# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, overload

from azure.core import AsyncPipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._utils.serialization import Deserializer, Serializer
from ...operations._favorites_operations import (
    build_add_request,
    build_delete_request,
    build_get_request,
    build_list_request,
    build_update_request,
)
from .._configuration import ApplicationInsightsManagementClientConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class FavoritesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.applicationinsights.aio.ApplicationInsightsManagementClient`'s
        :attr:`favorites` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: ApplicationInsightsManagementClientConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def list(
        self,
        resource_group_name: str,
        resource_name: str,
        favorite_type: Optional[Union[str, _models.FavoriteType]] = None,
        source_type: Optional[Union[str, _models.FavoriteSourceType]] = None,
        can_fetch_content: Optional[bool] = None,
        tags: Optional[List[str]] = None,
        **kwargs: Any
    ) -> List[_models.ApplicationInsightsComponentFavorite]:
        """Gets a list of favorites defined within an Application Insights component.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_name: The name of the Application Insights component resource. Required.
        :type resource_name: str
        :param favorite_type: The type of favorite. Value can be either shared or user. Known values
         are: "shared" and "user". Default value is None.
        :type favorite_type: str or ~azure.mgmt.applicationinsights.models.FavoriteType
        :param source_type: Source type of favorite to return. When left out, the source type defaults
         to 'other' (not present in this enum). Known values are: "retention", "notebook", "sessions",
         "events", "userflows", "funnel", "impact", and "segmentation". Default value is None.
        :type source_type: str or ~azure.mgmt.applicationinsights.models.FavoriteSourceType
        :param can_fetch_content: Flag indicating whether or not to return the full content for each
         applicable favorite. If false, only return summary content for favorites. Default value is
         None.
        :type can_fetch_content: bool
        :param tags: Tags that must be present on each favorite returned. Default value is None.
        :type tags: list[str]
        :return: list of ApplicationInsightsComponentFavorite or the result of cls(response)
        :rtype: list[~azure.mgmt.applicationinsights.models.ApplicationInsightsComponentFavorite]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2015-05-01"))
        cls: ClsType[List[_models.ApplicationInsightsComponentFavorite]] = kwargs.pop("cls", None)

        _request = build_list_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            subscription_id=self._config.subscription_id,
            favorite_type=favorite_type,
            source_type=source_type,
            can_fetch_content=can_fetch_content,
            tags=tags,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("[ApplicationInsightsComponentFavorite]", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, resource_name: str, favorite_id: str, **kwargs: Any
    ) -> _models.ApplicationInsightsComponentFavorite:
        """Get a single favorite by its FavoriteId, defined within an Application Insights component.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_name: The name of the Application Insights component resource. Required.
        :type resource_name: str
        :param favorite_id: The Id of a specific favorite defined in the Application Insights
         component. Required.
        :type favorite_id: str
        :return: ApplicationInsightsComponentFavorite or the result of cls(response)
        :rtype: ~azure.mgmt.applicationinsights.models.ApplicationInsightsComponentFavorite
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2015-05-01"))
        cls: ClsType[_models.ApplicationInsightsComponentFavorite] = kwargs.pop("cls", None)

        _request = build_get_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            favorite_id=favorite_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ApplicationInsightsComponentFavorite", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def add(
        self,
        resource_group_name: str,
        resource_name: str,
        favorite_id: str,
        favorite_properties: _models.ApplicationInsightsComponentFavorite,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ApplicationInsightsComponentFavorite:
        """Adds a new favorites to an Application Insights component.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_name: The name of the Application Insights component resource. Required.
        :type resource_name: str
        :param favorite_id: The Id of a specific favorite defined in the Application Insights
         component. Required.
        :type favorite_id: str
        :param favorite_properties: Properties that need to be specified to create a new favorite and
         add it to an Application Insights component. Required.
        :type favorite_properties:
         ~azure.mgmt.applicationinsights.models.ApplicationInsightsComponentFavorite
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ApplicationInsightsComponentFavorite or the result of cls(response)
        :rtype: ~azure.mgmt.applicationinsights.models.ApplicationInsightsComponentFavorite
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add(
        self,
        resource_group_name: str,
        resource_name: str,
        favorite_id: str,
        favorite_properties: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ApplicationInsightsComponentFavorite:
        """Adds a new favorites to an Application Insights component.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_name: The name of the Application Insights component resource. Required.
        :type resource_name: str
        :param favorite_id: The Id of a specific favorite defined in the Application Insights
         component. Required.
        :type favorite_id: str
        :param favorite_properties: Properties that need to be specified to create a new favorite and
         add it to an Application Insights component. Required.
        :type favorite_properties: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ApplicationInsightsComponentFavorite or the result of cls(response)
        :rtype: ~azure.mgmt.applicationinsights.models.ApplicationInsightsComponentFavorite
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add(
        self,
        resource_group_name: str,
        resource_name: str,
        favorite_id: str,
        favorite_properties: Union[_models.ApplicationInsightsComponentFavorite, IO[bytes]],
        **kwargs: Any
    ) -> _models.ApplicationInsightsComponentFavorite:
        """Adds a new favorites to an Application Insights component.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_name: The name of the Application Insights component resource. Required.
        :type resource_name: str
        :param favorite_id: The Id of a specific favorite defined in the Application Insights
         component. Required.
        :type favorite_id: str
        :param favorite_properties: Properties that need to be specified to create a new favorite and
         add it to an Application Insights component. Is either a ApplicationInsightsComponentFavorite
         type or a IO[bytes] type. Required.
        :type favorite_properties:
         ~azure.mgmt.applicationinsights.models.ApplicationInsightsComponentFavorite or IO[bytes]
        :return: ApplicationInsightsComponentFavorite or the result of cls(response)
        :rtype: ~azure.mgmt.applicationinsights.models.ApplicationInsightsComponentFavorite
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2015-05-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ApplicationInsightsComponentFavorite] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(favorite_properties, (IOBase, bytes)):
            _content = favorite_properties
        else:
            _json = self._serialize.body(favorite_properties, "ApplicationInsightsComponentFavorite")

        _request = build_add_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            favorite_id=favorite_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ApplicationInsightsComponentFavorite", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update(
        self,
        resource_group_name: str,
        resource_name: str,
        favorite_id: str,
        favorite_properties: _models.ApplicationInsightsComponentFavorite,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ApplicationInsightsComponentFavorite:
        """Updates a favorite that has already been added to an Application Insights component.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_name: The name of the Application Insights component resource. Required.
        :type resource_name: str
        :param favorite_id: The Id of a specific favorite defined in the Application Insights
         component. Required.
        :type favorite_id: str
        :param favorite_properties: Properties that need to be specified to update the existing
         favorite. Required.
        :type favorite_properties:
         ~azure.mgmt.applicationinsights.models.ApplicationInsightsComponentFavorite
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ApplicationInsightsComponentFavorite or the result of cls(response)
        :rtype: ~azure.mgmt.applicationinsights.models.ApplicationInsightsComponentFavorite
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        resource_name: str,
        favorite_id: str,
        favorite_properties: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ApplicationInsightsComponentFavorite:
        """Updates a favorite that has already been added to an Application Insights component.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_name: The name of the Application Insights component resource. Required.
        :type resource_name: str
        :param favorite_id: The Id of a specific favorite defined in the Application Insights
         component. Required.
        :type favorite_id: str
        :param favorite_properties: Properties that need to be specified to update the existing
         favorite. Required.
        :type favorite_properties: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ApplicationInsightsComponentFavorite or the result of cls(response)
        :rtype: ~azure.mgmt.applicationinsights.models.ApplicationInsightsComponentFavorite
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self,
        resource_group_name: str,
        resource_name: str,
        favorite_id: str,
        favorite_properties: Union[_models.ApplicationInsightsComponentFavorite, IO[bytes]],
        **kwargs: Any
    ) -> _models.ApplicationInsightsComponentFavorite:
        """Updates a favorite that has already been added to an Application Insights component.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_name: The name of the Application Insights component resource. Required.
        :type resource_name: str
        :param favorite_id: The Id of a specific favorite defined in the Application Insights
         component. Required.
        :type favorite_id: str
        :param favorite_properties: Properties that need to be specified to update the existing
         favorite. Is either a ApplicationInsightsComponentFavorite type or a IO[bytes] type. Required.
        :type favorite_properties:
         ~azure.mgmt.applicationinsights.models.ApplicationInsightsComponentFavorite or IO[bytes]
        :return: ApplicationInsightsComponentFavorite or the result of cls(response)
        :rtype: ~azure.mgmt.applicationinsights.models.ApplicationInsightsComponentFavorite
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2015-05-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ApplicationInsightsComponentFavorite] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(favorite_properties, (IOBase, bytes)):
            _content = favorite_properties
        else:
            _json = self._serialize.body(favorite_properties, "ApplicationInsightsComponentFavorite")

        _request = build_update_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            favorite_id=favorite_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ApplicationInsightsComponentFavorite", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete(self, resource_group_name: str, resource_name: str, favorite_id: str, **kwargs: Any) -> None:
        """Remove a favorite that is associated to an Application Insights component.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_name: The name of the Application Insights component resource. Required.
        :type resource_name: str
        :param favorite_id: The Id of a specific favorite defined in the Application Insights
         component. Required.
        :type favorite_id: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2015-05-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            favorite_id=favorite_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
