# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ReservationRecommendation(Model):
    """Reservation recommendation resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Resource location
    :vartype location: str
    :ivar sku: Resource sku
    :vartype sku: str
    :ivar look_back_period: The number of days of usage to look back for
     recommendation.
    :vartype look_back_period: str
    :ivar meter_id: The meter id (GUID)
    :vartype meter_id: str
    :ivar term: RI recommendations in one or three year terms.
    :vartype term: str
    :ivar cost_with_no_reserved_instances: The total amount of cost without
     reserved instances.
    :vartype cost_with_no_reserved_instances: decimal.Decimal
    :ivar recommended_quantity: Recommended quality for reserved instances.
    :vartype recommended_quantity: decimal.Decimal
    :ivar total_cost_with_reserved_instances: The total amount of cost with
     reserved instances.
    :vartype total_cost_with_reserved_instances: decimal.Decimal
    :ivar net_savings: Total estimated savings with reserved instances.
    :vartype net_savings: decimal.Decimal
    :ivar first_usage_date: The usage date for looking back.
    :vartype first_usage_date: datetime
    :ivar scope: Shared or single recommendation.
    :vartype scope: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'location': {'readonly': True},
        'sku': {'readonly': True},
        'look_back_period': {'readonly': True},
        'meter_id': {'readonly': True},
        'term': {'readonly': True},
        'cost_with_no_reserved_instances': {'readonly': True},
        'recommended_quantity': {'readonly': True},
        'total_cost_with_reserved_instances': {'readonly': True},
        'net_savings': {'readonly': True},
        'first_usage_date': {'readonly': True},
        'scope': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'look_back_period': {'key': 'properties.lookBackPeriod', 'type': 'str'},
        'meter_id': {'key': 'properties.meterId', 'type': 'str'},
        'term': {'key': 'properties.term', 'type': 'str'},
        'cost_with_no_reserved_instances': {'key': 'properties.costWithNoReservedInstances', 'type': 'decimal'},
        'recommended_quantity': {'key': 'properties.recommendedQuantity', 'type': 'decimal'},
        'total_cost_with_reserved_instances': {'key': 'properties.totalCostWithReservedInstances', 'type': 'decimal'},
        'net_savings': {'key': 'properties.netSavings', 'type': 'decimal'},
        'first_usage_date': {'key': 'properties.firstUsageDate', 'type': 'iso-8601'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ReservationRecommendation, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.tags = None
        self.location = None
        self.sku = None
        self.look_back_period = None
        self.meter_id = None
        self.term = None
        self.cost_with_no_reserved_instances = None
        self.recommended_quantity = None
        self.total_cost_with_reserved_instances = None
        self.net_savings = None
        self.first_usage_date = None
        self.scope = None
