# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class TagDescriptionContract(Resource):
    """Contract details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param description: Description of the Tag.
    :type description: str
    :param external_docs_url: Absolute URL of external resources describing
     the tag.
    :type external_docs_url: str
    :param external_docs_description: Description of the external resources
     describing the tag.
    :type external_docs_description: str
    :param display_name: Tag name.
    :type display_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'external_docs_url': {'max_length': 2000},
        'display_name': {'max_length': 160, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'external_docs_url': {'key': 'properties.externalDocsUrl', 'type': 'str'},
        'external_docs_description': {'key': 'properties.externalDocsDescription', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TagDescriptionContract, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.external_docs_url = kwargs.get('external_docs_url', None)
        self.external_docs_description = kwargs.get('external_docs_description', None)
        self.display_name = kwargs.get('display_name', None)
