# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CheckNameAvailabilityRequest(Model):
    """A request to check whether the specified name for a resource is available.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param name: The name whose availability is to be checked.
    :type name: str
    :ivar type: The type of resource that is used as the scope of the
     availability check. Default value: "Microsoft.Sql/servers" .
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Sql/servers"

    def __init__(self, name):
        self.name = name
