// clang-format off
/*
 * Copyright (c) 2020, 2024, Oracle and/or its affiliates.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2.0,
 * as published by the Free Software Foundation.
 *
 * This program is designed to work with certain software (including
 * but not limited to OpenSSL) that is licensed under separate terms,
 * as designated in a particular file or component or in included license
 * documentation.  The authors of MySQL hereby grant you an additional
 * permission to link the program and your derivative works with the
 * separately licensed software that they have either included with
 * the program or referenced in the documentation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
 * the GNU General Public License, version 2.0, for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */




// Generated from /home/paandrus/dev/ngshell/mysqlshdk/libs/parser/grammars/MySQLParser.g4 by ANTLR 4.10.1


#include "MySQLParserListener.h"
#include "MySQLParserVisitor.h"

#include "MySQLParser.h"

#include "mysqlshdk/libs/parser/MySQLBaseRecognizer.h"

using namespace antlrcpp;
using namespace parsers;

using namespace antlr4;

namespace {

struct MySQLParserStaticData final {
  MySQLParserStaticData(std::vector<std::string> ruleNames,
                        std::vector<std::string> literalNames,
                        std::vector<std::string> symbolicNames)
      : ruleNames(std::move(ruleNames)), literalNames(std::move(literalNames)),
        symbolicNames(std::move(symbolicNames)),
        vocabulary(this->literalNames, this->symbolicNames) {}

  MySQLParserStaticData(const MySQLParserStaticData&) = delete;
  MySQLParserStaticData(MySQLParserStaticData&&) = delete;
  MySQLParserStaticData& operator=(const MySQLParserStaticData&) = delete;
  MySQLParserStaticData& operator=(MySQLParserStaticData&&) = delete;

  std::vector<antlr4::dfa::DFA> decisionToDFA;
  antlr4::atn::PredictionContextCache sharedContextCache;
  const std::vector<std::string> ruleNames;
  const std::vector<std::string> literalNames;
  const std::vector<std::string> symbolicNames;
  const antlr4::dfa::Vocabulary vocabulary;
  antlr4::atn::SerializedATNView serializedATN;
  std::unique_ptr<antlr4::atn::ATN> atn;
};

std::once_flag mysqlparserParserOnceFlag;
MySQLParserStaticData *mysqlparserParserStaticData = nullptr;

void mysqlparserParserInitialize() {
  assert(mysqlparserParserStaticData == nullptr);
  auto staticData = std::make_unique<MySQLParserStaticData>(
    std::vector<std::string>{
      "query", "simpleStatement", "alterStatement", "alterDatabase", "alterDatabaseOption", 
      "alterEvent", "alterLogfileGroup", "alterLogfileGroupOptions", "alterLogfileGroupOption", 
      "alterServer", "alterTable", "alterTableActions", "alterCommandList", 
      "alterCommandsModifierList", "standaloneAlterCommands", "alterPartition", 
      "alterList", "alterCommandsModifier", "alterListItem", "place", "restrict", 
      "alterOrderList", "alterAlgorithmOption", "alterLockOption", "indexLockAndAlgorithm", 
      "withValidation", "removePartitioning", "allOrPartitionNameList", 
      "alterTablespace", "alterUndoTablespace", "undoTableSpaceOptions", 
      "undoTableSpaceOption", "alterTablespaceOptions", "alterTablespaceOption", 
      "changeTablespaceOption", "alterView", "viewTail", "viewQueryBlock", 
      "viewCheckOption", "alterInstanceStatement", "createStatement", "createDatabase", 
      "createDatabaseOption", "createTable", "tableElementList", "tableElement", 
      "duplicateAsQe", "asCreateQueryExpression", "queryExpressionOrParens", 
      "queryExpressionWithOptLockingClauses", "createRoutine", "createProcedure", 
      "routineString", "storedRoutineBody", "createFunction", "createUdf", 
      "routineCreateOption", "routineAlterOptions", "routineOption", "createIndex", 
      "indexNameAndType", "createIndexTarget", "createLogfileGroup", "logfileGroupOptions", 
      "logfileGroupOption", "createServer", "serverOptions", "serverOption", 
      "createTablespace", "createUndoTablespace", "tsDataFileName", "tsDataFile", 
      "tablespaceOptions", "tablespaceOption", "tsOptionInitialSize", "tsOptionUndoRedoBufferSize", 
      "tsOptionAutoextendSize", "tsOptionMaxSize", "tsOptionExtentSize", 
      "tsOptionNodegroup", "tsOptionEngine", "tsOptionWait", "tsOptionComment", 
      "tsOptionFileblockSize", "tsOptionEncryption", "tsOptionEngineAttribute", 
      "createView", "viewReplaceOrAlgorithm", "viewAlgorithm", "viewSuid", 
      "createTrigger", "triggerFollowsPrecedesClause", "createEvent", "createRole", 
      "createSpatialReference", "srsAttribute", "dropStatement", "dropDatabase", 
      "dropEvent", "dropFunction", "dropProcedure", "dropIndex", "dropLogfileGroup", 
      "dropLogfileGroupOption", "dropServer", "dropTable", "dropTableSpace", 
      "dropTrigger", "dropView", "dropRole", "dropSpatialReference", "dropUndoTablespace", 
      "renameTableStatement", "renamePair", "truncateTableStatement", "importStatement", 
      "callStatement", "deleteStatement", "partitionDelete", "deleteStatementOption", 
      "doStatement", "handlerStatement", "handlerReadOrScan", "insertStatement", 
      "insertLockOption", "insertFromConstructor", "fields", "insertValues", 
      "insertQueryExpression", "valueList", "values", "valuesReference", 
      "insertUpdateList", "loadStatement", "dataOrXml", "loadDataLock", 
      "loadFrom", "loadSourceType", "sourceCount", "sourceOrder", "xmlRowsIdentifiedBy", 
      "loadDataFileTail", "loadDataFileTargetList", "fieldOrVariableList", 
      "loadAlgorithm", "loadParallel", "loadMemory", "replaceStatement", 
      "selectStatement", "selectStatementWithInto", "queryExpression", "queryExpressionBody", 
      "queryExpressionParens", "queryPrimary", "querySpecification", "subquery", 
      "querySpecOption", "limitClause", "simpleLimitClause", "limitOptions", 
      "limitOption", "intoClause", "procedureAnalyseClause", "havingClause", 
      "qualifyClause", "windowClause", "windowDefinition", "windowSpec", 
      "windowSpecDetails", "windowFrameClause", "windowFrameUnits", "windowFrameExtent", 
      "windowFrameStart", "windowFrameBetween", "windowFrameBound", "windowFrameExclusion", 
      "withClause", "commonTableExpression", "groupByClause", "olapOption", 
      "orderClause", "direction", "fromClause", "tableReferenceList", "tableValueConstructor", 
      "explicitTable", "rowValueExplicit", "selectOption", "lockingClauseList", 
      "lockingClause", "lockStrengh", "lockedRowAction", "selectItemList", 
      "selectItem", "selectAlias", "whereClause", "tableReference", "escapedTableReference", 
      "joinedTable", "naturalJoinType", "innerJoinType", "outerJoinType", 
      "tableFactor", "singleTable", "singleTableParens", "derivedTable", 
      "tableReferenceListParens", "tableFunction", "columnsClause", "jtColumn", 
      "onEmptyOrError", "onEmptyOrErrorJsonTable", "onEmpty", "onError", 
      "jsonOnResponse", "unionOption", "tableAlias", "indexHintList", "indexHint", 
      "indexHintType", "keyOrIndex", "constraintKeyType", "indexHintClause", 
      "indexList", "indexListElement", "updateStatement", "transactionOrLockingStatement", 
      "transactionStatement", "beginWork", "startTransactionOptionList", 
      "savepointStatement", "lockStatement", "lockItem", "lockOption", "xaStatement", 
      "xaConvert", "xid", "replicationStatement", "purgeOptions", "resetOption", 
      "masterOrBinaryLogsAndGtids", "sourceResetOptions", "replicationLoad", 
      "changeReplicationSource", "changeSource", "sourceDefinitions", "sourceDefinition", 
      "changeReplicationSourceAutoPosition", "changeReplicationSourceHost", 
      "changeReplicationSourceBind", "changeReplicationSourceUser", "changeReplicationSourcePassword", 
      "changeReplicationSourcePort", "changeReplicationSourceConnectRetry", 
      "changeReplicationSourceRetryCount", "changeReplicationSourceDelay", 
      "changeReplicationSourceSSL", "changeReplicationSourceSSLCA", "changeReplicationSourceSSLCApath", 
      "changeReplicationSourceSSLCipher", "changeReplicationSourceSSLCLR", 
      "changeReplicationSourceSSLCLRpath", "changeReplicationSourceSSLKey", 
      "changeReplicationSourceSSLVerifyServerCert", "changeReplicationSourceTLSVersion", 
      "changeReplicationSourceTLSCiphersuites", "changeReplicationSourceSSLCert", 
      "changeReplicationSourcePublicKey", "changeReplicationSourceGetSourcePublicKey", 
      "changeReplicationSourceHeartbeatPeriod", "changeReplicationSourceCompressionAlgorithm", 
      "changeReplicationSourceZstdCompressionLevel", "privilegeCheckDef", 
      "tablePrimaryKeyCheckDef", "assignGtidsToAnonymousTransactionsDefinition", 
      "sourceTlsCiphersuitesDef", "sourceFileDef", "sourceLogFile", "sourceLogPos", 
      "serverIdList", "changeReplication", "filterDefinition", "filterDbList", 
      "filterTableList", "filterStringList", "filterWildDbTableString", 
      "filterDbPairList", "startReplicaStatement", "stopReplicaStatement", 
      "replicaUntil", "userOption", "passwordOption", "defaultAuthOption", 
      "pluginDirOption", "replicaThreadOptions", "replicaThreadOption", 
      "groupReplication", "groupReplicationStartOptions", "groupReplicationStartOption", 
      "groupReplicationUser", "groupReplicationPassword", "groupReplicationPluginAuth", 
      "replica", "preparedStatement", "executeStatement", "executeVarList", 
      "cloneStatement", "dataDirSSL", "ssl", "accountManagementStatement", 
      "alterUserStatement", "alterUserList", "alterUser", "oldAlterUser", 
      "userFunction", "createUserStatement", "createUserTail", "userAttributes", 
      "defaultRoleClause", "requireClause", "connectOptions", "accountLockPasswordExpireOptions", 
      "dropUserStatement", "grantStatement", "grantTargetList", "grantOptions", 
      "exceptRoleList", "withRoles", "grantAs", "versionedRequireClause", 
      "renameUserStatement", "revokeStatement", "aclType", "roleOrPrivilegesList", 
      "roleOrPrivilege", "grantIdentifier", "requireList", "requireListElement", 
      "grantOption", "setRoleStatement", "roleList", "role", "tableAdministrationStatement", 
      "histogramAutoUpdate", "histogramUpdateParam", "histogramNumBuckets", 
      "histogram", "checkOption", "repairType", "uninstallStatement", "installStatement", 
      "installOptionType", "installSetRvalue", "installSetValue", "installSetValueList", 
      "setStatement", "startOptionValueList", "transactionCharacteristics", 
      "transactionAccessMode", "isolationLevel", "optionValueListContinued", 
      "optionValueNoOptionType", "optionValue", "startOptionValueListFollowingOptionType", 
      "optionValueFollowingOptionType", "setExprOrDefault", "showDatabasesStatement", 
      "showTablesStatement", "showTriggersStatement", "showEventsStatement", 
      "showTableStatusStatement", "showOpenTablesStatement", "showParseTreeStatement", 
      "showPluginsStatement", "showEngineLogsStatement", "showEngineMutexStatement", 
      "showEngineStatusStatement", "showColumnsStatement", "showBinaryLogsStatement", 
      "showBinaryLogStatusStatement", "showReplicasStatement", "showBinlogEventsStatement", 
      "showRelaylogEventsStatement", "showKeysStatement", "showEnginesStatement", 
      "showCountWarningsStatement", "showCountErrorsStatement", "showWarningsStatement", 
      "showErrorsStatement", "showProfilesStatement", "showProfileStatement", 
      "showStatusStatement", "showProcessListStatement", "showVariablesStatement", 
      "showCharacterSetStatement", "showCollationStatement", "showPrivilegesStatement", 
      "showGrantsStatement", "showCreateDatabaseStatement", "showCreateTableStatement", 
      "showCreateViewStatement", "showMasterStatusStatement", "showReplicaStatusStatement", 
      "showCreateProcedureStatement", "showCreateFunctionStatement", "showCreateTriggerStatement", 
      "showCreateProcedureStatusStatement", "showCreateFunctionStatusStatement", 
      "showCreateProcedureCodeStatement", "showCreateFunctionCodeStatement", 
      "showCreateEventStatement", "showCreateUserStatement", "showCommandType", 
      "engineOrAll", "fromOrIn", "inDb", "profileDefinitions", "profileDefinition", 
      "otherAdministrativeStatement", "keyCacheListOrParts", "keyCacheList", 
      "assignToKeycache", "assignToKeycachePartition", "cacheKeyList", "keyUsageElement", 
      "keyUsageList", "flushOption", "logType", "flushTables", "flushTablesOptions", 
      "preloadTail", "preloadList", "preloadKeys", "adminPartition", "resourceGroupManagement", 
      "createResourceGroup", "resourceGroupVcpuList", "vcpuNumOrRange", 
      "resourceGroupPriority", "resourceGroupEnableDisable", "alterResourceGroup", 
      "setResourceGroup", "threadIdList", "dropResourceGroup", "utilityStatement", 
      "describeStatement", "explainStatement", "explainOptions", "explainableStatement", 
      "explainInto", "helpCommand", "useCommand", "restartServer", "expr", 
      "boolPri", "compOp", "predicate", "predicateOperations", "bitExpr", 
      "simpleExpr", "arrayCast", "jsonOperator", "sumExpr", "groupingOperation", 
      "windowFunctionCall", "samplingMethod", "samplingPercentage", "tablesampleClause", 
      "windowingClause", "leadLagInfo", "stableInteger", "paramOrVar", "nullTreatment", 
      "jsonFunction", "inSumExpr", "identListArg", "identList", "fulltextOptions", 
      "runtimeFunctionCall", "returningType", "geometryFunction", "timeFunctionParameters", 
      "fractionalPrecision", "weightStringLevels", "weightStringLevelListItem", 
      "dateTimeTtype", "trimFunction", "substringFunction", "functionCall", 
      "udfExprList", "udfExpr", "userVariable", "userVariableIdentifier", 
      "inExpressionUserVariableAssignment", "rvalueSystemOrUserVariable", 
      "lvalueVariable", "rvalueSystemVariable", "whenExpression", "thenExpression", 
      "elseExpression", "castType", "exprList", "charset", "notRule", "not2Rule", 
      "interval", "intervalTimeStamp", "exprListWithParentheses", "exprWithParentheses", 
      "simpleExprWithParentheses", "orderList", "orderExpression", "groupList", 
      "groupingExpression", "channel", "compoundStatement", "returnStatement", 
      "ifStatement", "ifBody", "thenStatement", "compoundStatementList", 
      "caseStatement", "elseStatement", "labeledBlock", "unlabeledBlock", 
      "label", "beginEndBlock", "labeledControl", "unlabeledControl", "loopBlock", 
      "whileDoBlock", "repeatUntilBlock", "spDeclarations", "spDeclaration", 
      "variableDeclaration", "conditionDeclaration", "spCondition", "sqlstate", 
      "handlerDeclaration", "handlerCondition", "cursorDeclaration", "iterateStatement", 
      "leaveStatement", "getDiagnosticsStatement", "signalAllowedExpr", 
      "statementInformationItem", "conditionInformationItem", "signalInformationItemName", 
      "signalStatement", "resignalStatement", "signalInformationItem", "cursorOpen", 
      "cursorClose", "cursorFetch", "schedule", "columnDefinition", "checkOrReferences", 
      "checkConstraint", "constraintEnforcement", "tableConstraintDef", 
      "constraintName", "fieldDefinition", "columnAttribute", "columnFormat", 
      "storageMedia", "now", "nowOrSignedLiteral", "gcolAttribute", "references", 
      "deleteOption", "keyList", "keyPart", "keyListWithExpression", "keyPartOrExpression", 
      "indexType", "indexOption", "commonIndexOption", "visibility", "indexTypeClause", 
      "fulltextIndexOption", "spatialIndexOption", "dataTypeDefinition", 
      "dataType", "nchar", "realType", "fieldLength", "fieldOptions", "charsetWithOptBinary", 
      "ascii", "unicode", "wsNumCodepoints", "typeDatetimePrecision", "functionDatetimePrecision", 
      "charsetName", "collationName", "createTableOptions", "createTableOptionsEtc", 
      "createPartitioningEtc", "createTableOptionsSpaceSeparated", "createTableOption", 
      "ternaryOption", "defaultCollation", "defaultEncryption", "defaultCharset", 
      "partitionClause", "partitionTypeDef", "subPartitions", "partitionKeyAlgorithm", 
      "partitionDefinitions", "partitionDefinition", "partitionValuesIn", 
      "partitionOption", "subpartitionDefinition", "partitionValueItemListParen", 
      "partitionValueItem", "definerClause", "ifExists", "ifExistsIdentifier", 
      "persistedVariableIdentifier", "ifNotExists", "ignoreUnknownUser", 
      "procedureParameter", "functionParameter", "collate", "typeWithOptCollate", 
      "schemaIdentifierPair", "viewRefList", "updateList", "updateElement", 
      "charsetClause", "fieldsClause", "fieldTerm", "linesClause", "lineTerm", 
      "userList", "createUserList", "createUser", "createUserWithMfa", "identification", 
      "identifiedByPassword", "identifiedByRandomPassword", "identifiedWithPlugin", 
      "identifiedWithPluginAsAuth", "identifiedWithPluginByPassword", "identifiedWithPluginByRandomPassword", 
      "initialAuth", "retainCurrentPassword", "discardOldPassword", "userRegistration", 
      "factor", "replacePassword", "userIdentifierOrText", "user", "likeClause", 
      "likeOrWhere", "onlineOption", "noWriteToBinLog", "usePartition", 
      "fieldIdentifier", "columnName", "columnInternalRef", "columnInternalRefList", 
      "columnRef", "insertIdentifier", "indexName", "indexRef", "tableWild", 
      "schemaName", "schemaRef", "procedureName", "procedureRef", "functionName", 
      "functionRef", "triggerName", "triggerRef", "viewName", "viewRef", 
      "tablespaceName", "tablespaceRef", "logfileGroupName", "logfileGroupRef", 
      "eventName", "eventRef", "udfName", "serverName", "serverRef", "engineRef", 
      "tableName", "filterTableRef", "tableRefWithWildcard", "tableRef", 
      "tableRefList", "tableAliasRefList", "parameterName", "labelIdentifier", 
      "labelRef", "roleIdentifier", "pluginRef", "componentRef", "resourceGroupRef", 
      "windowName", "pureIdentifier", "identifier", "identifierList", "identifierListWithParentheses", 
      "qualifiedIdentifier", "simpleIdentifier", "dotIdentifier", "ulong_number", 
      "real_ulong_number", "ulonglongNumber", "real_ulonglong_number", "signedLiteral", 
      "signedLiteralOrNull", "literal", "literalOrNull", "nullAsLiteral", 
      "stringList", "textStringLiteral", "textString", "textStringHash", 
      "textLiteral", "textStringNoLinebreak", "textStringLiteralList", "numLiteral", 
      "boolLiteral", "nullLiteral", "int64Literal", "temporalLiteral", "floatOptions", 
      "standardFloatOptions", "precision", "textOrIdentifier", "lValueIdentifier", 
      "roleIdentifierOrText", "sizeNumber", "parentheses", "equal", "optionType", 
      "rvalueSystemVariableType", "setVarIdentType", "jsonAttribute", "identifierKeyword", 
      "identifierKeywordsAmbiguous1RolesAndLabels", "identifierKeywordsAmbiguous2Labels", 
      "labelKeyword", "identifierKeywordsAmbiguous3Roles", "identifierKeywordsUnambiguous", 
      "roleKeyword", "lValueKeyword", "identifierKeywordsAmbiguous4SystemVariables", 
      "roleOrIdentifierKeyword", "roleOrLabelKeyword"
    },
    std::vector<std::string>{
      "", "", "", "", "", "", "'='", "':='", "'<=>'", "'>='", "'>'", "'<='", 
      "'<'", "'!='", "'+'", "'-'", "'*'", "'/'", "'%'", "'!'", "'~'", "'<<'", 
      "'>>'", "'&&'", "'&'", "'^'", "'||'", "'|'", "'.'", "','", "';'", 
      "':'", "'('", "')'", "'{'", "'}'", "'_'", "'->'", "'->>'", "'@'", 
      "", "'\\N'", "'\\u003F'", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "'<>'"
    },
    std::vector<std::string>{
      "", "NOT2_SYMBOL", "CONCAT_PIPES_SYMBOL", "INT_NUMBER", "LONG_NUMBER", 
      "ULONGLONG_NUMBER", "EQUAL_OPERATOR", "ASSIGN_OPERATOR", "NULL_SAFE_EQUAL_OPERATOR", 
      "GREATER_OR_EQUAL_OPERATOR", "GREATER_THAN_OPERATOR", "LESS_OR_EQUAL_OPERATOR", 
      "LESS_THAN_OPERATOR", "NOT_EQUAL_OPERATOR", "PLUS_OPERATOR", "MINUS_OPERATOR", 
      "MULT_OPERATOR", "DIV_OPERATOR", "MOD_OPERATOR", "LOGICAL_NOT_OPERATOR", 
      "BITWISE_NOT_OPERATOR", "SHIFT_LEFT_OPERATOR", "SHIFT_RIGHT_OPERATOR", 
      "LOGICAL_AND_OPERATOR", "BITWISE_AND_OPERATOR", "BITWISE_XOR_OPERATOR", 
      "LOGICAL_OR_OPERATOR", "BITWISE_OR_OPERATOR", "DOT_SYMBOL", "COMMA_SYMBOL", 
      "SEMICOLON_SYMBOL", "COLON_SYMBOL", "OPEN_PAR_SYMBOL", "CLOSE_PAR_SYMBOL", 
      "OPEN_CURLY_SYMBOL", "CLOSE_CURLY_SYMBOL", "UNDERLINE_SYMBOL", "JSON_SEPARATOR_SYMBOL", 
      "JSON_UNQUOTED_SEPARATOR_SYMBOL", "AT_SIGN_SYMBOL", "AT_AT_SIGN_SYMBOL", 
      "NULL2_SYMBOL", "PARAM_MARKER", "HEX_NUMBER", "BIN_NUMBER", "DECIMAL_NUMBER", 
      "FLOAT_NUMBER", "ACCESSIBLE_SYMBOL", "ACCOUNT_SYMBOL", "ACTION_SYMBOL", 
      "ADD_SYMBOL", "ADDDATE_SYMBOL", "AFTER_SYMBOL", "AGAINST_SYMBOL", 
      "AGGREGATE_SYMBOL", "ALGORITHM_SYMBOL", "ALL_SYMBOL", "ALTER_SYMBOL", 
      "ALWAYS_SYMBOL", "ANALYSE_SYMBOL", "ANALYZE_SYMBOL", "AND_SYMBOL", 
      "ANY_SYMBOL", "AS_SYMBOL", "ASC_SYMBOL", "ASCII_SYMBOL", "ASENSITIVE_SYMBOL", 
      "AT_SYMBOL", "AUTOEXTEND_SIZE_SYMBOL", "AUTO_INCREMENT_SYMBOL", "AVG_ROW_LENGTH_SYMBOL", 
      "AVG_SYMBOL", "BACKUP_SYMBOL", "BEFORE_SYMBOL", "BEGIN_SYMBOL", "BETWEEN_SYMBOL", 
      "BIGINT_SYMBOL", "BINARY_SYMBOL", "BINLOG_SYMBOL", "BIN_NUM_SYMBOL", 
      "BIT_AND_SYMBOL", "BIT_OR_SYMBOL", "BIT_SYMBOL", "BIT_XOR_SYMBOL", 
      "BLOB_SYMBOL", "BLOCK_SYMBOL", "BOOLEAN_SYMBOL", "BOOL_SYMBOL", "BOTH_SYMBOL", 
      "BTREE_SYMBOL", "BY_SYMBOL", "BYTE_SYMBOL", "CACHE_SYMBOL", "CALL_SYMBOL", 
      "CASCADE_SYMBOL", "CASCADED_SYMBOL", "CASE_SYMBOL", "CAST_SYMBOL", 
      "CATALOG_NAME_SYMBOL", "CHAIN_SYMBOL", "CHANGE_SYMBOL", "CHANGED_SYMBOL", 
      "CHANNEL_SYMBOL", "CHARSET_SYMBOL", "CHAR_SYMBOL", "CHECKSUM_SYMBOL", 
      "CHECK_SYMBOL", "CIPHER_SYMBOL", "CLASS_ORIGIN_SYMBOL", "CLIENT_SYMBOL", 
      "CLOSE_SYMBOL", "COALESCE_SYMBOL", "CODE_SYMBOL", "COLLATE_SYMBOL", 
      "COLLATION_SYMBOL", "COLUMNS_SYMBOL", "COLUMN_SYMBOL", "COLUMN_NAME_SYMBOL", 
      "COLUMN_FORMAT_SYMBOL", "COMMENT_SYMBOL", "COMMITTED_SYMBOL", "COMMIT_SYMBOL", 
      "COMPACT_SYMBOL", "COMPLETION_SYMBOL", "COMPRESSED_SYMBOL", "COMPRESSION_SYMBOL", 
      "CONCURRENT_SYMBOL", "CONDITION_SYMBOL", "CONNECTION_SYMBOL", "CONSISTENT_SYMBOL", 
      "CONSTRAINT_SYMBOL", "CONSTRAINT_CATALOG_SYMBOL", "CONSTRAINT_NAME_SYMBOL", 
      "CONSTRAINT_SCHEMA_SYMBOL", "CONTAINS_SYMBOL", "CONTEXT_SYMBOL", "CONTINUE_SYMBOL", 
      "CONVERT_SYMBOL", "COUNT_SYMBOL", "CPU_SYMBOL", "CREATE_SYMBOL", "CROSS_SYMBOL", 
      "CUBE_SYMBOL", "CURDATE_SYMBOL", "CURRENT_SYMBOL", "CURRENT_DATE_SYMBOL", 
      "CURRENT_TIME_SYMBOL", "CURRENT_USER_SYMBOL", "CURSOR_SYMBOL", "CURSOR_NAME_SYMBOL", 
      "CURTIME_SYMBOL", "DATABASE_SYMBOL", "DATABASES_SYMBOL", "DATAFILE_SYMBOL", 
      "DATA_SYMBOL", "DATETIME_SYMBOL", "DATE_ADD_SYMBOL", "DATE_SUB_SYMBOL", 
      "DATE_SYMBOL", "DAY_HOUR_SYMBOL", "DAY_MICROSECOND_SYMBOL", "DAY_MINUTE_SYMBOL", 
      "DAY_SECOND_SYMBOL", "DAY_SYMBOL", "DEALLOCATE_SYMBOL", "DECIMAL_NUM_SYMBOL", 
      "DECIMAL_SYMBOL", "DECLARE_SYMBOL", "DEFAULT_SYMBOL", "DEFAULT_AUTH_SYMBOL", 
      "DEFINER_SYMBOL", "DELAYED_SYMBOL", "DELAY_KEY_WRITE_SYMBOL", "DELETE_SYMBOL", 
      "DESC_SYMBOL", "DESCRIBE_SYMBOL", "DES_KEY_FILE_SYMBOL", "DETERMINISTIC_SYMBOL", 
      "DIAGNOSTICS_SYMBOL", "DIRECTORY_SYMBOL", "DISABLE_SYMBOL", "DISCARD_SYMBOL", 
      "DISK_SYMBOL", "DISTINCT_SYMBOL", "DIV_SYMBOL", "DOUBLE_SYMBOL", "DO_SYMBOL", 
      "DROP_SYMBOL", "DUAL_SYMBOL", "DUMPFILE_SYMBOL", "DUPLICATE_SYMBOL", 
      "DYNAMIC_SYMBOL", "EACH_SYMBOL", "ELSE_SYMBOL", "ELSEIF_SYMBOL", "ENABLE_SYMBOL", 
      "ENCLOSED_SYMBOL", "ENCRYPTION_SYMBOL", "END_SYMBOL", "ENDS_SYMBOL", 
      "END_OF_INPUT_SYMBOL", "ENGINES_SYMBOL", "ENGINE_SYMBOL", "ENUM_SYMBOL", 
      "ERROR_SYMBOL", "ERRORS_SYMBOL", "ESCAPED_SYMBOL", "ESCAPE_SYMBOL", 
      "EVENTS_SYMBOL", "EVENT_SYMBOL", "EVERY_SYMBOL", "EXCHANGE_SYMBOL", 
      "EXECUTE_SYMBOL", "EXISTS_SYMBOL", "EXIT_SYMBOL", "EXPANSION_SYMBOL", 
      "EXPIRE_SYMBOL", "EXPLAIN_SYMBOL", "EXPORT_SYMBOL", "EXTENDED_SYMBOL", 
      "EXTENT_SIZE_SYMBOL", "EXTRACT_SYMBOL", "FALSE_SYMBOL", "FAST_SYMBOL", 
      "FAULTS_SYMBOL", "FETCH_SYMBOL", "FILE_SYMBOL", "FILE_BLOCK_SIZE_SYMBOL", 
      "FILTER_SYMBOL", "FIRST_SYMBOL", "FIXED_SYMBOL", "FLOAT_SYMBOL", "FLUSH_SYMBOL", 
      "FOLLOWS_SYMBOL", "FORCE_SYMBOL", "FOREIGN_SYMBOL", "FOR_SYMBOL", 
      "FORMAT_SYMBOL", "FOUND_SYMBOL", "FROM_SYMBOL", "FULL_SYMBOL", "FULLTEXT_SYMBOL", 
      "FUNCTION_SYMBOL", "GET_SYMBOL", "GENERAL_SYMBOL", "GENERATED_SYMBOL", 
      "GROUP_REPLICATION_SYMBOL", "GEOMETRYCOLLECTION_SYMBOL", "GEOMETRY_SYMBOL", 
      "GET_FORMAT_SYMBOL", "GLOBAL_SYMBOL", "GRANT_SYMBOL", "GRANTS_SYMBOL", 
      "GROUP_SYMBOL", "GROUP_CONCAT_SYMBOL", "HANDLER_SYMBOL", "HASH_SYMBOL", 
      "HAVING_SYMBOL", "HELP_SYMBOL", "HIGH_PRIORITY_SYMBOL", "HOST_SYMBOL", 
      "HOSTS_SYMBOL", "HOUR_MICROSECOND_SYMBOL", "HOUR_MINUTE_SYMBOL", "HOUR_SECOND_SYMBOL", 
      "HOUR_SYMBOL", "IDENTIFIED_SYMBOL", "IF_SYMBOL", "IGNORE_SYMBOL", 
      "IGNORE_SERVER_IDS_SYMBOL", "IMPORT_SYMBOL", "INDEXES_SYMBOL", "INDEX_SYMBOL", 
      "INFILE_SYMBOL", "INITIAL_SIZE_SYMBOL", "INNER_SYMBOL", "INOUT_SYMBOL", 
      "INSENSITIVE_SYMBOL", "INSERT_SYMBOL", "INSERT_METHOD_SYMBOL", "INSTANCE_SYMBOL", 
      "INSTALL_SYMBOL", "INTERVAL_SYMBOL", "INTO_SYMBOL", "INT_SYMBOL", 
      "INVOKER_SYMBOL", "IN_SYMBOL", "IO_AFTER_GTIDS_SYMBOL", "IO_BEFORE_GTIDS_SYMBOL", 
      "IO_SYMBOL", "IPC_SYMBOL", "IS_SYMBOL", "ISOLATION_SYMBOL", "ISSUER_SYMBOL", 
      "ITERATE_SYMBOL", "JOIN_SYMBOL", "JSON_SYMBOL", "KEYS_SYMBOL", "KEY_BLOCK_SIZE_SYMBOL", 
      "KEY_SYMBOL", "KILL_SYMBOL", "LANGUAGE_SYMBOL", "LAST_SYMBOL", "LEADING_SYMBOL", 
      "LEAVES_SYMBOL", "LEAVE_SYMBOL", "LEFT_SYMBOL", "LESS_SYMBOL", "LEVEL_SYMBOL", 
      "LIKE_SYMBOL", "LIMIT_SYMBOL", "LINEAR_SYMBOL", "LINES_SYMBOL", "LINESTRING_SYMBOL", 
      "LIST_SYMBOL", "LOAD_SYMBOL", "LOCAL_SYMBOL", "LOCATOR_SYMBOL", "LOCKS_SYMBOL", 
      "LOCK_SYMBOL", "LOGFILE_SYMBOL", "LOGS_SYMBOL", "LONGBLOB_SYMBOL", 
      "LONGTEXT_SYMBOL", "LONG_NUM_SYMBOL", "LONG_SYMBOL", "LOOP_SYMBOL", 
      "LOW_PRIORITY_SYMBOL", "MASTER_AUTO_POSITION_SYMBOL", "MASTER_BIND_SYMBOL", 
      "MASTER_CONNECT_RETRY_SYMBOL", "MASTER_DELAY_SYMBOL", "MASTER_HOST_SYMBOL", 
      "MASTER_LOG_FILE_SYMBOL", "MASTER_LOG_POS_SYMBOL", "MASTER_PASSWORD_SYMBOL", 
      "MASTER_PORT_SYMBOL", "MASTER_RETRY_COUNT_SYMBOL", "MASTER_SERVER_ID_SYMBOL", 
      "MASTER_SSL_CAPATH_SYMBOL", "MASTER_SSL_CA_SYMBOL", "MASTER_SSL_CERT_SYMBOL", 
      "MASTER_SSL_CIPHER_SYMBOL", "MASTER_SSL_CRL_SYMBOL", "MASTER_SSL_CRLPATH_SYMBOL", 
      "MASTER_SSL_KEY_SYMBOL", "MASTER_SSL_SYMBOL", "MASTER_SSL_VERIFY_SERVER_CERT_SYMBOL", 
      "MASTER_SYMBOL", "MASTER_TLS_VERSION_SYMBOL", "MASTER_USER_SYMBOL", 
      "MASTER_HEARTBEAT_PERIOD_SYMBOL", "MATCH_SYMBOL", "MAX_CONNECTIONS_PER_HOUR_SYMBOL", 
      "MAX_QUERIES_PER_HOUR_SYMBOL", "MAX_ROWS_SYMBOL", "MAX_SIZE_SYMBOL", 
      "MAX_STATEMENT_TIME_SYMBOL", "MAX_SYMBOL", "MAX_UPDATES_PER_HOUR_SYMBOL", 
      "MAX_USER_CONNECTIONS_SYMBOL", "MAXVALUE_SYMBOL", "MEDIUMBLOB_SYMBOL", 
      "MEDIUMINT_SYMBOL", "MEDIUMTEXT_SYMBOL", "MEDIUM_SYMBOL", "MEMORY_SYMBOL", 
      "MERGE_SYMBOL", "MESSAGE_TEXT_SYMBOL", "MICROSECOND_SYMBOL", "MID_SYMBOL", 
      "MIGRATE_SYMBOL", "MINUTE_MICROSECOND_SYMBOL", "MINUTE_SECOND_SYMBOL", 
      "MINUTE_SYMBOL", "MIN_ROWS_SYMBOL", "MIN_SYMBOL", "MODE_SYMBOL", "MODIFIES_SYMBOL", 
      "MODIFY_SYMBOL", "MOD_SYMBOL", "MONTH_SYMBOL", "MULTILINESTRING_SYMBOL", 
      "MULTIPOINT_SYMBOL", "MULTIPOLYGON_SYMBOL", "MUTEX_SYMBOL", "MYSQL_ERRNO_SYMBOL", 
      "NAMES_SYMBOL", "NAME_SYMBOL", "NATIONAL_SYMBOL", "NATURAL_SYMBOL", 
      "NCHAR_STRING_SYMBOL", "NCHAR_SYMBOL", "NDBCLUSTER_SYMBOL", "NEG_SYMBOL", 
      "NEVER_SYMBOL", "NEW_SYMBOL", "NEXT_SYMBOL", "NODEGROUP_SYMBOL", "NONE_SYMBOL", 
      "NONBLOCKING_SYMBOL", "NOT_SYMBOL", "NOW_SYMBOL", "NO_SYMBOL", "NO_WAIT_SYMBOL", 
      "NO_WRITE_TO_BINLOG_SYMBOL", "NULL_SYMBOL", "NUMBER_SYMBOL", "NUMERIC_SYMBOL", 
      "NVARCHAR_SYMBOL", "OFFLINE_SYMBOL", "OFFSET_SYMBOL", "OLD_PASSWORD_SYMBOL", 
      "ON_SYMBOL", "ONE_SYMBOL", "ONLINE_SYMBOL", "ONLY_SYMBOL", "OPEN_SYMBOL", 
      "OPTIMIZE_SYMBOL", "OPTIMIZER_COSTS_SYMBOL", "OPTIONS_SYMBOL", "OPTION_SYMBOL", 
      "OPTIONALLY_SYMBOL", "ORDER_SYMBOL", "OR_SYMBOL", "OUTER_SYMBOL", 
      "OUTFILE_SYMBOL", "OUT_SYMBOL", "OWNER_SYMBOL", "PACK_KEYS_SYMBOL", 
      "PAGE_SYMBOL", "PARSER_SYMBOL", "PARTIAL_SYMBOL", "PARTITIONING_SYMBOL", 
      "PARTITIONS_SYMBOL", "PARTITION_SYMBOL", "PASSWORD_SYMBOL", "PHASE_SYMBOL", 
      "PLUGINS_SYMBOL", "PLUGIN_DIR_SYMBOL", "PLUGIN_SYMBOL", "POINT_SYMBOL", 
      "POLYGON_SYMBOL", "PORT_SYMBOL", "POSITION_SYMBOL", "PRECEDES_SYMBOL", 
      "PRECISION_SYMBOL", "PREPARE_SYMBOL", "PRESERVE_SYMBOL", "PREV_SYMBOL", 
      "PRIMARY_SYMBOL", "PRIVILEGES_SYMBOL", "PROCEDURE_SYMBOL", "PROCESS_SYMBOL", 
      "PROCESSLIST_SYMBOL", "PROFILE_SYMBOL", "PROFILES_SYMBOL", "PROXY_SYMBOL", 
      "PURGE_SYMBOL", "QUARTER_SYMBOL", "QUERY_SYMBOL", "QUICK_SYMBOL", 
      "RANGE_SYMBOL", "READS_SYMBOL", "READ_ONLY_SYMBOL", "READ_SYMBOL", 
      "READ_WRITE_SYMBOL", "REAL_SYMBOL", "REBUILD_SYMBOL", "RECOVER_SYMBOL", 
      "REDOFILE_SYMBOL", "REDO_BUFFER_SIZE_SYMBOL", "REDUNDANT_SYMBOL", 
      "REFERENCES_SYMBOL", "REGEXP_SYMBOL", "RELAY_SYMBOL", "RELAYLOG_SYMBOL", 
      "RELAY_LOG_FILE_SYMBOL", "RELAY_LOG_POS_SYMBOL", "RELAY_THREAD_SYMBOL", 
      "RELEASE_SYMBOL", "RELOAD_SYMBOL", "REMOVE_SYMBOL", "RENAME_SYMBOL", 
      "REORGANIZE_SYMBOL", "REPAIR_SYMBOL", "REPEATABLE_SYMBOL", "REPEAT_SYMBOL", 
      "REPLACE_SYMBOL", "REPLICATION_SYMBOL", "REPLICATE_DO_DB_SYMBOL", 
      "REPLICATE_IGNORE_DB_SYMBOL", "REPLICATE_DO_TABLE_SYMBOL", "REPLICATE_IGNORE_TABLE_SYMBOL", 
      "REPLICATE_WILD_DO_TABLE_SYMBOL", "REPLICATE_WILD_IGNORE_TABLE_SYMBOL", 
      "REPLICATE_REWRITE_DB_SYMBOL", "REQUIRE_SYMBOL", "RESET_SYMBOL", "RESIGNAL_SYMBOL", 
      "RESTORE_SYMBOL", "RESTRICT_SYMBOL", "RESUME_SYMBOL", "RETURNED_SQLSTATE_SYMBOL", 
      "RETURNS_SYMBOL", "RETURN_SYMBOL", "REVERSE_SYMBOL", "REVOKE_SYMBOL", 
      "RIGHT_SYMBOL", "ROLLBACK_SYMBOL", "ROLLUP_SYMBOL", "ROTATE_SYMBOL", 
      "ROUTINE_SYMBOL", "ROWS_SYMBOL", "ROW_COUNT_SYMBOL", "ROW_FORMAT_SYMBOL", 
      "ROW_SYMBOL", "RTREE_SYMBOL", "SAVEPOINT_SYMBOL", "SCHEDULE_SYMBOL", 
      "SCHEMA_NAME_SYMBOL", "SECOND_MICROSECOND_SYMBOL", "SECOND_SYMBOL", 
      "SECURITY_SYMBOL", "SELECT_SYMBOL", "SENSITIVE_SYMBOL", "SEPARATOR_SYMBOL", 
      "SERIALIZABLE_SYMBOL", "SERIAL_SYMBOL", "SESSION_SYMBOL", "SERVER_SYMBOL", 
      "SERVER_OPTIONS_SYMBOL", "SESSION_USER_SYMBOL", "SET_SYMBOL", "SET_VAR_SYMBOL", 
      "SHARE_SYMBOL", "SHOW_SYMBOL", "SHUTDOWN_SYMBOL", "SIGNAL_SYMBOL", 
      "SIGNED_SYMBOL", "SIMPLE_SYMBOL", "SLAVE_SYMBOL", "SLOW_SYMBOL", "SMALLINT_SYMBOL", 
      "SNAPSHOT_SYMBOL", "SOCKET_SYMBOL", "SONAME_SYMBOL", "SOUNDS_SYMBOL", 
      "SOURCE_SYMBOL", "SPATIAL_SYMBOL", "SPECIFIC_SYMBOL", "SQLEXCEPTION_SYMBOL", 
      "SQLSTATE_SYMBOL", "SQLWARNING_SYMBOL", "SQL_AFTER_GTIDS_SYMBOL", 
      "SQL_AFTER_MTS_GAPS_SYMBOL", "SQL_BEFORE_GTIDS_SYMBOL", "SQL_BIG_RESULT_SYMBOL", 
      "SQL_BUFFER_RESULT_SYMBOL", "SQL_CACHE_SYMBOL", "SQL_CALC_FOUND_ROWS_SYMBOL", 
      "SQL_NO_CACHE_SYMBOL", "SQL_SMALL_RESULT_SYMBOL", "SQL_SYMBOL", "SQL_THREAD_SYMBOL", 
      "SSL_SYMBOL", "STACKED_SYMBOL", "STARTING_SYMBOL", "STARTS_SYMBOL", 
      "START_SYMBOL", "STATS_AUTO_RECALC_SYMBOL", "STATS_PERSISTENT_SYMBOL", 
      "STATS_SAMPLE_PAGES_SYMBOL", "STATUS_SYMBOL", "STDDEV_SAMP_SYMBOL", 
      "STDDEV_SYMBOL", "STDDEV_POP_SYMBOL", "STD_SYMBOL", "STOP_SYMBOL", 
      "STORAGE_SYMBOL", "STORED_SYMBOL", "STRAIGHT_JOIN_SYMBOL", "STRING_SYMBOL", 
      "SUBCLASS_ORIGIN_SYMBOL", "SUBDATE_SYMBOL", "SUBJECT_SYMBOL", "SUBPARTITIONS_SYMBOL", 
      "SUBPARTITION_SYMBOL", "SUBSTR_SYMBOL", "SUBSTRING_SYMBOL", "SUM_SYMBOL", 
      "SUPER_SYMBOL", "SUSPEND_SYMBOL", "SWAPS_SYMBOL", "SWITCHES_SYMBOL", 
      "SYSDATE_SYMBOL", "SYSTEM_USER_SYMBOL", "TABLES_SYMBOL", "TABLESPACE_SYMBOL", 
      "TABLE_REF_PRIORITY_SYMBOL", "TABLE_SYMBOL", "TABLE_CHECKSUM_SYMBOL", 
      "TABLE_NAME_SYMBOL", "TEMPORARY_SYMBOL", "TEMPTABLE_SYMBOL", "TERMINATED_SYMBOL", 
      "TEXT_SYMBOL", "THAN_SYMBOL", "THEN_SYMBOL", "TIMESTAMP_SYMBOL", "TIMESTAMPADD_SYMBOL", 
      "TIMESTAMPDIFF_SYMBOL", "TIME_SYMBOL", "TINYBLOB_SYMBOL", "TINYINT_SYMBOL", 
      "TINYTEXT_SYMBOL", "TO_SYMBOL", "TRAILING_SYMBOL", "TRANSACTION_SYMBOL", 
      "TRIGGERS_SYMBOL", "TRIGGER_SYMBOL", "TRIM_SYMBOL", "TRUE_SYMBOL", 
      "TRUNCATE_SYMBOL", "TYPES_SYMBOL", "TYPE_SYMBOL", "UDF_RETURNS_SYMBOL", 
      "UNCOMMITTED_SYMBOL", "UNDEFINED_SYMBOL", "UNDOFILE_SYMBOL", "UNDO_BUFFER_SIZE_SYMBOL", 
      "UNDO_SYMBOL", "UNICODE_SYMBOL", "UNINSTALL_SYMBOL", "UNION_SYMBOL", 
      "UNIQUE_SYMBOL", "UNKNOWN_SYMBOL", "UNLOCK_SYMBOL", "UNSIGNED_SYMBOL", 
      "UNTIL_SYMBOL", "UPDATE_SYMBOL", "UPGRADE_SYMBOL", "USAGE_SYMBOL", 
      "USER_RESOURCES_SYMBOL", "USER_SYMBOL", "USE_FRM_SYMBOL", "USE_SYMBOL", 
      "USING_SYMBOL", "UTC_DATE_SYMBOL", "UTC_TIMESTAMP_SYMBOL", "UTC_TIME_SYMBOL", 
      "VALIDATION_SYMBOL", "VALUES_SYMBOL", "VALUE_SYMBOL", "VARBINARY_SYMBOL", 
      "VARCHAR_SYMBOL", "VARIABLES_SYMBOL", "VARIANCE_SYMBOL", "VARYING_SYMBOL", 
      "VAR_POP_SYMBOL", "VAR_SAMP_SYMBOL", "VIEW_SYMBOL", "VIRTUAL_SYMBOL", 
      "WAIT_SYMBOL", "WARNINGS_SYMBOL", "WEEK_SYMBOL", "WEIGHT_STRING_SYMBOL", 
      "WHEN_SYMBOL", "WHERE_SYMBOL", "WHILE_SYMBOL", "WITH_SYMBOL", "WITHOUT_SYMBOL", 
      "WORK_SYMBOL", "WRAPPER_SYMBOL", "WRITE_SYMBOL", "X509_SYMBOL", "XA_SYMBOL", 
      "XID_SYMBOL", "XML_SYMBOL", "XOR_SYMBOL", "YEAR_MONTH_SYMBOL", "YEAR_SYMBOL", 
      "ZEROFILL_SYMBOL", "PERSIST_SYMBOL", "ROLE_SYMBOL", "ADMIN_SYMBOL", 
      "INVISIBLE_SYMBOL", "VISIBLE_SYMBOL", "EXCEPT_SYMBOL", "COMPONENT_SYMBOL", 
      "RECURSIVE_SYMBOL", "JSON_OBJECTAGG_SYMBOL", "JSON_ARRAYAGG_SYMBOL", 
      "OF_SYMBOL", "SKIP_SYMBOL", "LOCKED_SYMBOL", "NOWAIT_SYMBOL", "GROUPING_SYMBOL", 
      "PERSIST_ONLY_SYMBOL", "HISTOGRAM_SYMBOL", "BUCKETS_SYMBOL", "REMOTE_SYMBOL", 
      "CLONE_SYMBOL", "CUME_DIST_SYMBOL", "DENSE_RANK_SYMBOL", "EXCLUDE_SYMBOL", 
      "FIRST_VALUE_SYMBOL", "FOLLOWING_SYMBOL", "GROUPS_SYMBOL", "LAG_SYMBOL", 
      "LAST_VALUE_SYMBOL", "LEAD_SYMBOL", "NTH_VALUE_SYMBOL", "NTILE_SYMBOL", 
      "NULLS_SYMBOL", "OTHERS_SYMBOL", "OVER_SYMBOL", "PERCENT_RANK_SYMBOL", 
      "PRECEDING_SYMBOL", "RANK_SYMBOL", "RESPECT_SYMBOL", "ROW_NUMBER_SYMBOL", 
      "TIES_SYMBOL", "UNBOUNDED_SYMBOL", "WINDOW_SYMBOL", "EMPTY_SYMBOL", 
      "JSON_TABLE_SYMBOL", "NESTED_SYMBOL", "ORDINALITY_SYMBOL", "PATH_SYMBOL", 
      "HISTORY_SYMBOL", "REUSE_SYMBOL", "SRID_SYMBOL", "THREAD_PRIORITY_SYMBOL", 
      "RESOURCE_SYMBOL", "SYSTEM_SYMBOL", "VCPU_SYMBOL", "MASTER_PUBLIC_KEY_PATH_SYMBOL", 
      "GET_MASTER_PUBLIC_KEY_SYMBOL", "RESTART_SYMBOL", "DEFINITION_SYMBOL", 
      "DESCRIPTION_SYMBOL", "ORGANIZATION_SYMBOL", "REFERENCE_SYMBOL", "OPTIONAL_SYMBOL", 
      "SECONDARY_SYMBOL", "SECONDARY_ENGINE_SYMBOL", "SECONDARY_LOAD_SYMBOL", 
      "SECONDARY_UNLOAD_SYMBOL", "ACTIVE_SYMBOL", "INACTIVE_SYMBOL", "LATERAL_SYMBOL", 
      "RETAIN_SYMBOL", "OLD_SYMBOL", "NETWORK_NAMESPACE_SYMBOL", "ENFORCED_SYMBOL", 
      "ARRAY_SYMBOL", "OJ_SYMBOL", "MEMBER_SYMBOL", "RANDOM_SYMBOL", "MASTER_COMPRESSION_ALGORITHM_SYMBOL", 
      "MASTER_ZSTD_COMPRESSION_LEVEL_SYMBOL", "PRIVILEGE_CHECKS_USER_SYMBOL", 
      "MASTER_TLS_CIPHERSUITES_SYMBOL", "REQUIRE_ROW_FORMAT_SYMBOL", "PASSWORD_LOCK_TIME_SYMBOL", 
      "FAILED_LOGIN_ATTEMPTS_SYMBOL", "REQUIRE_TABLE_PRIMARY_KEY_CHECK_SYMBOL", 
      "STREAM_SYMBOL", "OFF_SYMBOL", "RETURNING_SYMBOL", "JSON_VALUE_SYMBOL", 
      "TLS_SYMBOL", "ATTRIBUTE_SYMBOL", "ENGINE_ATTRIBUTE_SYMBOL", "SECONDARY_ENGINE_ATTRIBUTE_SYMBOL", 
      "SOURCE_CONNECTION_AUTO_FAILOVER_SYMBOL", "ZONE_SYMBOL", "GRAMMAR_SELECTOR_DERIVED_EXPR", 
      "REPLICA_SYMBOL", "REPLICAS_SYMBOL", "ASSIGN_GTIDS_TO_ANONYMOUS_TRANSACTIONS_SYMBOL", 
      "GET_SOURCE_PUBLIC_KEY_SYMBOL", "SOURCE_AUTO_POSITION_SYMBOL", "SOURCE_BIND_SYMBOL", 
      "SOURCE_COMPRESSION_ALGORITHM_SYMBOL", "SOURCE_CONNECT_RETRY_SYMBOL", 
      "SOURCE_DELAY_SYMBOL", "SOURCE_HEARTBEAT_PERIOD_SYMBOL", "SOURCE_HOST_SYMBOL", 
      "SOURCE_LOG_FILE_SYMBOL", "SOURCE_LOG_POS_SYMBOL", "SOURCE_PASSWORD_SYMBOL", 
      "SOURCE_PORT_SYMBOL", "SOURCE_PUBLIC_KEY_PATH_SYMBOL", "SOURCE_RETRY_COUNT_SYMBOL", 
      "SOURCE_SSL_SYMBOL", "SOURCE_SSL_CA_SYMBOL", "SOURCE_SSL_CAPATH_SYMBOL", 
      "SOURCE_SSL_CERT_SYMBOL", "SOURCE_SSL_CIPHER_SYMBOL", "SOURCE_SSL_CRL_SYMBOL", 
      "SOURCE_SSL_CRLPATH_SYMBOL", "SOURCE_SSL_KEY_SYMBOL", "SOURCE_SSL_VERIFY_SERVER_CERT_SYMBOL", 
      "SOURCE_TLS_CIPHERSUITES_SYMBOL", "SOURCE_TLS_VERSION_SYMBOL", "SOURCE_USER_SYMBOL", 
      "SOURCE_ZSTD_COMPRESSION_LEVEL_SYMBOL", "ST_COLLECT_SYMBOL", "KEYRING_SYMBOL", 
      "AUTHENTICATION_SYMBOL", "FACTOR_SYMBOL", "FINISH_SYMBOL", "INITIATE_SYMBOL", 
      "REGISTRATION_SYMBOL", "UNREGISTER_SYMBOL", "INITIAL_SYMBOL", "CHALLENGE_RESPONSE_SYMBOL", 
      "GTID_ONLY_SYMBOL", "INTERSECT_SYMBOL", "BULK_SYMBOL", "URL_SYMBOL", 
      "GENERATE_SYMBOL", "PARSE_TREE_SYMBOL", "LOG_SYMBOL", "GTIDS_SYMBOL", 
      "PARALLEL_SYMBOL", "S3_SYMBOL", "QUALIFY_SYMBOL", "AUTO_SYMBOL", "MANUAL_SYMBOL", 
      "BERNOULLI_SYMBOL", "TABLESAMPLE_SYMBOL", "WHITESPACE", "INVALID_INPUT", 
      "UNDERSCORE_CHARSET", "IDENTIFIER", "NCHAR_TEXT", "BACK_TICK_QUOTED_ID", 
      "DOUBLE_QUOTED_TEXT", "SINGLE_QUOTED_TEXT", "DOLLAR_QUOTED_STRING_TEXT", 
      "VERSION_COMMENT_START", "MYSQL_COMMENT_START", "VERSION_COMMENT_END", 
      "BLOCK_COMMENT", "INVALID_BLOCK_COMMENT", "POUND_COMMENT", "DASHDASH_COMMENT", 
      "SIMPLE_IDENTIFIER", "NOT_EQUAL2_OPERATOR"
    }
  );
  static const int32_t serializedATNSegment[] = {
  	4,1,851,9484,2,0,7,0,2,1,7,1,2,2,7,2,2,3,7,3,2,4,7,4,2,5,7,5,2,6,7,6,
  	2,7,7,7,2,8,7,8,2,9,7,9,2,10,7,10,2,11,7,11,2,12,7,12,2,13,7,13,2,14,
  	7,14,2,15,7,15,2,16,7,16,2,17,7,17,2,18,7,18,2,19,7,19,2,20,7,20,2,21,
  	7,21,2,22,7,22,2,23,7,23,2,24,7,24,2,25,7,25,2,26,7,26,2,27,7,27,2,28,
  	7,28,2,29,7,29,2,30,7,30,2,31,7,31,2,32,7,32,2,33,7,33,2,34,7,34,2,35,
  	7,35,2,36,7,36,2,37,7,37,2,38,7,38,2,39,7,39,2,40,7,40,2,41,7,41,2,42,
  	7,42,2,43,7,43,2,44,7,44,2,45,7,45,2,46,7,46,2,47,7,47,2,48,7,48,2,49,
  	7,49,2,50,7,50,2,51,7,51,2,52,7,52,2,53,7,53,2,54,7,54,2,55,7,55,2,56,
  	7,56,2,57,7,57,2,58,7,58,2,59,7,59,2,60,7,60,2,61,7,61,2,62,7,62,2,63,
  	7,63,2,64,7,64,2,65,7,65,2,66,7,66,2,67,7,67,2,68,7,68,2,69,7,69,2,70,
  	7,70,2,71,7,71,2,72,7,72,2,73,7,73,2,74,7,74,2,75,7,75,2,76,7,76,2,77,
  	7,77,2,78,7,78,2,79,7,79,2,80,7,80,2,81,7,81,2,82,7,82,2,83,7,83,2,84,
  	7,84,2,85,7,85,2,86,7,86,2,87,7,87,2,88,7,88,2,89,7,89,2,90,7,90,2,91,
  	7,91,2,92,7,92,2,93,7,93,2,94,7,94,2,95,7,95,2,96,7,96,2,97,7,97,2,98,
  	7,98,2,99,7,99,2,100,7,100,2,101,7,101,2,102,7,102,2,103,7,103,2,104,
  	7,104,2,105,7,105,2,106,7,106,2,107,7,107,2,108,7,108,2,109,7,109,2,110,
  	7,110,2,111,7,111,2,112,7,112,2,113,7,113,2,114,7,114,2,115,7,115,2,116,
  	7,116,2,117,7,117,2,118,7,118,2,119,7,119,2,120,7,120,2,121,7,121,2,122,
  	7,122,2,123,7,123,2,124,7,124,2,125,7,125,2,126,7,126,2,127,7,127,2,128,
  	7,128,2,129,7,129,2,130,7,130,2,131,7,131,2,132,7,132,2,133,7,133,2,134,
  	7,134,2,135,7,135,2,136,7,136,2,137,7,137,2,138,7,138,2,139,7,139,2,140,
  	7,140,2,141,7,141,2,142,7,142,2,143,7,143,2,144,7,144,2,145,7,145,2,146,
  	7,146,2,147,7,147,2,148,7,148,2,149,7,149,2,150,7,150,2,151,7,151,2,152,
  	7,152,2,153,7,153,2,154,7,154,2,155,7,155,2,156,7,156,2,157,7,157,2,158,
  	7,158,2,159,7,159,2,160,7,160,2,161,7,161,2,162,7,162,2,163,7,163,2,164,
  	7,164,2,165,7,165,2,166,7,166,2,167,7,167,2,168,7,168,2,169,7,169,2,170,
  	7,170,2,171,7,171,2,172,7,172,2,173,7,173,2,174,7,174,2,175,7,175,2,176,
  	7,176,2,177,7,177,2,178,7,178,2,179,7,179,2,180,7,180,2,181,7,181,2,182,
  	7,182,2,183,7,183,2,184,7,184,2,185,7,185,2,186,7,186,2,187,7,187,2,188,
  	7,188,2,189,7,189,2,190,7,190,2,191,7,191,2,192,7,192,2,193,7,193,2,194,
  	7,194,2,195,7,195,2,196,7,196,2,197,7,197,2,198,7,198,2,199,7,199,2,200,
  	7,200,2,201,7,201,2,202,7,202,2,203,7,203,2,204,7,204,2,205,7,205,2,206,
  	7,206,2,207,7,207,2,208,7,208,2,209,7,209,2,210,7,210,2,211,7,211,2,212,
  	7,212,2,213,7,213,2,214,7,214,2,215,7,215,2,216,7,216,2,217,7,217,2,218,
  	7,218,2,219,7,219,2,220,7,220,2,221,7,221,2,222,7,222,2,223,7,223,2,224,
  	7,224,2,225,7,225,2,226,7,226,2,227,7,227,2,228,7,228,2,229,7,229,2,230,
  	7,230,2,231,7,231,2,232,7,232,2,233,7,233,2,234,7,234,2,235,7,235,2,236,
  	7,236,2,237,7,237,2,238,7,238,2,239,7,239,2,240,7,240,2,241,7,241,2,242,
  	7,242,2,243,7,243,2,244,7,244,2,245,7,245,2,246,7,246,2,247,7,247,2,248,
  	7,248,2,249,7,249,2,250,7,250,2,251,7,251,2,252,7,252,2,253,7,253,2,254,
  	7,254,2,255,7,255,2,256,7,256,2,257,7,257,2,258,7,258,2,259,7,259,2,260,
  	7,260,2,261,7,261,2,262,7,262,2,263,7,263,2,264,7,264,2,265,7,265,2,266,
  	7,266,2,267,7,267,2,268,7,268,2,269,7,269,2,270,7,270,2,271,7,271,2,272,
  	7,272,2,273,7,273,2,274,7,274,2,275,7,275,2,276,7,276,2,277,7,277,2,278,
  	7,278,2,279,7,279,2,280,7,280,2,281,7,281,2,282,7,282,2,283,7,283,2,284,
  	7,284,2,285,7,285,2,286,7,286,2,287,7,287,2,288,7,288,2,289,7,289,2,290,
  	7,290,2,291,7,291,2,292,7,292,2,293,7,293,2,294,7,294,2,295,7,295,2,296,
  	7,296,2,297,7,297,2,298,7,298,2,299,7,299,2,300,7,300,2,301,7,301,2,302,
  	7,302,2,303,7,303,2,304,7,304,2,305,7,305,2,306,7,306,2,307,7,307,2,308,
  	7,308,2,309,7,309,2,310,7,310,2,311,7,311,2,312,7,312,2,313,7,313,2,314,
  	7,314,2,315,7,315,2,316,7,316,2,317,7,317,2,318,7,318,2,319,7,319,2,320,
  	7,320,2,321,7,321,2,322,7,322,2,323,7,323,2,324,7,324,2,325,7,325,2,326,
  	7,326,2,327,7,327,2,328,7,328,2,329,7,329,2,330,7,330,2,331,7,331,2,332,
  	7,332,2,333,7,333,2,334,7,334,2,335,7,335,2,336,7,336,2,337,7,337,2,338,
  	7,338,2,339,7,339,2,340,7,340,2,341,7,341,2,342,7,342,2,343,7,343,2,344,
  	7,344,2,345,7,345,2,346,7,346,2,347,7,347,2,348,7,348,2,349,7,349,2,350,
  	7,350,2,351,7,351,2,352,7,352,2,353,7,353,2,354,7,354,2,355,7,355,2,356,
  	7,356,2,357,7,357,2,358,7,358,2,359,7,359,2,360,7,360,2,361,7,361,2,362,
  	7,362,2,363,7,363,2,364,7,364,2,365,7,365,2,366,7,366,2,367,7,367,2,368,
  	7,368,2,369,7,369,2,370,7,370,2,371,7,371,2,372,7,372,2,373,7,373,2,374,
  	7,374,2,375,7,375,2,376,7,376,2,377,7,377,2,378,7,378,2,379,7,379,2,380,
  	7,380,2,381,7,381,2,382,7,382,2,383,7,383,2,384,7,384,2,385,7,385,2,386,
  	7,386,2,387,7,387,2,388,7,388,2,389,7,389,2,390,7,390,2,391,7,391,2,392,
  	7,392,2,393,7,393,2,394,7,394,2,395,7,395,2,396,7,396,2,397,7,397,2,398,
  	7,398,2,399,7,399,2,400,7,400,2,401,7,401,2,402,7,402,2,403,7,403,2,404,
  	7,404,2,405,7,405,2,406,7,406,2,407,7,407,2,408,7,408,2,409,7,409,2,410,
  	7,410,2,411,7,411,2,412,7,412,2,413,7,413,2,414,7,414,2,415,7,415,2,416,
  	7,416,2,417,7,417,2,418,7,418,2,419,7,419,2,420,7,420,2,421,7,421,2,422,
  	7,422,2,423,7,423,2,424,7,424,2,425,7,425,2,426,7,426,2,427,7,427,2,428,
  	7,428,2,429,7,429,2,430,7,430,2,431,7,431,2,432,7,432,2,433,7,433,2,434,
  	7,434,2,435,7,435,2,436,7,436,2,437,7,437,2,438,7,438,2,439,7,439,2,440,
  	7,440,2,441,7,441,2,442,7,442,2,443,7,443,2,444,7,444,2,445,7,445,2,446,
  	7,446,2,447,7,447,2,448,7,448,2,449,7,449,2,450,7,450,2,451,7,451,2,452,
  	7,452,2,453,7,453,2,454,7,454,2,455,7,455,2,456,7,456,2,457,7,457,2,458,
  	7,458,2,459,7,459,2,460,7,460,2,461,7,461,2,462,7,462,2,463,7,463,2,464,
  	7,464,2,465,7,465,2,466,7,466,2,467,7,467,2,468,7,468,2,469,7,469,2,470,
  	7,470,2,471,7,471,2,472,7,472,2,473,7,473,2,474,7,474,2,475,7,475,2,476,
  	7,476,2,477,7,477,2,478,7,478,2,479,7,479,2,480,7,480,2,481,7,481,2,482,
  	7,482,2,483,7,483,2,484,7,484,2,485,7,485,2,486,7,486,2,487,7,487,2,488,
  	7,488,2,489,7,489,2,490,7,490,2,491,7,491,2,492,7,492,2,493,7,493,2,494,
  	7,494,2,495,7,495,2,496,7,496,2,497,7,497,2,498,7,498,2,499,7,499,2,500,
  	7,500,2,501,7,501,2,502,7,502,2,503,7,503,2,504,7,504,2,505,7,505,2,506,
  	7,506,2,507,7,507,2,508,7,508,2,509,7,509,2,510,7,510,2,511,7,511,2,512,
  	7,512,2,513,7,513,2,514,7,514,2,515,7,515,2,516,7,516,2,517,7,517,2,518,
  	7,518,2,519,7,519,2,520,7,520,2,521,7,521,2,522,7,522,2,523,7,523,2,524,
  	7,524,2,525,7,525,2,526,7,526,2,527,7,527,2,528,7,528,2,529,7,529,2,530,
  	7,530,2,531,7,531,2,532,7,532,2,533,7,533,2,534,7,534,2,535,7,535,2,536,
  	7,536,2,537,7,537,2,538,7,538,2,539,7,539,2,540,7,540,2,541,7,541,2,542,
  	7,542,2,543,7,543,2,544,7,544,2,545,7,545,2,546,7,546,2,547,7,547,2,548,
  	7,548,2,549,7,549,2,550,7,550,2,551,7,551,2,552,7,552,2,553,7,553,2,554,
  	7,554,2,555,7,555,2,556,7,556,2,557,7,557,2,558,7,558,2,559,7,559,2,560,
  	7,560,2,561,7,561,2,562,7,562,2,563,7,563,2,564,7,564,2,565,7,565,2,566,
  	7,566,2,567,7,567,2,568,7,568,2,569,7,569,2,570,7,570,2,571,7,571,2,572,
  	7,572,2,573,7,573,2,574,7,574,2,575,7,575,2,576,7,576,2,577,7,577,2,578,
  	7,578,2,579,7,579,2,580,7,580,2,581,7,581,2,582,7,582,2,583,7,583,2,584,
  	7,584,2,585,7,585,2,586,7,586,2,587,7,587,2,588,7,588,2,589,7,589,2,590,
  	7,590,2,591,7,591,2,592,7,592,2,593,7,593,2,594,7,594,2,595,7,595,2,596,
  	7,596,2,597,7,597,2,598,7,598,2,599,7,599,2,600,7,600,2,601,7,601,2,602,
  	7,602,2,603,7,603,2,604,7,604,2,605,7,605,2,606,7,606,2,607,7,607,2,608,
  	7,608,2,609,7,609,2,610,7,610,2,611,7,611,2,612,7,612,2,613,7,613,2,614,
  	7,614,2,615,7,615,2,616,7,616,2,617,7,617,2,618,7,618,2,619,7,619,2,620,
  	7,620,2,621,7,621,2,622,7,622,2,623,7,623,2,624,7,624,2,625,7,625,2,626,
  	7,626,2,627,7,627,2,628,7,628,2,629,7,629,2,630,7,630,2,631,7,631,2,632,
  	7,632,2,633,7,633,2,634,7,634,2,635,7,635,2,636,7,636,2,637,7,637,2,638,
  	7,638,2,639,7,639,2,640,7,640,2,641,7,641,2,642,7,642,2,643,7,643,2,644,
  	7,644,2,645,7,645,2,646,7,646,2,647,7,647,2,648,7,648,2,649,7,649,2,650,
  	7,650,2,651,7,651,2,652,7,652,2,653,7,653,2,654,7,654,2,655,7,655,2,656,
  	7,656,2,657,7,657,2,658,7,658,2,659,7,659,2,660,7,660,2,661,7,661,2,662,
  	7,662,2,663,7,663,2,664,7,664,2,665,7,665,2,666,7,666,2,667,7,667,2,668,
  	7,668,2,669,7,669,2,670,7,670,2,671,7,671,2,672,7,672,2,673,7,673,2,674,
  	7,674,2,675,7,675,2,676,7,676,2,677,7,677,2,678,7,678,2,679,7,679,2,680,
  	7,680,2,681,7,681,2,682,7,682,2,683,7,683,2,684,7,684,2,685,7,685,2,686,
  	7,686,2,687,7,687,2,688,7,688,2,689,7,689,2,690,7,690,2,691,7,691,2,692,
  	7,692,2,693,7,693,2,694,7,694,2,695,7,695,2,696,7,696,2,697,7,697,2,698,
  	7,698,2,699,7,699,2,700,7,700,2,701,7,701,2,702,7,702,2,703,7,703,2,704,
  	7,704,2,705,7,705,2,706,7,706,2,707,7,707,2,708,7,708,2,709,7,709,2,710,
  	7,710,2,711,7,711,2,712,7,712,2,713,7,713,2,714,7,714,2,715,7,715,2,716,
  	7,716,2,717,7,717,2,718,7,718,2,719,7,719,2,720,7,720,2,721,7,721,2,722,
  	7,722,2,723,7,723,2,724,7,724,2,725,7,725,2,726,7,726,2,727,7,727,2,728,
  	7,728,2,729,7,729,2,730,7,730,2,731,7,731,2,732,7,732,2,733,7,733,2,734,
  	7,734,2,735,7,735,2,736,7,736,2,737,7,737,2,738,7,738,2,739,7,739,2,740,
  	7,740,2,741,7,741,2,742,7,742,2,743,7,743,2,744,7,744,2,745,7,745,2,746,
  	7,746,2,747,7,747,2,748,7,748,2,749,7,749,2,750,7,750,2,751,7,751,2,752,
  	7,752,1,0,1,0,3,0,1509,8,0,1,0,3,0,1512,8,0,3,0,1514,8,0,1,0,1,0,1,1,
  	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,1,1598,8,1,1,2,1,2,1,2,1,2,1,2,
  	1,2,3,2,1606,8,2,1,2,1,2,1,2,3,2,1611,8,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
  	1,2,3,2,1621,8,2,1,3,1,3,1,3,4,3,1626,8,3,11,3,12,3,1627,1,3,1,3,1,3,
  	1,3,1,3,3,3,1635,8,3,1,4,1,4,1,4,1,4,3,4,1641,8,4,1,4,3,4,1644,8,4,1,
  	5,3,5,1647,8,5,1,5,1,5,1,5,1,5,1,5,3,5,1654,8,5,1,5,1,5,1,5,3,5,1659,
  	8,5,1,5,3,5,1662,8,5,1,5,1,5,1,5,3,5,1667,8,5,1,5,1,5,1,5,1,5,3,5,1673,
  	8,5,3,5,1675,8,5,1,5,1,5,3,5,1679,8,5,1,5,1,5,3,5,1683,8,5,1,6,1,6,1,
  	6,1,6,1,6,1,6,1,6,3,6,1692,8,6,1,7,1,7,3,7,1696,8,7,1,7,5,7,1699,8,7,
  	10,7,12,7,1702,9,7,1,8,1,8,1,8,3,8,1707,8,8,1,9,1,9,1,9,1,9,1,10,3,10,
  	1714,8,10,1,10,1,10,1,10,3,10,1719,8,10,1,11,1,11,1,11,3,11,1724,8,11,
  	1,11,1,11,1,11,1,11,1,11,3,11,1731,8,11,1,11,3,11,1734,8,11,1,12,1,12,
  	1,12,1,12,3,12,1740,8,12,1,12,3,12,1743,8,12,1,13,1,13,1,13,5,13,1748,
  	8,13,10,13,12,13,1751,9,13,1,14,1,14,1,14,1,14,1,14,1,14,1,14,3,14,1760,
  	8,14,1,15,1,15,1,15,3,15,1765,8,15,1,15,1,15,1,15,3,15,1770,8,15,1,15,
  	1,15,1,15,1,15,1,15,1,15,3,15,1778,8,15,1,15,1,15,1,15,1,15,3,15,1784,
  	8,15,1,15,1,15,3,15,1788,8,15,1,15,1,15,1,15,3,15,1793,8,15,1,15,1,15,
  	1,15,1,15,1,15,5,15,1800,8,15,10,15,12,15,1803,9,15,1,15,1,15,1,15,3,
  	15,1808,8,15,1,15,1,15,5,15,1812,8,15,10,15,12,15,1815,9,15,1,15,1,15,
  	1,15,3,15,1820,8,15,1,15,1,15,1,15,1,15,1,15,1,15,1,15,3,15,1829,8,15,
  	1,15,1,15,1,15,1,15,3,15,1835,8,15,1,15,1,15,1,15,1,15,1,15,1,15,1,15,
  	3,15,1844,8,15,1,15,1,15,1,15,1,15,1,15,1,15,1,15,1,15,1,15,1,15,1,15,
  	1,15,3,15,1858,8,15,1,16,1,16,3,16,1862,8,16,1,16,1,16,1,16,1,16,3,16,
  	1868,8,16,5,16,1870,8,16,10,16,12,16,1873,9,16,1,17,1,17,1,17,3,17,1878,
  	8,17,1,18,1,18,3,18,1882,8,18,1,18,1,18,1,18,3,18,1887,8,18,1,18,3,18,
  	1890,8,18,1,18,1,18,1,18,1,18,3,18,1896,8,18,1,18,1,18,1,18,1,18,3,18,
  	1902,8,18,1,18,1,18,1,18,1,18,3,18,1908,8,18,1,18,1,18,3,18,1912,8,18,
  	1,18,1,18,1,18,3,18,1917,8,18,1,18,1,18,3,18,1921,8,18,1,18,1,18,3,18,
  	1925,8,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,
  	1,18,1,18,3,18,1941,8,18,1,18,1,18,1,18,1,18,1,18,1,18,3,18,1949,8,18,
  	1,18,1,18,1,18,1,18,1,18,1,18,3,18,1957,8,18,1,18,1,18,1,18,1,18,1,18,
  	3,18,1964,8,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,
  	1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,
  	1,18,1,18,3,18,1993,8,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,
  	1,18,1,18,1,18,1,18,3,18,2008,8,18,1,18,3,18,2011,8,18,1,18,1,18,1,18,
  	1,18,1,18,1,18,1,18,3,18,2020,8,18,1,19,1,19,1,19,3,19,2025,8,19,1,20,
  	1,20,1,21,1,21,3,21,2031,8,21,1,21,1,21,1,21,3,21,2036,8,21,5,21,2038,
  	8,21,10,21,12,21,2041,9,21,1,22,1,22,3,22,2045,8,22,1,22,1,22,3,22,2049,
  	8,22,1,23,1,23,3,23,2053,8,23,1,23,1,23,3,23,2057,8,23,1,24,1,24,3,24,
  	2061,8,24,1,24,1,24,3,24,2065,8,24,3,24,2067,8,24,1,25,1,25,1,25,1,25,
  	1,26,1,26,1,26,1,27,1,27,3,27,2078,8,27,1,28,1,28,1,28,1,28,1,28,1,28,
  	3,28,2086,8,28,1,28,1,28,1,28,1,28,1,28,3,28,2093,8,28,1,29,1,29,1,29,
  	1,29,1,29,1,29,3,29,2101,8,29,1,30,1,30,3,30,2105,8,30,1,30,5,30,2108,
  	8,30,10,30,12,30,2111,9,30,1,31,1,31,1,32,1,32,3,32,2117,8,32,1,32,5,
  	32,2120,8,32,10,32,12,32,2123,9,32,1,33,1,33,3,33,2127,8,33,1,33,1,33,
  	1,33,1,33,1,33,1,33,1,33,1,33,3,33,2137,8,33,1,34,1,34,3,34,2141,8,34,
  	1,34,1,34,1,34,3,34,2146,8,34,1,35,3,35,2149,8,35,1,35,3,35,2152,8,35,
  	1,35,3,35,2155,8,35,1,35,1,35,1,35,1,35,1,36,3,36,2162,8,36,1,36,1,36,
  	1,36,1,37,1,37,3,37,2169,8,37,1,38,1,38,3,38,2173,8,38,1,38,1,38,1,38,
  	1,39,1,39,1,39,1,39,1,39,1,39,1,39,1,39,1,39,1,39,1,39,1,39,1,39,1,39,
  	3,39,2192,8,39,1,39,1,39,1,39,1,39,3,39,2198,8,39,1,39,1,39,1,39,1,39,
  	1,39,1,39,1,39,1,39,3,39,2208,8,39,1,39,3,39,2211,8,39,1,40,1,40,1,40,
  	1,40,1,40,1,40,1,40,1,40,1,40,1,40,1,40,1,40,1,40,1,40,1,40,1,40,1,40,
  	1,40,1,40,3,40,2232,8,40,1,41,1,41,3,41,2236,8,41,1,41,1,41,5,41,2240,
  	8,41,10,41,12,41,2243,9,41,1,42,1,42,1,42,1,42,3,42,2249,8,42,1,43,3,
  	43,2252,8,43,1,43,1,43,3,43,2256,8,43,1,43,1,43,1,43,1,43,1,43,3,43,2263,
  	8,43,1,43,3,43,2266,8,43,1,43,1,43,1,43,1,43,1,43,1,43,1,43,3,43,2275,
  	8,43,1,44,1,44,1,44,5,44,2280,8,44,10,44,12,44,2283,9,44,1,45,1,45,3,
  	45,2287,8,45,1,46,3,46,2290,8,46,1,46,1,46,1,47,3,47,2295,8,47,1,47,1,
  	47,1,48,1,48,3,48,2301,8,48,1,48,3,48,2304,8,48,1,49,1,49,3,49,2308,8,
  	49,1,50,1,50,1,50,1,50,3,50,2314,8,50,1,50,3,50,2317,8,50,1,50,1,50,1,
  	51,3,51,2322,8,51,1,51,1,51,1,51,3,51,2327,8,51,1,51,1,51,1,51,1,51,1,
  	51,5,51,2334,8,51,10,51,12,51,2337,9,51,3,51,2339,8,51,1,51,1,51,5,51,
  	2343,8,51,10,51,12,51,2346,9,51,1,51,1,51,1,52,1,52,3,52,2352,8,52,1,
  	53,1,53,1,53,1,53,3,53,2358,8,53,1,54,3,54,2361,8,54,1,54,1,54,1,54,3,
  	54,2366,8,54,1,54,1,54,1,54,1,54,1,54,5,54,2373,8,54,10,54,12,54,2376,
  	9,54,3,54,2378,8,54,1,54,1,54,1,54,1,54,5,54,2384,8,54,10,54,12,54,2387,
  	9,54,1,54,1,54,1,55,3,55,2392,8,55,1,55,1,55,1,55,3,55,2397,8,55,1,55,
  	1,55,1,55,1,55,1,55,1,55,1,56,1,56,3,56,2407,8,56,1,56,3,56,2410,8,56,
  	1,57,4,57,2413,8,57,11,57,12,57,2414,1,58,1,58,1,58,1,58,1,58,1,58,3,
  	58,2423,8,58,1,58,1,58,1,58,1,58,1,58,1,58,1,58,1,58,1,58,1,58,1,58,1,
  	58,1,58,3,58,2438,8,58,1,59,3,59,2441,8,59,1,59,3,59,2444,8,59,1,59,1,
  	59,1,59,3,59,2449,8,59,1,59,1,59,5,59,2453,8,59,10,59,12,59,2456,9,59,
  	1,59,1,59,1,59,1,59,1,59,5,59,2463,8,59,10,59,12,59,2466,9,59,1,59,1,
  	59,1,59,1,59,1,59,5,59,2473,8,59,10,59,12,59,2476,9,59,3,59,2478,8,59,
  	1,59,3,59,2481,8,59,1,60,1,60,3,60,2485,8,60,1,60,1,60,1,60,1,60,1,60,
  	1,60,3,60,2493,8,60,1,61,1,61,1,61,1,61,1,62,1,62,1,62,1,62,1,62,1,62,
  	1,62,3,62,2506,8,62,1,63,1,63,3,63,2510,8,63,1,63,5,63,2513,8,63,10,63,
  	12,63,2516,9,63,1,64,1,64,1,64,1,64,1,64,1,64,3,64,2524,8,64,1,65,1,65,
  	1,65,1,65,1,65,1,65,1,65,1,65,1,66,1,66,1,66,1,66,1,66,5,66,2539,8,66,
  	10,66,12,66,2542,9,66,1,66,1,66,1,67,1,67,1,67,1,67,1,67,1,67,1,67,1,
  	67,1,67,1,67,1,67,1,67,1,67,1,67,3,67,2560,8,67,1,68,1,68,1,68,1,68,1,
  	68,1,68,1,68,3,68,2569,8,68,1,68,3,68,2572,8,68,1,69,1,69,1,69,1,69,1,
  	69,1,69,3,69,2580,8,69,1,70,1,70,1,70,1,70,1,70,3,70,2587,8,70,3,70,2589,
  	8,70,1,71,1,71,1,71,1,72,1,72,3,72,2596,8,72,1,72,5,72,2599,8,72,10,72,
  	12,72,2602,9,72,1,73,1,73,1,73,1,73,1,73,1,73,1,73,1,73,1,73,1,73,1,73,
  	1,73,3,73,2616,8,73,1,74,1,74,3,74,2620,8,74,1,74,1,74,1,75,1,75,3,75,
  	2626,8,75,1,75,1,75,1,76,1,76,3,76,2632,8,76,1,76,1,76,1,77,1,77,3,77,
  	2638,8,77,1,77,1,77,1,78,1,78,3,78,2644,8,78,1,78,1,78,1,79,1,79,3,79,
  	2650,8,79,1,79,1,79,1,80,3,80,2655,8,80,1,80,1,80,3,80,2659,8,80,1,80,
  	1,80,1,81,1,81,1,82,1,82,3,82,2667,8,82,1,82,1,82,1,83,1,83,3,83,2673,
  	8,83,1,83,1,83,1,84,1,84,3,84,2679,8,84,1,84,1,84,1,85,1,85,3,85,2685,
  	8,85,1,85,1,85,1,86,3,86,2690,8,86,1,86,3,86,2693,8,86,1,86,3,86,2696,
  	8,86,1,86,1,86,1,86,1,86,1,87,1,87,1,87,3,87,2705,8,87,1,87,3,87,2708,
  	8,87,1,88,1,88,1,88,1,88,1,89,1,89,1,89,1,89,1,90,3,90,2719,8,90,1,90,
  	1,90,1,90,3,90,2724,8,90,1,90,1,90,1,90,1,90,1,90,1,90,1,90,1,90,1,90,
  	3,90,2735,8,90,1,90,1,90,1,91,1,91,1,91,1,92,3,92,2743,8,92,1,92,1,92,
  	3,92,2747,8,92,1,92,1,92,1,92,1,92,1,92,1,92,1,92,3,92,2756,8,92,1,92,
  	3,92,2759,8,92,1,92,1,92,1,92,1,92,3,92,2765,8,92,3,92,2767,8,92,1,92,
  	1,92,3,92,2771,8,92,1,92,1,92,1,92,1,93,1,93,3,93,2778,8,93,1,93,1,93,
  	1,94,1,94,1,94,1,94,1,94,1,94,1,94,5,94,2789,8,94,10,94,12,94,2792,9,
  	94,1,94,1,94,1,94,1,94,3,94,2798,8,94,1,94,1,94,5,94,2802,8,94,10,94,
  	12,94,2805,9,94,3,94,2807,8,94,1,95,1,95,1,95,1,95,1,95,1,95,1,95,1,95,
  	1,95,1,95,1,95,1,95,1,95,1,95,1,95,3,95,2824,8,95,1,96,1,96,1,96,1,96,
  	1,96,1,96,1,96,1,96,1,96,1,96,1,96,1,96,1,96,1,96,1,96,1,96,1,96,1,96,
  	3,96,2844,8,96,1,97,1,97,3,97,2848,8,97,1,97,1,97,1,98,1,98,3,98,2854,
  	8,98,1,98,1,98,1,99,1,99,3,99,2860,8,99,1,99,1,99,1,100,1,100,3,100,2866,
  	8,100,1,100,1,100,1,101,3,101,2871,8,101,1,101,1,101,1,101,1,101,1,101,
  	3,101,2878,8,101,1,102,1,102,1,102,1,102,1,102,3,102,2885,8,102,1,102,
  	5,102,2888,8,102,10,102,12,102,2891,9,102,3,102,2893,8,102,1,103,1,103,
  	3,103,2897,8,103,1,104,1,104,3,104,2901,8,104,1,104,1,104,1,105,3,105,
  	2906,8,105,1,105,1,105,3,105,2910,8,105,1,105,1,105,3,105,2914,8,105,
  	1,106,1,106,1,106,1,106,3,106,2920,8,106,1,106,5,106,2923,8,106,10,106,
  	12,106,2926,9,106,3,106,2928,8,106,1,107,1,107,3,107,2932,8,107,1,107,
  	1,107,1,108,1,108,3,108,2938,8,108,1,108,1,108,3,108,2942,8,108,1,109,
  	1,109,3,109,2946,8,109,1,109,1,109,1,110,1,110,1,110,1,110,3,110,2954,
  	8,110,1,110,1,110,1,111,1,111,1,111,1,111,3,111,2962,8,111,1,112,1,112,
  	1,112,1,112,1,112,5,112,2969,8,112,10,112,12,112,2972,9,112,1,113,1,113,
  	1,113,1,113,1,114,1,114,3,114,2980,8,114,1,114,1,114,1,115,1,115,1,115,
  	1,115,1,115,1,116,1,116,1,116,1,116,3,116,2993,8,116,1,116,3,116,2996,
  	8,116,1,117,1,117,3,117,3000,8,117,1,117,1,117,5,117,3004,8,117,10,117,
  	12,117,3007,9,117,1,117,1,117,1,117,1,117,1,117,3,117,3014,8,117,1,117,
  	1,117,1,117,3,117,3019,8,117,1,117,3,117,3022,8,117,1,117,3,117,3025,
  	8,117,1,117,3,117,3028,8,117,1,117,3,117,3031,8,117,3,117,3033,8,117,
  	1,117,1,117,1,117,1,117,3,117,3039,8,117,3,117,3041,8,117,1,118,1,118,
  	1,118,1,118,1,118,1,119,1,119,1,120,1,120,1,120,1,120,1,120,3,120,3055,
  	8,120,1,121,1,121,1,121,1,121,3,121,3061,8,121,1,121,1,121,1,121,1,121,
  	1,121,3,121,3068,8,121,1,121,3,121,3071,8,121,3,121,3073,8,121,3,121,
  	3075,8,121,1,122,1,122,1,122,1,122,1,122,1,122,1,122,1,122,3,122,3085,
  	8,122,3,122,3087,8,122,1,123,1,123,3,123,3091,8,123,1,123,3,123,3094,
  	8,123,1,123,3,123,3097,8,123,1,123,1,123,3,123,3101,8,123,1,123,1,123,
  	3,123,3105,8,123,1,123,1,123,1,123,3,123,3110,8,123,1,123,3,123,3113,
  	8,123,1,123,3,123,3116,8,123,1,124,1,124,1,125,1,125,3,125,3122,8,125,
  	1,125,3,125,3125,8,125,1,125,1,125,1,126,1,126,1,126,5,126,3132,8,126,
  	10,126,12,126,3135,9,126,1,127,1,127,1,127,1,128,1,128,1,128,1,128,3,
  	128,3144,8,128,1,128,3,128,3147,8,128,1,128,3,128,3150,8,128,1,129,1,
  	129,3,129,3154,8,129,1,129,1,129,1,129,1,129,3,129,3160,8,129,1,129,5,
  	129,3163,8,129,10,129,12,129,3166,9,129,1,130,1,130,3,130,3170,8,130,
  	1,130,1,130,1,130,3,130,3175,8,130,5,130,3177,8,130,10,130,12,130,3180,
  	9,130,1,131,1,131,1,131,1,131,3,131,3186,8,131,1,132,1,132,1,132,1,132,
  	1,132,1,132,1,133,1,133,1,133,3,133,3197,8,133,1,133,3,133,3200,8,133,
  	1,133,3,133,3203,8,133,1,133,3,133,3206,8,133,1,133,1,133,3,133,3210,
  	8,133,1,133,3,133,3213,8,133,1,133,3,133,3216,8,133,1,133,1,133,1,133,
  	1,133,3,133,3222,8,133,1,133,3,133,3225,8,133,1,133,3,133,3228,8,133,
  	1,133,3,133,3231,8,133,1,133,3,133,3234,8,133,1,133,1,133,3,133,3238,
  	8,133,1,133,3,133,3241,8,133,1,133,3,133,3244,8,133,1,134,1,134,1,135,
  	1,135,1,136,1,136,1,136,1,137,1,137,1,137,3,137,3256,8,137,1,138,1,138,
  	1,138,1,138,1,138,1,138,3,138,3264,8,138,1,139,1,139,1,139,1,139,1,139,
  	1,139,1,140,1,140,1,140,1,140,1,140,1,141,1,141,1,141,3,141,3280,8,141,
  	1,141,3,141,3283,8,141,1,141,1,141,3,141,3287,8,141,1,142,1,142,3,142,
  	3291,8,142,1,142,1,142,1,143,1,143,3,143,3297,8,143,1,143,1,143,1,143,
  	3,143,3302,8,143,5,143,3304,8,143,10,143,12,143,3307,9,143,1,144,1,144,
  	1,144,1,144,1,144,1,145,1,145,1,145,1,145,1,145,1,146,1,146,1,146,1,146,
  	1,146,1,147,1,147,3,147,3326,8,147,1,147,3,147,3329,8,147,1,147,1,147,
  	3,147,3333,8,147,1,147,1,147,1,147,1,147,3,147,3339,8,147,1,148,1,148,
  	3,148,3343,8,148,1,148,3,148,3346,8,148,1,149,1,149,1,149,1,149,1,149,
  	1,149,1,149,3,149,3355,8,149,1,149,1,149,1,149,1,149,1,149,1,149,1,149,
  	1,149,3,149,3365,8,149,1,150,1,150,3,150,3369,8,150,1,150,1,150,3,150,
  	3373,8,150,1,150,3,150,3376,8,150,1,150,1,150,3,150,3380,8,150,1,151,
  	1,151,3,151,3384,8,151,1,151,1,151,1,151,3,151,3389,8,151,1,151,3,151,
  	3392,8,151,1,151,5,151,3395,8,151,10,151,12,151,3398,9,151,1,152,1,152,
  	1,152,3,152,3403,8,152,1,152,1,152,1,153,1,153,1,153,1,153,1,153,3,153,
  	3412,8,153,1,154,1,154,5,154,3416,8,154,10,154,12,154,3419,9,154,1,154,
  	1,154,3,154,3423,8,154,1,154,3,154,3426,8,154,1,154,3,154,3429,8,154,
  	1,154,3,154,3432,8,154,1,154,3,154,3435,8,154,1,154,1,154,3,154,3439,
  	8,154,1,154,3,154,3442,8,154,1,155,1,155,1,156,1,156,1,157,1,157,1,157,
  	1,158,1,158,1,158,1,159,1,159,1,159,3,159,3457,8,159,1,160,1,160,3,160,
  	3461,8,160,1,161,1,161,1,161,1,161,3,161,3467,8,161,1,161,3,161,3470,
  	8,161,1,161,3,161,3473,8,161,1,161,1,161,1,161,1,161,3,161,3479,8,161,
  	1,161,1,161,1,161,3,161,3484,8,161,5,161,3486,8,161,10,161,12,161,3489,
  	9,161,3,161,3491,8,161,1,162,1,162,1,162,1,162,1,162,1,162,3,162,3499,
  	8,162,3,162,3501,8,162,1,162,1,162,1,163,1,163,1,163,1,164,1,164,1,164,
  	1,164,1,165,1,165,1,165,1,165,5,165,3516,8,165,10,165,12,165,3519,9,165,
  	1,166,1,166,1,166,1,166,1,167,1,167,1,167,1,167,1,168,3,168,3530,8,168,
  	1,168,1,168,1,168,3,168,3535,8,168,1,168,3,168,3538,8,168,1,168,3,168,
  	3541,8,168,1,169,1,169,1,169,3,169,3546,8,169,1,170,1,170,1,171,1,171,
  	3,171,3552,8,171,1,172,1,172,1,172,1,172,1,172,1,172,1,172,1,172,1,172,
  	1,172,1,172,1,172,1,172,1,172,3,172,3568,8,172,1,173,1,173,1,173,1,173,
  	1,173,1,174,1,174,1,174,1,174,1,174,1,174,1,174,1,174,1,174,1,174,1,174,
  	1,174,1,174,3,174,3588,8,174,1,175,1,175,1,175,1,175,1,175,1,175,1,175,
  	3,175,3597,8,175,1,176,1,176,3,176,3601,8,176,1,176,1,176,1,176,5,176,
  	3606,8,176,10,176,12,176,3609,9,176,1,177,1,177,3,177,3613,8,177,1,177,
  	1,177,1,177,1,178,1,178,1,178,1,178,3,178,3622,8,178,1,178,1,178,1,178,
  	1,178,1,178,1,178,1,178,1,178,3,178,3632,8,178,1,179,1,179,1,179,1,179,
  	1,179,3,179,3639,8,179,1,180,1,180,1,180,1,180,1,181,1,181,1,182,1,182,
  	1,182,3,182,3650,8,182,1,183,1,183,1,183,5,183,3655,8,183,10,183,12,183,
  	3658,9,183,1,184,1,184,1,184,1,184,5,184,3664,8,184,10,184,12,184,3667,
  	9,184,1,185,1,185,1,185,1,186,1,186,1,186,3,186,3675,8,186,1,186,1,186,
  	1,187,1,187,1,187,1,187,1,187,1,187,1,187,1,187,3,187,3687,8,187,1,188,
  	1,188,4,188,3691,8,188,11,188,12,188,3692,1,189,1,189,1,189,1,189,1,189,
  	3,189,3700,8,189,1,189,1,189,3,189,3704,8,189,1,189,1,189,1,189,1,189,
  	3,189,3710,8,189,1,190,1,190,1,190,3,190,3715,8,190,1,191,1,191,1,191,
  	3,191,3720,8,191,1,192,1,192,3,192,3724,8,192,1,192,1,192,5,192,3728,
  	8,192,10,192,12,192,3731,9,192,1,193,1,193,1,193,3,193,3736,8,193,3,193,
  	3738,8,193,1,194,3,194,3741,8,194,1,194,1,194,3,194,3745,8,194,1,195,
  	1,195,1,195,1,196,1,196,1,196,1,196,1,196,3,196,3755,8,196,1,196,1,196,
  	1,196,3,196,3760,8,196,1,196,5,196,3763,8,196,10,196,12,196,3766,9,196,
  	1,197,1,197,5,197,3770,8,197,10,197,12,197,3773,9,197,1,198,1,198,1,198,
  	1,198,1,198,1,198,3,198,3781,8,198,1,198,1,198,1,198,1,198,1,198,1,198,
  	3,198,3789,8,198,1,198,1,198,1,198,3,198,3794,8,198,1,199,1,199,3,199,
  	3798,8,199,1,199,1,199,1,199,1,199,3,199,3804,8,199,1,199,3,199,3807,
  	8,199,1,200,3,200,3810,8,200,1,200,1,200,3,200,3814,8,200,1,201,1,201,
  	3,201,3818,8,201,1,201,1,201,1,202,1,202,1,202,1,202,1,202,1,202,3,202,
  	3828,8,202,1,203,1,203,3,203,3832,8,203,1,203,3,203,3835,8,203,1,203,
  	3,203,3838,8,203,1,203,3,203,3841,8,203,1,204,1,204,1,204,3,204,3846,
  	8,204,1,204,1,204,1,205,1,205,3,205,3852,8,205,1,205,1,205,3,205,3856,
  	8,205,1,205,1,205,1,205,1,205,3,205,3862,8,205,1,205,3,205,3865,8,205,
  	3,205,3867,8,205,1,206,1,206,1,206,3,206,3872,8,206,1,206,1,206,1,207,
  	1,207,1,207,1,207,1,207,1,207,1,207,1,207,3,207,3884,8,207,1,208,1,208,
  	1,208,1,208,1,208,5,208,3891,8,208,10,208,12,208,3894,9,208,1,208,1,208,
  	1,209,1,209,1,209,1,209,1,209,1,209,1,209,1,209,3,209,3906,8,209,1,209,
  	3,209,3909,8,209,1,209,1,209,1,209,3,209,3914,8,209,1,209,1,209,1,209,
  	1,209,1,209,3,209,3921,8,209,1,210,1,210,3,210,3925,8,210,1,210,3,210,
  	3928,8,210,1,211,1,211,1,211,1,211,3,211,3934,8,211,1,212,1,212,1,212,
  	1,212,1,213,1,213,1,213,1,213,1,214,1,214,1,214,1,214,3,214,3948,8,214,
  	1,215,1,215,1,216,1,216,1,216,3,216,3955,8,216,1,216,1,216,1,217,1,217,
  	1,217,5,217,3962,8,217,10,217,12,217,3965,9,217,1,218,1,218,1,218,3,218,
  	3970,8,218,1,218,1,218,1,218,1,218,1,218,1,218,1,218,3,218,3979,8,218,
  	1,218,1,218,3,218,3983,8,218,1,218,1,218,3,218,3987,8,218,1,219,1,219,
  	1,220,1,220,1,221,1,221,1,221,1,221,3,221,3997,8,221,3,221,3999,8,221,
  	1,222,1,222,1,222,1,222,1,222,1,222,3,222,4007,8,222,1,223,1,223,1,223,
  	5,223,4012,8,223,10,223,12,223,4015,9,223,1,224,1,224,3,224,4019,8,224,
  	1,225,1,225,3,225,4023,8,225,1,225,1,225,3,225,4027,8,225,1,225,3,225,
  	4030,8,225,1,225,1,225,1,225,1,225,3,225,4036,8,225,1,225,3,225,4039,
  	8,225,1,225,3,225,4042,8,225,1,226,1,226,1,226,1,226,3,226,4048,8,226,
  	1,227,1,227,1,227,5,227,4053,8,227,10,227,12,227,4056,9,227,1,227,1,227,
  	3,227,4060,8,227,1,227,1,227,3,227,4064,8,227,1,227,3,227,4067,8,227,
  	1,227,3,227,4070,8,227,1,227,3,227,4073,8,227,3,227,4075,8,227,1,228,
  	1,228,3,228,4079,8,228,1,229,1,229,1,229,1,229,1,229,3,229,4086,8,229,
  	1,230,1,230,1,230,1,230,3,230,4092,8,230,1,230,1,230,3,230,4096,8,230,
  	1,230,1,230,1,230,3,230,4101,8,230,1,230,3,230,4104,8,230,1,230,3,230,
  	4107,8,230,1,230,3,230,4110,8,230,3,230,4112,8,230,1,230,1,230,1,230,
  	3,230,4117,8,230,1,231,1,231,1,231,1,231,1,231,5,231,4124,8,231,10,231,
  	12,231,4127,9,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,
  	1,231,3,231,4139,8,231,3,231,4141,8,231,1,232,1,232,3,232,4145,8,232,
  	1,232,1,232,1,233,1,233,3,233,4151,8,233,1,233,3,233,4154,8,233,1,233,
  	3,233,4157,8,233,1,234,1,234,1,234,1,234,3,234,4163,8,234,1,234,1,234,
  	1,234,1,234,1,234,3,234,4170,8,234,3,234,4172,8,234,1,234,1,234,1,234,
  	1,234,1,234,1,234,3,234,4180,8,234,1,234,1,234,1,234,1,234,3,234,4186,
  	8,234,1,235,1,235,1,235,3,235,4191,8,235,1,235,3,235,4194,8,235,1,236,
  	1,236,1,236,1,236,1,236,3,236,4201,8,236,3,236,4203,8,236,1,237,1,237,
  	1,237,1,237,1,237,1,237,1,237,5,237,4212,8,237,10,237,12,237,4215,9,237,
  	1,237,1,237,1,237,1,237,3,237,4221,8,237,1,237,1,237,1,237,1,237,1,237,
  	1,237,3,237,4229,8,237,1,238,1,238,1,238,1,238,1,238,1,238,3,238,4237,
  	8,238,1,239,1,239,3,239,4241,8,239,1,239,1,239,1,239,1,239,1,239,3,239,
  	4248,8,239,1,239,3,239,4251,8,239,3,239,4253,8,239,1,240,1,240,1,240,
  	1,240,1,240,1,240,3,240,4261,8,240,1,241,1,241,1,241,1,241,1,242,1,242,
  	1,242,1,242,3,242,4271,8,242,1,242,1,242,1,242,1,243,1,243,1,243,1,243,
  	3,243,4280,8,243,1,244,1,244,1,244,1,244,1,244,3,244,4287,8,244,1,245,
  	1,245,1,245,5,245,4292,8,245,10,245,12,245,4295,9,245,1,246,1,246,1,246,
  	1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,
  	1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,
  	1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,
  	1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,
  	1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,
  	1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,
  	1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,
  	1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,
  	1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,
  	1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,1,246,
  	1,246,1,246,1,246,1,246,1,246,3,246,4425,8,246,1,247,1,247,1,248,1,248,
  	1,249,1,249,1,250,1,250,1,251,1,251,1,252,1,252,1,253,1,253,1,254,1,254,
  	1,255,1,255,1,256,1,256,1,257,1,257,1,258,1,258,1,259,1,259,1,260,1,260,
  	1,261,1,261,1,262,1,262,1,263,1,263,1,264,1,264,1,265,1,265,1,266,1,266,
  	1,267,1,267,1,268,1,268,1,269,1,269,1,270,1,270,1,271,1,271,1,272,1,272,
  	3,272,4479,8,272,1,273,1,273,1,274,1,274,1,274,3,274,4486,8,274,1,275,
  	1,275,3,275,4490,8,275,1,276,1,276,1,276,1,276,1,276,1,276,1,276,1,276,
  	1,276,1,276,1,276,1,276,1,276,1,276,3,276,4506,8,276,1,277,1,277,1,278,
  	1,278,1,279,1,279,1,279,1,279,5,279,4516,8,279,10,279,12,279,4519,9,279,
  	3,279,4521,8,279,1,279,1,279,1,280,1,280,1,280,1,280,1,280,1,280,5,280,
  	4531,8,280,10,280,12,280,4534,9,280,1,280,1,280,3,280,4538,8,280,1,281,
  	1,281,1,281,1,281,3,281,4544,8,281,1,281,1,281,1,281,1,281,1,281,3,281,
  	4551,8,281,1,281,1,281,1,281,1,281,1,281,3,281,4558,8,281,1,281,1,281,
  	1,281,1,281,1,281,3,281,4565,8,281,1,281,1,281,1,281,1,281,1,281,3,281,
  	4572,8,281,1,281,1,281,1,281,1,281,1,281,3,281,4579,8,281,1,281,1,281,
  	1,281,1,281,1,281,3,281,4586,8,281,1,281,3,281,4589,8,281,1,282,1,282,
  	1,282,5,282,4594,8,282,10,282,12,282,4597,9,282,1,283,1,283,1,283,5,283,
  	4602,8,283,10,283,12,283,4605,9,283,1,284,1,284,1,284,5,284,4610,8,284,
  	10,284,12,284,4613,9,284,1,285,1,285,1,286,1,286,1,286,5,286,4620,8,286,
  	10,286,12,286,4623,9,286,1,287,1,287,1,287,3,287,4628,8,287,1,287,1,287,
  	3,287,4632,8,287,1,287,3,287,4635,8,287,1,287,3,287,4638,8,287,1,287,
  	3,287,4641,8,287,1,287,3,287,4644,8,287,1,287,3,287,4647,8,287,1,288,
  	1,288,1,288,3,288,4652,8,288,1,288,3,288,4655,8,288,1,289,1,289,1,289,
  	1,289,1,289,3,289,4662,8,289,1,289,1,289,5,289,4666,8,289,10,289,12,289,
  	4669,9,289,1,290,1,290,1,290,1,290,1,291,1,291,1,291,1,291,1,292,1,292,
  	1,292,1,292,1,293,1,293,1,293,1,293,1,294,1,294,1,294,5,294,4690,8,294,
  	10,294,12,294,4693,9,294,1,295,1,295,1,296,1,296,1,296,1,296,3,296,4701,
  	8,296,1,296,1,296,3,296,4705,8,296,1,297,1,297,1,297,5,297,4710,8,297,
  	10,297,12,297,4713,9,297,1,298,1,298,1,298,3,298,4718,8,298,1,299,1,299,
  	1,299,1,299,1,300,1,300,1,300,1,300,1,301,1,301,1,301,1,301,1,302,1,302,
  	1,303,1,303,1,303,1,303,1,303,3,303,4739,8,303,1,303,1,303,1,303,1,303,
  	3,303,4745,8,303,1,304,1,304,1,304,1,304,3,304,4751,8,304,1,305,1,305,
  	1,305,5,305,4756,8,305,10,305,12,305,4759,9,305,1,306,1,306,1,306,1,306,
  	1,306,3,306,4766,8,306,1,306,1,306,1,306,1,306,3,306,4772,8,306,1,306,
  	1,306,1,306,1,306,1,306,1,306,1,306,1,306,1,306,1,306,3,306,4784,8,306,
  	3,306,4786,8,306,1,307,1,307,1,307,1,307,3,307,4792,8,307,1,307,1,307,
  	3,307,4796,8,307,3,307,4798,8,307,1,308,1,308,3,308,4802,8,308,1,308,
  	1,308,1,309,1,309,1,309,1,309,1,309,1,309,1,309,1,309,3,309,4814,8,309,
  	1,310,1,310,1,310,1,310,3,310,4820,8,310,1,310,1,310,1,310,1,310,3,310,
  	4826,8,310,1,310,1,310,1,310,1,310,1,310,1,310,3,310,4834,8,310,1,310,
  	1,310,3,310,4838,8,310,1,310,1,310,3,310,4842,8,310,1,310,1,310,1,310,
  	1,310,3,310,4848,8,310,3,310,4850,8,310,1,310,1,310,1,310,1,310,1,310,
  	1,310,1,310,1,310,1,310,1,310,1,310,3,310,4863,8,310,1,310,1,310,3,310,
  	4867,8,310,3,310,4869,8,310,3,310,4871,8,310,1,311,1,311,1,311,5,311,
  	4876,8,311,10,311,12,311,4879,9,311,1,312,1,312,1,312,1,312,1,312,1,312,
  	1,312,1,312,3,312,4889,8,312,1,312,3,312,4892,8,312,3,312,4894,8,312,
  	1,312,1,312,3,312,4898,8,312,1,312,1,312,1,312,3,312,4903,8,312,3,312,
  	4905,8,312,1,312,1,312,1,312,3,312,4910,8,312,1,312,1,312,1,312,1,312,
  	3,312,4916,8,312,1,312,3,312,4919,8,312,3,312,4921,8,312,1,312,1,312,
  	3,312,4925,8,312,1,312,3,312,4928,8,312,1,312,1,312,1,312,1,312,1,312,
  	1,312,1,312,1,312,3,312,4938,8,312,1,312,1,312,1,312,1,312,1,312,1,312,
  	1,312,1,312,3,312,4948,8,312,1,312,1,312,1,312,1,312,1,312,3,312,4955,
  	8,312,3,312,4957,8,312,3,312,4959,8,312,1,313,1,313,1,313,1,313,1,313,
  	1,313,3,313,4967,8,313,1,313,1,313,3,313,4971,8,313,1,313,1,313,1,313,
  	1,313,3,313,4977,8,313,1,313,3,313,4980,8,313,3,313,4982,8,313,1,313,
  	1,313,1,313,1,313,1,313,1,313,1,313,1,313,3,313,4992,8,313,1,313,1,313,
  	3,313,4996,8,313,1,313,1,313,1,313,1,313,3,313,5002,8,313,1,313,1,313,
  	1,313,1,313,1,313,3,313,5009,8,313,3,313,5011,8,313,1,313,1,313,1,313,
  	3,313,5016,8,313,3,313,5018,8,313,1,314,1,314,1,314,1,315,1,315,1,315,
  	1,315,3,315,5027,8,315,1,315,1,315,1,315,1,315,1,316,1,316,3,316,5035,
  	8,316,1,316,3,316,5038,8,316,1,316,5,316,5041,8,316,10,316,12,316,5044,
  	9,316,1,316,1,316,3,316,5048,8,316,1,316,3,316,5051,8,316,1,317,1,317,
  	1,317,1,317,3,317,5057,8,317,1,318,1,318,1,318,1,318,3,318,5063,8,318,
  	1,318,3,318,5066,8,318,1,319,1,319,1,319,3,319,5071,8,319,1,320,1,320,
  	1,320,1,320,1,320,1,320,1,320,1,320,1,320,4,320,5082,8,320,11,320,12,
  	320,5083,1,321,1,321,1,321,1,321,1,321,1,321,1,321,1,321,1,321,1,321,
  	3,321,5096,8,321,1,321,1,321,1,321,3,321,5101,8,321,1,321,1,321,1,321,
  	1,321,1,321,1,321,3,321,5109,8,321,1,321,1,321,1,321,1,321,3,321,5115,
  	8,321,3,321,5117,8,321,1,321,1,321,1,321,1,321,1,321,1,321,1,321,3,321,
  	5126,8,321,3,321,5128,8,321,1,322,1,322,1,322,1,322,3,322,5134,8,322,
  	1,322,1,322,1,323,1,323,1,323,1,323,1,323,1,323,1,323,1,323,3,323,5146,
  	8,323,1,323,1,323,1,323,3,323,5151,8,323,3,323,5153,8,323,1,323,1,323,
  	3,323,5157,8,323,1,323,1,323,1,323,1,323,3,323,5163,8,323,1,323,3,323,
  	5166,8,323,1,323,3,323,5169,8,323,1,323,1,323,1,323,1,323,1,323,1,323,
  	1,323,1,323,3,323,5179,8,323,3,323,5181,8,323,1,324,1,324,1,324,1,324,
  	3,324,5187,8,324,1,325,1,325,1,325,1,326,1,326,1,326,1,327,1,327,1,327,
  	1,327,1,327,3,327,5200,8,327,1,327,1,327,3,327,5204,8,327,1,328,1,328,
  	1,328,3,328,5209,8,328,1,329,1,329,1,329,1,330,1,330,1,330,1,330,1,330,
  	1,330,1,330,1,330,1,330,1,330,5,330,5224,8,330,10,330,12,330,5227,9,330,
  	1,331,1,331,1,331,3,331,5232,8,331,1,331,1,331,1,331,1,331,1,331,1,331,
  	1,331,1,331,3,331,5242,8,331,1,331,1,331,1,331,1,331,1,331,1,331,3,331,
  	5250,8,331,1,331,1,331,1,331,3,331,5255,8,331,1,331,1,331,1,331,1,331,
  	3,331,5261,8,331,1,331,1,331,1,331,1,331,1,331,1,331,1,331,1,331,3,331,
  	5271,8,331,1,331,1,331,3,331,5275,8,331,1,332,1,332,1,333,1,333,1,333,
  	5,333,5282,8,333,10,333,12,333,5285,9,333,1,334,1,334,1,334,3,334,5290,
  	8,334,1,334,1,334,1,334,1,334,3,334,5296,8,334,3,334,5298,8,334,1,334,
  	1,334,3,334,5302,8,334,1,334,1,334,1,334,1,334,1,334,1,334,1,334,1,334,
  	1,334,3,334,5313,8,334,1,334,1,334,1,334,1,334,1,334,3,334,5320,8,334,
  	1,334,1,334,1,334,1,334,3,334,5326,8,334,1,334,1,334,1,334,3,334,5331,
  	8,334,1,335,1,335,1,335,3,335,5336,8,335,1,335,1,335,1,335,3,335,5341,
  	8,335,1,335,1,335,1,335,1,335,1,335,1,335,3,335,5349,8,335,1,336,1,336,
  	3,336,5353,8,336,1,336,5,336,5356,8,336,10,336,12,336,5359,9,336,1,337,
  	1,337,1,337,1,337,1,337,1,337,3,337,5367,8,337,1,338,1,338,1,338,1,338,
  	1,338,1,338,1,338,1,338,1,338,1,338,1,338,3,338,5380,8,338,3,338,5382,
  	8,338,1,339,1,339,1,339,1,339,1,339,1,339,1,339,1,339,1,339,1,339,1,339,
  	1,339,3,339,5396,8,339,1,339,1,339,1,339,1,339,1,339,1,339,1,339,3,339,
  	5405,8,339,3,339,5407,8,339,1,340,1,340,1,340,5,340,5412,8,340,10,340,
  	12,340,5415,9,340,1,341,1,341,1,341,1,341,3,341,5421,8,341,3,341,5423,
  	8,341,1,342,1,342,3,342,5427,8,342,1,342,1,342,1,342,1,342,3,342,5433,
  	8,342,1,342,1,342,1,342,1,342,5,342,5439,8,342,10,342,12,342,5442,9,342,
  	1,342,1,342,1,342,1,342,3,342,5448,8,342,1,342,1,342,3,342,5452,8,342,
  	1,342,1,342,1,342,1,342,3,342,5458,8,342,1,342,1,342,1,342,5,342,5463,
  	8,342,10,342,12,342,5466,9,342,3,342,5468,8,342,1,343,1,343,1,343,1,343,
  	1,344,3,344,5475,8,344,1,344,3,344,5478,8,344,1,344,1,344,1,344,1,344,
  	3,344,5484,8,344,1,345,1,345,1,345,1,345,1,346,1,346,1,346,1,346,1,346,
  	1,346,1,346,1,346,1,346,1,346,3,346,5500,8,346,1,347,1,347,1,347,3,347,
  	5505,8,347,1,348,1,348,1,349,1,349,1,349,1,349,1,349,1,349,1,349,5,349,
  	5516,8,349,10,349,12,349,5519,9,349,3,349,5521,8,349,1,350,1,350,1,350,
  	1,350,1,350,1,350,1,350,1,350,1,350,3,350,5532,8,350,3,350,5534,8,350,
  	1,351,1,351,1,352,1,352,3,352,5540,8,352,1,353,1,353,1,353,1,353,1,353,
  	1,354,1,354,1,354,1,354,1,354,5,354,5552,8,354,10,354,12,354,5555,9,354,
  	1,355,1,355,1,355,1,356,1,356,1,356,1,356,1,356,1,356,1,356,1,356,1,356,
  	1,356,1,356,3,356,5571,8,356,1,356,1,356,1,356,3,356,5576,8,356,1,356,
  	3,356,5579,8,356,1,356,1,356,3,356,5583,8,356,1,356,3,356,5586,8,356,
  	1,356,1,356,1,356,1,356,1,356,1,356,1,356,1,356,1,356,1,356,1,356,1,356,
  	3,356,5600,8,356,1,356,1,356,1,356,1,356,3,356,5606,8,356,1,356,1,356,
  	1,356,3,356,5611,8,356,1,356,3,356,5614,8,356,3,356,5616,8,356,1,357,
  	1,357,3,357,5620,8,357,1,357,1,357,1,357,3,357,5625,8,357,3,357,5627,
  	8,357,1,358,1,358,1,358,1,359,1,359,1,359,1,359,1,359,1,359,1,359,3,359,
  	5639,8,359,1,360,1,360,5,360,5643,8,360,10,360,12,360,5646,9,360,1,361,
  	1,361,1,361,1,361,1,361,1,361,1,361,1,361,1,361,1,361,1,361,1,361,3,361,
  	5660,8,361,1,361,1,361,1,361,1,361,1,361,1,361,1,361,1,361,1,361,1,361,
  	3,361,5672,8,361,1,361,1,361,3,361,5676,8,361,3,361,5678,8,361,1,362,
  	1,362,1,362,1,362,1,362,1,362,3,362,5686,8,362,1,363,1,363,1,363,1,363,
  	1,363,3,363,5693,8,363,1,364,1,364,1,364,1,364,1,365,1,365,1,365,1,365,
  	1,365,1,365,1,365,1,365,1,365,3,365,5708,8,365,1,366,1,366,1,366,3,366,
  	5713,8,366,1,367,1,367,3,367,5717,8,367,1,367,1,367,3,367,5721,8,367,
  	1,367,3,367,5724,8,367,1,368,1,368,3,368,5728,8,368,1,368,1,368,3,368,
  	5732,8,368,1,368,3,368,5735,8,368,1,369,1,369,1,369,3,369,5740,8,369,
  	1,369,3,369,5743,8,369,1,370,1,370,1,370,1,370,3,370,5749,8,370,1,370,
  	3,370,5752,8,370,1,371,1,371,1,371,1,371,3,371,5758,8,371,1,371,3,371,
  	5761,8,371,1,372,1,372,1,372,1,372,1,372,1,373,1,373,1,373,1,374,1,374,
  	1,374,1,374,1,374,1,375,1,375,1,375,1,375,1,375,1,376,1,376,1,376,1,376,
  	1,376,1,377,1,377,3,377,5788,8,377,1,377,1,377,1,377,1,377,3,377,5794,
  	8,377,1,377,3,377,5797,8,377,1,378,1,378,1,378,1,378,1,379,1,379,1,379,
  	1,379,1,379,1,380,1,380,1,380,1,380,3,380,5812,8,380,1,381,1,381,1,381,
  	1,381,1,381,3,381,5819,8,381,1,381,1,381,3,381,5823,8,381,1,381,3,381,
  	5826,8,381,1,381,3,381,5829,8,381,1,382,1,382,1,382,1,382,1,382,3,382,
  	5836,8,382,1,382,1,382,3,382,5840,8,382,1,382,3,382,5843,8,382,1,382,
  	3,382,5846,8,382,1,383,1,383,1,383,3,383,5851,8,383,1,383,1,383,1,383,
  	1,383,3,383,5857,8,383,1,383,3,383,5860,8,383,1,384,1,384,3,384,5864,
  	8,384,1,384,1,384,1,385,1,385,1,385,1,385,1,385,1,385,1,385,1,386,1,386,
  	1,386,1,386,1,386,1,386,1,386,1,387,1,387,1,387,3,387,5885,8,387,1,388,
  	1,388,1,388,3,388,5890,8,388,1,389,1,389,1,389,1,390,1,390,1,390,3,390,
  	5898,8,390,1,390,1,390,1,390,3,390,5903,8,390,1,390,3,390,5906,8,390,
  	1,391,1,391,3,391,5910,8,391,1,391,1,391,3,391,5914,8,391,1,392,1,392,
  	3,392,5918,8,392,1,392,1,392,1,393,1,393,3,393,5924,8,393,1,393,1,393,
  	3,393,5928,8,393,1,394,1,394,1,394,3,394,5933,8,394,1,395,1,395,1,395,
  	3,395,5938,8,395,1,396,1,396,1,396,1,397,1,397,1,397,1,397,1,397,1,397,
  	3,397,5949,8,397,3,397,5951,8,397,1,398,1,398,1,398,1,398,3,398,5957,
  	8,398,1,398,1,398,1,399,1,399,1,399,1,399,1,399,1,400,1,400,1,400,1,400,
  	1,400,1,401,1,401,1,401,1,401,1,402,1,402,1,402,1,402,1,402,3,402,5980,
  	8,402,1,402,3,402,5983,8,402,1,403,1,403,1,403,1,403,1,403,1,404,1,404,
  	1,404,1,404,1,404,1,405,1,405,1,405,1,405,1,405,1,406,1,406,1,406,1,406,
  	1,406,3,406,6005,8,406,1,407,1,407,1,407,1,407,1,407,3,407,6012,8,407,
  	1,408,1,408,1,408,1,408,1,408,1,408,1,409,1,409,1,409,1,409,1,409,1,409,
  	1,410,1,410,1,410,1,410,1,410,1,411,1,411,1,411,1,411,1,411,1,412,1,412,
  	1,412,1,412,3,412,6040,8,412,3,412,6042,8,412,1,413,1,413,3,413,6046,
  	8,413,1,414,1,414,1,415,1,415,1,415,1,416,1,416,1,416,5,416,6056,8,416,
  	10,416,12,416,6059,9,416,1,417,1,417,1,417,1,417,1,417,1,417,1,417,3,
  	417,6068,8,417,1,418,1,418,1,418,1,418,1,418,1,418,1,418,1,418,3,418,
  	6078,8,418,1,418,1,418,3,418,6082,8,418,1,418,1,418,1,418,1,418,5,418,
  	6088,8,418,10,418,12,418,6091,9,418,3,418,6093,8,418,1,418,1,418,3,418,
  	6097,8,418,1,418,1,418,1,418,1,418,1,418,1,418,1,418,1,418,3,418,6107,
  	8,418,1,419,1,419,3,419,6111,8,419,1,420,1,420,1,420,5,420,6116,8,420,
  	10,420,12,420,6119,9,420,1,421,1,421,3,421,6123,8,421,1,422,1,422,1,422,
  	1,422,1,422,1,422,3,422,6131,8,422,1,423,1,423,1,423,3,423,6136,8,423,
  	1,423,1,423,1,424,1,424,3,424,6142,8,424,1,425,1,425,1,425,5,425,6147,
  	8,425,10,425,12,425,6150,9,425,1,426,1,426,3,426,6154,8,426,1,426,1,426,
  	1,426,1,426,3,426,6160,8,426,1,426,1,426,1,426,1,426,1,426,3,426,6167,
  	8,426,1,427,1,427,1,428,1,428,1,428,1,428,1,428,1,428,3,428,6177,8,428,
  	3,428,6179,8,428,1,429,1,429,1,429,1,429,1,429,3,429,6186,8,429,1,430,
  	1,430,1,430,3,430,6191,8,430,1,430,1,430,3,430,6195,8,430,1,430,3,430,
  	6198,8,430,1,431,1,431,1,431,5,431,6203,8,431,10,431,12,431,6206,9,431,
  	1,432,1,432,3,432,6210,8,432,1,432,1,432,3,432,6214,8,432,1,433,1,433,
  	1,433,1,433,1,433,1,434,1,434,1,434,1,434,3,434,6225,8,434,1,435,1,435,
  	1,435,1,435,1,435,1,435,3,435,6233,8,435,1,435,1,435,3,435,6237,8,435,
  	1,435,3,435,6240,8,435,1,435,3,435,6243,8,435,1,436,1,436,3,436,6247,
  	8,436,1,436,1,436,3,436,6251,8,436,1,436,5,436,6254,8,436,10,436,12,436,
  	6257,9,436,1,437,1,437,1,437,3,437,6262,8,437,1,438,1,438,3,438,6266,
  	8,438,1,438,1,438,1,439,1,439,1,440,1,440,1,440,1,440,1,440,3,440,6277,
  	8,440,1,440,3,440,6280,8,440,1,440,3,440,6283,8,440,1,440,3,440,6286,
  	8,440,1,441,1,441,1,441,1,441,1,441,1,441,3,441,6294,8,441,1,442,1,442,
  	3,442,6298,8,442,1,442,5,442,6301,8,442,10,442,12,442,6304,9,442,1,443,
  	1,443,1,443,1,443,1,443,3,443,6311,8,443,1,444,1,444,1,444,1,444,1,444,
  	1,444,3,444,6319,8,444,1,445,1,445,1,445,1,445,3,445,6325,8,445,1,446,
  	1,446,3,446,6329,8,446,1,446,1,446,1,446,1,446,3,446,6335,8,446,1,446,
  	1,446,1,447,1,447,1,447,1,447,1,447,3,447,6344,8,447,1,447,1,447,1,447,
  	1,447,1,447,1,447,1,447,1,447,1,447,1,447,1,447,3,447,6357,8,447,1,448,
  	1,448,1,448,1,448,1,448,1,448,1,448,1,448,3,448,6367,8,448,1,449,1,449,
  	1,449,1,449,1,450,1,450,1,450,1,451,1,451,1,451,1,452,1,452,1,453,1,453,
  	1,453,1,453,3,453,6385,8,453,1,453,3,453,6388,8,453,1,453,1,453,3,453,
  	6392,8,453,1,453,1,453,1,453,1,453,1,453,1,453,1,453,1,453,1,453,5,453,
  	6403,8,453,10,453,12,453,6406,9,453,1,454,1,454,1,454,1,454,1,454,1,454,
  	3,454,6414,8,454,1,454,1,454,1,454,1,454,1,454,1,454,1,454,1,454,1,454,
  	1,454,5,454,6426,8,454,10,454,12,454,6429,9,454,1,455,1,455,1,456,1,456,
  	3,456,6435,8,456,1,456,1,456,1,456,1,456,3,456,6441,8,456,1,456,1,456,
  	1,456,1,456,3,456,6447,8,456,1,457,1,457,1,457,1,457,1,457,1,457,3,457,
  	6455,8,457,1,457,1,457,1,457,1,457,1,457,1,457,1,457,1,457,1,457,3,457,
  	6466,8,457,1,457,1,457,3,457,6470,8,457,1,458,1,458,1,458,1,458,1,458,
  	1,458,1,458,1,458,1,458,1,458,1,458,1,458,1,458,1,458,1,458,1,458,1,458,
  	1,458,1,458,1,458,1,458,1,458,1,458,1,458,1,458,1,458,1,458,5,458,6499,
  	8,458,10,458,12,458,6502,9,458,1,459,1,459,1,459,3,459,6507,8,459,1,459,
  	1,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,
  	1,459,1,459,1,459,1,459,3,459,6526,8,459,1,459,1,459,1,459,1,459,1,459,
  	3,459,6533,8,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,
  	1,459,1,459,1,459,3,459,6547,8,459,1,459,1,459,1,459,1,459,1,459,1,459,
  	1,459,1,459,1,459,3,459,6558,8,459,1,459,1,459,1,459,3,459,6563,8,459,
  	1,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,3,459,6575,
  	8,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,3,459,6585,8,459,
  	1,459,1,459,1,459,4,459,6590,8,459,11,459,12,459,6591,1,459,3,459,6595,
  	8,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,
  	1,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,
  	1,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,1,459,3,459,6629,8,459,
  	1,459,1,459,1,459,1,459,1,459,1,459,5,459,6637,8,459,10,459,12,459,6640,
  	9,459,1,460,1,460,1,460,1,461,1,461,1,461,1,461,1,461,1,461,3,461,6651,
  	8,461,1,462,1,462,1,462,3,462,6656,8,462,1,462,1,462,1,462,1,462,3,462,
  	6662,8,462,1,462,1,462,1,462,1,462,1,462,1,462,3,462,6670,8,462,1,462,
  	1,462,1,462,1,462,1,462,1,462,3,462,6678,8,462,1,462,1,462,1,462,3,462,
  	6683,8,462,1,462,1,462,1,462,3,462,6688,8,462,1,462,1,462,1,462,1,462,
  	3,462,6694,8,462,1,462,1,462,1,462,3,462,6699,8,462,1,462,1,462,1,462,
  	3,462,6704,8,462,1,462,1,462,1,462,1,462,3,462,6710,8,462,1,462,1,462,
  	1,462,1,462,1,462,1,462,3,462,6718,8,462,1,462,1,462,1,462,1,462,1,462,
  	1,462,1,462,3,462,6727,8,462,1,462,1,462,1,462,3,462,6732,8,462,1,462,
  	1,462,3,462,6736,8,462,1,462,1,462,3,462,6740,8,462,1,462,1,462,1,462,
  	3,462,6745,8,462,3,462,6747,8,462,1,463,1,463,1,463,1,463,1,463,1,464,
  	1,464,1,464,1,464,1,464,1,464,1,464,1,464,1,464,1,464,1,464,3,464,6765,
  	8,464,1,464,1,464,1,464,1,464,1,464,1,464,3,464,6773,8,464,1,464,1,464,
  	3,464,6777,8,464,1,464,1,464,1,464,1,464,1,464,3,464,6784,8,464,1,464,
  	1,464,1,464,1,464,1,464,1,464,1,464,1,464,1,464,1,464,3,464,6796,8,464,
  	1,464,3,464,6799,8,464,1,464,1,464,3,464,6803,8,464,1,465,1,465,1,466,
  	1,466,1,466,1,466,3,466,6811,8,466,1,467,1,467,1,467,1,467,1,467,1,467,
  	1,467,1,468,1,468,1,468,3,468,6823,8,468,1,469,1,469,1,469,1,469,1,469,
  	3,469,6830,8,469,1,469,1,469,3,469,6834,8,469,1,470,1,470,3,470,6838,
  	8,470,1,471,1,471,1,471,3,471,6843,8,471,1,472,1,472,1,472,1,473,1,473,
  	1,473,1,473,1,473,3,473,6853,8,473,1,473,1,473,1,473,1,473,1,473,1,473,
  	1,473,3,473,6862,8,473,3,473,6864,8,473,1,474,3,474,6867,8,474,1,474,
  	1,474,1,475,1,475,1,475,1,475,1,475,3,475,6876,8,475,1,476,1,476,1,476,
  	5,476,6881,8,476,10,476,12,476,6884,9,476,1,477,1,477,1,477,1,477,1,477,
  	1,477,1,477,1,477,1,477,1,477,3,477,6896,8,477,1,477,1,477,1,477,3,477,
  	6901,8,477,1,478,1,478,1,478,1,478,1,478,3,478,6908,8,478,1,478,1,478,
  	1,478,1,478,3,478,6914,8,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,
  	1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,
  	1,478,1,478,1,478,4,478,6938,8,478,11,478,12,478,6939,1,478,1,478,1,478,
  	1,478,1,478,1,478,1,478,1,478,1,478,3,478,6951,8,478,1,478,1,478,1,478,
  	1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,
  	1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,
  	1,478,1,478,1,478,3,478,6983,8,478,1,478,1,478,1,478,1,478,1,478,1,478,
  	1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,3,478,
  	7002,8,478,1,478,1,478,1,478,1,478,3,478,7008,8,478,1,478,1,478,3,478,
  	7012,8,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,
  	1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,
  	1,478,1,478,1,478,1,478,1,478,1,478,1,478,3,478,7043,8,478,1,478,1,478,
  	1,478,1,478,3,478,7049,8,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,
  	1,478,1,478,1,478,3,478,7061,8,478,1,478,1,478,1,478,1,478,1,478,1,478,
  	1,478,1,478,1,478,1,478,1,478,3,478,7074,8,478,1,478,1,478,3,478,7078,
  	8,478,1,478,1,478,3,478,7082,8,478,1,478,1,478,1,478,1,478,1,478,1,478,
  	1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,
  	1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,3,478,7110,8,478,1,478,
  	1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,
  	1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,
  	1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,
  	1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,3,478,
  	7160,8,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,3,478,7170,
  	8,478,1,478,1,478,3,478,7174,8,478,1,478,1,478,1,478,1,478,1,478,1,478,
  	1,478,1,478,1,478,1,478,3,478,7186,8,478,1,478,1,478,1,478,3,478,7191,
  	8,478,1,479,1,479,1,479,1,480,1,480,1,480,1,480,1,480,1,480,1,480,1,480,
  	1,480,1,480,1,480,3,480,7207,8,480,1,480,1,480,1,480,1,480,1,480,1,480,
  	1,480,1,480,1,480,1,480,1,480,1,480,1,480,1,480,1,480,1,480,1,480,1,480,
  	3,480,7227,8,480,1,481,1,481,3,481,7231,8,481,1,481,1,481,1,482,1,482,
  	1,483,1,483,1,483,1,483,1,483,1,483,1,483,1,483,5,483,7245,8,483,10,483,
  	12,483,7248,9,483,3,483,7250,8,483,1,484,1,484,1,484,3,484,7255,8,484,
  	1,484,3,484,7258,8,484,1,485,1,485,1,486,1,486,1,486,1,486,1,486,3,486,
  	7267,8,486,1,486,1,486,3,486,7271,8,486,1,486,1,486,1,486,1,486,3,486,
  	7277,8,486,1,486,1,486,1,486,1,486,3,486,7283,8,486,1,486,1,486,3,486,
  	7287,8,486,1,486,1,486,1,487,1,487,1,487,1,487,1,487,1,487,1,487,3,487,
  	7298,8,487,1,487,1,487,1,487,1,487,3,487,7304,8,487,3,487,7306,8,487,
  	1,487,1,487,1,488,1,488,1,488,3,488,7313,8,488,1,488,1,488,1,488,1,488,
  	1,488,3,488,7320,8,488,1,488,1,488,3,488,7324,8,488,1,489,1,489,1,489,
  	5,489,7329,8,489,10,489,12,489,7332,9,489,1,490,1,490,3,490,7336,8,490,
  	1,491,1,491,1,491,1,492,1,492,3,492,7343,8,492,1,493,1,493,1,493,1,493,
  	1,494,1,494,1,494,1,494,3,494,7353,8,494,1,494,3,494,7356,8,494,1,495,
  	1,495,3,495,7360,8,495,1,495,1,495,1,495,3,495,7365,8,495,3,495,7367,
  	8,495,1,495,1,495,3,495,7371,8,495,1,496,1,496,3,496,7375,8,496,1,497,
  	1,497,1,497,1,498,1,498,1,498,1,499,1,499,1,499,1,500,1,500,3,500,7388,
  	8,500,1,500,1,500,3,500,7392,8,500,1,500,3,500,7395,8,500,1,500,1,500,
  	3,500,7399,8,500,1,500,1,500,3,500,7403,8,500,1,500,1,500,3,500,7407,
  	8,500,1,500,1,500,1,500,1,500,1,500,3,500,7414,8,500,1,500,1,500,3,500,
  	7418,8,500,1,500,1,500,3,500,7422,8,500,1,500,1,500,1,500,1,500,1,500,
  	1,500,1,500,3,500,7431,8,500,1,500,1,500,3,500,7435,8,500,1,501,1,501,
  	1,501,5,501,7440,8,501,10,501,12,501,7443,9,501,1,502,1,502,1,502,3,502,
  	7448,8,502,1,503,1,503,1,504,1,504,1,505,1,505,3,505,7456,8,505,1,506,
  	1,506,1,507,1,507,1,507,1,507,1,508,1,508,1,508,1,508,1,509,1,509,1,509,
  	1,509,1,510,1,510,1,510,5,510,7475,8,510,10,510,12,510,7478,9,510,1,511,
  	1,511,3,511,7482,8,511,1,512,1,512,1,512,5,512,7487,8,512,10,512,12,512,
  	7490,9,512,1,513,1,513,1,514,1,514,1,514,1,514,1,514,1,515,1,515,1,515,
  	1,515,1,515,1,515,1,515,1,515,1,515,1,515,1,515,1,515,1,515,3,515,7512,
  	8,515,1,516,1,516,1,516,1,517,1,517,1,517,1,517,1,517,1,518,1,518,1,518,
  	1,518,1,518,1,518,3,518,7528,8,518,1,519,1,519,1,519,1,520,1,520,1,520,
  	4,520,7536,8,520,11,520,12,520,7537,1,521,1,521,3,521,7542,8,521,1,521,
  	1,521,1,521,4,521,7547,8,521,11,521,12,521,7548,1,521,3,521,7552,8,521,
  	1,521,1,521,1,521,1,522,1,522,1,522,1,523,1,523,1,523,3,523,7563,8,523,
  	1,524,1,524,1,525,1,525,1,525,1,526,1,526,3,526,7572,8,526,1,526,3,526,
  	7575,8,526,1,526,1,526,1,527,1,527,1,527,3,527,7582,8,527,1,528,1,528,
  	1,528,3,528,7587,8,528,1,529,1,529,1,529,1,529,1,529,1,530,1,530,1,530,
  	1,530,1,530,1,530,1,530,1,531,1,531,1,531,1,531,1,531,1,531,1,531,1,532,
  	1,532,1,532,4,532,7611,8,532,11,532,12,532,7612,1,533,1,533,1,533,1,533,
  	3,533,7619,8,533,1,534,1,534,1,534,1,534,3,534,7625,8,534,1,534,1,534,
  	3,534,7629,8,534,1,535,1,535,1,535,1,535,1,535,1,535,1,536,1,536,3,536,
  	7639,8,536,1,537,1,537,3,537,7643,8,537,1,537,1,537,1,538,1,538,1,538,
  	1,538,1,538,1,538,1,538,5,538,7654,8,538,10,538,12,538,7657,9,538,1,538,
  	1,538,1,539,1,539,1,539,1,539,1,539,1,539,1,539,3,539,7668,8,539,1,540,
  	1,540,1,540,1,540,1,540,1,540,1,541,1,541,1,541,1,542,1,542,1,542,1,543,
  	1,543,3,543,7684,8,543,1,543,1,543,1,543,1,543,5,543,7690,8,543,10,543,
  	12,543,7693,9,543,1,543,1,543,1,543,1,543,1,543,5,543,7700,8,543,10,543,
  	12,543,7703,9,543,3,543,7705,8,543,1,544,1,544,1,544,3,544,7710,8,544,
  	1,545,1,545,3,545,7714,8,545,1,545,1,545,1,545,1,546,1,546,3,546,7721,
  	8,546,1,546,1,546,1,546,3,546,7726,8,546,1,547,1,547,1,548,1,548,1,548,
  	3,548,7733,8,548,1,548,1,548,1,548,1,548,5,548,7739,8,548,10,548,12,548,
  	7742,9,548,3,548,7744,8,548,1,549,1,549,1,549,3,549,7749,8,549,1,549,
  	1,549,1,549,1,549,5,549,7755,8,549,10,549,12,549,7758,9,549,3,549,7760,
  	8,549,1,550,1,550,1,550,1,550,1,551,1,551,1,551,1,552,1,552,1,552,1,553,
  	1,553,3,553,7774,8,553,1,553,3,553,7777,8,553,1,553,1,553,1,553,1,553,
  	1,554,1,554,1,554,1,554,1,554,1,554,1,554,3,554,7790,8,554,1,554,1,554,
  	3,554,7794,8,554,3,554,7796,8,554,1,555,1,555,1,555,3,555,7801,8,555,
  	1,556,1,556,1,556,3,556,7806,8,556,1,557,1,557,1,557,1,558,1,558,3,558,
  	7813,8,558,1,558,1,558,1,559,1,559,3,559,7819,8,559,1,559,1,559,5,559,
  	7823,8,559,10,559,12,559,7826,9,559,1,559,1,559,3,559,7830,8,559,1,559,
  	3,559,7833,8,559,1,559,1,559,5,559,7837,8,559,10,559,12,559,7840,9,559,
  	1,559,1,559,3,559,7844,8,559,1,559,3,559,7847,8,559,1,559,1,559,5,559,
  	7851,8,559,10,559,12,559,7854,9,559,1,559,3,559,7857,8,559,1,559,1,559,
  	1,559,1,559,3,559,7863,8,559,3,559,7865,8,559,1,559,3,559,7868,8,559,
  	1,559,1,559,5,559,7872,8,559,10,559,12,559,7875,9,559,1,559,1,559,1,559,
  	3,559,7880,8,559,1,559,1,559,1,559,1,559,1,559,3,559,7887,8,559,3,559,
  	7889,8,559,3,559,7891,8,559,1,560,1,560,3,560,7895,8,560,1,561,1,561,
  	5,561,7899,8,561,10,561,12,561,7902,9,561,1,561,1,561,3,561,7906,8,561,
  	1,561,1,561,3,561,7910,8,561,1,561,1,561,1,561,3,561,7915,8,561,1,561,
  	1,561,5,561,7919,8,561,10,561,12,561,7922,9,561,1,561,1,561,5,561,7926,
  	8,561,10,561,12,561,7929,9,561,3,561,7931,8,561,3,561,7933,8,561,1,562,
  	3,562,7936,8,562,1,562,1,562,1,562,1,562,1,562,1,562,1,562,1,562,3,562,
  	7946,8,562,1,562,1,562,1,562,1,562,3,562,7952,8,562,1,562,1,562,1,562,
  	1,562,1,562,3,562,7959,8,562,1,562,1,562,1,562,3,562,7964,8,562,1,562,
  	1,562,1,562,1,562,1,562,1,562,1,562,1,562,1,562,1,562,1,562,1,562,3,562,
  	7978,8,562,1,562,1,562,1,562,1,562,1,562,1,562,3,562,7986,8,562,1,562,
  	1,562,1,562,1,562,3,562,7992,8,562,1,562,1,562,1,562,3,562,7997,8,562,
  	1,563,1,563,1,564,1,564,1,565,1,565,1,565,1,566,1,566,3,566,8008,8,566,
  	1,567,1,567,3,567,8012,8,567,1,567,1,567,1,567,3,567,8017,8,567,1,567,
  	1,567,3,567,8021,8,567,1,567,3,567,8024,8,567,1,568,1,568,1,568,3,568,
  	8029,8,568,1,568,1,568,3,568,8033,8,568,1,568,1,568,1,568,1,568,1,568,
  	1,568,3,568,8041,8,568,1,568,1,568,1,568,1,568,1,568,1,568,3,568,8049,
  	8,568,3,568,8051,8,568,1,569,1,569,1,569,1,569,1,569,1,569,1,569,3,569,
  	8060,8,569,1,570,1,570,1,570,1,570,5,570,8066,8,570,10,570,12,570,8069,
  	9,570,1,570,1,570,1,571,1,571,3,571,8075,8,571,1,571,3,571,8078,8,571,
  	1,572,1,572,1,572,1,572,5,572,8084,8,572,10,572,12,572,8087,9,572,1,572,
  	1,572,1,573,1,573,1,573,1,573,3,573,8095,8,573,3,573,8097,8,573,1,574,
  	1,574,1,575,1,575,3,575,8103,8,575,1,576,1,576,3,576,8107,8,576,1,576,
  	1,576,1,576,1,576,1,576,1,576,1,576,1,576,3,576,8117,8,576,1,576,1,576,
  	1,576,1,576,3,576,8123,8,576,1,576,3,576,8126,8,576,1,577,1,577,1,578,
  	1,578,1,578,1,579,1,579,1,579,1,579,3,579,8137,8,579,1,580,1,580,1,581,
  	1,581,1,581,1,582,1,582,3,582,8146,8,582,1,582,3,582,8149,8,582,1,582,
  	1,582,1,582,3,582,8154,8,582,3,582,8156,8,582,1,582,3,582,8159,8,582,
  	1,582,3,582,8162,8,582,1,582,1,582,3,582,8166,8,582,1,582,3,582,8169,
  	8,582,1,582,1,582,3,582,8173,8,582,1,582,1,582,1,582,3,582,8178,8,582,
  	1,582,3,582,8181,8,582,1,582,1,582,3,582,8185,8,582,1,582,3,582,8188,
  	8,582,1,582,1,582,3,582,8192,8,582,1,582,1,582,1,582,3,582,8197,8,582,
  	1,582,1,582,3,582,8201,8,582,1,582,1,582,1,582,1,582,1,582,1,582,1,582,
  	1,582,1,582,1,582,3,582,8213,8,582,1,582,1,582,3,582,8217,8,582,1,582,
  	1,582,1,582,1,582,3,582,8223,8,582,1,582,3,582,8226,8,582,1,582,1,582,
  	1,582,3,582,8231,8,582,1,582,1,582,3,582,8235,8,582,1,582,1,582,3,582,
  	8239,8,582,1,582,1,582,1,582,3,582,8244,8,582,1,582,1,582,1,582,1,582,
  	1,582,1,582,1,582,3,582,8253,8,582,1,582,3,582,8256,8,582,1,582,1,582,
  	3,582,8260,8,582,1,582,1,582,3,582,8264,8,582,1,582,3,582,8267,8,582,
  	1,582,1,582,3,582,8271,8,582,1,582,1,582,3,582,8275,8,582,1,582,1,582,
  	1,582,3,582,8280,8,582,1,582,1,582,1,582,3,582,8285,8,582,1,582,1,582,
  	1,582,1,582,3,582,8291,8,582,1,583,1,583,1,583,3,583,8296,8,583,1,584,
  	1,584,1,584,3,584,8301,8,584,3,584,8303,8,584,1,585,1,585,1,585,3,585,
  	8308,8,585,1,585,1,585,1,586,4,586,8313,8,586,11,586,12,586,8314,1,587,
  	1,587,1,587,1,587,1,587,1,587,3,587,8323,8,587,1,587,1,587,1,587,1,587,
  	3,587,8329,8,587,3,587,8331,8,587,1,588,1,588,3,588,8335,8,588,1,588,
  	1,588,3,588,8339,8,588,1,589,1,589,3,589,8343,8,589,1,589,1,589,3,589,
  	8347,8,589,1,590,1,590,1,590,1,590,1,591,1,591,1,591,1,591,1,592,1,592,
  	1,592,1,592,1,592,3,592,8362,8,592,1,593,1,593,1,593,1,593,3,593,8368,
  	8,593,1,594,1,594,1,594,1,594,1,594,3,594,8375,8,594,1,595,1,595,3,595,
  	8379,8,595,1,595,5,595,8382,8,595,10,595,12,595,8385,9,595,1,596,1,596,
  	3,596,8389,8,596,1,596,3,596,8392,8,596,1,597,1,597,3,597,8396,8,597,
  	1,597,3,597,8399,8,597,1,598,4,598,8402,8,598,11,598,12,598,8403,1,599,
  	1,599,3,599,8408,8,599,1,599,1,599,1,599,1,599,3,599,8414,8,599,1,599,
  	1,599,3,599,8418,8,599,1,599,1,599,3,599,8422,8,599,1,599,1,599,1,599,
  	3,599,8427,8,599,1,599,1,599,1,599,3,599,8432,8,599,1,599,1,599,1,599,
  	3,599,8437,8,599,1,599,1,599,1,599,3,599,8442,8,599,1,599,1,599,1,599,
  	1,599,3,599,8448,8,599,1,599,1,599,1,599,1,599,3,599,8454,8,599,1,599,
  	1,599,1,599,3,599,8459,8,599,1,599,1,599,1,599,3,599,8464,8,599,1,599,
  	1,599,1,599,3,599,8469,8,599,1,599,1,599,1,599,3,599,8474,8,599,1,599,
  	1,599,1,599,3,599,8479,8,599,1,599,1,599,1,599,3,599,8484,8,599,1,599,
  	1,599,1,599,3,599,8489,8,599,1,599,1,599,1,599,1,599,1,599,1,599,1,599,
  	1,599,3,599,8499,8,599,1,599,1,599,1,599,1,599,3,599,8505,8,599,1,599,
  	1,599,1,599,1,599,3,599,8511,8,599,1,599,1,599,1,599,1,599,3,599,8517,
  	8,599,1,599,3,599,8520,8,599,1,599,1,599,1,599,1,599,1,599,3,599,8527,
  	8,599,1,599,1,599,1,599,3,599,8532,8,599,1,599,1,599,1,599,1,599,1,599,
  	1,599,1,599,3,599,8541,8,599,1,599,1,599,1,599,1,599,3,599,8547,8,599,
  	1,599,1,599,1,599,3,599,8552,8,599,1,600,1,600,3,600,8556,8,600,1,601,
  	3,601,8559,8,601,1,601,1,601,3,601,8563,8,601,1,601,1,601,1,602,3,602,
  	8568,8,602,1,602,1,602,3,602,8572,8,602,1,602,1,602,1,603,3,603,8577,
  	8,603,1,603,1,603,3,603,8581,8,603,1,603,1,603,1,604,1,604,1,604,1,604,
  	1,604,3,604,8590,8,604,1,604,3,604,8593,8,604,1,604,3,604,8596,8,604,
  	1,605,3,605,8599,8,605,1,605,1,605,3,605,8603,8,605,1,605,1,605,3,605,
  	8607,8,605,1,605,1,605,3,605,8611,8,605,1,605,1,605,1,605,1,605,1,605,
  	1,605,1,605,1,605,1,605,1,605,1,605,1,605,1,605,3,605,8626,8,605,1,605,
  	3,605,8629,8,605,3,605,8631,8,605,1,606,1,606,1,606,3,606,8636,8,606,
  	1,606,1,606,1,606,1,606,1,606,1,606,1,606,3,606,8645,8,606,1,606,3,606,
  	8648,8,606,1,606,1,606,3,606,8652,8,606,1,607,1,607,1,607,1,607,1,608,
  	1,608,1,608,1,608,5,608,8662,8,608,10,608,12,608,8665,9,608,1,608,1,608,
  	1,609,1,609,1,609,1,609,1,609,1,609,1,609,3,609,8676,8,609,1,609,1,609,
  	1,609,3,609,8681,8,609,1,609,5,609,8684,8,609,10,609,12,609,8687,9,609,
  	1,609,1,609,1,609,1,609,5,609,8693,8,609,10,609,12,609,8696,9,609,1,609,
  	1,609,3,609,8700,8,609,1,610,1,610,1,610,1,610,1,610,5,610,8707,8,610,
  	10,610,12,610,8710,9,610,1,610,1,610,3,610,8714,8,610,1,611,1,611,3,611,
  	8718,8,611,1,611,1,611,3,611,8722,8,611,1,611,1,611,3,611,8726,8,611,
  	1,611,1,611,1,611,3,611,8731,8,611,1,611,1,611,1,611,3,611,8736,8,611,
  	1,611,1,611,1,611,1,611,3,611,8742,8,611,1,611,1,611,1,611,3,611,8747,
  	8,611,1,611,3,611,8750,8,611,1,612,1,612,1,612,5,612,8755,8,612,10,612,
  	12,612,8758,9,612,1,613,1,613,1,613,1,613,5,613,8764,8,613,10,613,12,
  	613,8767,9,613,1,613,1,613,1,614,1,614,3,614,8773,8,614,1,615,1,615,1,
  	615,1,615,1,616,1,616,1,616,1,617,3,617,8783,8,617,1,617,1,617,1,618,
  	1,618,1,618,1,618,1,618,3,618,8792,8,618,3,618,8794,8,618,1,619,1,619,
  	1,619,1,619,1,620,1,620,1,620,1,620,1,621,3,621,8805,8,621,1,621,1,621,
  	1,622,1,622,1,622,1,623,1,623,1,623,1,624,1,624,3,624,8817,8,624,1,625,
  	1,625,1,625,1,625,1,625,1,625,1,626,1,626,1,626,5,626,8828,8,626,10,626,
  	12,626,8831,9,626,1,627,1,627,1,627,5,627,8836,8,627,10,627,12,627,8839,
  	9,627,1,628,1,628,1,628,1,628,3,628,8845,8,628,1,629,1,629,1,629,1,630,
  	1,630,4,630,8852,8,630,11,630,12,630,8853,1,631,1,631,1,631,1,631,3,631,
  	8860,8,631,1,631,1,631,1,631,1,631,1,631,1,631,3,631,8868,8,631,1,632,
  	1,632,4,632,8872,8,632,11,632,12,632,8873,1,633,1,633,1,633,1,633,1,634,
  	1,634,1,634,5,634,8883,8,634,10,634,12,634,8886,9,634,1,635,1,635,1,635,
  	5,635,8891,8,635,10,635,12,635,8894,9,635,1,636,1,636,1,636,1,636,3,636,
  	8900,8,636,1,636,1,636,1,636,3,636,8905,8,636,1,636,1,636,3,636,8909,
  	8,636,1,637,1,637,1,637,1,637,3,637,8915,8,637,1,638,1,638,1,638,1,638,
  	1,638,1,638,1,638,1,638,1,638,3,638,8926,8,638,1,639,1,639,1,639,1,639,
  	3,639,8932,8,639,1,639,1,639,1,640,1,640,1,640,1,640,1,640,1,641,1,641,
  	1,641,1,641,1,642,1,642,1,642,1,642,1,642,1,642,1,643,1,643,1,643,1,643,
  	1,643,1,643,1,644,1,644,1,644,1,644,1,644,1,644,1,644,1,645,1,645,1,645,
  	1,645,1,645,3,645,8969,8,645,1,646,1,646,1,646,1,646,1,647,1,647,1,647,
  	1,647,1,648,1,648,1,648,1,648,1,648,1,648,1,648,1,648,1,648,1,648,1,648,
  	1,648,1,648,1,648,1,648,3,648,8994,8,648,1,649,1,649,1,649,1,650,1,650,
  	1,650,1,651,1,651,1,651,1,651,3,651,9006,8,651,3,651,9008,8,651,1,652,
  	1,652,1,652,3,652,9013,8,652,3,652,9015,8,652,1,653,1,653,1,653,1,654,
  	1,654,3,654,9022,8,654,1,655,1,655,1,656,1,656,1,657,1,657,1,657,1,658,
  	1,658,1,658,3,658,9034,8,658,3,658,9036,8,658,1,659,1,659,1,659,1,659,
  	3,659,9042,8,659,1,660,1,660,1,661,1,661,1,661,1,661,5,661,9050,8,661,
  	10,661,12,661,9053,9,661,1,661,1,661,1,662,1,662,1,663,1,663,3,663,9061,
  	8,663,1,664,1,664,1,665,1,665,1,666,1,666,1,666,1,666,1,666,3,666,9072,
  	8,666,1,666,1,666,1,667,1,667,1,668,1,668,1,669,1,669,1,670,1,670,1,671,
  	1,671,1,672,1,672,1,673,1,673,1,674,1,674,1,675,1,675,3,675,9094,8,675,
  	1,676,1,676,3,676,9098,8,676,1,677,1,677,1,678,1,678,1,679,1,679,1,680,
  	1,680,1,681,1,681,1,682,1,682,1,683,1,683,1,684,1,684,1,685,1,685,1,686,
  	1,686,1,687,1,687,3,687,9122,8,687,1,688,1,688,1,688,1,689,1,689,1,689,
  	1,689,1,689,1,689,3,689,9133,8,689,3,689,9135,8,689,1,690,1,690,3,690,
  	9139,8,690,1,691,1,691,1,691,5,691,9144,8,691,10,691,12,691,9147,9,691,
  	1,692,1,692,1,692,5,692,9152,8,692,10,692,12,692,9155,9,692,1,693,1,693,
  	1,694,1,694,3,694,9161,8,694,1,695,1,695,1,696,1,696,3,696,9167,8,696,
  	1,697,1,697,1,698,1,698,1,699,1,699,1,700,1,700,1,701,1,701,1,701,3,701,
  	9180,8,701,1,702,1,702,3,702,9184,8,702,1,703,1,703,1,703,5,703,9189,
  	8,703,10,703,12,703,9192,9,703,1,704,1,704,1,704,1,704,1,705,1,705,3,
  	705,9200,8,705,1,706,1,706,1,706,3,706,9205,8,706,3,706,9207,8,706,1,
  	706,1,706,1,706,1,706,3,706,9213,8,706,1,707,1,707,1,707,1,708,1,708,
  	1,709,1,709,1,710,1,710,1,711,1,711,1,711,1,711,1,711,3,711,9229,8,711,
  	1,712,1,712,1,712,1,712,1,712,3,712,9236,8,712,1,713,1,713,1,713,3,713,
  	9241,8,713,1,714,1,714,1,714,1,714,1,714,1,714,3,714,9249,8,714,1,714,
  	3,714,9252,8,714,1,715,1,715,1,715,3,715,9257,8,715,1,716,1,716,1,717,
  	1,717,1,717,1,717,5,717,9265,8,717,10,717,12,717,9268,9,717,1,717,1,717,
  	1,718,1,718,1,718,3,718,9275,8,718,1,719,1,719,1,719,3,719,9280,8,719,
  	1,720,1,720,1,720,3,720,9285,8,720,1,721,3,721,9288,8,721,1,721,1,721,
  	3,721,9292,8,721,1,721,5,721,9295,8,721,10,721,12,721,9298,9,721,1,722,
  	1,722,1,723,1,723,1,723,5,723,9305,8,723,10,723,12,723,9308,9,723,1,724,
  	1,724,1,724,3,724,9313,8,724,1,725,1,725,1,726,1,726,1,727,1,727,1,728,
  	1,728,1,728,1,728,1,728,1,728,3,728,9327,8,728,1,729,1,729,3,729,9331,
  	8,729,1,730,1,730,1,731,1,731,1,731,1,731,1,731,1,731,1,732,1,732,3,732,
  	9343,8,732,1,733,1,733,3,733,9347,8,733,1,734,1,734,3,734,9351,8,734,
  	1,735,1,735,3,735,9355,8,735,1,736,1,736,1,736,1,737,1,737,1,738,1,738,
  	1,738,1,738,1,738,1,738,1,738,3,738,9369,8,738,1,739,1,739,1,739,1,739,
  	1,739,1,739,3,739,9377,8,739,1,740,1,740,1,740,1,740,1,740,1,740,1,740,
  	3,740,9386,8,740,1,740,1,740,1,741,1,741,1,742,1,742,1,742,1,742,1,742,
  	1,742,1,742,1,742,3,742,9400,8,742,1,742,1,742,1,742,1,742,1,742,3,742,
  	9407,8,742,3,742,9409,8,742,1,743,1,743,1,744,1,744,1,745,1,745,1,745,
  	1,745,1,745,1,745,1,745,1,745,1,745,1,745,1,745,3,745,9426,8,745,1,745,
  	1,745,1,745,3,745,9431,8,745,3,745,9433,8,745,1,746,1,746,1,747,1,747,
  	1,747,1,747,1,747,3,747,9442,8,747,1,748,1,748,1,748,3,748,9447,8,748,
  	1,748,1,748,1,748,3,748,9452,8,748,3,748,9454,8,748,1,749,1,749,1,749,
  	1,749,3,749,9460,8,749,1,750,1,750,1,751,1,751,1,751,1,751,1,751,3,751,
  	9469,8,751,1,752,1,752,1,752,1,752,1,752,1,752,1,752,1,752,1,752,1,752,
  	1,752,3,752,9482,8,752,1,752,0,4,906,908,916,918,753,0,2,4,6,8,10,12,
  	14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,
  	60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,
  	106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,
  	142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,
  	178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,
  	214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,246,248,
  	250,252,254,256,258,260,262,264,266,268,270,272,274,276,278,280,282,284,
  	286,288,290,292,294,296,298,300,302,304,306,308,310,312,314,316,318,320,
  	322,324,326,328,330,332,334,336,338,340,342,344,346,348,350,352,354,356,
  	358,360,362,364,366,368,370,372,374,376,378,380,382,384,386,388,390,392,
  	394,396,398,400,402,404,406,408,410,412,414,416,418,420,422,424,426,428,
  	430,432,434,436,438,440,442,444,446,448,450,452,454,456,458,460,462,464,
  	466,468,470,472,474,476,478,480,482,484,486,488,490,492,494,496,498,500,
  	502,504,506,508,510,512,514,516,518,520,522,524,526,528,530,532,534,536,
  	538,540,542,544,546,548,550,552,554,556,558,560,562,564,566,568,570,572,
  	574,576,578,580,582,584,586,588,590,592,594,596,598,600,602,604,606,608,
  	610,612,614,616,618,620,622,624,626,628,630,632,634,636,638,640,642,644,
  	646,648,650,652,654,656,658,660,662,664,666,668,670,672,674,676,678,680,
  	682,684,686,688,690,692,694,696,698,700,702,704,706,708,710,712,714,716,
  	718,720,722,724,726,728,730,732,734,736,738,740,742,744,746,748,750,752,
  	754,756,758,760,762,764,766,768,770,772,774,776,778,780,782,784,786,788,
  	790,792,794,796,798,800,802,804,806,808,810,812,814,816,818,820,822,824,
  	826,828,830,832,834,836,838,840,842,844,846,848,850,852,854,856,858,860,
  	862,864,866,868,870,872,874,876,878,880,882,884,886,888,890,892,894,896,
  	898,900,902,904,906,908,910,912,914,916,918,920,922,924,926,928,930,932,
  	934,936,938,940,942,944,946,948,950,952,954,956,958,960,962,964,966,968,
  	970,972,974,976,978,980,982,984,986,988,990,992,994,996,998,1000,1002,
  	1004,1006,1008,1010,1012,1014,1016,1018,1020,1022,1024,1026,1028,1030,
  	1032,1034,1036,1038,1040,1042,1044,1046,1048,1050,1052,1054,1056,1058,
  	1060,1062,1064,1066,1068,1070,1072,1074,1076,1078,1080,1082,1084,1086,
  	1088,1090,1092,1094,1096,1098,1100,1102,1104,1106,1108,1110,1112,1114,
  	1116,1118,1120,1122,1124,1126,1128,1130,1132,1134,1136,1138,1140,1142,
  	1144,1146,1148,1150,1152,1154,1156,1158,1160,1162,1164,1166,1168,1170,
  	1172,1174,1176,1178,1180,1182,1184,1186,1188,1190,1192,1194,1196,1198,
  	1200,1202,1204,1206,1208,1210,1212,1214,1216,1218,1220,1222,1224,1226,
  	1228,1230,1232,1234,1236,1238,1240,1242,1244,1246,1248,1250,1252,1254,
  	1256,1258,1260,1262,1264,1266,1268,1270,1272,1274,1276,1278,1280,1282,
  	1284,1286,1288,1290,1292,1294,1296,1298,1300,1302,1304,1306,1308,1310,
  	1312,1314,1316,1318,1320,1322,1324,1326,1328,1330,1332,1334,1336,1338,
  	1340,1342,1344,1346,1348,1350,1352,1354,1356,1358,1360,1362,1364,1366,
  	1368,1370,1372,1374,1376,1378,1380,1382,1384,1386,1388,1390,1392,1394,
  	1396,1398,1400,1402,1404,1406,1408,1410,1412,1414,1416,1418,1420,1422,
  	1424,1426,1428,1430,1432,1434,1436,1438,1440,1442,1444,1446,1448,1450,
  	1452,1454,1456,1458,1460,1462,1464,1466,1468,1470,1472,1474,1476,1478,
  	1480,1482,1484,1486,1488,1490,1492,1494,1496,1498,1500,1502,1504,0,176,
  	1,0,747,748,2,0,63,63,616,616,2,0,94,94,501,501,1,0,670,671,2,0,50,50,
  	187,187,1,0,749,750,2,0,95,95,316,316,2,0,180,180,195,195,2,0,268,268,
  	488,488,4,0,166,166,284,284,467,467,582,582,2,0,170,170,285,285,2,0,471,
  	471,630,630,2,0,404,404,663,663,3,0,367,367,604,604,628,628,2,0,52,52,
  	73,73,3,0,173,173,278,278,640,640,2,0,233,233,445,445,2,0,597,597,600,
  	600,3,0,268,268,327,327,461,461,2,0,229,229,397,397,4,0,229,229,302,302,
  	397,397,449,449,2,0,6,6,9,12,3,0,171,171,259,259,327,327,1,0,652,653,
  	2,0,154,154,678,678,2,0,126,126,327,327,2,0,822,822,828,828,2,0,312,312,
  	513,513,2,0,171,171,327,327,2,0,688,688,820,820,7,0,56,56,183,183,259,
  	259,557,558,560,560,562,562,581,581,2,0,29,29,411,411,2,0,3,5,42,42,3,
  	0,462,462,513,513,708,708,2,0,142,142,510,510,2,0,64,64,174,174,2,0,306,
  	306,508,508,2,0,141,141,275,275,2,0,56,56,183,183,2,0,234,234,268,268,
  	2,0,272,272,299,299,2,0,416,416,674,674,2,0,74,74,569,569,2,0,295,295,
  	502,502,2,0,77,77,348,348,2,0,328,328,783,783,2,0,332,332,789,789,2,0,
  	329,329,784,784,2,0,350,350,807,807,2,0,335,335,792,792,2,0,336,336,793,
  	793,2,0,330,330,786,786,2,0,337,337,795,795,2,0,331,331,787,787,2,0,346,
  	346,796,796,2,0,340,340,797,797,2,0,339,339,798,798,2,0,342,342,800,800,
  	2,0,343,343,801,801,2,0,344,344,802,802,2,0,345,345,803,803,2,0,347,347,
  	804,804,2,0,349,349,806,806,2,0,763,763,805,805,2,0,341,341,799,799,2,
  	0,737,737,794,794,2,0,738,738,782,782,2,0,351,351,788,788,2,0,760,760,
  	785,785,2,0,761,761,808,808,3,0,413,413,768,769,823,823,2,0,333,333,790,
  	790,2,0,334,334,791,791,2,0,554,554,556,556,2,0,479,479,564,564,2,0,541,
  	541,779,779,2,0,164,164,187,187,3,0,399,399,565,565,675,675,2,0,319,319,
  	637,637,2,0,168,168,744,744,3,0,242,242,452,452,600,600,4,0,278,278,473,
  	473,524,524,640,640,13,0,173,173,187,187,209,209,212,212,226,226,272,
  	272,453,453,457,457,481,481,537,537,591,591,620,620,642,642,4,0,512,512,
  	598,598,644,644,661,661,2,0,140,140,187,187,2,0,168,168,399,399,2,0,219,
  	219,461,461,1,0,830,831,5,0,101,101,219,219,223,223,365,365,461,461,3,
  	0,219,219,461,461,645,645,2,0,250,250,683,683,2,0,120,120,627,627,2,0,
  	239,239,286,286,2,0,271,272,297,297,6,0,56,56,139,139,290,290,366,366,
  	548,548,593,593,2,0,128,128,460,460,5,0,176,176,261,261,451,451,573,573,
  	643,643,5,0,77,77,202,202,204,204,244,244,542,542,2,0,644,644,735,735,
  	2,0,174,175,217,217,3,0,222,222,622,622,636,636,2,0,23,23,61,61,2,0,26,
  	26,424,424,2,0,56,56,62,62,2,0,6,6,8,13,3,0,16,18,184,184,380,380,1,0,
  	14,15,1,0,21,22,2,0,14,15,20,20,2,0,80,81,83,83,2,0,358,358,376,376,5,
  	0,574,574,577,577,590,590,657,657,660,660,4,0,703,704,717,717,719,719,
  	721,721,2,0,709,709,711,711,2,0,706,706,710,710,2,0,229,229,302,302,2,
  	0,735,735,832,832,2,0,268,268,720,720,2,0,51,51,584,584,1,0,156,157,1,
  	0,610,611,4,0,155,155,158,158,609,609,612,612,4,0,247,247,313,313,382,
  	384,441,442,2,0,1,1,401,401,2,0,1,1,19,19,5,0,159,162,262,264,372,373,
  	521,521,680,680,9,0,163,163,265,265,369,369,374,374,381,381,459,459,522,
  	522,665,665,681,681,3,0,136,136,214,214,631,631,2,0,144,144,566,566,2,
  	0,407,407,514,514,10,0,98,98,108,108,117,117,131,133,149,149,368,368,
  	386,386,520,520,583,583,602,602,2,0,580,580,662,662,3,0,168,168,191,191,
  	230,230,3,0,168,168,182,182,366,366,3,0,240,240,432,432,540,540,3,0,89,
  	89,256,256,517,517,1,0,686,687,2,0,625,625,647,647,5,0,76,76,284,284,
  	363,363,543,543,614,614,3,0,166,166,230,231,408,408,1,0,86,87,2,0,322,
  	322,362,362,4,0,247,248,313,313,382,384,441,442,3,0,539,539,638,638,682,
  	682,1,0,570,572,2,0,105,105,601,601,6,0,122,122,124,124,168,168,191,191,
  	230,230,472,472,3,0,229,229,302,302,403,403,2,0,182,182,366,366,2,0,314,
  	314,462,462,2,0,355,355,375,375,2,0,154,154,272,272,3,0,276,276,286,286,
  	427,427,2,0,567,567,605,605,2,0,410,410,415,415,2,0,316,316,405,405,2,
  	0,837,837,839,839,3,0,3,5,43,43,45,46,2,0,3,5,43,43,2,0,3,5,45,46,1,0,
  	43,44,2,0,222,222,622,622,2,0,41,41,406,406,1,0,3,5,1,0,6,7,3,0,212,212,
  	537,537,739,739,32,0,65,65,74,74,91,92,103,103,105,105,119,119,121,121,
  	134,134,164,164,186,186,198,198,232,233,255,255,258,258,270,270,281,281,
  	301,301,403,403,445,445,447,447,485,485,498,498,509,509,518,518,539,539,
  	541,541,569,569,578,578,623,623,632,633,676,676,702,702,9,0,209,209,226,
  	226,399,399,453,453,457,457,481,481,489,489,591,591,734,734,160,0,48,
  	49,51,55,58,58,62,62,67,72,78,78,82,82,85,87,89,89,95,95,98,99,101,102,
  	107,112,114,115,117,118,120,120,122,126,128,129,131,133,135,135,139,139,
  	144,144,149,149,153,155,158,158,163,163,169,170,172,172,178,182,189,191,
  	195,195,197,197,199,199,201,205,207,208,210,211,215,216,218,220,223,224,
  	227,230,237,238,240,240,244,244,246,249,252,252,256,256,260,261,265,266,
  	269,269,271,271,274,274,279,280,285,285,289,290,292,293,296,296,298,298,
  	302,302,304,304,307,308,313,314,318,318,320,321,328,328,330,346,348,351,
  	353,356,359,360,365,369,371,371,374,375,377,377,379,379,381,389,392,393,
  	395,398,404,404,407,407,409,409,411,411,414,414,416,417,420,420,428,434,
  	436,443,448,449,451,451,454,456,459,461,464,464,468,469,471,472,475,479,
  	482,482,484,484,486,486,490,496,500,500,502,504,506,506,510,512,514,515,
  	517,517,519,520,522,523,527,528,530,530,535,535,540,540,542,542,544,548,
  	554,556,558,558,561,561,564,564,566,566,568,568,570,573,579,579,582,587,
  	592,594,597,598,601,604,606,607,609,612,618,619,624,625,627,630,636,636,
  	639,639,641,641,643,645,651,651,653,653,656,656,661,661,663,666,671,673,
  	675,675,677,678,681,681,684,687,689,689,694,696,699,700,705,705,707,707,
  	714,715,718,718,720,720,722,723,727,733,736,738,740,750,752,755,757,757,
  	760,763,770,773,775,777,779,819,4,0,609,609,612,612,756,756,758,769,4,
  	0,821,821,823,826,828,828,832,832,5,0,250,250,316,316,529,529,683,683,
  	698,698,54,0,48,48,58,58,65,65,72,72,74,74,91,92,103,103,105,105,110,
  	110,119,119,121,121,134,134,164,164,186,186,198,198,232,233,237,237,246,
  	246,255,255,258,258,260,260,281,281,301,301,403,403,417,417,420,420,428,
  	428,431,431,435,435,443,443,445,445,447,447,482,482,485,485,498,498,500,
  	500,509,509,518,518,523,523,530,530,539,539,541,541,545,546,569,569,578,
  	578,623,623,632,633,641,641,673,673,676,676,684,684,686,687,702,702,745,
  	748,154,0,49,49,51,55,59,59,62,62,67,71,78,78,82,82,85,87,89,89,95,95,
  	98,99,101,102,107,109,111,112,114,115,117,118,120,120,122,126,128,129,
  	131,133,135,135,139,139,144,144,149,149,153,155,158,158,163,163,169,170,
  	172,172,176,176,178,182,189,191,195,195,197,197,199,199,201,205,207,208,
  	210,210,215,215,218,220,223,224,227,230,238,238,240,240,244,244,247,250,
  	252,252,256,256,261,261,265,266,269,269,271,271,274,274,279,280,285,285,
  	289,290,292,293,296,296,298,298,302,302,304,304,307,308,313,314,316,316,
  	318,318,320,321,328,328,330,337,339,346,348,351,353,357,359,360,365,369,
  	371,371,374,375,377,377,379,379,381,389,392,393,395,398,404,404,407,407,
  	409,409,411,412,414,414,429,430,432,434,436,442,448,449,451,451,454,456,
  	459,461,464,464,468,472,475,479,484,484,486,486,490,496,502,504,506,506,
  	510,512,514,515,517,517,519,520,522,522,527,529,535,535,540,540,542,542,
  	544,544,547,548,554,556,558,559,561,561,564,564,566,566,568,568,570,573,
  	579,579,582,587,591,594,597,598,601,604,606,607,609,612,618,619,624,630,
  	636,636,639,639,643,645,653,653,656,656,661,661,663,666,672,672,675,675,
  	677,678,681,681,689,689,694,696,699,701,705,705,707,707,714,715,718,718,
  	720,720,722,723,727,733,736,737,741,742,744,744,749,750,752,753,774,774,
  	5,0,142,142,242,242,270,270,513,513,516,516,6,0,211,211,216,216,416,416,
  	591,591,651,651,671,671,10586,0,1513,1,0,0,0,2,1597,1,0,0,0,4,1599,1,
  	0,0,0,6,1622,1,0,0,0,8,1643,1,0,0,0,10,1646,1,0,0,0,12,1684,1,0,0,0,14,
  	1693,1,0,0,0,16,1706,1,0,0,0,18,1708,1,0,0,0,20,1713,1,0,0,0,22,1733,
  	1,0,0,0,24,1742,1,0,0,0,26,1744,1,0,0,0,28,1759,1,0,0,0,30,1857,1,0,0,
  	0,32,1861,1,0,0,0,34,1877,1,0,0,0,36,2019,1,0,0,0,38,2024,1,0,0,0,40,
  	2026,1,0,0,0,42,2028,1,0,0,0,44,2042,1,0,0,0,46,2050,1,0,0,0,48,2066,
  	1,0,0,0,50,2068,1,0,0,0,52,2072,1,0,0,0,54,2077,1,0,0,0,56,2079,1,0,0,
  	0,58,2094,1,0,0,0,60,2102,1,0,0,0,62,2112,1,0,0,0,64,2114,1,0,0,0,66,
  	2136,1,0,0,0,68,2145,1,0,0,0,70,2148,1,0,0,0,72,2161,1,0,0,0,74,2166,
  	1,0,0,0,76,2170,1,0,0,0,78,2210,1,0,0,0,80,2212,1,0,0,0,82,2233,1,0,0,
  	0,84,2248,1,0,0,0,86,2251,1,0,0,0,88,2276,1,0,0,0,90,2286,1,0,0,0,92,
  	2289,1,0,0,0,94,2294,1,0,0,0,96,2303,1,0,0,0,98,2305,1,0,0,0,100,2309,
  	1,0,0,0,102,2321,1,0,0,0,104,2351,1,0,0,0,106,2357,1,0,0,0,108,2360,1,
  	0,0,0,110,2391,1,0,0,0,112,2409,1,0,0,0,114,2412,1,0,0,0,116,2437,1,0,
  	0,0,118,2440,1,0,0,0,120,2492,1,0,0,0,122,2494,1,0,0,0,124,2498,1,0,0,
  	0,126,2507,1,0,0,0,128,2523,1,0,0,0,130,2525,1,0,0,0,132,2533,1,0,0,0,
  	134,2559,1,0,0,0,136,2561,1,0,0,0,138,2573,1,0,0,0,140,2588,1,0,0,0,142,
  	2590,1,0,0,0,144,2593,1,0,0,0,146,2615,1,0,0,0,148,2617,1,0,0,0,150,2623,
  	1,0,0,0,152,2629,1,0,0,0,154,2635,1,0,0,0,156,2641,1,0,0,0,158,2647,1,
  	0,0,0,160,2654,1,0,0,0,162,2662,1,0,0,0,164,2664,1,0,0,0,166,2670,1,0,
  	0,0,168,2676,1,0,0,0,170,2682,1,0,0,0,172,2689,1,0,0,0,174,2707,1,0,0,
  	0,176,2709,1,0,0,0,178,2713,1,0,0,0,180,2718,1,0,0,0,182,2738,1,0,0,0,
  	184,2742,1,0,0,0,186,2775,1,0,0,0,188,2806,1,0,0,0,190,2823,1,0,0,0,192,
  	2825,1,0,0,0,194,2845,1,0,0,0,196,2851,1,0,0,0,198,2857,1,0,0,0,200,2863,
  	1,0,0,0,202,2870,1,0,0,0,204,2879,1,0,0,0,206,2896,1,0,0,0,208,2898,1,
  	0,0,0,210,2905,1,0,0,0,212,2915,1,0,0,0,214,2929,1,0,0,0,216,2935,1,0,
  	0,0,218,2943,1,0,0,0,220,2949,1,0,0,0,222,2957,1,0,0,0,224,2963,1,0,0,
  	0,226,2973,1,0,0,0,228,2977,1,0,0,0,230,2983,1,0,0,0,232,2988,1,0,0,0,
  	234,2999,1,0,0,0,236,3042,1,0,0,0,238,3047,1,0,0,0,240,3049,1,0,0,0,242,
  	3056,1,0,0,0,244,3086,1,0,0,0,246,3088,1,0,0,0,248,3117,1,0,0,0,250,3124,
  	1,0,0,0,252,3128,1,0,0,0,254,3136,1,0,0,0,256,3149,1,0,0,0,258,3151,1,
  	0,0,0,260,3169,1,0,0,0,262,3181,1,0,0,0,264,3187,1,0,0,0,266,3193,1,0,
  	0,0,268,3245,1,0,0,0,270,3247,1,0,0,0,272,3249,1,0,0,0,274,3255,1,0,0,
  	0,276,3257,1,0,0,0,278,3265,1,0,0,0,280,3271,1,0,0,0,282,3279,1,0,0,0,
  	284,3288,1,0,0,0,286,3296,1,0,0,0,288,3308,1,0,0,0,290,3313,1,0,0,0,292,
  	3318,1,0,0,0,294,3323,1,0,0,0,296,3345,1,0,0,0,298,3364,1,0,0,0,300,3368,
  	1,0,0,0,302,3383,1,0,0,0,304,3399,1,0,0,0,306,3411,1,0,0,0,308,3413,1,
  	0,0,0,310,3443,1,0,0,0,312,3445,1,0,0,0,314,3447,1,0,0,0,316,3450,1,0,
  	0,0,318,3453,1,0,0,0,320,3460,1,0,0,0,322,3462,1,0,0,0,324,3492,1,0,0,
  	0,326,3504,1,0,0,0,328,3507,1,0,0,0,330,3511,1,0,0,0,332,3520,1,0,0,0,
  	334,3524,1,0,0,0,336,3529,1,0,0,0,338,3542,1,0,0,0,340,3547,1,0,0,0,342,
  	3551,1,0,0,0,344,3567,1,0,0,0,346,3569,1,0,0,0,348,3587,1,0,0,0,350,3589,
  	1,0,0,0,352,3598,1,0,0,0,354,3610,1,0,0,0,356,3631,1,0,0,0,358,3638,1,
  	0,0,0,360,3640,1,0,0,0,362,3644,1,0,0,0,364,3646,1,0,0,0,366,3651,1,0,
  	0,0,368,3659,1,0,0,0,370,3668,1,0,0,0,372,3671,1,0,0,0,374,3686,1,0,0,
  	0,376,3688,1,0,0,0,378,3709,1,0,0,0,380,3714,1,0,0,0,382,3719,1,0,0,0,
  	384,3723,1,0,0,0,386,3737,1,0,0,0,388,3740,1,0,0,0,390,3746,1,0,0,0,392,
  	3759,1,0,0,0,394,3767,1,0,0,0,396,3793,1,0,0,0,398,3806,1,0,0,0,400,3813,
  	1,0,0,0,402,3815,1,0,0,0,404,3827,1,0,0,0,406,3829,1,0,0,0,408,3842,1,
  	0,0,0,410,3866,1,0,0,0,412,3868,1,0,0,0,414,3875,1,0,0,0,416,3885,1,0,
  	0,0,418,3920,1,0,0,0,420,3927,1,0,0,0,422,3933,1,0,0,0,424,3935,1,0,0,
  	0,426,3939,1,0,0,0,428,3947,1,0,0,0,430,3949,1,0,0,0,432,3954,1,0,0,0,
  	434,3958,1,0,0,0,436,3986,1,0,0,0,438,3988,1,0,0,0,440,3990,1,0,0,0,442,
  	3998,1,0,0,0,444,4000,1,0,0,0,446,4008,1,0,0,0,448,4018,1,0,0,0,450,4022,
  	1,0,0,0,452,4047,1,0,0,0,454,4074,1,0,0,0,456,4076,1,0,0,0,458,4085,1,
  	0,0,0,460,4116,1,0,0,0,462,4140,1,0,0,0,464,4142,1,0,0,0,466,4156,1,0,
  	0,0,468,4158,1,0,0,0,470,4193,1,0,0,0,472,4195,1,0,0,0,474,4228,1,0,0,
  	0,476,4230,1,0,0,0,478,4252,1,0,0,0,480,4260,1,0,0,0,482,4262,1,0,0,0,
  	484,4266,1,0,0,0,486,4279,1,0,0,0,488,4281,1,0,0,0,490,4288,1,0,0,0,492,
  	4424,1,0,0,0,494,4426,1,0,0,0,496,4428,1,0,0,0,498,4430,1,0,0,0,500,4432,
  	1,0,0,0,502,4434,1,0,0,0,504,4436,1,0,0,0,506,4438,1,0,0,0,508,4440,1,
  	0,0,0,510,4442,1,0,0,0,512,4444,1,0,0,0,514,4446,1,0,0,0,516,4448,1,0,
  	0,0,518,4450,1,0,0,0,520,4452,1,0,0,0,522,4454,1,0,0,0,524,4456,1,0,0,
  	0,526,4458,1,0,0,0,528,4460,1,0,0,0,530,4462,1,0,0,0,532,4464,1,0,0,0,
  	534,4466,1,0,0,0,536,4468,1,0,0,0,538,4470,1,0,0,0,540,4472,1,0,0,0,542,
  	4474,1,0,0,0,544,4478,1,0,0,0,546,4480,1,0,0,0,548,4485,1,0,0,0,550,4489,
  	1,0,0,0,552,4505,1,0,0,0,554,4507,1,0,0,0,556,4509,1,0,0,0,558,4511,1,
  	0,0,0,560,4524,1,0,0,0,562,4588,1,0,0,0,564,4590,1,0,0,0,566,4598,1,0,
  	0,0,568,4606,1,0,0,0,570,4614,1,0,0,0,572,4616,1,0,0,0,574,4624,1,0,0,
  	0,576,4648,1,0,0,0,578,4661,1,0,0,0,580,4670,1,0,0,0,582,4674,1,0,0,0,
  	584,4678,1,0,0,0,586,4682,1,0,0,0,588,4686,1,0,0,0,590,4694,1,0,0,0,592,
  	4704,1,0,0,0,594,4706,1,0,0,0,596,4717,1,0,0,0,598,4719,1,0,0,0,600,4723,
  	1,0,0,0,602,4727,1,0,0,0,604,4731,1,0,0,0,606,4744,1,0,0,0,608,4746,1,
  	0,0,0,610,4752,1,0,0,0,612,4760,1,0,0,0,614,4797,1,0,0,0,616,4799,1,0,
  	0,0,618,4813,1,0,0,0,620,4815,1,0,0,0,622,4872,1,0,0,0,624,4958,1,0,0,
  	0,626,5017,1,0,0,0,628,5019,1,0,0,0,630,5022,1,0,0,0,632,5050,1,0,0,0,
  	634,5056,1,0,0,0,636,5065,1,0,0,0,638,5067,1,0,0,0,640,5072,1,0,0,0,642,
  	5127,1,0,0,0,644,5129,1,0,0,0,646,5137,1,0,0,0,648,5186,1,0,0,0,650,5188,
  	1,0,0,0,652,5191,1,0,0,0,654,5194,1,0,0,0,656,5205,1,0,0,0,658,5210,1,
  	0,0,0,660,5213,1,0,0,0,662,5228,1,0,0,0,664,5276,1,0,0,0,666,5278,1,0,
  	0,0,668,5330,1,0,0,0,670,5348,1,0,0,0,672,5350,1,0,0,0,674,5366,1,0,0,
  	0,676,5381,1,0,0,0,678,5406,1,0,0,0,680,5408,1,0,0,0,682,5416,1,0,0,0,
  	684,5467,1,0,0,0,686,5469,1,0,0,0,688,5483,1,0,0,0,690,5485,1,0,0,0,692,
  	5499,1,0,0,0,694,5504,1,0,0,0,696,5506,1,0,0,0,698,5508,1,0,0,0,700,5522,
  	1,0,0,0,702,5535,1,0,0,0,704,5539,1,0,0,0,706,5541,1,0,0,0,708,5546,1,
  	0,0,0,710,5556,1,0,0,0,712,5615,1,0,0,0,714,5626,1,0,0,0,716,5628,1,0,
  	0,0,718,5631,1,0,0,0,720,5644,1,0,0,0,722,5677,1,0,0,0,724,5685,1,0,0,
  	0,726,5692,1,0,0,0,728,5694,1,0,0,0,730,5707,1,0,0,0,732,5709,1,0,0,0,
  	734,5714,1,0,0,0,736,5725,1,0,0,0,738,5736,1,0,0,0,740,5744,1,0,0,0,742,
  	5753,1,0,0,0,744,5762,1,0,0,0,746,5767,1,0,0,0,748,5770,1,0,0,0,750,5775,
  	1,0,0,0,752,5780,1,0,0,0,754,5785,1,0,0,0,756,5798,1,0,0,0,758,5802,1,
  	0,0,0,760,5807,1,0,0,0,762,5813,1,0,0,0,764,5830,1,0,0,0,766,5847,1,0,
  	0,0,768,5861,1,0,0,0,770,5867,1,0,0,0,772,5874,1,0,0,0,774,5881,1,0,0,
  	0,776,5886,1,0,0,0,778,5891,1,0,0,0,780,5894,1,0,0,0,782,5907,1,0,0,0,
  	784,5915,1,0,0,0,786,5921,1,0,0,0,788,5929,1,0,0,0,790,5934,1,0,0,0,792,
  	5939,1,0,0,0,794,5942,1,0,0,0,796,5952,1,0,0,0,798,5960,1,0,0,0,800,5965,
  	1,0,0,0,802,5970,1,0,0,0,804,5974,1,0,0,0,806,5984,1,0,0,0,808,5989,1,
  	0,0,0,810,5994,1,0,0,0,812,5999,1,0,0,0,814,6006,1,0,0,0,816,6013,1,0,
  	0,0,818,6019,1,0,0,0,820,6025,1,0,0,0,822,6030,1,0,0,0,824,6041,1,0,0,
  	0,826,6045,1,0,0,0,828,6047,1,0,0,0,830,6049,1,0,0,0,832,6052,1,0,0,0,
  	834,6067,1,0,0,0,836,6106,1,0,0,0,838,6110,1,0,0,0,840,6112,1,0,0,0,842,
  	6120,1,0,0,0,844,6124,1,0,0,0,846,6132,1,0,0,0,848,6141,1,0,0,0,850,6143,
  	1,0,0,0,852,6166,1,0,0,0,854,6168,1,0,0,0,856,6170,1,0,0,0,858,6185,1,
  	0,0,0,860,6197,1,0,0,0,862,6199,1,0,0,0,864,6207,1,0,0,0,866,6215,1,0,
  	0,0,868,6224,1,0,0,0,870,6226,1,0,0,0,872,6244,1,0,0,0,874,6258,1,0,0,
  	0,876,6263,1,0,0,0,878,6269,1,0,0,0,880,6271,1,0,0,0,882,6287,1,0,0,0,
  	884,6295,1,0,0,0,886,6305,1,0,0,0,888,6318,1,0,0,0,890,6320,1,0,0,0,892,
  	6326,1,0,0,0,894,6356,1,0,0,0,896,6366,1,0,0,0,898,6368,1,0,0,0,900,6372,
  	1,0,0,0,902,6375,1,0,0,0,904,6378,1,0,0,0,906,6391,1,0,0,0,908,6407,1,
  	0,0,0,910,6430,1,0,0,0,912,6432,1,0,0,0,914,6469,1,0,0,0,916,6471,1,0,
  	0,0,918,6628,1,0,0,0,920,6641,1,0,0,0,922,6650,1,0,0,0,924,6746,1,0,0,
  	0,926,6748,1,0,0,0,928,6802,1,0,0,0,930,6804,1,0,0,0,932,6810,1,0,0,0,
  	934,6812,1,0,0,0,936,6819,1,0,0,0,938,6824,1,0,0,0,940,6837,1,0,0,0,942,
  	6842,1,0,0,0,944,6844,1,0,0,0,946,6863,1,0,0,0,948,6866,1,0,0,0,950,6875,
  	1,0,0,0,952,6877,1,0,0,0,954,6900,1,0,0,0,956,7190,1,0,0,0,958,7192,1,
  	0,0,0,960,7226,1,0,0,0,962,7228,1,0,0,0,964,7234,1,0,0,0,966,7236,1,0,
  	0,0,968,7251,1,0,0,0,970,7259,1,0,0,0,972,7261,1,0,0,0,974,7290,1,0,0,
  	0,976,7323,1,0,0,0,978,7325,1,0,0,0,980,7333,1,0,0,0,982,7337,1,0,0,0,
  	984,7342,1,0,0,0,986,7344,1,0,0,0,988,7355,1,0,0,0,990,7370,1,0,0,0,992,
  	7372,1,0,0,0,994,7376,1,0,0,0,996,7379,1,0,0,0,998,7382,1,0,0,0,1000,
  	7434,1,0,0,0,1002,7436,1,0,0,0,1004,7447,1,0,0,0,1006,7449,1,0,0,0,1008,
  	7451,1,0,0,0,1010,7455,1,0,0,0,1012,7457,1,0,0,0,1014,7459,1,0,0,0,1016,
  	7463,1,0,0,0,1018,7467,1,0,0,0,1020,7471,1,0,0,0,1022,7479,1,0,0,0,1024,
  	7483,1,0,0,0,1026,7491,1,0,0,0,1028,7493,1,0,0,0,1030,7511,1,0,0,0,1032,
  	7513,1,0,0,0,1034,7516,1,0,0,0,1036,7521,1,0,0,0,1038,7529,1,0,0,0,1040,
  	7535,1,0,0,0,1042,7539,1,0,0,0,1044,7556,1,0,0,0,1046,7559,1,0,0,0,1048,
  	7564,1,0,0,0,1050,7566,1,0,0,0,1052,7569,1,0,0,0,1054,7578,1,0,0,0,1056,
  	7586,1,0,0,0,1058,7588,1,0,0,0,1060,7593,1,0,0,0,1062,7600,1,0,0,0,1064,
  	7610,1,0,0,0,1066,7618,1,0,0,0,1068,7620,1,0,0,0,1070,7630,1,0,0,0,1072,
  	7638,1,0,0,0,1074,7640,1,0,0,0,1076,7646,1,0,0,0,1078,7667,1,0,0,0,1080,
  	7669,1,0,0,0,1082,7675,1,0,0,0,1084,7678,1,0,0,0,1086,7681,1,0,0,0,1088,
  	7709,1,0,0,0,1090,7713,1,0,0,0,1092,7720,1,0,0,0,1094,7727,1,0,0,0,1096,
  	7729,1,0,0,0,1098,7745,1,0,0,0,1100,7761,1,0,0,0,1102,7765,1,0,0,0,1104,
  	7768,1,0,0,0,1106,7771,1,0,0,0,1108,7795,1,0,0,0,1110,7797,1,0,0,0,1112,
  	7805,1,0,0,0,1114,7807,1,0,0,0,1116,7810,1,0,0,0,1118,7890,1,0,0,0,1120,
  	7892,1,0,0,0,1122,7896,1,0,0,0,1124,7996,1,0,0,0,1126,7998,1,0,0,0,1128,
  	8000,1,0,0,0,1130,8002,1,0,0,0,1132,8007,1,0,0,0,1134,8023,1,0,0,0,1136,
  	8025,1,0,0,0,1138,8059,1,0,0,0,1140,8061,1,0,0,0,1142,8072,1,0,0,0,1144,
  	8079,1,0,0,0,1146,8096,1,0,0,0,1148,8098,1,0,0,0,1150,8102,1,0,0,0,1152,
  	8125,1,0,0,0,1154,8127,1,0,0,0,1156,8129,1,0,0,0,1158,8136,1,0,0,0,1160,
  	8138,1,0,0,0,1162,8140,1,0,0,0,1164,8290,1,0,0,0,1166,8295,1,0,0,0,1168,
  	8302,1,0,0,0,1170,8304,1,0,0,0,1172,8312,1,0,0,0,1174,8330,1,0,0,0,1176,
  	8338,1,0,0,0,1178,8346,1,0,0,0,1180,8348,1,0,0,0,1182,8352,1,0,0,0,1184,
  	8361,1,0,0,0,1186,8367,1,0,0,0,1188,8374,1,0,0,0,1190,8376,1,0,0,0,1192,
  	8391,1,0,0,0,1194,8398,1,0,0,0,1196,8401,1,0,0,0,1198,8551,1,0,0,0,1200,
  	8555,1,0,0,0,1202,8558,1,0,0,0,1204,8567,1,0,0,0,1206,8576,1,0,0,0,1208,
  	8584,1,0,0,0,1210,8630,1,0,0,0,1212,8632,1,0,0,0,1214,8653,1,0,0,0,1216,
  	8657,1,0,0,0,1218,8668,1,0,0,0,1220,8713,1,0,0,0,1222,8749,1,0,0,0,1224,
  	8751,1,0,0,0,1226,8759,1,0,0,0,1228,8772,1,0,0,0,1230,8774,1,0,0,0,1232,
  	8778,1,0,0,0,1234,8782,1,0,0,0,1236,8793,1,0,0,0,1238,8795,1,0,0,0,1240,
  	8799,1,0,0,0,1242,8804,1,0,0,0,1244,8808,1,0,0,0,1246,8811,1,0,0,0,1248,
  	8814,1,0,0,0,1250,8818,1,0,0,0,1252,8824,1,0,0,0,1254,8832,1,0,0,0,1256,
  	8840,1,0,0,0,1258,8846,1,0,0,0,1260,8849,1,0,0,0,1262,8867,1,0,0,0,1264,
  	8869,1,0,0,0,1266,8875,1,0,0,0,1268,8879,1,0,0,0,1270,8887,1,0,0,0,1272,
  	8895,1,0,0,0,1274,8910,1,0,0,0,1276,8925,1,0,0,0,1278,8927,1,0,0,0,1280,
  	8935,1,0,0,0,1282,8940,1,0,0,0,1284,8944,1,0,0,0,1286,8950,1,0,0,0,1288,
  	8956,1,0,0,0,1290,8963,1,0,0,0,1292,8970,1,0,0,0,1294,8974,1,0,0,0,1296,
  	8993,1,0,0,0,1298,8995,1,0,0,0,1300,8998,1,0,0,0,1302,9001,1,0,0,0,1304,
  	9014,1,0,0,0,1306,9016,1,0,0,0,1308,9021,1,0,0,0,1310,9023,1,0,0,0,1312,
  	9025,1,0,0,0,1314,9027,1,0,0,0,1316,9035,1,0,0,0,1318,9041,1,0,0,0,1320,
  	9043,1,0,0,0,1322,9045,1,0,0,0,1324,9056,1,0,0,0,1326,9060,1,0,0,0,1328,
  	9062,1,0,0,0,1330,9064,1,0,0,0,1332,9066,1,0,0,0,1334,9075,1,0,0,0,1336,
  	9077,1,0,0,0,1338,9079,1,0,0,0,1340,9081,1,0,0,0,1342,9083,1,0,0,0,1344,
  	9085,1,0,0,0,1346,9087,1,0,0,0,1348,9089,1,0,0,0,1350,9093,1,0,0,0,1352,
  	9097,1,0,0,0,1354,9099,1,0,0,0,1356,9101,1,0,0,0,1358,9103,1,0,0,0,1360,
  	9105,1,0,0,0,1362,9107,1,0,0,0,1364,9109,1,0,0,0,1366,9111,1,0,0,0,1368,
  	9113,1,0,0,0,1370,9115,1,0,0,0,1372,9117,1,0,0,0,1374,9121,1,0,0,0,1376,
  	9123,1,0,0,0,1378,9126,1,0,0,0,1380,9138,1,0,0,0,1382,9140,1,0,0,0,1384,
  	9148,1,0,0,0,1386,9156,1,0,0,0,1388,9160,1,0,0,0,1390,9162,1,0,0,0,1392,
  	9166,1,0,0,0,1394,9168,1,0,0,0,1396,9170,1,0,0,0,1398,9172,1,0,0,0,1400,
  	9174,1,0,0,0,1402,9179,1,0,0,0,1404,9183,1,0,0,0,1406,9185,1,0,0,0,1408,
  	9193,1,0,0,0,1410,9197,1,0,0,0,1412,9212,1,0,0,0,1414,9214,1,0,0,0,1416,
  	9217,1,0,0,0,1418,9219,1,0,0,0,1420,9221,1,0,0,0,1422,9228,1,0,0,0,1424,
  	9235,1,0,0,0,1426,9240,1,0,0,0,1428,9251,1,0,0,0,1430,9256,1,0,0,0,1432,
  	9258,1,0,0,0,1434,9260,1,0,0,0,1436,9274,1,0,0,0,1438,9279,1,0,0,0,1440,
  	9284,1,0,0,0,1442,9291,1,0,0,0,1444,9299,1,0,0,0,1446,9301,1,0,0,0,1448,
  	9312,1,0,0,0,1450,9314,1,0,0,0,1452,9316,1,0,0,0,1454,9318,1,0,0,0,1456,
  	9326,1,0,0,0,1458,9330,1,0,0,0,1460,9332,1,0,0,0,1462,9334,1,0,0,0,1464,
  	9342,1,0,0,0,1466,9346,1,0,0,0,1468,9350,1,0,0,0,1470,9354,1,0,0,0,1472,
  	9356,1,0,0,0,1474,9359,1,0,0,0,1476,9368,1,0,0,0,1478,9376,1,0,0,0,1480,
  	9385,1,0,0,0,1482,9389,1,0,0,0,1484,9408,1,0,0,0,1486,9410,1,0,0,0,1488,
  	9412,1,0,0,0,1490,9432,1,0,0,0,1492,9434,1,0,0,0,1494,9441,1,0,0,0,1496,
  	9453,1,0,0,0,1498,9459,1,0,0,0,1500,9461,1,0,0,0,1502,9468,1,0,0,0,1504,
  	9481,1,0,0,0,1506,1509,3,2,1,0,1507,1509,3,456,228,0,1508,1506,1,0,0,
  	0,1508,1507,1,0,0,0,1509,1511,1,0,0,0,1510,1512,5,30,0,0,1511,1510,1,
  	0,0,0,1511,1512,1,0,0,0,1512,1514,1,0,0,0,1513,1508,1,0,0,0,1513,1514,
  	1,0,0,0,1514,1515,1,0,0,0,1515,1516,5,0,0,1,1516,1,1,0,0,0,1517,1598,
  	3,4,2,0,1518,1598,3,80,40,0,1519,1598,3,192,96,0,1520,1598,3,224,112,
  	0,1521,1598,3,228,114,0,1522,1523,4,1,0,0,1523,1598,3,230,115,0,1524,
  	1598,3,232,116,0,1525,1598,3,234,117,0,1526,1598,3,240,120,0,1527,1598,
  	3,242,121,0,1528,1598,3,246,123,0,1529,1598,3,266,133,0,1530,1598,3,294,
  	147,0,1531,1598,3,296,148,0,1532,1598,3,450,225,0,1533,1598,3,452,226,
  	0,1534,1598,3,474,237,0,1535,1598,3,606,303,0,1536,1537,4,1,1,0,1537,
  	1598,3,612,306,0,1538,1598,3,618,309,0,1539,1598,3,684,342,0,1540,1598,
  	3,698,349,0,1541,1598,3,700,350,0,1542,1598,3,710,355,0,1543,1598,3,732,
  	366,0,1544,1598,3,734,367,0,1545,1598,3,736,368,0,1546,1598,3,738,369,
  	0,1547,1598,3,740,370,0,1548,1598,3,742,371,0,1549,1598,3,744,372,0,1550,
  	1598,3,746,373,0,1551,1598,3,748,374,0,1552,1598,3,750,375,0,1553,1598,
  	3,752,376,0,1554,1598,3,754,377,0,1555,1598,3,756,378,0,1556,1598,3,758,
  	379,0,1557,1598,3,760,380,0,1558,1598,3,762,381,0,1559,1598,3,764,382,
  	0,1560,1598,3,766,383,0,1561,1598,3,768,384,0,1562,1598,3,770,385,0,1563,
  	1598,3,772,386,0,1564,1598,3,774,387,0,1565,1598,3,776,388,0,1566,1598,
  	3,778,389,0,1567,1598,3,780,390,0,1568,1598,3,782,391,0,1569,1598,3,784,
  	392,0,1570,1598,3,786,393,0,1571,1598,3,788,394,0,1572,1598,3,790,395,
  	0,1573,1598,3,792,396,0,1574,1598,3,794,397,0,1575,1598,3,796,398,0,1576,
  	1598,3,798,399,0,1577,1598,3,800,400,0,1578,1598,3,802,401,0,1579,1598,
  	3,804,402,0,1580,1598,3,806,403,0,1581,1598,3,808,404,0,1582,1598,3,810,
  	405,0,1583,1598,3,812,406,0,1584,1598,3,814,407,0,1585,1598,3,816,408,
  	0,1586,1598,3,818,409,0,1587,1598,3,820,410,0,1588,1589,4,1,2,0,1589,
  	1598,3,822,411,0,1590,1591,4,1,3,0,1591,1598,3,868,434,0,1592,1598,3,
  	836,418,0,1593,1598,3,888,444,0,1594,1598,3,1086,543,0,1595,1598,3,1096,
  	548,0,1596,1598,3,1098,549,0,1597,1517,1,0,0,0,1597,1518,1,0,0,0,1597,
  	1519,1,0,0,0,1597,1520,1,0,0,0,1597,1521,1,0,0,0,1597,1522,1,0,0,0,1597,
  	1524,1,0,0,0,1597,1525,1,0,0,0,1597,1526,1,0,0,0,1597,1527,1,0,0,0,1597,
  	1528,1,0,0,0,1597,1529,1,0,0,0,1597,1530,1,0,0,0,1597,1531,1,0,0,0,1597,
  	1532,1,0,0,0,1597,1533,1,0,0,0,1597,1534,1,0,0,0,1597,1535,1,0,0,0,1597,
  	1536,1,0,0,0,1597,1538,1,0,0,0,1597,1539,1,0,0,0,1597,1540,1,0,0,0,1597,
  	1541,1,0,0,0,1597,1542,1,0,0,0,1597,1543,1,0,0,0,1597,1544,1,0,0,0,1597,
  	1545,1,0,0,0,1597,1546,1,0,0,0,1597,1547,1,0,0,0,1597,1548,1,0,0,0,1597,
  	1549,1,0,0,0,1597,1550,1,0,0,0,1597,1551,1,0,0,0,1597,1552,1,0,0,0,1597,
  	1553,1,0,0,0,1597,1554,1,0,0,0,1597,1555,1,0,0,0,1597,1556,1,0,0,0,1597,
  	1557,1,0,0,0,1597,1558,1,0,0,0,1597,1559,1,0,0,0,1597,1560,1,0,0,0,1597,
  	1561,1,0,0,0,1597,1562,1,0,0,0,1597,1563,1,0,0,0,1597,1564,1,0,0,0,1597,
  	1565,1,0,0,0,1597,1566,1,0,0,0,1597,1567,1,0,0,0,1597,1568,1,0,0,0,1597,
  	1569,1,0,0,0,1597,1570,1,0,0,0,1597,1571,1,0,0,0,1597,1572,1,0,0,0,1597,
  	1573,1,0,0,0,1597,1574,1,0,0,0,1597,1575,1,0,0,0,1597,1576,1,0,0,0,1597,
  	1577,1,0,0,0,1597,1578,1,0,0,0,1597,1579,1,0,0,0,1597,1580,1,0,0,0,1597,
  	1581,1,0,0,0,1597,1582,1,0,0,0,1597,1583,1,0,0,0,1597,1584,1,0,0,0,1597,
  	1585,1,0,0,0,1597,1586,1,0,0,0,1597,1587,1,0,0,0,1597,1588,1,0,0,0,1597,
  	1590,1,0,0,0,1597,1592,1,0,0,0,1597,1593,1,0,0,0,1597,1594,1,0,0,0,1597,
  	1595,1,0,0,0,1597,1596,1,0,0,0,1598,3,1,0,0,0,1599,1620,5,57,0,0,1600,
  	1621,3,20,10,0,1601,1621,3,6,3,0,1602,1603,5,452,0,0,1603,1605,3,1340,
  	670,0,1604,1606,3,114,57,0,1605,1604,1,0,0,0,1605,1606,1,0,0,0,1606,1621,
  	1,0,0,0,1607,1608,5,242,0,0,1608,1610,3,1344,672,0,1609,1611,3,114,57,
  	0,1610,1609,1,0,0,0,1610,1611,1,0,0,0,1611,1621,1,0,0,0,1612,1621,3,70,
  	35,0,1613,1621,3,10,5,0,1614,1621,3,56,28,0,1615,1616,4,2,4,0,1616,1621,
  	3,58,29,0,1617,1621,3,12,6,0,1618,1621,3,18,9,0,1619,1621,3,78,39,0,1620,
  	1600,1,0,0,0,1620,1601,1,0,0,0,1620,1602,1,0,0,0,1620,1607,1,0,0,0,1620,
  	1612,1,0,0,0,1620,1613,1,0,0,0,1620,1614,1,0,0,0,1620,1615,1,0,0,0,1620,
  	1617,1,0,0,0,1620,1618,1,0,0,0,1620,1619,1,0,0,0,1621,5,1,0,0,0,1622,
  	1623,5,151,0,0,1623,1634,3,1336,668,0,1624,1626,3,8,4,0,1625,1624,1,0,
  	0,0,1626,1627,1,0,0,0,1627,1625,1,0,0,0,1627,1628,1,0,0,0,1628,1635,1,
  	0,0,0,1629,1630,4,3,5,0,1630,1631,5,641,0,0,1631,1632,5,154,0,0,1632,
  	1633,5,179,0,0,1633,1635,5,388,0,0,1634,1625,1,0,0,0,1634,1629,1,0,0,
  	0,1635,7,1,0,0,0,1636,1644,3,84,42,0,1637,1638,5,465,0,0,1638,1640,5,
  	416,0,0,1639,1641,5,6,0,0,1640,1639,1,0,0,0,1640,1641,1,0,0,0,1641,1642,
  	1,0,0,0,1642,1644,3,1200,600,0,1643,1636,1,0,0,0,1643,1637,1,0,0,0,1644,
  	9,1,0,0,0,1645,1647,3,1230,615,0,1646,1645,1,0,0,0,1646,1647,1,0,0,0,
  	1647,1648,1,0,0,0,1648,1649,5,209,0,0,1649,1653,3,1364,682,0,1650,1651,
  	5,413,0,0,1651,1652,5,519,0,0,1652,1654,3,1108,554,0,1653,1650,1,0,0,
  	0,1653,1654,1,0,0,0,1654,1661,1,0,0,0,1655,1656,5,413,0,0,1656,1658,5,
  	123,0,0,1657,1659,5,401,0,0,1658,1657,1,0,0,0,1658,1659,1,0,0,0,1659,
  	1660,1,0,0,0,1660,1662,5,448,0,0,1661,1655,1,0,0,0,1661,1662,1,0,0,0,
  	1662,1666,1,0,0,0,1663,1664,5,483,0,0,1664,1665,5,616,0,0,1665,1667,3,
  	1404,702,0,1666,1663,1,0,0,0,1666,1667,1,0,0,0,1667,1674,1,0,0,0,1668,
  	1675,5,195,0,0,1669,1672,5,180,0,0,1670,1671,5,413,0,0,1671,1673,3,604,
  	302,0,1672,1670,1,0,0,0,1672,1673,1,0,0,0,1673,1675,1,0,0,0,1674,1668,
  	1,0,0,0,1674,1669,1,0,0,0,1674,1675,1,0,0,0,1675,1678,1,0,0,0,1676,1677,
  	5,119,0,0,1677,1679,3,1442,721,0,1678,1676,1,0,0,0,1678,1679,1,0,0,0,
  	1679,1682,1,0,0,0,1680,1681,5,186,0,0,1681,1683,3,1030,515,0,1682,1680,
  	1,0,0,0,1682,1683,1,0,0,0,1683,11,1,0,0,0,1684,1685,5,320,0,0,1685,1686,
  	5,253,0,0,1686,1687,3,1360,680,0,1687,1688,5,50,0,0,1688,1689,5,629,0,
  	0,1689,1691,3,1442,721,0,1690,1692,3,14,7,0,1691,1690,1,0,0,0,1691,1692,
  	1,0,0,0,1692,13,1,0,0,0,1693,1700,3,16,8,0,1694,1696,5,29,0,0,1695,1694,
  	1,0,0,0,1695,1696,1,0,0,0,1696,1697,1,0,0,0,1697,1699,3,16,8,0,1698,1695,
  	1,0,0,0,1699,1702,1,0,0,0,1700,1698,1,0,0,0,1700,1701,1,0,0,0,1701,15,
  	1,0,0,0,1702,1700,1,0,0,0,1703,1707,3,148,74,0,1704,1707,3,160,80,0,1705,
  	1707,3,162,81,0,1706,1703,1,0,0,0,1706,1704,1,0,0,0,1706,1705,1,0,0,0,
  	1707,17,1,0,0,0,1708,1709,5,530,0,0,1709,1710,3,1370,685,0,1710,1711,
  	3,132,66,0,1711,19,1,0,0,0,1712,1714,3,1310,655,0,1713,1712,1,0,0,0,1713,
  	1714,1,0,0,0,1714,1715,1,0,0,0,1715,1716,5,600,0,0,1716,1718,3,1380,690,
  	0,1717,1719,3,22,11,0,1718,1717,1,0,0,0,1718,1719,1,0,0,0,1719,21,1,0,
  	0,0,1720,1723,3,24,12,0,1721,1724,3,1208,604,0,1722,1724,3,52,26,0,1723,
  	1721,1,0,0,0,1723,1722,1,0,0,0,1723,1724,1,0,0,0,1724,1734,1,0,0,0,1725,
  	1734,3,1208,604,0,1726,1734,3,52,26,0,1727,1728,3,26,13,0,1728,1729,5,
  	29,0,0,1729,1731,1,0,0,0,1730,1727,1,0,0,0,1730,1731,1,0,0,0,1731,1732,
  	1,0,0,0,1732,1734,3,28,14,0,1733,1720,1,0,0,0,1733,1725,1,0,0,0,1733,
  	1726,1,0,0,0,1733,1730,1,0,0,0,1734,23,1,0,0,0,1735,1743,3,26,13,0,1736,
  	1737,3,26,13,0,1737,1738,5,29,0,0,1738,1740,1,0,0,0,1739,1736,1,0,0,0,
  	1739,1740,1,0,0,0,1740,1741,1,0,0,0,1741,1743,3,32,16,0,1742,1735,1,0,
  	0,0,1742,1739,1,0,0,0,1743,25,1,0,0,0,1744,1749,3,34,17,0,1745,1746,5,
  	29,0,0,1746,1748,3,34,17,0,1747,1745,1,0,0,0,1748,1751,1,0,0,0,1749,1747,
  	1,0,0,0,1749,1750,1,0,0,0,1750,27,1,0,0,0,1751,1749,1,0,0,0,1752,1753,
  	5,181,0,0,1753,1760,5,598,0,0,1754,1755,5,270,0,0,1755,1760,5,598,0,0,
  	1756,1760,3,30,15,0,1757,1758,4,14,6,0,1758,1760,7,0,0,0,1759,1752,1,
  	0,0,0,1759,1754,1,0,0,0,1759,1756,1,0,0,0,1759,1757,1,0,0,0,1760,29,1,
  	0,0,0,1761,1762,5,50,0,0,1762,1764,5,435,0,0,1763,1765,3,1312,656,0,1764,
  	1763,1,0,0,0,1764,1765,1,0,0,0,1765,1769,1,0,0,0,1766,1770,3,1216,608,
  	0,1767,1768,5,434,0,0,1768,1770,3,1418,709,0,1769,1766,1,0,0,0,1769,1767,
  	1,0,0,0,1770,1858,1,0,0,0,1771,1772,5,187,0,0,1772,1773,5,435,0,0,1773,
  	1858,3,1406,703,0,1774,1775,5,468,0,0,1775,1777,5,435,0,0,1776,1778,3,
  	1312,656,0,1777,1776,1,0,0,0,1777,1778,1,0,0,0,1778,1779,1,0,0,0,1779,
  	1858,3,54,27,0,1780,1781,5,418,0,0,1781,1783,5,435,0,0,1782,1784,3,1312,
  	656,0,1783,1782,1,0,0,0,1783,1784,1,0,0,0,1784,1785,1,0,0,0,1785,1787,
  	3,54,27,0,1786,1788,3,1312,656,0,1787,1786,1,0,0,0,1787,1788,1,0,0,0,
  	1788,1858,1,0,0,0,1789,1790,5,60,0,0,1790,1792,5,435,0,0,1791,1793,3,
  	1312,656,0,1792,1791,1,0,0,0,1792,1793,1,0,0,0,1793,1794,1,0,0,0,1794,
  	1858,3,54,27,0,1795,1796,5,106,0,0,1796,1797,5,435,0,0,1797,1801,3,54,
  	27,0,1798,1800,3,694,347,0,1799,1798,1,0,0,0,1800,1803,1,0,0,0,1801,1799,
  	1,0,0,0,1801,1802,1,0,0,0,1802,1858,1,0,0,0,1803,1801,1,0,0,0,1804,1805,
  	5,485,0,0,1805,1807,5,435,0,0,1806,1808,3,1312,656,0,1807,1806,1,0,0,
  	0,1807,1808,1,0,0,0,1808,1809,1,0,0,0,1809,1813,3,54,27,0,1810,1812,3,
  	696,348,0,1811,1810,1,0,0,0,1812,1815,1,0,0,0,1813,1811,1,0,0,0,1813,
  	1814,1,0,0,0,1814,1858,1,0,0,0,1815,1813,1,0,0,0,1816,1817,5,111,0,0,
  	1817,1819,5,435,0,0,1818,1820,3,1312,656,0,1819,1818,1,0,0,0,1819,1820,
  	1,0,0,0,1820,1821,1,0,0,0,1821,1858,3,1418,709,0,1822,1823,5,623,0,0,
  	1823,1824,5,435,0,0,1824,1858,3,54,27,0,1825,1826,5,484,0,0,1826,1828,
  	5,435,0,0,1827,1829,3,1312,656,0,1828,1827,1,0,0,0,1828,1829,1,0,0,0,
  	1829,1834,1,0,0,0,1830,1831,3,1406,703,0,1831,1832,5,283,0,0,1832,1833,
  	3,1216,608,0,1833,1835,1,0,0,0,1834,1830,1,0,0,0,1834,1835,1,0,0,0,1835,
  	1858,1,0,0,0,1836,1837,5,211,0,0,1837,1838,5,435,0,0,1838,1839,3,1404,
  	702,0,1839,1840,5,670,0,0,1840,1841,5,600,0,0,1841,1843,3,1380,690,0,
  	1842,1844,3,50,25,0,1843,1842,1,0,0,0,1843,1844,1,0,0,0,1844,1858,1,0,
  	0,0,1845,1846,4,15,7,0,1846,1847,5,181,0,0,1847,1848,5,435,0,0,1848,1849,
  	3,54,27,0,1849,1850,5,598,0,0,1850,1858,1,0,0,0,1851,1852,4,15,8,0,1852,
  	1853,5,270,0,0,1853,1854,5,435,0,0,1854,1855,3,54,27,0,1855,1856,5,598,
  	0,0,1856,1858,1,0,0,0,1857,1761,1,0,0,0,1857,1771,1,0,0,0,1857,1774,1,
  	0,0,0,1857,1780,1,0,0,0,1857,1789,1,0,0,0,1857,1795,1,0,0,0,1857,1804,
  	1,0,0,0,1857,1816,1,0,0,0,1857,1822,1,0,0,0,1857,1825,1,0,0,0,1857,1836,
  	1,0,0,0,1857,1845,1,0,0,0,1857,1851,1,0,0,0,1858,31,1,0,0,0,1859,1862,
  	3,36,18,0,1860,1862,3,1196,598,0,1861,1859,1,0,0,0,1861,1860,1,0,0,0,
  	1862,1871,1,0,0,0,1863,1867,5,29,0,0,1864,1868,3,36,18,0,1865,1868,3,
  	34,17,0,1866,1868,3,1196,598,0,1867,1864,1,0,0,0,1867,1865,1,0,0,0,1867,
  	1866,1,0,0,0,1868,1870,1,0,0,0,1869,1863,1,0,0,0,1870,1873,1,0,0,0,1871,
  	1869,1,0,0,0,1871,1872,1,0,0,0,1872,33,1,0,0,0,1873,1871,1,0,0,0,1874,
  	1878,3,44,22,0,1875,1878,3,46,23,0,1876,1878,3,50,25,0,1877,1874,1,0,
  	0,0,1877,1875,1,0,0,0,1877,1876,1,0,0,0,1878,35,1,0,0,0,1879,1881,5,50,
  	0,0,1880,1882,5,116,0,0,1881,1880,1,0,0,0,1881,1882,1,0,0,0,1882,1895,
  	1,0,0,0,1883,1884,3,1404,702,0,1884,1886,3,1122,561,0,1885,1887,3,1112,
  	556,0,1886,1885,1,0,0,0,1886,1887,1,0,0,0,1887,1889,1,0,0,0,1888,1890,
  	3,38,19,0,1889,1888,1,0,0,0,1889,1890,1,0,0,0,1890,1896,1,0,0,0,1891,
  	1892,5,32,0,0,1892,1893,3,88,44,0,1893,1894,5,33,0,0,1894,1896,1,0,0,
  	0,1895,1883,1,0,0,0,1895,1891,1,0,0,0,1896,2020,1,0,0,0,1897,1898,5,50,
  	0,0,1898,2020,3,1118,559,0,1899,1901,5,100,0,0,1900,1902,5,116,0,0,1901,
  	1900,1,0,0,0,1901,1902,1,0,0,0,1902,1903,1,0,0,0,1903,1904,3,1320,660,
  	0,1904,1905,3,1404,702,0,1905,1907,3,1122,561,0,1906,1908,3,38,19,0,1907,
  	1906,1,0,0,0,1907,1908,1,0,0,0,1908,2020,1,0,0,0,1909,1911,5,379,0,0,
  	1910,1912,5,116,0,0,1911,1910,1,0,0,0,1911,1912,1,0,0,0,1912,1913,1,0,
  	0,0,1913,1914,3,1320,660,0,1914,1916,3,1122,561,0,1915,1917,3,38,19,0,
  	1916,1915,1,0,0,0,1916,1917,1,0,0,0,1917,2020,1,0,0,0,1918,1940,5,187,
  	0,0,1919,1921,5,116,0,0,1920,1919,1,0,0,0,1920,1921,1,0,0,0,1921,1922,
  	1,0,0,0,1922,1924,3,1320,660,0,1923,1925,3,40,20,0,1924,1923,1,0,0,0,
  	1924,1925,1,0,0,0,1925,1941,1,0,0,0,1926,1927,5,235,0,0,1927,1928,5,299,
  	0,0,1928,1941,3,1320,660,0,1929,1930,5,450,0,0,1930,1941,5,299,0,0,1931,
  	1932,3,440,220,0,1932,1933,3,1330,665,0,1933,1941,1,0,0,0,1934,1935,4,
  	18,9,0,1935,1936,5,106,0,0,1936,1941,3,1404,702,0,1937,1938,4,18,10,0,
  	1938,1939,5,130,0,0,1939,1941,3,1404,702,0,1940,1920,1,0,0,0,1940,1926,
  	1,0,0,0,1940,1929,1,0,0,0,1940,1931,1,0,0,0,1940,1934,1,0,0,0,1940,1937,
  	1,0,0,0,1941,2020,1,0,0,0,1942,1943,5,180,0,0,1943,2020,5,297,0,0,1944,
  	1945,5,195,0,0,1945,2020,5,297,0,0,1946,1948,5,57,0,0,1947,1949,5,116,
  	0,0,1948,1947,1,0,0,0,1948,1949,1,0,0,0,1949,1950,1,0,0,0,1950,1963,3,
  	1320,660,0,1951,1952,5,533,0,0,1952,1956,5,168,0,0,1953,1954,4,18,11,
  	0,1954,1957,3,1016,508,0,1955,1957,3,1426,713,0,1956,1953,1,0,0,0,1956,
  	1955,1,0,0,0,1957,1964,1,0,0,0,1958,1959,5,187,0,0,1959,1964,5,168,0,
  	0,1960,1961,4,18,12,0,1961,1962,5,533,0,0,1962,1964,3,1154,577,0,1963,
  	1951,1,0,0,0,1963,1958,1,0,0,0,1963,1960,1,0,0,0,1964,2020,1,0,0,0,1965,
  	1966,4,18,13,0,1966,1967,5,57,0,0,1967,1968,5,272,0,0,1968,1969,3,1330,
  	665,0,1969,1970,3,1154,577,0,1970,2020,1,0,0,0,1971,1972,4,18,14,0,1972,
  	1973,5,57,0,0,1973,1974,5,106,0,0,1974,1975,3,1404,702,0,1975,1976,3,
  	1116,558,0,1976,2020,1,0,0,0,1977,1978,4,18,15,0,1978,1979,5,57,0,0,1979,
  	1980,5,130,0,0,1980,1981,3,1404,702,0,1981,1982,3,1116,558,0,1982,2020,
  	1,0,0,0,1983,1984,4,18,16,0,1984,1985,5,483,0,0,1985,1986,5,116,0,0,1986,
  	1987,3,1320,660,0,1987,1988,5,616,0,0,1988,1989,3,1404,702,0,1989,2020,
  	1,0,0,0,1990,1992,5,483,0,0,1991,1993,7,1,0,0,1992,1991,1,0,0,0,1992,
  	1993,1,0,0,0,1993,1994,1,0,0,0,1994,2020,3,1374,687,0,1995,1996,5,483,
  	0,0,1996,1997,3,440,220,0,1997,1998,3,1330,665,0,1998,1999,5,616,0,0,
  	1999,2000,3,1328,664,0,2000,2020,1,0,0,0,2001,2002,5,137,0,0,2002,2003,
  	5,616,0,0,2003,2007,3,1004,502,0,2004,2005,4,18,17,0,2005,2008,5,168,
  	0,0,2006,2008,3,1186,593,0,2007,2004,1,0,0,0,2007,2006,1,0,0,0,2008,2010,
  	1,0,0,0,2009,2011,3,1246,623,0,2010,2009,1,0,0,0,2010,2011,1,0,0,0,2011,
  	2020,1,0,0,0,2012,2020,5,234,0,0,2013,2014,5,423,0,0,2014,2015,5,90,0,
  	0,2015,2020,3,42,21,0,2016,2017,4,18,18,0,2017,2018,5,641,0,0,2018,2020,
  	5,433,0,0,2019,1879,1,0,0,0,2019,1897,1,0,0,0,2019,1899,1,0,0,0,2019,
  	1909,1,0,0,0,2019,1918,1,0,0,0,2019,1942,1,0,0,0,2019,1944,1,0,0,0,2019,
  	1946,1,0,0,0,2019,1965,1,0,0,0,2019,1971,1,0,0,0,2019,1977,1,0,0,0,2019,
  	1983,1,0,0,0,2019,1990,1,0,0,0,2019,1995,1,0,0,0,2019,2001,1,0,0,0,2019,
  	2012,1,0,0,0,2019,2013,1,0,0,0,2019,2016,1,0,0,0,2020,37,1,0,0,0,2021,
  	2022,5,52,0,0,2022,2025,3,1404,702,0,2023,2025,5,229,0,0,2024,2021,1,
  	0,0,0,2024,2023,1,0,0,0,2025,39,1,0,0,0,2026,2027,7,2,0,0,2027,41,1,0,
  	0,0,2028,2030,3,1404,702,0,2029,2031,3,362,181,0,2030,2029,1,0,0,0,2030,
  	2031,1,0,0,0,2031,2039,1,0,0,0,2032,2033,5,29,0,0,2033,2035,3,1404,702,
  	0,2034,2036,3,362,181,0,2035,2034,1,0,0,0,2035,2036,1,0,0,0,2036,2038,
  	1,0,0,0,2037,2032,1,0,0,0,2038,2041,1,0,0,0,2039,2037,1,0,0,0,2039,2040,
  	1,0,0,0,2040,43,1,0,0,0,2041,2039,1,0,0,0,2042,2044,5,55,0,0,2043,2045,
  	5,6,0,0,2044,2043,1,0,0,0,2044,2045,1,0,0,0,2045,2048,1,0,0,0,2046,2049,
  	5,168,0,0,2047,2049,3,1404,702,0,2048,2046,1,0,0,0,2048,2047,1,0,0,0,
  	2049,45,1,0,0,0,2050,2052,5,319,0,0,2051,2053,5,6,0,0,2052,2051,1,0,0,
  	0,2052,2053,1,0,0,0,2053,2056,1,0,0,0,2054,2057,5,168,0,0,2055,2057,3,
  	1404,702,0,2056,2054,1,0,0,0,2056,2055,1,0,0,0,2057,47,1,0,0,0,2058,2060,
  	3,44,22,0,2059,2061,3,46,23,0,2060,2059,1,0,0,0,2060,2061,1,0,0,0,2061,
  	2067,1,0,0,0,2062,2064,3,46,23,0,2063,2065,3,44,22,0,2064,2063,1,0,0,
  	0,2064,2065,1,0,0,0,2065,2067,1,0,0,0,2066,2058,1,0,0,0,2066,2062,1,0,
  	0,0,2067,49,1,0,0,0,2068,2069,4,25,19,0,2069,2070,7,3,0,0,2070,2071,5,
  	651,0,0,2071,51,1,0,0,0,2072,2073,5,482,0,0,2073,2074,5,433,0,0,2074,
  	53,1,0,0,0,2075,2078,5,56,0,0,2076,2078,3,1406,703,0,2077,2075,1,0,0,
  	0,2077,2076,1,0,0,0,2078,55,1,0,0,0,2079,2080,5,598,0,0,2080,2092,3,1356,
  	678,0,2081,2082,7,4,0,0,2082,2083,5,153,0,0,2083,2085,3,1442,721,0,2084,
  	2086,3,64,32,0,2085,2084,1,0,0,0,2085,2086,1,0,0,0,2086,2093,1,0,0,0,
  	2087,2088,5,483,0,0,2088,2089,5,616,0,0,2089,2093,3,1404,702,0,2090,2091,
  	4,28,20,0,2091,2093,3,64,32,0,2092,2081,1,0,0,0,2092,2087,1,0,0,0,2092,
  	2090,1,0,0,0,2093,57,1,0,0,0,2094,2095,5,631,0,0,2095,2096,5,598,0,0,
  	2096,2097,3,1356,678,0,2097,2098,5,533,0,0,2098,2100,7,5,0,0,2099,2101,
  	3,60,30,0,2100,2099,1,0,0,0,2100,2101,1,0,0,0,2101,59,1,0,0,0,2102,2109,
  	3,62,31,0,2103,2105,5,29,0,0,2104,2103,1,0,0,0,2104,2105,1,0,0,0,2105,
  	2106,1,0,0,0,2106,2108,3,62,31,0,2107,2104,1,0,0,0,2108,2111,1,0,0,0,
  	2109,2107,1,0,0,0,2109,2110,1,0,0,0,2110,61,1,0,0,0,2111,2109,1,0,0,0,
  	2112,2113,3,160,80,0,2113,63,1,0,0,0,2114,2121,3,66,33,0,2115,2117,5,
  	29,0,0,2116,2115,1,0,0,0,2116,2117,1,0,0,0,2117,2118,1,0,0,0,2118,2120,
  	3,66,33,0,2119,2116,1,0,0,0,2120,2123,1,0,0,0,2121,2119,1,0,0,0,2121,
  	2122,1,0,0,0,2122,65,1,0,0,0,2123,2121,1,0,0,0,2124,2126,5,274,0,0,2125,
  	2127,5,6,0,0,2126,2125,1,0,0,0,2126,2127,1,0,0,0,2127,2128,1,0,0,0,2128,
  	2137,3,1470,735,0,2129,2137,3,152,76,0,2130,2137,3,154,77,0,2131,2137,
  	3,160,80,0,2132,2137,3,162,81,0,2133,2137,3,168,84,0,2134,2135,4,33,21,
  	0,2135,2137,3,170,85,0,2136,2124,1,0,0,0,2136,2129,1,0,0,0,2136,2130,
  	1,0,0,0,2136,2131,1,0,0,0,2136,2132,1,0,0,0,2136,2133,1,0,0,0,2136,2134,
  	1,0,0,0,2137,67,1,0,0,0,2138,2140,5,274,0,0,2139,2141,5,6,0,0,2140,2139,
  	1,0,0,0,2140,2141,1,0,0,0,2141,2142,1,0,0,0,2142,2146,3,1470,735,0,2143,
  	2146,3,152,76,0,2144,2146,3,154,77,0,2145,2138,1,0,0,0,2145,2143,1,0,
  	0,0,2145,2144,1,0,0,0,2146,69,1,0,0,0,2147,2149,3,176,88,0,2148,2147,
  	1,0,0,0,2148,2149,1,0,0,0,2149,2151,1,0,0,0,2150,2152,3,1230,615,0,2151,
  	2150,1,0,0,0,2151,2152,1,0,0,0,2152,2154,1,0,0,0,2153,2155,3,178,89,0,
  	2154,2153,1,0,0,0,2154,2155,1,0,0,0,2155,2156,1,0,0,0,2156,2157,5,661,
  	0,0,2157,2158,3,1352,676,0,2158,2159,3,72,36,0,2159,71,1,0,0,0,2160,2162,
  	3,1322,661,0,2161,2160,1,0,0,0,2161,2162,1,0,0,0,2162,2163,1,0,0,0,2163,
  	2164,5,63,0,0,2164,2165,3,74,37,0,2165,73,1,0,0,0,2166,2168,3,98,49,0,
  	2167,2169,3,76,38,0,2168,2167,1,0,0,0,2168,2169,1,0,0,0,2169,75,1,0,0,
  	0,2170,2172,5,670,0,0,2171,2173,7,6,0,0,2172,2171,1,0,0,0,2172,2173,1,
  	0,0,0,2173,2174,1,0,0,0,2174,2175,5,106,0,0,2175,2176,5,421,0,0,2176,
  	77,1,0,0,0,2177,2178,4,39,22,0,2178,2207,5,280,0,0,2179,2180,5,511,0,
  	0,2180,2181,3,1464,732,0,2181,2182,5,348,0,0,2182,2183,5,299,0,0,2183,
  	2208,1,0,0,0,2184,2185,4,39,23,0,2185,2186,5,481,0,0,2186,2191,5,772,
  	0,0,2187,2188,4,39,24,0,2188,2189,5,236,0,0,2189,2190,5,102,0,0,2190,
  	2192,3,1404,702,0,2191,2187,1,0,0,0,2191,2192,1,0,0,0,2192,2197,1,0,0,
  	0,2193,2194,5,403,0,0,2194,2195,5,509,0,0,2195,2196,5,413,0,0,2196,2198,
  	5,204,0,0,2197,2193,1,0,0,0,2197,2198,1,0,0,0,2198,2208,1,0,0,0,2199,
  	2200,4,39,25,0,2200,2201,7,7,0,0,2201,2202,3,1404,702,0,2202,2203,3,1404,
  	702,0,2203,2208,1,0,0,0,2204,2205,4,39,26,0,2205,2206,5,481,0,0,2206,
  	2208,5,810,0,0,2207,2179,1,0,0,0,2207,2184,1,0,0,0,2207,2199,1,0,0,0,
  	2207,2204,1,0,0,0,2208,2211,1,0,0,0,2209,2211,1,0,0,0,2210,2177,1,0,0,
  	0,2210,2209,1,0,0,0,2211,79,1,0,0,0,2212,2231,5,140,0,0,2213,2232,3,82,
  	41,0,2214,2232,3,86,43,0,2215,2232,3,108,54,0,2216,2232,3,102,51,0,2217,
  	2232,3,110,55,0,2218,2232,3,124,62,0,2219,2232,3,172,86,0,2220,2232,3,
  	180,90,0,2221,2232,3,118,59,0,2222,2232,3,130,65,0,2223,2232,3,136,68,
  	0,2224,2232,3,184,92,0,2225,2226,4,40,27,0,2226,2232,3,186,93,0,2227,
  	2228,4,40,28,0,2228,2232,3,188,94,0,2229,2230,4,40,29,0,2230,2232,3,138,
  	69,0,2231,2213,1,0,0,0,2231,2214,1,0,0,0,2231,2215,1,0,0,0,2231,2216,
  	1,0,0,0,2231,2217,1,0,0,0,2231,2218,1,0,0,0,2231,2219,1,0,0,0,2231,2220,
  	1,0,0,0,2231,2221,1,0,0,0,2231,2222,1,0,0,0,2231,2223,1,0,0,0,2231,2224,
  	1,0,0,0,2231,2225,1,0,0,0,2231,2227,1,0,0,0,2231,2229,1,0,0,0,2232,81,
  	1,0,0,0,2233,2235,5,151,0,0,2234,2236,3,1238,619,0,2235,2234,1,0,0,0,
  	2235,2236,1,0,0,0,2236,2237,1,0,0,0,2237,2241,3,1334,667,0,2238,2240,
  	3,84,42,0,2239,2238,1,0,0,0,2240,2243,1,0,0,0,2241,2239,1,0,0,0,2241,
  	2242,1,0,0,0,2242,83,1,0,0,0,2243,2241,1,0,0,0,2244,2249,3,1206,603,0,
  	2245,2249,3,1202,601,0,2246,2247,4,42,30,0,2247,2249,3,1204,602,0,2248,
  	2244,1,0,0,0,2248,2245,1,0,0,0,2248,2246,1,0,0,0,2249,85,1,0,0,0,2250,
  	2252,5,603,0,0,2251,2250,1,0,0,0,2251,2252,1,0,0,0,2252,2253,1,0,0,0,
  	2253,2255,5,600,0,0,2254,2256,3,1238,619,0,2255,2254,1,0,0,0,2255,2256,
  	1,0,0,0,2256,2257,1,0,0,0,2257,2274,3,1374,687,0,2258,2259,5,32,0,0,2259,
  	2260,3,88,44,0,2260,2261,5,33,0,0,2261,2263,1,0,0,0,2262,2258,1,0,0,0,
  	2262,2263,1,0,0,0,2263,2265,1,0,0,0,2264,2266,3,1192,596,0,2265,2264,
  	1,0,0,0,2265,2266,1,0,0,0,2266,2275,1,0,0,0,2267,2268,5,309,0,0,2268,
  	2275,3,1380,690,0,2269,2270,5,32,0,0,2270,2271,5,309,0,0,2271,2272,3,
  	1380,690,0,2272,2273,5,33,0,0,2273,2275,1,0,0,0,2274,2262,1,0,0,0,2274,
  	2267,1,0,0,0,2274,2269,1,0,0,0,2275,87,1,0,0,0,2276,2281,3,90,45,0,2277,
  	2278,5,29,0,0,2278,2280,3,90,45,0,2279,2277,1,0,0,0,2280,2283,1,0,0,0,
  	2281,2279,1,0,0,0,2281,2282,1,0,0,0,2282,89,1,0,0,0,2283,2281,1,0,0,0,
  	2284,2287,3,1110,555,0,2285,2287,3,1118,559,0,2286,2284,1,0,0,0,2286,
  	2285,1,0,0,0,2287,91,1,0,0,0,2288,2290,7,8,0,0,2289,2288,1,0,0,0,2289,
  	2290,1,0,0,0,2290,2291,1,0,0,0,2291,2292,3,94,47,0,2292,93,1,0,0,0,2293,
  	2295,5,63,0,0,2294,2293,1,0,0,0,2294,2295,1,0,0,0,2295,2296,1,0,0,0,2296,
  	2297,3,98,49,0,2297,95,1,0,0,0,2298,2300,3,300,150,0,2299,2301,3,376,
  	188,0,2300,2299,1,0,0,0,2300,2301,1,0,0,0,2301,2304,1,0,0,0,2302,2304,
  	3,304,152,0,2303,2298,1,0,0,0,2303,2302,1,0,0,0,2304,97,1,0,0,0,2305,
  	2307,3,300,150,0,2306,2308,3,376,188,0,2307,2306,1,0,0,0,2307,2308,1,
  	0,0,0,2308,99,1,0,0,0,2309,2313,5,140,0,0,2310,2314,3,102,51,0,2311,2314,
  	3,108,54,0,2312,2314,3,110,55,0,2313,2310,1,0,0,0,2313,2311,1,0,0,0,2313,
  	2312,1,0,0,0,2314,2316,1,0,0,0,2315,2317,5,30,0,0,2316,2315,1,0,0,0,2316,
  	2317,1,0,0,0,2317,2318,1,0,0,0,2318,2319,5,0,0,1,2319,101,1,0,0,0,2320,
  	2322,3,1230,615,0,2321,2320,1,0,0,0,2321,2322,1,0,0,0,2322,2323,1,0,0,
  	0,2323,2326,5,452,0,0,2324,2325,4,51,31,0,2325,2327,3,1238,619,0,2326,
  	2324,1,0,0,0,2326,2327,1,0,0,0,2327,2328,1,0,0,0,2328,2329,3,1338,669,
  	0,2329,2338,5,32,0,0,2330,2335,3,1242,621,0,2331,2332,5,29,0,0,2332,2334,
  	3,1242,621,0,2333,2331,1,0,0,0,2334,2337,1,0,0,0,2335,2333,1,0,0,0,2335,
  	2336,1,0,0,0,2336,2339,1,0,0,0,2337,2335,1,0,0,0,2338,2330,1,0,0,0,2338,
  	2339,1,0,0,0,2339,2340,1,0,0,0,2340,2344,5,33,0,0,2341,2343,3,112,56,
  	0,2342,2341,1,0,0,0,2343,2346,1,0,0,0,2344,2342,1,0,0,0,2344,2345,1,0,
  	0,0,2345,2347,1,0,0,0,2346,2344,1,0,0,0,2347,2348,3,106,53,0,2348,103,
  	1,0,0,0,2349,2352,3,1436,718,0,2350,2352,5,842,0,0,2351,2349,1,0,0,0,
  	2351,2350,1,0,0,0,2352,105,1,0,0,0,2353,2358,3,1030,515,0,2354,2355,4,
  	53,32,0,2355,2356,5,63,0,0,2356,2358,3,104,52,0,2357,2353,1,0,0,0,2357,
  	2354,1,0,0,0,2358,107,1,0,0,0,2359,2361,3,1230,615,0,2360,2359,1,0,0,
  	0,2360,2361,1,0,0,0,2361,2362,1,0,0,0,2362,2365,5,242,0,0,2363,2364,4,
  	54,33,0,2364,2366,3,1238,619,0,2365,2363,1,0,0,0,2365,2366,1,0,0,0,2366,
  	2367,1,0,0,0,2367,2368,3,1342,671,0,2368,2377,5,32,0,0,2369,2374,3,1244,
  	622,0,2370,2371,5,29,0,0,2371,2373,3,1244,622,0,2372,2370,1,0,0,0,2373,
  	2376,1,0,0,0,2374,2372,1,0,0,0,2374,2375,1,0,0,0,2375,2378,1,0,0,0,2376,
  	2374,1,0,0,0,2377,2369,1,0,0,0,2377,2378,1,0,0,0,2378,2379,1,0,0,0,2379,
  	2380,5,33,0,0,2380,2381,5,504,0,0,2381,2385,3,1248,624,0,2382,2384,3,
  	112,56,0,2383,2382,1,0,0,0,2384,2387,1,0,0,0,2385,2383,1,0,0,0,2385,2386,
  	1,0,0,0,2386,2388,1,0,0,0,2387,2385,1,0,0,0,2388,2389,3,106,53,0,2389,
  	109,1,0,0,0,2390,2392,5,54,0,0,2391,2390,1,0,0,0,2391,2392,1,0,0,0,2392,
  	2393,1,0,0,0,2393,2396,5,242,0,0,2394,2395,4,55,34,0,2395,2397,3,1238,
  	619,0,2396,2394,1,0,0,0,2396,2397,1,0,0,0,2397,2398,1,0,0,0,2398,2399,
  	3,1366,683,0,2399,2400,5,504,0,0,2400,2401,7,9,0,0,2401,2402,5,546,0,
  	0,2402,2403,3,1442,721,0,2403,111,1,0,0,0,2404,2410,3,116,58,0,2405,2407,
  	5,401,0,0,2406,2405,1,0,0,0,2406,2407,1,0,0,0,2407,2408,1,0,0,0,2408,
  	2410,5,177,0,0,2409,2404,1,0,0,0,2409,2406,1,0,0,0,2410,113,1,0,0,0,2411,
  	2413,3,112,56,0,2412,2411,1,0,0,0,2413,2414,1,0,0,0,2414,2412,1,0,0,0,
  	2414,2415,1,0,0,0,2415,115,1,0,0,0,2416,2417,5,119,0,0,2417,2438,3,1442,
  	721,0,2418,2422,5,301,0,0,2419,2423,5,563,0,0,2420,2421,4,58,35,0,2421,
  	2423,3,1404,702,0,2422,2419,1,0,0,0,2422,2420,1,0,0,0,2423,2438,1,0,0,
  	0,2424,2425,5,403,0,0,2425,2438,5,563,0,0,2426,2427,5,134,0,0,2427,2438,
  	5,563,0,0,2428,2429,5,463,0,0,2429,2430,5,563,0,0,2430,2438,5,154,0,0,
  	2431,2432,5,378,0,0,2432,2433,5,563,0,0,2433,2438,5,154,0,0,2434,2435,
  	5,563,0,0,2435,2436,5,523,0,0,2436,2438,7,10,0,0,2437,2416,1,0,0,0,2437,
  	2418,1,0,0,0,2437,2424,1,0,0,0,2437,2426,1,0,0,0,2437,2428,1,0,0,0,2437,
  	2431,1,0,0,0,2437,2434,1,0,0,0,2438,117,1,0,0,0,2439,2441,3,1310,655,
  	0,2440,2439,1,0,0,0,2440,2441,1,0,0,0,2441,2477,1,0,0,0,2442,2444,5,635,
  	0,0,2443,2442,1,0,0,0,2443,2444,1,0,0,0,2444,2445,1,0,0,0,2445,2446,5,
  	272,0,0,2446,2448,3,1328,664,0,2447,2449,3,1156,578,0,2448,2447,1,0,0,
  	0,2448,2449,1,0,0,0,2449,2450,1,0,0,0,2450,2454,3,122,61,0,2451,2453,
  	3,1150,575,0,2452,2451,1,0,0,0,2453,2456,1,0,0,0,2454,2452,1,0,0,0,2454,
  	2455,1,0,0,0,2455,2478,1,0,0,0,2456,2454,1,0,0,0,2457,2458,5,241,0,0,
  	2458,2459,5,272,0,0,2459,2460,3,1328,664,0,2460,2464,3,122,61,0,2461,
  	2463,3,1158,579,0,2462,2461,1,0,0,0,2463,2466,1,0,0,0,2464,2462,1,0,0,
  	0,2464,2465,1,0,0,0,2465,2478,1,0,0,0,2466,2464,1,0,0,0,2467,2468,5,549,
  	0,0,2468,2469,5,272,0,0,2469,2470,3,1328,664,0,2470,2474,3,122,61,0,2471,
  	2473,3,1160,580,0,2472,2471,1,0,0,0,2473,2476,1,0,0,0,2474,2472,1,0,0,
  	0,2474,2475,1,0,0,0,2475,2478,1,0,0,0,2476,2474,1,0,0,0,2477,2443,1,0,
  	0,0,2477,2457,1,0,0,0,2477,2467,1,0,0,0,2478,2480,1,0,0,0,2479,2481,3,
  	48,24,0,2480,2479,1,0,0,0,2480,2481,1,0,0,0,2481,119,1,0,0,0,2482,2493,
  	3,1328,664,0,2483,2485,3,1328,664,0,2484,2483,1,0,0,0,2484,2485,1,0,0,
  	0,2485,2486,1,0,0,0,2486,2487,5,647,0,0,2487,2493,3,1148,574,0,2488,2489,
  	3,1328,664,0,2489,2490,5,625,0,0,2490,2491,3,1148,574,0,2491,2493,1,0,
  	0,0,2492,2482,1,0,0,0,2492,2484,1,0,0,0,2492,2488,1,0,0,0,2493,121,1,
  	0,0,0,2494,2495,5,413,0,0,2495,2496,3,1380,690,0,2496,2497,3,1144,572,
  	0,2497,123,1,0,0,0,2498,2499,5,320,0,0,2499,2500,5,253,0,0,2500,2501,
  	3,1358,679,0,2501,2502,5,50,0,0,2502,2503,5,629,0,0,2503,2505,3,1442,
  	721,0,2504,2506,3,126,63,0,2505,2504,1,0,0,0,2505,2506,1,0,0,0,2506,125,
  	1,0,0,0,2507,2514,3,128,64,0,2508,2510,5,29,0,0,2509,2508,1,0,0,0,2509,
  	2510,1,0,0,0,2510,2511,1,0,0,0,2511,2513,3,128,64,0,2512,2509,1,0,0,0,
  	2513,2516,1,0,0,0,2514,2512,1,0,0,0,2514,2515,1,0,0,0,2515,127,1,0,0,
  	0,2516,2514,1,0,0,0,2517,2524,3,148,74,0,2518,2524,3,150,75,0,2519,2524,
  	3,158,79,0,2520,2524,3,160,80,0,2521,2524,3,162,81,0,2522,2524,3,164,
  	82,0,2523,2517,1,0,0,0,2523,2518,1,0,0,0,2523,2519,1,0,0,0,2523,2520,
  	1,0,0,0,2523,2521,1,0,0,0,2523,2522,1,0,0,0,2524,129,1,0,0,0,2525,2526,
  	5,530,0,0,2526,2527,3,1368,684,0,2527,2528,5,235,0,0,2528,2529,5,154,
  	0,0,2529,2530,5,673,0,0,2530,2531,3,1464,732,0,2531,2532,3,132,66,0,2532,
  	131,1,0,0,0,2533,2534,5,420,0,0,2534,2535,5,32,0,0,2535,2540,3,134,67,
  	0,2536,2537,5,29,0,0,2537,2539,3,134,67,0,2538,2536,1,0,0,0,2539,2542,
  	1,0,0,0,2540,2538,1,0,0,0,2540,2541,1,0,0,0,2541,2543,1,0,0,0,2542,2540,
  	1,0,0,0,2543,2544,5,33,0,0,2544,133,1,0,0,0,2545,2546,5,260,0,0,2546,
  	2560,3,1442,721,0,2547,2548,5,151,0,0,2548,2560,3,1442,721,0,2549,2550,
  	5,644,0,0,2550,2560,3,1442,721,0,2551,2552,5,436,0,0,2552,2560,3,1442,
  	721,0,2553,2554,5,545,0,0,2554,2560,3,1442,721,0,2555,2556,5,428,0,0,
  	2556,2560,3,1442,721,0,2557,2558,5,443,0,0,2558,2560,3,1416,708,0,2559,
  	2545,1,0,0,0,2559,2547,1,0,0,0,2559,2549,1,0,0,0,2559,2551,1,0,0,0,2559,
  	2553,1,0,0,0,2559,2555,1,0,0,0,2559,2557,1,0,0,0,2560,135,1,0,0,0,2561,
  	2562,5,598,0,0,2562,2563,3,1354,677,0,2563,2568,3,140,70,0,2564,2565,
  	5,646,0,0,2565,2566,5,320,0,0,2566,2567,5,253,0,0,2567,2569,3,1360,680,
  	0,2568,2564,1,0,0,0,2568,2569,1,0,0,0,2569,2571,1,0,0,0,2570,2572,3,144,
  	72,0,2571,2570,1,0,0,0,2571,2572,1,0,0,0,2572,137,1,0,0,0,2573,2574,5,
  	631,0,0,2574,2575,5,598,0,0,2575,2576,3,1354,677,0,2576,2577,5,50,0,0,
  	2577,2579,3,142,71,0,2578,2580,3,60,30,0,2579,2578,1,0,0,0,2579,2580,
  	1,0,0,0,2580,139,1,0,0,0,2581,2582,5,50,0,0,2582,2589,3,142,71,0,2583,
  	2586,4,70,36,0,2584,2585,5,50,0,0,2585,2587,3,142,71,0,2586,2584,1,0,
  	0,0,2586,2587,1,0,0,0,2587,2589,1,0,0,0,2588,2581,1,0,0,0,2588,2583,1,
  	0,0,0,2589,141,1,0,0,0,2590,2591,5,153,0,0,2591,2592,3,1442,721,0,2592,
  	143,1,0,0,0,2593,2600,3,146,73,0,2594,2596,5,29,0,0,2595,2594,1,0,0,0,
  	2595,2596,1,0,0,0,2596,2597,1,0,0,0,2597,2599,3,146,73,0,2598,2595,1,
  	0,0,0,2599,2602,1,0,0,0,2600,2598,1,0,0,0,2600,2601,1,0,0,0,2601,145,
  	1,0,0,0,2602,2600,1,0,0,0,2603,2616,3,148,74,0,2604,2616,3,152,76,0,2605,
  	2616,3,154,77,0,2606,2616,3,156,78,0,2607,2616,3,158,79,0,2608,2616,3,
  	160,80,0,2609,2616,3,162,81,0,2610,2616,3,164,82,0,2611,2612,4,73,37,
  	0,2612,2616,3,166,83,0,2613,2614,4,73,38,0,2614,2616,3,168,84,0,2615,
  	2603,1,0,0,0,2615,2604,1,0,0,0,2615,2605,1,0,0,0,2615,2606,1,0,0,0,2615,
  	2607,1,0,0,0,2615,2608,1,0,0,0,2615,2609,1,0,0,0,2615,2610,1,0,0,0,2615,
  	2611,1,0,0,0,2615,2613,1,0,0,0,2616,147,1,0,0,0,2617,2619,5,274,0,0,2618,
  	2620,5,6,0,0,2619,2618,1,0,0,0,2619,2620,1,0,0,0,2620,2621,1,0,0,0,2621,
  	2622,3,1470,735,0,2622,149,1,0,0,0,2623,2625,7,11,0,0,2624,2626,5,6,0,
  	0,2625,2624,1,0,0,0,2625,2626,1,0,0,0,2626,2627,1,0,0,0,2627,2628,3,1470,
  	735,0,2628,151,1,0,0,0,2629,2631,5,68,0,0,2630,2632,5,6,0,0,2631,2630,
  	1,0,0,0,2631,2632,1,0,0,0,2632,2633,1,0,0,0,2633,2634,3,1470,735,0,2634,
  	153,1,0,0,0,2635,2637,5,356,0,0,2636,2638,5,6,0,0,2637,2636,1,0,0,0,2637,
  	2638,1,0,0,0,2638,2639,1,0,0,0,2639,2640,3,1470,735,0,2640,155,1,0,0,
  	0,2641,2643,5,220,0,0,2642,2644,5,6,0,0,2643,2642,1,0,0,0,2643,2644,1,
  	0,0,0,2644,2645,1,0,0,0,2645,2646,3,1470,735,0,2646,157,1,0,0,0,2647,
  	2649,5,398,0,0,2648,2650,5,6,0,0,2649,2648,1,0,0,0,2649,2650,1,0,0,0,
  	2650,2651,1,0,0,0,2651,2652,3,1418,709,0,2652,159,1,0,0,0,2653,2655,5,
  	579,0,0,2654,2653,1,0,0,0,2654,2655,1,0,0,0,2655,2656,1,0,0,0,2656,2658,
  	5,202,0,0,2657,2659,5,6,0,0,2658,2657,1,0,0,0,2658,2659,1,0,0,0,2659,
  	2660,1,0,0,0,2660,2661,3,1372,686,0,2661,161,1,0,0,0,2662,2663,7,12,0,
  	0,2663,163,1,0,0,0,2664,2666,5,119,0,0,2665,2667,5,6,0,0,2666,2665,1,
  	0,0,0,2666,2667,1,0,0,0,2667,2668,1,0,0,0,2668,2669,3,1442,721,0,2669,
  	165,1,0,0,0,2670,2672,5,227,0,0,2671,2673,5,6,0,0,2672,2671,1,0,0,0,2672,
  	2673,1,0,0,0,2673,2674,1,0,0,0,2674,2675,3,1470,735,0,2675,167,1,0,0,
  	0,2676,2678,5,197,0,0,2677,2679,5,6,0,0,2678,2677,1,0,0,0,2678,2679,1,
  	0,0,0,2679,2680,1,0,0,0,2680,2681,3,1436,718,0,2681,169,1,0,0,0,2682,
  	2684,5,202,0,0,2683,2685,5,6,0,0,2684,2683,1,0,0,0,2684,2685,1,0,0,0,
  	2685,2686,1,0,0,0,2686,2687,3,1482,741,0,2687,171,1,0,0,0,2688,2690,3,
  	174,87,0,2689,2688,1,0,0,0,2689,2690,1,0,0,0,2690,2692,1,0,0,0,2691,2693,
  	3,1230,615,0,2692,2691,1,0,0,0,2692,2693,1,0,0,0,2693,2695,1,0,0,0,2694,
  	2696,3,178,89,0,2695,2694,1,0,0,0,2695,2696,1,0,0,0,2696,2697,1,0,0,0,
  	2697,2698,5,661,0,0,2698,2699,3,1350,675,0,2699,2700,3,72,36,0,2700,173,
  	1,0,0,0,2701,2702,5,424,0,0,2702,2704,5,488,0,0,2703,2705,3,176,88,0,
  	2704,2703,1,0,0,0,2704,2705,1,0,0,0,2705,2708,1,0,0,0,2706,2708,3,176,
  	88,0,2707,2701,1,0,0,0,2707,2706,1,0,0,0,2708,175,1,0,0,0,2709,2710,5,
  	55,0,0,2710,2711,5,6,0,0,2711,2712,7,13,0,0,2712,177,1,0,0,0,2713,2714,
  	5,563,0,0,2714,2715,5,523,0,0,2715,2716,7,10,0,0,2716,179,1,0,0,0,2717,
  	2719,3,1230,615,0,2718,2717,1,0,0,0,2718,2719,1,0,0,0,2719,2720,1,0,0,
  	0,2720,2723,5,620,0,0,2721,2722,4,90,39,0,2722,2724,3,1238,619,0,2723,
  	2721,1,0,0,0,2723,2724,1,0,0,0,2724,2725,1,0,0,0,2725,2726,3,1346,673,
  	0,2726,2727,7,14,0,0,2727,2728,7,15,0,0,2728,2729,5,413,0,0,2729,2730,
  	3,1380,690,0,2730,2731,5,236,0,0,2731,2732,5,192,0,0,2732,2734,5,516,
  	0,0,2733,2735,3,182,91,0,2734,2733,1,0,0,0,2734,2735,1,0,0,0,2735,2736,
  	1,0,0,0,2736,2737,3,1030,515,0,2737,181,1,0,0,0,2738,2739,7,16,0,0,2739,
  	2740,3,1464,732,0,2740,183,1,0,0,0,2741,2743,3,1230,615,0,2742,2741,1,
  	0,0,0,2742,2743,1,0,0,0,2743,2744,1,0,0,0,2744,2746,5,209,0,0,2745,2747,
  	3,1238,619,0,2746,2745,1,0,0,0,2746,2747,1,0,0,0,2747,2748,1,0,0,0,2748,
  	2749,3,1362,681,0,2749,2750,5,413,0,0,2750,2751,5,519,0,0,2751,2758,3,
  	1108,554,0,2752,2753,5,413,0,0,2753,2755,5,123,0,0,2754,2756,5,401,0,
  	0,2755,2754,1,0,0,0,2755,2756,1,0,0,0,2756,2757,1,0,0,0,2757,2759,5,448,
  	0,0,2758,2752,1,0,0,0,2758,2759,1,0,0,0,2759,2766,1,0,0,0,2760,2767,5,
  	195,0,0,2761,2764,5,180,0,0,2762,2763,5,413,0,0,2763,2765,3,604,302,0,
  	2764,2762,1,0,0,0,2764,2765,1,0,0,0,2765,2767,1,0,0,0,2766,2760,1,0,0,
  	0,2766,2761,1,0,0,0,2766,2767,1,0,0,0,2767,2770,1,0,0,0,2768,2769,5,119,
  	0,0,2769,2771,3,1442,721,0,2770,2768,1,0,0,0,2770,2771,1,0,0,0,2771,2772,
  	1,0,0,0,2772,2773,5,186,0,0,2773,2774,3,1030,515,0,2774,185,1,0,0,0,2775,
  	2777,5,684,0,0,2776,2778,3,1238,619,0,2777,2776,1,0,0,0,2777,2778,1,0,
  	0,0,2778,2779,1,0,0,0,2779,2780,3,680,340,0,2780,187,1,0,0,0,2781,2782,
  	5,424,0,0,2782,2783,5,488,0,0,2783,2784,5,549,0,0,2784,2785,5,743,0,0,
  	2785,2786,5,735,0,0,2786,2790,3,1422,711,0,2787,2789,3,190,95,0,2788,
  	2787,1,0,0,0,2789,2792,1,0,0,0,2790,2788,1,0,0,0,2790,2791,1,0,0,0,2791,
  	2807,1,0,0,0,2792,2790,1,0,0,0,2793,2794,5,549,0,0,2794,2795,5,743,0,
  	0,2795,2797,5,735,0,0,2796,2798,3,1238,619,0,2797,2796,1,0,0,0,2797,2798,
  	1,0,0,0,2798,2799,1,0,0,0,2799,2803,3,1422,711,0,2800,2802,3,190,95,0,
  	2801,2800,1,0,0,0,2802,2805,1,0,0,0,2803,2801,1,0,0,0,2803,2804,1,0,0,
  	0,2804,2807,1,0,0,0,2805,2803,1,0,0,0,2806,2781,1,0,0,0,2806,2793,1,0,
  	0,0,2807,189,1,0,0,0,2808,2809,5,388,0,0,2809,2810,5,606,0,0,2810,2824,
  	3,1444,722,0,2811,2812,5,740,0,0,2812,2813,5,606,0,0,2813,2824,3,1444,
  	722,0,2814,2815,5,742,0,0,2815,2816,3,1444,722,0,2816,2817,5,266,0,0,
  	2817,2818,5,90,0,0,2818,2819,3,1422,711,0,2819,2824,1,0,0,0,2820,2821,
  	5,741,0,0,2821,2822,5,606,0,0,2822,2824,3,1444,722,0,2823,2808,1,0,0,
  	0,2823,2811,1,0,0,0,2823,2814,1,0,0,0,2823,2820,1,0,0,0,2824,191,1,0,
  	0,0,2825,2843,5,187,0,0,2826,2844,3,194,97,0,2827,2844,3,196,98,0,2828,
  	2844,3,198,99,0,2829,2844,3,200,100,0,2830,2844,3,202,101,0,2831,2844,
  	3,204,102,0,2832,2844,3,208,104,0,2833,2844,3,210,105,0,2834,2844,3,212,
  	106,0,2835,2844,3,214,107,0,2836,2844,3,216,108,0,2837,2838,4,96,40,0,
  	2838,2844,3,218,109,0,2839,2840,4,96,41,0,2840,2844,3,220,110,0,2841,
  	2842,4,96,42,0,2842,2844,3,222,111,0,2843,2826,1,0,0,0,2843,2827,1,0,
  	0,0,2843,2828,1,0,0,0,2843,2829,1,0,0,0,2843,2830,1,0,0,0,2843,2831,1,
  	0,0,0,2843,2832,1,0,0,0,2843,2833,1,0,0,0,2843,2834,1,0,0,0,2843,2835,
  	1,0,0,0,2843,2836,1,0,0,0,2843,2837,1,0,0,0,2843,2839,1,0,0,0,2843,2841,
  	1,0,0,0,2844,193,1,0,0,0,2845,2847,5,151,0,0,2846,2848,3,1232,616,0,2847,
  	2846,1,0,0,0,2847,2848,1,0,0,0,2848,2849,1,0,0,0,2849,2850,3,1336,668,
  	0,2850,195,1,0,0,0,2851,2853,5,209,0,0,2852,2854,3,1232,616,0,2853,2852,
  	1,0,0,0,2853,2854,1,0,0,0,2854,2855,1,0,0,0,2855,2856,3,1364,682,0,2856,
  	197,1,0,0,0,2857,2859,5,242,0,0,2858,2860,3,1232,616,0,2859,2858,1,0,
  	0,0,2859,2860,1,0,0,0,2860,2861,1,0,0,0,2861,2862,3,1344,672,0,2862,199,
  	1,0,0,0,2863,2865,5,452,0,0,2864,2866,3,1232,616,0,2865,2864,1,0,0,0,
  	2865,2866,1,0,0,0,2866,2867,1,0,0,0,2867,2868,3,1340,670,0,2868,201,1,
  	0,0,0,2869,2871,3,1310,655,0,2870,2869,1,0,0,0,2870,2871,1,0,0,0,2871,
  	2872,1,0,0,0,2872,2873,5,272,0,0,2873,2874,3,1330,665,0,2874,2875,5,413,
  	0,0,2875,2877,3,1380,690,0,2876,2878,3,48,24,0,2877,2876,1,0,0,0,2877,
  	2878,1,0,0,0,2878,203,1,0,0,0,2879,2880,5,320,0,0,2880,2881,5,253,0,0,
  	2881,2892,3,1360,680,0,2882,2889,3,206,103,0,2883,2885,5,29,0,0,2884,
  	2883,1,0,0,0,2884,2885,1,0,0,0,2885,2886,1,0,0,0,2886,2888,3,206,103,
  	0,2887,2884,1,0,0,0,2888,2891,1,0,0,0,2889,2887,1,0,0,0,2889,2890,1,0,
  	0,0,2890,2893,1,0,0,0,2891,2889,1,0,0,0,2892,2882,1,0,0,0,2892,2893,1,
  	0,0,0,2893,205,1,0,0,0,2894,2897,3,162,81,0,2895,2897,3,160,80,0,2896,
  	2894,1,0,0,0,2896,2895,1,0,0,0,2897,207,1,0,0,0,2898,2900,5,530,0,0,2899,
  	2901,3,1232,616,0,2900,2899,1,0,0,0,2900,2901,1,0,0,0,2901,2902,1,0,0,
  	0,2902,2903,3,1370,685,0,2903,209,1,0,0,0,2904,2906,5,603,0,0,2905,2904,
  	1,0,0,0,2905,2906,1,0,0,0,2906,2907,1,0,0,0,2907,2909,7,17,0,0,2908,2910,
  	3,1232,616,0,2909,2908,1,0,0,0,2909,2910,1,0,0,0,2910,2911,1,0,0,0,2911,
  	2913,3,1382,691,0,2912,2914,7,2,0,0,2913,2912,1,0,0,0,2913,2914,1,0,0,
  	0,2914,211,1,0,0,0,2915,2916,5,598,0,0,2916,2927,3,1356,678,0,2917,2924,
  	3,206,103,0,2918,2920,5,29,0,0,2919,2918,1,0,0,0,2919,2920,1,0,0,0,2920,
  	2921,1,0,0,0,2921,2923,3,206,103,0,2922,2919,1,0,0,0,2923,2926,1,0,0,
  	0,2924,2922,1,0,0,0,2924,2925,1,0,0,0,2925,2928,1,0,0,0,2926,2924,1,0,
  	0,0,2927,2917,1,0,0,0,2927,2928,1,0,0,0,2928,213,1,0,0,0,2929,2931,5,
  	620,0,0,2930,2932,3,1232,616,0,2931,2930,1,0,0,0,2931,2932,1,0,0,0,2932,
  	2933,1,0,0,0,2933,2934,3,1348,674,0,2934,215,1,0,0,0,2935,2937,5,661,
  	0,0,2936,2938,3,1232,616,0,2937,2936,1,0,0,0,2937,2938,1,0,0,0,2938,2939,
  	1,0,0,0,2939,2941,3,1252,626,0,2940,2942,7,2,0,0,2941,2940,1,0,0,0,2941,
  	2942,1,0,0,0,2942,217,1,0,0,0,2943,2945,5,684,0,0,2944,2946,3,1232,616,
  	0,2945,2944,1,0,0,0,2945,2946,1,0,0,0,2946,2947,1,0,0,0,2947,2948,3,680,
  	340,0,2948,219,1,0,0,0,2949,2950,5,549,0,0,2950,2951,5,743,0,0,2951,2953,
  	5,735,0,0,2952,2954,3,1232,616,0,2953,2952,1,0,0,0,2953,2954,1,0,0,0,
  	2954,2955,1,0,0,0,2955,2956,3,1422,711,0,2956,221,1,0,0,0,2957,2958,5,
  	631,0,0,2958,2959,5,598,0,0,2959,2961,3,1356,678,0,2960,2962,3,60,30,
  	0,2961,2960,1,0,0,0,2961,2962,1,0,0,0,2962,223,1,0,0,0,2963,2964,5,483,
  	0,0,2964,2965,7,17,0,0,2965,2970,3,226,113,0,2966,2967,5,29,0,0,2967,
  	2969,3,226,113,0,2968,2966,1,0,0,0,2969,2972,1,0,0,0,2970,2968,1,0,0,
  	0,2970,2971,1,0,0,0,2971,225,1,0,0,0,2972,2970,1,0,0,0,2973,2974,3,1380,
  	690,0,2974,2975,5,616,0,0,2975,2976,3,1374,687,0,2976,227,1,0,0,0,2977,
  	2979,5,623,0,0,2978,2980,5,600,0,0,2979,2978,1,0,0,0,2979,2980,1,0,0,
  	0,2980,2981,1,0,0,0,2981,2982,3,1380,690,0,2982,229,1,0,0,0,2983,2984,
  	5,270,0,0,2984,2985,5,600,0,0,2985,2986,5,239,0,0,2986,2987,3,1446,723,
  	0,2987,231,1,0,0,0,2988,2989,5,93,0,0,2989,2995,3,1340,670,0,2990,2992,
  	5,32,0,0,2991,2993,3,1002,501,0,2992,2991,1,0,0,0,2992,2993,1,0,0,0,2993,
  	2994,1,0,0,0,2994,2996,5,33,0,0,2995,2990,1,0,0,0,2995,2996,1,0,0,0,2996,
  	233,1,0,0,0,2997,2998,4,117,43,0,2998,3000,3,352,176,0,2999,2997,1,0,
  	0,0,2999,3000,1,0,0,0,3000,3001,1,0,0,0,3001,3005,5,173,0,0,3002,3004,
  	3,238,119,0,3003,3002,1,0,0,0,3004,3007,1,0,0,0,3005,3003,1,0,0,0,3005,
  	3006,1,0,0,0,3006,3040,1,0,0,0,3007,3005,1,0,0,0,3008,3032,5,239,0,0,
  	3009,3010,3,1384,692,0,3010,3011,5,647,0,0,3011,3013,3,366,183,0,3012,
  	3014,3,390,195,0,3013,3012,1,0,0,0,3013,3014,1,0,0,0,3014,3033,1,0,0,
  	0,3015,3018,3,1380,690,0,3016,3017,4,117,44,0,3017,3019,3,432,216,0,3018,
  	3016,1,0,0,0,3018,3019,1,0,0,0,3019,3021,1,0,0,0,3020,3022,3,236,118,
  	0,3021,3020,1,0,0,0,3021,3022,1,0,0,0,3022,3024,1,0,0,0,3023,3025,3,390,
  	195,0,3024,3023,1,0,0,0,3024,3025,1,0,0,0,3025,3027,1,0,0,0,3026,3028,
  	3,360,180,0,3027,3026,1,0,0,0,3027,3028,1,0,0,0,3028,3030,1,0,0,0,3029,
  	3031,3,316,158,0,3030,3029,1,0,0,0,3030,3031,1,0,0,0,3031,3033,1,0,0,
  	0,3032,3009,1,0,0,0,3032,3015,1,0,0,0,3033,3041,1,0,0,0,3034,3035,3,1384,
  	692,0,3035,3036,5,239,0,0,3036,3038,3,366,183,0,3037,3039,3,390,195,0,
  	3038,3037,1,0,0,0,3038,3039,1,0,0,0,3039,3041,1,0,0,0,3040,3008,1,0,0,
  	0,3040,3034,1,0,0,0,3041,235,1,0,0,0,3042,3043,5,435,0,0,3043,3044,5,
  	32,0,0,3044,3045,3,1406,703,0,3045,3046,5,33,0,0,3046,237,1,0,0,0,3047,
  	3048,7,18,0,0,3048,239,1,0,0,0,3049,3054,5,186,0,0,3050,3051,4,120,45,
  	0,3051,3055,3,1002,501,0,3052,3053,4,120,46,0,3053,3055,3,384,192,0,3054,
  	3050,1,0,0,0,3054,3052,1,0,0,0,3055,241,1,0,0,0,3056,3074,5,255,0,0,3057,
  	3058,3,1380,690,0,3058,3060,5,417,0,0,3059,3061,3,432,216,0,3060,3059,
  	1,0,0,0,3060,3061,1,0,0,0,3061,3075,1,0,0,0,3062,3072,3,1404,702,0,3063,
  	3073,5,110,0,0,3064,3065,5,465,0,0,3065,3067,3,244,122,0,3066,3068,3,
  	390,195,0,3067,3066,1,0,0,0,3067,3068,1,0,0,0,3068,3070,1,0,0,0,3069,
  	3071,3,314,157,0,3070,3069,1,0,0,0,3070,3071,1,0,0,0,3071,3073,1,0,0,
  	0,3072,3063,1,0,0,0,3072,3064,1,0,0,0,3073,3075,1,0,0,0,3074,3057,1,0,
  	0,0,3074,3062,1,0,0,0,3075,243,1,0,0,0,3076,3087,7,19,0,0,3077,3084,3,
  	1404,702,0,3078,3085,7,20,0,0,3079,3080,7,21,0,0,3080,3081,5,32,0,0,3081,
  	3082,3,260,130,0,3082,3083,5,33,0,0,3083,3085,1,0,0,0,3084,3078,1,0,0,
  	0,3084,3079,1,0,0,0,3085,3087,1,0,0,0,3086,3076,1,0,0,0,3086,3077,1,0,
  	0,0,3087,245,1,0,0,0,3088,3090,5,278,0,0,3089,3091,3,248,124,0,3090,3089,
  	1,0,0,0,3090,3091,1,0,0,0,3091,3093,1,0,0,0,3092,3094,5,268,0,0,3093,
  	3092,1,0,0,0,3093,3094,1,0,0,0,3094,3096,1,0,0,0,3095,3097,5,283,0,0,
  	3096,3095,1,0,0,0,3096,3097,1,0,0,0,3097,3098,1,0,0,0,3098,3100,3,1380,
  	690,0,3099,3101,3,1314,657,0,3100,3099,1,0,0,0,3100,3101,1,0,0,0,3101,
  	3112,1,0,0,0,3102,3104,3,250,125,0,3103,3105,3,262,131,0,3104,3103,1,
  	0,0,0,3104,3105,1,0,0,0,3105,3113,1,0,0,0,3106,3107,5,533,0,0,3107,3109,
  	3,1254,627,0,3108,3110,3,262,131,0,3109,3108,1,0,0,0,3109,3110,1,0,0,
  	0,3110,3113,1,0,0,0,3111,3113,3,256,128,0,3112,3102,1,0,0,0,3112,3106,
  	1,0,0,0,3112,3111,1,0,0,0,3113,3115,1,0,0,0,3114,3116,3,264,132,0,3115,
  	3114,1,0,0,0,3115,3116,1,0,0,0,3116,247,1,0,0,0,3117,3118,7,22,0,0,3118,
  	249,1,0,0,0,3119,3121,5,32,0,0,3120,3122,3,252,126,0,3121,3120,1,0,0,
  	0,3121,3122,1,0,0,0,3122,3123,1,0,0,0,3123,3125,5,33,0,0,3124,3119,1,
  	0,0,0,3124,3125,1,0,0,0,3125,3126,1,0,0,0,3126,3127,3,254,127,0,3127,
  	251,1,0,0,0,3128,3133,3,1326,663,0,3129,3130,5,29,0,0,3130,3132,3,1326,
  	663,0,3131,3129,1,0,0,0,3132,3135,1,0,0,0,3133,3131,1,0,0,0,3133,3134,
  	1,0,0,0,3134,253,1,0,0,0,3135,3133,1,0,0,0,3136,3137,7,23,0,0,3137,3138,
  	3,258,129,0,3138,255,1,0,0,0,3139,3150,3,300,150,0,3140,3150,3,304,152,
  	0,3141,3143,5,32,0,0,3142,3144,3,252,126,0,3143,3142,1,0,0,0,3143,3144,
  	1,0,0,0,3144,3145,1,0,0,0,3145,3147,5,33,0,0,3146,3141,1,0,0,0,3146,3147,
  	1,0,0,0,3147,3148,1,0,0,0,3148,3150,3,98,49,0,3149,3139,1,0,0,0,3149,
  	3140,1,0,0,0,3149,3146,1,0,0,0,3150,257,1,0,0,0,3151,3153,5,32,0,0,3152,
  	3154,3,260,130,0,3153,3152,1,0,0,0,3153,3154,1,0,0,0,3154,3155,1,0,0,
  	0,3155,3164,5,33,0,0,3156,3157,5,29,0,0,3157,3159,5,32,0,0,3158,3160,
  	3,260,130,0,3159,3158,1,0,0,0,3159,3160,1,0,0,0,3160,3161,1,0,0,0,3161,
  	3163,5,33,0,0,3162,3156,1,0,0,0,3163,3166,1,0,0,0,3164,3162,1,0,0,0,3164,
  	3165,1,0,0,0,3165,259,1,0,0,0,3166,3164,1,0,0,0,3167,3170,3,906,453,0,
  	3168,3170,5,168,0,0,3169,3167,1,0,0,0,3169,3168,1,0,0,0,3170,3178,1,0,
  	0,0,3171,3174,5,29,0,0,3172,3175,3,906,453,0,3173,3175,5,168,0,0,3174,
  	3172,1,0,0,0,3174,3173,1,0,0,0,3175,3177,1,0,0,0,3176,3171,1,0,0,0,3177,
  	3180,1,0,0,0,3178,3176,1,0,0,0,3178,3179,1,0,0,0,3179,261,1,0,0,0,3180,
  	3178,1,0,0,0,3181,3182,4,131,47,0,3182,3183,5,63,0,0,3183,3185,3,1404,
  	702,0,3184,3186,3,1322,661,0,3185,3184,1,0,0,0,3185,3186,1,0,0,0,3186,
  	263,1,0,0,0,3187,3188,5,413,0,0,3188,3189,5,190,0,0,3189,3190,5,299,0,
  	0,3190,3191,5,640,0,0,3191,3192,3,1254,627,0,3192,265,1,0,0,0,3193,3194,
  	5,315,0,0,3194,3196,3,268,134,0,3195,3197,3,270,135,0,3196,3195,1,0,0,
  	0,3196,3197,1,0,0,0,3197,3199,1,0,0,0,3198,3200,3,272,136,0,3199,3198,
  	1,0,0,0,3199,3200,1,0,0,0,3200,3202,1,0,0,0,3201,3203,5,316,0,0,3202,
  	3201,1,0,0,0,3202,3203,1,0,0,0,3203,3205,1,0,0,0,3204,3206,3,274,137,
  	0,3205,3204,1,0,0,0,3205,3206,1,0,0,0,3206,3207,1,0,0,0,3207,3209,3,1436,
  	718,0,3208,3210,3,276,138,0,3209,3208,1,0,0,0,3209,3210,1,0,0,0,3210,
  	3212,1,0,0,0,3211,3213,3,278,139,0,3212,3211,1,0,0,0,3212,3213,1,0,0,
  	0,3213,3215,1,0,0,0,3214,3216,7,8,0,0,3215,3214,1,0,0,0,3215,3216,1,0,
  	0,0,3216,3217,1,0,0,0,3217,3218,5,283,0,0,3218,3219,5,600,0,0,3219,3221,
  	3,1380,690,0,3220,3222,3,1314,657,0,3221,3220,1,0,0,0,3221,3222,1,0,0,
  	0,3222,3224,1,0,0,0,3223,3225,3,1258,629,0,3224,3223,1,0,0,0,3224,3225,
  	1,0,0,0,3225,3227,1,0,0,0,3226,3228,3,280,140,0,3227,3226,1,0,0,0,3227,
  	3228,1,0,0,0,3228,3230,1,0,0,0,3229,3231,3,1260,630,0,3230,3229,1,0,0,
  	0,3230,3231,1,0,0,0,3231,3233,1,0,0,0,3232,3234,3,1264,632,0,3233,3232,
  	1,0,0,0,3233,3234,1,0,0,0,3234,3235,1,0,0,0,3235,3237,3,282,141,0,3236,
  	3238,3,290,145,0,3237,3236,1,0,0,0,3237,3238,1,0,0,0,3238,3240,1,0,0,
  	0,3239,3241,3,292,146,0,3240,3239,1,0,0,0,3240,3241,1,0,0,0,3241,3243,
  	1,0,0,0,3242,3244,3,288,144,0,3243,3242,1,0,0,0,3243,3244,1,0,0,0,3244,
  	267,1,0,0,0,3245,3246,7,24,0,0,3246,269,1,0,0,0,3247,3248,7,25,0,0,3248,
  	271,1,0,0,0,3249,3250,4,136,48,0,3250,3251,5,239,0,0,3251,273,1,0,0,0,
  	3252,3256,5,273,0,0,3253,3254,4,137,49,0,3254,3256,7,26,0,0,3255,3252,
  	1,0,0,0,3255,3253,1,0,0,0,3256,275,1,0,0,0,3257,3263,4,138,50,0,3258,
  	3259,5,138,0,0,3259,3264,5,3,0,0,3260,3261,3,1402,701,0,3261,3262,5,3,
  	0,0,3262,3264,1,0,0,0,3263,3258,1,0,0,0,3263,3260,1,0,0,0,3264,277,1,
  	0,0,0,3265,3266,4,139,51,0,3266,3267,5,286,0,0,3267,3268,5,450,0,0,3268,
  	3269,5,299,0,0,3269,3270,5,423,0,0,3270,279,1,0,0,0,3271,3272,5,513,0,
  	0,3272,3273,5,266,0,0,3273,3274,5,90,0,0,3274,3275,3,1438,719,0,3275,
  	281,1,0,0,0,3276,3277,5,268,0,0,3277,3278,5,3,0,0,3278,3280,7,27,0,0,
  	3279,3276,1,0,0,0,3279,3280,1,0,0,0,3280,3282,1,0,0,0,3281,3283,3,284,
  	142,0,3282,3281,1,0,0,0,3282,3283,1,0,0,0,3283,3286,1,0,0,0,3284,3285,
  	5,533,0,0,3285,3287,3,1254,627,0,3286,3284,1,0,0,0,3286,3287,1,0,0,0,
  	3287,283,1,0,0,0,3288,3290,5,32,0,0,3289,3291,3,286,143,0,3290,3289,1,
  	0,0,0,3290,3291,1,0,0,0,3291,3292,1,0,0,0,3292,3293,5,33,0,0,3293,285,
  	1,0,0,0,3294,3297,3,1324,662,0,3295,3297,3,982,491,0,3296,3294,1,0,0,
  	0,3296,3295,1,0,0,0,3297,3305,1,0,0,0,3298,3301,5,29,0,0,3299,3302,3,
  	1324,662,0,3300,3302,3,982,491,0,3301,3299,1,0,0,0,3301,3300,1,0,0,0,
  	3302,3304,1,0,0,0,3303,3298,1,0,0,0,3304,3307,1,0,0,0,3305,3303,1,0,0,
  	0,3305,3306,1,0,0,0,3306,287,1,0,0,0,3307,3305,1,0,0,0,3308,3309,4,144,
  	52,0,3309,3310,5,55,0,0,3310,3311,5,6,0,0,3311,3312,5,821,0,0,3312,289,
  	1,0,0,0,3313,3314,4,145,53,0,3314,3315,5,827,0,0,3315,3316,5,6,0,0,3316,
  	3317,5,3,0,0,3317,291,1,0,0,0,3318,3319,4,146,54,0,3319,3320,5,366,0,
  	0,3320,3321,5,6,0,0,3321,3322,3,1470,735,0,3322,293,1,0,0,0,3323,3325,
  	5,488,0,0,3324,3326,7,28,0,0,3325,3324,1,0,0,0,3325,3326,1,0,0,0,3326,
  	3328,1,0,0,0,3327,3329,5,283,0,0,3328,3327,1,0,0,0,3328,3329,1,0,0,0,
  	3329,3330,1,0,0,0,3330,3332,3,1380,690,0,3331,3333,3,1314,657,0,3332,
  	3331,1,0,0,0,3332,3333,1,0,0,0,3333,3338,1,0,0,0,3334,3339,3,250,125,
  	0,3335,3336,5,533,0,0,3336,3339,3,1254,627,0,3337,3339,3,256,128,0,3338,
  	3334,1,0,0,0,3338,3335,1,0,0,0,3338,3337,1,0,0,0,3339,295,1,0,0,0,3340,
  	3342,3,300,150,0,3341,3343,3,376,188,0,3342,3341,1,0,0,0,3342,3343,1,
  	0,0,0,3343,3346,1,0,0,0,3344,3346,3,298,149,0,3345,3340,1,0,0,0,3345,
  	3344,1,0,0,0,3346,297,1,0,0,0,3347,3348,5,32,0,0,3348,3349,3,298,149,
  	0,3349,3350,5,33,0,0,3350,3365,1,0,0,0,3351,3352,3,300,150,0,3352,3354,
  	3,322,161,0,3353,3355,3,376,188,0,3354,3353,1,0,0,0,3354,3355,1,0,0,0,
  	3355,3365,1,0,0,0,3356,3357,3,300,150,0,3357,3358,3,376,188,0,3358,3359,
  	3,322,161,0,3359,3365,1,0,0,0,3360,3361,4,149,55,0,3361,3362,3,304,152,
  	0,3362,3363,3,322,161,0,3363,3365,1,0,0,0,3364,3347,1,0,0,0,3364,3351,
  	1,0,0,0,3364,3356,1,0,0,0,3364,3360,1,0,0,0,3365,299,1,0,0,0,3366,3367,
  	4,150,56,0,3367,3369,3,352,176,0,3368,3366,1,0,0,0,3368,3369,1,0,0,0,
  	3369,3370,1,0,0,0,3370,3372,3,302,151,0,3371,3373,3,360,180,0,3372,3371,
  	1,0,0,0,3372,3373,1,0,0,0,3373,3375,1,0,0,0,3374,3376,3,314,157,0,3375,
  	3374,1,0,0,0,3375,3376,1,0,0,0,3376,3379,1,0,0,0,3377,3378,4,150,57,0,
  	3378,3380,3,324,162,0,3379,3377,1,0,0,0,3379,3380,1,0,0,0,3380,301,1,
  	0,0,0,3381,3384,3,306,153,0,3382,3384,3,304,152,0,3383,3381,1,0,0,0,3383,
  	3382,1,0,0,0,3384,3396,1,0,0,0,3385,3389,5,634,0,0,3386,3387,4,151,58,
  	0,3387,3389,7,29,0,0,3388,3385,1,0,0,0,3388,3386,1,0,0,0,3389,3391,1,
  	0,0,0,3390,3392,3,430,215,0,3391,3390,1,0,0,0,3391,3392,1,0,0,0,3392,
  	3393,1,0,0,0,3393,3395,3,302,151,0,3394,3388,1,0,0,0,3395,3398,1,0,0,
  	0,3396,3394,1,0,0,0,3396,3397,1,0,0,0,3397,303,1,0,0,0,3398,3396,1,0,
  	0,0,3399,3402,5,32,0,0,3400,3403,3,304,152,0,3401,3403,3,98,49,0,3402,
  	3400,1,0,0,0,3402,3401,1,0,0,0,3403,3404,1,0,0,0,3404,3405,5,33,0,0,3405,
  	305,1,0,0,0,3406,3412,3,308,154,0,3407,3408,4,153,59,0,3408,3412,3,368,
  	184,0,3409,3410,4,153,60,0,3410,3412,3,370,185,0,3411,3406,1,0,0,0,3411,
  	3407,1,0,0,0,3411,3409,1,0,0,0,3412,307,1,0,0,0,3413,3417,5,524,0,0,3414,
  	3416,3,374,187,0,3415,3414,1,0,0,0,3416,3419,1,0,0,0,3417,3415,1,0,0,
  	0,3417,3418,1,0,0,0,3418,3420,1,0,0,0,3419,3417,1,0,0,0,3420,3422,3,384,
  	192,0,3421,3423,3,322,161,0,3422,3421,1,0,0,0,3422,3423,1,0,0,0,3423,
  	3425,1,0,0,0,3424,3426,3,364,182,0,3425,3424,1,0,0,0,3425,3426,1,0,0,
  	0,3426,3428,1,0,0,0,3427,3429,3,390,195,0,3428,3427,1,0,0,0,3428,3429,
  	1,0,0,0,3429,3431,1,0,0,0,3430,3432,3,356,178,0,3431,3430,1,0,0,0,3431,
  	3432,1,0,0,0,3432,3434,1,0,0,0,3433,3435,3,326,163,0,3434,3433,1,0,0,
  	0,3434,3435,1,0,0,0,3435,3438,1,0,0,0,3436,3437,4,154,61,0,3437,3439,
  	3,330,165,0,3438,3436,1,0,0,0,3438,3439,1,0,0,0,3439,3441,1,0,0,0,3440,
  	3442,3,328,164,0,3441,3440,1,0,0,0,3441,3442,1,0,0,0,3442,309,1,0,0,0,
  	3443,3444,3,304,152,0,3444,311,1,0,0,0,3445,3446,7,30,0,0,3446,313,1,
  	0,0,0,3447,3448,5,310,0,0,3448,3449,3,318,159,0,3449,315,1,0,0,0,3450,
  	3451,5,310,0,0,3451,3452,3,320,160,0,3452,317,1,0,0,0,3453,3456,3,320,
  	160,0,3454,3455,7,31,0,0,3455,3457,3,320,160,0,3456,3454,1,0,0,0,3456,
  	3457,1,0,0,0,3457,319,1,0,0,0,3458,3461,3,1404,702,0,3459,3461,7,32,0,
  	0,3460,3458,1,0,0,0,3460,3459,1,0,0,0,3461,321,1,0,0,0,3462,3490,5,283,
  	0,0,3463,3464,5,426,0,0,3464,3466,3,1436,718,0,3465,3467,3,1258,629,0,
  	3466,3465,1,0,0,0,3466,3467,1,0,0,0,3467,3469,1,0,0,0,3468,3470,3,1260,
  	630,0,3469,3468,1,0,0,0,3469,3470,1,0,0,0,3470,3472,1,0,0,0,3471,3473,
  	3,1264,632,0,3472,3471,1,0,0,0,3472,3473,1,0,0,0,3473,3491,1,0,0,0,3474,
  	3475,5,189,0,0,3475,3491,3,1436,718,0,3476,3479,3,1464,732,0,3477,3479,
  	3,982,491,0,3478,3476,1,0,0,0,3478,3477,1,0,0,0,3479,3487,1,0,0,0,3480,
  	3483,5,29,0,0,3481,3484,3,1464,732,0,3482,3484,3,982,491,0,3483,3481,
  	1,0,0,0,3483,3482,1,0,0,0,3484,3486,1,0,0,0,3485,3480,1,0,0,0,3486,3489,
  	1,0,0,0,3487,3485,1,0,0,0,3487,3488,1,0,0,0,3488,3491,1,0,0,0,3489,3487,
  	1,0,0,0,3490,3463,1,0,0,0,3490,3474,1,0,0,0,3490,3478,1,0,0,0,3491,323,
  	1,0,0,0,3492,3493,5,452,0,0,3493,3494,5,59,0,0,3494,3500,5,32,0,0,3495,
  	3498,5,3,0,0,3496,3497,5,29,0,0,3497,3499,5,3,0,0,3498,3496,1,0,0,0,3498,
  	3499,1,0,0,0,3499,3501,1,0,0,0,3500,3495,1,0,0,0,3500,3501,1,0,0,0,3501,
  	3502,1,0,0,0,3502,3503,5,33,0,0,3503,325,1,0,0,0,3504,3505,5,257,0,0,
  	3505,3506,3,906,453,0,3506,327,1,0,0,0,3507,3508,4,164,62,0,3508,3509,
  	5,829,0,0,3509,3510,3,906,453,0,3510,329,1,0,0,0,3511,3512,5,724,0,0,
  	3512,3517,3,332,166,0,3513,3514,5,29,0,0,3514,3516,3,332,166,0,3515,3513,
  	1,0,0,0,3516,3519,1,0,0,0,3517,3515,1,0,0,0,3517,3518,1,0,0,0,3518,331,
  	1,0,0,0,3519,3517,1,0,0,0,3520,3521,3,1400,700,0,3521,3522,5,63,0,0,3522,
  	3523,3,334,167,0,3523,333,1,0,0,0,3524,3525,5,32,0,0,3525,3526,3,336,
  	168,0,3526,3527,5,33,0,0,3527,335,1,0,0,0,3528,3530,3,1400,700,0,3529,
  	3528,1,0,0,0,3529,3530,1,0,0,0,3530,3534,1,0,0,0,3531,3532,5,435,0,0,
  	3532,3533,5,90,0,0,3533,3535,3,1020,510,0,3534,3531,1,0,0,0,3534,3535,
  	1,0,0,0,3535,3537,1,0,0,0,3536,3538,3,360,180,0,3537,3536,1,0,0,0,3537,
  	3538,1,0,0,0,3538,3540,1,0,0,0,3539,3541,3,338,169,0,3540,3539,1,0,0,
  	0,3540,3541,1,0,0,0,3541,337,1,0,0,0,3542,3543,3,340,170,0,3543,3545,
  	3,342,171,0,3544,3546,3,350,175,0,3545,3544,1,0,0,0,3545,3546,1,0,0,0,
  	3546,339,1,0,0,0,3547,3548,7,33,0,0,3548,341,1,0,0,0,3549,3552,3,344,
  	172,0,3550,3552,3,346,173,0,3551,3549,1,0,0,0,3551,3550,1,0,0,0,3552,
  	343,1,0,0,0,3553,3554,5,723,0,0,3554,3568,5,718,0,0,3555,3556,3,1420,
  	710,0,3556,3557,5,718,0,0,3557,3568,1,0,0,0,3558,3559,5,42,0,0,3559,3568,
  	5,718,0,0,3560,3561,5,282,0,0,3561,3562,3,906,453,0,3562,3563,3,1010,
  	505,0,3563,3564,5,718,0,0,3564,3568,1,0,0,0,3565,3566,5,144,0,0,3566,
  	3568,5,516,0,0,3567,3553,1,0,0,0,3567,3555,1,0,0,0,3567,3558,1,0,0,0,
  	3567,3560,1,0,0,0,3567,3565,1,0,0,0,3568,345,1,0,0,0,3569,3570,5,75,0,
  	0,3570,3571,3,348,174,0,3571,3572,5,61,0,0,3572,3573,3,348,174,0,3573,
  	347,1,0,0,0,3574,3588,3,344,172,0,3575,3576,5,723,0,0,3576,3588,5,707,
  	0,0,3577,3578,3,1420,710,0,3578,3579,5,707,0,0,3579,3588,1,0,0,0,3580,
  	3581,5,42,0,0,3581,3588,5,707,0,0,3582,3583,5,282,0,0,3583,3584,3,906,
  	453,0,3584,3585,3,1010,505,0,3585,3586,5,707,0,0,3586,3588,1,0,0,0,3587,
  	3574,1,0,0,0,3587,3575,1,0,0,0,3587,3577,1,0,0,0,3587,3580,1,0,0,0,3587,
  	3582,1,0,0,0,3588,349,1,0,0,0,3589,3596,5,705,0,0,3590,3591,5,144,0,0,
  	3591,3597,5,516,0,0,3592,3597,5,253,0,0,3593,3597,5,722,0,0,3594,3595,
  	5,403,0,0,3595,3597,5,715,0,0,3596,3590,1,0,0,0,3596,3592,1,0,0,0,3596,
  	3593,1,0,0,0,3596,3594,1,0,0,0,3597,351,1,0,0,0,3598,3600,5,670,0,0,3599,
  	3601,5,690,0,0,3600,3599,1,0,0,0,3600,3601,1,0,0,0,3601,3602,1,0,0,0,
  	3602,3607,3,354,177,0,3603,3604,5,29,0,0,3604,3606,3,354,177,0,3605,3603,
  	1,0,0,0,3606,3609,1,0,0,0,3607,3605,1,0,0,0,3607,3608,1,0,0,0,3608,353,
  	1,0,0,0,3609,3607,1,0,0,0,3610,3612,3,1404,702,0,3611,3613,3,1322,661,
  	0,3612,3611,1,0,0,0,3612,3613,1,0,0,0,3613,3614,1,0,0,0,3614,3615,5,63,
  	0,0,3615,3616,3,310,155,0,3616,355,1,0,0,0,3617,3618,5,253,0,0,3618,3619,
  	5,90,0,0,3619,3621,3,1020,510,0,3620,3622,3,358,179,0,3621,3620,1,0,0,
  	0,3621,3622,1,0,0,0,3622,3632,1,0,0,0,3623,3624,4,178,63,0,3624,3625,
  	5,253,0,0,3625,3626,5,90,0,0,3626,3627,7,34,0,0,3627,3628,5,32,0,0,3628,
  	3629,3,1024,512,0,3629,3630,5,33,0,0,3630,3632,1,0,0,0,3631,3617,1,0,
  	0,0,3631,3623,1,0,0,0,3632,357,1,0,0,0,3633,3634,5,670,0,0,3634,3639,
  	5,510,0,0,3635,3636,4,179,64,0,3636,3637,5,670,0,0,3637,3639,5,142,0,
  	0,3638,3633,1,0,0,0,3638,3635,1,0,0,0,3639,359,1,0,0,0,3640,3641,5,423,
  	0,0,3641,3642,5,90,0,0,3642,3643,3,1020,510,0,3643,361,1,0,0,0,3644,3645,
  	7,35,0,0,3645,363,1,0,0,0,3646,3649,5,239,0,0,3647,3650,5,188,0,0,3648,
  	3650,3,366,183,0,3649,3647,1,0,0,0,3649,3648,1,0,0,0,3650,365,1,0,0,0,
  	3651,3656,3,392,196,0,3652,3653,5,29,0,0,3653,3655,3,392,196,0,3654,3652,
  	1,0,0,0,3655,3658,1,0,0,0,3656,3654,1,0,0,0,3656,3657,1,0,0,0,3657,367,
  	1,0,0,0,3658,3656,1,0,0,0,3659,3660,5,652,0,0,3660,3665,3,372,186,0,3661,
  	3662,5,29,0,0,3662,3664,3,372,186,0,3663,3661,1,0,0,0,3664,3667,1,0,0,
  	0,3665,3663,1,0,0,0,3665,3666,1,0,0,0,3666,369,1,0,0,0,3667,3665,1,0,
  	0,0,3668,3669,5,600,0,0,3669,3670,3,1380,690,0,3670,371,1,0,0,0,3671,
  	3672,5,516,0,0,3672,3674,5,32,0,0,3673,3675,3,260,130,0,3674,3673,1,0,
  	0,0,3674,3675,1,0,0,0,3675,3676,1,0,0,0,3676,3677,5,33,0,0,3677,373,1,
  	0,0,0,3678,3687,3,312,156,0,3679,3687,5,561,0,0,3680,3681,4,187,65,0,
  	3681,3687,5,559,0,0,3682,3683,4,187,66,0,3683,3684,5,357,0,0,3684,3685,
  	5,6,0,0,3685,3687,3,1418,709,0,3686,3678,1,0,0,0,3686,3679,1,0,0,0,3686,
  	3680,1,0,0,0,3686,3682,1,0,0,0,3687,375,1,0,0,0,3688,3690,4,188,67,0,
  	3689,3691,3,378,189,0,3690,3689,1,0,0,0,3691,3692,1,0,0,0,3692,3690,1,
  	0,0,0,3692,3693,1,0,0,0,3693,377,1,0,0,0,3694,3695,5,236,0,0,3695,3699,
  	3,380,190,0,3696,3697,4,189,68,0,3697,3698,5,693,0,0,3698,3700,3,1384,
  	692,0,3699,3696,1,0,0,0,3699,3700,1,0,0,0,3700,3703,1,0,0,0,3701,3702,
  	4,189,69,0,3702,3704,3,382,191,0,3703,3701,1,0,0,0,3703,3704,1,0,0,0,
  	3704,3710,1,0,0,0,3705,3706,5,319,0,0,3706,3707,5,286,0,0,3707,3708,5,
  	535,0,0,3708,3710,5,377,0,0,3709,3694,1,0,0,0,3709,3705,1,0,0,0,3710,
  	379,1,0,0,0,3711,3715,5,640,0,0,3712,3713,4,190,70,0,3713,3715,5,535,
  	0,0,3714,3711,1,0,0,0,3714,3712,1,0,0,0,3715,381,1,0,0,0,3716,3717,5,
  	694,0,0,3717,3720,5,695,0,0,3718,3720,5,696,0,0,3719,3716,1,0,0,0,3719,
  	3718,1,0,0,0,3720,383,1,0,0,0,3721,3724,3,386,193,0,3722,3724,5,16,0,
  	0,3723,3721,1,0,0,0,3723,3722,1,0,0,0,3724,3729,1,0,0,0,3725,3726,5,29,
  	0,0,3726,3728,3,386,193,0,3727,3725,1,0,0,0,3728,3731,1,0,0,0,3729,3727,
  	1,0,0,0,3729,3730,1,0,0,0,3730,385,1,0,0,0,3731,3729,1,0,0,0,3732,3738,
  	3,1332,666,0,3733,3735,3,906,453,0,3734,3736,3,388,194,0,3735,3734,1,
  	0,0,0,3735,3736,1,0,0,0,3736,3738,1,0,0,0,3737,3732,1,0,0,0,3737,3733,
  	1,0,0,0,3738,387,1,0,0,0,3739,3741,5,63,0,0,3740,3739,1,0,0,0,3740,3741,
  	1,0,0,0,3741,3744,1,0,0,0,3742,3745,3,1404,702,0,3743,3745,3,1436,718,
  	0,3744,3742,1,0,0,0,3744,3743,1,0,0,0,3745,389,1,0,0,0,3746,3747,5,668,
  	0,0,3747,3748,3,906,453,0,3748,391,1,0,0,0,3749,3760,3,404,202,0,3750,
  	3754,5,34,0,0,3751,3752,4,196,71,0,3752,3755,3,1404,702,0,3753,3755,5,
  	757,0,0,3754,3751,1,0,0,0,3754,3753,1,0,0,0,3755,3756,1,0,0,0,3756,3757,
  	3,394,197,0,3757,3758,5,35,0,0,3758,3760,1,0,0,0,3759,3749,1,0,0,0,3759,
  	3750,1,0,0,0,3760,3764,1,0,0,0,3761,3763,3,396,198,0,3762,3761,1,0,0,
  	0,3763,3766,1,0,0,0,3764,3762,1,0,0,0,3764,3765,1,0,0,0,3765,393,1,0,
  	0,0,3766,3764,1,0,0,0,3767,3771,3,404,202,0,3768,3770,3,396,198,0,3769,
  	3768,1,0,0,0,3770,3773,1,0,0,0,3771,3769,1,0,0,0,3771,3772,1,0,0,0,3772,
  	395,1,0,0,0,3773,3771,1,0,0,0,3774,3775,3,400,200,0,3775,3780,3,392,196,
  	0,3776,3777,5,413,0,0,3777,3781,3,906,453,0,3778,3779,5,647,0,0,3779,
  	3781,3,1408,704,0,3780,3776,1,0,0,0,3780,3778,1,0,0,0,3780,3781,1,0,0,
  	0,3781,3794,1,0,0,0,3782,3783,3,402,201,0,3783,3788,3,392,196,0,3784,
  	3785,5,413,0,0,3785,3789,3,906,453,0,3786,3787,5,647,0,0,3787,3789,3,
  	1408,704,0,3788,3784,1,0,0,0,3788,3786,1,0,0,0,3789,3794,1,0,0,0,3790,
  	3791,3,398,199,0,3791,3792,3,404,202,0,3792,3794,1,0,0,0,3793,3774,1,
  	0,0,0,3793,3782,1,0,0,0,3793,3790,1,0,0,0,3794,397,1,0,0,0,3795,3797,
  	5,390,0,0,3796,3798,5,275,0,0,3797,3796,1,0,0,0,3797,3798,1,0,0,0,3798,
  	3799,1,0,0,0,3799,3807,5,295,0,0,3800,3801,5,390,0,0,3801,3803,7,36,0,
  	0,3802,3804,5,425,0,0,3803,3802,1,0,0,0,3803,3804,1,0,0,0,3804,3805,1,
  	0,0,0,3805,3807,5,295,0,0,3806,3795,1,0,0,0,3806,3800,1,0,0,0,3807,399,
  	1,0,0,0,3808,3810,7,37,0,0,3809,3808,1,0,0,0,3809,3810,1,0,0,0,3810,3811,
  	1,0,0,0,3811,3814,5,295,0,0,3812,3814,5,581,0,0,3813,3809,1,0,0,0,3813,
  	3812,1,0,0,0,3814,401,1,0,0,0,3815,3817,7,36,0,0,3816,3818,5,425,0,0,
  	3817,3816,1,0,0,0,3817,3818,1,0,0,0,3818,3819,1,0,0,0,3819,3820,5,295,
  	0,0,3820,403,1,0,0,0,3821,3828,3,406,203,0,3822,3828,3,408,204,0,3823,
  	3828,3,410,205,0,3824,3828,3,412,206,0,3825,3826,4,202,72,0,3826,3828,
  	3,414,207,0,3827,3821,1,0,0,0,3827,3822,1,0,0,0,3827,3823,1,0,0,0,3827,
  	3824,1,0,0,0,3827,3825,1,0,0,0,3828,405,1,0,0,0,3829,3831,3,1380,690,
  	0,3830,3832,3,1314,657,0,3831,3830,1,0,0,0,3831,3832,1,0,0,0,3832,3834,
  	1,0,0,0,3833,3835,3,432,216,0,3834,3833,1,0,0,0,3834,3835,1,0,0,0,3835,
  	3837,1,0,0,0,3836,3838,3,434,217,0,3837,3836,1,0,0,0,3837,3838,1,0,0,
  	0,3838,3840,1,0,0,0,3839,3841,3,934,467,0,3840,3839,1,0,0,0,3840,3841,
  	1,0,0,0,3841,407,1,0,0,0,3842,3845,5,32,0,0,3843,3846,3,406,203,0,3844,
  	3846,3,408,204,0,3845,3843,1,0,0,0,3845,3844,1,0,0,0,3846,3847,1,0,0,
  	0,3847,3848,5,33,0,0,3848,409,1,0,0,0,3849,3851,3,310,155,0,3850,3852,
  	3,432,216,0,3851,3850,1,0,0,0,3851,3852,1,0,0,0,3852,3855,1,0,0,0,3853,
  	3854,4,205,73,0,3854,3856,3,1322,661,0,3855,3853,1,0,0,0,3855,3856,1,
  	0,0,0,3856,3867,1,0,0,0,3857,3858,4,205,74,0,3858,3859,5,751,0,0,3859,
  	3861,3,310,155,0,3860,3862,3,432,216,0,3861,3860,1,0,0,0,3861,3862,1,
  	0,0,0,3862,3864,1,0,0,0,3863,3865,3,1322,661,0,3864,3863,1,0,0,0,3864,
  	3865,1,0,0,0,3865,3867,1,0,0,0,3866,3849,1,0,0,0,3866,3857,1,0,0,0,3867,
  	411,1,0,0,0,3868,3871,5,32,0,0,3869,3872,3,366,183,0,3870,3872,3,412,
  	206,0,3871,3869,1,0,0,0,3871,3870,1,0,0,0,3872,3873,1,0,0,0,3873,3874,
  	5,33,0,0,3874,413,1,0,0,0,3875,3876,5,726,0,0,3876,3877,5,32,0,0,3877,
  	3878,3,906,453,0,3878,3879,5,29,0,0,3879,3880,3,1436,718,0,3880,3881,
  	3,416,208,0,3881,3883,5,33,0,0,3882,3884,3,432,216,0,3883,3882,1,0,0,
  	0,3883,3884,1,0,0,0,3884,415,1,0,0,0,3885,3886,5,115,0,0,3886,3887,5,
  	32,0,0,3887,3892,3,418,209,0,3888,3889,5,29,0,0,3889,3891,3,418,209,0,
  	3890,3888,1,0,0,0,3891,3894,1,0,0,0,3892,3890,1,0,0,0,3892,3893,1,0,0,
  	0,3893,3895,1,0,0,0,3894,3892,1,0,0,0,3895,3896,5,33,0,0,3896,417,1,0,
  	0,0,3897,3898,3,1404,702,0,3898,3899,5,236,0,0,3899,3900,5,728,0,0,3900,
  	3921,1,0,0,0,3901,3902,3,1404,702,0,3902,3905,3,1164,582,0,3903,3904,
  	4,209,75,0,3904,3906,3,1246,623,0,3905,3903,1,0,0,0,3905,3906,1,0,0,0,
  	3906,3908,1,0,0,0,3907,3909,5,213,0,0,3908,3907,1,0,0,0,3908,3909,1,0,
  	0,0,3909,3910,1,0,0,0,3910,3911,5,729,0,0,3911,3913,3,1436,718,0,3912,
  	3914,3,422,211,0,3913,3912,1,0,0,0,3913,3914,1,0,0,0,3914,3921,1,0,0,
  	0,3915,3916,5,727,0,0,3916,3917,5,729,0,0,3917,3918,3,1436,718,0,3918,
  	3919,3,416,208,0,3919,3921,1,0,0,0,3920,3897,1,0,0,0,3920,3901,1,0,0,
  	0,3920,3915,1,0,0,0,3921,419,1,0,0,0,3922,3924,3,424,212,0,3923,3925,
  	3,426,213,0,3924,3923,1,0,0,0,3924,3925,1,0,0,0,3925,3928,1,0,0,0,3926,
  	3928,3,426,213,0,3927,3922,1,0,0,0,3927,3926,1,0,0,0,3928,421,1,0,0,0,
  	3929,3934,3,420,210,0,3930,3931,3,426,213,0,3931,3932,3,424,212,0,3932,
  	3934,1,0,0,0,3933,3929,1,0,0,0,3933,3930,1,0,0,0,3934,423,1,0,0,0,3935,
  	3936,3,428,214,0,3936,3937,5,413,0,0,3937,3938,5,725,0,0,3938,425,1,0,
  	0,0,3939,3940,3,428,214,0,3940,3941,5,413,0,0,3941,3942,5,204,0,0,3942,
  	427,1,0,0,0,3943,3948,5,204,0,0,3944,3948,5,406,0,0,3945,3946,5,168,0,
  	0,3946,3948,3,1436,718,0,3947,3943,1,0,0,0,3947,3944,1,0,0,0,3947,3945,
  	1,0,0,0,3948,429,1,0,0,0,3949,3950,7,38,0,0,3950,431,1,0,0,0,3951,3955,
  	5,63,0,0,3952,3953,4,216,76,0,3953,3955,5,6,0,0,3954,3951,1,0,0,0,3954,
  	3952,1,0,0,0,3954,3955,1,0,0,0,3955,3956,1,0,0,0,3956,3957,3,1404,702,
  	0,3957,433,1,0,0,0,3958,3963,3,436,218,0,3959,3960,5,29,0,0,3960,3962,
  	3,436,218,0,3961,3959,1,0,0,0,3962,3965,1,0,0,0,3963,3961,1,0,0,0,3963,
  	3964,1,0,0,0,3964,435,1,0,0,0,3965,3963,1,0,0,0,3966,3967,3,438,219,0,
  	3967,3969,3,440,220,0,3968,3970,3,444,222,0,3969,3968,1,0,0,0,3969,3970,
  	1,0,0,0,3970,3971,1,0,0,0,3971,3972,5,32,0,0,3972,3973,3,446,223,0,3973,
  	3974,5,33,0,0,3974,3987,1,0,0,0,3975,3976,5,646,0,0,3976,3978,3,440,220,
  	0,3977,3979,3,444,222,0,3978,3977,1,0,0,0,3978,3979,1,0,0,0,3979,3980,
  	1,0,0,0,3980,3982,5,32,0,0,3981,3983,3,446,223,0,3982,3981,1,0,0,0,3982,
  	3983,1,0,0,0,3983,3984,1,0,0,0,3984,3985,5,33,0,0,3985,3987,1,0,0,0,3986,
  	3966,1,0,0,0,3986,3975,1,0,0,0,3987,437,1,0,0,0,3988,3989,7,39,0,0,3989,
  	439,1,0,0,0,3990,3991,7,40,0,0,3991,441,1,0,0,0,3992,3993,5,450,0,0,3993,
  	3999,5,299,0,0,3994,3996,5,635,0,0,3995,3997,3,440,220,0,3996,3995,1,
  	0,0,0,3996,3997,1,0,0,0,3997,3999,1,0,0,0,3998,3992,1,0,0,0,3998,3994,
  	1,0,0,0,3999,443,1,0,0,0,4000,4006,5,236,0,0,4001,4007,5,295,0,0,4002,
  	4003,5,423,0,0,4003,4007,5,90,0,0,4004,4005,5,253,0,0,4005,4007,5,90,
  	0,0,4006,4001,1,0,0,0,4006,4002,1,0,0,0,4006,4004,1,0,0,0,4007,445,1,
  	0,0,0,4008,4013,3,448,224,0,4009,4010,5,29,0,0,4010,4012,3,448,224,0,
  	4011,4009,1,0,0,0,4012,4015,1,0,0,0,4013,4011,1,0,0,0,4013,4014,1,0,0,
  	0,4014,447,1,0,0,0,4015,4013,1,0,0,0,4016,4019,3,1404,702,0,4017,4019,
  	5,450,0,0,4018,4016,1,0,0,0,4018,4017,1,0,0,0,4019,449,1,0,0,0,4020,4021,
  	4,225,77,0,4021,4023,3,352,176,0,4022,4020,1,0,0,0,4022,4023,1,0,0,0,
  	4023,4024,1,0,0,0,4024,4026,5,640,0,0,4025,4027,5,327,0,0,4026,4025,1,
  	0,0,0,4026,4027,1,0,0,0,4027,4029,1,0,0,0,4028,4030,5,268,0,0,4029,4028,
  	1,0,0,0,4029,4030,1,0,0,0,4030,4031,1,0,0,0,4031,4032,3,366,183,0,4032,
  	4033,5,533,0,0,4033,4035,3,1254,627,0,4034,4036,3,390,195,0,4035,4034,
  	1,0,0,0,4035,4036,1,0,0,0,4036,4038,1,0,0,0,4037,4039,3,360,180,0,4038,
  	4037,1,0,0,0,4038,4039,1,0,0,0,4039,4041,1,0,0,0,4040,4042,3,316,158,
  	0,4041,4040,1,0,0,0,4041,4042,1,0,0,0,4042,451,1,0,0,0,4043,4048,3,454,
  	227,0,4044,4048,3,460,230,0,4045,4048,3,462,231,0,4046,4048,3,468,234,
  	0,4047,4043,1,0,0,0,4047,4044,1,0,0,0,4047,4045,1,0,0,0,4047,4046,1,0,
  	0,0,4048,453,1,0,0,0,4049,4050,5,569,0,0,4050,4054,5,618,0,0,4051,4053,
  	3,458,229,0,4052,4051,1,0,0,0,4053,4056,1,0,0,0,4054,4052,1,0,0,0,4054,
  	4055,1,0,0,0,4055,4075,1,0,0,0,4056,4054,1,0,0,0,4057,4059,5,121,0,0,
  	4058,4060,5,672,0,0,4059,4058,1,0,0,0,4059,4060,1,0,0,0,4060,4066,1,0,
  	0,0,4061,4063,5,61,0,0,4062,4064,5,403,0,0,4063,4062,1,0,0,0,4063,4064,
  	1,0,0,0,4064,4065,1,0,0,0,4065,4067,5,99,0,0,4066,4061,1,0,0,0,4066,4067,
  	1,0,0,0,4067,4072,1,0,0,0,4068,4070,5,403,0,0,4069,4068,1,0,0,0,4069,
  	4070,1,0,0,0,4070,4071,1,0,0,0,4071,4073,5,480,0,0,4072,4069,1,0,0,0,
  	4072,4073,1,0,0,0,4073,4075,1,0,0,0,4074,4049,1,0,0,0,4074,4057,1,0,0,
  	0,4075,455,1,0,0,0,4076,4078,5,74,0,0,4077,4079,5,672,0,0,4078,4077,1,
  	0,0,0,4078,4079,1,0,0,0,4079,457,1,0,0,0,4080,4081,5,670,0,0,4081,4082,
  	5,129,0,0,4082,4086,5,544,0,0,4083,4084,5,465,0,0,4084,4086,7,41,0,0,
  	4085,4080,1,0,0,0,4085,4083,1,0,0,0,4086,459,1,0,0,0,4087,4088,5,518,
  	0,0,4088,4117,3,1404,702,0,4089,4091,5,509,0,0,4090,4092,5,672,0,0,4091,
  	4090,1,0,0,0,4091,4092,1,0,0,0,4092,4111,1,0,0,0,4093,4095,5,616,0,0,
  	4094,4096,5,518,0,0,4095,4094,1,0,0,0,4095,4096,1,0,0,0,4096,4097,1,0,
  	0,0,4097,4112,3,1404,702,0,4098,4100,5,61,0,0,4099,4101,5,403,0,0,4100,
  	4099,1,0,0,0,4100,4101,1,0,0,0,4101,4102,1,0,0,0,4102,4104,5,99,0,0,4103,
  	4098,1,0,0,0,4103,4104,1,0,0,0,4104,4109,1,0,0,0,4105,4107,5,403,0,0,
  	4106,4105,1,0,0,0,4106,4107,1,0,0,0,4107,4108,1,0,0,0,4108,4110,5,480,
  	0,0,4109,4106,1,0,0,0,4109,4110,1,0,0,0,4110,4112,1,0,0,0,4111,4093,1,
  	0,0,0,4111,4103,1,0,0,0,4112,4117,1,0,0,0,4113,4114,5,480,0,0,4114,4115,
  	5,518,0,0,4115,4117,3,1404,702,0,4116,4087,1,0,0,0,4116,4089,1,0,0,0,
  	4116,4113,1,0,0,0,4117,461,1,0,0,0,4118,4119,5,319,0,0,4119,4120,7,17,
  	0,0,4120,4125,3,464,232,0,4121,4122,5,29,0,0,4122,4124,3,464,232,0,4123,
  	4121,1,0,0,0,4124,4127,1,0,0,0,4125,4123,1,0,0,0,4125,4126,1,0,0,0,4126,
  	4141,1,0,0,0,4127,4125,1,0,0,0,4128,4129,4,231,78,0,4129,4130,5,319,0,
  	0,4130,4131,5,280,0,0,4131,4132,5,236,0,0,4132,4141,5,72,0,0,4133,4138,
  	5,637,0,0,4134,4139,5,597,0,0,4135,4139,5,600,0,0,4136,4137,4,231,79,
  	0,4137,4139,5,280,0,0,4138,4134,1,0,0,0,4138,4135,1,0,0,0,4138,4136,1,
  	0,0,0,4139,4141,1,0,0,0,4140,4118,1,0,0,0,4140,4128,1,0,0,0,4140,4133,
  	1,0,0,0,4141,463,1,0,0,0,4142,4144,3,1380,690,0,4143,4145,3,432,216,0,
  	4144,4143,1,0,0,0,4144,4145,1,0,0,0,4145,4146,1,0,0,0,4146,4147,3,466,
  	233,0,4147,465,1,0,0,0,4148,4150,5,465,0,0,4149,4151,5,316,0,0,4150,4149,
  	1,0,0,0,4150,4151,1,0,0,0,4151,4157,1,0,0,0,4152,4154,5,327,0,0,4153,
  	4152,1,0,0,0,4153,4154,1,0,0,0,4154,4155,1,0,0,0,4155,4157,5,674,0,0,
  	4156,4148,1,0,0,0,4156,4153,1,0,0,0,4157,467,1,0,0,0,4158,4185,5,676,
  	0,0,4159,4160,7,42,0,0,4160,4162,3,472,236,0,4161,4163,7,43,0,0,4162,
  	4161,1,0,0,0,4162,4163,1,0,0,0,4163,4186,1,0,0,0,4164,4165,5,198,0,0,
  	4165,4171,3,472,236,0,4166,4169,5,592,0,0,4167,4168,5,236,0,0,4168,4170,
  	5,371,0,0,4169,4167,1,0,0,0,4169,4170,1,0,0,0,4170,4172,1,0,0,0,4171,
  	4166,1,0,0,0,4171,4172,1,0,0,0,4172,4186,1,0,0,0,4173,4174,5,447,0,0,
  	4174,4186,3,472,236,0,4175,4176,5,121,0,0,4176,4179,3,472,236,0,4177,
  	4178,5,414,0,0,4178,4180,5,437,0,0,4179,4177,1,0,0,0,4179,4180,1,0,0,
  	0,4180,4186,1,0,0,0,4181,4182,5,509,0,0,4182,4186,3,472,236,0,4183,4184,
  	5,469,0,0,4184,4186,3,470,235,0,4185,4159,1,0,0,0,4185,4164,1,0,0,0,4185,
  	4173,1,0,0,0,4185,4175,1,0,0,0,4185,4181,1,0,0,0,4185,4183,1,0,0,0,4186,
  	469,1,0,0,0,4187,4190,4,235,80,0,4188,4189,5,137,0,0,4189,4191,5,677,
  	0,0,4190,4188,1,0,0,0,4190,4191,1,0,0,0,4191,4194,1,0,0,0,4192,4194,1,
  	0,0,0,4193,4187,1,0,0,0,4193,4192,1,0,0,0,4194,471,1,0,0,0,4195,4202,
  	3,1438,719,0,4196,4197,5,29,0,0,4197,4200,3,1438,719,0,4198,4199,5,29,
  	0,0,4199,4201,3,1416,708,0,4200,4198,1,0,0,0,4200,4201,1,0,0,0,4201,4203,
  	1,0,0,0,4202,4196,1,0,0,0,4202,4203,1,0,0,0,4203,473,1,0,0,0,4204,4205,
  	5,458,0,0,4205,4229,3,476,238,0,4206,4229,3,488,244,0,4207,4208,5,498,
  	0,0,4208,4213,3,478,239,0,4209,4210,5,29,0,0,4210,4212,3,478,239,0,4211,
  	4209,1,0,0,0,4212,4215,1,0,0,0,4213,4211,1,0,0,0,4213,4214,1,0,0,0,4214,
  	4229,1,0,0,0,4215,4213,1,0,0,0,4216,4217,4,237,81,0,4217,4218,5,498,0,
  	0,4218,4220,5,683,0,0,4219,4221,3,1234,617,0,4220,4219,1,0,0,0,4220,4221,
  	1,0,0,0,4221,4229,1,0,0,0,4222,4229,3,574,287,0,4223,4229,3,576,288,0,
  	4224,4229,3,560,280,0,4225,4229,3,484,242,0,4226,4227,4,237,82,0,4227,
  	4229,3,592,296,0,4228,4204,1,0,0,0,4228,4206,1,0,0,0,4228,4207,1,0,0,
  	0,4228,4216,1,0,0,0,4228,4222,1,0,0,0,4228,4223,1,0,0,0,4228,4224,1,0,
  	0,0,4228,4225,1,0,0,0,4228,4226,1,0,0,0,4229,475,1,0,0,0,4230,4231,7,
  	44,0,0,4231,4236,5,321,0,0,4232,4233,5,616,0,0,4233,4237,3,1442,721,0,
  	4234,4235,5,73,0,0,4235,4237,3,906,453,0,4236,4232,1,0,0,0,4236,4234,
  	1,0,0,0,4237,477,1,0,0,0,4238,4240,3,480,240,0,4239,4241,3,482,241,0,
  	4240,4239,1,0,0,0,4240,4241,1,0,0,0,4241,4253,1,0,0,0,4242,4243,4,239,
  	83,0,4243,4244,5,460,0,0,4244,4253,5,92,0,0,4245,4247,3,604,302,0,4246,
  	4248,5,56,0,0,4247,4246,1,0,0,0,4247,4248,1,0,0,0,4248,4250,1,0,0,0,4249,
  	4251,3,1028,514,0,4250,4249,1,0,0,0,4250,4251,1,0,0,0,4251,4253,1,0,0,
  	0,4252,4238,1,0,0,0,4252,4242,1,0,0,0,4252,4245,1,0,0,0,4253,479,1,0,
  	0,0,4254,4261,5,348,0,0,4255,4256,4,240,84,0,4256,4257,5,77,0,0,4257,
  	4258,5,321,0,0,4258,4259,5,61,0,0,4259,4261,5,826,0,0,4260,4254,1,0,0,
  	0,4260,4255,1,0,0,0,4261,481,1,0,0,0,4262,4263,4,241,85,0,4263,4264,5,
  	616,0,0,4264,4265,3,1422,711,0,4265,483,1,0,0,0,4266,4270,5,315,0,0,4267,
  	4271,5,154,0,0,4268,4269,5,600,0,0,4269,4271,3,1380,690,0,4270,4267,1,
  	0,0,0,4270,4268,1,0,0,0,4271,4272,1,0,0,0,4272,4273,5,239,0,0,4273,4274,
  	5,348,0,0,4274,485,1,0,0,0,4275,4280,5,348,0,0,4276,4277,4,243,86,0,4277,
  	4278,5,489,0,0,4278,4280,5,548,0,0,4279,4275,1,0,0,0,4279,4276,1,0,0,
  	0,4280,487,1,0,0,0,4281,4282,5,100,0,0,4282,4283,3,486,243,0,4283,4284,
  	5,616,0,0,4284,4286,3,490,245,0,4285,4287,3,1028,514,0,4286,4285,1,0,
  	0,0,4286,4287,1,0,0,0,4287,489,1,0,0,0,4288,4293,3,492,246,0,4289,4290,
  	5,29,0,0,4290,4292,3,492,246,0,4291,4289,1,0,0,0,4292,4295,1,0,0,0,4293,
  	4291,1,0,0,0,4293,4294,1,0,0,0,4294,491,1,0,0,0,4295,4293,1,0,0,0,4296,
  	4297,3,496,248,0,4297,4298,5,6,0,0,4298,4299,3,1444,722,0,4299,4425,1,
  	0,0,0,4300,4301,5,754,0,0,4301,4302,5,6,0,0,4302,4425,3,1444,722,0,4303,
  	4304,3,498,249,0,4304,4305,5,6,0,0,4305,4306,3,1444,722,0,4306,4425,1,
  	0,0,0,4307,4308,3,500,250,0,4308,4309,5,6,0,0,4309,4310,3,1444,722,0,
  	4310,4425,1,0,0,0,4311,4312,3,502,251,0,4312,4313,5,6,0,0,4313,4314,3,
  	1444,722,0,4314,4425,1,0,0,0,4315,4316,3,504,252,0,4316,4317,5,6,0,0,
  	4317,4318,3,1416,708,0,4318,4425,1,0,0,0,4319,4320,3,506,253,0,4320,4321,
  	5,6,0,0,4321,4322,3,1416,708,0,4322,4425,1,0,0,0,4323,4324,3,508,254,
  	0,4324,4325,5,6,0,0,4325,4326,3,1416,708,0,4326,4425,1,0,0,0,4327,4328,
  	3,510,255,0,4328,4329,5,6,0,0,4329,4330,3,1416,708,0,4330,4425,1,0,0,
  	0,4331,4332,3,512,256,0,4332,4333,5,6,0,0,4333,4334,3,1416,708,0,4334,
  	4425,1,0,0,0,4335,4336,3,514,257,0,4336,4337,5,6,0,0,4337,4338,3,1444,
  	722,0,4338,4425,1,0,0,0,4339,4340,3,516,258,0,4340,4341,5,6,0,0,4341,
  	4342,3,1444,722,0,4342,4425,1,0,0,0,4343,4344,3,528,264,0,4344,4345,5,
  	6,0,0,4345,4346,3,1444,722,0,4346,4425,1,0,0,0,4347,4348,3,532,266,0,
  	4348,4349,5,6,0,0,4349,4350,3,1444,722,0,4350,4425,1,0,0,0,4351,4352,
  	3,530,265,0,4352,4353,5,6,0,0,4353,4354,3,550,275,0,4354,4425,1,0,0,0,
  	4355,4356,3,518,259,0,4356,4357,5,6,0,0,4357,4358,3,1444,722,0,4358,4425,
  	1,0,0,0,4359,4360,3,524,262,0,4360,4361,5,6,0,0,4361,4362,3,1444,722,
  	0,4362,4425,1,0,0,0,4363,4364,3,526,263,0,4364,4365,5,6,0,0,4365,4366,
  	3,1416,708,0,4366,4425,1,0,0,0,4367,4368,3,520,260,0,4368,4369,5,6,0,
  	0,4369,4370,3,1442,721,0,4370,4425,1,0,0,0,4371,4372,3,522,261,0,4372,
  	4373,5,6,0,0,4373,4374,3,1444,722,0,4374,4425,1,0,0,0,4375,4376,3,534,
  	267,0,4376,4377,5,6,0,0,4377,4378,3,1444,722,0,4378,4425,1,0,0,0,4379,
  	4380,3,536,268,0,4380,4381,5,6,0,0,4381,4382,3,1416,708,0,4382,4425,1,
  	0,0,0,4383,4384,3,538,269,0,4384,4385,5,6,0,0,4385,4386,3,1416,708,0,
  	4386,4425,1,0,0,0,4387,4388,5,269,0,0,4388,4389,5,6,0,0,4389,4425,3,558,
  	279,0,4390,4391,3,540,270,0,4391,4392,5,6,0,0,4392,4393,3,1436,718,0,
  	4393,4425,1,0,0,0,4394,4395,3,542,271,0,4395,4396,5,6,0,0,4396,4397,3,
  	1416,708,0,4397,4425,1,0,0,0,4398,4399,3,494,247,0,4399,4400,5,6,0,0,
  	4400,4401,3,1416,708,0,4401,4425,1,0,0,0,4402,4403,5,762,0,0,4403,4404,
  	5,6,0,0,4404,4425,3,544,272,0,4405,4406,5,764,0,0,4406,4407,5,6,0,0,4407,
  	4425,3,1416,708,0,4408,4409,5,767,0,0,4409,4410,5,6,0,0,4410,4425,3,546,
  	273,0,4411,4412,4,246,87,0,4412,4413,5,776,0,0,4413,4414,5,6,0,0,4414,
  	4425,3,1418,709,0,4415,4416,4,246,88,0,4416,4417,5,781,0,0,4417,4418,
  	5,6,0,0,4418,4425,3,548,274,0,4419,4420,4,246,89,0,4420,4421,5,819,0,
  	0,4421,4422,5,6,0,0,4422,4425,3,1418,709,0,4423,4425,3,552,276,0,4424,
  	4296,1,0,0,0,4424,4300,1,0,0,0,4424,4303,1,0,0,0,4424,4307,1,0,0,0,4424,
  	4311,1,0,0,0,4424,4315,1,0,0,0,4424,4319,1,0,0,0,4424,4323,1,0,0,0,4424,
  	4327,1,0,0,0,4424,4331,1,0,0,0,4424,4335,1,0,0,0,4424,4339,1,0,0,0,4424,
  	4343,1,0,0,0,4424,4347,1,0,0,0,4424,4351,1,0,0,0,4424,4355,1,0,0,0,4424,
  	4359,1,0,0,0,4424,4363,1,0,0,0,4424,4367,1,0,0,0,4424,4371,1,0,0,0,4424,
  	4375,1,0,0,0,4424,4379,1,0,0,0,4424,4383,1,0,0,0,4424,4387,1,0,0,0,4424,
  	4390,1,0,0,0,4424,4394,1,0,0,0,4424,4398,1,0,0,0,4424,4402,1,0,0,0,4424,
  	4405,1,0,0,0,4424,4408,1,0,0,0,4424,4411,1,0,0,0,4424,4415,1,0,0,0,4424,
  	4419,1,0,0,0,4424,4423,1,0,0,0,4425,493,1,0,0,0,4426,4427,7,45,0,0,4427,
  	495,1,0,0,0,4428,4429,7,46,0,0,4429,497,1,0,0,0,4430,4431,7,47,0,0,4431,
  	499,1,0,0,0,4432,4433,7,48,0,0,4433,501,1,0,0,0,4434,4435,7,49,0,0,4435,
  	503,1,0,0,0,4436,4437,7,50,0,0,4437,505,1,0,0,0,4438,4439,7,51,0,0,4439,
  	507,1,0,0,0,4440,4441,7,52,0,0,4441,509,1,0,0,0,4442,4443,7,53,0,0,4443,
  	511,1,0,0,0,4444,4445,7,54,0,0,4445,513,1,0,0,0,4446,4447,7,55,0,0,4447,
  	515,1,0,0,0,4448,4449,7,56,0,0,4449,517,1,0,0,0,4450,4451,7,57,0,0,4451,
  	519,1,0,0,0,4452,4453,7,58,0,0,4453,521,1,0,0,0,4454,4455,7,59,0,0,4455,
  	523,1,0,0,0,4456,4457,7,60,0,0,4457,525,1,0,0,0,4458,4459,7,61,0,0,4459,
  	527,1,0,0,0,4460,4461,7,62,0,0,4461,529,1,0,0,0,4462,4463,7,63,0,0,4463,
  	531,1,0,0,0,4464,4465,7,64,0,0,4465,533,1,0,0,0,4466,4467,7,65,0,0,4467,
  	535,1,0,0,0,4468,4469,7,66,0,0,4469,537,1,0,0,0,4470,4471,7,67,0,0,4471,
  	539,1,0,0,0,4472,4473,7,68,0,0,4473,541,1,0,0,0,4474,4475,7,69,0,0,4475,
  	543,1,0,0,0,4476,4479,3,1302,651,0,4477,4479,5,406,0,0,4478,4476,1,0,
  	0,0,4478,4477,1,0,0,0,4479,545,1,0,0,0,4480,4481,7,70,0,0,4481,547,1,
  	0,0,0,4482,4486,5,769,0,0,4483,4486,5,316,0,0,4484,4486,3,1436,718,0,
  	4485,4482,1,0,0,0,4485,4483,1,0,0,0,4485,4484,1,0,0,0,4486,549,1,0,0,
  	0,4487,4490,3,1444,722,0,4488,4490,5,406,0,0,4489,4487,1,0,0,0,4489,4488,
  	1,0,0,0,4490,551,1,0,0,0,4491,4492,3,554,277,0,4492,4493,5,6,0,0,4493,
  	4494,3,1444,722,0,4494,4506,1,0,0,0,4495,4496,3,556,278,0,4496,4497,5,
  	6,0,0,4497,4498,3,1420,710,0,4498,4506,1,0,0,0,4499,4500,5,477,0,0,4500,
  	4501,5,6,0,0,4501,4506,3,1444,722,0,4502,4503,5,478,0,0,4503,4504,5,6,
  	0,0,4504,4506,3,1416,708,0,4505,4491,1,0,0,0,4505,4495,1,0,0,0,4505,4499,
  	1,0,0,0,4505,4502,1,0,0,0,4506,553,1,0,0,0,4507,4508,7,71,0,0,4508,555,
  	1,0,0,0,4509,4510,7,72,0,0,4510,557,1,0,0,0,4511,4520,5,32,0,0,4512,4517,
  	3,1416,708,0,4513,4514,5,29,0,0,4514,4516,3,1416,708,0,4515,4513,1,0,
  	0,0,4516,4519,1,0,0,0,4517,4515,1,0,0,0,4517,4518,1,0,0,0,4518,4521,1,
  	0,0,0,4519,4517,1,0,0,0,4520,4512,1,0,0,0,4520,4521,1,0,0,0,4521,4522,
  	1,0,0,0,4522,4523,5,33,0,0,4523,559,1,0,0,0,4524,4525,5,100,0,0,4525,
  	4526,5,489,0,0,4526,4527,5,228,0,0,4527,4532,3,562,281,0,4528,4529,5,
  	29,0,0,4529,4531,3,562,281,0,4530,4528,1,0,0,0,4531,4534,1,0,0,0,4532,
  	4530,1,0,0,0,4532,4533,1,0,0,0,4533,4537,1,0,0,0,4534,4532,1,0,0,0,4535,
  	4536,4,280,90,0,4536,4538,3,1028,514,0,4537,4535,1,0,0,0,4537,4538,1,
  	0,0,0,4538,561,1,0,0,0,4539,4540,5,490,0,0,4540,4541,5,6,0,0,4541,4543,
  	5,32,0,0,4542,4544,3,564,282,0,4543,4542,1,0,0,0,4543,4544,1,0,0,0,4544,
  	4545,1,0,0,0,4545,4589,5,33,0,0,4546,4547,5,491,0,0,4547,4548,5,6,0,0,
  	4548,4550,5,32,0,0,4549,4551,3,564,282,0,4550,4549,1,0,0,0,4550,4551,
  	1,0,0,0,4551,4552,1,0,0,0,4552,4589,5,33,0,0,4553,4554,5,492,0,0,4554,
  	4555,5,6,0,0,4555,4557,5,32,0,0,4556,4558,3,566,283,0,4557,4556,1,0,0,
  	0,4557,4558,1,0,0,0,4558,4559,1,0,0,0,4559,4589,5,33,0,0,4560,4561,5,
  	493,0,0,4561,4562,5,6,0,0,4562,4564,5,32,0,0,4563,4565,3,566,283,0,4564,
  	4563,1,0,0,0,4564,4565,1,0,0,0,4565,4566,1,0,0,0,4566,4589,5,33,0,0,4567,
  	4568,5,494,0,0,4568,4569,5,6,0,0,4569,4571,5,32,0,0,4570,4572,3,568,284,
  	0,4571,4570,1,0,0,0,4571,4572,1,0,0,0,4572,4573,1,0,0,0,4573,4589,5,33,
  	0,0,4574,4575,5,495,0,0,4575,4576,5,6,0,0,4576,4578,5,32,0,0,4577,4579,
  	3,568,284,0,4578,4577,1,0,0,0,4578,4579,1,0,0,0,4579,4580,1,0,0,0,4580,
  	4589,5,33,0,0,4581,4582,5,496,0,0,4582,4583,5,6,0,0,4583,4585,5,32,0,
  	0,4584,4586,3,572,286,0,4585,4584,1,0,0,0,4585,4586,1,0,0,0,4586,4587,
  	1,0,0,0,4587,4589,5,33,0,0,4588,4539,1,0,0,0,4588,4546,1,0,0,0,4588,4553,
  	1,0,0,0,4588,4560,1,0,0,0,4588,4567,1,0,0,0,4588,4574,1,0,0,0,4588,4581,
  	1,0,0,0,4589,563,1,0,0,0,4590,4595,3,1336,668,0,4591,4592,5,29,0,0,4592,
  	4594,3,1336,668,0,4593,4591,1,0,0,0,4594,4597,1,0,0,0,4595,4593,1,0,0,
  	0,4595,4596,1,0,0,0,4596,565,1,0,0,0,4597,4595,1,0,0,0,4598,4603,3,1376,
  	688,0,4599,4600,5,29,0,0,4600,4602,3,1376,688,0,4601,4599,1,0,0,0,4602,
  	4605,1,0,0,0,4603,4601,1,0,0,0,4603,4604,1,0,0,0,4604,567,1,0,0,0,4605,
  	4603,1,0,0,0,4606,4611,3,570,285,0,4607,4608,5,29,0,0,4608,4610,3,570,
  	285,0,4609,4607,1,0,0,0,4610,4613,1,0,0,0,4611,4609,1,0,0,0,4611,4612,
  	1,0,0,0,4612,569,1,0,0,0,4613,4611,1,0,0,0,4614,4615,3,1444,722,0,4615,
  	571,1,0,0,0,4616,4621,3,1250,625,0,4617,4618,5,29,0,0,4618,4620,3,1250,
  	625,0,4619,4617,1,0,0,0,4620,4623,1,0,0,0,4621,4619,1,0,0,0,4621,4622,
  	1,0,0,0,4622,573,1,0,0,0,4623,4621,1,0,0,0,4624,4625,5,569,0,0,4625,4627,
  	3,604,302,0,4626,4628,3,588,294,0,4627,4626,1,0,0,0,4627,4628,1,0,0,0,
  	4628,4631,1,0,0,0,4629,4630,5,639,0,0,4630,4632,3,578,289,0,4631,4629,
  	1,0,0,0,4631,4632,1,0,0,0,4632,4634,1,0,0,0,4633,4635,3,580,290,0,4634,
  	4633,1,0,0,0,4634,4635,1,0,0,0,4635,4637,1,0,0,0,4636,4638,3,582,291,
  	0,4637,4636,1,0,0,0,4637,4638,1,0,0,0,4638,4640,1,0,0,0,4639,4641,3,584,
  	292,0,4640,4639,1,0,0,0,4640,4641,1,0,0,0,4641,4643,1,0,0,0,4642,4644,
  	3,586,293,0,4643,4642,1,0,0,0,4643,4644,1,0,0,0,4644,4646,1,0,0,0,4645,
  	4647,3,1028,514,0,4646,4645,1,0,0,0,4646,4647,1,0,0,0,4647,575,1,0,0,
  	0,4648,4649,5,578,0,0,4649,4651,3,604,302,0,4650,4652,3,588,294,0,4651,
  	4650,1,0,0,0,4651,4652,1,0,0,0,4652,4654,1,0,0,0,4653,4655,3,1028,514,
  	0,4654,4653,1,0,0,0,4654,4655,1,0,0,0,4655,577,1,0,0,0,4656,4662,3,552,
  	276,0,4657,4658,7,73,0,0,4658,4659,5,6,0,0,4659,4662,3,1438,719,0,4660,
  	4662,5,555,0,0,4661,4656,1,0,0,0,4661,4657,1,0,0,0,4661,4660,1,0,0,0,
  	4662,4667,1,0,0,0,4663,4664,5,29,0,0,4664,4666,3,552,276,0,4665,4663,
  	1,0,0,0,4666,4669,1,0,0,0,4667,4665,1,0,0,0,4667,4668,1,0,0,0,4668,579,
  	1,0,0,0,4669,4667,1,0,0,0,4670,4671,5,644,0,0,4671,4672,5,6,0,0,4672,
  	4673,3,1438,719,0,4673,581,1,0,0,0,4674,4675,5,436,0,0,4675,4676,5,6,
  	0,0,4676,4677,3,1438,719,0,4677,583,1,0,0,0,4678,4679,5,169,0,0,4679,
  	4680,5,6,0,0,4680,4681,3,1438,719,0,4681,585,1,0,0,0,4682,4683,5,439,
  	0,0,4683,4684,5,6,0,0,4684,4685,3,1438,719,0,4685,587,1,0,0,0,4686,4691,
  	3,590,295,0,4687,4688,5,29,0,0,4688,4690,3,590,295,0,4689,4687,1,0,0,
  	0,4690,4693,1,0,0,0,4691,4689,1,0,0,0,4691,4692,1,0,0,0,4692,589,1,0,
  	0,0,4693,4691,1,0,0,0,4694,4695,7,74,0,0,4695,591,1,0,0,0,4696,4697,5,
  	569,0,0,4697,4700,5,246,0,0,4698,4699,4,296,91,0,4699,4701,3,594,297,
  	0,4700,4698,1,0,0,0,4700,4701,1,0,0,0,4701,4705,1,0,0,0,4702,4703,5,578,
  	0,0,4703,4705,5,246,0,0,4704,4696,1,0,0,0,4704,4702,1,0,0,0,4705,593,
  	1,0,0,0,4706,4711,3,596,298,0,4707,4708,5,29,0,0,4708,4710,3,596,298,
  	0,4709,4707,1,0,0,0,4710,4713,1,0,0,0,4711,4709,1,0,0,0,4711,4712,1,0,
  	0,0,4712,595,1,0,0,0,4713,4711,1,0,0,0,4714,4718,3,598,299,0,4715,4718,
  	3,600,300,0,4716,4718,3,602,301,0,4717,4714,1,0,0,0,4717,4715,1,0,0,0,
  	4717,4716,1,0,0,0,4718,597,1,0,0,0,4719,4720,5,644,0,0,4720,4721,5,6,
  	0,0,4721,4722,3,1444,722,0,4722,599,1,0,0,0,4723,4724,5,436,0,0,4724,
  	4725,5,6,0,0,4725,4726,3,1444,722,0,4726,601,1,0,0,0,4727,4728,5,169,
  	0,0,4728,4729,5,6,0,0,4729,4730,3,1444,722,0,4730,603,1,0,0,0,4731,4732,
  	7,75,0,0,4732,605,1,0,0,0,4733,4734,5,447,0,0,4734,4735,3,1404,702,0,
  	4735,4738,5,239,0,0,4736,4739,3,1442,721,0,4737,4739,3,982,491,0,4738,
  	4736,1,0,0,0,4738,4737,1,0,0,0,4739,4745,1,0,0,0,4740,4745,3,608,304,
  	0,4741,4742,7,76,0,0,4742,4743,5,447,0,0,4743,4745,3,1404,702,0,4744,
  	4733,1,0,0,0,4744,4740,1,0,0,0,4744,4741,1,0,0,0,4745,607,1,0,0,0,4746,
  	4747,5,212,0,0,4747,4750,3,1404,702,0,4748,4749,5,647,0,0,4749,4751,3,
  	610,305,0,4750,4748,1,0,0,0,4750,4751,1,0,0,0,4751,609,1,0,0,0,4752,4757,
  	3,982,491,0,4753,4754,5,29,0,0,4754,4756,3,982,491,0,4755,4753,1,0,0,
  	0,4756,4759,1,0,0,0,4757,4755,1,0,0,0,4757,4758,1,0,0,0,4758,611,1,0,
  	0,0,4759,4757,1,0,0,0,4760,4785,5,702,0,0,4761,4762,5,316,0,0,4762,4763,
  	5,154,0,0,4763,4765,5,179,0,0,4764,4766,3,1474,737,0,4765,4764,1,0,0,
  	0,4765,4766,1,0,0,0,4766,4767,1,0,0,0,4767,4786,3,1436,718,0,4768,4771,
  	5,701,0,0,4769,4770,5,236,0,0,4770,4772,5,489,0,0,4771,4769,1,0,0,0,4771,
  	4772,1,0,0,0,4772,4786,1,0,0,0,4773,4774,4,306,92,0,4774,4775,5,280,0,
  	0,4775,4776,5,239,0,0,4776,4777,3,1304,652,0,4777,4778,5,31,0,0,4778,
  	4779,3,1416,708,0,4779,4780,5,266,0,0,4780,4781,5,90,0,0,4781,4783,3,
  	1436,718,0,4782,4784,3,614,307,0,4783,4782,1,0,0,0,4783,4784,1,0,0,0,
  	4784,4786,1,0,0,0,4785,4761,1,0,0,0,4785,4768,1,0,0,0,4785,4773,1,0,0,
  	0,4786,613,1,0,0,0,4787,4798,3,616,308,0,4788,4789,5,154,0,0,4789,4791,
  	5,179,0,0,4790,4792,3,1474,737,0,4791,4790,1,0,0,0,4791,4792,1,0,0,0,
  	4792,4793,1,0,0,0,4793,4795,3,1436,718,0,4794,4796,3,616,308,0,4795,4794,
  	1,0,0,0,4795,4796,1,0,0,0,4796,4798,1,0,0,0,4797,4787,1,0,0,0,4797,4788,
  	1,0,0,0,4798,615,1,0,0,0,4799,4801,5,497,0,0,4800,4802,5,403,0,0,4801,
  	4800,1,0,0,0,4801,4802,1,0,0,0,4802,4803,1,0,0,0,4803,4804,5,565,0,0,
  	4804,617,1,0,0,0,4805,4814,3,620,310,0,4806,4814,3,630,315,0,4807,4814,
  	3,644,322,0,4808,4814,3,646,323,0,4809,4814,3,660,330,0,4810,4814,3,662,
  	331,0,4811,4812,4,309,93,0,4812,4814,3,678,339,0,4813,4805,1,0,0,0,4813,
  	4806,1,0,0,0,4813,4807,1,0,0,0,4813,4808,1,0,0,0,4813,4809,1,0,0,0,4813,
  	4810,1,0,0,0,4813,4811,1,0,0,0,4814,619,1,0,0,0,4815,4816,5,57,0,0,4816,
  	4819,5,644,0,0,4817,4818,4,310,94,0,4818,4820,3,1232,616,0,4819,4817,
  	1,0,0,0,4819,4820,1,0,0,0,4820,4870,1,0,0,0,4821,4822,4,310,95,0,4822,
  	4826,3,1270,635,0,4823,4824,4,310,96,0,4824,4826,3,622,311,0,4825,4821,
  	1,0,0,0,4825,4823,1,0,0,0,4826,4827,1,0,0,0,4827,4828,3,632,316,0,4828,
  	4871,1,0,0,0,4829,4830,4,310,97,0,4830,4849,3,628,314,0,4831,4834,3,1280,
  	640,0,4832,4834,3,1278,639,0,4833,4831,1,0,0,0,4833,4832,1,0,0,0,4834,
  	4837,1,0,0,0,4835,4836,4,310,98,0,4836,4838,3,1300,650,0,4837,4835,1,
  	0,0,0,4837,4838,1,0,0,0,4838,4841,1,0,0,0,4839,4840,4,310,99,0,4840,4842,
  	3,1292,646,0,4841,4839,1,0,0,0,4841,4842,1,0,0,0,4842,4850,1,0,0,0,4843,
  	4844,4,310,100,0,4844,4850,3,1294,647,0,4845,4847,4,310,101,0,4846,4848,
  	3,1296,648,0,4847,4846,1,0,0,0,4847,4848,1,0,0,0,4848,4850,1,0,0,0,4849,
  	4833,1,0,0,0,4849,4843,1,0,0,0,4849,4845,1,0,0,0,4850,4871,1,0,0,0,4851,
  	4852,4,310,102,0,4852,4853,3,628,314,0,4853,4854,3,1278,639,0,4854,4871,
  	1,0,0,0,4855,4856,4,310,103,0,4856,4868,3,1304,652,0,4857,4858,5,168,
  	0,0,4858,4862,5,684,0,0,4859,4863,5,56,0,0,4860,4863,5,399,0,0,4861,4863,
  	3,680,340,0,4862,4859,1,0,0,0,4862,4860,1,0,0,0,4862,4861,1,0,0,0,4863,
  	4869,1,0,0,0,4864,4866,4,310,104,0,4865,4867,3,1296,648,0,4866,4865,1,
  	0,0,0,4866,4867,1,0,0,0,4867,4869,1,0,0,0,4868,4857,1,0,0,0,4868,4864,
  	1,0,0,0,4869,4871,1,0,0,0,4870,4825,1,0,0,0,4870,4829,1,0,0,0,4870,4851,
  	1,0,0,0,4870,4855,1,0,0,0,4871,621,1,0,0,0,4872,4877,3,624,312,0,4873,
  	4874,5,29,0,0,4874,4876,3,624,312,0,4875,4873,1,0,0,0,4876,4879,1,0,0,
  	0,4877,4875,1,0,0,0,4877,4878,1,0,0,0,4878,623,1,0,0,0,4879,4877,1,0,
  	0,0,4880,4881,4,312,105,0,4881,4959,3,626,313,0,4882,4883,4,312,106,0,
  	4883,4956,3,1304,652,0,4884,4893,3,1278,639,0,4885,4886,5,488,0,0,4886,
  	4888,3,1436,718,0,4887,4889,3,1292,646,0,4888,4887,1,0,0,0,4888,4889,
  	1,0,0,0,4889,4894,1,0,0,0,4890,4892,3,1292,646,0,4891,4890,1,0,0,0,4891,
  	4892,1,0,0,0,4892,4894,1,0,0,0,4893,4885,1,0,0,0,4893,4891,1,0,0,0,4894,
  	4957,1,0,0,0,4895,4904,3,1280,640,0,4896,4898,3,1292,646,0,4897,4896,
  	1,0,0,0,4897,4898,1,0,0,0,4898,4905,1,0,0,0,4899,4900,5,488,0,0,4900,
  	4902,3,1436,718,0,4901,4903,3,1292,646,0,4902,4901,1,0,0,0,4902,4903,
  	1,0,0,0,4903,4905,1,0,0,0,4904,4897,1,0,0,0,4904,4899,1,0,0,0,4905,4957,
  	1,0,0,0,4906,4957,3,1282,641,0,4907,4909,3,1284,642,0,4908,4910,3,1292,
  	646,0,4909,4908,1,0,0,0,4909,4910,1,0,0,0,4910,4957,1,0,0,0,4911,4920,
  	3,1286,643,0,4912,4913,5,488,0,0,4913,4915,3,1436,718,0,4914,4916,3,1292,
  	646,0,4915,4914,1,0,0,0,4915,4916,1,0,0,0,4916,4921,1,0,0,0,4917,4919,
  	3,1292,646,0,4918,4917,1,0,0,0,4918,4919,1,0,0,0,4919,4921,1,0,0,0,4920,
  	4912,1,0,0,0,4920,4918,1,0,0,0,4921,4957,1,0,0,0,4922,4924,3,1288,644,
  	0,4923,4925,3,1292,646,0,4924,4923,1,0,0,0,4924,4925,1,0,0,0,4925,4957,
  	1,0,0,0,4926,4928,3,1294,647,0,4927,4926,1,0,0,0,4927,4928,1,0,0,0,4928,
  	4957,1,0,0,0,4929,4930,4,312,107,0,4930,4931,5,50,0,0,4931,4932,3,1298,
  	649,0,4932,4937,3,1276,638,0,4933,4934,5,50,0,0,4934,4935,3,1298,649,
  	0,4935,4936,3,1276,638,0,4936,4938,1,0,0,0,4937,4933,1,0,0,0,4937,4938,
  	1,0,0,0,4938,4957,1,0,0,0,4939,4940,4,312,108,0,4940,4941,5,379,0,0,4941,
  	4942,3,1298,649,0,4942,4947,3,1276,638,0,4943,4944,5,379,0,0,4944,4945,
  	3,1298,649,0,4945,4946,3,1276,638,0,4946,4948,1,0,0,0,4947,4943,1,0,0,
  	0,4947,4948,1,0,0,0,4948,4957,1,0,0,0,4949,4950,4,312,109,0,4950,4951,
  	5,187,0,0,4951,4954,3,1298,649,0,4952,4953,5,187,0,0,4953,4955,3,1298,
  	649,0,4954,4952,1,0,0,0,4954,4955,1,0,0,0,4955,4957,1,0,0,0,4956,4884,
  	1,0,0,0,4956,4895,1,0,0,0,4956,4906,1,0,0,0,4956,4907,1,0,0,0,4956,4911,
  	1,0,0,0,4956,4922,1,0,0,0,4956,4927,1,0,0,0,4956,4929,1,0,0,0,4956,4939,
  	1,0,0,0,4956,4949,1,0,0,0,4957,4959,1,0,0,0,4958,4880,1,0,0,0,4958,4882,
  	1,0,0,0,4959,625,1,0,0,0,4960,4961,3,1304,652,0,4961,4962,5,266,0,0,4962,
  	4981,5,90,0,0,4963,4966,3,1438,719,0,4964,4965,4,313,110,0,4965,4967,
  	3,1300,650,0,4966,4964,1,0,0,0,4966,4967,1,0,0,0,4967,4970,1,0,0,0,4968,
  	4969,4,313,111,0,4969,4971,3,1292,646,0,4970,4968,1,0,0,0,4970,4971,1,
  	0,0,0,4971,4982,1,0,0,0,4972,4973,4,313,112,0,4973,4974,5,759,0,0,4974,
  	4976,5,436,0,0,4975,4977,3,1300,650,0,4976,4975,1,0,0,0,4976,4977,1,0,
  	0,0,4977,4979,1,0,0,0,4978,4980,3,1292,646,0,4979,4978,1,0,0,0,4979,4980,
  	1,0,0,0,4980,4982,1,0,0,0,4981,4963,1,0,0,0,4981,4972,1,0,0,0,4982,5018,
  	1,0,0,0,4983,4984,3,1304,652,0,4984,4985,5,266,0,0,4985,4986,5,670,0,
  	0,4986,5010,3,1464,732,0,4987,4988,5,90,0,0,4988,4991,3,1438,719,0,4989,
  	4990,4,313,113,0,4990,4992,3,1300,650,0,4991,4989,1,0,0,0,4991,4992,1,
  	0,0,0,4992,4995,1,0,0,0,4993,4994,4,313,114,0,4994,4996,3,1292,646,0,
  	4995,4993,1,0,0,0,4995,4996,1,0,0,0,4996,5011,1,0,0,0,4997,4998,5,63,
  	0,0,4998,5001,3,1440,720,0,4999,5000,4,313,115,0,5000,5002,3,1292,646,
  	0,5001,4999,1,0,0,0,5001,5002,1,0,0,0,5002,5011,1,0,0,0,5003,5004,4,313,
  	116,0,5004,5005,5,90,0,0,5005,5006,5,759,0,0,5006,5008,5,436,0,0,5007,
  	5009,3,1292,646,0,5008,5007,1,0,0,0,5008,5009,1,0,0,0,5009,5011,1,0,0,
  	0,5010,4987,1,0,0,0,5010,4997,1,0,0,0,5010,5003,1,0,0,0,5010,5011,1,0,
  	0,0,5011,5018,1,0,0,0,5012,5013,4,313,117,0,5013,5015,3,1304,652,0,5014,
  	5016,3,1294,647,0,5015,5014,1,0,0,0,5015,5016,1,0,0,0,5016,5018,1,0,0,
  	0,5017,4960,1,0,0,0,5017,4983,1,0,0,0,5017,5012,1,0,0,0,5018,627,1,0,
  	0,0,5019,5020,5,644,0,0,5020,5021,3,1472,736,0,5021,629,1,0,0,0,5022,
  	5023,5,140,0,0,5023,5026,5,644,0,0,5024,5025,4,315,118,0,5025,5027,3,
  	1238,619,0,5026,5024,1,0,0,0,5026,5027,1,0,0,0,5027,5028,1,0,0,0,5028,
  	5029,3,1270,635,0,5029,5030,3,636,318,0,5030,5031,3,632,316,0,5031,631,
  	1,0,0,0,5032,5034,4,316,119,0,5033,5035,3,638,319,0,5034,5033,1,0,0,0,
  	5034,5035,1,0,0,0,5035,5037,1,0,0,0,5036,5038,3,640,320,0,5037,5036,1,
  	0,0,0,5037,5038,1,0,0,0,5038,5042,1,0,0,0,5039,5041,3,642,321,0,5040,
  	5039,1,0,0,0,5041,5044,1,0,0,0,5042,5040,1,0,0,0,5042,5043,1,0,0,0,5043,
  	5047,1,0,0,0,5044,5042,1,0,0,0,5045,5046,4,316,120,0,5046,5048,3,634,
  	317,0,5047,5045,1,0,0,0,5047,5048,1,0,0,0,5048,5051,1,0,0,0,5049,5051,
  	1,0,0,0,5050,5032,1,0,0,0,5050,5049,1,0,0,0,5051,633,1,0,0,0,5052,5053,
  	5,773,0,0,5053,5057,3,1436,718,0,5054,5055,5,119,0,0,5055,5057,3,1436,
  	718,0,5056,5052,1,0,0,0,5056,5054,1,0,0,0,5057,635,1,0,0,0,5058,5062,
  	4,318,121,0,5059,5060,5,168,0,0,5060,5061,5,684,0,0,5061,5063,3,680,340,
  	0,5062,5059,1,0,0,0,5062,5063,1,0,0,0,5063,5066,1,0,0,0,5064,5066,1,0,
  	0,0,5065,5058,1,0,0,0,5065,5064,1,0,0,0,5066,637,1,0,0,0,5067,5070,5,
  	497,0,0,5068,5071,3,672,336,0,5069,5071,7,77,0,0,5070,5068,1,0,0,0,5070,
  	5069,1,0,0,0,5071,639,1,0,0,0,5072,5081,5,670,0,0,5073,5074,5,354,0,0,
  	5074,5082,3,1416,708,0,5075,5076,5,359,0,0,5076,5082,3,1416,708,0,5077,
  	5078,5,353,0,0,5078,5082,3,1416,708,0,5079,5080,5,360,0,0,5080,5082,3,
  	1416,708,0,5081,5073,1,0,0,0,5081,5075,1,0,0,0,5081,5077,1,0,0,0,5081,
  	5079,1,0,0,0,5082,5083,1,0,0,0,5083,5081,1,0,0,0,5083,5084,1,0,0,0,5084,
  	641,1,0,0,0,5085,5086,5,48,0,0,5086,5128,7,78,0,0,5087,5116,5,436,0,0,
  	5088,5095,5,216,0,0,5089,5090,5,282,0,0,5090,5091,3,1418,709,0,5091,5092,
  	5,163,0,0,5092,5096,1,0,0,0,5093,5096,5,395,0,0,5094,5096,5,168,0,0,5095,
  	5089,1,0,0,0,5095,5093,1,0,0,0,5095,5094,1,0,0,0,5095,5096,1,0,0,0,5096,
  	5117,1,0,0,0,5097,5100,5,730,0,0,5098,5101,3,1418,709,0,5099,5101,5,168,
  	0,0,5100,5098,1,0,0,0,5100,5099,1,0,0,0,5101,5117,1,0,0,0,5102,5103,5,
  	731,0,0,5103,5108,5,282,0,0,5104,5105,3,1418,709,0,5105,5106,5,163,0,
  	0,5106,5109,1,0,0,0,5107,5109,5,168,0,0,5108,5104,1,0,0,0,5108,5107,1,
  	0,0,0,5109,5117,1,0,0,0,5110,5111,4,321,122,0,5111,5112,5,497,0,0,5112,
  	5114,5,144,0,0,5113,5115,7,79,0,0,5114,5113,1,0,0,0,5114,5115,1,0,0,0,
  	5115,5117,1,0,0,0,5116,5088,1,0,0,0,5116,5097,1,0,0,0,5116,5102,1,0,0,
  	0,5116,5110,1,0,0,0,5117,5128,1,0,0,0,5118,5119,4,321,123,0,5119,5120,
  	5,766,0,0,5120,5128,3,1418,709,0,5121,5122,4,321,124,0,5122,5125,5,765,
  	0,0,5123,5126,3,1418,709,0,5124,5126,5,723,0,0,5125,5123,1,0,0,0,5125,
  	5124,1,0,0,0,5126,5128,1,0,0,0,5127,5085,1,0,0,0,5127,5087,1,0,0,0,5127,
  	5118,1,0,0,0,5127,5121,1,0,0,0,5128,643,1,0,0,0,5129,5130,5,187,0,0,5130,
  	5133,5,644,0,0,5131,5132,4,322,125,0,5132,5134,3,1232,616,0,5133,5131,
  	1,0,0,0,5133,5134,1,0,0,0,5134,5135,1,0,0,0,5135,5136,3,1268,634,0,5136,
  	645,1,0,0,0,5137,5180,5,251,0,0,5138,5139,4,323,126,0,5139,5140,3,666,
  	333,0,5140,5141,5,616,0,0,5141,5145,3,1268,634,0,5142,5143,5,670,0,0,
  	5143,5144,5,685,0,0,5144,5146,5,421,0,0,5145,5142,1,0,0,0,5145,5146,1,
  	0,0,0,5146,5181,1,0,0,0,5147,5153,3,666,333,0,5148,5150,5,56,0,0,5149,
  	5151,5,451,0,0,5150,5149,1,0,0,0,5150,5151,1,0,0,0,5151,5153,1,0,0,0,
  	5152,5147,1,0,0,0,5152,5148,1,0,0,0,5153,5154,1,0,0,0,5154,5156,5,413,
  	0,0,5155,5157,3,664,332,0,5156,5155,1,0,0,0,5156,5157,1,0,0,0,5157,5158,
  	1,0,0,0,5158,5159,3,670,335,0,5159,5160,5,616,0,0,5160,5162,3,648,324,
  	0,5161,5163,3,658,329,0,5162,5161,1,0,0,0,5162,5163,1,0,0,0,5163,5165,
  	1,0,0,0,5164,5166,3,650,325,0,5165,5164,1,0,0,0,5165,5166,1,0,0,0,5166,
  	5168,1,0,0,0,5167,5169,3,656,328,0,5168,5167,1,0,0,0,5168,5169,1,0,0,
  	0,5169,5181,1,0,0,0,5170,5171,5,457,0,0,5171,5172,5,413,0,0,5172,5173,
  	3,1304,652,0,5173,5174,5,616,0,0,5174,5178,3,648,324,0,5175,5176,5,670,
  	0,0,5176,5177,5,251,0,0,5177,5179,5,421,0,0,5178,5175,1,0,0,0,5178,5179,
  	1,0,0,0,5179,5181,1,0,0,0,5180,5138,1,0,0,0,5180,5152,1,0,0,0,5180,5170,
  	1,0,0,0,5181,647,1,0,0,0,5182,5183,4,324,127,0,5183,5187,3,1270,635,0,
  	5184,5185,4,324,128,0,5185,5187,3,1268,634,0,5186,5182,1,0,0,0,5186,5184,
  	1,0,0,0,5187,649,1,0,0,0,5188,5189,5,670,0,0,5189,5190,3,676,338,0,5190,
  	651,1,0,0,0,5191,5192,5,688,0,0,5192,5193,3,680,340,0,5193,653,1,0,0,
  	0,5194,5195,5,670,0,0,5195,5203,5,684,0,0,5196,5204,3,680,340,0,5197,
  	5199,5,56,0,0,5198,5200,3,652,326,0,5199,5198,1,0,0,0,5199,5200,1,0,0,
  	0,5200,5204,1,0,0,0,5201,5204,5,399,0,0,5202,5204,5,168,0,0,5203,5196,
  	1,0,0,0,5203,5197,1,0,0,0,5203,5201,1,0,0,0,5203,5202,1,0,0,0,5204,655,
  	1,0,0,0,5205,5206,5,63,0,0,5206,5208,5,644,0,0,5207,5209,3,654,327,0,
  	5208,5207,1,0,0,0,5208,5209,1,0,0,0,5209,657,1,0,0,0,5210,5211,4,329,
  	129,0,5211,5212,3,638,319,0,5212,659,1,0,0,0,5213,5214,5,483,0,0,5214,
  	5215,5,644,0,0,5215,5216,3,1304,652,0,5216,5217,5,616,0,0,5217,5225,3,
  	1304,652,0,5218,5219,5,29,0,0,5219,5220,3,1304,652,0,5220,5221,5,616,
  	0,0,5221,5222,3,1304,652,0,5222,5224,1,0,0,0,5223,5218,1,0,0,0,5224,5227,
  	1,0,0,0,5225,5223,1,0,0,0,5225,5226,1,0,0,0,5226,661,1,0,0,0,5227,5225,
  	1,0,0,0,5228,5231,5,507,0,0,5229,5230,4,331,130,0,5230,5232,3,1232,616,
  	0,5231,5229,1,0,0,0,5231,5232,1,0,0,0,5232,5270,1,0,0,0,5233,5234,4,331,
  	131,0,5234,5235,3,666,333,0,5235,5236,5,239,0,0,5236,5237,3,1268,634,
  	0,5237,5271,1,0,0,0,5238,5239,3,666,333,0,5239,5241,5,413,0,0,5240,5242,
  	3,664,332,0,5241,5240,1,0,0,0,5241,5242,1,0,0,0,5242,5243,1,0,0,0,5243,
  	5244,3,670,335,0,5244,5245,5,239,0,0,5245,5246,3,1268,634,0,5246,5271,
  	1,0,0,0,5247,5249,5,56,0,0,5248,5250,5,451,0,0,5249,5248,1,0,0,0,5249,
  	5250,1,0,0,0,5250,5260,1,0,0,0,5251,5252,4,331,132,0,5252,5254,5,413,
  	0,0,5253,5255,3,664,332,0,5254,5253,1,0,0,0,5254,5255,1,0,0,0,5255,5256,
  	1,0,0,0,5256,5261,3,670,335,0,5257,5258,5,29,0,0,5258,5259,5,251,0,0,
  	5259,5261,5,421,0,0,5260,5251,1,0,0,0,5260,5257,1,0,0,0,5261,5262,1,0,
  	0,0,5262,5263,5,239,0,0,5263,5271,3,1268,634,0,5264,5265,5,457,0,0,5265,
  	5266,5,413,0,0,5266,5267,3,1304,652,0,5267,5268,5,239,0,0,5268,5269,3,
  	1268,634,0,5269,5271,1,0,0,0,5270,5233,1,0,0,0,5270,5238,1,0,0,0,5270,
  	5247,1,0,0,0,5270,5264,1,0,0,0,5271,5274,1,0,0,0,5272,5273,4,331,133,
  	0,5273,5275,3,1240,620,0,5274,5272,1,0,0,0,5274,5275,1,0,0,0,5275,663,
  	1,0,0,0,5276,5277,7,80,0,0,5277,665,1,0,0,0,5278,5283,3,668,334,0,5279,
  	5280,5,29,0,0,5280,5282,3,668,334,0,5281,5279,1,0,0,0,5282,5285,1,0,0,
  	0,5283,5281,1,0,0,0,5283,5284,1,0,0,0,5284,667,1,0,0,0,5285,5283,1,0,
  	0,0,5286,5297,4,334,134,0,5287,5289,3,1468,734,0,5288,5290,3,1322,661,
  	0,5289,5288,1,0,0,0,5289,5290,1,0,0,0,5290,5298,1,0,0,0,5291,5292,3,1468,
  	734,0,5292,5295,5,39,0,0,5293,5296,3,1464,732,0,5294,5296,5,850,0,0,5295,
  	5293,1,0,0,0,5295,5294,1,0,0,0,5296,5298,1,0,0,0,5297,5287,1,0,0,0,5297,
  	5291,1,0,0,0,5298,5331,1,0,0,0,5299,5301,7,81,0,0,5300,5302,3,1322,661,
  	0,5301,5300,1,0,0,0,5301,5302,1,0,0,0,5302,5331,1,0,0,0,5303,5331,7,82,
  	0,0,5304,5305,5,251,0,0,5305,5331,5,421,0,0,5306,5307,5,536,0,0,5307,
  	5331,5,152,0,0,5308,5312,5,140,0,0,5309,5310,5,603,0,0,5310,5313,5,597,
  	0,0,5311,5313,7,83,0,0,5312,5309,1,0,0,0,5312,5311,1,0,0,0,5312,5313,
  	1,0,0,0,5313,5331,1,0,0,0,5314,5315,5,319,0,0,5315,5331,5,597,0,0,5316,
  	5319,5,489,0,0,5317,5320,5,109,0,0,5318,5320,3,604,302,0,5319,5317,1,
  	0,0,0,5319,5318,1,0,0,0,5320,5331,1,0,0,0,5321,5322,5,536,0,0,5322,5331,
  	5,661,0,0,5323,5325,5,57,0,0,5324,5326,5,512,0,0,5325,5324,1,0,0,0,5325,
  	5326,1,0,0,0,5326,5331,1,0,0,0,5327,5328,4,334,135,0,5328,5329,7,84,0,
  	0,5329,5331,5,684,0,0,5330,5286,1,0,0,0,5330,5299,1,0,0,0,5330,5303,1,
  	0,0,0,5330,5304,1,0,0,0,5330,5306,1,0,0,0,5330,5308,1,0,0,0,5330,5314,
  	1,0,0,0,5330,5316,1,0,0,0,5330,5321,1,0,0,0,5330,5323,1,0,0,0,5330,5327,
  	1,0,0,0,5331,669,1,0,0,0,5332,5335,5,16,0,0,5333,5334,5,28,0,0,5334,5336,
  	5,16,0,0,5335,5333,1,0,0,0,5335,5336,1,0,0,0,5336,5349,1,0,0,0,5337,5340,
  	3,1336,668,0,5338,5339,5,28,0,0,5339,5341,5,16,0,0,5340,5338,1,0,0,0,
  	5340,5341,1,0,0,0,5341,5349,1,0,0,0,5342,5349,3,1380,690,0,5343,5344,
  	4,335,136,0,5344,5345,3,1336,668,0,5345,5346,5,28,0,0,5346,5347,3,1380,
  	690,0,5347,5349,1,0,0,0,5348,5332,1,0,0,0,5348,5337,1,0,0,0,5348,5342,
  	1,0,0,0,5348,5343,1,0,0,0,5349,671,1,0,0,0,5350,5357,3,674,337,0,5351,
  	5353,5,61,0,0,5352,5351,1,0,0,0,5352,5353,1,0,0,0,5353,5354,1,0,0,0,5354,
  	5356,3,674,337,0,5355,5352,1,0,0,0,5356,5359,1,0,0,0,5357,5355,1,0,0,
  	0,5357,5358,1,0,0,0,5358,673,1,0,0,0,5359,5357,1,0,0,0,5360,5361,5,107,
  	0,0,5361,5367,3,1438,719,0,5362,5363,5,293,0,0,5363,5367,3,1438,719,0,
  	5364,5365,5,585,0,0,5365,5367,3,1438,719,0,5366,5360,1,0,0,0,5366,5362,
  	1,0,0,0,5366,5364,1,0,0,0,5367,675,1,0,0,0,5368,5369,5,251,0,0,5369,5382,
  	5,421,0,0,5370,5379,4,338,137,0,5371,5372,5,354,0,0,5372,5380,3,1416,
  	708,0,5373,5374,5,359,0,0,5374,5380,3,1416,708,0,5375,5376,5,353,0,0,
  	5376,5380,3,1416,708,0,5377,5378,5,360,0,0,5378,5380,3,1416,708,0,5379,
  	5371,1,0,0,0,5379,5373,1,0,0,0,5379,5375,1,0,0,0,5379,5377,1,0,0,0,5380,
  	5382,1,0,0,0,5381,5368,1,0,0,0,5381,5370,1,0,0,0,5382,677,1,0,0,0,5383,
  	5384,5,533,0,0,5384,5385,5,684,0,0,5385,5407,3,680,340,0,5386,5387,5,
  	533,0,0,5387,5388,5,684,0,0,5388,5407,7,85,0,0,5389,5390,5,533,0,0,5390,
  	5391,5,168,0,0,5391,5395,5,684,0,0,5392,5396,3,680,340,0,5393,5396,5,
  	399,0,0,5394,5396,5,56,0,0,5395,5392,1,0,0,0,5395,5393,1,0,0,0,5395,5394,
  	1,0,0,0,5396,5397,1,0,0,0,5397,5398,5,616,0,0,5398,5407,3,680,340,0,5399,
  	5400,5,533,0,0,5400,5401,5,684,0,0,5401,5404,5,56,0,0,5402,5403,5,688,
  	0,0,5403,5405,3,680,340,0,5404,5402,1,0,0,0,5404,5405,1,0,0,0,5405,5407,
  	1,0,0,0,5406,5383,1,0,0,0,5406,5386,1,0,0,0,5406,5389,1,0,0,0,5406,5399,
  	1,0,0,0,5407,679,1,0,0,0,5408,5413,3,682,341,0,5409,5410,5,29,0,0,5410,
  	5412,3,682,341,0,5411,5409,1,0,0,0,5412,5415,1,0,0,0,5413,5411,1,0,0,
  	0,5413,5414,1,0,0,0,5414,681,1,0,0,0,5415,5413,1,0,0,0,5416,5422,3,1468,
  	734,0,5417,5420,5,39,0,0,5418,5421,3,1464,732,0,5419,5421,5,850,0,0,5420,
  	5418,1,0,0,0,5420,5419,1,0,0,0,5421,5423,1,0,0,0,5422,5417,1,0,0,0,5422,
  	5423,1,0,0,0,5423,683,1,0,0,0,5424,5426,5,60,0,0,5425,5427,3,1312,656,
  	0,5426,5425,1,0,0,0,5426,5427,1,0,0,0,5427,5428,1,0,0,0,5428,5429,5,600,
  	0,0,5429,5432,3,1382,691,0,5430,5431,4,342,138,0,5431,5433,3,692,346,
  	0,5432,5430,1,0,0,0,5432,5433,1,0,0,0,5433,5468,1,0,0,0,5434,5435,5,106,
  	0,0,5435,5436,5,600,0,0,5436,5440,3,1382,691,0,5437,5439,3,694,347,0,
  	5438,5437,1,0,0,0,5439,5442,1,0,0,0,5440,5438,1,0,0,0,5440,5441,1,0,0,
  	0,5441,5468,1,0,0,0,5442,5440,1,0,0,0,5443,5444,5,105,0,0,5444,5445,5,
  	600,0,0,5445,5447,3,1382,691,0,5446,5448,7,86,0,0,5447,5446,1,0,0,0,5447,
  	5448,1,0,0,0,5448,5468,1,0,0,0,5449,5451,5,418,0,0,5450,5452,3,1312,656,
  	0,5451,5450,1,0,0,0,5451,5452,1,0,0,0,5452,5453,1,0,0,0,5453,5454,5,600,
  	0,0,5454,5468,3,1382,691,0,5455,5457,5,485,0,0,5456,5458,3,1312,656,0,
  	5457,5456,1,0,0,0,5457,5458,1,0,0,0,5458,5459,1,0,0,0,5459,5460,5,600,
  	0,0,5460,5464,3,1382,691,0,5461,5463,3,696,348,0,5462,5461,1,0,0,0,5463,
  	5466,1,0,0,0,5464,5462,1,0,0,0,5464,5465,1,0,0,0,5465,5468,1,0,0,0,5466,
  	5464,1,0,0,0,5467,5424,1,0,0,0,5467,5434,1,0,0,0,5467,5443,1,0,0,0,5467,
  	5449,1,0,0,0,5467,5455,1,0,0,0,5468,685,1,0,0,0,5469,5470,4,343,139,0,
  	5470,5471,7,87,0,0,5471,5472,5,640,0,0,5472,687,1,0,0,0,5473,5475,3,690,
  	345,0,5474,5473,1,0,0,0,5474,5475,1,0,0,0,5475,5477,1,0,0,0,5476,5478,
  	3,686,343,0,5477,5476,1,0,0,0,5477,5478,1,0,0,0,5478,5484,1,0,0,0,5479,
  	5480,4,344,140,0,5480,5481,5,647,0,0,5481,5482,5,154,0,0,5482,5484,3,
  	1436,718,0,5483,5474,1,0,0,0,5483,5479,1,0,0,0,5484,689,1,0,0,0,5485,
  	5486,5,670,0,0,5486,5487,5,3,0,0,5487,5488,5,700,0,0,5488,691,1,0,0,0,
  	5489,5490,5,640,0,0,5490,5491,5,699,0,0,5491,5492,5,413,0,0,5492,5493,
  	3,1406,703,0,5493,5494,3,688,344,0,5494,5500,1,0,0,0,5495,5496,5,187,
  	0,0,5496,5497,5,699,0,0,5497,5498,5,413,0,0,5498,5500,3,1406,703,0,5499,
  	5489,1,0,0,0,5499,5495,1,0,0,0,5500,693,1,0,0,0,5501,5502,5,236,0,0,5502,
  	5505,5,641,0,0,5503,5505,7,88,0,0,5504,5501,1,0,0,0,5504,5503,1,0,0,0,
  	5505,695,1,0,0,0,5506,5507,7,89,0,0,5507,697,1,0,0,0,5508,5520,5,633,
  	0,0,5509,5510,5,440,0,0,5510,5521,3,1394,697,0,5511,5512,5,689,0,0,5512,
  	5517,3,1396,698,0,5513,5514,5,29,0,0,5514,5516,3,1396,698,0,5515,5513,
  	1,0,0,0,5516,5519,1,0,0,0,5517,5515,1,0,0,0,5517,5518,1,0,0,0,5518,5521,
  	1,0,0,0,5519,5517,1,0,0,0,5520,5509,1,0,0,0,5520,5511,1,0,0,0,5521,699,
  	1,0,0,0,5522,5533,5,281,0,0,5523,5524,5,440,0,0,5524,5525,3,1404,702,
  	0,5525,5526,5,546,0,0,5526,5527,3,1436,718,0,5527,5534,1,0,0,0,5528,5529,
  	5,689,0,0,5529,5531,3,1446,723,0,5530,5532,3,708,354,0,5531,5530,1,0,
  	0,0,5531,5532,1,0,0,0,5532,5534,1,0,0,0,5533,5523,1,0,0,0,5533,5528,1,
  	0,0,0,5534,701,1,0,0,0,5535,5536,7,90,0,0,5536,703,1,0,0,0,5537,5540,
  	3,906,453,0,5538,5540,5,413,0,0,5539,5537,1,0,0,0,5539,5538,1,0,0,0,5540,
  	705,1,0,0,0,5541,5542,3,702,351,0,5542,5543,3,990,495,0,5543,5544,3,1474,
  	737,0,5544,5545,3,704,352,0,5545,707,1,0,0,0,5546,5547,4,354,141,0,5547,
  	5548,5,533,0,0,5548,5553,3,706,353,0,5549,5550,5,29,0,0,5550,5552,3,706,
  	353,0,5551,5549,1,0,0,0,5552,5555,1,0,0,0,5553,5551,1,0,0,0,5553,5554,
  	1,0,0,0,5554,709,1,0,0,0,5555,5553,1,0,0,0,5556,5557,5,533,0,0,5557,5558,
  	3,712,356,0,5558,711,1,0,0,0,5559,5560,3,722,361,0,5560,5561,3,720,360,
  	0,5561,5616,1,0,0,0,5562,5563,5,618,0,0,5563,5616,3,714,357,0,5564,5565,
  	3,1476,738,0,5565,5566,3,726,363,0,5566,5616,1,0,0,0,5567,5570,5,436,
  	0,0,5568,5569,5,236,0,0,5569,5571,3,1304,652,0,5570,5568,1,0,0,0,5570,
  	5571,1,0,0,0,5571,5572,1,0,0,0,5572,5599,3,1474,737,0,5573,5575,3,1438,
  	719,0,5574,5576,3,1300,650,0,5575,5574,1,0,0,0,5575,5576,1,0,0,0,5576,
  	5578,1,0,0,0,5577,5579,3,1292,646,0,5578,5577,1,0,0,0,5578,5579,1,0,0,
  	0,5579,5600,1,0,0,0,5580,5582,3,1438,719,0,5581,5583,3,1300,650,0,5582,
  	5581,1,0,0,0,5582,5583,1,0,0,0,5583,5585,1,0,0,0,5584,5586,3,1292,646,
  	0,5585,5584,1,0,0,0,5585,5586,1,0,0,0,5586,5600,1,0,0,0,5587,5588,4,356,
  	142,0,5588,5589,5,412,0,0,5589,5590,5,32,0,0,5590,5591,3,1438,719,0,5591,
  	5592,5,33,0,0,5592,5600,1,0,0,0,5593,5594,4,356,143,0,5594,5595,5,436,
  	0,0,5595,5596,5,32,0,0,5596,5597,3,1438,719,0,5597,5598,5,33,0,0,5598,
  	5600,1,0,0,0,5599,5573,1,0,0,0,5599,5580,1,0,0,0,5599,5587,1,0,0,0,5599,
  	5593,1,0,0,0,5600,5616,1,0,0,0,5601,5602,4,356,144,0,5602,5605,5,436,
  	0,0,5603,5604,5,236,0,0,5604,5606,3,1304,652,0,5605,5603,1,0,0,0,5605,
  	5606,1,0,0,0,5606,5607,1,0,0,0,5607,5608,5,616,0,0,5608,5610,5,759,0,
  	0,5609,5611,3,1300,650,0,5610,5609,1,0,0,0,5610,5611,1,0,0,0,5611,5613,
  	1,0,0,0,5612,5614,3,1292,646,0,5613,5612,1,0,0,0,5613,5614,1,0,0,0,5614,
  	5616,1,0,0,0,5615,5559,1,0,0,0,5615,5562,1,0,0,0,5615,5564,1,0,0,0,5615,
  	5567,1,0,0,0,5615,5601,1,0,0,0,5616,713,1,0,0,0,5617,5619,3,716,358,0,
  	5618,5620,3,718,359,0,5619,5618,1,0,0,0,5619,5620,1,0,0,0,5620,5627,1,
  	0,0,0,5621,5624,3,718,359,0,5622,5623,5,29,0,0,5623,5625,3,716,358,0,
  	5624,5622,1,0,0,0,5624,5625,1,0,0,0,5625,5627,1,0,0,0,5626,5617,1,0,0,
  	0,5626,5621,1,0,0,0,5627,715,1,0,0,0,5628,5629,5,465,0,0,5629,5630,7,
  	41,0,0,5630,717,1,0,0,0,5631,5632,5,292,0,0,5632,5638,5,308,0,0,5633,
  	5634,5,486,0,0,5634,5639,5,465,0,0,5635,5636,5,465,0,0,5636,5639,7,91,
  	0,0,5637,5639,5,527,0,0,5638,5633,1,0,0,0,5638,5635,1,0,0,0,5638,5637,
  	1,0,0,0,5639,719,1,0,0,0,5640,5641,5,29,0,0,5641,5643,3,724,362,0,5642,
  	5640,1,0,0,0,5643,5646,1,0,0,0,5644,5642,1,0,0,0,5644,5645,1,0,0,0,5645,
  	721,1,0,0,0,5646,5644,1,0,0,0,5647,5648,3,990,495,0,5648,5649,3,1474,
  	737,0,5649,5650,3,730,365,0,5650,5678,1,0,0,0,5651,5678,3,1258,629,0,
  	5652,5653,3,982,491,0,5653,5654,3,1474,737,0,5654,5655,3,906,453,0,5655,
  	5678,1,0,0,0,5656,5657,5,39,0,0,5657,5659,5,39,0,0,5658,5660,3,1480,740,
  	0,5659,5658,1,0,0,0,5659,5660,1,0,0,0,5660,5661,1,0,0,0,5661,5662,3,990,
  	495,0,5662,5663,3,1474,737,0,5663,5664,3,730,365,0,5664,5678,1,0,0,0,
  	5665,5675,5,387,0,0,5666,5667,3,1474,737,0,5667,5668,3,906,453,0,5668,
  	5676,1,0,0,0,5669,5671,3,1186,593,0,5670,5672,3,1246,623,0,5671,5670,
  	1,0,0,0,5671,5672,1,0,0,0,5672,5676,1,0,0,0,5673,5674,4,361,145,0,5674,
  	5676,5,168,0,0,5675,5666,1,0,0,0,5675,5669,1,0,0,0,5675,5673,1,0,0,0,
  	5676,5678,1,0,0,0,5677,5647,1,0,0,0,5677,5651,1,0,0,0,5677,5652,1,0,0,
  	0,5677,5656,1,0,0,0,5677,5665,1,0,0,0,5678,723,1,0,0,0,5679,5680,3,1476,
  	738,0,5680,5681,3,990,495,0,5681,5682,3,1474,737,0,5682,5683,3,730,365,
  	0,5683,5686,1,0,0,0,5684,5686,3,722,361,0,5685,5679,1,0,0,0,5685,5684,
  	1,0,0,0,5686,725,1,0,0,0,5687,5688,3,728,364,0,5688,5689,3,720,360,0,
  	5689,5693,1,0,0,0,5690,5691,5,618,0,0,5691,5693,3,714,357,0,5692,5687,
  	1,0,0,0,5692,5690,1,0,0,0,5693,727,1,0,0,0,5694,5695,3,990,495,0,5695,
  	5696,3,1474,737,0,5696,5697,3,730,365,0,5697,729,1,0,0,0,5698,5708,3,
  	906,453,0,5699,5708,5,168,0,0,5700,5708,5,413,0,0,5701,5708,5,56,0,0,
  	5702,5708,5,77,0,0,5703,5704,4,365,146,0,5704,5708,5,516,0,0,5705,5706,
  	4,365,147,0,5706,5708,5,735,0,0,5707,5698,1,0,0,0,5707,5699,1,0,0,0,5707,
  	5700,1,0,0,0,5707,5701,1,0,0,0,5707,5702,1,0,0,0,5707,5703,1,0,0,0,5707,
  	5705,1,0,0,0,5708,731,1,0,0,0,5709,5710,5,536,0,0,5710,5712,5,152,0,0,
  	5711,5713,3,1308,654,0,5712,5711,1,0,0,0,5712,5713,1,0,0,0,5713,733,1,
  	0,0,0,5714,5716,5,536,0,0,5715,5717,3,824,412,0,5716,5715,1,0,0,0,5716,
  	5717,1,0,0,0,5717,5718,1,0,0,0,5718,5720,5,597,0,0,5719,5721,3,830,415,
  	0,5720,5719,1,0,0,0,5720,5721,1,0,0,0,5721,5723,1,0,0,0,5722,5724,3,1308,
  	654,0,5723,5722,1,0,0,0,5723,5724,1,0,0,0,5724,735,1,0,0,0,5725,5727,
  	5,536,0,0,5726,5728,5,240,0,0,5727,5726,1,0,0,0,5727,5728,1,0,0,0,5728,
  	5729,1,0,0,0,5729,5731,5,619,0,0,5730,5732,3,830,415,0,5731,5730,1,0,
  	0,0,5731,5732,1,0,0,0,5732,5734,1,0,0,0,5733,5735,3,1308,654,0,5734,5733,
  	1,0,0,0,5734,5735,1,0,0,0,5735,737,1,0,0,0,5736,5737,5,536,0,0,5737,5739,
  	5,208,0,0,5738,5740,3,830,415,0,5739,5738,1,0,0,0,5739,5740,1,0,0,0,5740,
  	5742,1,0,0,0,5741,5743,3,1308,654,0,5742,5741,1,0,0,0,5742,5743,1,0,0,
  	0,5743,739,1,0,0,0,5744,5745,5,536,0,0,5745,5746,5,600,0,0,5746,5748,
  	5,573,0,0,5747,5749,3,830,415,0,5748,5747,1,0,0,0,5748,5749,1,0,0,0,5749,
  	5751,1,0,0,0,5750,5752,3,1308,654,0,5751,5750,1,0,0,0,5751,5752,1,0,0,
  	0,5752,741,1,0,0,0,5753,5754,5,536,0,0,5754,5755,5,417,0,0,5755,5757,
  	5,597,0,0,5756,5758,3,830,415,0,5757,5756,1,0,0,0,5757,5758,1,0,0,0,5758,
  	5760,1,0,0,0,5759,5761,3,1308,654,0,5760,5759,1,0,0,0,5760,5761,1,0,0,
  	0,5761,743,1,0,0,0,5762,5763,4,372,148,0,5763,5764,5,536,0,0,5764,5765,
  	5,824,0,0,5765,5766,3,2,1,0,5766,745,1,0,0,0,5767,5768,5,536,0,0,5768,
  	5769,5,438,0,0,5769,747,1,0,0,0,5770,5771,5,536,0,0,5771,5772,5,202,0,
  	0,5772,5773,3,826,413,0,5773,5774,5,321,0,0,5774,749,1,0,0,0,5775,5776,
  	5,536,0,0,5776,5777,5,202,0,0,5777,5778,3,826,413,0,5778,5779,5,385,0,
  	0,5779,751,1,0,0,0,5780,5781,5,536,0,0,5781,5782,5,202,0,0,5782,5783,
  	3,826,413,0,5783,5784,5,573,0,0,5784,753,1,0,0,0,5785,5787,5,536,0,0,
  	5786,5788,3,824,412,0,5787,5786,1,0,0,0,5787,5788,1,0,0,0,5788,5789,1,
  	0,0,0,5789,5790,5,115,0,0,5790,5791,7,92,0,0,5791,5793,3,1380,690,0,5792,
  	5794,3,830,415,0,5793,5792,1,0,0,0,5793,5794,1,0,0,0,5794,5796,1,0,0,
  	0,5795,5797,3,1308,654,0,5796,5795,1,0,0,0,5796,5797,1,0,0,0,5797,755,
  	1,0,0,0,5798,5799,5,536,0,0,5799,5800,7,44,0,0,5800,5801,5,321,0,0,5801,
  	757,1,0,0,0,5802,5803,5,536,0,0,5803,5804,5,77,0,0,5804,5805,5,825,0,
  	0,5805,5806,5,573,0,0,5806,759,1,0,0,0,5807,5811,5,536,0,0,5808,5809,
  	5,541,0,0,5809,5812,5,261,0,0,5810,5812,5,780,0,0,5811,5808,1,0,0,0,5811,
  	5810,1,0,0,0,5812,761,1,0,0,0,5813,5814,5,536,0,0,5814,5815,5,78,0,0,
  	5815,5818,5,208,0,0,5816,5817,5,286,0,0,5817,5819,3,1438,719,0,5818,5816,
  	1,0,0,0,5818,5819,1,0,0,0,5819,5822,1,0,0,0,5820,5821,5,239,0,0,5821,
  	5823,3,1420,710,0,5822,5820,1,0,0,0,5822,5823,1,0,0,0,5823,5825,1,0,0,
  	0,5824,5826,3,314,157,0,5825,5824,1,0,0,0,5825,5826,1,0,0,0,5826,5828,
  	1,0,0,0,5827,5829,3,1028,514,0,5828,5827,1,0,0,0,5828,5829,1,0,0,0,5829,
  	763,1,0,0,0,5830,5831,5,536,0,0,5831,5832,5,476,0,0,5832,5835,5,208,0,
  	0,5833,5834,5,286,0,0,5834,5836,3,1438,719,0,5835,5833,1,0,0,0,5835,5836,
  	1,0,0,0,5836,5839,1,0,0,0,5837,5838,5,239,0,0,5838,5840,3,1420,710,0,
  	5839,5837,1,0,0,0,5839,5840,1,0,0,0,5840,5842,1,0,0,0,5841,5843,3,314,
  	157,0,5842,5841,1,0,0,0,5842,5843,1,0,0,0,5843,5845,1,0,0,0,5844,5846,
  	3,1028,514,0,5845,5844,1,0,0,0,5845,5846,1,0,0,0,5846,765,1,0,0,0,5847,
  	5850,5,536,0,0,5848,5849,4,383,149,0,5849,5851,5,219,0,0,5850,5848,1,
  	0,0,0,5850,5851,1,0,0,0,5851,5852,1,0,0,0,5852,5853,7,93,0,0,5853,5854,
  	3,828,414,0,5854,5856,3,1380,690,0,5855,5857,3,830,415,0,5856,5855,1,
  	0,0,0,5856,5857,1,0,0,0,5857,5859,1,0,0,0,5858,5860,3,390,195,0,5859,
  	5858,1,0,0,0,5859,5860,1,0,0,0,5860,767,1,0,0,0,5861,5863,5,536,0,0,5862,
  	5864,5,579,0,0,5863,5862,1,0,0,0,5863,5864,1,0,0,0,5864,5865,1,0,0,0,
  	5865,5866,5,201,0,0,5866,769,1,0,0,0,5867,5868,5,536,0,0,5868,5869,5,
  	138,0,0,5869,5870,5,32,0,0,5870,5871,5,16,0,0,5871,5872,5,33,0,0,5872,
  	5873,5,664,0,0,5873,771,1,0,0,0,5874,5875,5,536,0,0,5875,5876,5,138,0,
  	0,5876,5877,5,32,0,0,5877,5878,5,16,0,0,5878,5879,5,33,0,0,5879,5880,
  	5,205,0,0,5880,773,1,0,0,0,5881,5882,5,536,0,0,5882,5884,5,664,0,0,5883,
  	5885,3,314,157,0,5884,5883,1,0,0,0,5884,5885,1,0,0,0,5885,775,1,0,0,0,
  	5886,5887,5,536,0,0,5887,5889,5,205,0,0,5888,5890,3,314,157,0,5889,5888,
  	1,0,0,0,5889,5890,1,0,0,0,5890,777,1,0,0,0,5891,5892,5,536,0,0,5892,5893,
  	5,456,0,0,5893,779,1,0,0,0,5894,5895,5,536,0,0,5895,5897,5,455,0,0,5896,
  	5898,3,832,416,0,5897,5896,1,0,0,0,5897,5898,1,0,0,0,5898,5902,1,0,0,
  	0,5899,5900,5,236,0,0,5900,5901,5,460,0,0,5901,5903,5,3,0,0,5902,5899,
  	1,0,0,0,5902,5903,1,0,0,0,5903,5905,1,0,0,0,5904,5906,3,314,157,0,5905,
  	5904,1,0,0,0,5905,5906,1,0,0,0,5906,781,1,0,0,0,5907,5909,5,536,0,0,5908,
  	5910,3,1476,738,0,5909,5908,1,0,0,0,5909,5910,1,0,0,0,5910,5911,1,0,0,
  	0,5911,5913,5,573,0,0,5912,5914,3,1308,654,0,5913,5912,1,0,0,0,5913,5914,
  	1,0,0,0,5914,783,1,0,0,0,5915,5917,5,536,0,0,5916,5918,5,240,0,0,5917,
  	5916,1,0,0,0,5917,5918,1,0,0,0,5918,5919,1,0,0,0,5919,5920,5,454,0,0,
  	5920,785,1,0,0,0,5921,5923,5,536,0,0,5922,5924,3,1476,738,0,5923,5922,
  	1,0,0,0,5923,5924,1,0,0,0,5924,5925,1,0,0,0,5925,5927,5,656,0,0,5926,
  	5928,3,1308,654,0,5927,5926,1,0,0,0,5927,5928,1,0,0,0,5928,787,1,0,0,
  	0,5929,5930,5,536,0,0,5930,5932,3,1004,502,0,5931,5933,3,1308,654,0,5932,
  	5931,1,0,0,0,5932,5933,1,0,0,0,5933,789,1,0,0,0,5934,5935,5,536,0,0,5935,
  	5937,5,114,0,0,5936,5938,3,1308,654,0,5937,5936,1,0,0,0,5937,5938,1,0,
  	0,0,5938,791,1,0,0,0,5939,5940,5,536,0,0,5940,5941,5,451,0,0,5941,793,
  	1,0,0,0,5942,5943,5,536,0,0,5943,5950,5,252,0,0,5944,5945,5,236,0,0,5945,
  	5948,3,1304,652,0,5946,5947,5,647,0,0,5947,5949,3,1268,634,0,5948,5946,
  	1,0,0,0,5948,5949,1,0,0,0,5949,5951,1,0,0,0,5950,5944,1,0,0,0,5950,5951,
  	1,0,0,0,5951,795,1,0,0,0,5952,5953,5,536,0,0,5953,5954,5,140,0,0,5954,
  	5956,5,151,0,0,5955,5957,3,1238,619,0,5956,5955,1,0,0,0,5956,5957,1,0,
  	0,0,5957,5958,1,0,0,0,5958,5959,3,1336,668,0,5959,797,1,0,0,0,5960,5961,
  	5,536,0,0,5961,5962,5,140,0,0,5962,5963,5,600,0,0,5963,5964,3,1380,690,
  	0,5964,799,1,0,0,0,5965,5966,5,536,0,0,5966,5967,5,140,0,0,5967,5968,
  	5,661,0,0,5968,5969,3,1352,676,0,5969,801,1,0,0,0,5970,5971,5,536,0,0,
  	5971,5972,5,348,0,0,5972,5973,5,573,0,0,5973,803,1,0,0,0,5974,5975,5,
  	536,0,0,5975,5976,3,604,302,0,5976,5979,5,573,0,0,5977,5978,4,402,150,
  	0,5978,5980,5,400,0,0,5979,5977,1,0,0,0,5979,5980,1,0,0,0,5980,5982,1,
  	0,0,0,5981,5983,3,1028,514,0,5982,5981,1,0,0,0,5982,5983,1,0,0,0,5983,
  	805,1,0,0,0,5984,5985,5,536,0,0,5985,5986,5,140,0,0,5986,5987,5,452,0,
  	0,5987,5988,3,1340,670,0,5988,807,1,0,0,0,5989,5990,5,536,0,0,5990,5991,
  	5,140,0,0,5991,5992,5,242,0,0,5992,5993,3,1344,672,0,5993,809,1,0,0,0,
  	5994,5995,5,536,0,0,5995,5996,5,140,0,0,5996,5997,5,620,0,0,5997,5998,
  	3,1348,674,0,5998,811,1,0,0,0,5999,6000,5,536,0,0,6000,6001,5,140,0,0,
  	6001,6002,5,452,0,0,6002,6004,5,573,0,0,6003,6005,3,1308,654,0,6004,6003,
  	1,0,0,0,6004,6005,1,0,0,0,6005,813,1,0,0,0,6006,6007,5,536,0,0,6007,6008,
  	5,140,0,0,6008,6009,5,242,0,0,6009,6011,5,573,0,0,6010,6012,3,1308,654,
  	0,6011,6010,1,0,0,0,6011,6012,1,0,0,0,6012,815,1,0,0,0,6013,6014,5,536,
  	0,0,6014,6015,5,140,0,0,6015,6016,5,452,0,0,6016,6017,5,112,0,0,6017,
  	6018,3,1340,670,0,6018,817,1,0,0,0,6019,6020,5,536,0,0,6020,6021,5,140,
  	0,0,6021,6022,5,242,0,0,6022,6023,5,112,0,0,6023,6024,3,1344,672,0,6024,
  	819,1,0,0,0,6025,6026,5,536,0,0,6026,6027,5,140,0,0,6027,6028,5,209,0,
  	0,6028,6029,3,1364,682,0,6029,821,1,0,0,0,6030,6031,5,536,0,0,6031,6032,
  	5,140,0,0,6032,6033,5,644,0,0,6033,6034,3,1304,652,0,6034,823,1,0,0,0,
  	6035,6042,5,240,0,0,6036,6037,4,412,151,0,6037,6039,5,219,0,0,6038,6040,
  	5,240,0,0,6039,6038,1,0,0,0,6039,6040,1,0,0,0,6040,6042,1,0,0,0,6041,
  	6035,1,0,0,0,6041,6036,1,0,0,0,6042,825,1,0,0,0,6043,6046,3,1372,686,
  	0,6044,6046,5,56,0,0,6045,6043,1,0,0,0,6045,6044,1,0,0,0,6046,827,1,0,
  	0,0,6047,6048,7,92,0,0,6048,829,1,0,0,0,6049,6050,3,828,414,0,6050,6051,
  	3,1404,702,0,6051,831,1,0,0,0,6052,6057,3,834,417,0,6053,6054,5,29,0,
  	0,6054,6056,3,834,417,0,6055,6053,1,0,0,0,6056,6059,1,0,0,0,6057,6055,
  	1,0,0,0,6057,6058,1,0,0,0,6058,833,1,0,0,0,6059,6057,1,0,0,0,6060,6061,
  	5,85,0,0,6061,6068,5,289,0,0,6062,6063,5,135,0,0,6063,6068,5,594,0,0,
  	6064,6065,5,430,0,0,6065,6068,5,224,0,0,6066,6068,7,94,0,0,6067,6060,
  	1,0,0,0,6067,6062,1,0,0,0,6067,6064,1,0,0,0,6067,6066,1,0,0,0,6068,835,
  	1,0,0,0,6069,6070,5,78,0,0,6070,6107,3,1442,721,0,6071,6072,5,92,0,0,
  	6072,6073,5,272,0,0,6073,6074,3,838,419,0,6074,6077,5,286,0,0,6075,6078,
  	3,1404,702,0,6076,6078,5,168,0,0,6077,6075,1,0,0,0,6077,6076,1,0,0,0,
  	6078,6107,1,0,0,0,6079,6081,5,232,0,0,6080,6082,3,1312,656,0,6081,6080,
  	1,0,0,0,6081,6082,1,0,0,0,6082,6092,1,0,0,0,6083,6093,3,856,428,0,6084,
  	6089,3,852,426,0,6085,6086,5,29,0,0,6086,6088,3,852,426,0,6087,6085,1,
  	0,0,0,6088,6091,1,0,0,0,6089,6087,1,0,0,0,6089,6090,1,0,0,0,6090,6093,
  	1,0,0,0,6091,6089,1,0,0,0,6092,6083,1,0,0,0,6092,6084,1,0,0,0,6093,6107,
  	1,0,0,0,6094,6096,5,300,0,0,6095,6097,7,95,0,0,6096,6095,1,0,0,0,6096,
  	6097,1,0,0,0,6097,6098,1,0,0,0,6098,6107,3,906,453,0,6099,6100,5,315,
  	0,0,6100,6101,5,272,0,0,6101,6102,5,283,0,0,6102,6103,5,92,0,0,6103,6107,
  	3,860,430,0,6104,6105,4,418,152,0,6105,6107,5,537,0,0,6106,6069,1,0,0,
  	0,6106,6071,1,0,0,0,6106,6079,1,0,0,0,6106,6094,1,0,0,0,6106,6099,1,0,
  	0,0,6106,6104,1,0,0,0,6107,837,1,0,0,0,6108,6111,3,840,420,0,6109,6111,
  	3,844,422,0,6110,6108,1,0,0,0,6110,6109,1,0,0,0,6111,839,1,0,0,0,6112,
  	6117,3,842,421,0,6113,6114,5,29,0,0,6114,6116,3,842,421,0,6115,6113,1,
  	0,0,0,6116,6119,1,0,0,0,6117,6115,1,0,0,0,6117,6118,1,0,0,0,6118,841,
  	1,0,0,0,6119,6117,1,0,0,0,6120,6122,3,1380,690,0,6121,6123,3,846,423,
  	0,6122,6121,1,0,0,0,6122,6123,1,0,0,0,6123,843,1,0,0,0,6124,6125,3,1380,
  	690,0,6125,6126,5,435,0,0,6126,6127,5,32,0,0,6127,6128,3,54,27,0,6128,
  	6130,5,33,0,0,6129,6131,3,846,423,0,6130,6129,1,0,0,0,6130,6131,1,0,0,
  	0,6131,845,1,0,0,0,6132,6133,3,440,220,0,6133,6135,5,32,0,0,6134,6136,
  	3,850,425,0,6135,6134,1,0,0,0,6135,6136,1,0,0,0,6136,6137,1,0,0,0,6137,
  	6138,5,33,0,0,6138,847,1,0,0,0,6139,6142,3,1404,702,0,6140,6142,5,450,
  	0,0,6141,6139,1,0,0,0,6141,6140,1,0,0,0,6142,849,1,0,0,0,6143,6148,3,
  	848,424,0,6144,6145,5,29,0,0,6145,6147,3,848,424,0,6146,6144,1,0,0,0,
  	6147,6150,1,0,0,0,6148,6146,1,0,0,0,6148,6149,1,0,0,0,6149,851,1,0,0,
  	0,6150,6148,1,0,0,0,6151,6167,7,96,0,0,6152,6154,3,854,427,0,6153,6152,
  	1,0,0,0,6153,6154,1,0,0,0,6154,6155,1,0,0,0,6155,6167,5,321,0,0,6156,
  	6157,5,475,0,0,6157,6159,5,321,0,0,6158,6160,3,1028,514,0,6159,6158,1,
  	0,0,0,6159,6160,1,0,0,0,6160,6167,1,0,0,0,6161,6162,4,426,153,0,6162,
  	6163,5,460,0,0,6163,6167,5,92,0,0,6164,6165,4,426,154,0,6165,6167,5,419,
  	0,0,6166,6151,1,0,0,0,6166,6153,1,0,0,0,6166,6156,1,0,0,0,6166,6161,1,
  	0,0,0,6166,6164,1,0,0,0,6167,853,1,0,0,0,6168,6169,7,97,0,0,6169,855,
  	1,0,0,0,6170,6178,7,17,0,0,6171,6172,5,670,0,0,6172,6173,5,465,0,0,6173,
  	6179,5,319,0,0,6174,6176,3,1406,703,0,6175,6177,3,858,429,0,6176,6175,
  	1,0,0,0,6176,6177,1,0,0,0,6177,6179,1,0,0,0,6178,6171,1,0,0,0,6178,6174,
  	1,0,0,0,6178,6179,1,0,0,0,6179,857,1,0,0,0,6180,6181,5,236,0,0,6181,6186,
  	5,218,0,0,6182,6183,5,670,0,0,6183,6184,5,465,0,0,6184,6186,5,319,0,0,
  	6185,6180,1,0,0,0,6185,6182,1,0,0,0,6186,859,1,0,0,0,6187,6188,3,1380,
  	690,0,6188,6190,3,866,433,0,6189,6191,3,846,423,0,6190,6189,1,0,0,0,6190,
  	6191,1,0,0,0,6191,6194,1,0,0,0,6192,6193,5,268,0,0,6193,6195,5,304,0,
  	0,6194,6192,1,0,0,0,6194,6195,1,0,0,0,6195,6198,1,0,0,0,6196,6198,3,862,
  	431,0,6197,6187,1,0,0,0,6197,6196,1,0,0,0,6198,861,1,0,0,0,6199,6204,
  	3,864,432,0,6200,6201,5,29,0,0,6201,6203,3,864,432,0,6202,6200,1,0,0,
  	0,6203,6206,1,0,0,0,6204,6202,1,0,0,0,6204,6205,1,0,0,0,6205,863,1,0,
  	0,0,6206,6204,1,0,0,0,6207,6209,3,1380,690,0,6208,6210,3,846,423,0,6209,
  	6208,1,0,0,0,6209,6210,1,0,0,0,6210,6213,1,0,0,0,6211,6212,5,268,0,0,
  	6212,6214,5,304,0,0,6213,6211,1,0,0,0,6213,6214,1,0,0,0,6214,865,1,0,
  	0,0,6215,6216,5,435,0,0,6216,6217,5,32,0,0,6217,6218,3,54,27,0,6218,6219,
  	5,33,0,0,6219,867,1,0,0,0,6220,6225,3,870,435,0,6221,6225,3,880,440,0,
  	6222,6225,3,882,441,0,6223,6225,3,886,443,0,6224,6220,1,0,0,0,6224,6221,
  	1,0,0,0,6224,6222,1,0,0,0,6224,6223,1,0,0,0,6225,869,1,0,0,0,6226,6227,
  	5,140,0,0,6227,6228,5,734,0,0,6228,6229,5,253,0,0,6229,6230,3,1404,702,
  	0,6230,6232,5,625,0,0,6231,6233,3,1474,737,0,6232,6231,1,0,0,0,6232,6233,
  	1,0,0,0,6233,6234,1,0,0,0,6234,6236,7,98,0,0,6235,6237,3,872,436,0,6236,
  	6235,1,0,0,0,6236,6237,1,0,0,0,6237,6239,1,0,0,0,6238,6240,3,876,438,
  	0,6239,6238,1,0,0,0,6239,6240,1,0,0,0,6240,6242,1,0,0,0,6241,6243,3,878,
  	439,0,6242,6241,1,0,0,0,6242,6243,1,0,0,0,6243,871,1,0,0,0,6244,6246,
  	5,736,0,0,6245,6247,3,1474,737,0,6246,6245,1,0,0,0,6246,6247,1,0,0,0,
  	6247,6248,1,0,0,0,6248,6255,3,874,437,0,6249,6251,5,29,0,0,6250,6249,
  	1,0,0,0,6250,6251,1,0,0,0,6251,6252,1,0,0,0,6252,6254,3,874,437,0,6253,
  	6250,1,0,0,0,6254,6257,1,0,0,0,6255,6253,1,0,0,0,6255,6256,1,0,0,0,6256,
  	873,1,0,0,0,6257,6255,1,0,0,0,6258,6261,5,3,0,0,6259,6260,5,15,0,0,6260,
  	6262,5,3,0,0,6261,6259,1,0,0,0,6261,6262,1,0,0,0,6262,875,1,0,0,0,6263,
  	6265,5,733,0,0,6264,6266,3,1474,737,0,6265,6264,1,0,0,0,6265,6266,1,0,
  	0,0,6266,6267,1,0,0,0,6267,6268,5,3,0,0,6268,877,1,0,0,0,6269,6270,7,
  	7,0,0,6270,879,1,0,0,0,6271,6272,5,57,0,0,6272,6273,5,734,0,0,6273,6274,
  	5,253,0,0,6274,6276,3,1398,699,0,6275,6277,3,872,436,0,6276,6275,1,0,
  	0,0,6276,6277,1,0,0,0,6277,6279,1,0,0,0,6278,6280,3,876,438,0,6279,6278,
  	1,0,0,0,6279,6280,1,0,0,0,6280,6282,1,0,0,0,6281,6283,3,878,439,0,6282,
  	6281,1,0,0,0,6282,6283,1,0,0,0,6283,6285,1,0,0,0,6284,6286,5,234,0,0,
  	6285,6284,1,0,0,0,6285,6286,1,0,0,0,6286,881,1,0,0,0,6287,6288,5,533,
  	0,0,6288,6289,5,734,0,0,6289,6290,5,253,0,0,6290,6293,3,1404,702,0,6291,
  	6292,5,236,0,0,6292,6294,3,884,442,0,6293,6291,1,0,0,0,6293,6294,1,0,
  	0,0,6294,883,1,0,0,0,6295,6302,3,1418,709,0,6296,6298,5,29,0,0,6297,6296,
  	1,0,0,0,6297,6298,1,0,0,0,6298,6299,1,0,0,0,6299,6301,3,1418,709,0,6300,
  	6297,1,0,0,0,6301,6304,1,0,0,0,6302,6300,1,0,0,0,6302,6303,1,0,0,0,6303,
  	885,1,0,0,0,6304,6302,1,0,0,0,6305,6306,5,187,0,0,6306,6307,5,734,0,0,
  	6307,6308,5,253,0,0,6308,6310,3,1398,699,0,6309,6311,5,234,0,0,6310,6309,
  	1,0,0,0,6310,6311,1,0,0,0,6311,887,1,0,0,0,6312,6319,3,890,445,0,6313,
  	6319,3,892,446,0,6314,6319,3,900,450,0,6315,6319,3,902,451,0,6316,6317,
  	4,444,155,0,6317,6319,3,904,452,0,6318,6312,1,0,0,0,6318,6313,1,0,0,0,
  	6318,6314,1,0,0,0,6318,6315,1,0,0,0,6318,6316,1,0,0,0,6319,889,1,0,0,
  	0,6320,6321,7,99,0,0,6321,6324,3,1380,690,0,6322,6325,3,1438,719,0,6323,
  	6325,3,1324,662,0,6324,6322,1,0,0,0,6324,6323,1,0,0,0,6324,6325,1,0,0,
  	0,6325,891,1,0,0,0,6326,6328,7,99,0,0,6327,6329,3,894,447,0,6328,6327,
  	1,0,0,0,6328,6329,1,0,0,0,6329,6334,1,0,0,0,6330,6331,4,446,156,0,6331,
  	6332,5,236,0,0,6332,6333,5,151,0,0,6333,6335,3,1464,732,0,6334,6330,1,
  	0,0,0,6334,6335,1,0,0,0,6335,6336,1,0,0,0,6336,6337,3,896,448,0,6337,
  	893,1,0,0,0,6338,6339,5,237,0,0,6339,6340,5,6,0,0,6340,6343,3,1464,732,
  	0,6341,6342,4,447,157,0,6342,6344,3,898,449,0,6343,6341,1,0,0,0,6343,
  	6344,1,0,0,0,6344,6357,1,0,0,0,6345,6346,4,447,158,0,6346,6357,5,219,
  	0,0,6347,6348,4,447,159,0,6348,6357,5,434,0,0,6349,6350,4,447,160,0,6350,
  	6357,5,60,0,0,6351,6352,4,447,161,0,6352,6353,5,60,0,0,6353,6354,5,237,
  	0,0,6354,6355,5,6,0,0,6355,6357,3,1464,732,0,6356,6338,1,0,0,0,6356,6345,
  	1,0,0,0,6356,6347,1,0,0,0,6356,6349,1,0,0,0,6356,6351,1,0,0,0,6357,895,
  	1,0,0,0,6358,6367,3,296,148,0,6359,6367,3,234,117,0,6360,6367,3,246,123,
  	0,6361,6367,3,294,147,0,6362,6367,3,450,225,0,6363,6364,5,236,0,0,6364,
  	6365,5,128,0,0,6365,6367,3,1418,709,0,6366,6358,1,0,0,0,6366,6359,1,0,
  	0,0,6366,6360,1,0,0,0,6366,6361,1,0,0,0,6366,6362,1,0,0,0,6366,6363,1,
  	0,0,0,6367,897,1,0,0,0,6368,6369,5,283,0,0,6369,6370,5,39,0,0,6370,6371,
  	3,1464,732,0,6371,899,1,0,0,0,6372,6373,5,258,0,0,6373,6374,3,1464,732,
  	0,6374,901,1,0,0,0,6375,6376,5,646,0,0,6376,6377,3,1336,668,0,6377,903,
  	1,0,0,0,6378,6379,5,739,0,0,6379,905,1,0,0,0,6380,6381,6,453,-1,0,6381,
  	6387,3,908,454,0,6382,6384,5,291,0,0,6383,6385,3,1006,503,0,6384,6383,
  	1,0,0,0,6384,6385,1,0,0,0,6385,6386,1,0,0,0,6386,6388,7,100,0,0,6387,
  	6382,1,0,0,0,6387,6388,1,0,0,0,6388,6392,1,0,0,0,6389,6390,5,401,0,0,
  	6390,6392,3,906,453,4,6391,6380,1,0,0,0,6391,6389,1,0,0,0,6392,6404,1,
  	0,0,0,6393,6394,10,3,0,0,6394,6395,7,101,0,0,6395,6403,3,906,453,4,6396,
  	6397,10,2,0,0,6397,6398,5,679,0,0,6398,6403,3,906,453,3,6399,6400,10,
  	1,0,0,6400,6401,7,102,0,0,6401,6403,3,906,453,2,6402,6393,1,0,0,0,6402,
  	6396,1,0,0,0,6402,6399,1,0,0,0,6403,6406,1,0,0,0,6404,6402,1,0,0,0,6404,
  	6405,1,0,0,0,6405,907,1,0,0,0,6406,6404,1,0,0,0,6407,6408,6,454,-1,0,
  	6408,6409,3,912,456,0,6409,6427,1,0,0,0,6410,6411,10,3,0,0,6411,6413,
  	5,291,0,0,6412,6414,3,1006,503,0,6413,6412,1,0,0,0,6413,6414,1,0,0,0,
  	6414,6415,1,0,0,0,6415,6426,5,406,0,0,6416,6417,10,2,0,0,6417,6418,3,
  	910,455,0,6418,6419,3,912,456,0,6419,6426,1,0,0,0,6420,6421,10,1,0,0,
  	6421,6422,3,910,455,0,6422,6423,7,103,0,0,6423,6424,3,310,155,0,6424,
  	6426,1,0,0,0,6425,6410,1,0,0,0,6425,6416,1,0,0,0,6425,6420,1,0,0,0,6426,
  	6429,1,0,0,0,6427,6425,1,0,0,0,6427,6428,1,0,0,0,6428,909,1,0,0,0,6429,
  	6427,1,0,0,0,6430,6431,7,104,0,0,6431,911,1,0,0,0,6432,6446,3,916,458,
  	0,6433,6435,3,1006,503,0,6434,6433,1,0,0,0,6434,6435,1,0,0,0,6435,6436,
  	1,0,0,0,6436,6447,3,914,457,0,6437,6438,4,456,168,0,6438,6440,5,758,0,
  	0,6439,6441,5,693,0,0,6440,6439,1,0,0,0,6440,6441,1,0,0,0,6441,6442,1,
  	0,0,0,6442,6447,3,1018,509,0,6443,6444,5,547,0,0,6444,6445,5,309,0,0,
  	6445,6447,3,916,458,0,6446,6434,1,0,0,0,6446,6437,1,0,0,0,6446,6443,1,
  	0,0,0,6446,6447,1,0,0,0,6447,913,1,0,0,0,6448,6454,5,286,0,0,6449,6455,
  	3,310,155,0,6450,6451,5,32,0,0,6451,6452,3,1002,501,0,6452,6453,5,33,
  	0,0,6453,6455,1,0,0,0,6454,6449,1,0,0,0,6454,6450,1,0,0,0,6455,6470,1,
  	0,0,0,6456,6457,5,75,0,0,6457,6458,3,916,458,0,6458,6459,5,61,0,0,6459,
  	6460,3,912,456,0,6460,6470,1,0,0,0,6461,6462,5,309,0,0,6462,6465,3,918,
  	459,0,6463,6464,5,207,0,0,6464,6466,3,918,459,0,6465,6463,1,0,0,0,6465,
  	6466,1,0,0,0,6466,6470,1,0,0,0,6467,6468,5,474,0,0,6468,6470,3,916,458,
  	0,6469,6448,1,0,0,0,6469,6456,1,0,0,0,6469,6461,1,0,0,0,6469,6467,1,0,
  	0,0,6470,915,1,0,0,0,6471,6472,6,458,-1,0,6472,6473,3,918,459,0,6473,
  	6500,1,0,0,0,6474,6475,10,7,0,0,6475,6476,5,25,0,0,6476,6499,3,916,458,
  	8,6477,6478,10,6,0,0,6478,6479,7,105,0,0,6479,6499,3,916,458,7,6480,6481,
  	10,5,0,0,6481,6482,7,106,0,0,6482,6499,3,916,458,6,6483,6484,10,3,0,0,
  	6484,6485,7,107,0,0,6485,6499,3,916,458,4,6486,6487,10,2,0,0,6487,6488,
  	5,24,0,0,6488,6499,3,916,458,3,6489,6490,10,1,0,0,6490,6491,5,27,0,0,
  	6491,6499,3,916,458,2,6492,6493,10,4,0,0,6493,6494,7,106,0,0,6494,6495,
  	5,282,0,0,6495,6496,3,906,453,0,6496,6497,3,1010,505,0,6497,6499,1,0,
  	0,0,6498,6474,1,0,0,0,6498,6477,1,0,0,0,6498,6480,1,0,0,0,6498,6483,1,
  	0,0,0,6498,6486,1,0,0,0,6498,6489,1,0,0,0,6498,6492,1,0,0,0,6499,6502,
  	1,0,0,0,6500,6498,1,0,0,0,6500,6501,1,0,0,0,6501,917,1,0,0,0,6502,6500,
  	1,0,0,0,6503,6504,6,459,-1,0,6504,6506,3,1324,662,0,6505,6507,3,922,461,
  	0,6506,6505,1,0,0,0,6506,6507,1,0,0,0,6507,6629,1,0,0,0,6508,6629,3,956,
  	478,0,6509,6629,3,976,488,0,6510,6629,3,1430,715,0,6511,6629,5,42,0,0,
  	6512,6629,3,988,494,0,6513,6629,3,986,493,0,6514,6629,3,924,462,0,6515,
  	6516,4,459,176,0,6516,6629,3,926,463,0,6517,6518,4,459,177,0,6518,6629,
  	3,928,464,0,6519,6520,7,108,0,0,6520,6629,3,918,459,15,6521,6522,3,1008,
  	504,0,6522,6523,3,918,459,14,6523,6629,1,0,0,0,6524,6526,5,516,0,0,6525,
  	6524,1,0,0,0,6525,6526,1,0,0,0,6526,6527,1,0,0,0,6527,6528,5,32,0,0,6528,
  	6529,3,1002,501,0,6529,6530,5,33,0,0,6530,6629,1,0,0,0,6531,6533,5,213,
  	0,0,6532,6531,1,0,0,0,6532,6533,1,0,0,0,6533,6534,1,0,0,0,6534,6629,3,
  	310,155,0,6535,6536,5,34,0,0,6536,6537,3,1404,702,0,6537,6538,3,906,453,
  	0,6538,6539,5,35,0,0,6539,6629,1,0,0,0,6540,6541,5,352,0,0,6541,6542,
  	3,950,475,0,6542,6543,5,53,0,0,6543,6544,5,32,0,0,6544,6546,3,916,458,
  	0,6545,6547,3,954,477,0,6546,6545,1,0,0,0,6546,6547,1,0,0,0,6547,6548,
  	1,0,0,0,6548,6549,5,33,0,0,6549,6629,1,0,0,0,6550,6551,5,77,0,0,6551,
  	6629,3,918,459,9,6552,6553,5,97,0,0,6553,6554,5,32,0,0,6554,6557,3,906,
  	453,0,6555,6556,5,67,0,0,6556,6558,5,316,0,0,6557,6555,1,0,0,0,6557,6558,
  	1,0,0,0,6558,6559,1,0,0,0,6559,6560,5,63,0,0,6560,6562,3,1000,500,0,6561,
  	6563,3,920,460,0,6562,6561,1,0,0,0,6562,6563,1,0,0,0,6563,6564,1,0,0,
  	0,6564,6565,5,33,0,0,6565,6629,1,0,0,0,6566,6567,4,459,178,0,6567,6568,
  	5,97,0,0,6568,6569,5,32,0,0,6569,6570,3,906,453,0,6570,6571,5,67,0,0,
  	6571,6572,5,612,0,0,6572,6574,5,777,0,0,6573,6575,5,282,0,0,6574,6573,
  	1,0,0,0,6574,6575,1,0,0,0,6575,6576,1,0,0,0,6576,6577,3,1436,718,0,6577,
  	6578,5,63,0,0,6578,6579,5,155,0,0,6579,6580,3,1182,591,0,6580,6581,5,
  	33,0,0,6581,6629,1,0,0,0,6582,6584,5,96,0,0,6583,6585,3,906,453,0,6584,
  	6583,1,0,0,0,6584,6585,1,0,0,0,6585,6589,1,0,0,0,6586,6587,3,994,497,
  	0,6587,6588,3,996,498,0,6588,6590,1,0,0,0,6589,6586,1,0,0,0,6590,6591,
  	1,0,0,0,6591,6589,1,0,0,0,6591,6592,1,0,0,0,6592,6594,1,0,0,0,6593,6595,
  	3,998,499,0,6594,6593,1,0,0,0,6594,6595,1,0,0,0,6595,6596,1,0,0,0,6596,
  	6597,5,198,0,0,6597,6629,1,0,0,0,6598,6599,5,137,0,0,6599,6600,5,32,0,
  	0,6600,6601,3,906,453,0,6601,6602,5,29,0,0,6602,6603,3,1000,500,0,6603,
  	6604,5,33,0,0,6604,6629,1,0,0,0,6605,6606,5,137,0,0,6606,6607,5,32,0,
  	0,6607,6608,3,906,453,0,6608,6609,5,647,0,0,6609,6610,3,1186,593,0,6610,
  	6611,5,33,0,0,6611,6629,1,0,0,0,6612,6613,5,168,0,0,6613,6614,5,32,0,
  	0,6614,6615,3,1412,706,0,6615,6616,5,33,0,0,6616,6629,1,0,0,0,6617,6618,
  	5,652,0,0,6618,6619,5,32,0,0,6619,6620,3,1412,706,0,6620,6621,5,33,0,
  	0,6621,6629,1,0,0,0,6622,6623,5,282,0,0,6623,6624,3,906,453,0,6624,6625,
  	3,1010,505,0,6625,6626,5,14,0,0,6626,6627,3,906,453,0,6627,6629,1,0,0,
  	0,6628,6503,1,0,0,0,6628,6508,1,0,0,0,6628,6509,1,0,0,0,6628,6510,1,0,
  	0,0,6628,6511,1,0,0,0,6628,6512,1,0,0,0,6628,6513,1,0,0,0,6628,6514,1,
  	0,0,0,6628,6515,1,0,0,0,6628,6517,1,0,0,0,6628,6519,1,0,0,0,6628,6521,
  	1,0,0,0,6628,6525,1,0,0,0,6628,6532,1,0,0,0,6628,6535,1,0,0,0,6628,6540,
  	1,0,0,0,6628,6550,1,0,0,0,6628,6552,1,0,0,0,6628,6566,1,0,0,0,6628,6582,
  	1,0,0,0,6628,6598,1,0,0,0,6628,6605,1,0,0,0,6628,6612,1,0,0,0,6628,6617,
  	1,0,0,0,6628,6622,1,0,0,0,6629,6638,1,0,0,0,6630,6631,10,16,0,0,6631,
  	6632,5,2,0,0,6632,6637,3,918,459,17,6633,6634,10,24,0,0,6634,6635,5,113,
  	0,0,6635,6637,3,1464,732,0,6636,6630,1,0,0,0,6636,6633,1,0,0,0,6637,6640,
  	1,0,0,0,6638,6636,1,0,0,0,6638,6639,1,0,0,0,6639,919,1,0,0,0,6640,6638,
  	1,0,0,0,6641,6642,4,460,181,0,6642,6643,5,756,0,0,6643,921,1,0,0,0,6644,
  	6645,4,461,182,0,6645,6646,5,37,0,0,6646,6651,3,1436,718,0,6647,6648,
  	4,461,183,0,6648,6649,5,38,0,0,6649,6651,3,1436,718,0,6650,6644,1,0,0,
  	0,6650,6647,1,0,0,0,6651,923,1,0,0,0,6652,6653,5,71,0,0,6653,6655,5,32,
  	0,0,6654,6656,5,183,0,0,6655,6654,1,0,0,0,6655,6656,1,0,0,0,6656,6657,
  	1,0,0,0,6657,6658,3,948,474,0,6658,6661,5,33,0,0,6659,6660,4,462,184,
  	0,6660,6662,3,936,468,0,6661,6659,1,0,0,0,6661,6662,1,0,0,0,6662,6747,
  	1,0,0,0,6663,6664,7,109,0,0,6664,6665,5,32,0,0,6665,6666,3,948,474,0,
  	6666,6669,5,33,0,0,6667,6668,4,462,185,0,6668,6670,3,936,468,0,6669,6667,
  	1,0,0,0,6669,6670,1,0,0,0,6670,6747,1,0,0,0,6671,6672,4,462,186,0,6672,
  	6747,3,946,473,0,6673,6674,4,462,187,0,6674,6675,5,809,0,0,6675,6677,
  	5,32,0,0,6676,6678,5,183,0,0,6677,6676,1,0,0,0,6677,6678,1,0,0,0,6678,
  	6679,1,0,0,0,6679,6680,3,948,474,0,6680,6682,5,33,0,0,6681,6683,3,936,
  	468,0,6682,6681,1,0,0,0,6682,6683,1,0,0,0,6683,6747,1,0,0,0,6684,6685,
  	5,138,0,0,6685,6693,5,32,0,0,6686,6688,5,56,0,0,6687,6686,1,0,0,0,6687,
  	6688,1,0,0,0,6688,6689,1,0,0,0,6689,6694,5,16,0,0,6690,6694,3,948,474,
  	0,6691,6692,5,183,0,0,6692,6694,3,1002,501,0,6693,6687,1,0,0,0,6693,6690,
  	1,0,0,0,6693,6691,1,0,0,0,6694,6695,1,0,0,0,6695,6698,5,33,0,0,6696,6697,
  	4,462,188,0,6697,6699,3,936,468,0,6698,6696,1,0,0,0,6698,6699,1,0,0,0,
  	6699,6747,1,0,0,0,6700,6701,7,110,0,0,6701,6703,5,32,0,0,6702,6704,5,
  	183,0,0,6703,6702,1,0,0,0,6703,6704,1,0,0,0,6704,6705,1,0,0,0,6705,6706,
  	3,948,474,0,6706,6709,5,33,0,0,6707,6708,4,462,189,0,6708,6710,3,936,
  	468,0,6709,6707,1,0,0,0,6709,6710,1,0,0,0,6710,6747,1,0,0,0,6711,6712,
  	7,111,0,0,6712,6713,5,32,0,0,6713,6714,3,948,474,0,6714,6717,5,33,0,0,
  	6715,6716,4,462,190,0,6716,6718,3,936,468,0,6717,6715,1,0,0,0,6717,6718,
  	1,0,0,0,6718,6747,1,0,0,0,6719,6720,5,590,0,0,6720,6721,5,32,0,0,6721,
  	6722,5,183,0,0,6722,6723,3,948,474,0,6723,6726,5,33,0,0,6724,6725,4,462,
  	191,0,6725,6727,3,936,468,0,6726,6724,1,0,0,0,6726,6727,1,0,0,0,6727,
  	6747,1,0,0,0,6728,6729,5,254,0,0,6729,6731,5,32,0,0,6730,6732,5,183,0,
  	0,6731,6730,1,0,0,0,6731,6732,1,0,0,0,6732,6733,1,0,0,0,6733,6735,3,1002,
  	501,0,6734,6736,3,360,180,0,6735,6734,1,0,0,0,6735,6736,1,0,0,0,6736,
  	6739,1,0,0,0,6737,6738,5,526,0,0,6738,6740,3,1438,719,0,6739,6737,1,0,
  	0,0,6739,6740,1,0,0,0,6740,6741,1,0,0,0,6741,6744,5,33,0,0,6742,6743,
  	4,462,192,0,6743,6745,3,936,468,0,6744,6742,1,0,0,0,6744,6745,1,0,0,0,
  	6745,6747,1,0,0,0,6746,6652,1,0,0,0,6746,6663,1,0,0,0,6746,6671,1,0,0,
  	0,6746,6673,1,0,0,0,6746,6684,1,0,0,0,6746,6700,1,0,0,0,6746,6711,1,0,
  	0,0,6746,6719,1,0,0,0,6746,6728,1,0,0,0,6747,925,1,0,0,0,6748,6749,5,
  	697,0,0,6749,6750,5,32,0,0,6750,6751,3,1002,501,0,6751,6752,5,33,0,0,
  	6752,927,1,0,0,0,6753,6754,7,112,0,0,6754,6755,3,1472,736,0,6755,6756,
  	3,936,468,0,6756,6803,1,0,0,0,6757,6764,5,713,0,0,6758,6759,5,32,0,0,
  	6759,6760,3,940,470,0,6760,6761,5,33,0,0,6761,6765,1,0,0,0,6762,6763,
  	4,464,193,0,6763,6765,3,1018,509,0,6764,6758,1,0,0,0,6764,6762,1,0,0,
  	0,6765,6766,1,0,0,0,6766,6767,3,936,468,0,6767,6803,1,0,0,0,6768,6769,
  	7,113,0,0,6769,6770,5,32,0,0,6770,6772,3,906,453,0,6771,6773,3,938,469,
  	0,6772,6771,1,0,0,0,6772,6773,1,0,0,0,6773,6774,1,0,0,0,6774,6776,5,33,
  	0,0,6775,6777,3,944,472,0,6776,6775,1,0,0,0,6776,6777,1,0,0,0,6777,6778,
  	1,0,0,0,6778,6779,3,936,468,0,6779,6803,1,0,0,0,6780,6781,7,114,0,0,6781,
  	6783,3,1016,508,0,6782,6784,3,944,472,0,6783,6782,1,0,0,0,6783,6784,1,
  	0,0,0,6784,6785,1,0,0,0,6785,6786,3,936,468,0,6786,6803,1,0,0,0,6787,
  	6788,5,712,0,0,6788,6789,5,32,0,0,6789,6790,3,906,453,0,6790,6791,5,29,
  	0,0,6791,6792,3,918,459,0,6792,6795,5,33,0,0,6793,6794,5,239,0,0,6794,
  	6796,7,115,0,0,6795,6793,1,0,0,0,6795,6796,1,0,0,0,6796,6798,1,0,0,0,
  	6797,6799,3,944,472,0,6798,6797,1,0,0,0,6798,6799,1,0,0,0,6799,6800,1,
  	0,0,0,6800,6801,3,936,468,0,6801,6803,1,0,0,0,6802,6753,1,0,0,0,6802,
  	6757,1,0,0,0,6802,6768,1,0,0,0,6802,6780,1,0,0,0,6802,6787,1,0,0,0,6803,
  	929,1,0,0,0,6804,6805,7,116,0,0,6805,931,1,0,0,0,6806,6811,3,1420,710,
  	0,6807,6808,5,39,0,0,6808,6811,3,1464,732,0,6809,6811,5,42,0,0,6810,6806,
  	1,0,0,0,6810,6807,1,0,0,0,6810,6809,1,0,0,0,6811,933,1,0,0,0,6812,6813,
  	4,467,194,0,6813,6814,5,833,0,0,6814,6815,3,930,465,0,6815,6816,5,32,
  	0,0,6816,6817,3,932,466,0,6817,6818,5,33,0,0,6818,935,1,0,0,0,6819,6822,
  	5,716,0,0,6820,6823,3,1400,700,0,6821,6823,3,334,167,0,6822,6820,1,0,
  	0,0,6822,6821,1,0,0,0,6823,937,1,0,0,0,6824,6829,5,29,0,0,6825,6830,3,
  	1420,710,0,6826,6830,5,42,0,0,6827,6828,4,469,195,0,6828,6830,3,940,470,
  	0,6829,6825,1,0,0,0,6829,6826,1,0,0,0,6829,6827,1,0,0,0,6830,6833,1,0,
  	0,0,6831,6832,5,29,0,0,6832,6834,3,906,453,0,6833,6831,1,0,0,0,6833,6834,
  	1,0,0,0,6834,939,1,0,0,0,6835,6838,3,1454,727,0,6836,6838,3,942,471,0,
  	6837,6835,1,0,0,0,6837,6836,1,0,0,0,6838,941,1,0,0,0,6839,6843,5,42,0,
  	0,6840,6843,3,1404,702,0,6841,6843,3,982,491,0,6842,6839,1,0,0,0,6842,
  	6840,1,0,0,0,6842,6841,1,0,0,0,6843,943,1,0,0,0,6844,6845,7,117,0,0,6845,
  	6846,5,714,0,0,6846,945,1,0,0,0,6847,6848,5,692,0,0,6848,6849,5,32,0,
  	0,6849,6850,3,948,474,0,6850,6852,5,33,0,0,6851,6853,3,936,468,0,6852,
  	6851,1,0,0,0,6852,6853,1,0,0,0,6853,6864,1,0,0,0,6854,6855,5,691,0,0,
  	6855,6856,5,32,0,0,6856,6857,3,948,474,0,6857,6858,5,29,0,0,6858,6859,
  	3,948,474,0,6859,6861,5,33,0,0,6860,6862,3,936,468,0,6861,6860,1,0,0,
  	0,6861,6862,1,0,0,0,6862,6864,1,0,0,0,6863,6847,1,0,0,0,6863,6854,1,0,
  	0,0,6864,947,1,0,0,0,6865,6867,5,56,0,0,6866,6865,1,0,0,0,6866,6867,1,
  	0,0,0,6867,6868,1,0,0,0,6868,6869,3,906,453,0,6869,949,1,0,0,0,6870,6876,
  	3,952,476,0,6871,6872,5,32,0,0,6872,6873,3,952,476,0,6873,6874,5,33,0,
  	0,6874,6876,1,0,0,0,6875,6870,1,0,0,0,6875,6871,1,0,0,0,6876,951,1,0,
  	0,0,6877,6882,3,1412,706,0,6878,6879,5,29,0,0,6879,6881,3,1412,706,0,
  	6880,6878,1,0,0,0,6881,6884,1,0,0,0,6882,6880,1,0,0,0,6882,6883,1,0,0,
  	0,6883,953,1,0,0,0,6884,6882,1,0,0,0,6885,6886,5,286,0,0,6886,6887,5,
  	86,0,0,6887,6901,5,377,0,0,6888,6889,5,286,0,0,6889,6890,5,390,0,0,6890,
  	6891,5,301,0,0,6891,6895,5,377,0,0,6892,6893,5,670,0,0,6893,6894,5,460,
  	0,0,6894,6896,5,215,0,0,6895,6892,1,0,0,0,6895,6896,1,0,0,0,6896,6901,
  	1,0,0,0,6897,6898,5,670,0,0,6898,6899,5,460,0,0,6899,6901,5,215,0,0,6900,
  	6885,1,0,0,0,6900,6888,1,0,0,0,6900,6897,1,0,0,0,6901,955,1,0,0,0,6902,
  	6903,5,104,0,0,6903,6904,5,32,0,0,6904,6907,3,1002,501,0,6905,6906,5,
  	647,0,0,6906,6908,3,1186,593,0,6907,6905,1,0,0,0,6907,6908,1,0,0,0,6908,
  	6909,1,0,0,0,6909,6910,5,33,0,0,6910,7191,1,0,0,0,6911,6913,5,147,0,0,
  	6912,6914,3,1472,736,0,6913,6912,1,0,0,0,6913,6914,1,0,0,0,6914,7191,
  	1,0,0,0,6915,6916,5,158,0,0,6916,7191,3,1016,508,0,6917,6918,5,163,0,
  	0,6918,7191,3,1016,508,0,6919,6920,5,265,0,0,6920,7191,3,1016,508,0,6921,
  	6922,5,278,0,0,6922,6923,5,32,0,0,6923,6924,3,906,453,0,6924,6925,5,29,
  	0,0,6925,6926,3,906,453,0,6926,6927,5,29,0,0,6927,6928,3,906,453,0,6928,
  	6929,5,29,0,0,6929,6930,3,906,453,0,6930,6931,5,33,0,0,6931,7191,1,0,
  	0,0,6932,6933,5,282,0,0,6933,6934,5,32,0,0,6934,6937,3,906,453,0,6935,
  	6936,5,29,0,0,6936,6938,3,906,453,0,6937,6935,1,0,0,0,6938,6939,1,0,0,
  	0,6939,6937,1,0,0,0,6939,6940,1,0,0,0,6940,6941,1,0,0,0,6941,6942,5,33,
  	0,0,6942,7191,1,0,0,0,6943,6944,4,478,196,0,6944,6945,5,771,0,0,6945,
  	6946,5,32,0,0,6946,6947,3,918,459,0,6947,6948,5,29,0,0,6948,6950,3,1442,
  	721,0,6949,6951,3,958,479,0,6950,6949,1,0,0,0,6950,6951,1,0,0,0,6951,
  	6952,1,0,0,0,6952,6953,3,420,210,0,6953,6954,5,33,0,0,6954,7191,1,0,0,
  	0,6955,6956,5,306,0,0,6956,6957,5,32,0,0,6957,6958,3,906,453,0,6958,6959,
  	5,29,0,0,6959,6960,3,906,453,0,6960,6961,5,33,0,0,6961,7191,1,0,0,0,6962,
  	6963,5,374,0,0,6963,7191,3,1016,508,0,6964,6965,5,381,0,0,6965,7191,3,
  	1016,508,0,6966,6967,5,508,0,0,6967,6968,5,32,0,0,6968,6969,3,906,453,
  	0,6969,6970,5,29,0,0,6970,6971,3,906,453,0,6971,6972,5,33,0,0,6972,7191,
  	1,0,0,0,6973,6974,5,522,0,0,6974,7191,3,1016,508,0,6975,6976,5,612,0,
  	0,6976,7191,3,1016,508,0,6977,6978,5,609,0,0,6978,6979,5,32,0,0,6979,
  	6982,3,906,453,0,6980,6981,5,29,0,0,6981,6983,3,906,453,0,6982,6980,1,
  	0,0,0,6982,6983,1,0,0,0,6983,6984,1,0,0,0,6984,6985,5,33,0,0,6985,7191,
  	1,0,0,0,6986,7191,3,972,486,0,6987,7191,3,628,314,0,6988,6989,5,652,0,
  	0,6989,7191,3,1016,508,0,6990,6991,5,681,0,0,6991,7191,3,1016,508,0,6992,
  	6993,7,118,0,0,6993,6994,5,32,0,0,6994,6995,3,906,453,0,6995,7001,5,29,
  	0,0,6996,7002,3,906,453,0,6997,6998,5,282,0,0,6998,6999,3,906,453,0,6999,
  	7000,3,1010,505,0,7000,7002,1,0,0,0,7001,6996,1,0,0,0,7001,6997,1,0,0,
  	0,7002,7003,1,0,0,0,7003,7004,5,33,0,0,7004,7191,1,0,0,0,7005,7007,5,
  	143,0,0,7006,7008,3,1472,736,0,7007,7006,1,0,0,0,7007,7008,1,0,0,0,7008,
  	7191,1,0,0,0,7009,7011,5,150,0,0,7010,7012,3,962,481,0,7011,7010,1,0,
  	0,0,7011,7012,1,0,0,0,7012,7191,1,0,0,0,7013,7014,7,119,0,0,7014,7015,
  	5,32,0,0,7015,7016,3,906,453,0,7016,7017,5,29,0,0,7017,7018,5,282,0,0,
  	7018,7019,3,906,453,0,7019,7020,3,1010,505,0,7020,7021,5,33,0,0,7021,
  	7191,1,0,0,0,7022,7023,5,221,0,0,7023,7024,5,32,0,0,7024,7025,3,1010,
  	505,0,7025,7026,5,239,0,0,7026,7027,3,906,453,0,7027,7028,5,33,0,0,7028,
  	7191,1,0,0,0,7029,7030,5,249,0,0,7030,7031,5,32,0,0,7031,7032,3,970,485,
  	0,7032,7033,5,29,0,0,7033,7034,3,906,453,0,7034,7035,5,33,0,0,7035,7191,
  	1,0,0,0,7036,7037,4,478,197,0,7037,7038,5,825,0,0,7038,7039,5,32,0,0,
  	7039,7042,3,906,453,0,7040,7041,5,29,0,0,7041,7043,3,906,453,0,7042,7040,
  	1,0,0,0,7042,7043,1,0,0,0,7043,7044,1,0,0,0,7044,7045,5,33,0,0,7045,7191,
  	1,0,0,0,7046,7048,5,402,0,0,7047,7049,3,962,481,0,7048,7047,1,0,0,0,7048,
  	7049,1,0,0,0,7049,7191,1,0,0,0,7050,7051,5,444,0,0,7051,7052,5,32,0,0,
  	7052,7053,3,916,458,0,7053,7054,5,286,0,0,7054,7055,3,906,453,0,7055,
  	7056,5,33,0,0,7056,7191,1,0,0,0,7057,7191,3,974,487,0,7058,7060,5,595,
  	0,0,7059,7061,3,962,481,0,7060,7059,1,0,0,0,7060,7061,1,0,0,0,7061,7191,
  	1,0,0,0,7062,7063,7,120,0,0,7063,7064,5,32,0,0,7064,7065,3,1012,506,0,
  	7065,7066,5,29,0,0,7066,7067,3,906,453,0,7067,7068,5,29,0,0,7068,7069,
  	3,906,453,0,7069,7070,5,33,0,0,7070,7191,1,0,0,0,7071,7073,5,648,0,0,
  	7072,7074,3,1472,736,0,7073,7072,1,0,0,0,7073,7074,1,0,0,0,7074,7191,
  	1,0,0,0,7075,7077,5,650,0,0,7076,7078,3,962,481,0,7077,7076,1,0,0,0,7077,
  	7078,1,0,0,0,7078,7191,1,0,0,0,7079,7081,5,649,0,0,7080,7082,3,962,481,
  	0,7081,7080,1,0,0,0,7081,7082,1,0,0,0,7082,7191,1,0,0,0,7083,7084,5,65,
  	0,0,7084,7191,3,1016,508,0,7085,7086,5,103,0,0,7086,7191,3,1016,508,0,
  	7087,7088,5,111,0,0,7088,7191,3,1014,507,0,7089,7090,5,114,0,0,7090,7191,
  	3,1016,508,0,7091,7092,5,151,0,0,7092,7191,3,1472,736,0,7093,7094,5,267,
  	0,0,7094,7095,5,32,0,0,7095,7096,3,906,453,0,7096,7097,5,29,0,0,7097,
  	7098,3,906,453,0,7098,7099,5,29,0,0,7099,7100,3,906,453,0,7100,7101,5,
  	33,0,0,7101,7191,1,0,0,0,7102,7103,5,237,0,0,7103,7104,5,32,0,0,7104,
  	7105,3,906,453,0,7105,7106,5,29,0,0,7106,7109,3,906,453,0,7107,7108,5,
  	29,0,0,7108,7110,3,906,453,0,7109,7107,1,0,0,0,7109,7110,1,0,0,0,7110,
  	7111,1,0,0,0,7111,7112,5,33,0,0,7112,7191,1,0,0,0,7113,7114,5,369,0,0,
  	7114,7191,3,1016,508,0,7115,7116,5,380,0,0,7116,7117,5,32,0,0,7117,7118,
  	3,906,453,0,7118,7119,5,29,0,0,7119,7120,3,906,453,0,7120,7121,5,33,0,
  	0,7121,7191,1,0,0,0,7122,7123,4,478,198,0,7123,7124,5,436,0,0,7124,7191,
  	3,1016,508,0,7125,7126,5,459,0,0,7126,7191,3,1016,508,0,7127,7128,5,487,
  	0,0,7128,7129,5,32,0,0,7129,7130,3,906,453,0,7130,7131,5,29,0,0,7131,
  	7132,3,906,453,0,7132,7133,5,33,0,0,7133,7191,1,0,0,0,7134,7135,5,488,
  	0,0,7135,7136,5,32,0,0,7136,7137,3,906,453,0,7137,7138,5,29,0,0,7138,
  	7139,3,906,453,0,7139,7140,5,29,0,0,7140,7141,3,906,453,0,7141,7142,5,
  	33,0,0,7142,7191,1,0,0,0,7143,7144,5,506,0,0,7144,7191,3,1016,508,0,7145,
  	7146,5,514,0,0,7146,7191,3,1472,736,0,7147,7148,5,623,0,0,7148,7149,5,
  	32,0,0,7149,7150,3,906,453,0,7150,7151,5,29,0,0,7151,7152,3,906,453,0,
  	7152,7153,5,33,0,0,7153,7191,1,0,0,0,7154,7155,5,665,0,0,7155,7156,5,
  	32,0,0,7156,7159,3,906,453,0,7157,7158,5,29,0,0,7158,7160,3,906,453,0,
  	7159,7157,1,0,0,0,7159,7160,1,0,0,0,7160,7161,1,0,0,0,7161,7162,5,33,
  	0,0,7162,7191,1,0,0,0,7163,7164,5,666,0,0,7164,7165,5,32,0,0,7165,7185,
  	3,906,453,0,7166,7167,5,63,0,0,7167,7168,5,104,0,0,7168,7170,3,1180,590,
  	0,7169,7166,1,0,0,0,7169,7170,1,0,0,0,7170,7173,1,0,0,0,7171,7172,4,478,
  	199,0,7172,7174,3,966,483,0,7173,7171,1,0,0,0,7173,7174,1,0,0,0,7174,
  	7186,1,0,0,0,7175,7176,5,63,0,0,7176,7177,5,77,0,0,7177,7186,3,1180,590,
  	0,7178,7179,5,29,0,0,7179,7180,3,1416,708,0,7180,7181,5,29,0,0,7181,7182,
  	3,1416,708,0,7182,7183,5,29,0,0,7183,7184,3,1416,708,0,7184,7186,1,0,
  	0,0,7185,7169,1,0,0,0,7185,7175,1,0,0,0,7185,7178,1,0,0,0,7186,7187,1,
  	0,0,0,7187,7188,5,33,0,0,7188,7191,1,0,0,0,7189,7191,3,960,480,0,7190,
  	6902,1,0,0,0,7190,6911,1,0,0,0,7190,6915,1,0,0,0,7190,6917,1,0,0,0,7190,
  	6919,1,0,0,0,7190,6921,1,0,0,0,7190,6932,1,0,0,0,7190,6943,1,0,0,0,7190,
  	6955,1,0,0,0,7190,6962,1,0,0,0,7190,6964,1,0,0,0,7190,6966,1,0,0,0,7190,
  	6973,1,0,0,0,7190,6975,1,0,0,0,7190,6977,1,0,0,0,7190,6986,1,0,0,0,7190,
  	6987,1,0,0,0,7190,6988,1,0,0,0,7190,6990,1,0,0,0,7190,6992,1,0,0,0,7190,
  	7005,1,0,0,0,7190,7009,1,0,0,0,7190,7013,1,0,0,0,7190,7022,1,0,0,0,7190,
  	7029,1,0,0,0,7190,7036,1,0,0,0,7190,7046,1,0,0,0,7190,7050,1,0,0,0,7190,
  	7057,1,0,0,0,7190,7058,1,0,0,0,7190,7062,1,0,0,0,7190,7071,1,0,0,0,7190,
  	7075,1,0,0,0,7190,7079,1,0,0,0,7190,7083,1,0,0,0,7190,7085,1,0,0,0,7190,
  	7087,1,0,0,0,7190,7089,1,0,0,0,7190,7091,1,0,0,0,7190,7093,1,0,0,0,7190,
  	7102,1,0,0,0,7190,7113,1,0,0,0,7190,7115,1,0,0,0,7190,7122,1,0,0,0,7190,
  	7125,1,0,0,0,7190,7127,1,0,0,0,7190,7134,1,0,0,0,7190,7143,1,0,0,0,7190,
  	7145,1,0,0,0,7190,7147,1,0,0,0,7190,7154,1,0,0,0,7190,7163,1,0,0,0,7190,
  	7189,1,0,0,0,7191,957,1,0,0,0,7192,7193,5,770,0,0,7193,7194,3,1000,500,
  	0,7194,959,1,0,0,0,7195,7196,4,480,200,0,7196,7197,5,134,0,0,7197,7198,
  	5,32,0,0,7198,7199,3,906,453,0,7199,7200,5,29,0,0,7200,7201,3,906,453,
  	0,7201,7202,5,33,0,0,7202,7227,1,0,0,0,7203,7204,5,247,0,0,7204,7206,
  	5,32,0,0,7205,7207,3,1002,501,0,7206,7205,1,0,0,0,7206,7207,1,0,0,0,7207,
  	7208,1,0,0,0,7208,7227,5,33,0,0,7209,7210,5,313,0,0,7210,7227,3,1014,
  	507,0,7211,7212,5,382,0,0,7212,7227,3,1014,507,0,7213,7214,5,383,0,0,
  	7214,7227,3,1014,507,0,7215,7216,5,384,0,0,7216,7227,3,1014,507,0,7217,
  	7218,5,441,0,0,7218,7219,5,32,0,0,7219,7220,3,906,453,0,7220,7221,5,29,
  	0,0,7221,7222,3,906,453,0,7222,7223,5,33,0,0,7223,7227,1,0,0,0,7224,7225,
  	5,442,0,0,7225,7227,3,1014,507,0,7226,7195,1,0,0,0,7226,7203,1,0,0,0,
  	7226,7209,1,0,0,0,7226,7211,1,0,0,0,7226,7213,1,0,0,0,7226,7215,1,0,0,
  	0,7226,7217,1,0,0,0,7226,7224,1,0,0,0,7227,961,1,0,0,0,7228,7230,5,32,
  	0,0,7229,7231,3,964,482,0,7230,7229,1,0,0,0,7230,7231,1,0,0,0,7231,7232,
  	1,0,0,0,7232,7233,5,33,0,0,7233,963,1,0,0,0,7234,7235,5,3,0,0,7235,965,
  	1,0,0,0,7236,7249,5,308,0,0,7237,7238,3,1418,709,0,7238,7239,5,15,0,0,
  	7239,7240,3,1418,709,0,7240,7250,1,0,0,0,7241,7246,3,968,484,0,7242,7243,
  	5,29,0,0,7243,7245,3,968,484,0,7244,7242,1,0,0,0,7245,7248,1,0,0,0,7246,
  	7244,1,0,0,0,7246,7247,1,0,0,0,7247,7250,1,0,0,0,7248,7246,1,0,0,0,7249,
  	7237,1,0,0,0,7249,7241,1,0,0,0,7250,967,1,0,0,0,7251,7257,3,1418,709,
  	0,7252,7254,7,35,0,0,7253,7255,5,506,0,0,7254,7253,1,0,0,0,7254,7255,
  	1,0,0,0,7255,7258,1,0,0,0,7256,7258,5,506,0,0,7257,7252,1,0,0,0,7257,
  	7256,1,0,0,0,7257,7258,1,0,0,0,7258,969,1,0,0,0,7259,7260,7,121,0,0,7260,
  	971,1,0,0,0,7261,7262,5,621,0,0,7262,7286,5,32,0,0,7263,7266,3,906,453,
  	0,7264,7265,5,239,0,0,7265,7267,3,906,453,0,7266,7264,1,0,0,0,7266,7267,
  	1,0,0,0,7267,7287,1,0,0,0,7268,7270,5,303,0,0,7269,7271,3,906,453,0,7270,
  	7269,1,0,0,0,7270,7271,1,0,0,0,7271,7272,1,0,0,0,7272,7273,5,239,0,0,
  	7273,7287,3,906,453,0,7274,7276,5,617,0,0,7275,7277,3,906,453,0,7276,
  	7275,1,0,0,0,7276,7277,1,0,0,0,7277,7278,1,0,0,0,7278,7279,5,239,0,0,
  	7279,7287,3,906,453,0,7280,7282,5,88,0,0,7281,7283,3,906,453,0,7282,7281,
  	1,0,0,0,7282,7283,1,0,0,0,7283,7284,1,0,0,0,7284,7285,5,239,0,0,7285,
  	7287,3,906,453,0,7286,7263,1,0,0,0,7286,7268,1,0,0,0,7286,7274,1,0,0,
  	0,7286,7280,1,0,0,0,7287,7288,1,0,0,0,7288,7289,5,33,0,0,7289,973,1,0,
  	0,0,7290,7291,5,589,0,0,7291,7292,5,32,0,0,7292,7305,3,906,453,0,7293,
  	7294,5,29,0,0,7294,7297,3,906,453,0,7295,7296,5,29,0,0,7296,7298,3,906,
  	453,0,7297,7295,1,0,0,0,7297,7298,1,0,0,0,7298,7306,1,0,0,0,7299,7300,
  	5,239,0,0,7300,7303,3,906,453,0,7301,7302,5,236,0,0,7302,7304,3,906,453,
  	0,7303,7301,1,0,0,0,7303,7304,1,0,0,0,7304,7306,1,0,0,0,7305,7293,1,0,
  	0,0,7305,7299,1,0,0,0,7306,7307,1,0,0,0,7307,7308,5,33,0,0,7308,975,1,
  	0,0,0,7309,7310,3,1402,701,0,7310,7312,5,32,0,0,7311,7313,3,978,489,0,
  	7312,7311,1,0,0,0,7312,7313,1,0,0,0,7313,7314,1,0,0,0,7314,7315,5,33,
  	0,0,7315,7324,1,0,0,0,7316,7317,3,1410,705,0,7317,7319,5,32,0,0,7318,
  	7320,3,1002,501,0,7319,7318,1,0,0,0,7319,7320,1,0,0,0,7320,7321,1,0,0,
  	0,7321,7322,5,33,0,0,7322,7324,1,0,0,0,7323,7309,1,0,0,0,7323,7316,1,
  	0,0,0,7324,977,1,0,0,0,7325,7330,3,980,490,0,7326,7327,5,29,0,0,7327,
  	7329,3,980,490,0,7328,7326,1,0,0,0,7329,7332,1,0,0,0,7330,7328,1,0,0,
  	0,7330,7331,1,0,0,0,7331,979,1,0,0,0,7332,7330,1,0,0,0,7333,7335,3,906,
  	453,0,7334,7336,3,388,194,0,7335,7334,1,0,0,0,7335,7336,1,0,0,0,7336,
  	981,1,0,0,0,7337,7338,5,39,0,0,7338,7339,3,984,492,0,7339,983,1,0,0,0,
  	7340,7343,3,1464,732,0,7341,7343,5,850,0,0,7342,7340,1,0,0,0,7342,7341,
  	1,0,0,0,7343,985,1,0,0,0,7344,7345,3,982,491,0,7345,7346,5,7,0,0,7346,
  	7347,3,906,453,0,7347,987,1,0,0,0,7348,7356,3,982,491,0,7349,7350,5,39,
  	0,0,7350,7352,5,39,0,0,7351,7353,3,1478,739,0,7352,7351,1,0,0,0,7352,
  	7353,1,0,0,0,7353,7354,1,0,0,0,7354,7356,3,992,496,0,7355,7348,1,0,0,
  	0,7355,7349,1,0,0,0,7356,989,1,0,0,0,7357,7359,3,1404,702,0,7358,7360,
  	3,1414,707,0,7359,7358,1,0,0,0,7359,7360,1,0,0,0,7360,7367,1,0,0,0,7361,
  	7362,4,495,201,0,7362,7364,3,1466,733,0,7363,7365,3,1414,707,0,7364,7363,
  	1,0,0,0,7364,7365,1,0,0,0,7365,7367,1,0,0,0,7366,7357,1,0,0,0,7366,7361,
  	1,0,0,0,7367,7371,1,0,0,0,7368,7369,5,168,0,0,7369,7371,3,1414,707,0,
  	7370,7366,1,0,0,0,7370,7368,1,0,0,0,7371,991,1,0,0,0,7372,7374,3,1464,
  	732,0,7373,7375,3,1414,707,0,7374,7373,1,0,0,0,7374,7375,1,0,0,0,7375,
  	993,1,0,0,0,7376,7377,5,667,0,0,7377,7378,3,906,453,0,7378,995,1,0,0,
  	0,7379,7380,5,608,0,0,7380,7381,3,906,453,0,7381,997,1,0,0,0,7382,7383,
  	5,193,0,0,7383,7384,3,906,453,0,7384,999,1,0,0,0,7385,7387,5,77,0,0,7386,
  	7388,3,1170,585,0,7387,7386,1,0,0,0,7387,7388,1,0,0,0,7388,7435,1,0,0,
  	0,7389,7391,5,104,0,0,7390,7392,3,1170,585,0,7391,7390,1,0,0,0,7391,7392,
  	1,0,0,0,7392,7394,1,0,0,0,7393,7395,3,1174,587,0,7394,7393,1,0,0,0,7394,
  	7395,1,0,0,0,7395,7435,1,0,0,0,7396,7398,3,1166,583,0,7397,7399,3,1170,
  	585,0,7398,7397,1,0,0,0,7398,7399,1,0,0,0,7399,7435,1,0,0,0,7400,7402,
  	5,539,0,0,7401,7403,5,284,0,0,7402,7401,1,0,0,0,7402,7403,1,0,0,0,7403,
  	7435,1,0,0,0,7404,7406,5,638,0,0,7405,7407,5,284,0,0,7406,7405,1,0,0,
  	0,7406,7407,1,0,0,0,7407,7435,1,0,0,0,7408,7435,5,158,0,0,7409,7410,4,
  	500,202,0,7410,7435,5,681,0,0,7411,7413,5,612,0,0,7412,7414,3,1182,591,
  	0,7413,7412,1,0,0,0,7413,7414,1,0,0,0,7414,7435,1,0,0,0,7415,7417,5,155,
  	0,0,7416,7418,3,1182,591,0,7417,7416,1,0,0,0,7417,7418,1,0,0,0,7418,7435,
  	1,0,0,0,7419,7421,5,166,0,0,7420,7422,3,1458,729,0,7421,7420,1,0,0,0,
  	7421,7422,1,0,0,0,7422,7435,1,0,0,0,7423,7424,4,500,203,0,7424,7435,5,
  	296,0,0,7425,7426,4,500,204,0,7426,7435,3,1168,584,0,7427,7428,4,500,
  	205,0,7428,7430,5,231,0,0,7429,7431,3,1460,730,0,7430,7429,1,0,0,0,7430,
  	7431,1,0,0,0,7431,7435,1,0,0,0,7432,7433,4,500,206,0,7433,7435,7,122,
  	0,0,7434,7385,1,0,0,0,7434,7389,1,0,0,0,7434,7396,1,0,0,0,7434,7400,1,
  	0,0,0,7434,7404,1,0,0,0,7434,7408,1,0,0,0,7434,7409,1,0,0,0,7434,7411,
  	1,0,0,0,7434,7415,1,0,0,0,7434,7419,1,0,0,0,7434,7423,1,0,0,0,7434,7425,
  	1,0,0,0,7434,7427,1,0,0,0,7434,7432,1,0,0,0,7435,1001,1,0,0,0,7436,7441,
  	3,906,453,0,7437,7438,5,29,0,0,7438,7440,3,906,453,0,7439,7437,1,0,0,
  	0,7440,7443,1,0,0,0,7441,7439,1,0,0,0,7441,7442,1,0,0,0,7442,1003,1,0,
  	0,0,7443,7441,1,0,0,0,7444,7445,5,104,0,0,7445,7448,5,533,0,0,7446,7448,
  	5,103,0,0,7447,7444,1,0,0,0,7447,7446,1,0,0,0,7448,1005,1,0,0,0,7449,
  	7450,7,123,0,0,7450,1007,1,0,0,0,7451,7452,7,124,0,0,7452,1009,1,0,0,
  	0,7453,7456,3,1012,506,0,7454,7456,7,125,0,0,7455,7453,1,0,0,0,7455,7454,
  	1,0,0,0,7456,1011,1,0,0,0,7457,7458,7,126,0,0,7458,1013,1,0,0,0,7459,
  	7460,5,32,0,0,7460,7461,3,1002,501,0,7461,7462,5,33,0,0,7462,1015,1,0,
  	0,0,7463,7464,5,32,0,0,7464,7465,3,906,453,0,7465,7466,5,33,0,0,7466,
  	1017,1,0,0,0,7467,7468,5,32,0,0,7468,7469,3,918,459,0,7469,7470,5,33,
  	0,0,7470,1019,1,0,0,0,7471,7476,3,1022,511,0,7472,7473,5,29,0,0,7473,
  	7475,3,1022,511,0,7474,7472,1,0,0,0,7475,7478,1,0,0,0,7476,7474,1,0,0,
  	0,7476,7477,1,0,0,0,7477,1021,1,0,0,0,7478,7476,1,0,0,0,7479,7481,3,906,
  	453,0,7480,7482,3,362,181,0,7481,7480,1,0,0,0,7481,7482,1,0,0,0,7482,
  	1023,1,0,0,0,7483,7488,3,1026,513,0,7484,7485,5,29,0,0,7485,7487,3,1026,
  	513,0,7486,7484,1,0,0,0,7487,7490,1,0,0,0,7488,7486,1,0,0,0,7488,7489,
  	1,0,0,0,7489,1025,1,0,0,0,7490,7488,1,0,0,0,7491,7492,3,906,453,0,7492,
  	1027,1,0,0,0,7493,7494,4,514,207,0,7494,7495,5,236,0,0,7495,7496,5,102,
  	0,0,7496,7497,3,1444,722,0,7497,1029,1,0,0,0,7498,7512,3,2,1,0,7499,7512,
  	3,1032,516,0,7500,7512,3,1034,517,0,7501,7512,3,1042,521,0,7502,7512,
  	3,1046,523,0,7503,7512,3,1048,524,0,7504,7512,3,1054,527,0,7505,7512,
  	3,1056,528,0,7506,7512,3,1084,542,0,7507,7512,3,1082,541,0,7508,7512,
  	3,1102,551,0,7509,7512,3,1106,553,0,7510,7512,3,1104,552,0,7511,7498,
  	1,0,0,0,7511,7499,1,0,0,0,7511,7500,1,0,0,0,7511,7501,1,0,0,0,7511,7502,
  	1,0,0,0,7511,7503,1,0,0,0,7511,7504,1,0,0,0,7511,7505,1,0,0,0,7511,7506,
  	1,0,0,0,7511,7507,1,0,0,0,7511,7508,1,0,0,0,7511,7509,1,0,0,0,7511,7510,
  	1,0,0,0,7512,1031,1,0,0,0,7513,7514,5,505,0,0,7514,7515,3,906,453,0,7515,
  	1033,1,0,0,0,7516,7517,5,267,0,0,7517,7518,3,1036,518,0,7518,7519,5,198,
  	0,0,7519,7520,5,267,0,0,7520,1035,1,0,0,0,7521,7522,3,906,453,0,7522,
  	7527,3,1038,519,0,7523,7524,5,194,0,0,7524,7528,3,1036,518,0,7525,7526,
  	5,193,0,0,7526,7528,3,1040,520,0,7527,7523,1,0,0,0,7527,7525,1,0,0,0,
  	7527,7528,1,0,0,0,7528,1037,1,0,0,0,7529,7530,5,608,0,0,7530,7531,3,1040,
  	520,0,7531,1039,1,0,0,0,7532,7533,3,1030,515,0,7533,7534,5,30,0,0,7534,
  	7536,1,0,0,0,7535,7532,1,0,0,0,7536,7537,1,0,0,0,7537,7535,1,0,0,0,7537,
  	7538,1,0,0,0,7538,1041,1,0,0,0,7539,7541,5,96,0,0,7540,7542,3,906,453,
  	0,7541,7540,1,0,0,0,7541,7542,1,0,0,0,7542,7546,1,0,0,0,7543,7544,3,994,
  	497,0,7544,7545,3,1038,519,0,7545,7547,1,0,0,0,7546,7543,1,0,0,0,7547,
  	7548,1,0,0,0,7548,7546,1,0,0,0,7548,7549,1,0,0,0,7549,7551,1,0,0,0,7550,
  	7552,3,1044,522,0,7551,7550,1,0,0,0,7551,7552,1,0,0,0,7552,7553,1,0,0,
  	0,7553,7554,5,198,0,0,7554,7555,5,96,0,0,7555,1043,1,0,0,0,7556,7557,
  	5,193,0,0,7557,7558,3,1040,520,0,7558,1045,1,0,0,0,7559,7560,3,1050,525,
  	0,7560,7562,3,1052,526,0,7561,7563,3,1390,695,0,7562,7561,1,0,0,0,7562,
  	7563,1,0,0,0,7563,1047,1,0,0,0,7564,7565,3,1052,526,0,7565,1049,1,0,0,
  	0,7566,7567,3,1388,694,0,7567,7568,5,31,0,0,7568,1051,1,0,0,0,7569,7571,
  	5,74,0,0,7570,7572,3,1064,532,0,7571,7570,1,0,0,0,7571,7572,1,0,0,0,7572,
  	7574,1,0,0,0,7573,7575,3,1040,520,0,7574,7573,1,0,0,0,7574,7575,1,0,0,
  	0,7575,7576,1,0,0,0,7576,7577,5,198,0,0,7577,1053,1,0,0,0,7578,7579,3,
  	1050,525,0,7579,7581,3,1056,528,0,7580,7582,3,1390,695,0,7581,7580,1,
  	0,0,0,7581,7582,1,0,0,0,7582,1055,1,0,0,0,7583,7587,3,1058,529,0,7584,
  	7587,3,1060,530,0,7585,7587,3,1062,531,0,7586,7583,1,0,0,0,7586,7584,
  	1,0,0,0,7586,7585,1,0,0,0,7587,1057,1,0,0,0,7588,7589,5,326,0,0,7589,
  	7590,3,1040,520,0,7590,7591,5,198,0,0,7591,7592,5,326,0,0,7592,1059,1,
  	0,0,0,7593,7594,5,669,0,0,7594,7595,3,906,453,0,7595,7596,5,186,0,0,7596,
  	7597,3,1040,520,0,7597,7598,5,198,0,0,7598,7599,5,669,0,0,7599,1061,1,
  	0,0,0,7600,7601,5,487,0,0,7601,7602,3,1040,520,0,7602,7603,5,639,0,0,
  	7603,7604,3,906,453,0,7604,7605,5,198,0,0,7605,7606,5,487,0,0,7606,1063,
  	1,0,0,0,7607,7608,3,1066,533,0,7608,7609,5,30,0,0,7609,7611,1,0,0,0,7610,
  	7607,1,0,0,0,7611,7612,1,0,0,0,7612,7610,1,0,0,0,7612,7613,1,0,0,0,7613,
  	1065,1,0,0,0,7614,7619,3,1068,534,0,7615,7619,3,1070,535,0,7616,7619,
  	3,1076,538,0,7617,7619,3,1080,540,0,7618,7614,1,0,0,0,7618,7615,1,0,0,
  	0,7618,7616,1,0,0,0,7618,7617,1,0,0,0,7619,1067,1,0,0,0,7620,7621,5,167,
  	0,0,7621,7622,3,1406,703,0,7622,7624,3,1164,582,0,7623,7625,3,1246,623,
  	0,7624,7623,1,0,0,0,7624,7625,1,0,0,0,7625,7628,1,0,0,0,7626,7627,5,168,
  	0,0,7627,7629,3,906,453,0,7628,7626,1,0,0,0,7628,7629,1,0,0,0,7629,1069,
  	1,0,0,0,7630,7631,5,167,0,0,7631,7632,3,1404,702,0,7632,7633,5,127,0,
  	0,7633,7634,5,236,0,0,7634,7635,3,1072,536,0,7635,1071,1,0,0,0,7636,7639,
  	3,1416,708,0,7637,7639,3,1074,537,0,7638,7636,1,0,0,0,7638,7637,1,0,0,
  	0,7639,1073,1,0,0,0,7640,7642,5,552,0,0,7641,7643,5,653,0,0,7642,7641,
  	1,0,0,0,7642,7643,1,0,0,0,7643,7644,1,0,0,0,7644,7645,3,1442,721,0,7645,
  	1075,1,0,0,0,7646,7647,5,167,0,0,7647,7648,7,127,0,0,7648,7649,5,255,
  	0,0,7649,7650,5,236,0,0,7650,7655,3,1078,539,0,7651,7652,5,29,0,0,7652,
  	7654,3,1078,539,0,7653,7651,1,0,0,0,7654,7657,1,0,0,0,7655,7653,1,0,0,
  	0,7655,7656,1,0,0,0,7656,7658,1,0,0,0,7657,7655,1,0,0,0,7658,7659,3,1030,
  	515,0,7659,1077,1,0,0,0,7660,7668,3,1072,536,0,7661,7668,3,1404,702,0,
  	7662,7668,5,553,0,0,7663,7664,3,1006,503,0,7664,7665,5,238,0,0,7665,7668,
  	1,0,0,0,7666,7668,5,551,0,0,7667,7660,1,0,0,0,7667,7661,1,0,0,0,7667,
  	7662,1,0,0,0,7667,7663,1,0,0,0,7667,7666,1,0,0,0,7668,1079,1,0,0,0,7669,
  	7670,5,167,0,0,7670,7671,3,1404,702,0,7671,7672,5,148,0,0,7672,7673,5,
  	236,0,0,7673,7674,3,296,148,0,7674,1081,1,0,0,0,7675,7676,5,294,0,0,7676,
  	7677,3,1390,695,0,7677,1083,1,0,0,0,7678,7679,5,305,0,0,7679,7680,3,1390,
  	695,0,7680,1085,1,0,0,0,7681,7683,5,243,0,0,7682,7684,7,128,0,0,7683,
  	7682,1,0,0,0,7683,7684,1,0,0,0,7684,7685,1,0,0,0,7685,7704,5,178,0,0,
  	7686,7691,3,1090,545,0,7687,7688,5,29,0,0,7688,7690,3,1090,545,0,7689,
  	7687,1,0,0,0,7690,7693,1,0,0,0,7691,7689,1,0,0,0,7691,7692,1,0,0,0,7692,
  	7705,1,0,0,0,7693,7691,1,0,0,0,7694,7695,5,127,0,0,7695,7696,3,1088,544,
  	0,7696,7701,3,1092,546,0,7697,7698,5,29,0,0,7698,7700,3,1092,546,0,7699,
  	7697,1,0,0,0,7700,7703,1,0,0,0,7701,7699,1,0,0,0,7701,7702,1,0,0,0,7702,
  	7705,1,0,0,0,7703,7701,1,0,0,0,7704,7686,1,0,0,0,7704,7694,1,0,0,0,7705,
  	1087,1,0,0,0,7706,7710,3,1428,714,0,7707,7710,3,988,494,0,7708,7710,3,
  	1410,705,0,7709,7706,1,0,0,0,7709,7707,1,0,0,0,7709,7708,1,0,0,0,7710,
  	1089,1,0,0,0,7711,7714,3,982,491,0,7712,7714,3,1404,702,0,7713,7711,1,
  	0,0,0,7713,7712,1,0,0,0,7714,7715,1,0,0,0,7715,7716,5,6,0,0,7716,7717,
  	7,129,0,0,7717,1091,1,0,0,0,7718,7721,3,982,491,0,7719,7721,3,1404,702,
  	0,7720,7718,1,0,0,0,7720,7719,1,0,0,0,7721,7722,1,0,0,0,7722,7725,5,6,
  	0,0,7723,7726,3,1094,547,0,7724,7726,5,503,0,0,7725,7723,1,0,0,0,7725,
  	7724,1,0,0,0,7726,1093,1,0,0,0,7727,7728,7,130,0,0,7728,1095,1,0,0,0,
  	7729,7732,5,538,0,0,7730,7733,3,1404,702,0,7731,7733,3,1074,537,0,7732,
  	7730,1,0,0,0,7732,7731,1,0,0,0,7733,7743,1,0,0,0,7734,7735,5,533,0,0,
  	7735,7740,3,1100,550,0,7736,7737,5,29,0,0,7737,7739,3,1100,550,0,7738,
  	7736,1,0,0,0,7739,7742,1,0,0,0,7740,7738,1,0,0,0,7740,7741,1,0,0,0,7741,
  	7744,1,0,0,0,7742,7740,1,0,0,0,7743,7734,1,0,0,0,7743,7744,1,0,0,0,7744,
  	1097,1,0,0,0,7745,7748,5,499,0,0,7746,7749,3,1404,702,0,7747,7749,3,1074,
  	537,0,7748,7746,1,0,0,0,7748,7747,1,0,0,0,7748,7749,1,0,0,0,7749,7759,
  	1,0,0,0,7750,7751,5,533,0,0,7751,7756,3,1100,550,0,7752,7753,5,29,0,0,
  	7753,7755,3,1100,550,0,7754,7752,1,0,0,0,7755,7758,1,0,0,0,7756,7754,
  	1,0,0,0,7756,7757,1,0,0,0,7757,7760,1,0,0,0,7758,7756,1,0,0,0,7759,7750,
  	1,0,0,0,7759,7760,1,0,0,0,7760,1099,1,0,0,0,7761,7762,3,1094,547,0,7762,
  	7763,5,6,0,0,7763,7764,3,1088,544,0,7764,1101,1,0,0,0,7765,7766,5,417,
  	0,0,7766,7767,3,1404,702,0,7767,1103,1,0,0,0,7768,7769,5,110,0,0,7769,
  	7770,3,1404,702,0,7770,1105,1,0,0,0,7771,7776,5,225,0,0,7772,7774,5,397,
  	0,0,7773,7772,1,0,0,0,7773,7774,1,0,0,0,7774,7775,1,0,0,0,7775,7777,5,
  	239,0,0,7776,7773,1,0,0,0,7776,7777,1,0,0,0,7777,7778,1,0,0,0,7778,7779,
  	3,1404,702,0,7779,7780,5,283,0,0,7780,7781,3,1406,703,0,7781,1107,1,0,
  	0,0,7782,7783,5,67,0,0,7783,7796,3,906,453,0,7784,7785,5,210,0,0,7785,
  	7786,3,906,453,0,7786,7789,3,1010,505,0,7787,7788,5,568,0,0,7788,7790,
  	3,906,453,0,7789,7787,1,0,0,0,7789,7790,1,0,0,0,7790,7793,1,0,0,0,7791,
  	7792,5,199,0,0,7792,7794,3,906,453,0,7793,7791,1,0,0,0,7793,7794,1,0,
  	0,0,7794,7796,1,0,0,0,7795,7782,1,0,0,0,7795,7784,1,0,0,0,7796,1109,1,
  	0,0,0,7797,7798,3,1318,659,0,7798,7800,3,1122,561,0,7799,7801,3,1112,
  	556,0,7800,7799,1,0,0,0,7800,7801,1,0,0,0,7801,1111,1,0,0,0,7802,7803,
  	4,556,208,0,7803,7806,3,1114,557,0,7804,7806,3,1136,568,0,7805,7802,1,
  	0,0,0,7805,7804,1,0,0,0,7806,1113,1,0,0,0,7807,7808,5,106,0,0,7808,7809,
  	3,1016,508,0,7809,1115,1,0,0,0,7810,7812,4,558,209,0,7811,7813,5,401,
  	0,0,7812,7811,1,0,0,0,7812,7813,1,0,0,0,7813,7814,1,0,0,0,7814,7815,5,
  	755,0,0,7815,1117,1,0,0,0,7816,7818,7,40,0,0,7817,7819,3,120,60,0,7818,
  	7817,1,0,0,0,7818,7819,1,0,0,0,7819,7820,1,0,0,0,7820,7824,3,1144,572,
  	0,7821,7823,3,1150,575,0,7822,7821,1,0,0,0,7823,7826,1,0,0,0,7824,7822,
  	1,0,0,0,7824,7825,1,0,0,0,7825,7891,1,0,0,0,7826,7824,1,0,0,0,7827,7829,
  	5,241,0,0,7828,7830,3,440,220,0,7829,7828,1,0,0,0,7829,7830,1,0,0,0,7830,
  	7832,1,0,0,0,7831,7833,3,1328,664,0,7832,7831,1,0,0,0,7832,7833,1,0,0,
  	0,7833,7834,1,0,0,0,7834,7838,3,1144,572,0,7835,7837,3,1158,579,0,7836,
  	7835,1,0,0,0,7837,7840,1,0,0,0,7838,7836,1,0,0,0,7838,7839,1,0,0,0,7839,
  	7891,1,0,0,0,7840,7838,1,0,0,0,7841,7843,5,549,0,0,7842,7844,3,440,220,
  	0,7843,7842,1,0,0,0,7843,7844,1,0,0,0,7844,7846,1,0,0,0,7845,7847,3,1328,
  	664,0,7846,7845,1,0,0,0,7846,7847,1,0,0,0,7847,7848,1,0,0,0,7848,7852,
  	3,1144,572,0,7849,7851,3,1160,580,0,7850,7849,1,0,0,0,7851,7854,1,0,0,
  	0,7852,7850,1,0,0,0,7852,7853,1,0,0,0,7853,7891,1,0,0,0,7854,7852,1,0,
  	0,0,7855,7857,3,1120,560,0,7856,7855,1,0,0,0,7856,7857,1,0,0,0,7857,7888,
  	1,0,0,0,7858,7859,5,450,0,0,7859,7865,5,299,0,0,7860,7862,5,635,0,0,7861,
  	7863,3,440,220,0,7862,7861,1,0,0,0,7862,7863,1,0,0,0,7863,7865,1,0,0,
  	0,7864,7858,1,0,0,0,7864,7860,1,0,0,0,7865,7867,1,0,0,0,7866,7868,3,120,
  	60,0,7867,7866,1,0,0,0,7867,7868,1,0,0,0,7868,7869,1,0,0,0,7869,7873,
  	3,1144,572,0,7870,7872,3,1150,575,0,7871,7870,1,0,0,0,7872,7875,1,0,0,
  	0,7873,7871,1,0,0,0,7873,7874,1,0,0,0,7874,7889,1,0,0,0,7875,7873,1,0,
  	0,0,7876,7877,5,235,0,0,7877,7879,5,299,0,0,7878,7880,3,1328,664,0,7879,
  	7878,1,0,0,0,7879,7880,1,0,0,0,7880,7881,1,0,0,0,7881,7882,3,1140,570,
  	0,7882,7883,3,1136,568,0,7883,7889,1,0,0,0,7884,7886,3,1114,557,0,7885,
  	7887,3,1116,558,0,7886,7885,1,0,0,0,7886,7887,1,0,0,0,7887,7889,1,0,0,
  	0,7888,7864,1,0,0,0,7888,7876,1,0,0,0,7888,7884,1,0,0,0,7889,7891,1,0,
  	0,0,7890,7816,1,0,0,0,7890,7827,1,0,0,0,7890,7841,1,0,0,0,7890,7856,1,
  	0,0,0,7891,1119,1,0,0,0,7892,7894,5,130,0,0,7893,7895,3,1404,702,0,7894,
  	7893,1,0,0,0,7894,7895,1,0,0,0,7895,1121,1,0,0,0,7896,7932,3,1164,582,
  	0,7897,7899,3,1124,562,0,7898,7897,1,0,0,0,7899,7902,1,0,0,0,7900,7898,
  	1,0,0,0,7900,7901,1,0,0,0,7901,7933,1,0,0,0,7902,7900,1,0,0,0,7903,7905,
  	4,561,210,0,7904,7906,3,1246,623,0,7905,7904,1,0,0,0,7905,7906,1,0,0,
  	0,7906,7909,1,0,0,0,7907,7908,5,245,0,0,7908,7910,5,58,0,0,7909,7907,
  	1,0,0,0,7909,7910,1,0,0,0,7910,7911,1,0,0,0,7911,7912,5,63,0,0,7912,7914,
  	3,1016,508,0,7913,7915,7,131,0,0,7914,7913,1,0,0,0,7914,7915,1,0,0,0,
  	7915,7930,1,0,0,0,7916,7920,4,561,211,0,7917,7919,3,1134,567,0,7918,7917,
  	1,0,0,0,7919,7922,1,0,0,0,7920,7918,1,0,0,0,7920,7921,1,0,0,0,7921,7931,
  	1,0,0,0,7922,7920,1,0,0,0,7923,7927,4,561,212,0,7924,7926,3,1124,562,
  	0,7925,7924,1,0,0,0,7926,7929,1,0,0,0,7927,7925,1,0,0,0,7927,7928,1,0,
  	0,0,7928,7931,1,0,0,0,7929,7927,1,0,0,0,7930,7916,1,0,0,0,7930,7923,1,
  	0,0,0,7931,7933,1,0,0,0,7932,7900,1,0,0,0,7932,7903,1,0,0,0,7933,1123,
  	1,0,0,0,7934,7936,5,401,0,0,7935,7934,1,0,0,0,7935,7936,1,0,0,0,7936,
  	7937,1,0,0,0,7937,7997,3,1452,726,0,7938,7939,4,562,213,0,7939,7940,5,
  	401,0,0,7940,7997,5,745,0,0,7941,7945,5,168,0,0,7942,7946,3,1132,566,
  	0,7943,7944,4,562,214,0,7944,7946,3,1016,508,0,7945,7942,1,0,0,0,7945,
  	7943,1,0,0,0,7946,7997,1,0,0,0,7947,7948,5,413,0,0,7948,7949,5,640,0,
  	0,7949,7951,5,402,0,0,7950,7952,3,962,481,0,7951,7950,1,0,0,0,7951,7952,
  	1,0,0,0,7952,7997,1,0,0,0,7953,7997,5,69,0,0,7954,7955,5,528,0,0,7955,
  	7956,5,168,0,0,7956,7997,5,653,0,0,7957,7959,5,450,0,0,7958,7957,1,0,
  	0,0,7958,7959,1,0,0,0,7959,7960,1,0,0,0,7960,7997,5,299,0,0,7961,7963,
  	5,635,0,0,7962,7964,5,299,0,0,7963,7962,1,0,0,0,7963,7964,1,0,0,0,7964,
  	7997,1,0,0,0,7965,7966,5,119,0,0,7966,7997,3,1442,721,0,7967,7997,3,1246,
  	623,0,7968,7969,5,118,0,0,7969,7997,3,1126,563,0,7970,7971,5,579,0,0,
  	7971,7997,3,1128,564,0,7972,7973,4,562,215,0,7973,7974,5,732,0,0,7974,
  	7997,3,1422,711,0,7975,7977,4,562,216,0,7976,7978,3,1120,560,0,7977,7976,
  	1,0,0,0,7977,7978,1,0,0,0,7978,7979,1,0,0,0,7979,7997,3,1114,557,0,7980,
  	7981,4,562,217,0,7981,7997,3,1116,558,0,7982,7983,4,562,218,0,7983,7985,
  	5,774,0,0,7984,7986,5,6,0,0,7985,7984,1,0,0,0,7985,7986,1,0,0,0,7986,
  	7987,1,0,0,0,7987,7997,3,1482,741,0,7988,7989,4,562,219,0,7989,7991,5,
  	775,0,0,7990,7992,5,6,0,0,7991,7990,1,0,0,0,7991,7992,1,0,0,0,7992,7993,
  	1,0,0,0,7993,7997,3,1482,741,0,7994,7995,4,562,220,0,7995,7997,3,1154,
  	577,0,7996,7935,1,0,0,0,7996,7938,1,0,0,0,7996,7941,1,0,0,0,7996,7947,
  	1,0,0,0,7996,7953,1,0,0,0,7996,7954,1,0,0,0,7996,7958,1,0,0,0,7996,7961,
  	1,0,0,0,7996,7965,1,0,0,0,7996,7967,1,0,0,0,7996,7968,1,0,0,0,7996,7970,
  	1,0,0,0,7996,7972,1,0,0,0,7996,7975,1,0,0,0,7996,7980,1,0,0,0,7996,7982,
  	1,0,0,0,7996,7988,1,0,0,0,7996,7994,1,0,0,0,7997,1125,1,0,0,0,7998,7999,
  	7,132,0,0,7999,1127,1,0,0,0,8000,8001,7,133,0,0,8001,1129,1,0,0,0,8002,
  	8003,5,402,0,0,8003,8004,3,1184,592,0,8004,1131,1,0,0,0,8005,8008,3,1130,
  	565,0,8006,8008,3,1426,713,0,8007,8005,1,0,0,0,8007,8006,1,0,0,0,8008,
  	1133,1,0,0,0,8009,8011,5,635,0,0,8010,8012,5,299,0,0,8011,8010,1,0,0,
  	0,8011,8012,1,0,0,0,8012,8024,1,0,0,0,8013,8014,5,119,0,0,8014,8024,3,
  	1438,719,0,8015,8017,3,1006,503,0,8016,8015,1,0,0,0,8016,8017,1,0,0,0,
  	8017,8018,1,0,0,0,8018,8024,5,406,0,0,8019,8021,5,450,0,0,8020,8019,1,
  	0,0,0,8020,8021,1,0,0,0,8021,8022,1,0,0,0,8022,8024,5,299,0,0,8023,8009,
  	1,0,0,0,8023,8013,1,0,0,0,8023,8016,1,0,0,0,8023,8020,1,0,0,0,8024,1135,
  	1,0,0,0,8025,8026,5,473,0,0,8026,8028,3,1380,690,0,8027,8029,3,1408,704,
  	0,8028,8027,1,0,0,0,8028,8029,1,0,0,0,8029,8032,1,0,0,0,8030,8031,5,352,
  	0,0,8031,8033,7,134,0,0,8032,8030,1,0,0,0,8032,8033,1,0,0,0,8033,8050,
  	1,0,0,0,8034,8035,5,413,0,0,8035,8036,5,640,0,0,8036,8040,3,1138,569,
  	0,8037,8038,5,413,0,0,8038,8039,5,173,0,0,8039,8041,3,1138,569,0,8040,
  	8037,1,0,0,0,8040,8041,1,0,0,0,8041,8051,1,0,0,0,8042,8043,5,413,0,0,
  	8043,8044,5,173,0,0,8044,8048,3,1138,569,0,8045,8046,5,413,0,0,8046,8047,
  	5,640,0,0,8047,8049,3,1138,569,0,8048,8045,1,0,0,0,8048,8049,1,0,0,0,
  	8049,8051,1,0,0,0,8050,8034,1,0,0,0,8050,8042,1,0,0,0,8050,8051,1,0,0,
  	0,8051,1137,1,0,0,0,8052,8060,7,2,0,0,8053,8054,5,533,0,0,8054,8060,3,
  	1452,726,0,8055,8056,5,533,0,0,8056,8060,5,168,0,0,8057,8058,5,403,0,
  	0,8058,8060,5,49,0,0,8059,8052,1,0,0,0,8059,8053,1,0,0,0,8059,8055,1,
  	0,0,0,8059,8057,1,0,0,0,8060,1139,1,0,0,0,8061,8062,5,32,0,0,8062,8067,
  	3,1142,571,0,8063,8064,5,29,0,0,8064,8066,3,1142,571,0,8065,8063,1,0,
  	0,0,8066,8069,1,0,0,0,8067,8065,1,0,0,0,8067,8068,1,0,0,0,8068,8070,1,
  	0,0,0,8069,8067,1,0,0,0,8070,8071,5,33,0,0,8071,1141,1,0,0,0,8072,8074,
  	3,1404,702,0,8073,8075,3,1170,585,0,8074,8073,1,0,0,0,8074,8075,1,0,0,
  	0,8075,8077,1,0,0,0,8076,8078,3,362,181,0,8077,8076,1,0,0,0,8077,8078,
  	1,0,0,0,8078,1143,1,0,0,0,8079,8080,5,32,0,0,8080,8085,3,1146,573,0,8081,
  	8082,5,29,0,0,8082,8084,3,1146,573,0,8083,8081,1,0,0,0,8084,8087,1,0,
  	0,0,8085,8083,1,0,0,0,8085,8086,1,0,0,0,8086,8088,1,0,0,0,8087,8085,1,
  	0,0,0,8088,8089,5,33,0,0,8089,1145,1,0,0,0,8090,8097,3,1142,571,0,8091,
  	8092,4,573,221,0,8092,8094,3,1016,508,0,8093,8095,3,362,181,0,8094,8093,
  	1,0,0,0,8094,8095,1,0,0,0,8095,8097,1,0,0,0,8096,8090,1,0,0,0,8096,8091,
  	1,0,0,0,8097,1147,1,0,0,0,8098,8099,7,135,0,0,8099,1149,1,0,0,0,8100,
  	8103,3,1152,576,0,8101,8103,3,1156,578,0,8102,8100,1,0,0,0,8102,8101,
  	1,0,0,0,8103,1151,1,0,0,0,8104,8106,5,298,0,0,8105,8107,5,6,0,0,8106,
  	8105,1,0,0,0,8106,8107,1,0,0,0,8107,8108,1,0,0,0,8108,8126,3,1416,708,
  	0,8109,8110,5,119,0,0,8110,8126,3,1442,721,0,8111,8112,4,576,222,0,8112,
  	8126,3,1154,577,0,8113,8114,4,576,223,0,8114,8116,5,774,0,0,8115,8117,
  	5,6,0,0,8116,8115,1,0,0,0,8116,8117,1,0,0,0,8117,8118,1,0,0,0,8118,8126,
  	3,1482,741,0,8119,8120,4,576,224,0,8120,8122,5,775,0,0,8121,8123,5,6,
  	0,0,8122,8121,1,0,0,0,8122,8123,1,0,0,0,8123,8124,1,0,0,0,8124,8126,3,
  	1482,741,0,8125,8104,1,0,0,0,8125,8109,1,0,0,0,8125,8111,1,0,0,0,8125,
  	8113,1,0,0,0,8125,8119,1,0,0,0,8126,1153,1,0,0,0,8127,8128,7,136,0,0,
  	8128,1155,1,0,0,0,8129,8130,7,137,0,0,8130,8131,3,1148,574,0,8131,1157,
  	1,0,0,0,8132,8137,3,1152,576,0,8133,8134,5,670,0,0,8134,8135,5,431,0,
  	0,8135,8137,3,1404,702,0,8136,8132,1,0,0,0,8136,8133,1,0,0,0,8137,1159,
  	1,0,0,0,8138,8139,3,1152,576,0,8139,1161,1,0,0,0,8140,8141,3,1164,582,
  	0,8141,8142,5,0,0,1,8142,1163,1,0,0,0,8143,8145,7,138,0,0,8144,8146,3,
  	1170,585,0,8145,8144,1,0,0,0,8145,8146,1,0,0,0,8146,8148,1,0,0,0,8147,
  	8149,3,1172,586,0,8148,8147,1,0,0,0,8148,8149,1,0,0,0,8149,8291,1,0,0,
  	0,8150,8156,5,467,0,0,8151,8153,5,185,0,0,8152,8154,5,446,0,0,8153,8152,
  	1,0,0,0,8153,8154,1,0,0,0,8154,8156,1,0,0,0,8155,8150,1,0,0,0,8155,8151,
  	1,0,0,0,8156,8158,1,0,0,0,8157,8159,3,1462,731,0,8158,8157,1,0,0,0,8158,
  	8159,1,0,0,0,8159,8161,1,0,0,0,8160,8162,3,1172,586,0,8161,8160,1,0,0,
  	0,8161,8162,1,0,0,0,8162,8291,1,0,0,0,8163,8165,7,139,0,0,8164,8166,3,
  	1458,729,0,8165,8164,1,0,0,0,8165,8166,1,0,0,0,8166,8168,1,0,0,0,8167,
  	8169,3,1172,586,0,8168,8167,1,0,0,0,8168,8169,1,0,0,0,8169,8291,1,0,0,
  	0,8170,8172,5,82,0,0,8171,8173,3,1170,585,0,8172,8171,1,0,0,0,8172,8173,
  	1,0,0,0,8173,8291,1,0,0,0,8174,8291,7,140,0,0,8175,8177,5,104,0,0,8176,
  	8178,3,1170,585,0,8177,8176,1,0,0,0,8177,8178,1,0,0,0,8178,8180,1,0,0,
  	0,8179,8181,3,1174,587,0,8180,8179,1,0,0,0,8180,8181,1,0,0,0,8181,8291,
  	1,0,0,0,8182,8184,3,1166,583,0,8183,8185,3,1170,585,0,8184,8183,1,0,0,
  	0,8184,8185,1,0,0,0,8185,8187,1,0,0,0,8186,8188,5,77,0,0,8187,8186,1,
  	0,0,0,8187,8188,1,0,0,0,8188,8291,1,0,0,0,8189,8191,5,77,0,0,8190,8192,
  	3,1170,585,0,8191,8190,1,0,0,0,8191,8192,1,0,0,0,8192,8291,1,0,0,0,8193,
  	8194,5,104,0,0,8194,8197,5,658,0,0,8195,8197,5,655,0,0,8196,8193,1,0,
  	0,0,8196,8195,1,0,0,0,8197,8198,1,0,0,0,8198,8200,3,1170,585,0,8199,8201,
  	3,1174,587,0,8200,8199,1,0,0,0,8200,8201,1,0,0,0,8201,8291,1,0,0,0,8202,
  	8203,5,389,0,0,8203,8213,5,655,0,0,8204,8213,5,409,0,0,8205,8206,5,392,
  	0,0,8206,8213,5,655,0,0,8207,8208,5,389,0,0,8208,8209,5,104,0,0,8209,
  	8213,5,658,0,0,8210,8211,5,392,0,0,8211,8213,5,658,0,0,8212,8202,1,0,
  	0,0,8212,8204,1,0,0,0,8212,8205,1,0,0,0,8212,8207,1,0,0,0,8212,8210,1,
  	0,0,0,8213,8214,1,0,0,0,8214,8216,3,1170,585,0,8215,8217,5,77,0,0,8216,
  	8215,1,0,0,0,8216,8217,1,0,0,0,8217,8291,1,0,0,0,8218,8219,5,654,0,0,
  	8219,8291,3,1170,585,0,8220,8222,5,681,0,0,8221,8223,3,1170,585,0,8222,
  	8221,1,0,0,0,8222,8223,1,0,0,0,8223,8225,1,0,0,0,8224,8226,3,1172,586,
  	0,8225,8224,1,0,0,0,8225,8226,1,0,0,0,8226,8291,1,0,0,0,8227,8291,5,158,
  	0,0,8228,8230,5,612,0,0,8229,8231,3,1182,591,0,8230,8229,1,0,0,0,8230,
  	8231,1,0,0,0,8231,8291,1,0,0,0,8232,8234,5,609,0,0,8233,8235,3,1182,591,
  	0,8234,8233,1,0,0,0,8234,8235,1,0,0,0,8235,8291,1,0,0,0,8236,8238,5,155,
  	0,0,8237,8239,3,1182,591,0,8238,8237,1,0,0,0,8238,8239,1,0,0,0,8239,8291,
  	1,0,0,0,8240,8291,5,613,0,0,8241,8243,5,84,0,0,8242,8244,3,1170,585,0,
  	8243,8242,1,0,0,0,8243,8244,1,0,0,0,8244,8291,1,0,0,0,8245,8291,7,141,
  	0,0,8246,8247,5,325,0,0,8247,8291,5,654,0,0,8248,8252,5,325,0,0,8249,
  	8250,5,104,0,0,8250,8253,5,658,0,0,8251,8253,5,655,0,0,8252,8249,1,0,
  	0,0,8252,8251,1,0,0,0,8252,8253,1,0,0,0,8253,8255,1,0,0,0,8254,8256,3,
  	1174,587,0,8255,8254,1,0,0,0,8255,8256,1,0,0,0,8256,8291,1,0,0,0,8257,
  	8259,5,615,0,0,8258,8260,3,1174,587,0,8259,8258,1,0,0,0,8259,8260,1,0,
  	0,0,8260,8291,1,0,0,0,8261,8263,5,606,0,0,8262,8264,3,1170,585,0,8263,
  	8262,1,0,0,0,8263,8264,1,0,0,0,8264,8266,1,0,0,0,8265,8267,3,1174,587,
  	0,8266,8265,1,0,0,0,8266,8267,1,0,0,0,8267,8291,1,0,0,0,8268,8270,5,364,
  	0,0,8269,8271,3,1174,587,0,8270,8269,1,0,0,0,8270,8271,1,0,0,0,8271,8291,
  	1,0,0,0,8272,8274,5,323,0,0,8273,8275,3,1174,587,0,8274,8273,1,0,0,0,
  	8274,8275,1,0,0,0,8275,8291,1,0,0,0,8276,8277,5,203,0,0,8277,8279,3,1434,
  	717,0,8278,8280,3,1174,587,0,8279,8278,1,0,0,0,8279,8280,1,0,0,0,8280,
  	8291,1,0,0,0,8281,8282,5,533,0,0,8282,8284,3,1434,717,0,8283,8285,3,1174,
  	587,0,8284,8283,1,0,0,0,8284,8285,1,0,0,0,8285,8291,1,0,0,0,8286,8291,
  	5,528,0,0,8287,8288,4,582,225,0,8288,8291,5,296,0,0,8289,8291,7,142,0,
  	0,8290,8143,1,0,0,0,8290,8155,1,0,0,0,8290,8163,1,0,0,0,8290,8170,1,0,
  	0,0,8290,8174,1,0,0,0,8290,8175,1,0,0,0,8290,8182,1,0,0,0,8290,8189,1,
  	0,0,0,8290,8196,1,0,0,0,8290,8212,1,0,0,0,8290,8218,1,0,0,0,8290,8220,
  	1,0,0,0,8290,8227,1,0,0,0,8290,8228,1,0,0,0,8290,8232,1,0,0,0,8290,8236,
  	1,0,0,0,8290,8240,1,0,0,0,8290,8241,1,0,0,0,8290,8245,1,0,0,0,8290,8246,
  	1,0,0,0,8290,8248,1,0,0,0,8290,8257,1,0,0,0,8290,8261,1,0,0,0,8290,8268,
  	1,0,0,0,8290,8272,1,0,0,0,8290,8276,1,0,0,0,8290,8281,1,0,0,0,8290,8286,
  	1,0,0,0,8290,8287,1,0,0,0,8290,8289,1,0,0,0,8291,1165,1,0,0,0,8292,8296,
  	5,392,0,0,8293,8294,5,389,0,0,8294,8296,5,104,0,0,8295,8292,1,0,0,0,8295,
  	8293,1,0,0,0,8296,1167,1,0,0,0,8297,8303,5,467,0,0,8298,8300,5,185,0,
  	0,8299,8301,5,446,0,0,8300,8299,1,0,0,0,8300,8301,1,0,0,0,8301,8303,1,
  	0,0,0,8302,8297,1,0,0,0,8302,8298,1,0,0,0,8303,1169,1,0,0,0,8304,8307,
  	5,32,0,0,8305,8308,3,1422,711,0,8306,8308,5,45,0,0,8307,8305,1,0,0,0,
  	8307,8306,1,0,0,0,8308,8309,1,0,0,0,8309,8310,5,33,0,0,8310,1171,1,0,
  	0,0,8311,8313,7,143,0,0,8312,8311,1,0,0,0,8313,8314,1,0,0,0,8314,8312,
  	1,0,0,0,8314,8315,1,0,0,0,8315,1173,1,0,0,0,8316,8331,3,1176,588,0,8317,
  	8331,3,1178,589,0,8318,8331,5,91,0,0,8319,8320,3,1004,502,0,8320,8322,
  	3,1186,593,0,8321,8323,5,77,0,0,8322,8321,1,0,0,0,8322,8323,1,0,0,0,8323,
  	8331,1,0,0,0,8324,8328,5,77,0,0,8325,8326,3,1004,502,0,8326,8327,3,1186,
  	593,0,8327,8329,1,0,0,0,8328,8325,1,0,0,0,8328,8329,1,0,0,0,8329,8331,
  	1,0,0,0,8330,8316,1,0,0,0,8330,8317,1,0,0,0,8330,8318,1,0,0,0,8330,8319,
  	1,0,0,0,8330,8324,1,0,0,0,8331,1175,1,0,0,0,8332,8334,5,65,0,0,8333,8335,
  	5,77,0,0,8334,8333,1,0,0,0,8334,8335,1,0,0,0,8335,8339,1,0,0,0,8336,8337,
  	5,77,0,0,8337,8339,5,65,0,0,8338,8332,1,0,0,0,8338,8336,1,0,0,0,8339,
  	1177,1,0,0,0,8340,8342,5,632,0,0,8341,8343,5,77,0,0,8342,8341,1,0,0,0,
  	8342,8343,1,0,0,0,8343,8347,1,0,0,0,8344,8345,5,77,0,0,8345,8347,5,632,
  	0,0,8346,8340,1,0,0,0,8346,8344,1,0,0,0,8347,1179,1,0,0,0,8348,8349,5,
  	32,0,0,8349,8350,3,1418,709,0,8350,8351,5,33,0,0,8351,1181,1,0,0,0,8352,
  	8353,5,32,0,0,8353,8354,5,3,0,0,8354,8355,5,33,0,0,8355,1183,1,0,0,0,
  	8356,8362,1,0,0,0,8357,8362,3,1472,736,0,8358,8359,5,32,0,0,8359,8360,
  	5,3,0,0,8360,8362,5,33,0,0,8361,8356,1,0,0,0,8361,8357,1,0,0,0,8361,8358,
  	1,0,0,0,8362,1185,1,0,0,0,8363,8368,3,1464,732,0,8364,8368,5,77,0,0,8365,
  	8366,4,593,226,0,8366,8368,5,168,0,0,8367,8363,1,0,0,0,8367,8364,1,0,
  	0,0,8367,8365,1,0,0,0,8368,1187,1,0,0,0,8369,8375,3,1464,732,0,8370,8371,
  	4,594,227,0,8371,8375,5,168,0,0,8372,8373,4,594,228,0,8373,8375,5,77,
  	0,0,8374,8369,1,0,0,0,8374,8370,1,0,0,0,8374,8372,1,0,0,0,8375,1189,1,
  	0,0,0,8376,8383,3,1198,599,0,8377,8379,5,29,0,0,8378,8377,1,0,0,0,8378,
  	8379,1,0,0,0,8379,8380,1,0,0,0,8380,8382,3,1198,599,0,8381,8378,1,0,0,
  	0,8382,8385,1,0,0,0,8383,8381,1,0,0,0,8383,8384,1,0,0,0,8384,1191,1,0,
  	0,0,8385,8383,1,0,0,0,8386,8388,3,1190,595,0,8387,8389,3,1194,597,0,8388,
  	8387,1,0,0,0,8388,8389,1,0,0,0,8389,8392,1,0,0,0,8390,8392,3,1194,597,
  	0,8391,8386,1,0,0,0,8391,8390,1,0,0,0,8392,1193,1,0,0,0,8393,8395,3,1208,
  	604,0,8394,8396,3,92,46,0,8395,8394,1,0,0,0,8395,8396,1,0,0,0,8396,8399,
  	1,0,0,0,8397,8399,3,92,46,0,8398,8393,1,0,0,0,8398,8397,1,0,0,0,8399,
  	1195,1,0,0,0,8400,8402,3,1198,599,0,8401,8400,1,0,0,0,8402,8403,1,0,0,
  	0,8403,8401,1,0,0,0,8403,8404,1,0,0,0,8404,1197,1,0,0,0,8405,8407,5,202,
  	0,0,8406,8408,5,6,0,0,8407,8406,1,0,0,0,8407,8408,1,0,0,0,8408,8409,1,
  	0,0,0,8409,8552,3,1372,686,0,8410,8411,4,599,229,0,8411,8413,5,746,0,
  	0,8412,8414,3,1474,737,0,8413,8412,1,0,0,0,8413,8414,1,0,0,0,8414,8417,
  	1,0,0,0,8415,8418,5,406,0,0,8416,8418,3,1464,732,0,8417,8415,1,0,0,0,
  	8417,8416,1,0,0,0,8418,8552,1,0,0,0,8419,8421,5,355,0,0,8420,8422,5,6,
  	0,0,8421,8420,1,0,0,0,8421,8422,1,0,0,0,8422,8423,1,0,0,0,8423,8552,3,
  	1420,710,0,8424,8426,5,375,0,0,8425,8427,5,6,0,0,8426,8425,1,0,0,0,8426,
  	8427,1,0,0,0,8427,8428,1,0,0,0,8428,8552,3,1420,710,0,8429,8431,5,70,
  	0,0,8430,8432,5,6,0,0,8431,8430,1,0,0,0,8431,8432,1,0,0,0,8432,8433,1,
  	0,0,0,8433,8552,3,1420,710,0,8434,8436,5,436,0,0,8435,8437,5,6,0,0,8436,
  	8435,1,0,0,0,8436,8437,1,0,0,0,8437,8438,1,0,0,0,8438,8552,3,1436,718,
  	0,8439,8441,5,119,0,0,8440,8442,5,6,0,0,8441,8440,1,0,0,0,8441,8442,1,
  	0,0,0,8442,8443,1,0,0,0,8443,8552,3,1436,718,0,8444,8445,4,599,230,0,
  	8445,8447,5,125,0,0,8446,8448,5,6,0,0,8447,8446,1,0,0,0,8447,8448,1,0,
  	0,0,8448,8449,1,0,0,0,8449,8552,3,1438,719,0,8450,8451,4,599,231,0,8451,
  	8453,5,197,0,0,8452,8454,5,6,0,0,8453,8452,1,0,0,0,8453,8454,1,0,0,0,
  	8454,8455,1,0,0,0,8455,8552,3,1438,719,0,8456,8458,5,69,0,0,8457,8459,
  	5,6,0,0,8458,8457,1,0,0,0,8458,8459,1,0,0,0,8459,8460,1,0,0,0,8460,8552,
  	3,1420,710,0,8461,8463,5,429,0,0,8462,8464,5,6,0,0,8463,8462,1,0,0,0,
  	8463,8464,1,0,0,0,8464,8465,1,0,0,0,8465,8552,3,1200,600,0,8466,8468,
  	7,144,0,0,8467,8469,5,6,0,0,8468,8467,1,0,0,0,8468,8469,1,0,0,0,8469,
  	8470,1,0,0,0,8470,8552,3,1200,600,0,8471,8473,7,145,0,0,8472,8474,5,6,
  	0,0,8473,8472,1,0,0,0,8473,8474,1,0,0,0,8474,8475,1,0,0,0,8475,8552,3,
  	1416,708,0,8476,8478,5,172,0,0,8477,8479,5,6,0,0,8478,8477,1,0,0,0,8478,
  	8479,1,0,0,0,8479,8480,1,0,0,0,8480,8552,3,1416,708,0,8481,8483,5,515,
  	0,0,8482,8484,5,6,0,0,8483,8482,1,0,0,0,8483,8484,1,0,0,0,8484,8485,1,
  	0,0,0,8485,8552,7,146,0,0,8486,8488,5,634,0,0,8487,8489,5,6,0,0,8488,
  	8487,1,0,0,0,8488,8489,1,0,0,0,8489,8490,1,0,0,0,8490,8491,5,32,0,0,8491,
  	8492,3,1382,691,0,8492,8493,5,33,0,0,8493,8552,1,0,0,0,8494,8552,3,1206,
  	603,0,8495,8552,3,1202,601,0,8496,8498,5,279,0,0,8497,8499,5,6,0,0,8498,
  	8497,1,0,0,0,8498,8499,1,0,0,0,8499,8500,1,0,0,0,8500,8552,7,147,0,0,
  	8501,8502,5,154,0,0,8502,8504,5,179,0,0,8503,8505,5,6,0,0,8504,8503,1,
  	0,0,0,8504,8505,1,0,0,0,8505,8506,1,0,0,0,8506,8552,3,1438,719,0,8507,
  	8508,5,272,0,0,8508,8510,5,179,0,0,8509,8511,5,6,0,0,8510,8509,1,0,0,
  	0,8510,8511,1,0,0,0,8511,8512,1,0,0,0,8512,8552,3,1438,719,0,8513,8519,
  	5,598,0,0,8514,8516,4,599,232,0,8515,8517,5,6,0,0,8516,8515,1,0,0,0,8516,
  	8517,1,0,0,0,8517,8520,1,0,0,0,8518,8520,1,0,0,0,8519,8514,1,0,0,0,8519,
  	8518,1,0,0,0,8520,8521,1,0,0,0,8521,8552,3,1404,702,0,8522,8523,5,579,
  	0,0,8523,8552,7,148,0,0,8524,8526,5,128,0,0,8525,8527,5,6,0,0,8526,8525,
  	1,0,0,0,8526,8527,1,0,0,0,8527,8528,1,0,0,0,8528,8552,3,1438,719,0,8529,
  	8531,5,298,0,0,8530,8532,5,6,0,0,8531,8530,1,0,0,0,8531,8532,1,0,0,0,
  	8532,8533,1,0,0,0,8533,8552,3,1420,710,0,8534,8535,4,599,233,0,8535,8536,
  	5,569,0,0,8536,8552,5,618,0,0,8537,8538,4,599,234,0,8538,8540,5,774,0,
  	0,8539,8541,5,6,0,0,8540,8539,1,0,0,0,8540,8541,1,0,0,0,8541,8542,1,0,
  	0,0,8542,8552,3,1482,741,0,8543,8544,4,599,235,0,8544,8546,5,775,0,0,
  	8545,8547,5,6,0,0,8546,8545,1,0,0,0,8546,8547,1,0,0,0,8547,8548,1,0,0,
  	0,8548,8552,3,1482,741,0,8549,8550,4,599,236,0,8550,8552,3,152,76,0,8551,
  	8405,1,0,0,0,8551,8410,1,0,0,0,8551,8419,1,0,0,0,8551,8424,1,0,0,0,8551,
  	8429,1,0,0,0,8551,8434,1,0,0,0,8551,8439,1,0,0,0,8551,8444,1,0,0,0,8551,
  	8450,1,0,0,0,8551,8456,1,0,0,0,8551,8461,1,0,0,0,8551,8466,1,0,0,0,8551,
  	8471,1,0,0,0,8551,8476,1,0,0,0,8551,8481,1,0,0,0,8551,8486,1,0,0,0,8551,
  	8494,1,0,0,0,8551,8495,1,0,0,0,8551,8496,1,0,0,0,8551,8501,1,0,0,0,8551,
  	8507,1,0,0,0,8551,8513,1,0,0,0,8551,8522,1,0,0,0,8551,8524,1,0,0,0,8551,
  	8529,1,0,0,0,8551,8534,1,0,0,0,8551,8537,1,0,0,0,8551,8543,1,0,0,0,8551,
  	8549,1,0,0,0,8552,1199,1,0,0,0,8553,8556,3,1416,708,0,8554,8556,5,168,
  	0,0,8555,8553,1,0,0,0,8555,8554,1,0,0,0,8556,1201,1,0,0,0,8557,8559,5,
  	168,0,0,8558,8557,1,0,0,0,8558,8559,1,0,0,0,8559,8560,1,0,0,0,8560,8562,
  	5,113,0,0,8561,8563,5,6,0,0,8562,8561,1,0,0,0,8562,8563,1,0,0,0,8563,
  	8564,1,0,0,0,8564,8565,3,1188,594,0,8565,1203,1,0,0,0,8566,8568,5,168,
  	0,0,8567,8566,1,0,0,0,8567,8568,1,0,0,0,8568,8569,1,0,0,0,8569,8571,5,
  	197,0,0,8570,8572,5,6,0,0,8571,8570,1,0,0,0,8571,8572,1,0,0,0,8572,8573,
  	1,0,0,0,8573,8574,3,1436,718,0,8574,1205,1,0,0,0,8575,8577,5,168,0,0,
  	8576,8575,1,0,0,0,8576,8577,1,0,0,0,8577,8578,1,0,0,0,8578,8580,3,1004,
  	502,0,8579,8581,5,6,0,0,8580,8579,1,0,0,0,8580,8581,1,0,0,0,8581,8582,
  	1,0,0,0,8582,8583,3,1186,593,0,8583,1207,1,0,0,0,8584,8585,5,435,0,0,
  	8585,8586,5,90,0,0,8586,8589,3,1210,605,0,8587,8588,5,434,0,0,8588,8590,
  	3,1418,709,0,8589,8587,1,0,0,0,8589,8590,1,0,0,0,8590,8592,1,0,0,0,8591,
  	8593,3,1212,606,0,8592,8591,1,0,0,0,8592,8593,1,0,0,0,8593,8595,1,0,0,
  	0,8594,8596,3,1216,608,0,8595,8594,1,0,0,0,8595,8596,1,0,0,0,8596,1209,
  	1,0,0,0,8597,8599,5,311,0,0,8598,8597,1,0,0,0,8598,8599,1,0,0,0,8599,
  	8600,1,0,0,0,8600,8602,5,299,0,0,8601,8603,3,1214,607,0,8602,8601,1,0,
  	0,0,8602,8603,1,0,0,0,8603,8604,1,0,0,0,8604,8606,5,32,0,0,8605,8607,
  	3,1406,703,0,8606,8605,1,0,0,0,8606,8607,1,0,0,0,8607,8608,1,0,0,0,8608,
  	8631,5,33,0,0,8609,8611,5,311,0,0,8610,8609,1,0,0,0,8610,8611,1,0,0,0,
  	8611,8612,1,0,0,0,8612,8613,5,256,0,0,8613,8614,5,32,0,0,8614,8615,3,
  	916,458,0,8615,8616,5,33,0,0,8616,8631,1,0,0,0,8617,8628,7,149,0,0,8618,
  	8619,5,32,0,0,8619,8620,3,916,458,0,8620,8621,5,33,0,0,8621,8629,1,0,
  	0,0,8622,8623,5,115,0,0,8623,8625,5,32,0,0,8624,8626,3,1406,703,0,8625,
  	8624,1,0,0,0,8625,8626,1,0,0,0,8626,8627,1,0,0,0,8627,8629,5,33,0,0,8628,
  	8618,1,0,0,0,8628,8622,1,0,0,0,8629,8631,1,0,0,0,8630,8598,1,0,0,0,8630,
  	8610,1,0,0,0,8630,8617,1,0,0,0,8631,1211,1,0,0,0,8632,8633,5,587,0,0,
  	8633,8635,5,90,0,0,8634,8636,5,311,0,0,8635,8634,1,0,0,0,8635,8636,1,
  	0,0,0,8636,8647,1,0,0,0,8637,8638,5,256,0,0,8638,8639,5,32,0,0,8639,8640,
  	3,916,458,0,8640,8641,5,33,0,0,8641,8648,1,0,0,0,8642,8644,5,299,0,0,
  	8643,8645,3,1214,607,0,8644,8643,1,0,0,0,8644,8645,1,0,0,0,8645,8646,
  	1,0,0,0,8646,8648,3,1408,704,0,8647,8637,1,0,0,0,8647,8642,1,0,0,0,8648,
  	8651,1,0,0,0,8649,8650,5,586,0,0,8650,8652,3,1418,709,0,8651,8649,1,0,
  	0,0,8651,8652,1,0,0,0,8652,1213,1,0,0,0,8653,8654,5,55,0,0,8654,8655,
  	5,6,0,0,8655,8656,3,1418,709,0,8656,1215,1,0,0,0,8657,8658,5,32,0,0,8658,
  	8663,3,1218,609,0,8659,8660,5,29,0,0,8660,8662,3,1218,609,0,8661,8659,
  	1,0,0,0,8662,8665,1,0,0,0,8663,8661,1,0,0,0,8663,8664,1,0,0,0,8664,8666,
  	1,0,0,0,8665,8663,1,0,0,0,8666,8667,5,33,0,0,8667,1217,1,0,0,0,8668,8669,
  	5,435,0,0,8669,8680,3,1404,702,0,8670,8671,5,652,0,0,8671,8672,5,307,
  	0,0,8672,8675,5,607,0,0,8673,8676,3,1226,613,0,8674,8676,5,361,0,0,8675,
  	8673,1,0,0,0,8675,8674,1,0,0,0,8676,8681,1,0,0,0,8677,8678,5,652,0,0,
  	8678,8679,5,286,0,0,8679,8681,3,1220,610,0,8680,8670,1,0,0,0,8680,8677,
  	1,0,0,0,8680,8681,1,0,0,0,8681,8685,1,0,0,0,8682,8684,3,1222,611,0,8683,
  	8682,1,0,0,0,8684,8687,1,0,0,0,8685,8683,1,0,0,0,8685,8686,1,0,0,0,8686,
  	8699,1,0,0,0,8687,8685,1,0,0,0,8688,8689,5,32,0,0,8689,8694,3,1224,612,
  	0,8690,8691,5,29,0,0,8691,8693,3,1224,612,0,8692,8690,1,0,0,0,8693,8696,
  	1,0,0,0,8694,8692,1,0,0,0,8694,8695,1,0,0,0,8695,8697,1,0,0,0,8696,8694,
  	1,0,0,0,8697,8698,5,33,0,0,8698,8700,1,0,0,0,8699,8688,1,0,0,0,8699,8700,
  	1,0,0,0,8700,1219,1,0,0,0,8701,8714,3,1226,613,0,8702,8703,5,32,0,0,8703,
  	8708,3,1226,613,0,8704,8705,5,29,0,0,8705,8707,3,1226,613,0,8706,8704,
  	1,0,0,0,8707,8710,1,0,0,0,8708,8706,1,0,0,0,8708,8709,1,0,0,0,8709,8711,
  	1,0,0,0,8710,8708,1,0,0,0,8711,8712,5,33,0,0,8712,8714,1,0,0,0,8713,8701,
  	1,0,0,0,8713,8702,1,0,0,0,8714,1221,1,0,0,0,8715,8717,5,598,0,0,8716,
  	8718,5,6,0,0,8717,8716,1,0,0,0,8717,8718,1,0,0,0,8718,8719,1,0,0,0,8719,
  	8750,3,1404,702,0,8720,8722,5,579,0,0,8721,8720,1,0,0,0,8721,8722,1,0,
  	0,0,8722,8723,1,0,0,0,8723,8725,5,202,0,0,8724,8726,5,6,0,0,8725,8724,
  	1,0,0,0,8725,8726,1,0,0,0,8726,8727,1,0,0,0,8727,8750,3,1372,686,0,8728,
  	8730,5,398,0,0,8729,8731,5,6,0,0,8730,8729,1,0,0,0,8730,8731,1,0,0,0,
  	8731,8732,1,0,0,0,8732,8750,3,1418,709,0,8733,8735,7,150,0,0,8734,8736,
  	5,6,0,0,8735,8734,1,0,0,0,8735,8736,1,0,0,0,8736,8737,1,0,0,0,8737,8750,
  	3,1418,709,0,8738,8739,7,151,0,0,8739,8741,5,179,0,0,8740,8742,5,6,0,
  	0,8741,8740,1,0,0,0,8741,8742,1,0,0,0,8742,8743,1,0,0,0,8743,8750,3,1442,
  	721,0,8744,8746,5,119,0,0,8745,8747,5,6,0,0,8746,8745,1,0,0,0,8746,8747,
  	1,0,0,0,8747,8748,1,0,0,0,8748,8750,3,1442,721,0,8749,8715,1,0,0,0,8749,
  	8721,1,0,0,0,8749,8728,1,0,0,0,8749,8733,1,0,0,0,8749,8738,1,0,0,0,8749,
  	8744,1,0,0,0,8750,1223,1,0,0,0,8751,8752,5,587,0,0,8752,8756,3,1464,732,
  	0,8753,8755,3,1222,611,0,8754,8753,1,0,0,0,8755,8758,1,0,0,0,8756,8754,
  	1,0,0,0,8756,8757,1,0,0,0,8757,1225,1,0,0,0,8758,8756,1,0,0,0,8759,8760,
  	5,32,0,0,8760,8765,3,1228,614,0,8761,8762,5,29,0,0,8762,8764,3,1228,614,
  	0,8763,8761,1,0,0,0,8764,8767,1,0,0,0,8765,8763,1,0,0,0,8765,8766,1,0,
  	0,0,8766,8768,1,0,0,0,8767,8765,1,0,0,0,8768,8769,5,33,0,0,8769,1227,
  	1,0,0,0,8770,8773,3,916,458,0,8771,8773,5,361,0,0,8772,8770,1,0,0,0,8772,
  	8771,1,0,0,0,8773,1229,1,0,0,0,8774,8775,5,170,0,0,8775,8776,5,6,0,0,
  	8776,8777,3,1304,652,0,8777,1231,1,0,0,0,8778,8779,5,267,0,0,8779,8780,
  	5,213,0,0,8780,1233,1,0,0,0,8781,8783,3,1232,616,0,8782,8781,1,0,0,0,
  	8782,8783,1,0,0,0,8783,8784,1,0,0,0,8784,8785,3,1236,618,0,8785,1235,
  	1,0,0,0,8786,8794,3,1404,702,0,8787,8791,4,618,237,0,8788,8792,3,1410,
  	705,0,8789,8790,5,168,0,0,8790,8792,3,1414,707,0,8791,8788,1,0,0,0,8791,
  	8789,1,0,0,0,8792,8794,1,0,0,0,8793,8786,1,0,0,0,8793,8787,1,0,0,0,8794,
  	1237,1,0,0,0,8795,8796,5,267,0,0,8796,8797,3,1006,503,0,8797,8798,5,213,
  	0,0,8798,1239,1,0,0,0,8799,8800,5,268,0,0,8800,8801,5,636,0,0,8801,8802,
  	5,644,0,0,8802,1241,1,0,0,0,8803,8805,7,152,0,0,8804,8803,1,0,0,0,8804,
  	8805,1,0,0,0,8805,8806,1,0,0,0,8806,8807,3,1244,622,0,8807,1243,1,0,0,
  	0,8808,8809,3,1386,693,0,8809,8810,3,1248,624,0,8810,1245,1,0,0,0,8811,
  	8812,5,113,0,0,8812,8813,3,1188,594,0,8813,1247,1,0,0,0,8814,8816,3,1164,
  	582,0,8815,8817,3,1246,623,0,8816,8815,1,0,0,0,8816,8817,1,0,0,0,8817,
  	1249,1,0,0,0,8818,8819,5,32,0,0,8819,8820,3,1336,668,0,8820,8821,5,29,
  	0,0,8821,8822,3,1336,668,0,8822,8823,5,33,0,0,8823,1251,1,0,0,0,8824,
  	8829,3,1352,676,0,8825,8826,5,29,0,0,8826,8828,3,1352,676,0,8827,8825,
  	1,0,0,0,8828,8831,1,0,0,0,8829,8827,1,0,0,0,8829,8830,1,0,0,0,8830,1253,
  	1,0,0,0,8831,8829,1,0,0,0,8832,8837,3,1256,628,0,8833,8834,5,29,0,0,8834,
  	8836,3,1256,628,0,8835,8833,1,0,0,0,8836,8839,1,0,0,0,8837,8835,1,0,0,
  	0,8837,8838,1,0,0,0,8838,1255,1,0,0,0,8839,8837,1,0,0,0,8840,8841,3,1324,
  	662,0,8841,8844,5,6,0,0,8842,8845,3,906,453,0,8843,8845,5,168,0,0,8844,
  	8842,1,0,0,0,8844,8843,1,0,0,0,8845,1257,1,0,0,0,8846,8847,3,1004,502,
  	0,8847,8848,3,1186,593,0,8848,1259,1,0,0,0,8849,8851,5,115,0,0,8850,8852,
  	3,1262,631,0,8851,8850,1,0,0,0,8852,8853,1,0,0,0,8853,8851,1,0,0,0,8853,
  	8854,1,0,0,0,8854,1261,1,0,0,0,8855,8856,5,605,0,0,8856,8857,5,90,0,0,
  	8857,8868,3,1438,719,0,8858,8860,5,422,0,0,8859,8858,1,0,0,0,8859,8860,
  	1,0,0,0,8860,8861,1,0,0,0,8861,8862,5,196,0,0,8862,8863,5,90,0,0,8863,
  	8868,3,1438,719,0,8864,8865,5,206,0,0,8865,8866,5,90,0,0,8866,8868,3,
  	1438,719,0,8867,8855,1,0,0,0,8867,8859,1,0,0,0,8867,8864,1,0,0,0,8868,
  	1263,1,0,0,0,8869,8871,5,312,0,0,8870,8872,3,1266,633,0,8871,8870,1,0,
  	0,0,8872,8873,1,0,0,0,8873,8871,1,0,0,0,8873,8874,1,0,0,0,8874,1265,1,
  	0,0,0,8875,8876,7,153,0,0,8876,8877,5,90,0,0,8877,8878,3,1438,719,0,8878,
  	1267,1,0,0,0,8879,8884,3,1304,652,0,8880,8881,5,29,0,0,8881,8883,3,1304,
  	652,0,8882,8880,1,0,0,0,8883,8886,1,0,0,0,8884,8882,1,0,0,0,8884,8885,
  	1,0,0,0,8885,1269,1,0,0,0,8886,8884,1,0,0,0,8887,8892,3,1272,636,0,8888,
  	8889,5,29,0,0,8889,8891,3,1272,636,0,8890,8888,1,0,0,0,8891,8894,1,0,
  	0,0,8892,8890,1,0,0,0,8892,8893,1,0,0,0,8893,1271,1,0,0,0,8894,8892,1,
  	0,0,0,8895,8908,3,1304,652,0,8896,8899,3,1276,638,0,8897,8898,4,636,238,
  	0,8898,8900,3,1274,637,0,8899,8897,1,0,0,0,8899,8900,1,0,0,0,8900,8909,
  	1,0,0,0,8901,8904,3,1282,641,0,8902,8903,4,636,239,0,8903,8905,3,1290,
  	645,0,8904,8902,1,0,0,0,8904,8905,1,0,0,0,8905,8909,1,0,0,0,8906,8907,
  	4,636,240,0,8907,8909,3,1274,637,0,8908,8896,1,0,0,0,8908,8901,1,0,0,
  	0,8908,8906,1,0,0,0,8908,8909,1,0,0,0,8909,1273,1,0,0,0,8910,8911,5,61,
  	0,0,8911,8914,3,1276,638,0,8912,8913,5,61,0,0,8913,8915,3,1276,638,0,
  	8914,8912,1,0,0,0,8914,8915,1,0,0,0,8915,1275,1,0,0,0,8916,8926,3,1278,
  	639,0,8917,8918,4,638,241,0,8918,8926,3,1280,640,0,8919,8926,3,1282,641,
  	0,8920,8926,3,1284,642,0,8921,8922,4,638,242,0,8922,8926,3,1286,643,0,
  	8923,8924,4,638,243,0,8924,8926,3,1288,644,0,8925,8916,1,0,0,0,8925,8917,
  	1,0,0,0,8925,8919,1,0,0,0,8925,8920,1,0,0,0,8925,8921,1,0,0,0,8925,8923,
  	1,0,0,0,8926,1277,1,0,0,0,8927,8928,5,266,0,0,8928,8931,5,90,0,0,8929,
  	8930,4,639,244,0,8930,8932,5,436,0,0,8931,8929,1,0,0,0,8931,8932,1,0,
  	0,0,8932,8933,1,0,0,0,8933,8934,3,1436,718,0,8934,1279,1,0,0,0,8935,8936,
  	5,266,0,0,8936,8937,5,90,0,0,8937,8938,5,759,0,0,8938,8939,5,436,0,0,
  	8939,1281,1,0,0,0,8940,8941,5,266,0,0,8941,8942,5,670,0,0,8942,8943,3,
  	1464,732,0,8943,1283,1,0,0,0,8944,8945,5,266,0,0,8945,8946,5,670,0,0,
  	8946,8947,3,1464,732,0,8947,8948,5,63,0,0,8948,8949,3,1440,720,0,8949,
  	1285,1,0,0,0,8950,8951,5,266,0,0,8951,8952,5,670,0,0,8952,8953,3,1464,
  	732,0,8953,8954,5,90,0,0,8954,8955,3,1436,718,0,8955,1287,1,0,0,0,8956,
  	8957,5,266,0,0,8957,8958,5,670,0,0,8958,8959,3,1464,732,0,8959,8960,5,
  	90,0,0,8960,8961,5,759,0,0,8961,8962,5,436,0,0,8962,1289,1,0,0,0,8963,
  	8964,5,817,0,0,8964,8968,5,811,0,0,8965,8969,3,1280,640,0,8966,8969,3,
  	1284,642,0,8967,8969,3,1278,639,0,8968,8965,1,0,0,0,8968,8966,1,0,0,0,
  	8968,8967,1,0,0,0,8969,1291,1,0,0,0,8970,8971,5,752,0,0,8971,8972,5,144,
  	0,0,8972,8973,5,436,0,0,8973,1293,1,0,0,0,8974,8975,5,181,0,0,8975,8976,
  	5,753,0,0,8976,8977,5,436,0,0,8977,1295,1,0,0,0,8978,8979,3,1298,649,
  	0,8979,8980,5,814,0,0,8980,8981,5,815,0,0,8981,8994,1,0,0,0,8982,8983,
  	3,1298,649,0,8983,8984,5,816,0,0,8984,8994,1,0,0,0,8985,8986,3,1298,649,
  	0,8986,8987,5,813,0,0,8987,8988,5,815,0,0,8988,8989,5,533,0,0,8989,8990,
  	5,818,0,0,8990,8991,5,63,0,0,8991,8992,3,1440,720,0,8992,8994,1,0,0,0,
  	8993,8978,1,0,0,0,8993,8982,1,0,0,0,8993,8985,1,0,0,0,8994,1297,1,0,0,
  	0,8995,8996,3,1448,724,0,8996,8997,5,812,0,0,8997,1299,1,0,0,0,8998,8999,
  	5,488,0,0,8999,9000,3,1438,719,0,9000,1301,1,0,0,0,9001,9007,3,1464,732,
  	0,9002,9005,5,39,0,0,9003,9006,3,1464,732,0,9004,9006,5,850,0,0,9005,
  	9003,1,0,0,0,9005,9004,1,0,0,0,9006,9008,1,0,0,0,9007,9002,1,0,0,0,9007,
  	9008,1,0,0,0,9008,1303,1,0,0,0,9009,9015,3,1302,651,0,9010,9012,5,147,
  	0,0,9011,9013,3,1472,736,0,9012,9011,1,0,0,0,9012,9013,1,0,0,0,9013,9015,
  	1,0,0,0,9014,9009,1,0,0,0,9014,9010,1,0,0,0,9015,1305,1,0,0,0,9016,9017,
  	5,309,0,0,9017,9018,3,1436,718,0,9018,1307,1,0,0,0,9019,9022,3,1306,653,
  	0,9020,9022,3,390,195,0,9021,9019,1,0,0,0,9021,9020,1,0,0,0,9022,1309,
  	1,0,0,0,9023,9024,7,154,0,0,9024,1311,1,0,0,0,9025,9026,7,155,0,0,9026,
  	1313,1,0,0,0,9027,9028,5,435,0,0,9028,9029,3,1408,704,0,9029,1315,1,0,
  	0,0,9030,9036,3,1414,707,0,9031,9033,3,1410,705,0,9032,9034,3,1414,707,
  	0,9033,9032,1,0,0,0,9033,9034,1,0,0,0,9034,9036,1,0,0,0,9035,9030,1,0,
  	0,0,9035,9031,1,0,0,0,9036,1317,1,0,0,0,9037,9038,4,659,245,0,9038,9042,
  	3,1404,702,0,9039,9040,4,659,246,0,9040,9042,3,1316,658,0,9041,9037,1,
  	0,0,0,9041,9039,1,0,0,0,9042,1319,1,0,0,0,9043,9044,3,1404,702,0,9044,
  	1321,1,0,0,0,9045,9046,5,32,0,0,9046,9051,3,1320,660,0,9047,9048,5,29,
  	0,0,9048,9050,3,1320,660,0,9049,9047,1,0,0,0,9050,9053,1,0,0,0,9051,9049,
  	1,0,0,0,9051,9052,1,0,0,0,9052,9054,1,0,0,0,9053,9051,1,0,0,0,9054,9055,
  	5,33,0,0,9055,1323,1,0,0,0,9056,9057,3,1316,658,0,9057,1325,1,0,0,0,9058,
  	9061,3,1324,662,0,9059,9061,3,1332,666,0,9060,9058,1,0,0,0,9060,9059,
  	1,0,0,0,9061,1327,1,0,0,0,9062,9063,3,1404,702,0,9063,1329,1,0,0,0,9064,
  	9065,3,1316,658,0,9065,1331,1,0,0,0,9066,9067,3,1404,702,0,9067,9071,
  	5,28,0,0,9068,9069,3,1404,702,0,9069,9070,5,28,0,0,9070,9072,1,0,0,0,
  	9071,9068,1,0,0,0,9071,9072,1,0,0,0,9072,9073,1,0,0,0,9073,9074,5,16,
  	0,0,9074,1333,1,0,0,0,9075,9076,3,1404,702,0,9076,1335,1,0,0,0,9077,9078,
  	3,1404,702,0,9078,1337,1,0,0,0,9079,9080,3,1410,705,0,9080,1339,1,0,0,
  	0,9081,9082,3,1410,705,0,9082,1341,1,0,0,0,9083,9084,3,1410,705,0,9084,
  	1343,1,0,0,0,9085,9086,3,1410,705,0,9086,1345,1,0,0,0,9087,9088,3,1410,
  	705,0,9088,1347,1,0,0,0,9089,9090,3,1410,705,0,9090,1349,1,0,0,0,9091,
  	9094,3,1410,705,0,9092,9094,3,1414,707,0,9093,9091,1,0,0,0,9093,9092,
  	1,0,0,0,9094,1351,1,0,0,0,9095,9098,3,1410,705,0,9096,9098,3,1414,707,
  	0,9097,9095,1,0,0,0,9097,9096,1,0,0,0,9098,1353,1,0,0,0,9099,9100,3,1404,
  	702,0,9100,1355,1,0,0,0,9101,9102,3,1404,702,0,9102,1357,1,0,0,0,9103,
  	9104,3,1404,702,0,9104,1359,1,0,0,0,9105,9106,3,1404,702,0,9106,1361,
  	1,0,0,0,9107,9108,3,1410,705,0,9108,1363,1,0,0,0,9109,9110,3,1410,705,
  	0,9110,1365,1,0,0,0,9111,9112,3,1404,702,0,9112,1367,1,0,0,0,9113,9114,
  	3,1464,732,0,9114,1369,1,0,0,0,9115,9116,3,1464,732,0,9116,1371,1,0,0,
  	0,9117,9118,3,1464,732,0,9118,1373,1,0,0,0,9119,9122,3,1410,705,0,9120,
  	9122,3,1414,707,0,9121,9119,1,0,0,0,9121,9120,1,0,0,0,9122,1375,1,0,0,
  	0,9123,9124,3,1336,668,0,9124,9125,3,1414,707,0,9125,1377,1,0,0,0,9126,
  	9134,3,1404,702,0,9127,9128,5,28,0,0,9128,9135,5,16,0,0,9129,9132,3,1414,
  	707,0,9130,9131,5,28,0,0,9131,9133,5,16,0,0,9132,9130,1,0,0,0,9132,9133,
  	1,0,0,0,9133,9135,1,0,0,0,9134,9127,1,0,0,0,9134,9129,1,0,0,0,9134,9135,
  	1,0,0,0,9135,1379,1,0,0,0,9136,9139,3,1410,705,0,9137,9139,3,1414,707,
  	0,9138,9136,1,0,0,0,9138,9137,1,0,0,0,9139,1381,1,0,0,0,9140,9145,3,1380,
  	690,0,9141,9142,5,29,0,0,9142,9144,3,1380,690,0,9143,9141,1,0,0,0,9144,
  	9147,1,0,0,0,9145,9143,1,0,0,0,9145,9146,1,0,0,0,9146,1383,1,0,0,0,9147,
  	9145,1,0,0,0,9148,9153,3,1378,689,0,9149,9150,5,29,0,0,9150,9152,3,1378,
  	689,0,9151,9149,1,0,0,0,9152,9155,1,0,0,0,9153,9151,1,0,0,0,9153,9154,
  	1,0,0,0,9154,1385,1,0,0,0,9155,9153,1,0,0,0,9156,9157,3,1404,702,0,9157,
  	1387,1,0,0,0,9158,9161,3,1402,701,0,9159,9161,3,1490,745,0,9160,9158,
  	1,0,0,0,9160,9159,1,0,0,0,9161,1389,1,0,0,0,9162,9163,3,1388,694,0,9163,
  	1391,1,0,0,0,9164,9167,3,1402,701,0,9165,9167,3,1496,748,0,9166,9164,
  	1,0,0,0,9166,9165,1,0,0,0,9167,1393,1,0,0,0,9168,9169,3,1404,702,0,9169,
  	1395,1,0,0,0,9170,9171,3,1436,718,0,9171,1397,1,0,0,0,9172,9173,3,1404,
  	702,0,9173,1399,1,0,0,0,9174,9175,3,1404,702,0,9175,1401,1,0,0,0,9176,
  	9180,7,156,0,0,9177,9178,4,701,247,0,9178,9180,5,840,0,0,9179,9176,1,
  	0,0,0,9179,9177,1,0,0,0,9180,1403,1,0,0,0,9181,9184,3,1402,701,0,9182,
  	9184,3,1484,742,0,9183,9181,1,0,0,0,9183,9182,1,0,0,0,9184,1405,1,0,0,
  	0,9185,9190,3,1404,702,0,9186,9187,5,29,0,0,9187,9189,3,1404,702,0,9188,
  	9186,1,0,0,0,9189,9192,1,0,0,0,9190,9188,1,0,0,0,9190,9191,1,0,0,0,9191,
  	1407,1,0,0,0,9192,9190,1,0,0,0,9193,9194,5,32,0,0,9194,9195,3,1406,703,
  	0,9195,9196,5,33,0,0,9196,1409,1,0,0,0,9197,9199,3,1404,702,0,9198,9200,
  	3,1414,707,0,9199,9198,1,0,0,0,9199,9200,1,0,0,0,9200,1411,1,0,0,0,9201,
  	9206,3,1404,702,0,9202,9204,3,1414,707,0,9203,9205,3,1414,707,0,9204,
  	9203,1,0,0,0,9204,9205,1,0,0,0,9205,9207,1,0,0,0,9206,9202,1,0,0,0,9206,
  	9207,1,0,0,0,9207,9213,1,0,0,0,9208,9209,4,706,248,0,9209,9210,3,1414,
  	707,0,9210,9211,3,1414,707,0,9211,9213,1,0,0,0,9212,9201,1,0,0,0,9212,
  	9208,1,0,0,0,9213,1413,1,0,0,0,9214,9215,5,28,0,0,9215,9216,3,1404,702,
  	0,9216,1415,1,0,0,0,9217,9218,7,157,0,0,9218,1417,1,0,0,0,9219,9220,7,
  	158,0,0,9220,1419,1,0,0,0,9221,9222,7,159,0,0,9222,1421,1,0,0,0,9223,
  	9229,5,3,0,0,9224,9225,4,711,249,0,9225,9229,5,43,0,0,9226,9229,5,5,0,
  	0,9227,9229,5,4,0,0,9228,9223,1,0,0,0,9228,9224,1,0,0,0,9228,9226,1,0,
  	0,0,9228,9227,1,0,0,0,9229,1423,1,0,0,0,9230,9236,3,1428,714,0,9231,9232,
  	5,14,0,0,9232,9236,3,1416,708,0,9233,9234,5,15,0,0,9234,9236,3,1416,708,
  	0,9235,9230,1,0,0,0,9235,9231,1,0,0,0,9235,9233,1,0,0,0,9236,1425,1,0,
  	0,0,9237,9241,3,1424,712,0,9238,9239,4,713,250,0,9239,9241,3,1432,716,
  	0,9240,9237,1,0,0,0,9240,9238,1,0,0,0,9241,1427,1,0,0,0,9242,9252,3,1442,
  	721,0,9243,9252,3,1448,724,0,9244,9252,3,1456,728,0,9245,9252,3,1452,
  	726,0,9246,9252,3,1450,725,0,9247,9249,5,836,0,0,9248,9247,1,0,0,0,9248,
  	9249,1,0,0,0,9249,9250,1,0,0,0,9250,9252,7,160,0,0,9251,9242,1,0,0,0,
  	9251,9243,1,0,0,0,9251,9244,1,0,0,0,9251,9245,1,0,0,0,9251,9246,1,0,0,
  	0,9251,9248,1,0,0,0,9252,1429,1,0,0,0,9253,9257,3,1428,714,0,9254,9255,
  	4,715,251,0,9255,9257,3,1432,716,0,9256,9253,1,0,0,0,9256,9254,1,0,0,
  	0,9257,1431,1,0,0,0,9258,9259,5,406,0,0,9259,1433,1,0,0,0,9260,9261,5,
  	32,0,0,9261,9266,3,1438,719,0,9262,9263,5,29,0,0,9263,9265,3,1438,719,
  	0,9264,9262,1,0,0,0,9265,9268,1,0,0,0,9266,9264,1,0,0,0,9266,9267,1,0,
  	0,0,9267,9269,1,0,0,0,9268,9266,1,0,0,0,9269,9270,5,33,0,0,9270,1435,
  	1,0,0,0,9271,9275,5,841,0,0,9272,9273,4,718,252,0,9273,9275,5,840,0,0,
  	9274,9271,1,0,0,0,9274,9272,1,0,0,0,9275,1437,1,0,0,0,9276,9280,3,1436,
  	718,0,9277,9280,5,43,0,0,9278,9280,5,44,0,0,9279,9276,1,0,0,0,9279,9277,
  	1,0,0,0,9279,9278,1,0,0,0,9280,1439,1,0,0,0,9281,9285,3,1436,718,0,9282,
  	9283,4,720,253,0,9283,9285,5,43,0,0,9284,9281,1,0,0,0,9284,9282,1,0,0,
  	0,9285,1441,1,0,0,0,9286,9288,5,836,0,0,9287,9286,1,0,0,0,9287,9288,1,
  	0,0,0,9288,9289,1,0,0,0,9289,9292,3,1436,718,0,9290,9292,5,838,0,0,9291,
  	9287,1,0,0,0,9291,9290,1,0,0,0,9292,9296,1,0,0,0,9293,9295,3,1436,718,
  	0,9294,9293,1,0,0,0,9295,9298,1,0,0,0,9296,9294,1,0,0,0,9296,9297,1,0,
  	0,0,9297,1443,1,0,0,0,9298,9296,1,0,0,0,9299,9300,3,1436,718,0,9300,1445,
  	1,0,0,0,9301,9306,3,1436,718,0,9302,9303,5,29,0,0,9303,9305,3,1436,718,
  	0,9304,9302,1,0,0,0,9305,9308,1,0,0,0,9306,9304,1,0,0,0,9306,9307,1,0,
  	0,0,9307,1447,1,0,0,0,9308,9306,1,0,0,0,9309,9313,3,1454,727,0,9310,9313,
  	5,45,0,0,9311,9313,5,46,0,0,9312,9309,1,0,0,0,9312,9310,1,0,0,0,9312,
  	9311,1,0,0,0,9313,1449,1,0,0,0,9314,9315,7,161,0,0,9315,1451,1,0,0,0,
  	9316,9317,7,162,0,0,9317,1453,1,0,0,0,9318,9319,7,163,0,0,9319,1455,1,
  	0,0,0,9320,9321,5,158,0,0,9321,9327,5,841,0,0,9322,9323,5,612,0,0,9323,
  	9327,5,841,0,0,9324,9325,5,609,0,0,9325,9327,5,841,0,0,9326,9320,1,0,
  	0,0,9326,9322,1,0,0,0,9326,9324,1,0,0,0,9327,1457,1,0,0,0,9328,9331,3,
  	1170,585,0,9329,9331,3,1462,731,0,9330,9328,1,0,0,0,9330,9329,1,0,0,0,
  	9331,1459,1,0,0,0,9332,9333,3,1462,731,0,9333,1461,1,0,0,0,9334,9335,
  	5,32,0,0,9335,9336,5,3,0,0,9336,9337,5,29,0,0,9337,9338,5,3,0,0,9338,
  	9339,5,33,0,0,9339,1463,1,0,0,0,9340,9343,3,1404,702,0,9341,9343,3,1436,
  	718,0,9342,9340,1,0,0,0,9342,9341,1,0,0,0,9343,1465,1,0,0,0,9344,9347,
  	3,1402,701,0,9345,9347,3,1498,749,0,9346,9344,1,0,0,0,9346,9345,1,0,0,
  	0,9347,1467,1,0,0,0,9348,9351,3,1392,696,0,9349,9351,3,1436,718,0,9350,
  	9348,1,0,0,0,9350,9349,1,0,0,0,9351,1469,1,0,0,0,9352,9355,3,1422,711,
  	0,9353,9355,3,1402,701,0,9354,9352,1,0,0,0,9354,9353,1,0,0,0,9355,1471,
  	1,0,0,0,9356,9357,5,32,0,0,9357,9358,5,33,0,0,9358,1473,1,0,0,0,9359,
  	9360,7,164,0,0,9360,1475,1,0,0,0,9361,9362,4,738,254,0,9362,9369,5,683,
  	0,0,9363,9364,4,738,255,0,9364,9369,5,698,0,0,9365,9369,5,250,0,0,9366,
  	9369,5,316,0,0,9367,9369,5,529,0,0,9368,9361,1,0,0,0,9368,9363,1,0,0,
  	0,9368,9365,1,0,0,0,9368,9366,1,0,0,0,9368,9367,1,0,0,0,9369,1477,1,0,
  	0,0,9370,9371,5,250,0,0,9371,9377,5,28,0,0,9372,9373,5,316,0,0,9373,9377,
  	5,28,0,0,9374,9375,5,529,0,0,9375,9377,5,28,0,0,9376,9370,1,0,0,0,9376,
  	9372,1,0,0,0,9376,9374,1,0,0,0,9377,1479,1,0,0,0,9378,9379,4,740,256,
  	0,9379,9386,5,683,0,0,9380,9381,4,740,257,0,9381,9386,5,698,0,0,9382,
  	9386,5,250,0,0,9383,9386,5,316,0,0,9384,9386,5,529,0,0,9385,9378,1,0,
  	0,0,9385,9380,1,0,0,0,9385,9382,1,0,0,0,9385,9383,1,0,0,0,9385,9384,1,
  	0,0,0,9386,9387,1,0,0,0,9387,9388,5,28,0,0,9388,1481,1,0,0,0,9389,9390,
  	3,1436,718,0,9390,1483,1,0,0,0,9391,9399,4,742,258,0,9392,9400,3,1490,
  	745,0,9393,9400,3,1502,751,0,9394,9400,5,212,0,0,9395,9396,4,742,259,
  	0,9396,9400,5,537,0,0,9397,9398,4,742,260,0,9398,9400,5,739,0,0,9399,
  	9392,1,0,0,0,9399,9393,1,0,0,0,9399,9394,1,0,0,0,9399,9395,1,0,0,0,9399,
  	9397,1,0,0,0,9400,9409,1,0,0,0,9401,9407,3,1494,747,0,9402,9407,3,1486,
  	743,0,9403,9407,3,1488,744,0,9404,9407,3,1492,746,0,9405,9407,3,1500,
  	750,0,9406,9401,1,0,0,0,9406,9402,1,0,0,0,9406,9403,1,0,0,0,9406,9404,
  	1,0,0,0,9406,9405,1,0,0,0,9407,9409,1,0,0,0,9408,9391,1,0,0,0,9408,9406,
  	1,0,0,0,9409,1485,1,0,0,0,9410,9411,7,165,0,0,9411,1487,1,0,0,0,9412,
  	9413,7,166,0,0,9413,1489,1,0,0,0,9414,9425,4,745,261,0,9415,9426,3,1504,
  	752,0,9416,9426,5,209,0,0,9417,9426,5,226,0,0,9418,9426,5,399,0,0,9419,
  	9426,5,453,0,0,9420,9426,5,457,0,0,9421,9426,5,481,0,0,9422,9426,5,489,
  	0,0,9423,9426,5,734,0,0,9424,9426,5,591,0,0,9425,9415,1,0,0,0,9425,9416,
  	1,0,0,0,9425,9417,1,0,0,0,9425,9418,1,0,0,0,9425,9419,1,0,0,0,9425,9420,
  	1,0,0,0,9425,9421,1,0,0,0,9425,9422,1,0,0,0,9425,9423,1,0,0,0,9425,9424,
  	1,0,0,0,9426,9433,1,0,0,0,9427,9431,3,1494,747,0,9428,9431,3,1492,746,
  	0,9429,9431,3,1500,750,0,9430,9427,1,0,0,0,9430,9428,1,0,0,0,9430,9429,
  	1,0,0,0,9431,9433,1,0,0,0,9432,9414,1,0,0,0,9432,9430,1,0,0,0,9433,1491,
  	1,0,0,0,9434,9435,7,167,0,0,9435,1493,1,0,0,0,9436,9442,7,168,0,0,9437,
  	9438,4,747,262,0,9438,9442,7,169,0,0,9439,9440,4,747,263,0,9440,9442,
  	7,170,0,0,9441,9436,1,0,0,0,9441,9437,1,0,0,0,9441,9439,1,0,0,0,9442,
  	1495,1,0,0,0,9443,9446,4,748,264,0,9444,9447,3,1504,752,0,9445,9447,3,
  	1502,751,0,9446,9444,1,0,0,0,9446,9445,1,0,0,0,9447,9454,1,0,0,0,9448,
  	9452,3,1494,747,0,9449,9452,3,1488,744,0,9450,9452,3,1500,750,0,9451,
  	9448,1,0,0,0,9451,9449,1,0,0,0,9451,9450,1,0,0,0,9452,9454,1,0,0,0,9453,
  	9443,1,0,0,0,9453,9451,1,0,0,0,9454,1497,1,0,0,0,9455,9460,3,1494,747,
  	0,9456,9460,3,1486,743,0,9457,9460,3,1488,744,0,9458,9460,3,1492,746,
  	0,9459,9455,1,0,0,0,9459,9456,1,0,0,0,9459,9457,1,0,0,0,9459,9458,1,0,
  	0,0,9460,1499,1,0,0,0,9461,9462,7,171,0,0,9462,1501,1,0,0,0,9463,9469,
  	7,172,0,0,9464,9465,4,751,265,0,9465,9469,5,537,0,0,9466,9467,4,751,266,
  	0,9467,9469,5,270,0,0,9468,9463,1,0,0,0,9468,9464,1,0,0,0,9468,9466,1,
  	0,0,0,9469,1503,1,0,0,0,9470,9482,7,173,0,0,9471,9472,4,752,267,0,9472,
  	9482,5,537,0,0,9473,9474,4,752,268,0,9474,9482,7,174,0,0,9475,9476,4,
  	752,269,0,9476,9482,7,175,0,0,9477,9478,4,752,270,0,9478,9482,5,685,0,
  	0,9479,9480,4,752,271,0,9480,9482,5,338,0,0,9481,9470,1,0,0,0,9481,9471,
  	1,0,0,0,9481,9473,1,0,0,0,9481,9475,1,0,0,0,9481,9477,1,0,0,0,9481,9479,
  	1,0,0,0,9482,1505,1,0,0,0,1198,1508,1511,1513,1597,1605,1610,1620,1627,
  	1634,1640,1643,1646,1653,1658,1661,1666,1672,1674,1678,1682,1691,1695,
  	1700,1706,1713,1718,1723,1730,1733,1739,1742,1749,1759,1764,1769,1777,
  	1783,1787,1792,1801,1807,1813,1819,1828,1834,1843,1857,1861,1867,1871,
  	1877,1881,1886,1889,1895,1901,1907,1911,1916,1920,1924,1940,1948,1956,
  	1963,1992,2007,2010,2019,2024,2030,2035,2039,2044,2048,2052,2056,2060,
  	2064,2066,2077,2085,2092,2100,2104,2109,2116,2121,2126,2136,2140,2145,
  	2148,2151,2154,2161,2168,2172,2191,2197,2207,2210,2231,2235,2241,2248,
  	2251,2255,2262,2265,2274,2281,2286,2289,2294,2300,2303,2307,2313,2316,
  	2321,2326,2335,2338,2344,2351,2357,2360,2365,2374,2377,2385,2391,2396,
  	2406,2409,2414,2422,2437,2440,2443,2448,2454,2464,2474,2477,2480,2484,
  	2492,2505,2509,2514,2523,2540,2559,2568,2571,2579,2586,2588,2595,2600,
  	2615,2619,2625,2631,2637,2643,2649,2654,2658,2666,2672,2678,2684,2689,
  	2692,2695,2704,2707,2718,2723,2734,2742,2746,2755,2758,2764,2766,2770,
  	2777,2790,2797,2803,2806,2823,2843,2847,2853,2859,2865,2870,2877,2884,
  	2889,2892,2896,2900,2905,2909,2913,2919,2924,2927,2931,2937,2941,2945,
  	2953,2961,2970,2979,2992,2995,2999,3005,3013,3018,3021,3024,3027,3030,
  	3032,3038,3040,3054,3060,3067,3070,3072,3074,3084,3086,3090,3093,3096,
  	3100,3104,3109,3112,3115,3121,3124,3133,3143,3146,3149,3153,3159,3164,
  	3169,3174,3178,3185,3196,3199,3202,3205,3209,3212,3215,3221,3224,3227,
  	3230,3233,3237,3240,3243,3255,3263,3279,3282,3286,3290,3296,3301,3305,
  	3325,3328,3332,3338,3342,3345,3354,3364,3368,3372,3375,3379,3383,3388,
  	3391,3396,3402,3411,3417,3422,3425,3428,3431,3434,3438,3441,3456,3460,
  	3466,3469,3472,3478,3483,3487,3490,3498,3500,3517,3529,3534,3537,3540,
  	3545,3551,3567,3587,3596,3600,3607,3612,3621,3631,3638,3649,3656,3665,
  	3674,3686,3692,3699,3703,3709,3714,3719,3723,3729,3735,3737,3740,3744,
  	3754,3759,3764,3771,3780,3788,3793,3797,3803,3806,3809,3813,3817,3827,
  	3831,3834,3837,3840,3845,3851,3855,3861,3864,3866,3871,3883,3892,3905,
  	3908,3913,3920,3924,3927,3933,3947,3954,3963,3969,3978,3982,3986,3996,
  	3998,4006,4013,4018,4022,4026,4029,4035,4038,4041,4047,4054,4059,4063,
  	4066,4069,4072,4074,4078,4085,4091,4095,4100,4103,4106,4109,4111,4116,
  	4125,4138,4140,4144,4150,4153,4156,4162,4169,4171,4179,4185,4190,4193,
  	4200,4202,4213,4220,4228,4236,4240,4247,4250,4252,4260,4270,4279,4286,
  	4293,4424,4478,4485,4489,4505,4517,4520,4532,4537,4543,4550,4557,4564,
  	4571,4578,4585,4588,4595,4603,4611,4621,4627,4631,4634,4637,4640,4643,
  	4646,4651,4654,4661,4667,4691,4700,4704,4711,4717,4738,4744,4750,4757,
  	4765,4771,4783,4785,4791,4795,4797,4801,4813,4819,4825,4833,4837,4841,
  	4847,4849,4862,4866,4868,4870,4877,4888,4891,4893,4897,4902,4904,4909,
  	4915,4918,4920,4924,4927,4937,4947,4954,4956,4958,4966,4970,4976,4979,
  	4981,4991,4995,5001,5008,5010,5015,5017,5026,5034,5037,5042,5047,5050,
  	5056,5062,5065,5070,5081,5083,5095,5100,5108,5114,5116,5125,5127,5133,
  	5145,5150,5152,5156,5162,5165,5168,5178,5180,5186,5199,5203,5208,5225,
  	5231,5241,5249,5254,5260,5270,5274,5283,5289,5295,5297,5301,5312,5319,
  	5325,5330,5335,5340,5348,5352,5357,5366,5379,5381,5395,5404,5406,5413,
  	5420,5422,5426,5432,5440,5447,5451,5457,5464,5467,5474,5477,5483,5499,
  	5504,5517,5520,5531,5533,5539,5553,5570,5575,5578,5582,5585,5599,5605,
  	5610,5613,5615,5619,5624,5626,5638,5644,5659,5671,5675,5677,5685,5692,
  	5707,5712,5716,5720,5723,5727,5731,5734,5739,5742,5748,5751,5757,5760,
  	5787,5793,5796,5811,5818,5822,5825,5828,5835,5839,5842,5845,5850,5856,
  	5859,5863,5884,5889,5897,5902,5905,5909,5913,5917,5923,5927,5932,5937,
  	5948,5950,5956,5979,5982,6004,6011,6039,6041,6045,6057,6067,6077,6081,
  	6089,6092,6096,6106,6110,6117,6122,6130,6135,6141,6148,6153,6159,6166,
  	6176,6178,6185,6190,6194,6197,6204,6209,6213,6224,6232,6236,6239,6242,
  	6246,6250,6255,6261,6265,6276,6279,6282,6285,6293,6297,6302,6310,6318,
  	6324,6328,6334,6343,6356,6366,6384,6387,6391,6402,6404,6413,6425,6427,
  	6434,6440,6446,6454,6465,6469,6498,6500,6506,6525,6532,6546,6557,6562,
  	6574,6584,6591,6594,6628,6636,6638,6650,6655,6661,6669,6677,6682,6687,
  	6693,6698,6703,6709,6717,6726,6731,6735,6739,6744,6746,6764,6772,6776,
  	6783,6795,6798,6802,6810,6822,6829,6833,6837,6842,6852,6861,6863,6866,
  	6875,6882,6895,6900,6907,6913,6939,6950,6982,7001,7007,7011,7042,7048,
  	7060,7073,7077,7081,7109,7159,7169,7173,7185,7190,7206,7226,7230,7246,
  	7249,7254,7257,7266,7270,7276,7282,7286,7297,7303,7305,7312,7319,7323,
  	7330,7335,7342,7352,7355,7359,7364,7366,7370,7374,7387,7391,7394,7398,
  	7402,7406,7413,7417,7421,7430,7434,7441,7447,7455,7476,7481,7488,7511,
  	7527,7537,7541,7548,7551,7562,7571,7574,7581,7586,7612,7618,7624,7628,
  	7638,7642,7655,7667,7683,7691,7701,7704,7709,7713,7720,7725,7732,7740,
  	7743,7748,7756,7759,7773,7776,7789,7793,7795,7800,7805,7812,7818,7824,
  	7829,7832,7838,7843,7846,7852,7856,7862,7864,7867,7873,7879,7886,7888,
  	7890,7894,7900,7905,7909,7914,7920,7927,7930,7932,7935,7945,7951,7958,
  	7963,7977,7985,7991,7996,8007,8011,8016,8020,8023,8028,8032,8040,8048,
  	8050,8059,8067,8074,8077,8085,8094,8096,8102,8106,8116,8122,8125,8136,
  	8145,8148,8153,8155,8158,8161,8165,8168,8172,8177,8180,8184,8187,8191,
  	8196,8200,8212,8216,8222,8225,8230,8234,8238,8243,8252,8255,8259,8263,
  	8266,8270,8274,8279,8284,8290,8295,8300,8302,8307,8314,8322,8328,8330,
  	8334,8338,8342,8346,8361,8367,8374,8378,8383,8388,8391,8395,8398,8403,
  	8407,8413,8417,8421,8426,8431,8436,8441,8447,8453,8458,8463,8468,8473,
  	8478,8483,8488,8498,8504,8510,8516,8519,8526,8531,8540,8546,8551,8555,
  	8558,8562,8567,8571,8576,8580,8589,8592,8595,8598,8602,8606,8610,8625,
  	8628,8630,8635,8644,8647,8651,8663,8675,8680,8685,8694,8699,8708,8713,
  	8717,8721,8725,8730,8735,8741,8746,8749,8756,8765,8772,8782,8791,8793,
  	8804,8816,8829,8837,8844,8853,8859,8867,8873,8884,8892,8899,8904,8908,
  	8914,8925,8931,8968,8993,9005,9007,9012,9014,9021,9033,9035,9041,9051,
  	9060,9071,9093,9097,9121,9132,9134,9138,9145,9153,9160,9166,9179,9183,
  	9190,9199,9204,9206,9212,9228,9235,9240,9248,9251,9256,9266,9274,9279,
  	9284,9287,9291,9296,9306,9312,9326,9330,9342,9346,9350,9354,9368,9376,
  	9385,9399,9406,9408,9425,9430,9432,9441,9446,9451,9453,9459,9468,9481
  };
  staticData->serializedATN = antlr4::atn::SerializedATNView(serializedATNSegment, sizeof(serializedATNSegment) / sizeof(serializedATNSegment[0]));

  antlr4::atn::ATNDeserializer deserializer;
  staticData->atn = deserializer.deserialize(staticData->serializedATN);

  const size_t count = staticData->atn->getNumberOfDecisions();
  staticData->decisionToDFA.reserve(count);
  for (size_t i = 0; i < count; i++) { 
    staticData->decisionToDFA.emplace_back(staticData->atn->getDecisionState(i), i);
  }
  mysqlparserParserStaticData = staticData.release();
}

}

MySQLParser::MySQLParser(TokenStream *input) : MySQLParser(input, antlr4::atn::ParserATNSimulatorOptions()) {}

MySQLParser::MySQLParser(TokenStream *input, const antlr4::atn::ParserATNSimulatorOptions &options) : MySQLBaseRecognizer(input) {
  MySQLParser::initialize();
  _interpreter = new atn::ParserATNSimulator(this, *mysqlparserParserStaticData->atn, mysqlparserParserStaticData->decisionToDFA, mysqlparserParserStaticData->sharedContextCache, options);
}

MySQLParser::~MySQLParser() {
  delete _interpreter;
}

const atn::ATN& MySQLParser::getATN() const {
  return *mysqlparserParserStaticData->atn;
}

std::string MySQLParser::getGrammarFileName() const {
  return "MySQLParser.g4";
}

const std::vector<std::string>& MySQLParser::getRuleNames() const {
  return mysqlparserParserStaticData->ruleNames;
}

const dfa::Vocabulary& MySQLParser::getVocabulary() const {
  return mysqlparserParserStaticData->vocabulary;
}

antlr4::atn::SerializedATNView MySQLParser::getSerializedATN() const {
  return mysqlparserParserStaticData->serializedATN;
}


//----------------- QueryContext ------------------------------------------------------------------

MySQLParser::QueryContext::QueryContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::QueryContext::EOF() {
  return getToken(MySQLParser::EOF, 0);
}

MySQLParser::SimpleStatementContext* MySQLParser::QueryContext::simpleStatement() {
  return getRuleContext<MySQLParser::SimpleStatementContext>(0);
}

MySQLParser::BeginWorkContext* MySQLParser::QueryContext::beginWork() {
  return getRuleContext<MySQLParser::BeginWorkContext>(0);
}

tree::TerminalNode* MySQLParser::QueryContext::SEMICOLON_SYMBOL() {
  return getToken(MySQLParser::SEMICOLON_SYMBOL, 0);
}


size_t MySQLParser::QueryContext::getRuleIndex() const {
  return MySQLParser::RuleQuery;
}

void MySQLParser::QueryContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQuery(this);
}

void MySQLParser::QueryContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQuery(this);
}


std::any MySQLParser::QueryContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQuery(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryContext* MySQLParser::query() {
  QueryContext *_localctx = _tracker.createInstance<QueryContext>(_ctx, getState());
  enterRule(_localctx, 0, MySQLParser::RuleQuery);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1513);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 2, _ctx)) {
    case 1: {
      setState(1508);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 0, _ctx)) {
      case 1: {
        setState(1506);
        simpleStatement();
        break;
      }

      case 2: {
        setState(1507);
        beginWork();
        break;
      }

      default:
        break;
      }
      setState(1511);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::SEMICOLON_SYMBOL) {
        setState(1510);
        match(MySQLParser::SEMICOLON_SYMBOL);
      }
      break;
    }

    default:
      break;
    }
    setState(1515);
    match(MySQLParser::EOF);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SimpleStatementContext ------------------------------------------------------------------

MySQLParser::SimpleStatementContext::SimpleStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::AlterStatementContext* MySQLParser::SimpleStatementContext::alterStatement() {
  return getRuleContext<MySQLParser::AlterStatementContext>(0);
}

MySQLParser::CreateStatementContext* MySQLParser::SimpleStatementContext::createStatement() {
  return getRuleContext<MySQLParser::CreateStatementContext>(0);
}

MySQLParser::DropStatementContext* MySQLParser::SimpleStatementContext::dropStatement() {
  return getRuleContext<MySQLParser::DropStatementContext>(0);
}

MySQLParser::RenameTableStatementContext* MySQLParser::SimpleStatementContext::renameTableStatement() {
  return getRuleContext<MySQLParser::RenameTableStatementContext>(0);
}

MySQLParser::TruncateTableStatementContext* MySQLParser::SimpleStatementContext::truncateTableStatement() {
  return getRuleContext<MySQLParser::TruncateTableStatementContext>(0);
}

MySQLParser::ImportStatementContext* MySQLParser::SimpleStatementContext::importStatement() {
  return getRuleContext<MySQLParser::ImportStatementContext>(0);
}

MySQLParser::CallStatementContext* MySQLParser::SimpleStatementContext::callStatement() {
  return getRuleContext<MySQLParser::CallStatementContext>(0);
}

MySQLParser::DeleteStatementContext* MySQLParser::SimpleStatementContext::deleteStatement() {
  return getRuleContext<MySQLParser::DeleteStatementContext>(0);
}

MySQLParser::DoStatementContext* MySQLParser::SimpleStatementContext::doStatement() {
  return getRuleContext<MySQLParser::DoStatementContext>(0);
}

MySQLParser::HandlerStatementContext* MySQLParser::SimpleStatementContext::handlerStatement() {
  return getRuleContext<MySQLParser::HandlerStatementContext>(0);
}

MySQLParser::InsertStatementContext* MySQLParser::SimpleStatementContext::insertStatement() {
  return getRuleContext<MySQLParser::InsertStatementContext>(0);
}

MySQLParser::LoadStatementContext* MySQLParser::SimpleStatementContext::loadStatement() {
  return getRuleContext<MySQLParser::LoadStatementContext>(0);
}

MySQLParser::ReplaceStatementContext* MySQLParser::SimpleStatementContext::replaceStatement() {
  return getRuleContext<MySQLParser::ReplaceStatementContext>(0);
}

MySQLParser::SelectStatementContext* MySQLParser::SimpleStatementContext::selectStatement() {
  return getRuleContext<MySQLParser::SelectStatementContext>(0);
}

MySQLParser::UpdateStatementContext* MySQLParser::SimpleStatementContext::updateStatement() {
  return getRuleContext<MySQLParser::UpdateStatementContext>(0);
}

MySQLParser::TransactionOrLockingStatementContext* MySQLParser::SimpleStatementContext::transactionOrLockingStatement() {
  return getRuleContext<MySQLParser::TransactionOrLockingStatementContext>(0);
}

MySQLParser::ReplicationStatementContext* MySQLParser::SimpleStatementContext::replicationStatement() {
  return getRuleContext<MySQLParser::ReplicationStatementContext>(0);
}

MySQLParser::PreparedStatementContext* MySQLParser::SimpleStatementContext::preparedStatement() {
  return getRuleContext<MySQLParser::PreparedStatementContext>(0);
}

MySQLParser::CloneStatementContext* MySQLParser::SimpleStatementContext::cloneStatement() {
  return getRuleContext<MySQLParser::CloneStatementContext>(0);
}

MySQLParser::AccountManagementStatementContext* MySQLParser::SimpleStatementContext::accountManagementStatement() {
  return getRuleContext<MySQLParser::AccountManagementStatementContext>(0);
}

MySQLParser::TableAdministrationStatementContext* MySQLParser::SimpleStatementContext::tableAdministrationStatement() {
  return getRuleContext<MySQLParser::TableAdministrationStatementContext>(0);
}

MySQLParser::UninstallStatementContext* MySQLParser::SimpleStatementContext::uninstallStatement() {
  return getRuleContext<MySQLParser::UninstallStatementContext>(0);
}

MySQLParser::InstallStatementContext* MySQLParser::SimpleStatementContext::installStatement() {
  return getRuleContext<MySQLParser::InstallStatementContext>(0);
}

MySQLParser::SetStatementContext* MySQLParser::SimpleStatementContext::setStatement() {
  return getRuleContext<MySQLParser::SetStatementContext>(0);
}

MySQLParser::ShowDatabasesStatementContext* MySQLParser::SimpleStatementContext::showDatabasesStatement() {
  return getRuleContext<MySQLParser::ShowDatabasesStatementContext>(0);
}

MySQLParser::ShowTablesStatementContext* MySQLParser::SimpleStatementContext::showTablesStatement() {
  return getRuleContext<MySQLParser::ShowTablesStatementContext>(0);
}

MySQLParser::ShowTriggersStatementContext* MySQLParser::SimpleStatementContext::showTriggersStatement() {
  return getRuleContext<MySQLParser::ShowTriggersStatementContext>(0);
}

MySQLParser::ShowEventsStatementContext* MySQLParser::SimpleStatementContext::showEventsStatement() {
  return getRuleContext<MySQLParser::ShowEventsStatementContext>(0);
}

MySQLParser::ShowTableStatusStatementContext* MySQLParser::SimpleStatementContext::showTableStatusStatement() {
  return getRuleContext<MySQLParser::ShowTableStatusStatementContext>(0);
}

MySQLParser::ShowOpenTablesStatementContext* MySQLParser::SimpleStatementContext::showOpenTablesStatement() {
  return getRuleContext<MySQLParser::ShowOpenTablesStatementContext>(0);
}

MySQLParser::ShowParseTreeStatementContext* MySQLParser::SimpleStatementContext::showParseTreeStatement() {
  return getRuleContext<MySQLParser::ShowParseTreeStatementContext>(0);
}

MySQLParser::ShowPluginsStatementContext* MySQLParser::SimpleStatementContext::showPluginsStatement() {
  return getRuleContext<MySQLParser::ShowPluginsStatementContext>(0);
}

MySQLParser::ShowEngineLogsStatementContext* MySQLParser::SimpleStatementContext::showEngineLogsStatement() {
  return getRuleContext<MySQLParser::ShowEngineLogsStatementContext>(0);
}

MySQLParser::ShowEngineMutexStatementContext* MySQLParser::SimpleStatementContext::showEngineMutexStatement() {
  return getRuleContext<MySQLParser::ShowEngineMutexStatementContext>(0);
}

MySQLParser::ShowEngineStatusStatementContext* MySQLParser::SimpleStatementContext::showEngineStatusStatement() {
  return getRuleContext<MySQLParser::ShowEngineStatusStatementContext>(0);
}

MySQLParser::ShowColumnsStatementContext* MySQLParser::SimpleStatementContext::showColumnsStatement() {
  return getRuleContext<MySQLParser::ShowColumnsStatementContext>(0);
}

MySQLParser::ShowBinaryLogsStatementContext* MySQLParser::SimpleStatementContext::showBinaryLogsStatement() {
  return getRuleContext<MySQLParser::ShowBinaryLogsStatementContext>(0);
}

MySQLParser::ShowBinaryLogStatusStatementContext* MySQLParser::SimpleStatementContext::showBinaryLogStatusStatement() {
  return getRuleContext<MySQLParser::ShowBinaryLogStatusStatementContext>(0);
}

MySQLParser::ShowReplicasStatementContext* MySQLParser::SimpleStatementContext::showReplicasStatement() {
  return getRuleContext<MySQLParser::ShowReplicasStatementContext>(0);
}

MySQLParser::ShowBinlogEventsStatementContext* MySQLParser::SimpleStatementContext::showBinlogEventsStatement() {
  return getRuleContext<MySQLParser::ShowBinlogEventsStatementContext>(0);
}

MySQLParser::ShowRelaylogEventsStatementContext* MySQLParser::SimpleStatementContext::showRelaylogEventsStatement() {
  return getRuleContext<MySQLParser::ShowRelaylogEventsStatementContext>(0);
}

MySQLParser::ShowKeysStatementContext* MySQLParser::SimpleStatementContext::showKeysStatement() {
  return getRuleContext<MySQLParser::ShowKeysStatementContext>(0);
}

MySQLParser::ShowEnginesStatementContext* MySQLParser::SimpleStatementContext::showEnginesStatement() {
  return getRuleContext<MySQLParser::ShowEnginesStatementContext>(0);
}

MySQLParser::ShowCountWarningsStatementContext* MySQLParser::SimpleStatementContext::showCountWarningsStatement() {
  return getRuleContext<MySQLParser::ShowCountWarningsStatementContext>(0);
}

MySQLParser::ShowCountErrorsStatementContext* MySQLParser::SimpleStatementContext::showCountErrorsStatement() {
  return getRuleContext<MySQLParser::ShowCountErrorsStatementContext>(0);
}

MySQLParser::ShowWarningsStatementContext* MySQLParser::SimpleStatementContext::showWarningsStatement() {
  return getRuleContext<MySQLParser::ShowWarningsStatementContext>(0);
}

MySQLParser::ShowErrorsStatementContext* MySQLParser::SimpleStatementContext::showErrorsStatement() {
  return getRuleContext<MySQLParser::ShowErrorsStatementContext>(0);
}

MySQLParser::ShowProfilesStatementContext* MySQLParser::SimpleStatementContext::showProfilesStatement() {
  return getRuleContext<MySQLParser::ShowProfilesStatementContext>(0);
}

MySQLParser::ShowProfileStatementContext* MySQLParser::SimpleStatementContext::showProfileStatement() {
  return getRuleContext<MySQLParser::ShowProfileStatementContext>(0);
}

MySQLParser::ShowStatusStatementContext* MySQLParser::SimpleStatementContext::showStatusStatement() {
  return getRuleContext<MySQLParser::ShowStatusStatementContext>(0);
}

MySQLParser::ShowProcessListStatementContext* MySQLParser::SimpleStatementContext::showProcessListStatement() {
  return getRuleContext<MySQLParser::ShowProcessListStatementContext>(0);
}

MySQLParser::ShowVariablesStatementContext* MySQLParser::SimpleStatementContext::showVariablesStatement() {
  return getRuleContext<MySQLParser::ShowVariablesStatementContext>(0);
}

MySQLParser::ShowCharacterSetStatementContext* MySQLParser::SimpleStatementContext::showCharacterSetStatement() {
  return getRuleContext<MySQLParser::ShowCharacterSetStatementContext>(0);
}

MySQLParser::ShowCollationStatementContext* MySQLParser::SimpleStatementContext::showCollationStatement() {
  return getRuleContext<MySQLParser::ShowCollationStatementContext>(0);
}

MySQLParser::ShowPrivilegesStatementContext* MySQLParser::SimpleStatementContext::showPrivilegesStatement() {
  return getRuleContext<MySQLParser::ShowPrivilegesStatementContext>(0);
}

MySQLParser::ShowGrantsStatementContext* MySQLParser::SimpleStatementContext::showGrantsStatement() {
  return getRuleContext<MySQLParser::ShowGrantsStatementContext>(0);
}

MySQLParser::ShowCreateDatabaseStatementContext* MySQLParser::SimpleStatementContext::showCreateDatabaseStatement() {
  return getRuleContext<MySQLParser::ShowCreateDatabaseStatementContext>(0);
}

MySQLParser::ShowCreateTableStatementContext* MySQLParser::SimpleStatementContext::showCreateTableStatement() {
  return getRuleContext<MySQLParser::ShowCreateTableStatementContext>(0);
}

MySQLParser::ShowCreateViewStatementContext* MySQLParser::SimpleStatementContext::showCreateViewStatement() {
  return getRuleContext<MySQLParser::ShowCreateViewStatementContext>(0);
}

MySQLParser::ShowMasterStatusStatementContext* MySQLParser::SimpleStatementContext::showMasterStatusStatement() {
  return getRuleContext<MySQLParser::ShowMasterStatusStatementContext>(0);
}

MySQLParser::ShowReplicaStatusStatementContext* MySQLParser::SimpleStatementContext::showReplicaStatusStatement() {
  return getRuleContext<MySQLParser::ShowReplicaStatusStatementContext>(0);
}

MySQLParser::ShowCreateProcedureStatementContext* MySQLParser::SimpleStatementContext::showCreateProcedureStatement() {
  return getRuleContext<MySQLParser::ShowCreateProcedureStatementContext>(0);
}

MySQLParser::ShowCreateFunctionStatementContext* MySQLParser::SimpleStatementContext::showCreateFunctionStatement() {
  return getRuleContext<MySQLParser::ShowCreateFunctionStatementContext>(0);
}

MySQLParser::ShowCreateTriggerStatementContext* MySQLParser::SimpleStatementContext::showCreateTriggerStatement() {
  return getRuleContext<MySQLParser::ShowCreateTriggerStatementContext>(0);
}

MySQLParser::ShowCreateProcedureStatusStatementContext* MySQLParser::SimpleStatementContext::showCreateProcedureStatusStatement() {
  return getRuleContext<MySQLParser::ShowCreateProcedureStatusStatementContext>(0);
}

MySQLParser::ShowCreateFunctionStatusStatementContext* MySQLParser::SimpleStatementContext::showCreateFunctionStatusStatement() {
  return getRuleContext<MySQLParser::ShowCreateFunctionStatusStatementContext>(0);
}

MySQLParser::ShowCreateProcedureCodeStatementContext* MySQLParser::SimpleStatementContext::showCreateProcedureCodeStatement() {
  return getRuleContext<MySQLParser::ShowCreateProcedureCodeStatementContext>(0);
}

MySQLParser::ShowCreateFunctionCodeStatementContext* MySQLParser::SimpleStatementContext::showCreateFunctionCodeStatement() {
  return getRuleContext<MySQLParser::ShowCreateFunctionCodeStatementContext>(0);
}

MySQLParser::ShowCreateEventStatementContext* MySQLParser::SimpleStatementContext::showCreateEventStatement() {
  return getRuleContext<MySQLParser::ShowCreateEventStatementContext>(0);
}

MySQLParser::ShowCreateUserStatementContext* MySQLParser::SimpleStatementContext::showCreateUserStatement() {
  return getRuleContext<MySQLParser::ShowCreateUserStatementContext>(0);
}

MySQLParser::ResourceGroupManagementContext* MySQLParser::SimpleStatementContext::resourceGroupManagement() {
  return getRuleContext<MySQLParser::ResourceGroupManagementContext>(0);
}

MySQLParser::OtherAdministrativeStatementContext* MySQLParser::SimpleStatementContext::otherAdministrativeStatement() {
  return getRuleContext<MySQLParser::OtherAdministrativeStatementContext>(0);
}

MySQLParser::UtilityStatementContext* MySQLParser::SimpleStatementContext::utilityStatement() {
  return getRuleContext<MySQLParser::UtilityStatementContext>(0);
}

MySQLParser::GetDiagnosticsStatementContext* MySQLParser::SimpleStatementContext::getDiagnosticsStatement() {
  return getRuleContext<MySQLParser::GetDiagnosticsStatementContext>(0);
}

MySQLParser::SignalStatementContext* MySQLParser::SimpleStatementContext::signalStatement() {
  return getRuleContext<MySQLParser::SignalStatementContext>(0);
}

MySQLParser::ResignalStatementContext* MySQLParser::SimpleStatementContext::resignalStatement() {
  return getRuleContext<MySQLParser::ResignalStatementContext>(0);
}


size_t MySQLParser::SimpleStatementContext::getRuleIndex() const {
  return MySQLParser::RuleSimpleStatement;
}

void MySQLParser::SimpleStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSimpleStatement(this);
}

void MySQLParser::SimpleStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSimpleStatement(this);
}


std::any MySQLParser::SimpleStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSimpleStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SimpleStatementContext* MySQLParser::simpleStatement() {
  SimpleStatementContext *_localctx = _tracker.createInstance<SimpleStatementContext>(_ctx, getState());
  enterRule(_localctx, 2, MySQLParser::RuleSimpleStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1597);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 3, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1517);
      alterStatement();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1518);
      createStatement();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1519);
      dropStatement();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(1520);
      renameTableStatement();
      break;
    }

    case 5: {
      enterOuterAlt(_localctx, 5);
      setState(1521);
      truncateTableStatement();
      break;
    }

    case 6: {
      enterOuterAlt(_localctx, 6);
      setState(1522);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(1523);
      importStatement();
      break;
    }

    case 7: {
      enterOuterAlt(_localctx, 7);
      setState(1524);
      callStatement();
      break;
    }

    case 8: {
      enterOuterAlt(_localctx, 8);
      setState(1525);
      deleteStatement();
      break;
    }

    case 9: {
      enterOuterAlt(_localctx, 9);
      setState(1526);
      doStatement();
      break;
    }

    case 10: {
      enterOuterAlt(_localctx, 10);
      setState(1527);
      handlerStatement();
      break;
    }

    case 11: {
      enterOuterAlt(_localctx, 11);
      setState(1528);
      insertStatement();
      break;
    }

    case 12: {
      enterOuterAlt(_localctx, 12);
      setState(1529);
      loadStatement();
      break;
    }

    case 13: {
      enterOuterAlt(_localctx, 13);
      setState(1530);
      replaceStatement();
      break;
    }

    case 14: {
      enterOuterAlt(_localctx, 14);
      setState(1531);
      selectStatement();
      break;
    }

    case 15: {
      enterOuterAlt(_localctx, 15);
      setState(1532);
      updateStatement();
      break;
    }

    case 16: {
      enterOuterAlt(_localctx, 16);
      setState(1533);
      transactionOrLockingStatement();
      break;
    }

    case 17: {
      enterOuterAlt(_localctx, 17);
      setState(1534);
      replicationStatement();
      break;
    }

    case 18: {
      enterOuterAlt(_localctx, 18);
      setState(1535);
      preparedStatement();
      break;
    }

    case 19: {
      enterOuterAlt(_localctx, 19);
      setState(1536);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(1537);
      cloneStatement();
      break;
    }

    case 20: {
      enterOuterAlt(_localctx, 20);
      setState(1538);
      accountManagementStatement();
      break;
    }

    case 21: {
      enterOuterAlt(_localctx, 21);
      setState(1539);
      tableAdministrationStatement();
      break;
    }

    case 22: {
      enterOuterAlt(_localctx, 22);
      setState(1540);
      uninstallStatement();
      break;
    }

    case 23: {
      enterOuterAlt(_localctx, 23);
      setState(1541);
      installStatement();
      break;
    }

    case 24: {
      enterOuterAlt(_localctx, 24);
      setState(1542);
      setStatement();
      break;
    }

    case 25: {
      enterOuterAlt(_localctx, 25);
      setState(1543);
      showDatabasesStatement();
      break;
    }

    case 26: {
      enterOuterAlt(_localctx, 26);
      setState(1544);
      showTablesStatement();
      break;
    }

    case 27: {
      enterOuterAlt(_localctx, 27);
      setState(1545);
      showTriggersStatement();
      break;
    }

    case 28: {
      enterOuterAlt(_localctx, 28);
      setState(1546);
      showEventsStatement();
      break;
    }

    case 29: {
      enterOuterAlt(_localctx, 29);
      setState(1547);
      showTableStatusStatement();
      break;
    }

    case 30: {
      enterOuterAlt(_localctx, 30);
      setState(1548);
      showOpenTablesStatement();
      break;
    }

    case 31: {
      enterOuterAlt(_localctx, 31);
      setState(1549);
      showParseTreeStatement();
      break;
    }

    case 32: {
      enterOuterAlt(_localctx, 32);
      setState(1550);
      showPluginsStatement();
      break;
    }

    case 33: {
      enterOuterAlt(_localctx, 33);
      setState(1551);
      showEngineLogsStatement();
      break;
    }

    case 34: {
      enterOuterAlt(_localctx, 34);
      setState(1552);
      showEngineMutexStatement();
      break;
    }

    case 35: {
      enterOuterAlt(_localctx, 35);
      setState(1553);
      showEngineStatusStatement();
      break;
    }

    case 36: {
      enterOuterAlt(_localctx, 36);
      setState(1554);
      showColumnsStatement();
      break;
    }

    case 37: {
      enterOuterAlt(_localctx, 37);
      setState(1555);
      showBinaryLogsStatement();
      break;
    }

    case 38: {
      enterOuterAlt(_localctx, 38);
      setState(1556);
      showBinaryLogStatusStatement();
      break;
    }

    case 39: {
      enterOuterAlt(_localctx, 39);
      setState(1557);
      showReplicasStatement();
      break;
    }

    case 40: {
      enterOuterAlt(_localctx, 40);
      setState(1558);
      showBinlogEventsStatement();
      break;
    }

    case 41: {
      enterOuterAlt(_localctx, 41);
      setState(1559);
      showRelaylogEventsStatement();
      break;
    }

    case 42: {
      enterOuterAlt(_localctx, 42);
      setState(1560);
      showKeysStatement();
      break;
    }

    case 43: {
      enterOuterAlt(_localctx, 43);
      setState(1561);
      showEnginesStatement();
      break;
    }

    case 44: {
      enterOuterAlt(_localctx, 44);
      setState(1562);
      showCountWarningsStatement();
      break;
    }

    case 45: {
      enterOuterAlt(_localctx, 45);
      setState(1563);
      showCountErrorsStatement();
      break;
    }

    case 46: {
      enterOuterAlt(_localctx, 46);
      setState(1564);
      showWarningsStatement();
      break;
    }

    case 47: {
      enterOuterAlt(_localctx, 47);
      setState(1565);
      showErrorsStatement();
      break;
    }

    case 48: {
      enterOuterAlt(_localctx, 48);
      setState(1566);
      showProfilesStatement();
      break;
    }

    case 49: {
      enterOuterAlt(_localctx, 49);
      setState(1567);
      showProfileStatement();
      break;
    }

    case 50: {
      enterOuterAlt(_localctx, 50);
      setState(1568);
      showStatusStatement();
      break;
    }

    case 51: {
      enterOuterAlt(_localctx, 51);
      setState(1569);
      showProcessListStatement();
      break;
    }

    case 52: {
      enterOuterAlt(_localctx, 52);
      setState(1570);
      showVariablesStatement();
      break;
    }

    case 53: {
      enterOuterAlt(_localctx, 53);
      setState(1571);
      showCharacterSetStatement();
      break;
    }

    case 54: {
      enterOuterAlt(_localctx, 54);
      setState(1572);
      showCollationStatement();
      break;
    }

    case 55: {
      enterOuterAlt(_localctx, 55);
      setState(1573);
      showPrivilegesStatement();
      break;
    }

    case 56: {
      enterOuterAlt(_localctx, 56);
      setState(1574);
      showGrantsStatement();
      break;
    }

    case 57: {
      enterOuterAlt(_localctx, 57);
      setState(1575);
      showCreateDatabaseStatement();
      break;
    }

    case 58: {
      enterOuterAlt(_localctx, 58);
      setState(1576);
      showCreateTableStatement();
      break;
    }

    case 59: {
      enterOuterAlt(_localctx, 59);
      setState(1577);
      showCreateViewStatement();
      break;
    }

    case 60: {
      enterOuterAlt(_localctx, 60);
      setState(1578);
      showMasterStatusStatement();
      break;
    }

    case 61: {
      enterOuterAlt(_localctx, 61);
      setState(1579);
      showReplicaStatusStatement();
      break;
    }

    case 62: {
      enterOuterAlt(_localctx, 62);
      setState(1580);
      showCreateProcedureStatement();
      break;
    }

    case 63: {
      enterOuterAlt(_localctx, 63);
      setState(1581);
      showCreateFunctionStatement();
      break;
    }

    case 64: {
      enterOuterAlt(_localctx, 64);
      setState(1582);
      showCreateTriggerStatement();
      break;
    }

    case 65: {
      enterOuterAlt(_localctx, 65);
      setState(1583);
      showCreateProcedureStatusStatement();
      break;
    }

    case 66: {
      enterOuterAlt(_localctx, 66);
      setState(1584);
      showCreateFunctionStatusStatement();
      break;
    }

    case 67: {
      enterOuterAlt(_localctx, 67);
      setState(1585);
      showCreateProcedureCodeStatement();
      break;
    }

    case 68: {
      enterOuterAlt(_localctx, 68);
      setState(1586);
      showCreateFunctionCodeStatement();
      break;
    }

    case 69: {
      enterOuterAlt(_localctx, 69);
      setState(1587);
      showCreateEventStatement();
      break;
    }

    case 70: {
      enterOuterAlt(_localctx, 70);
      setState(1588);

      if (!(serverVersion >= 50704)) throw FailedPredicateException(this, "serverVersion >= 50704");
      setState(1589);
      showCreateUserStatement();
      break;
    }

    case 71: {
      enterOuterAlt(_localctx, 71);
      setState(1590);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(1591);
      resourceGroupManagement();
      break;
    }

    case 72: {
      enterOuterAlt(_localctx, 72);
      setState(1592);
      otherAdministrativeStatement();
      break;
    }

    case 73: {
      enterOuterAlt(_localctx, 73);
      setState(1593);
      utilityStatement();
      break;
    }

    case 74: {
      enterOuterAlt(_localctx, 74);
      setState(1594);
      getDiagnosticsStatement();
      break;
    }

    case 75: {
      enterOuterAlt(_localctx, 75);
      setState(1595);
      signalStatement();
      break;
    }

    case 76: {
      enterOuterAlt(_localctx, 76);
      setState(1596);
      resignalStatement();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterStatementContext ------------------------------------------------------------------

MySQLParser::AlterStatementContext::AlterStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterStatementContext::ALTER_SYMBOL() {
  return getToken(MySQLParser::ALTER_SYMBOL, 0);
}

MySQLParser::AlterTableContext* MySQLParser::AlterStatementContext::alterTable() {
  return getRuleContext<MySQLParser::AlterTableContext>(0);
}

MySQLParser::AlterDatabaseContext* MySQLParser::AlterStatementContext::alterDatabase() {
  return getRuleContext<MySQLParser::AlterDatabaseContext>(0);
}

tree::TerminalNode* MySQLParser::AlterStatementContext::PROCEDURE_SYMBOL() {
  return getToken(MySQLParser::PROCEDURE_SYMBOL, 0);
}

MySQLParser::ProcedureRefContext* MySQLParser::AlterStatementContext::procedureRef() {
  return getRuleContext<MySQLParser::ProcedureRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterStatementContext::FUNCTION_SYMBOL() {
  return getToken(MySQLParser::FUNCTION_SYMBOL, 0);
}

MySQLParser::FunctionRefContext* MySQLParser::AlterStatementContext::functionRef() {
  return getRuleContext<MySQLParser::FunctionRefContext>(0);
}

MySQLParser::AlterViewContext* MySQLParser::AlterStatementContext::alterView() {
  return getRuleContext<MySQLParser::AlterViewContext>(0);
}

MySQLParser::AlterEventContext* MySQLParser::AlterStatementContext::alterEvent() {
  return getRuleContext<MySQLParser::AlterEventContext>(0);
}

MySQLParser::AlterTablespaceContext* MySQLParser::AlterStatementContext::alterTablespace() {
  return getRuleContext<MySQLParser::AlterTablespaceContext>(0);
}

MySQLParser::AlterUndoTablespaceContext* MySQLParser::AlterStatementContext::alterUndoTablespace() {
  return getRuleContext<MySQLParser::AlterUndoTablespaceContext>(0);
}

MySQLParser::AlterLogfileGroupContext* MySQLParser::AlterStatementContext::alterLogfileGroup() {
  return getRuleContext<MySQLParser::AlterLogfileGroupContext>(0);
}

MySQLParser::AlterServerContext* MySQLParser::AlterStatementContext::alterServer() {
  return getRuleContext<MySQLParser::AlterServerContext>(0);
}

MySQLParser::AlterInstanceStatementContext* MySQLParser::AlterStatementContext::alterInstanceStatement() {
  return getRuleContext<MySQLParser::AlterInstanceStatementContext>(0);
}

MySQLParser::RoutineAlterOptionsContext* MySQLParser::AlterStatementContext::routineAlterOptions() {
  return getRuleContext<MySQLParser::RoutineAlterOptionsContext>(0);
}


size_t MySQLParser::AlterStatementContext::getRuleIndex() const {
  return MySQLParser::RuleAlterStatement;
}

void MySQLParser::AlterStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterStatement(this);
}

void MySQLParser::AlterStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterStatement(this);
}


std::any MySQLParser::AlterStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterStatementContext* MySQLParser::alterStatement() {
  AlterStatementContext *_localctx = _tracker.createInstance<AlterStatementContext>(_ctx, getState());
  enterRule(_localctx, 4, MySQLParser::RuleAlterStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1599);
    match(MySQLParser::ALTER_SYMBOL);
    setState(1620);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 6, _ctx)) {
    case 1: {
      setState(1600);
      alterTable();
      break;
    }

    case 2: {
      setState(1601);
      alterDatabase();
      break;
    }

    case 3: {
      setState(1602);
      match(MySQLParser::PROCEDURE_SYMBOL);
      setState(1603);
      procedureRef();
      setState(1605);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (((((_la - 119) & ~ 0x3fULL) == 0) &&
        ((1ULL << (_la - 119)) & ((1ULL << (MySQLParser::COMMENT_SYMBOL - 119))
        | (1ULL << (MySQLParser::CONTAINS_SYMBOL - 119))
        | (1ULL << (MySQLParser::DETERMINISTIC_SYMBOL - 119)))) != 0) || _la == MySQLParser::LANGUAGE_SYMBOL || ((((_la - 378) & ~ 0x3fULL) == 0) &&
        ((1ULL << (_la - 378)) & ((1ULL << (MySQLParser::MODIFIES_SYMBOL - 378))
        | (1ULL << (MySQLParser::NOT_SYMBOL - 378))
        | (1ULL << (MySQLParser::NO_SYMBOL - 378)))) != 0) || _la == MySQLParser::READS_SYMBOL || _la == MySQLParser::SQL_SYMBOL) {
        setState(1604);
        routineAlterOptions();
      }
      break;
    }

    case 4: {
      setState(1607);
      match(MySQLParser::FUNCTION_SYMBOL);
      setState(1608);
      functionRef();
      setState(1610);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (((((_la - 119) & ~ 0x3fULL) == 0) &&
        ((1ULL << (_la - 119)) & ((1ULL << (MySQLParser::COMMENT_SYMBOL - 119))
        | (1ULL << (MySQLParser::CONTAINS_SYMBOL - 119))
        | (1ULL << (MySQLParser::DETERMINISTIC_SYMBOL - 119)))) != 0) || _la == MySQLParser::LANGUAGE_SYMBOL || ((((_la - 378) & ~ 0x3fULL) == 0) &&
        ((1ULL << (_la - 378)) & ((1ULL << (MySQLParser::MODIFIES_SYMBOL - 378))
        | (1ULL << (MySQLParser::NOT_SYMBOL - 378))
        | (1ULL << (MySQLParser::NO_SYMBOL - 378)))) != 0) || _la == MySQLParser::READS_SYMBOL || _la == MySQLParser::SQL_SYMBOL) {
        setState(1609);
        routineAlterOptions();
      }
      break;
    }

    case 5: {
      setState(1612);
      alterView();
      break;
    }

    case 6: {
      setState(1613);
      alterEvent();
      break;
    }

    case 7: {
      setState(1614);
      alterTablespace();
      break;
    }

    case 8: {
      setState(1615);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(1616);
      alterUndoTablespace();
      break;
    }

    case 9: {
      setState(1617);
      alterLogfileGroup();
      break;
    }

    case 10: {
      setState(1618);
      alterServer();
      break;
    }

    case 11: {
      setState(1619);
      alterInstanceStatement();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterDatabaseContext ------------------------------------------------------------------

MySQLParser::AlterDatabaseContext::AlterDatabaseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterDatabaseContext::DATABASE_SYMBOL() {
  return getToken(MySQLParser::DATABASE_SYMBOL, 0);
}

MySQLParser::SchemaRefContext* MySQLParser::AlterDatabaseContext::schemaRef() {
  return getRuleContext<MySQLParser::SchemaRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseContext::UPGRADE_SYMBOL() {
  return getToken(MySQLParser::UPGRADE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseContext::DATA_SYMBOL() {
  return getToken(MySQLParser::DATA_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseContext::DIRECTORY_SYMBOL() {
  return getToken(MySQLParser::DIRECTORY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseContext::NAME_SYMBOL() {
  return getToken(MySQLParser::NAME_SYMBOL, 0);
}

std::vector<MySQLParser::AlterDatabaseOptionContext *> MySQLParser::AlterDatabaseContext::alterDatabaseOption() {
  return getRuleContexts<MySQLParser::AlterDatabaseOptionContext>();
}

MySQLParser::AlterDatabaseOptionContext* MySQLParser::AlterDatabaseContext::alterDatabaseOption(size_t i) {
  return getRuleContext<MySQLParser::AlterDatabaseOptionContext>(i);
}


size_t MySQLParser::AlterDatabaseContext::getRuleIndex() const {
  return MySQLParser::RuleAlterDatabase;
}

void MySQLParser::AlterDatabaseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterDatabase(this);
}

void MySQLParser::AlterDatabaseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterDatabase(this);
}


std::any MySQLParser::AlterDatabaseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterDatabase(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterDatabaseContext* MySQLParser::alterDatabase() {
  AlterDatabaseContext *_localctx = _tracker.createInstance<AlterDatabaseContext>(_ctx, getState());
  enterRule(_localctx, 6, MySQLParser::RuleAlterDatabase);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(1622);
    match(MySQLParser::DATABASE_SYMBOL);
    setState(1623);
    schemaRef();
    setState(1634);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 8, _ctx)) {
    case 1: {
      setState(1625); 
      _errHandler->sync(this);
      alt = 1;
      do {
        switch (alt) {
          case 1: {
                setState(1624);
                alterDatabaseOption();
                break;
              }

        default:
          throw NoViableAltException(this);
        }
        setState(1627); 
        _errHandler->sync(this);
        alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 7, _ctx);
      } while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER);
      break;
    }

    case 2: {
      setState(1629);

      if (!(serverVersion < 80000)) throw FailedPredicateException(this, "serverVersion < 80000");
      setState(1630);
      match(MySQLParser::UPGRADE_SYMBOL);
      setState(1631);
      match(MySQLParser::DATA_SYMBOL);
      setState(1632);
      match(MySQLParser::DIRECTORY_SYMBOL);
      setState(1633);
      match(MySQLParser::NAME_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterDatabaseOptionContext ------------------------------------------------------------------

MySQLParser::AlterDatabaseOptionContext::AlterDatabaseOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::CreateDatabaseOptionContext* MySQLParser::AlterDatabaseOptionContext::createDatabaseOption() {
  return getRuleContext<MySQLParser::CreateDatabaseOptionContext>(0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseOptionContext::READ_SYMBOL() {
  return getToken(MySQLParser::READ_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseOptionContext::ONLY_SYMBOL() {
  return getToken(MySQLParser::ONLY_SYMBOL, 0);
}

MySQLParser::TernaryOptionContext* MySQLParser::AlterDatabaseOptionContext::ternaryOption() {
  return getRuleContext<MySQLParser::TernaryOptionContext>(0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseOptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::AlterDatabaseOptionContext::getRuleIndex() const {
  return MySQLParser::RuleAlterDatabaseOption;
}

void MySQLParser::AlterDatabaseOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterDatabaseOption(this);
}

void MySQLParser::AlterDatabaseOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterDatabaseOption(this);
}


std::any MySQLParser::AlterDatabaseOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterDatabaseOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterDatabaseOptionContext* MySQLParser::alterDatabaseOption() {
  AlterDatabaseOptionContext *_localctx = _tracker.createInstance<AlterDatabaseOptionContext>(_ctx, getState());
  enterRule(_localctx, 8, MySQLParser::RuleAlterDatabaseOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1643);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 10, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1636);
      createDatabaseOption();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1637);
      match(MySQLParser::READ_SYMBOL);
      setState(1638);
      match(MySQLParser::ONLY_SYMBOL);
      setState(1640);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::EQUAL_OPERATOR) {
        setState(1639);
        match(MySQLParser::EQUAL_OPERATOR);
      }
      setState(1642);
      ternaryOption();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterEventContext ------------------------------------------------------------------

MySQLParser::AlterEventContext::AlterEventContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterEventContext::EVENT_SYMBOL() {
  return getToken(MySQLParser::EVENT_SYMBOL, 0);
}

MySQLParser::EventRefContext* MySQLParser::AlterEventContext::eventRef() {
  return getRuleContext<MySQLParser::EventRefContext>(0);
}

MySQLParser::DefinerClauseContext* MySQLParser::AlterEventContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterEventContext::ON_SYMBOL() {
  return getTokens(MySQLParser::ON_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterEventContext::ON_SYMBOL(size_t i) {
  return getToken(MySQLParser::ON_SYMBOL, i);
}

tree::TerminalNode* MySQLParser::AlterEventContext::SCHEDULE_SYMBOL() {
  return getToken(MySQLParser::SCHEDULE_SYMBOL, 0);
}

MySQLParser::ScheduleContext* MySQLParser::AlterEventContext::schedule() {
  return getRuleContext<MySQLParser::ScheduleContext>(0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::COMPLETION_SYMBOL() {
  return getToken(MySQLParser::COMPLETION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::PRESERVE_SYMBOL() {
  return getToken(MySQLParser::PRESERVE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::RENAME_SYMBOL() {
  return getToken(MySQLParser::RENAME_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::TO_SYMBOL() {
  return getToken(MySQLParser::TO_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::AlterEventContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::ENABLE_SYMBOL() {
  return getToken(MySQLParser::ENABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::DISABLE_SYMBOL() {
  return getToken(MySQLParser::DISABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::COMMENT_SYMBOL() {
  return getToken(MySQLParser::COMMENT_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::AlterEventContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::DO_SYMBOL() {
  return getToken(MySQLParser::DO_SYMBOL, 0);
}

MySQLParser::CompoundStatementContext* MySQLParser::AlterEventContext::compoundStatement() {
  return getRuleContext<MySQLParser::CompoundStatementContext>(0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::NOT_SYMBOL() {
  return getToken(MySQLParser::NOT_SYMBOL, 0);
}

MySQLParser::ReplicaContext* MySQLParser::AlterEventContext::replica() {
  return getRuleContext<MySQLParser::ReplicaContext>(0);
}


size_t MySQLParser::AlterEventContext::getRuleIndex() const {
  return MySQLParser::RuleAlterEvent;
}

void MySQLParser::AlterEventContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterEvent(this);
}

void MySQLParser::AlterEventContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterEvent(this);
}


std::any MySQLParser::AlterEventContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterEvent(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterEventContext* MySQLParser::alterEvent() {
  AlterEventContext *_localctx = _tracker.createInstance<AlterEventContext>(_ctx, getState());
  enterRule(_localctx, 10, MySQLParser::RuleAlterEvent);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1646);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(1645);
      definerClause();
    }
    setState(1648);
    match(MySQLParser::EVENT_SYMBOL);
    setState(1649);
    eventRef();
    setState(1653);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 12, _ctx)) {
    case 1: {
      setState(1650);
      match(MySQLParser::ON_SYMBOL);
      setState(1651);
      match(MySQLParser::SCHEDULE_SYMBOL);
      setState(1652);
      schedule();
      break;
    }

    default:
      break;
    }
    setState(1661);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ON_SYMBOL) {
      setState(1655);
      match(MySQLParser::ON_SYMBOL);
      setState(1656);
      match(MySQLParser::COMPLETION_SYMBOL);
      setState(1658);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::NOT_SYMBOL) {
        setState(1657);
        match(MySQLParser::NOT_SYMBOL);
      }
      setState(1660);
      match(MySQLParser::PRESERVE_SYMBOL);
    }
    setState(1666);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::RENAME_SYMBOL) {
      setState(1663);
      match(MySQLParser::RENAME_SYMBOL);
      setState(1664);
      match(MySQLParser::TO_SYMBOL);
      setState(1665);
      identifier();
    }
    setState(1674);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::ENABLE_SYMBOL: {
        setState(1668);
        match(MySQLParser::ENABLE_SYMBOL);
        break;
      }

      case MySQLParser::DISABLE_SYMBOL: {
        setState(1669);
        match(MySQLParser::DISABLE_SYMBOL);
        setState(1672);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::ON_SYMBOL) {
          setState(1670);
          match(MySQLParser::ON_SYMBOL);
          setState(1671);
          replica();
        }
        break;
      }

      case MySQLParser::EOF:
      case MySQLParser::SEMICOLON_SYMBOL:
      case MySQLParser::COMMENT_SYMBOL:
      case MySQLParser::DO_SYMBOL: {
        break;
      }

    default:
      break;
    }
    setState(1678);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::COMMENT_SYMBOL) {
      setState(1676);
      match(MySQLParser::COMMENT_SYMBOL);
      setState(1677);
      textLiteral();
    }
    setState(1682);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DO_SYMBOL) {
      setState(1680);
      match(MySQLParser::DO_SYMBOL);
      setState(1681);
      compoundStatement();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterLogfileGroupContext ------------------------------------------------------------------

MySQLParser::AlterLogfileGroupContext::AlterLogfileGroupContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterLogfileGroupContext::LOGFILE_SYMBOL() {
  return getToken(MySQLParser::LOGFILE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterLogfileGroupContext::GROUP_SYMBOL() {
  return getToken(MySQLParser::GROUP_SYMBOL, 0);
}

MySQLParser::LogfileGroupRefContext* MySQLParser::AlterLogfileGroupContext::logfileGroupRef() {
  return getRuleContext<MySQLParser::LogfileGroupRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterLogfileGroupContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterLogfileGroupContext::UNDOFILE_SYMBOL() {
  return getToken(MySQLParser::UNDOFILE_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::AlterLogfileGroupContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

MySQLParser::AlterLogfileGroupOptionsContext* MySQLParser::AlterLogfileGroupContext::alterLogfileGroupOptions() {
  return getRuleContext<MySQLParser::AlterLogfileGroupOptionsContext>(0);
}


size_t MySQLParser::AlterLogfileGroupContext::getRuleIndex() const {
  return MySQLParser::RuleAlterLogfileGroup;
}

void MySQLParser::AlterLogfileGroupContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterLogfileGroup(this);
}

void MySQLParser::AlterLogfileGroupContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterLogfileGroup(this);
}


std::any MySQLParser::AlterLogfileGroupContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterLogfileGroup(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterLogfileGroupContext* MySQLParser::alterLogfileGroup() {
  AlterLogfileGroupContext *_localctx = _tracker.createInstance<AlterLogfileGroupContext>(_ctx, getState());
  enterRule(_localctx, 12, MySQLParser::RuleAlterLogfileGroup);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1684);
    match(MySQLParser::LOGFILE_SYMBOL);
    setState(1685);
    match(MySQLParser::GROUP_SYMBOL);
    setState(1686);
    logfileGroupRef();
    setState(1687);
    match(MySQLParser::ADD_SYMBOL);
    setState(1688);
    match(MySQLParser::UNDOFILE_SYMBOL);
    setState(1689);
    textLiteral();
    setState(1691);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::INITIAL_SIZE_SYMBOL || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
      setState(1690);
      alterLogfileGroupOptions();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterLogfileGroupOptionsContext ------------------------------------------------------------------

MySQLParser::AlterLogfileGroupOptionsContext::AlterLogfileGroupOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::AlterLogfileGroupOptionContext *> MySQLParser::AlterLogfileGroupOptionsContext::alterLogfileGroupOption() {
  return getRuleContexts<MySQLParser::AlterLogfileGroupOptionContext>();
}

MySQLParser::AlterLogfileGroupOptionContext* MySQLParser::AlterLogfileGroupOptionsContext::alterLogfileGroupOption(size_t i) {
  return getRuleContext<MySQLParser::AlterLogfileGroupOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterLogfileGroupOptionsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterLogfileGroupOptionsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::AlterLogfileGroupOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleAlterLogfileGroupOptions;
}

void MySQLParser::AlterLogfileGroupOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterLogfileGroupOptions(this);
}

void MySQLParser::AlterLogfileGroupOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterLogfileGroupOptions(this);
}


std::any MySQLParser::AlterLogfileGroupOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterLogfileGroupOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterLogfileGroupOptionsContext* MySQLParser::alterLogfileGroupOptions() {
  AlterLogfileGroupOptionsContext *_localctx = _tracker.createInstance<AlterLogfileGroupOptionsContext>(_ctx, getState());
  enterRule(_localctx, 14, MySQLParser::RuleAlterLogfileGroupOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1693);
    alterLogfileGroupOption();
    setState(1700);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL || _la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::INITIAL_SIZE_SYMBOL || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
      setState(1695);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::COMMA_SYMBOL) {
        setState(1694);
        match(MySQLParser::COMMA_SYMBOL);
      }
      setState(1697);
      alterLogfileGroupOption();
      setState(1702);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterLogfileGroupOptionContext ------------------------------------------------------------------

MySQLParser::AlterLogfileGroupOptionContext::AlterLogfileGroupOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TsOptionInitialSizeContext* MySQLParser::AlterLogfileGroupOptionContext::tsOptionInitialSize() {
  return getRuleContext<MySQLParser::TsOptionInitialSizeContext>(0);
}

MySQLParser::TsOptionEngineContext* MySQLParser::AlterLogfileGroupOptionContext::tsOptionEngine() {
  return getRuleContext<MySQLParser::TsOptionEngineContext>(0);
}

MySQLParser::TsOptionWaitContext* MySQLParser::AlterLogfileGroupOptionContext::tsOptionWait() {
  return getRuleContext<MySQLParser::TsOptionWaitContext>(0);
}


size_t MySQLParser::AlterLogfileGroupOptionContext::getRuleIndex() const {
  return MySQLParser::RuleAlterLogfileGroupOption;
}

void MySQLParser::AlterLogfileGroupOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterLogfileGroupOption(this);
}

void MySQLParser::AlterLogfileGroupOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterLogfileGroupOption(this);
}


std::any MySQLParser::AlterLogfileGroupOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterLogfileGroupOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterLogfileGroupOptionContext* MySQLParser::alterLogfileGroupOption() {
  AlterLogfileGroupOptionContext *_localctx = _tracker.createInstance<AlterLogfileGroupOptionContext>(_ctx, getState());
  enterRule(_localctx, 16, MySQLParser::RuleAlterLogfileGroupOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1706);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::INITIAL_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(1703);
        tsOptionInitialSize();
        break;
      }

      case MySQLParser::ENGINE_SYMBOL:
      case MySQLParser::STORAGE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(1704);
        tsOptionEngine();
        break;
      }

      case MySQLParser::NO_WAIT_SYMBOL:
      case MySQLParser::WAIT_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(1705);
        tsOptionWait();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterServerContext ------------------------------------------------------------------

MySQLParser::AlterServerContext::AlterServerContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterServerContext::SERVER_SYMBOL() {
  return getToken(MySQLParser::SERVER_SYMBOL, 0);
}

MySQLParser::ServerRefContext* MySQLParser::AlterServerContext::serverRef() {
  return getRuleContext<MySQLParser::ServerRefContext>(0);
}

MySQLParser::ServerOptionsContext* MySQLParser::AlterServerContext::serverOptions() {
  return getRuleContext<MySQLParser::ServerOptionsContext>(0);
}


size_t MySQLParser::AlterServerContext::getRuleIndex() const {
  return MySQLParser::RuleAlterServer;
}

void MySQLParser::AlterServerContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterServer(this);
}

void MySQLParser::AlterServerContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterServer(this);
}


std::any MySQLParser::AlterServerContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterServer(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterServerContext* MySQLParser::alterServer() {
  AlterServerContext *_localctx = _tracker.createInstance<AlterServerContext>(_ctx, getState());
  enterRule(_localctx, 18, MySQLParser::RuleAlterServer);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1708);
    match(MySQLParser::SERVER_SYMBOL);
    setState(1709);
    serverRef();
    setState(1710);
    serverOptions();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterTableContext ------------------------------------------------------------------

MySQLParser::AlterTableContext::AlterTableContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterTableContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::AlterTableContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::OnlineOptionContext* MySQLParser::AlterTableContext::onlineOption() {
  return getRuleContext<MySQLParser::OnlineOptionContext>(0);
}

MySQLParser::AlterTableActionsContext* MySQLParser::AlterTableContext::alterTableActions() {
  return getRuleContext<MySQLParser::AlterTableActionsContext>(0);
}


size_t MySQLParser::AlterTableContext::getRuleIndex() const {
  return MySQLParser::RuleAlterTable;
}

void MySQLParser::AlterTableContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterTable(this);
}

void MySQLParser::AlterTableContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterTable(this);
}


std::any MySQLParser::AlterTableContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterTable(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterTableContext* MySQLParser::alterTable() {
  AlterTableContext *_localctx = _tracker.createInstance<AlterTableContext>(_ctx, getState());
  enterRule(_localctx, 20, MySQLParser::RuleAlterTable);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1713);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OFFLINE_SYMBOL

    || _la == MySQLParser::ONLINE_SYMBOL) {
      setState(1712);
      onlineOption();
    }
    setState(1715);
    match(MySQLParser::TABLE_SYMBOL);
    setState(1716);
    tableRef();
    setState(1718);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 25, _ctx)) {
    case 1: {
      setState(1717);
      alterTableActions();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterTableActionsContext ------------------------------------------------------------------

MySQLParser::AlterTableActionsContext::AlterTableActionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::AlterCommandListContext* MySQLParser::AlterTableActionsContext::alterCommandList() {
  return getRuleContext<MySQLParser::AlterCommandListContext>(0);
}

MySQLParser::PartitionClauseContext* MySQLParser::AlterTableActionsContext::partitionClause() {
  return getRuleContext<MySQLParser::PartitionClauseContext>(0);
}

MySQLParser::RemovePartitioningContext* MySQLParser::AlterTableActionsContext::removePartitioning() {
  return getRuleContext<MySQLParser::RemovePartitioningContext>(0);
}

MySQLParser::StandaloneAlterCommandsContext* MySQLParser::AlterTableActionsContext::standaloneAlterCommands() {
  return getRuleContext<MySQLParser::StandaloneAlterCommandsContext>(0);
}

MySQLParser::AlterCommandsModifierListContext* MySQLParser::AlterTableActionsContext::alterCommandsModifierList() {
  return getRuleContext<MySQLParser::AlterCommandsModifierListContext>(0);
}

tree::TerminalNode* MySQLParser::AlterTableActionsContext::COMMA_SYMBOL() {
  return getToken(MySQLParser::COMMA_SYMBOL, 0);
}


size_t MySQLParser::AlterTableActionsContext::getRuleIndex() const {
  return MySQLParser::RuleAlterTableActions;
}

void MySQLParser::AlterTableActionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterTableActions(this);
}

void MySQLParser::AlterTableActionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterTableActions(this);
}


std::any MySQLParser::AlterTableActionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterTableActions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterTableActionsContext* MySQLParser::alterTableActions() {
  AlterTableActionsContext *_localctx = _tracker.createInstance<AlterTableActionsContext>(_ctx, getState());
  enterRule(_localctx, 22, MySQLParser::RuleAlterTableActions);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1733);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 28, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1720);
      alterCommandList();
      setState(1723);
      _errHandler->sync(this);
      switch (_input->LA(1)) {
        case MySQLParser::PARTITION_SYMBOL: {
          setState(1721);
          partitionClause();
          break;
        }

        case MySQLParser::REMOVE_SYMBOL: {
          setState(1722);
          removePartitioning();
          break;
        }

        case MySQLParser::EOF:
        case MySQLParser::SEMICOLON_SYMBOL: {
          break;
        }

      default:
        break;
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1725);
      partitionClause();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1726);
      removePartitioning();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(1730);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 27, _ctx)) {
      case 1: {
        setState(1727);
        alterCommandsModifierList();
        setState(1728);
        match(MySQLParser::COMMA_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1732);
      standaloneAlterCommands();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterCommandListContext ------------------------------------------------------------------

MySQLParser::AlterCommandListContext::AlterCommandListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::AlterCommandsModifierListContext* MySQLParser::AlterCommandListContext::alterCommandsModifierList() {
  return getRuleContext<MySQLParser::AlterCommandsModifierListContext>(0);
}

MySQLParser::AlterListContext* MySQLParser::AlterCommandListContext::alterList() {
  return getRuleContext<MySQLParser::AlterListContext>(0);
}

tree::TerminalNode* MySQLParser::AlterCommandListContext::COMMA_SYMBOL() {
  return getToken(MySQLParser::COMMA_SYMBOL, 0);
}


size_t MySQLParser::AlterCommandListContext::getRuleIndex() const {
  return MySQLParser::RuleAlterCommandList;
}

void MySQLParser::AlterCommandListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterCommandList(this);
}

void MySQLParser::AlterCommandListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterCommandList(this);
}


std::any MySQLParser::AlterCommandListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterCommandList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterCommandListContext* MySQLParser::alterCommandList() {
  AlterCommandListContext *_localctx = _tracker.createInstance<AlterCommandListContext>(_ctx, getState());
  enterRule(_localctx, 24, MySQLParser::RuleAlterCommandList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1742);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 30, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1735);
      alterCommandsModifierList();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1739);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 29, _ctx)) {
      case 1: {
        setState(1736);
        alterCommandsModifierList();
        setState(1737);
        match(MySQLParser::COMMA_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1741);
      alterList();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterCommandsModifierListContext ------------------------------------------------------------------

MySQLParser::AlterCommandsModifierListContext::AlterCommandsModifierListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::AlterCommandsModifierContext *> MySQLParser::AlterCommandsModifierListContext::alterCommandsModifier() {
  return getRuleContexts<MySQLParser::AlterCommandsModifierContext>();
}

MySQLParser::AlterCommandsModifierContext* MySQLParser::AlterCommandsModifierListContext::alterCommandsModifier(size_t i) {
  return getRuleContext<MySQLParser::AlterCommandsModifierContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterCommandsModifierListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterCommandsModifierListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::AlterCommandsModifierListContext::getRuleIndex() const {
  return MySQLParser::RuleAlterCommandsModifierList;
}

void MySQLParser::AlterCommandsModifierListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterCommandsModifierList(this);
}

void MySQLParser::AlterCommandsModifierListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterCommandsModifierList(this);
}


std::any MySQLParser::AlterCommandsModifierListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterCommandsModifierList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterCommandsModifierListContext* MySQLParser::alterCommandsModifierList() {
  AlterCommandsModifierListContext *_localctx = _tracker.createInstance<AlterCommandsModifierListContext>(_ctx, getState());
  enterRule(_localctx, 26, MySQLParser::RuleAlterCommandsModifierList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(1744);
    alterCommandsModifier();
    setState(1749);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 31, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(1745);
        match(MySQLParser::COMMA_SYMBOL);
        setState(1746);
        alterCommandsModifier(); 
      }
      setState(1751);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 31, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- StandaloneAlterCommandsContext ------------------------------------------------------------------

MySQLParser::StandaloneAlterCommandsContext::StandaloneAlterCommandsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::StandaloneAlterCommandsContext::DISCARD_SYMBOL() {
  return getToken(MySQLParser::DISCARD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::StandaloneAlterCommandsContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::StandaloneAlterCommandsContext::IMPORT_SYMBOL() {
  return getToken(MySQLParser::IMPORT_SYMBOL, 0);
}

MySQLParser::AlterPartitionContext* MySQLParser::StandaloneAlterCommandsContext::alterPartition() {
  return getRuleContext<MySQLParser::AlterPartitionContext>(0);
}

tree::TerminalNode* MySQLParser::StandaloneAlterCommandsContext::SECONDARY_LOAD_SYMBOL() {
  return getToken(MySQLParser::SECONDARY_LOAD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::StandaloneAlterCommandsContext::SECONDARY_UNLOAD_SYMBOL() {
  return getToken(MySQLParser::SECONDARY_UNLOAD_SYMBOL, 0);
}


size_t MySQLParser::StandaloneAlterCommandsContext::getRuleIndex() const {
  return MySQLParser::RuleStandaloneAlterCommands;
}

void MySQLParser::StandaloneAlterCommandsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterStandaloneAlterCommands(this);
}

void MySQLParser::StandaloneAlterCommandsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitStandaloneAlterCommands(this);
}


std::any MySQLParser::StandaloneAlterCommandsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitStandaloneAlterCommands(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::StandaloneAlterCommandsContext* MySQLParser::standaloneAlterCommands() {
  StandaloneAlterCommandsContext *_localctx = _tracker.createInstance<StandaloneAlterCommandsContext>(_ctx, getState());
  enterRule(_localctx, 28, MySQLParser::RuleStandaloneAlterCommands);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1759);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 32, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1752);
      match(MySQLParser::DISCARD_SYMBOL);
      setState(1753);
      match(MySQLParser::TABLESPACE_SYMBOL);
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1754);
      match(MySQLParser::IMPORT_SYMBOL);
      setState(1755);
      match(MySQLParser::TABLESPACE_SYMBOL);
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1756);
      alterPartition();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(1757);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(1758);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::SECONDARY_LOAD_SYMBOL

      || _la == MySQLParser::SECONDARY_UNLOAD_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterPartitionContext ------------------------------------------------------------------

MySQLParser::AlterPartitionContext::AlterPartitionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::PARTITION_SYMBOL() {
  return getToken(MySQLParser::PARTITION_SYMBOL, 0);
}

MySQLParser::PartitionDefinitionsContext* MySQLParser::AlterPartitionContext::partitionDefinitions() {
  return getRuleContext<MySQLParser::PartitionDefinitionsContext>(0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::PARTITIONS_SYMBOL() {
  return getToken(MySQLParser::PARTITIONS_SYMBOL, 0);
}

MySQLParser::Real_ulong_numberContext* MySQLParser::AlterPartitionContext::real_ulong_number() {
  return getRuleContext<MySQLParser::Real_ulong_numberContext>(0);
}

std::vector<MySQLParser::NoWriteToBinLogContext *> MySQLParser::AlterPartitionContext::noWriteToBinLog() {
  return getRuleContexts<MySQLParser::NoWriteToBinLogContext>();
}

MySQLParser::NoWriteToBinLogContext* MySQLParser::AlterPartitionContext::noWriteToBinLog(size_t i) {
  return getRuleContext<MySQLParser::NoWriteToBinLogContext>(i);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::DROP_SYMBOL() {
  return getToken(MySQLParser::DROP_SYMBOL, 0);
}

MySQLParser::IdentifierListContext* MySQLParser::AlterPartitionContext::identifierList() {
  return getRuleContext<MySQLParser::IdentifierListContext>(0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::REBUILD_SYMBOL() {
  return getToken(MySQLParser::REBUILD_SYMBOL, 0);
}

MySQLParser::AllOrPartitionNameListContext* MySQLParser::AlterPartitionContext::allOrPartitionNameList() {
  return getRuleContext<MySQLParser::AllOrPartitionNameListContext>(0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::OPTIMIZE_SYMBOL() {
  return getToken(MySQLParser::OPTIMIZE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::ANALYZE_SYMBOL() {
  return getToken(MySQLParser::ANALYZE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::CHECK_SYMBOL() {
  return getToken(MySQLParser::CHECK_SYMBOL, 0);
}

std::vector<MySQLParser::CheckOptionContext *> MySQLParser::AlterPartitionContext::checkOption() {
  return getRuleContexts<MySQLParser::CheckOptionContext>();
}

MySQLParser::CheckOptionContext* MySQLParser::AlterPartitionContext::checkOption(size_t i) {
  return getRuleContext<MySQLParser::CheckOptionContext>(i);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::REPAIR_SYMBOL() {
  return getToken(MySQLParser::REPAIR_SYMBOL, 0);
}

std::vector<MySQLParser::RepairTypeContext *> MySQLParser::AlterPartitionContext::repairType() {
  return getRuleContexts<MySQLParser::RepairTypeContext>();
}

MySQLParser::RepairTypeContext* MySQLParser::AlterPartitionContext::repairType(size_t i) {
  return getRuleContext<MySQLParser::RepairTypeContext>(i);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::COALESCE_SYMBOL() {
  return getToken(MySQLParser::COALESCE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::TRUNCATE_SYMBOL() {
  return getToken(MySQLParser::TRUNCATE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::REORGANIZE_SYMBOL() {
  return getToken(MySQLParser::REORGANIZE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::INTO_SYMBOL() {
  return getToken(MySQLParser::INTO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::EXCHANGE_SYMBOL() {
  return getToken(MySQLParser::EXCHANGE_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::AlterPartitionContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::WITH_SYMBOL() {
  return getToken(MySQLParser::WITH_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::AlterPartitionContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::WithValidationContext* MySQLParser::AlterPartitionContext::withValidation() {
  return getRuleContext<MySQLParser::WithValidationContext>(0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::DISCARD_SYMBOL() {
  return getToken(MySQLParser::DISCARD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::IMPORT_SYMBOL() {
  return getToken(MySQLParser::IMPORT_SYMBOL, 0);
}


size_t MySQLParser::AlterPartitionContext::getRuleIndex() const {
  return MySQLParser::RuleAlterPartition;
}

void MySQLParser::AlterPartitionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterPartition(this);
}

void MySQLParser::AlterPartitionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterPartition(this);
}


std::any MySQLParser::AlterPartitionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterPartition(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterPartitionContext* MySQLParser::alterPartition() {
  AlterPartitionContext *_localctx = _tracker.createInstance<AlterPartitionContext>(_ctx, getState());
  enterRule(_localctx, 30, MySQLParser::RuleAlterPartition);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1857);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 46, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1761);
      match(MySQLParser::ADD_SYMBOL);
      setState(1762);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1764);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::LOCAL_SYMBOL || _la == MySQLParser::NO_WRITE_TO_BINLOG_SYMBOL) {
        setState(1763);
        noWriteToBinLog();
      }
      setState(1769);
      _errHandler->sync(this);
      switch (_input->LA(1)) {
        case MySQLParser::OPEN_PAR_SYMBOL: {
          setState(1766);
          partitionDefinitions();
          break;
        }

        case MySQLParser::PARTITIONS_SYMBOL: {
          setState(1767);
          match(MySQLParser::PARTITIONS_SYMBOL);
          setState(1768);
          real_ulong_number();
          break;
        }

      default:
        throw NoViableAltException(this);
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1771);
      match(MySQLParser::DROP_SYMBOL);
      setState(1772);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1773);
      identifierList();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1774);
      match(MySQLParser::REBUILD_SYMBOL);
      setState(1775);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1777);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 35, _ctx)) {
      case 1: {
        setState(1776);
        noWriteToBinLog();
        break;
      }

      default:
        break;
      }
      setState(1779);
      allOrPartitionNameList();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(1780);
      match(MySQLParser::OPTIMIZE_SYMBOL);
      setState(1781);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1783);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 36, _ctx)) {
      case 1: {
        setState(1782);
        noWriteToBinLog();
        break;
      }

      default:
        break;
      }
      setState(1785);
      allOrPartitionNameList();
      setState(1787);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::LOCAL_SYMBOL || _la == MySQLParser::NO_WRITE_TO_BINLOG_SYMBOL) {
        setState(1786);
        noWriteToBinLog();
      }
      break;
    }

    case 5: {
      enterOuterAlt(_localctx, 5);
      setState(1789);
      match(MySQLParser::ANALYZE_SYMBOL);
      setState(1790);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1792);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 38, _ctx)) {
      case 1: {
        setState(1791);
        noWriteToBinLog();
        break;
      }

      default:
        break;
      }
      setState(1794);
      allOrPartitionNameList();
      break;
    }

    case 6: {
      enterOuterAlt(_localctx, 6);
      setState(1795);
      match(MySQLParser::CHECK_SYMBOL);
      setState(1796);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1797);
      allOrPartitionNameList();
      setState(1801);
      _errHandler->sync(this);
      _la = _input->LA(1);
      while (_la == MySQLParser::CHANGED_SYMBOL || ((((_la - 219) & ~ 0x3fULL) == 0) &&
        ((1ULL << (_la - 219)) & ((1ULL << (MySQLParser::EXTENDED_SYMBOL - 219))
        | (1ULL << (MySQLParser::FAST_SYMBOL - 219))
        | (1ULL << (MySQLParser::FOR_SYMBOL - 219)))) != 0) || _la == MySQLParser::MEDIUM_SYMBOL || _la == MySQLParser::QUICK_SYMBOL) {
        setState(1798);
        checkOption();
        setState(1803);
        _errHandler->sync(this);
        _la = _input->LA(1);
      }
      break;
    }

    case 7: {
      enterOuterAlt(_localctx, 7);
      setState(1804);
      match(MySQLParser::REPAIR_SYMBOL);
      setState(1805);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1807);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 40, _ctx)) {
      case 1: {
        setState(1806);
        noWriteToBinLog();
        break;
      }

      default:
        break;
      }
      setState(1809);
      allOrPartitionNameList();
      setState(1813);
      _errHandler->sync(this);
      _la = _input->LA(1);
      while (_la == MySQLParser::EXTENDED_SYMBOL || _la == MySQLParser::QUICK_SYMBOL || _la == MySQLParser::USE_FRM_SYMBOL) {
        setState(1810);
        repairType();
        setState(1815);
        _errHandler->sync(this);
        _la = _input->LA(1);
      }
      break;
    }

    case 8: {
      enterOuterAlt(_localctx, 8);
      setState(1816);
      match(MySQLParser::COALESCE_SYMBOL);
      setState(1817);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1819);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::LOCAL_SYMBOL || _la == MySQLParser::NO_WRITE_TO_BINLOG_SYMBOL) {
        setState(1818);
        noWriteToBinLog();
      }
      setState(1821);
      real_ulong_number();
      break;
    }

    case 9: {
      enterOuterAlt(_localctx, 9);
      setState(1822);
      match(MySQLParser::TRUNCATE_SYMBOL);
      setState(1823);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1824);
      allOrPartitionNameList();
      break;
    }

    case 10: {
      enterOuterAlt(_localctx, 10);
      setState(1825);
      match(MySQLParser::REORGANIZE_SYMBOL);
      setState(1826);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1828);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 43, _ctx)) {
      case 1: {
        setState(1827);
        noWriteToBinLog();
        break;
      }

      default:
        break;
      }
      setState(1834);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 44, _ctx)) {
      case 1: {
        setState(1830);
        identifierList();
        setState(1831);
        match(MySQLParser::INTO_SYMBOL);
        setState(1832);
        partitionDefinitions();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 11: {
      enterOuterAlt(_localctx, 11);
      setState(1836);
      match(MySQLParser::EXCHANGE_SYMBOL);
      setState(1837);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1838);
      identifier();
      setState(1839);
      match(MySQLParser::WITH_SYMBOL);
      setState(1840);
      match(MySQLParser::TABLE_SYMBOL);
      setState(1841);
      tableRef();
      setState(1843);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 45, _ctx)) {
      case 1: {
        setState(1842);
        withValidation();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 12: {
      enterOuterAlt(_localctx, 12);
      setState(1845);

      if (!(serverVersion >= 50704)) throw FailedPredicateException(this, "serverVersion >= 50704");
      setState(1846);
      match(MySQLParser::DISCARD_SYMBOL);
      setState(1847);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1848);
      allOrPartitionNameList();
      setState(1849);
      match(MySQLParser::TABLESPACE_SYMBOL);
      break;
    }

    case 13: {
      enterOuterAlt(_localctx, 13);
      setState(1851);

      if (!(serverVersion >= 50704)) throw FailedPredicateException(this, "serverVersion >= 50704");
      setState(1852);
      match(MySQLParser::IMPORT_SYMBOL);
      setState(1853);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1854);
      allOrPartitionNameList();
      setState(1855);
      match(MySQLParser::TABLESPACE_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterListContext ------------------------------------------------------------------

MySQLParser::AlterListContext::AlterListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::AlterListItemContext *> MySQLParser::AlterListContext::alterListItem() {
  return getRuleContexts<MySQLParser::AlterListItemContext>();
}

MySQLParser::AlterListItemContext* MySQLParser::AlterListContext::alterListItem(size_t i) {
  return getRuleContext<MySQLParser::AlterListItemContext>(i);
}

std::vector<MySQLParser::CreateTableOptionsSpaceSeparatedContext *> MySQLParser::AlterListContext::createTableOptionsSpaceSeparated() {
  return getRuleContexts<MySQLParser::CreateTableOptionsSpaceSeparatedContext>();
}

MySQLParser::CreateTableOptionsSpaceSeparatedContext* MySQLParser::AlterListContext::createTableOptionsSpaceSeparated(size_t i) {
  return getRuleContext<MySQLParser::CreateTableOptionsSpaceSeparatedContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}

std::vector<MySQLParser::AlterCommandsModifierContext *> MySQLParser::AlterListContext::alterCommandsModifier() {
  return getRuleContexts<MySQLParser::AlterCommandsModifierContext>();
}

MySQLParser::AlterCommandsModifierContext* MySQLParser::AlterListContext::alterCommandsModifier(size_t i) {
  return getRuleContext<MySQLParser::AlterCommandsModifierContext>(i);
}


size_t MySQLParser::AlterListContext::getRuleIndex() const {
  return MySQLParser::RuleAlterList;
}

void MySQLParser::AlterListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterList(this);
}

void MySQLParser::AlterListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterList(this);
}


std::any MySQLParser::AlterListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterListContext* MySQLParser::alterList() {
  AlterListContext *_localctx = _tracker.createInstance<AlterListContext>(_ctx, getState());
  enterRule(_localctx, 32, MySQLParser::RuleAlterList);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1861);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 47, _ctx)) {
    case 1: {
      setState(1859);
      alterListItem();
      break;
    }

    case 2: {
      setState(1860);
      createTableOptionsSpaceSeparated();
      break;
    }

    default:
      break;
    }
    setState(1871);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(1863);
      match(MySQLParser::COMMA_SYMBOL);
      setState(1867);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 48, _ctx)) {
      case 1: {
        setState(1864);
        alterListItem();
        break;
      }

      case 2: {
        setState(1865);
        alterCommandsModifier();
        break;
      }

      case 3: {
        setState(1866);
        createTableOptionsSpaceSeparated();
        break;
      }

      default:
        break;
      }
      setState(1873);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterCommandsModifierContext ------------------------------------------------------------------

MySQLParser::AlterCommandsModifierContext::AlterCommandsModifierContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::AlterAlgorithmOptionContext* MySQLParser::AlterCommandsModifierContext::alterAlgorithmOption() {
  return getRuleContext<MySQLParser::AlterAlgorithmOptionContext>(0);
}

MySQLParser::AlterLockOptionContext* MySQLParser::AlterCommandsModifierContext::alterLockOption() {
  return getRuleContext<MySQLParser::AlterLockOptionContext>(0);
}

MySQLParser::WithValidationContext* MySQLParser::AlterCommandsModifierContext::withValidation() {
  return getRuleContext<MySQLParser::WithValidationContext>(0);
}


size_t MySQLParser::AlterCommandsModifierContext::getRuleIndex() const {
  return MySQLParser::RuleAlterCommandsModifier;
}

void MySQLParser::AlterCommandsModifierContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterCommandsModifier(this);
}

void MySQLParser::AlterCommandsModifierContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterCommandsModifier(this);
}


std::any MySQLParser::AlterCommandsModifierContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterCommandsModifier(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterCommandsModifierContext* MySQLParser::alterCommandsModifier() {
  AlterCommandsModifierContext *_localctx = _tracker.createInstance<AlterCommandsModifierContext>(_ctx, getState());
  enterRule(_localctx, 34, MySQLParser::RuleAlterCommandsModifier);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1877);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 50, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1874);
      alterAlgorithmOption();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1875);
      alterLockOption();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1876);
      withValidation();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterListItemContext ------------------------------------------------------------------

MySQLParser::AlterListItemContext::AlterListItemContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterListItemContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::AlterListItemContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

MySQLParser::FieldDefinitionContext* MySQLParser::AlterListItemContext::fieldDefinition() {
  return getRuleContext<MySQLParser::FieldDefinitionContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

MySQLParser::TableElementListContext* MySQLParser::AlterListItemContext::tableElementList() {
  return getRuleContext<MySQLParser::TableElementListContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::COLUMN_SYMBOL() {
  return getToken(MySQLParser::COLUMN_SYMBOL, 0);
}

MySQLParser::CheckOrReferencesContext* MySQLParser::AlterListItemContext::checkOrReferences() {
  return getRuleContext<MySQLParser::CheckOrReferencesContext>(0);
}

MySQLParser::PlaceContext* MySQLParser::AlterListItemContext::place() {
  return getRuleContext<MySQLParser::PlaceContext>(0);
}

MySQLParser::TableConstraintDefContext* MySQLParser::AlterListItemContext::tableConstraintDef() {
  return getRuleContext<MySQLParser::TableConstraintDefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::CHANGE_SYMBOL() {
  return getToken(MySQLParser::CHANGE_SYMBOL, 0);
}

MySQLParser::ColumnInternalRefContext* MySQLParser::AlterListItemContext::columnInternalRef() {
  return getRuleContext<MySQLParser::ColumnInternalRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::MODIFY_SYMBOL() {
  return getToken(MySQLParser::MODIFY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::DROP_SYMBOL() {
  return getToken(MySQLParser::DROP_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::FOREIGN_SYMBOL() {
  return getToken(MySQLParser::FOREIGN_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::KEY_SYMBOL() {
  return getToken(MySQLParser::KEY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::PRIMARY_SYMBOL() {
  return getToken(MySQLParser::PRIMARY_SYMBOL, 0);
}

MySQLParser::KeyOrIndexContext* MySQLParser::AlterListItemContext::keyOrIndex() {
  return getRuleContext<MySQLParser::KeyOrIndexContext>(0);
}

MySQLParser::IndexRefContext* MySQLParser::AlterListItemContext::indexRef() {
  return getRuleContext<MySQLParser::IndexRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::CHECK_SYMBOL() {
  return getToken(MySQLParser::CHECK_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::CONSTRAINT_SYMBOL() {
  return getToken(MySQLParser::CONSTRAINT_SYMBOL, 0);
}

MySQLParser::RestrictContext* MySQLParser::AlterListItemContext::restrict() {
  return getRuleContext<MySQLParser::RestrictContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::DISABLE_SYMBOL() {
  return getToken(MySQLParser::DISABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::KEYS_SYMBOL() {
  return getToken(MySQLParser::KEYS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::ENABLE_SYMBOL() {
  return getToken(MySQLParser::ENABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::ALTER_SYMBOL() {
  return getToken(MySQLParser::ALTER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::SET_SYMBOL() {
  return getToken(MySQLParser::SET_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::DEFAULT_SYMBOL() {
  return getToken(MySQLParser::DEFAULT_SYMBOL, 0);
}

MySQLParser::VisibilityContext* MySQLParser::AlterListItemContext::visibility() {
  return getRuleContext<MySQLParser::VisibilityContext>(0);
}

MySQLParser::ExprWithParenthesesContext* MySQLParser::AlterListItemContext::exprWithParentheses() {
  return getRuleContext<MySQLParser::ExprWithParenthesesContext>(0);
}

MySQLParser::SignedLiteralOrNullContext* MySQLParser::AlterListItemContext::signedLiteralOrNull() {
  return getRuleContext<MySQLParser::SignedLiteralOrNullContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::INDEX_SYMBOL() {
  return getToken(MySQLParser::INDEX_SYMBOL, 0);
}

MySQLParser::ConstraintEnforcementContext* MySQLParser::AlterListItemContext::constraintEnforcement() {
  return getRuleContext<MySQLParser::ConstraintEnforcementContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::RENAME_SYMBOL() {
  return getToken(MySQLParser::RENAME_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::TO_SYMBOL() {
  return getToken(MySQLParser::TO_SYMBOL, 0);
}

MySQLParser::TableNameContext* MySQLParser::AlterListItemContext::tableName() {
  return getRuleContext<MySQLParser::TableNameContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}

MySQLParser::IndexNameContext* MySQLParser::AlterListItemContext::indexName() {
  return getRuleContext<MySQLParser::IndexNameContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::CONVERT_SYMBOL() {
  return getToken(MySQLParser::CONVERT_SYMBOL, 0);
}

MySQLParser::CharsetContext* MySQLParser::AlterListItemContext::charset() {
  return getRuleContext<MySQLParser::CharsetContext>(0);
}

MySQLParser::CharsetNameContext* MySQLParser::AlterListItemContext::charsetName() {
  return getRuleContext<MySQLParser::CharsetNameContext>(0);
}

MySQLParser::CollateContext* MySQLParser::AlterListItemContext::collate() {
  return getRuleContext<MySQLParser::CollateContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::FORCE_SYMBOL() {
  return getToken(MySQLParser::FORCE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::ORDER_SYMBOL() {
  return getToken(MySQLParser::ORDER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::BY_SYMBOL() {
  return getToken(MySQLParser::BY_SYMBOL, 0);
}

MySQLParser::AlterOrderListContext* MySQLParser::AlterListItemContext::alterOrderList() {
  return getRuleContext<MySQLParser::AlterOrderListContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::UPGRADE_SYMBOL() {
  return getToken(MySQLParser::UPGRADE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::PARTITIONING_SYMBOL() {
  return getToken(MySQLParser::PARTITIONING_SYMBOL, 0);
}


size_t MySQLParser::AlterListItemContext::getRuleIndex() const {
  return MySQLParser::RuleAlterListItem;
}

void MySQLParser::AlterListItemContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterListItem(this);
}

void MySQLParser::AlterListItemContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterListItem(this);
}


std::any MySQLParser::AlterListItemContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterListItem(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterListItemContext* MySQLParser::alterListItem() {
  AlterListItemContext *_localctx = _tracker.createInstance<AlterListItemContext>(_ctx, getState());
  enterRule(_localctx, 36, MySQLParser::RuleAlterListItem);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2019);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 68, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1879);
      match(MySQLParser::ADD_SYMBOL);
      setState(1881);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 51, _ctx)) {
      case 1: {
        setState(1880);
        match(MySQLParser::COLUMN_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1895);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 54, _ctx)) {
      case 1: {
        setState(1883);
        identifier();
        setState(1884);
        fieldDefinition();
        setState(1886);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 52, _ctx)) {
        case 1: {
          setState(1885);
          checkOrReferences();
          break;
        }

        default:
          break;
        }
        setState(1889);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::AFTER_SYMBOL || _la == MySQLParser::FIRST_SYMBOL) {
          setState(1888);
          place();
        }
        break;
      }

      case 2: {
        setState(1891);
        match(MySQLParser::OPEN_PAR_SYMBOL);
        setState(1892);
        tableElementList();
        setState(1893);
        match(MySQLParser::CLOSE_PAR_SYMBOL);
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1897);
      match(MySQLParser::ADD_SYMBOL);
      setState(1898);
      tableConstraintDef();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1899);
      match(MySQLParser::CHANGE_SYMBOL);
      setState(1901);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 55, _ctx)) {
      case 1: {
        setState(1900);
        match(MySQLParser::COLUMN_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1903);
      columnInternalRef();
      setState(1904);
      identifier();
      setState(1905);
      fieldDefinition();
      setState(1907);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::AFTER_SYMBOL || _la == MySQLParser::FIRST_SYMBOL) {
        setState(1906);
        place();
      }
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(1909);
      match(MySQLParser::MODIFY_SYMBOL);
      setState(1911);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 57, _ctx)) {
      case 1: {
        setState(1910);
        match(MySQLParser::COLUMN_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1913);
      columnInternalRef();
      setState(1914);
      fieldDefinition();
      setState(1916);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::AFTER_SYMBOL || _la == MySQLParser::FIRST_SYMBOL) {
        setState(1915);
        place();
      }
      break;
    }

    case 5: {
      enterOuterAlt(_localctx, 5);
      setState(1918);
      match(MySQLParser::DROP_SYMBOL);
      setState(1940);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 61, _ctx)) {
      case 1: {
        setState(1920);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 59, _ctx)) {
        case 1: {
          setState(1919);
          match(MySQLParser::COLUMN_SYMBOL);
          break;
        }

        default:
          break;
        }
        setState(1922);
        columnInternalRef();
        setState(1924);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::CASCADE_SYMBOL || _la == MySQLParser::RESTRICT_SYMBOL) {
          setState(1923);
          restrict();
        }
        break;
      }

      case 2: {
        setState(1926);
        match(MySQLParser::FOREIGN_SYMBOL);
        setState(1927);
        match(MySQLParser::KEY_SYMBOL);
        setState(1928);
        columnInternalRef();
        break;
      }

      case 3: {
        setState(1929);
        match(MySQLParser::PRIMARY_SYMBOL);
        setState(1930);
        match(MySQLParser::KEY_SYMBOL);
        break;
      }

      case 4: {
        setState(1931);
        keyOrIndex();
        setState(1932);
        indexRef();
        break;
      }

      case 5: {
        setState(1934);

        if (!(serverVersion >= 80017)) throw FailedPredicateException(this, "serverVersion >= 80017");
        setState(1935);
        match(MySQLParser::CHECK_SYMBOL);
        setState(1936);
        identifier();
        break;
      }

      case 6: {
        setState(1937);

        if (!(serverVersion >= 80019)) throw FailedPredicateException(this, "serverVersion >= 80019");
        setState(1938);
        match(MySQLParser::CONSTRAINT_SYMBOL);
        setState(1939);
        identifier();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 6: {
      enterOuterAlt(_localctx, 6);
      setState(1942);
      match(MySQLParser::DISABLE_SYMBOL);
      setState(1943);
      match(MySQLParser::KEYS_SYMBOL);
      break;
    }

    case 7: {
      enterOuterAlt(_localctx, 7);
      setState(1944);
      match(MySQLParser::ENABLE_SYMBOL);
      setState(1945);
      match(MySQLParser::KEYS_SYMBOL);
      break;
    }

    case 8: {
      enterOuterAlt(_localctx, 8);
      setState(1946);
      match(MySQLParser::ALTER_SYMBOL);
      setState(1948);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 62, _ctx)) {
      case 1: {
        setState(1947);
        match(MySQLParser::COLUMN_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1950);
      columnInternalRef();
      setState(1963);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 64, _ctx)) {
      case 1: {
        setState(1951);
        match(MySQLParser::SET_SYMBOL);
        setState(1952);
        match(MySQLParser::DEFAULT_SYMBOL);
        setState(1956);
        _errHandler->sync(this);
        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 63, _ctx)) {
        case 1: {
          setState(1953);

          if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
          setState(1954);
          exprWithParentheses();
          break;
        }

        case 2: {
          setState(1955);
          signedLiteralOrNull();
          break;
        }

        default:
          break;
        }
        break;
      }

      case 2: {
        setState(1958);
        match(MySQLParser::DROP_SYMBOL);
        setState(1959);
        match(MySQLParser::DEFAULT_SYMBOL);
        break;
      }

      case 3: {
        setState(1960);

        if (!(serverVersion >= 80024)) throw FailedPredicateException(this, "serverVersion >= 80024");
        setState(1961);
        match(MySQLParser::SET_SYMBOL);
        setState(1962);
        visibility();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 9: {
      enterOuterAlt(_localctx, 9);
      setState(1965);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(1966);
      match(MySQLParser::ALTER_SYMBOL);
      setState(1967);
      match(MySQLParser::INDEX_SYMBOL);
      setState(1968);
      indexRef();
      setState(1969);
      visibility();
      break;
    }

    case 10: {
      enterOuterAlt(_localctx, 10);
      setState(1971);

      if (!(serverVersion >= 80017)) throw FailedPredicateException(this, "serverVersion >= 80017");
      setState(1972);
      match(MySQLParser::ALTER_SYMBOL);
      setState(1973);
      match(MySQLParser::CHECK_SYMBOL);
      setState(1974);
      identifier();
      setState(1975);
      constraintEnforcement();
      break;
    }

    case 11: {
      enterOuterAlt(_localctx, 11);
      setState(1977);

      if (!(serverVersion >= 80019)) throw FailedPredicateException(this, "serverVersion >= 80019");
      setState(1978);
      match(MySQLParser::ALTER_SYMBOL);
      setState(1979);
      match(MySQLParser::CONSTRAINT_SYMBOL);
      setState(1980);
      identifier();
      setState(1981);
      constraintEnforcement();
      break;
    }

    case 12: {
      enterOuterAlt(_localctx, 12);
      setState(1983);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(1984);
      match(MySQLParser::RENAME_SYMBOL);
      setState(1985);
      match(MySQLParser::COLUMN_SYMBOL);
      setState(1986);
      columnInternalRef();
      setState(1987);
      match(MySQLParser::TO_SYMBOL);
      setState(1988);
      identifier();
      break;
    }

    case 13: {
      enterOuterAlt(_localctx, 13);
      setState(1990);
      match(MySQLParser::RENAME_SYMBOL);
      setState(1992);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 65, _ctx)) {
      case 1: {
        setState(1991);
        _la = _input->LA(1);
        if (!(_la == MySQLParser::AS_SYMBOL || _la == MySQLParser::TO_SYMBOL)) {
        _errHandler->recoverInline(this);
        }
        else {
          _errHandler->reportMatch(this);
          consume();
        }
        break;
      }

      default:
        break;
      }
      setState(1994);
      tableName();
      break;
    }

    case 14: {
      enterOuterAlt(_localctx, 14);
      setState(1995);
      match(MySQLParser::RENAME_SYMBOL);
      setState(1996);
      keyOrIndex();
      setState(1997);
      indexRef();
      setState(1998);
      match(MySQLParser::TO_SYMBOL);
      setState(1999);
      indexName();
      break;
    }

    case 15: {
      enterOuterAlt(_localctx, 15);
      setState(2001);
      match(MySQLParser::CONVERT_SYMBOL);
      setState(2002);
      match(MySQLParser::TO_SYMBOL);
      setState(2003);
      charset();
      setState(2007);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 66, _ctx)) {
      case 1: {
        setState(2004);

        if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
        setState(2005);
        match(MySQLParser::DEFAULT_SYMBOL);
        break;
      }

      case 2: {
        setState(2006);
        charsetName();
        break;
      }

      default:
        break;
      }
      setState(2010);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::COLLATE_SYMBOL) {
        setState(2009);
        collate();
      }
      break;
    }

    case 16: {
      enterOuterAlt(_localctx, 16);
      setState(2012);
      match(MySQLParser::FORCE_SYMBOL);
      break;
    }

    case 17: {
      enterOuterAlt(_localctx, 17);
      setState(2013);
      match(MySQLParser::ORDER_SYMBOL);
      setState(2014);
      match(MySQLParser::BY_SYMBOL);
      setState(2015);
      alterOrderList();
      break;
    }

    case 18: {
      enterOuterAlt(_localctx, 18);
      setState(2016);

      if (!(serverVersion >= 50708 && serverVersion < 80000)) throw FailedPredicateException(this, "serverVersion >= 50708 && serverVersion < 80000");
      setState(2017);
      match(MySQLParser::UPGRADE_SYMBOL);
      setState(2018);
      match(MySQLParser::PARTITIONING_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- PlaceContext ------------------------------------------------------------------

MySQLParser::PlaceContext::PlaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::PlaceContext::AFTER_SYMBOL() {
  return getToken(MySQLParser::AFTER_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::PlaceContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::PlaceContext::FIRST_SYMBOL() {
  return getToken(MySQLParser::FIRST_SYMBOL, 0);
}


size_t MySQLParser::PlaceContext::getRuleIndex() const {
  return MySQLParser::RulePlace;
}

void MySQLParser::PlaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterPlace(this);
}

void MySQLParser::PlaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitPlace(this);
}


std::any MySQLParser::PlaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitPlace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::PlaceContext* MySQLParser::place() {
  PlaceContext *_localctx = _tracker.createInstance<PlaceContext>(_ctx, getState());
  enterRule(_localctx, 38, MySQLParser::RulePlace);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2024);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::AFTER_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2021);
        match(MySQLParser::AFTER_SYMBOL);
        setState(2022);
        identifier();
        break;
      }

      case MySQLParser::FIRST_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2023);
        match(MySQLParser::FIRST_SYMBOL);
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RestrictContext ------------------------------------------------------------------

MySQLParser::RestrictContext::RestrictContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::RestrictContext::RESTRICT_SYMBOL() {
  return getToken(MySQLParser::RESTRICT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RestrictContext::CASCADE_SYMBOL() {
  return getToken(MySQLParser::CASCADE_SYMBOL, 0);
}


size_t MySQLParser::RestrictContext::getRuleIndex() const {
  return MySQLParser::RuleRestrict;
}

void MySQLParser::RestrictContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRestrict(this);
}

void MySQLParser::RestrictContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRestrict(this);
}


std::any MySQLParser::RestrictContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRestrict(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RestrictContext* MySQLParser::restrict() {
  RestrictContext *_localctx = _tracker.createInstance<RestrictContext>(_ctx, getState());
  enterRule(_localctx, 40, MySQLParser::RuleRestrict);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2026);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::CASCADE_SYMBOL || _la == MySQLParser::RESTRICT_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterOrderListContext ------------------------------------------------------------------

MySQLParser::AlterOrderListContext::AlterOrderListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::IdentifierContext *> MySQLParser::AlterOrderListContext::identifier() {
  return getRuleContexts<MySQLParser::IdentifierContext>();
}

MySQLParser::IdentifierContext* MySQLParser::AlterOrderListContext::identifier(size_t i) {
  return getRuleContext<MySQLParser::IdentifierContext>(i);
}

std::vector<MySQLParser::DirectionContext *> MySQLParser::AlterOrderListContext::direction() {
  return getRuleContexts<MySQLParser::DirectionContext>();
}

MySQLParser::DirectionContext* MySQLParser::AlterOrderListContext::direction(size_t i) {
  return getRuleContext<MySQLParser::DirectionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterOrderListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterOrderListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::AlterOrderListContext::getRuleIndex() const {
  return MySQLParser::RuleAlterOrderList;
}

void MySQLParser::AlterOrderListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterOrderList(this);
}

void MySQLParser::AlterOrderListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterOrderList(this);
}


std::any MySQLParser::AlterOrderListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterOrderList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterOrderListContext* MySQLParser::alterOrderList() {
  AlterOrderListContext *_localctx = _tracker.createInstance<AlterOrderListContext>(_ctx, getState());
  enterRule(_localctx, 42, MySQLParser::RuleAlterOrderList);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2028);
    identifier();
    setState(2030);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ASC_SYMBOL || _la == MySQLParser::DESC_SYMBOL) {
      setState(2029);
      direction();
    }
    setState(2039);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 72, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2032);
        match(MySQLParser::COMMA_SYMBOL);
        setState(2033);
        identifier();
        setState(2035);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::ASC_SYMBOL || _la == MySQLParser::DESC_SYMBOL) {
          setState(2034);
          direction();
        } 
      }
      setState(2041);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 72, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterAlgorithmOptionContext ------------------------------------------------------------------

MySQLParser::AlterAlgorithmOptionContext::AlterAlgorithmOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterAlgorithmOptionContext::ALGORITHM_SYMBOL() {
  return getToken(MySQLParser::ALGORITHM_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterAlgorithmOptionContext::DEFAULT_SYMBOL() {
  return getToken(MySQLParser::DEFAULT_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::AlterAlgorithmOptionContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::AlterAlgorithmOptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::AlterAlgorithmOptionContext::getRuleIndex() const {
  return MySQLParser::RuleAlterAlgorithmOption;
}

void MySQLParser::AlterAlgorithmOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterAlgorithmOption(this);
}

void MySQLParser::AlterAlgorithmOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterAlgorithmOption(this);
}


std::any MySQLParser::AlterAlgorithmOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterAlgorithmOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterAlgorithmOptionContext* MySQLParser::alterAlgorithmOption() {
  AlterAlgorithmOptionContext *_localctx = _tracker.createInstance<AlterAlgorithmOptionContext>(_ctx, getState());
  enterRule(_localctx, 44, MySQLParser::RuleAlterAlgorithmOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2042);
    match(MySQLParser::ALGORITHM_SYMBOL);
    setState(2044);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 73, _ctx)) {
    case 1: {
      setState(2043);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2048);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 74, _ctx)) {
    case 1: {
      setState(2046);
      match(MySQLParser::DEFAULT_SYMBOL);
      break;
    }

    case 2: {
      setState(2047);
      identifier();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterLockOptionContext ------------------------------------------------------------------

MySQLParser::AlterLockOptionContext::AlterLockOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterLockOptionContext::LOCK_SYMBOL() {
  return getToken(MySQLParser::LOCK_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterLockOptionContext::DEFAULT_SYMBOL() {
  return getToken(MySQLParser::DEFAULT_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::AlterLockOptionContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::AlterLockOptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::AlterLockOptionContext::getRuleIndex() const {
  return MySQLParser::RuleAlterLockOption;
}

void MySQLParser::AlterLockOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterLockOption(this);
}

void MySQLParser::AlterLockOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterLockOption(this);
}


std::any MySQLParser::AlterLockOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterLockOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterLockOptionContext* MySQLParser::alterLockOption() {
  AlterLockOptionContext *_localctx = _tracker.createInstance<AlterLockOptionContext>(_ctx, getState());
  enterRule(_localctx, 46, MySQLParser::RuleAlterLockOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2050);
    match(MySQLParser::LOCK_SYMBOL);
    setState(2052);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 75, _ctx)) {
    case 1: {
      setState(2051);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2056);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 76, _ctx)) {
    case 1: {
      setState(2054);
      match(MySQLParser::DEFAULT_SYMBOL);
      break;
    }

    case 2: {
      setState(2055);
      identifier();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- IndexLockAndAlgorithmContext ------------------------------------------------------------------

MySQLParser::IndexLockAndAlgorithmContext::IndexLockAndAlgorithmContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::AlterAlgorithmOptionContext* MySQLParser::IndexLockAndAlgorithmContext::alterAlgorithmOption() {
  return getRuleContext<MySQLParser::AlterAlgorithmOptionContext>(0);
}

MySQLParser::AlterLockOptionContext* MySQLParser::IndexLockAndAlgorithmContext::alterLockOption() {
  return getRuleContext<MySQLParser::AlterLockOptionContext>(0);
}


size_t MySQLParser::IndexLockAndAlgorithmContext::getRuleIndex() const {
  return MySQLParser::RuleIndexLockAndAlgorithm;
}

void MySQLParser::IndexLockAndAlgorithmContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterIndexLockAndAlgorithm(this);
}

void MySQLParser::IndexLockAndAlgorithmContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitIndexLockAndAlgorithm(this);
}


std::any MySQLParser::IndexLockAndAlgorithmContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitIndexLockAndAlgorithm(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::IndexLockAndAlgorithmContext* MySQLParser::indexLockAndAlgorithm() {
  IndexLockAndAlgorithmContext *_localctx = _tracker.createInstance<IndexLockAndAlgorithmContext>(_ctx, getState());
  enterRule(_localctx, 48, MySQLParser::RuleIndexLockAndAlgorithm);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2066);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::ALGORITHM_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2058);
        alterAlgorithmOption();
        setState(2060);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::LOCK_SYMBOL) {
          setState(2059);
          alterLockOption();
        }
        break;
      }

      case MySQLParser::LOCK_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2062);
        alterLockOption();
        setState(2064);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::ALGORITHM_SYMBOL) {
          setState(2063);
          alterAlgorithmOption();
        }
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WithValidationContext ------------------------------------------------------------------

MySQLParser::WithValidationContext::WithValidationContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WithValidationContext::VALIDATION_SYMBOL() {
  return getToken(MySQLParser::VALIDATION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WithValidationContext::WITH_SYMBOL() {
  return getToken(MySQLParser::WITH_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WithValidationContext::WITHOUT_SYMBOL() {
  return getToken(MySQLParser::WITHOUT_SYMBOL, 0);
}


size_t MySQLParser::WithValidationContext::getRuleIndex() const {
  return MySQLParser::RuleWithValidation;
}

void MySQLParser::WithValidationContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWithValidation(this);
}

void MySQLParser::WithValidationContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWithValidation(this);
}


std::any MySQLParser::WithValidationContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWithValidation(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WithValidationContext* MySQLParser::withValidation() {
  WithValidationContext *_localctx = _tracker.createInstance<WithValidationContext>(_ctx, getState());
  enterRule(_localctx, 50, MySQLParser::RuleWithValidation);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2068);

    if (!(serverVersion >= 50706)) throw FailedPredicateException(this, "serverVersion >= 50706");
    setState(2069);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::WITH_SYMBOL

    || _la == MySQLParser::WITHOUT_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2070);
    match(MySQLParser::VALIDATION_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RemovePartitioningContext ------------------------------------------------------------------

MySQLParser::RemovePartitioningContext::RemovePartitioningContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::RemovePartitioningContext::REMOVE_SYMBOL() {
  return getToken(MySQLParser::REMOVE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RemovePartitioningContext::PARTITIONING_SYMBOL() {
  return getToken(MySQLParser::PARTITIONING_SYMBOL, 0);
}


size_t MySQLParser::RemovePartitioningContext::getRuleIndex() const {
  return MySQLParser::RuleRemovePartitioning;
}

void MySQLParser::RemovePartitioningContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRemovePartitioning(this);
}

void MySQLParser::RemovePartitioningContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRemovePartitioning(this);
}


std::any MySQLParser::RemovePartitioningContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRemovePartitioning(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RemovePartitioningContext* MySQLParser::removePartitioning() {
  RemovePartitioningContext *_localctx = _tracker.createInstance<RemovePartitioningContext>(_ctx, getState());
  enterRule(_localctx, 52, MySQLParser::RuleRemovePartitioning);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2072);
    match(MySQLParser::REMOVE_SYMBOL);
    setState(2073);
    match(MySQLParser::PARTITIONING_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AllOrPartitionNameListContext ------------------------------------------------------------------

MySQLParser::AllOrPartitionNameListContext::AllOrPartitionNameListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AllOrPartitionNameListContext::ALL_SYMBOL() {
  return getToken(MySQLParser::ALL_SYMBOL, 0);
}

MySQLParser::IdentifierListContext* MySQLParser::AllOrPartitionNameListContext::identifierList() {
  return getRuleContext<MySQLParser::IdentifierListContext>(0);
}


size_t MySQLParser::AllOrPartitionNameListContext::getRuleIndex() const {
  return MySQLParser::RuleAllOrPartitionNameList;
}

void MySQLParser::AllOrPartitionNameListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAllOrPartitionNameList(this);
}

void MySQLParser::AllOrPartitionNameListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAllOrPartitionNameList(this);
}


std::any MySQLParser::AllOrPartitionNameListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAllOrPartitionNameList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AllOrPartitionNameListContext* MySQLParser::allOrPartitionNameList() {
  AllOrPartitionNameListContext *_localctx = _tracker.createInstance<AllOrPartitionNameListContext>(_ctx, getState());
  enterRule(_localctx, 54, MySQLParser::RuleAllOrPartitionNameList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2077);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 80, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2075);
      match(MySQLParser::ALL_SYMBOL);
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2076);
      identifierList();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterTablespaceContext ------------------------------------------------------------------

MySQLParser::AlterTablespaceContext::AlterTablespaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

MySQLParser::TablespaceRefContext* MySQLParser::AlterTablespaceContext::tablespaceRef() {
  return getRuleContext<MySQLParser::TablespaceRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::DATAFILE_SYMBOL() {
  return getToken(MySQLParser::DATAFILE_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::AlterTablespaceContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::RENAME_SYMBOL() {
  return getToken(MySQLParser::RENAME_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::TO_SYMBOL() {
  return getToken(MySQLParser::TO_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::AlterTablespaceContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

MySQLParser::AlterTablespaceOptionsContext* MySQLParser::AlterTablespaceContext::alterTablespaceOptions() {
  return getRuleContext<MySQLParser::AlterTablespaceOptionsContext>(0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::DROP_SYMBOL() {
  return getToken(MySQLParser::DROP_SYMBOL, 0);
}


size_t MySQLParser::AlterTablespaceContext::getRuleIndex() const {
  return MySQLParser::RuleAlterTablespace;
}

void MySQLParser::AlterTablespaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterTablespace(this);
}

void MySQLParser::AlterTablespaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterTablespace(this);
}


std::any MySQLParser::AlterTablespaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterTablespace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterTablespaceContext* MySQLParser::alterTablespace() {
  AlterTablespaceContext *_localctx = _tracker.createInstance<AlterTablespaceContext>(_ctx, getState());
  enterRule(_localctx, 56, MySQLParser::RuleAlterTablespace);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2079);
    match(MySQLParser::TABLESPACE_SYMBOL);
    setState(2080);
    tablespaceRef();
    setState(2092);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 82, _ctx)) {
    case 1: {
      setState(2081);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::ADD_SYMBOL || _la == MySQLParser::DROP_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      setState(2082);
      match(MySQLParser::DATAFILE_SYMBOL);
      setState(2083);
      textLiteral();
      setState(2085);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 81, _ctx)) {
      case 1: {
        setState(2084);
        alterTablespaceOptions();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(2087);
      match(MySQLParser::RENAME_SYMBOL);
      setState(2088);
      match(MySQLParser::TO_SYMBOL);
      setState(2089);
      identifier();
      break;
    }

    case 3: {
      setState(2090);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(2091);
      alterTablespaceOptions();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterUndoTablespaceContext ------------------------------------------------------------------

MySQLParser::AlterUndoTablespaceContext::AlterUndoTablespaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterUndoTablespaceContext::UNDO_SYMBOL() {
  return getToken(MySQLParser::UNDO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterUndoTablespaceContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

MySQLParser::TablespaceRefContext* MySQLParser::AlterUndoTablespaceContext::tablespaceRef() {
  return getRuleContext<MySQLParser::TablespaceRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterUndoTablespaceContext::SET_SYMBOL() {
  return getToken(MySQLParser::SET_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterUndoTablespaceContext::ACTIVE_SYMBOL() {
  return getToken(MySQLParser::ACTIVE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterUndoTablespaceContext::INACTIVE_SYMBOL() {
  return getToken(MySQLParser::INACTIVE_SYMBOL, 0);
}

MySQLParser::UndoTableSpaceOptionsContext* MySQLParser::AlterUndoTablespaceContext::undoTableSpaceOptions() {
  return getRuleContext<MySQLParser::UndoTableSpaceOptionsContext>(0);
}


size_t MySQLParser::AlterUndoTablespaceContext::getRuleIndex() const {
  return MySQLParser::RuleAlterUndoTablespace;
}

void MySQLParser::AlterUndoTablespaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterUndoTablespace(this);
}

void MySQLParser::AlterUndoTablespaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterUndoTablespace(this);
}


std::any MySQLParser::AlterUndoTablespaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterUndoTablespace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterUndoTablespaceContext* MySQLParser::alterUndoTablespace() {
  AlterUndoTablespaceContext *_localctx = _tracker.createInstance<AlterUndoTablespaceContext>(_ctx, getState());
  enterRule(_localctx, 58, MySQLParser::RuleAlterUndoTablespace);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2094);
    match(MySQLParser::UNDO_SYMBOL);
    setState(2095);
    match(MySQLParser::TABLESPACE_SYMBOL);
    setState(2096);
    tablespaceRef();
    setState(2097);
    match(MySQLParser::SET_SYMBOL);
    setState(2098);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::ACTIVE_SYMBOL

    || _la == MySQLParser::INACTIVE_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2100);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL) {
      setState(2099);
      undoTableSpaceOptions();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- UndoTableSpaceOptionsContext ------------------------------------------------------------------

MySQLParser::UndoTableSpaceOptionsContext::UndoTableSpaceOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::UndoTableSpaceOptionContext *> MySQLParser::UndoTableSpaceOptionsContext::undoTableSpaceOption() {
  return getRuleContexts<MySQLParser::UndoTableSpaceOptionContext>();
}

MySQLParser::UndoTableSpaceOptionContext* MySQLParser::UndoTableSpaceOptionsContext::undoTableSpaceOption(size_t i) {
  return getRuleContext<MySQLParser::UndoTableSpaceOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::UndoTableSpaceOptionsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::UndoTableSpaceOptionsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::UndoTableSpaceOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleUndoTableSpaceOptions;
}

void MySQLParser::UndoTableSpaceOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterUndoTableSpaceOptions(this);
}

void MySQLParser::UndoTableSpaceOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitUndoTableSpaceOptions(this);
}


std::any MySQLParser::UndoTableSpaceOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitUndoTableSpaceOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::UndoTableSpaceOptionsContext* MySQLParser::undoTableSpaceOptions() {
  UndoTableSpaceOptionsContext *_localctx = _tracker.createInstance<UndoTableSpaceOptionsContext>(_ctx, getState());
  enterRule(_localctx, 60, MySQLParser::RuleUndoTableSpaceOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2102);
    undoTableSpaceOption();
    setState(2109);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL || _la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL) {
      setState(2104);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::COMMA_SYMBOL) {
        setState(2103);
        match(MySQLParser::COMMA_SYMBOL);
      }
      setState(2106);
      undoTableSpaceOption();
      setState(2111);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- UndoTableSpaceOptionContext ------------------------------------------------------------------

MySQLParser::UndoTableSpaceOptionContext::UndoTableSpaceOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TsOptionEngineContext* MySQLParser::UndoTableSpaceOptionContext::tsOptionEngine() {
  return getRuleContext<MySQLParser::TsOptionEngineContext>(0);
}


size_t MySQLParser::UndoTableSpaceOptionContext::getRuleIndex() const {
  return MySQLParser::RuleUndoTableSpaceOption;
}

void MySQLParser::UndoTableSpaceOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterUndoTableSpaceOption(this);
}

void MySQLParser::UndoTableSpaceOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitUndoTableSpaceOption(this);
}


std::any MySQLParser::UndoTableSpaceOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitUndoTableSpaceOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::UndoTableSpaceOptionContext* MySQLParser::undoTableSpaceOption() {
  UndoTableSpaceOptionContext *_localctx = _tracker.createInstance<UndoTableSpaceOptionContext>(_ctx, getState());
  enterRule(_localctx, 62, MySQLParser::RuleUndoTableSpaceOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2112);
    tsOptionEngine();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterTablespaceOptionsContext ------------------------------------------------------------------

MySQLParser::AlterTablespaceOptionsContext::AlterTablespaceOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::AlterTablespaceOptionContext *> MySQLParser::AlterTablespaceOptionsContext::alterTablespaceOption() {
  return getRuleContexts<MySQLParser::AlterTablespaceOptionContext>();
}

MySQLParser::AlterTablespaceOptionContext* MySQLParser::AlterTablespaceOptionsContext::alterTablespaceOption(size_t i) {
  return getRuleContext<MySQLParser::AlterTablespaceOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterTablespaceOptionsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterTablespaceOptionsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::AlterTablespaceOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleAlterTablespaceOptions;
}

void MySQLParser::AlterTablespaceOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterTablespaceOptions(this);
}

void MySQLParser::AlterTablespaceOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterTablespaceOptions(this);
}


std::any MySQLParser::AlterTablespaceOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterTablespaceOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterTablespaceOptionsContext* MySQLParser::alterTablespaceOptions() {
  AlterTablespaceOptionsContext *_localctx = _tracker.createInstance<AlterTablespaceOptionsContext>(_ctx, getState());
  enterRule(_localctx, 64, MySQLParser::RuleAlterTablespaceOptions);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2114);
    alterTablespaceOption();
    setState(2121);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 87, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2116);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 86, _ctx)) {
        case 1: {
          setState(2115);
          match(MySQLParser::COMMA_SYMBOL);
          break;
        }

        default:
          break;
        }
        setState(2118);
        alterTablespaceOption(); 
      }
      setState(2123);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 87, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterTablespaceOptionContext ------------------------------------------------------------------

MySQLParser::AlterTablespaceOptionContext::AlterTablespaceOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterTablespaceOptionContext::INITIAL_SIZE_SYMBOL() {
  return getToken(MySQLParser::INITIAL_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::AlterTablespaceOptionContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceOptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}

MySQLParser::TsOptionAutoextendSizeContext* MySQLParser::AlterTablespaceOptionContext::tsOptionAutoextendSize() {
  return getRuleContext<MySQLParser::TsOptionAutoextendSizeContext>(0);
}

MySQLParser::TsOptionMaxSizeContext* MySQLParser::AlterTablespaceOptionContext::tsOptionMaxSize() {
  return getRuleContext<MySQLParser::TsOptionMaxSizeContext>(0);
}

MySQLParser::TsOptionEngineContext* MySQLParser::AlterTablespaceOptionContext::tsOptionEngine() {
  return getRuleContext<MySQLParser::TsOptionEngineContext>(0);
}

MySQLParser::TsOptionWaitContext* MySQLParser::AlterTablespaceOptionContext::tsOptionWait() {
  return getRuleContext<MySQLParser::TsOptionWaitContext>(0);
}

MySQLParser::TsOptionEncryptionContext* MySQLParser::AlterTablespaceOptionContext::tsOptionEncryption() {
  return getRuleContext<MySQLParser::TsOptionEncryptionContext>(0);
}

MySQLParser::TsOptionEngineAttributeContext* MySQLParser::AlterTablespaceOptionContext::tsOptionEngineAttribute() {
  return getRuleContext<MySQLParser::TsOptionEngineAttributeContext>(0);
}


size_t MySQLParser::AlterTablespaceOptionContext::getRuleIndex() const {
  return MySQLParser::RuleAlterTablespaceOption;
}

void MySQLParser::AlterTablespaceOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterTablespaceOption(this);
}

void MySQLParser::AlterTablespaceOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterTablespaceOption(this);
}


std::any MySQLParser::AlterTablespaceOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterTablespaceOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterTablespaceOptionContext* MySQLParser::alterTablespaceOption() {
  AlterTablespaceOptionContext *_localctx = _tracker.createInstance<AlterTablespaceOptionContext>(_ctx, getState());
  enterRule(_localctx, 66, MySQLParser::RuleAlterTablespaceOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2136);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 89, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2124);
      match(MySQLParser::INITIAL_SIZE_SYMBOL);
      setState(2126);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 88, _ctx)) {
      case 1: {
        setState(2125);
        match(MySQLParser::EQUAL_OPERATOR);
        break;
      }

      default:
        break;
      }
      setState(2128);
      sizeNumber();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2129);
      tsOptionAutoextendSize();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(2130);
      tsOptionMaxSize();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(2131);
      tsOptionEngine();
      break;
    }

    case 5: {
      enterOuterAlt(_localctx, 5);
      setState(2132);
      tsOptionWait();
      break;
    }

    case 6: {
      enterOuterAlt(_localctx, 6);
      setState(2133);
      tsOptionEncryption();
      break;
    }

    case 7: {
      enterOuterAlt(_localctx, 7);
      setState(2134);

      if (!(serverVersion >= 80024)) throw FailedPredicateException(this, "serverVersion >= 80024");
      setState(2135);
      tsOptionEngineAttribute();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ChangeTablespaceOptionContext ------------------------------------------------------------------

MySQLParser::ChangeTablespaceOptionContext::ChangeTablespaceOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ChangeTablespaceOptionContext::INITIAL_SIZE_SYMBOL() {
  return getToken(MySQLParser::INITIAL_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::ChangeTablespaceOptionContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::ChangeTablespaceOptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}

MySQLParser::TsOptionAutoextendSizeContext* MySQLParser::ChangeTablespaceOptionContext::tsOptionAutoextendSize() {
  return getRuleContext<MySQLParser::TsOptionAutoextendSizeContext>(0);
}

MySQLParser::TsOptionMaxSizeContext* MySQLParser::ChangeTablespaceOptionContext::tsOptionMaxSize() {
  return getRuleContext<MySQLParser::TsOptionMaxSizeContext>(0);
}


size_t MySQLParser::ChangeTablespaceOptionContext::getRuleIndex() const {
  return MySQLParser::RuleChangeTablespaceOption;
}

void MySQLParser::ChangeTablespaceOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterChangeTablespaceOption(this);
}

void MySQLParser::ChangeTablespaceOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitChangeTablespaceOption(this);
}


std::any MySQLParser::ChangeTablespaceOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitChangeTablespaceOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ChangeTablespaceOptionContext* MySQLParser::changeTablespaceOption() {
  ChangeTablespaceOptionContext *_localctx = _tracker.createInstance<ChangeTablespaceOptionContext>(_ctx, getState());
  enterRule(_localctx, 68, MySQLParser::RuleChangeTablespaceOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2145);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::INITIAL_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2138);
        match(MySQLParser::INITIAL_SIZE_SYMBOL);
        setState(2140);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 90, _ctx)) {
        case 1: {
          setState(2139);
          match(MySQLParser::EQUAL_OPERATOR);
          break;
        }

        default:
          break;
        }
        setState(2142);
        sizeNumber();
        break;
      }

      case MySQLParser::AUTOEXTEND_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2143);
        tsOptionAutoextendSize();
        break;
      }

      case MySQLParser::MAX_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(2144);
        tsOptionMaxSize();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterViewContext ------------------------------------------------------------------

MySQLParser::AlterViewContext::AlterViewContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterViewContext::VIEW_SYMBOL() {
  return getToken(MySQLParser::VIEW_SYMBOL, 0);
}

MySQLParser::ViewRefContext* MySQLParser::AlterViewContext::viewRef() {
  return getRuleContext<MySQLParser::ViewRefContext>(0);
}

MySQLParser::ViewTailContext* MySQLParser::AlterViewContext::viewTail() {
  return getRuleContext<MySQLParser::ViewTailContext>(0);
}

MySQLParser::ViewAlgorithmContext* MySQLParser::AlterViewContext::viewAlgorithm() {
  return getRuleContext<MySQLParser::ViewAlgorithmContext>(0);
}

MySQLParser::DefinerClauseContext* MySQLParser::AlterViewContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

MySQLParser::ViewSuidContext* MySQLParser::AlterViewContext::viewSuid() {
  return getRuleContext<MySQLParser::ViewSuidContext>(0);
}


size_t MySQLParser::AlterViewContext::getRuleIndex() const {
  return MySQLParser::RuleAlterView;
}

void MySQLParser::AlterViewContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterView(this);
}

void MySQLParser::AlterViewContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterView(this);
}


std::any MySQLParser::AlterViewContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterView(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterViewContext* MySQLParser::alterView() {
  AlterViewContext *_localctx = _tracker.createInstance<AlterViewContext>(_ctx, getState());
  enterRule(_localctx, 70, MySQLParser::RuleAlterView);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2148);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ALGORITHM_SYMBOL) {
      setState(2147);
      viewAlgorithm();
    }
    setState(2151);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(2150);
      definerClause();
    }
    setState(2154);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::SQL_SYMBOL) {
      setState(2153);
      viewSuid();
    }
    setState(2156);
    match(MySQLParser::VIEW_SYMBOL);
    setState(2157);
    viewRef();
    setState(2158);
    viewTail();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ViewTailContext ------------------------------------------------------------------

MySQLParser::ViewTailContext::ViewTailContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ViewTailContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}

MySQLParser::ViewQueryBlockContext* MySQLParser::ViewTailContext::viewQueryBlock() {
  return getRuleContext<MySQLParser::ViewQueryBlockContext>(0);
}

MySQLParser::ColumnInternalRefListContext* MySQLParser::ViewTailContext::columnInternalRefList() {
  return getRuleContext<MySQLParser::ColumnInternalRefListContext>(0);
}


size_t MySQLParser::ViewTailContext::getRuleIndex() const {
  return MySQLParser::RuleViewTail;
}

void MySQLParser::ViewTailContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterViewTail(this);
}

void MySQLParser::ViewTailContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitViewTail(this);
}


std::any MySQLParser::ViewTailContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitViewTail(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ViewTailContext* MySQLParser::viewTail() {
  ViewTailContext *_localctx = _tracker.createInstance<ViewTailContext>(_ctx, getState());
  enterRule(_localctx, 72, MySQLParser::RuleViewTail);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2161);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OPEN_PAR_SYMBOL) {
      setState(2160);
      columnInternalRefList();
    }
    setState(2163);
    match(MySQLParser::AS_SYMBOL);
    setState(2164);
    viewQueryBlock();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ViewQueryBlockContext ------------------------------------------------------------------

MySQLParser::ViewQueryBlockContext::ViewQueryBlockContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionWithOptLockingClausesContext* MySQLParser::ViewQueryBlockContext::queryExpressionWithOptLockingClauses() {
  return getRuleContext<MySQLParser::QueryExpressionWithOptLockingClausesContext>(0);
}

MySQLParser::ViewCheckOptionContext* MySQLParser::ViewQueryBlockContext::viewCheckOption() {
  return getRuleContext<MySQLParser::ViewCheckOptionContext>(0);
}


size_t MySQLParser::ViewQueryBlockContext::getRuleIndex() const {
  return MySQLParser::RuleViewQueryBlock;
}

void MySQLParser::ViewQueryBlockContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterViewQueryBlock(this);
}

void MySQLParser::ViewQueryBlockContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitViewQueryBlock(this);
}


std::any MySQLParser::ViewQueryBlockContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitViewQueryBlock(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ViewQueryBlockContext* MySQLParser::viewQueryBlock() {
  ViewQueryBlockContext *_localctx = _tracker.createInstance<ViewQueryBlockContext>(_ctx, getState());
  enterRule(_localctx, 74, MySQLParser::RuleViewQueryBlock);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2166);
    queryExpressionWithOptLockingClauses();
    setState(2168);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::WITH_SYMBOL) {
      setState(2167);
      viewCheckOption();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ViewCheckOptionContext ------------------------------------------------------------------

MySQLParser::ViewCheckOptionContext::ViewCheckOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ViewCheckOptionContext::WITH_SYMBOL() {
  return getToken(MySQLParser::WITH_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewCheckOptionContext::CHECK_SYMBOL() {
  return getToken(MySQLParser::CHECK_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewCheckOptionContext::OPTION_SYMBOL() {
  return getToken(MySQLParser::OPTION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewCheckOptionContext::CASCADED_SYMBOL() {
  return getToken(MySQLParser::CASCADED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewCheckOptionContext::LOCAL_SYMBOL() {
  return getToken(MySQLParser::LOCAL_SYMBOL, 0);
}


size_t MySQLParser::ViewCheckOptionContext::getRuleIndex() const {
  return MySQLParser::RuleViewCheckOption;
}

void MySQLParser::ViewCheckOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterViewCheckOption(this);
}

void MySQLParser::ViewCheckOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitViewCheckOption(this);
}


std::any MySQLParser::ViewCheckOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitViewCheckOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ViewCheckOptionContext* MySQLParser::viewCheckOption() {
  ViewCheckOptionContext *_localctx = _tracker.createInstance<ViewCheckOptionContext>(_ctx, getState());
  enterRule(_localctx, 76, MySQLParser::RuleViewCheckOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2170);
    match(MySQLParser::WITH_SYMBOL);
    setState(2172);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::CASCADED_SYMBOL || _la == MySQLParser::LOCAL_SYMBOL) {
      setState(2171);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::CASCADED_SYMBOL || _la == MySQLParser::LOCAL_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
    }
    setState(2174);
    match(MySQLParser::CHECK_SYMBOL);
    setState(2175);
    match(MySQLParser::OPTION_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterInstanceStatementContext ------------------------------------------------------------------

MySQLParser::AlterInstanceStatementContext::AlterInstanceStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::INSTANCE_SYMBOL() {
  return getToken(MySQLParser::INSTANCE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::ROTATE_SYMBOL() {
  return getToken(MySQLParser::ROTATE_SYMBOL, 0);
}

MySQLParser::TextOrIdentifierContext* MySQLParser::AlterInstanceStatementContext::textOrIdentifier() {
  return getRuleContext<MySQLParser::TextOrIdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::MASTER_SYMBOL() {
  return getToken(MySQLParser::MASTER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::KEY_SYMBOL() {
  return getToken(MySQLParser::KEY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::RELOAD_SYMBOL() {
  return getToken(MySQLParser::RELOAD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::TLS_SYMBOL() {
  return getToken(MySQLParser::TLS_SYMBOL, 0);
}

std::vector<MySQLParser::IdentifierContext *> MySQLParser::AlterInstanceStatementContext::identifier() {
  return getRuleContexts<MySQLParser::IdentifierContext>();
}

MySQLParser::IdentifierContext* MySQLParser::AlterInstanceStatementContext::identifier(size_t i) {
  return getRuleContext<MySQLParser::IdentifierContext>(i);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::KEYRING_SYMBOL() {
  return getToken(MySQLParser::KEYRING_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::ENABLE_SYMBOL() {
  return getToken(MySQLParser::ENABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::DISABLE_SYMBOL() {
  return getToken(MySQLParser::DISABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::FOR_SYMBOL() {
  return getToken(MySQLParser::FOR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::CHANNEL_SYMBOL() {
  return getToken(MySQLParser::CHANNEL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::NO_SYMBOL() {
  return getToken(MySQLParser::NO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::ROLLBACK_SYMBOL() {
  return getToken(MySQLParser::ROLLBACK_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::ON_SYMBOL() {
  return getToken(MySQLParser::ON_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::ERROR_SYMBOL() {
  return getToken(MySQLParser::ERROR_SYMBOL, 0);
}


size_t MySQLParser::AlterInstanceStatementContext::getRuleIndex() const {
  return MySQLParser::RuleAlterInstanceStatement;
}

void MySQLParser::AlterInstanceStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterInstanceStatement(this);
}

void MySQLParser::AlterInstanceStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterInstanceStatement(this);
}


std::any MySQLParser::AlterInstanceStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterInstanceStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterInstanceStatementContext* MySQLParser::alterInstanceStatement() {
  AlterInstanceStatementContext *_localctx = _tracker.createInstance<AlterInstanceStatementContext>(_ctx, getState());
  enterRule(_localctx, 78, MySQLParser::RuleAlterInstanceStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2210);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 101, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2177);

      if (!(serverVersion >= 50713)) throw FailedPredicateException(this, "serverVersion >= 50713");
      setState(2178);
      match(MySQLParser::INSTANCE_SYMBOL);
      setState(2207);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 100, _ctx)) {
      case 1: {
        setState(2179);
        match(MySQLParser::ROTATE_SYMBOL);
        setState(2180);
        textOrIdentifier();
        setState(2181);
        match(MySQLParser::MASTER_SYMBOL);
        setState(2182);
        match(MySQLParser::KEY_SYMBOL);
        break;
      }

      case 2: {
        setState(2184);

        if (!(serverVersion >= 80016)) throw FailedPredicateException(this, "serverVersion >= 80016");
        setState(2185);
        match(MySQLParser::RELOAD_SYMBOL);
        setState(2186);
        match(MySQLParser::TLS_SYMBOL);
        setState(2191);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 98, _ctx)) {
        case 1: {
          setState(2187);

          if (!(serverVersion >= 80021)) throw FailedPredicateException(this, "serverVersion >= 80021");
          setState(2188);
          match(MySQLParser::FOR_SYMBOL);
          setState(2189);
          match(MySQLParser::CHANNEL_SYMBOL);
          setState(2190);
          identifier();
          break;
        }

        default:
          break;
        }
        setState(2197);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::NO_SYMBOL) {
          setState(2193);
          match(MySQLParser::NO_SYMBOL);
          setState(2194);
          match(MySQLParser::ROLLBACK_SYMBOL);
          setState(2195);
          match(MySQLParser::ON_SYMBOL);
          setState(2196);
          match(MySQLParser::ERROR_SYMBOL);
        }
        break;
      }

      case 3: {
        setState(2199);

        if (!(serverVersion >= 80021)) throw FailedPredicateException(this, "serverVersion >= 80021");
        setState(2200);
        _la = _input->LA(1);
        if (!(_la == MySQLParser::DISABLE_SYMBOL

        || _la == MySQLParser::ENABLE_SYMBOL)) {
        _errHandler->recoverInline(this);
        }
        else {
          _errHandler->reportMatch(this);
          consume();
        }
        setState(2201);
        identifier();
        setState(2202);
        identifier();
        break;
      }

      case 4: {
        setState(2204);

        if (!(serverVersion >= 80024)) throw FailedPredicateException(this, "serverVersion >= 80024");
        setState(2205);
        match(MySQLParser::RELOAD_SYMBOL);
        setState(2206);
        match(MySQLParser::KEYRING_SYMBOL);
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);

      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateStatementContext ------------------------------------------------------------------

MySQLParser::CreateStatementContext::CreateStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateStatementContext::CREATE_SYMBOL() {
  return getToken(MySQLParser::CREATE_SYMBOL, 0);
}

MySQLParser::CreateDatabaseContext* MySQLParser::CreateStatementContext::createDatabase() {
  return getRuleContext<MySQLParser::CreateDatabaseContext>(0);
}

MySQLParser::CreateTableContext* MySQLParser::CreateStatementContext::createTable() {
  return getRuleContext<MySQLParser::CreateTableContext>(0);
}

MySQLParser::CreateFunctionContext* MySQLParser::CreateStatementContext::createFunction() {
  return getRuleContext<MySQLParser::CreateFunctionContext>(0);
}

MySQLParser::CreateProcedureContext* MySQLParser::CreateStatementContext::createProcedure() {
  return getRuleContext<MySQLParser::CreateProcedureContext>(0);
}

MySQLParser::CreateUdfContext* MySQLParser::CreateStatementContext::createUdf() {
  return getRuleContext<MySQLParser::CreateUdfContext>(0);
}

MySQLParser::CreateLogfileGroupContext* MySQLParser::CreateStatementContext::createLogfileGroup() {
  return getRuleContext<MySQLParser::CreateLogfileGroupContext>(0);
}

MySQLParser::CreateViewContext* MySQLParser::CreateStatementContext::createView() {
  return getRuleContext<MySQLParser::CreateViewContext>(0);
}

MySQLParser::CreateTriggerContext* MySQLParser::CreateStatementContext::createTrigger() {
  return getRuleContext<MySQLParser::CreateTriggerContext>(0);
}

MySQLParser::CreateIndexContext* MySQLParser::CreateStatementContext::createIndex() {
  return getRuleContext<MySQLParser::CreateIndexContext>(0);
}

MySQLParser::CreateServerContext* MySQLParser::CreateStatementContext::createServer() {
  return getRuleContext<MySQLParser::CreateServerContext>(0);
}

MySQLParser::CreateTablespaceContext* MySQLParser::CreateStatementContext::createTablespace() {
  return getRuleContext<MySQLParser::CreateTablespaceContext>(0);
}

MySQLParser::CreateEventContext* MySQLParser::CreateStatementContext::createEvent() {
  return getRuleContext<MySQLParser::CreateEventContext>(0);
}

MySQLParser::CreateRoleContext* MySQLParser::CreateStatementContext::createRole() {
  return getRuleContext<MySQLParser::CreateRoleContext>(0);
}

MySQLParser::CreateSpatialReferenceContext* MySQLParser::CreateStatementContext::createSpatialReference() {
  return getRuleContext<MySQLParser::CreateSpatialReferenceContext>(0);
}

MySQLParser::CreateUndoTablespaceContext* MySQLParser::CreateStatementContext::createUndoTablespace() {
  return getRuleContext<MySQLParser::CreateUndoTablespaceContext>(0);
}


size_t MySQLParser::CreateStatementContext::getRuleIndex() const {
  return MySQLParser::RuleCreateStatement;
}

void MySQLParser::CreateStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateStatement(this);
}

void MySQLParser::CreateStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateStatement(this);
}


std::any MySQLParser::CreateStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateStatementContext* MySQLParser::createStatement() {
  CreateStatementContext *_localctx = _tracker.createInstance<CreateStatementContext>(_ctx, getState());
  enterRule(_localctx, 80, MySQLParser::RuleCreateStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2212);
    match(MySQLParser::CREATE_SYMBOL);
    setState(2231);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 102, _ctx)) {
    case 1: {
      setState(2213);
      createDatabase();
      break;
    }

    case 2: {
      setState(2214);
      createTable();
      break;
    }

    case 3: {
      setState(2215);
      createFunction();
      break;
    }

    case 4: {
      setState(2216);
      createProcedure();
      break;
    }

    case 5: {
      setState(2217);
      createUdf();
      break;
    }

    case 6: {
      setState(2218);
      createLogfileGroup();
      break;
    }

    case 7: {
      setState(2219);
      createView();
      break;
    }

    case 8: {
      setState(2220);
      createTrigger();
      break;
    }

    case 9: {
      setState(2221);
      createIndex();
      break;
    }

    case 10: {
      setState(2222);
      createServer();
      break;
    }

    case 11: {
      setState(2223);
      createTablespace();
      break;
    }

    case 12: {
      setState(2224);
      createEvent();
      break;
    }

    case 13: {
      setState(2225);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(2226);
      createRole();
      break;
    }

    case 14: {
      setState(2227);

      if (!(serverVersion >= 80011)) throw FailedPredicateException(this, "serverVersion >= 80011");
      setState(2228);
      createSpatialReference();
      break;
    }

    case 15: {
      setState(2229);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(2230);
      createUndoTablespace();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateDatabaseContext ------------------------------------------------------------------

MySQLParser::CreateDatabaseContext::CreateDatabaseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateDatabaseContext::DATABASE_SYMBOL() {
  return getToken(MySQLParser::DATABASE_SYMBOL, 0);
}

MySQLParser::SchemaNameContext* MySQLParser::CreateDatabaseContext::schemaName() {
  return getRuleContext<MySQLParser::SchemaNameContext>(0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateDatabaseContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}

std::vector<MySQLParser::CreateDatabaseOptionContext *> MySQLParser::CreateDatabaseContext::createDatabaseOption() {
  return getRuleContexts<MySQLParser::CreateDatabaseOptionContext>();
}

MySQLParser::CreateDatabaseOptionContext* MySQLParser::CreateDatabaseContext::createDatabaseOption(size_t i) {
  return getRuleContext<MySQLParser::CreateDatabaseOptionContext>(i);
}


size_t MySQLParser::CreateDatabaseContext::getRuleIndex() const {
  return MySQLParser::RuleCreateDatabase;
}

void MySQLParser::CreateDatabaseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateDatabase(this);
}

void MySQLParser::CreateDatabaseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateDatabase(this);
}


std::any MySQLParser::CreateDatabaseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateDatabase(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateDatabaseContext* MySQLParser::createDatabase() {
  CreateDatabaseContext *_localctx = _tracker.createInstance<CreateDatabaseContext>(_ctx, getState());
  enterRule(_localctx, 82, MySQLParser::RuleCreateDatabase);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2233);
    match(MySQLParser::DATABASE_SYMBOL);
    setState(2235);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 103, _ctx)) {
    case 1: {
      setState(2234);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2237);
    schemaName();
    setState(2241);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 104, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2238);
        createDatabaseOption(); 
      }
      setState(2243);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 104, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateDatabaseOptionContext ------------------------------------------------------------------

MySQLParser::CreateDatabaseOptionContext::CreateDatabaseOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::DefaultCharsetContext* MySQLParser::CreateDatabaseOptionContext::defaultCharset() {
  return getRuleContext<MySQLParser::DefaultCharsetContext>(0);
}

MySQLParser::DefaultCollationContext* MySQLParser::CreateDatabaseOptionContext::defaultCollation() {
  return getRuleContext<MySQLParser::DefaultCollationContext>(0);
}

MySQLParser::DefaultEncryptionContext* MySQLParser::CreateDatabaseOptionContext::defaultEncryption() {
  return getRuleContext<MySQLParser::DefaultEncryptionContext>(0);
}


size_t MySQLParser::CreateDatabaseOptionContext::getRuleIndex() const {
  return MySQLParser::RuleCreateDatabaseOption;
}

void MySQLParser::CreateDatabaseOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateDatabaseOption(this);
}

void MySQLParser::CreateDatabaseOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateDatabaseOption(this);
}


std::any MySQLParser::CreateDatabaseOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateDatabaseOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateDatabaseOptionContext* MySQLParser::createDatabaseOption() {
  CreateDatabaseOptionContext *_localctx = _tracker.createInstance<CreateDatabaseOptionContext>(_ctx, getState());
  enterRule(_localctx, 84, MySQLParser::RuleCreateDatabaseOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2248);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 105, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2244);
      defaultCharset();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2245);
      defaultCollation();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(2246);

      if (!(serverVersion >= 80016)) throw FailedPredicateException(this, "serverVersion >= 80016");
      setState(2247);
      defaultEncryption();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateTableContext ------------------------------------------------------------------

MySQLParser::CreateTableContext::CreateTableContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateTableContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

MySQLParser::TableNameContext* MySQLParser::CreateTableContext::tableName() {
  return getRuleContext<MySQLParser::TableNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateTableContext::LIKE_SYMBOL() {
  return getToken(MySQLParser::LIKE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::CreateTableContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

tree::TerminalNode* MySQLParser::CreateTableContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTableContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTableContext::TEMPORARY_SYMBOL() {
  return getToken(MySQLParser::TEMPORARY_SYMBOL, 0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateTableContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}

MySQLParser::TableElementListContext* MySQLParser::CreateTableContext::tableElementList() {
  return getRuleContext<MySQLParser::TableElementListContext>(0);
}

MySQLParser::CreateTableOptionsEtcContext* MySQLParser::CreateTableContext::createTableOptionsEtc() {
  return getRuleContext<MySQLParser::CreateTableOptionsEtcContext>(0);
}


size_t MySQLParser::CreateTableContext::getRuleIndex() const {
  return MySQLParser::RuleCreateTable;
}

void MySQLParser::CreateTableContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateTable(this);
}

void MySQLParser::CreateTableContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateTable(this);
}


std::any MySQLParser::CreateTableContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateTable(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateTableContext* MySQLParser::createTable() {
  CreateTableContext *_localctx = _tracker.createInstance<CreateTableContext>(_ctx, getState());
  enterRule(_localctx, 86, MySQLParser::RuleCreateTable);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2251);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::TEMPORARY_SYMBOL) {
      setState(2250);
      match(MySQLParser::TEMPORARY_SYMBOL);
    }
    setState(2253);
    match(MySQLParser::TABLE_SYMBOL);
    setState(2255);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 107, _ctx)) {
    case 1: {
      setState(2254);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2257);
    tableName();
    setState(2274);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 110, _ctx)) {
    case 1: {
      setState(2262);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 108, _ctx)) {
      case 1: {
        setState(2258);
        match(MySQLParser::OPEN_PAR_SYMBOL);
        setState(2259);
        tableElementList();
        setState(2260);
        match(MySQLParser::CLOSE_PAR_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(2265);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 109, _ctx)) {
      case 1: {
        setState(2264);
        createTableOptionsEtc();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(2267);
      match(MySQLParser::LIKE_SYMBOL);
      setState(2268);
      tableRef();
      break;
    }

    case 3: {
      setState(2269);
      match(MySQLParser::OPEN_PAR_SYMBOL);
      setState(2270);
      match(MySQLParser::LIKE_SYMBOL);
      setState(2271);
      tableRef();
      setState(2272);
      match(MySQLParser::CLOSE_PAR_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TableElementListContext ------------------------------------------------------------------

MySQLParser::TableElementListContext::TableElementListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::TableElementContext *> MySQLParser::TableElementListContext::tableElement() {
  return getRuleContexts<MySQLParser::TableElementContext>();
}

MySQLParser::TableElementContext* MySQLParser::TableElementListContext::tableElement(size_t i) {
  return getRuleContext<MySQLParser::TableElementContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::TableElementListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::TableElementListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::TableElementListContext::getRuleIndex() const {
  return MySQLParser::RuleTableElementList;
}

void MySQLParser::TableElementListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTableElementList(this);
}

void MySQLParser::TableElementListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTableElementList(this);
}


std::any MySQLParser::TableElementListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTableElementList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TableElementListContext* MySQLParser::tableElementList() {
  TableElementListContext *_localctx = _tracker.createInstance<TableElementListContext>(_ctx, getState());
  enterRule(_localctx, 88, MySQLParser::RuleTableElementList);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2276);
    tableElement();
    setState(2281);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(2277);
      match(MySQLParser::COMMA_SYMBOL);
      setState(2278);
      tableElement();
      setState(2283);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TableElementContext ------------------------------------------------------------------

MySQLParser::TableElementContext::TableElementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::ColumnDefinitionContext* MySQLParser::TableElementContext::columnDefinition() {
  return getRuleContext<MySQLParser::ColumnDefinitionContext>(0);
}

MySQLParser::TableConstraintDefContext* MySQLParser::TableElementContext::tableConstraintDef() {
  return getRuleContext<MySQLParser::TableConstraintDefContext>(0);
}


size_t MySQLParser::TableElementContext::getRuleIndex() const {
  return MySQLParser::RuleTableElement;
}

void MySQLParser::TableElementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTableElement(this);
}

void MySQLParser::TableElementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTableElement(this);
}


std::any MySQLParser::TableElementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTableElement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TableElementContext* MySQLParser::tableElement() {
  TableElementContext *_localctx = _tracker.createInstance<TableElementContext>(_ctx, getState());
  enterRule(_localctx, 90, MySQLParser::RuleTableElement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2286);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 112, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2284);
      columnDefinition();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2285);
      tableConstraintDef();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DuplicateAsQeContext ------------------------------------------------------------------

MySQLParser::DuplicateAsQeContext::DuplicateAsQeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::AsCreateQueryExpressionContext* MySQLParser::DuplicateAsQeContext::asCreateQueryExpression() {
  return getRuleContext<MySQLParser::AsCreateQueryExpressionContext>(0);
}

tree::TerminalNode* MySQLParser::DuplicateAsQeContext::REPLACE_SYMBOL() {
  return getToken(MySQLParser::REPLACE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DuplicateAsQeContext::IGNORE_SYMBOL() {
  return getToken(MySQLParser::IGNORE_SYMBOL, 0);
}


size_t MySQLParser::DuplicateAsQeContext::getRuleIndex() const {
  return MySQLParser::RuleDuplicateAsQe;
}

void MySQLParser::DuplicateAsQeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDuplicateAsQe(this);
}

void MySQLParser::DuplicateAsQeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDuplicateAsQe(this);
}


std::any MySQLParser::DuplicateAsQeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDuplicateAsQe(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DuplicateAsQeContext* MySQLParser::duplicateAsQe() {
  DuplicateAsQeContext *_localctx = _tracker.createInstance<DuplicateAsQeContext>(_ctx, getState());
  enterRule(_localctx, 92, MySQLParser::RuleDuplicateAsQe);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2289);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 113, _ctx)) {
    case 1: {
      setState(2288);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::IGNORE_SYMBOL || _la == MySQLParser::REPLACE_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      break;
    }

    default:
      break;
    }
    setState(2291);
    asCreateQueryExpression();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AsCreateQueryExpressionContext ------------------------------------------------------------------

MySQLParser::AsCreateQueryExpressionContext::AsCreateQueryExpressionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionWithOptLockingClausesContext* MySQLParser::AsCreateQueryExpressionContext::queryExpressionWithOptLockingClauses() {
  return getRuleContext<MySQLParser::QueryExpressionWithOptLockingClausesContext>(0);
}

tree::TerminalNode* MySQLParser::AsCreateQueryExpressionContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}


size_t MySQLParser::AsCreateQueryExpressionContext::getRuleIndex() const {
  return MySQLParser::RuleAsCreateQueryExpression;
}

void MySQLParser::AsCreateQueryExpressionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAsCreateQueryExpression(this);
}

void MySQLParser::AsCreateQueryExpressionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAsCreateQueryExpression(this);
}


std::any MySQLParser::AsCreateQueryExpressionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAsCreateQueryExpression(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AsCreateQueryExpressionContext* MySQLParser::asCreateQueryExpression() {
  AsCreateQueryExpressionContext *_localctx = _tracker.createInstance<AsCreateQueryExpressionContext>(_ctx, getState());
  enterRule(_localctx, 94, MySQLParser::RuleAsCreateQueryExpression);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2294);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 114, _ctx)) {
    case 1: {
      setState(2293);
      match(MySQLParser::AS_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(2296);
    queryExpressionWithOptLockingClauses();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QueryExpressionOrParensContext ------------------------------------------------------------------

MySQLParser::QueryExpressionOrParensContext::QueryExpressionOrParensContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionContext* MySQLParser::QueryExpressionOrParensContext::queryExpression() {
  return getRuleContext<MySQLParser::QueryExpressionContext>(0);
}

MySQLParser::LockingClauseListContext* MySQLParser::QueryExpressionOrParensContext::lockingClauseList() {
  return getRuleContext<MySQLParser::LockingClauseListContext>(0);
}

MySQLParser::QueryExpressionParensContext* MySQLParser::QueryExpressionOrParensContext::queryExpressionParens() {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(0);
}


size_t MySQLParser::QueryExpressionOrParensContext::getRuleIndex() const {
  return MySQLParser::RuleQueryExpressionOrParens;
}

void MySQLParser::QueryExpressionOrParensContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQueryExpressionOrParens(this);
}

void MySQLParser::QueryExpressionOrParensContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQueryExpressionOrParens(this);
}


std::any MySQLParser::QueryExpressionOrParensContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQueryExpressionOrParens(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryExpressionOrParensContext* MySQLParser::queryExpressionOrParens() {
  QueryExpressionOrParensContext *_localctx = _tracker.createInstance<QueryExpressionOrParensContext>(_ctx, getState());
  enterRule(_localctx, 96, MySQLParser::RuleQueryExpressionOrParens);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2303);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 116, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2298);
      queryExpression();
      setState(2300);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 115, _ctx)) {
      case 1: {
        setState(2299);
        lockingClauseList();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2302);
      queryExpressionParens();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QueryExpressionWithOptLockingClausesContext ------------------------------------------------------------------

MySQLParser::QueryExpressionWithOptLockingClausesContext::QueryExpressionWithOptLockingClausesContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionContext* MySQLParser::QueryExpressionWithOptLockingClausesContext::queryExpression() {
  return getRuleContext<MySQLParser::QueryExpressionContext>(0);
}

MySQLParser::LockingClauseListContext* MySQLParser::QueryExpressionWithOptLockingClausesContext::lockingClauseList() {
  return getRuleContext<MySQLParser::LockingClauseListContext>(0);
}


size_t MySQLParser::QueryExpressionWithOptLockingClausesContext::getRuleIndex() const {
  return MySQLParser::RuleQueryExpressionWithOptLockingClauses;
}

void MySQLParser::QueryExpressionWithOptLockingClausesContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQueryExpressionWithOptLockingClauses(this);
}

void MySQLParser::QueryExpressionWithOptLockingClausesContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQueryExpressionWithOptLockingClauses(this);
}


std::any MySQLParser::QueryExpressionWithOptLockingClausesContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQueryExpressionWithOptLockingClauses(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryExpressionWithOptLockingClausesContext* MySQLParser::queryExpressionWithOptLockingClauses() {
  QueryExpressionWithOptLockingClausesContext *_localctx = _tracker.createInstance<QueryExpressionWithOptLockingClausesContext>(_ctx, getState());
  enterRule(_localctx, 98, MySQLParser::RuleQueryExpressionWithOptLockingClauses);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2305);
    queryExpression();
    setState(2307);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 117, _ctx)) {
    case 1: {
      setState(2306);
      lockingClauseList();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateRoutineContext ------------------------------------------------------------------

MySQLParser::CreateRoutineContext::CreateRoutineContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateRoutineContext::CREATE_SYMBOL() {
  return getToken(MySQLParser::CREATE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateRoutineContext::EOF() {
  return getToken(MySQLParser::EOF, 0);
}

MySQLParser::CreateProcedureContext* MySQLParser::CreateRoutineContext::createProcedure() {
  return getRuleContext<MySQLParser::CreateProcedureContext>(0);
}

MySQLParser::CreateFunctionContext* MySQLParser::CreateRoutineContext::createFunction() {
  return getRuleContext<MySQLParser::CreateFunctionContext>(0);
}

MySQLParser::CreateUdfContext* MySQLParser::CreateRoutineContext::createUdf() {
  return getRuleContext<MySQLParser::CreateUdfContext>(0);
}

tree::TerminalNode* MySQLParser::CreateRoutineContext::SEMICOLON_SYMBOL() {
  return getToken(MySQLParser::SEMICOLON_SYMBOL, 0);
}


size_t MySQLParser::CreateRoutineContext::getRuleIndex() const {
  return MySQLParser::RuleCreateRoutine;
}

void MySQLParser::CreateRoutineContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateRoutine(this);
}

void MySQLParser::CreateRoutineContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateRoutine(this);
}


std::any MySQLParser::CreateRoutineContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateRoutine(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateRoutineContext* MySQLParser::createRoutine() {
  CreateRoutineContext *_localctx = _tracker.createInstance<CreateRoutineContext>(_ctx, getState());
  enterRule(_localctx, 100, MySQLParser::RuleCreateRoutine);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2309);
    match(MySQLParser::CREATE_SYMBOL);
    setState(2313);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 118, _ctx)) {
    case 1: {
      setState(2310);
      createProcedure();
      break;
    }

    case 2: {
      setState(2311);
      createFunction();
      break;
    }

    case 3: {
      setState(2312);
      createUdf();
      break;
    }

    default:
      break;
    }
    setState(2316);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::SEMICOLON_SYMBOL) {
      setState(2315);
      match(MySQLParser::SEMICOLON_SYMBOL);
    }
    setState(2318);
    match(MySQLParser::EOF);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateProcedureContext ------------------------------------------------------------------

MySQLParser::CreateProcedureContext::CreateProcedureContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateProcedureContext::PROCEDURE_SYMBOL() {
  return getToken(MySQLParser::PROCEDURE_SYMBOL, 0);
}

MySQLParser::ProcedureNameContext* MySQLParser::CreateProcedureContext::procedureName() {
  return getRuleContext<MySQLParser::ProcedureNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateProcedureContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateProcedureContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::StoredRoutineBodyContext* MySQLParser::CreateProcedureContext::storedRoutineBody() {
  return getRuleContext<MySQLParser::StoredRoutineBodyContext>(0);
}

MySQLParser::DefinerClauseContext* MySQLParser::CreateProcedureContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateProcedureContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}

std::vector<MySQLParser::ProcedureParameterContext *> MySQLParser::CreateProcedureContext::procedureParameter() {
  return getRuleContexts<MySQLParser::ProcedureParameterContext>();
}

MySQLParser::ProcedureParameterContext* MySQLParser::CreateProcedureContext::procedureParameter(size_t i) {
  return getRuleContext<MySQLParser::ProcedureParameterContext>(i);
}

std::vector<MySQLParser::RoutineCreateOptionContext *> MySQLParser::CreateProcedureContext::routineCreateOption() {
  return getRuleContexts<MySQLParser::RoutineCreateOptionContext>();
}

MySQLParser::RoutineCreateOptionContext* MySQLParser::CreateProcedureContext::routineCreateOption(size_t i) {
  return getRuleContext<MySQLParser::RoutineCreateOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::CreateProcedureContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::CreateProcedureContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::CreateProcedureContext::getRuleIndex() const {
  return MySQLParser::RuleCreateProcedure;
}

void MySQLParser::CreateProcedureContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateProcedure(this);
}

void MySQLParser::CreateProcedureContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateProcedure(this);
}


std::any MySQLParser::CreateProcedureContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateProcedure(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateProcedureContext* MySQLParser::createProcedure() {
  CreateProcedureContext *_localctx = _tracker.createInstance<CreateProcedureContext>(_ctx, getState());
  enterRule(_localctx, 102, MySQLParser::RuleCreateProcedure);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2321);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(2320);
      definerClause();
    }
    setState(2323);
    match(MySQLParser::PROCEDURE_SYMBOL);
    setState(2326);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 121, _ctx)) {
    case 1: {
      setState(2324);

      if (!(serverVersion >= 80029)) throw FailedPredicateException(this, "serverVersion >= 80029");
      setState(2325);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2328);
    procedureName();
    setState(2329);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(2338);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 123, _ctx)) {
    case 1: {
      setState(2330);
      procedureParameter();
      setState(2335);
      _errHandler->sync(this);
      _la = _input->LA(1);
      while (_la == MySQLParser::COMMA_SYMBOL) {
        setState(2331);
        match(MySQLParser::COMMA_SYMBOL);
        setState(2332);
        procedureParameter();
        setState(2337);
        _errHandler->sync(this);
        _la = _input->LA(1);
      }
      break;
    }

    default:
      break;
    }
    setState(2340);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
    setState(2344);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 124, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2341);
        routineCreateOption(); 
      }
      setState(2346);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 124, _ctx);
    }
    setState(2347);
    storedRoutineBody();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RoutineStringContext ------------------------------------------------------------------

MySQLParser::RoutineStringContext::RoutineStringContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TextStringLiteralContext* MySQLParser::RoutineStringContext::textStringLiteral() {
  return getRuleContext<MySQLParser::TextStringLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::RoutineStringContext::DOLLAR_QUOTED_STRING_TEXT() {
  return getToken(MySQLParser::DOLLAR_QUOTED_STRING_TEXT, 0);
}


size_t MySQLParser::RoutineStringContext::getRuleIndex() const {
  return MySQLParser::RuleRoutineString;
}

void MySQLParser::RoutineStringContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRoutineString(this);
}

void MySQLParser::RoutineStringContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRoutineString(this);
}


std::any MySQLParser::RoutineStringContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRoutineString(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RoutineStringContext* MySQLParser::routineString() {
  RoutineStringContext *_localctx = _tracker.createInstance<RoutineStringContext>(_ctx, getState());
  enterRule(_localctx, 104, MySQLParser::RuleRoutineString);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2351);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 125, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2349);
      textStringLiteral();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2350);
      match(MySQLParser::DOLLAR_QUOTED_STRING_TEXT);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- StoredRoutineBodyContext ------------------------------------------------------------------

MySQLParser::StoredRoutineBodyContext::StoredRoutineBodyContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::CompoundStatementContext* MySQLParser::StoredRoutineBodyContext::compoundStatement() {
  return getRuleContext<MySQLParser::CompoundStatementContext>(0);
}

tree::TerminalNode* MySQLParser::StoredRoutineBodyContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}

MySQLParser::RoutineStringContext* MySQLParser::StoredRoutineBodyContext::routineString() {
  return getRuleContext<MySQLParser::RoutineStringContext>(0);
}


size_t MySQLParser::StoredRoutineBodyContext::getRuleIndex() const {
  return MySQLParser::RuleStoredRoutineBody;
}

void MySQLParser::StoredRoutineBodyContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterStoredRoutineBody(this);
}

void MySQLParser::StoredRoutineBodyContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitStoredRoutineBody(this);
}


std::any MySQLParser::StoredRoutineBodyContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitStoredRoutineBody(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::StoredRoutineBodyContext* MySQLParser::storedRoutineBody() {
  StoredRoutineBodyContext *_localctx = _tracker.createInstance<StoredRoutineBodyContext>(_ctx, getState());
  enterRule(_localctx, 106, MySQLParser::RuleStoredRoutineBody);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2357);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 126, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2353);
      compoundStatement();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2354);

      if (!(serverVersion >= 80032 && supportMle)) throw FailedPredicateException(this, "serverVersion >= 80032 && supportMle");
      setState(2355);
      match(MySQLParser::AS_SYMBOL);
      setState(2356);
      routineString();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateFunctionContext ------------------------------------------------------------------

MySQLParser::CreateFunctionContext::CreateFunctionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateFunctionContext::FUNCTION_SYMBOL() {
  return getToken(MySQLParser::FUNCTION_SYMBOL, 0);
}

MySQLParser::FunctionNameContext* MySQLParser::CreateFunctionContext::functionName() {
  return getRuleContext<MySQLParser::FunctionNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateFunctionContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateFunctionContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateFunctionContext::RETURNS_SYMBOL() {
  return getToken(MySQLParser::RETURNS_SYMBOL, 0);
}

MySQLParser::TypeWithOptCollateContext* MySQLParser::CreateFunctionContext::typeWithOptCollate() {
  return getRuleContext<MySQLParser::TypeWithOptCollateContext>(0);
}

MySQLParser::StoredRoutineBodyContext* MySQLParser::CreateFunctionContext::storedRoutineBody() {
  return getRuleContext<MySQLParser::StoredRoutineBodyContext>(0);
}

MySQLParser::DefinerClauseContext* MySQLParser::CreateFunctionContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateFunctionContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}

std::vector<MySQLParser::FunctionParameterContext *> MySQLParser::CreateFunctionContext::functionParameter() {
  return getRuleContexts<MySQLParser::FunctionParameterContext>();
}

MySQLParser::FunctionParameterContext* MySQLParser::CreateFunctionContext::functionParameter(size_t i) {
  return getRuleContext<MySQLParser::FunctionParameterContext>(i);
}

std::vector<MySQLParser::RoutineCreateOptionContext *> MySQLParser::CreateFunctionContext::routineCreateOption() {
  return getRuleContexts<MySQLParser::RoutineCreateOptionContext>();
}

MySQLParser::RoutineCreateOptionContext* MySQLParser::CreateFunctionContext::routineCreateOption(size_t i) {
  return getRuleContext<MySQLParser::RoutineCreateOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::CreateFunctionContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::CreateFunctionContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::CreateFunctionContext::getRuleIndex() const {
  return MySQLParser::RuleCreateFunction;
}

void MySQLParser::CreateFunctionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateFunction(this);
}

void MySQLParser::CreateFunctionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateFunction(this);
}


std::any MySQLParser::CreateFunctionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateFunction(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateFunctionContext* MySQLParser::createFunction() {
  CreateFunctionContext *_localctx = _tracker.createInstance<CreateFunctionContext>(_ctx, getState());
  enterRule(_localctx, 108, MySQLParser::RuleCreateFunction);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2360);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(2359);
      definerClause();
    }
    setState(2362);
    match(MySQLParser::FUNCTION_SYMBOL);
    setState(2365);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 128, _ctx)) {
    case 1: {
      setState(2363);

      if (!(serverVersion >= 80029)) throw FailedPredicateException(this, "serverVersion >= 80029");
      setState(2364);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2367);
    functionName();
    setState(2368);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(2377);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 130, _ctx)) {
    case 1: {
      setState(2369);
      functionParameter();
      setState(2374);
      _errHandler->sync(this);
      _la = _input->LA(1);
      while (_la == MySQLParser::COMMA_SYMBOL) {
        setState(2370);
        match(MySQLParser::COMMA_SYMBOL);
        setState(2371);
        functionParameter();
        setState(2376);
        _errHandler->sync(this);
        _la = _input->LA(1);
      }
      break;
    }

    default:
      break;
    }
    setState(2379);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
    setState(2380);
    match(MySQLParser::RETURNS_SYMBOL);
    setState(2381);
    typeWithOptCollate();
    setState(2385);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 131, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2382);
        routineCreateOption(); 
      }
      setState(2387);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 131, _ctx);
    }
    setState(2388);
    storedRoutineBody();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateUdfContext ------------------------------------------------------------------

MySQLParser::CreateUdfContext::CreateUdfContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateUdfContext::FUNCTION_SYMBOL() {
  return getToken(MySQLParser::FUNCTION_SYMBOL, 0);
}

MySQLParser::UdfNameContext* MySQLParser::CreateUdfContext::udfName() {
  return getRuleContext<MySQLParser::UdfNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::RETURNS_SYMBOL() {
  return getToken(MySQLParser::RETURNS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::SONAME_SYMBOL() {
  return getToken(MySQLParser::SONAME_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::CreateUdfContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::STRING_SYMBOL() {
  return getToken(MySQLParser::STRING_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::INT_SYMBOL() {
  return getToken(MySQLParser::INT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::REAL_SYMBOL() {
  return getToken(MySQLParser::REAL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::DECIMAL_SYMBOL() {
  return getToken(MySQLParser::DECIMAL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::AGGREGATE_SYMBOL() {
  return getToken(MySQLParser::AGGREGATE_SYMBOL, 0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateUdfContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}


size_t MySQLParser::CreateUdfContext::getRuleIndex() const {
  return MySQLParser::RuleCreateUdf;
}

void MySQLParser::CreateUdfContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateUdf(this);
}

void MySQLParser::CreateUdfContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateUdf(this);
}


std::any MySQLParser::CreateUdfContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateUdf(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateUdfContext* MySQLParser::createUdf() {
  CreateUdfContext *_localctx = _tracker.createInstance<CreateUdfContext>(_ctx, getState());
  enterRule(_localctx, 110, MySQLParser::RuleCreateUdf);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2391);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::AGGREGATE_SYMBOL) {
      setState(2390);
      match(MySQLParser::AGGREGATE_SYMBOL);
    }
    setState(2393);
    match(MySQLParser::FUNCTION_SYMBOL);
    setState(2396);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 133, _ctx)) {
    case 1: {
      setState(2394);

      if (!(serverVersion >= 80029)) throw FailedPredicateException(this, "serverVersion >= 80029");
      setState(2395);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2398);
    udfName();
    setState(2399);
    match(MySQLParser::RETURNS_SYMBOL);
    setState(2400);
    antlrcpp::downCast<CreateUdfContext *>(_localctx)->type = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::DECIMAL_SYMBOL || _la == MySQLParser::INT_SYMBOL || _la == MySQLParser::REAL_SYMBOL || _la == MySQLParser::STRING_SYMBOL)) {
      antlrcpp::downCast<CreateUdfContext *>(_localctx)->type = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2401);
    match(MySQLParser::SONAME_SYMBOL);
    setState(2402);
    textLiteral();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RoutineCreateOptionContext ------------------------------------------------------------------

MySQLParser::RoutineCreateOptionContext::RoutineCreateOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::RoutineOptionContext* MySQLParser::RoutineCreateOptionContext::routineOption() {
  return getRuleContext<MySQLParser::RoutineOptionContext>(0);
}

tree::TerminalNode* MySQLParser::RoutineCreateOptionContext::DETERMINISTIC_SYMBOL() {
  return getToken(MySQLParser::DETERMINISTIC_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineCreateOptionContext::NOT_SYMBOL() {
  return getToken(MySQLParser::NOT_SYMBOL, 0);
}


size_t MySQLParser::RoutineCreateOptionContext::getRuleIndex() const {
  return MySQLParser::RuleRoutineCreateOption;
}

void MySQLParser::RoutineCreateOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRoutineCreateOption(this);
}

void MySQLParser::RoutineCreateOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRoutineCreateOption(this);
}


std::any MySQLParser::RoutineCreateOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRoutineCreateOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RoutineCreateOptionContext* MySQLParser::routineCreateOption() {
  RoutineCreateOptionContext *_localctx = _tracker.createInstance<RoutineCreateOptionContext>(_ctx, getState());
  enterRule(_localctx, 112, MySQLParser::RuleRoutineCreateOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2409);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::COMMENT_SYMBOL:
      case MySQLParser::CONTAINS_SYMBOL:
      case MySQLParser::LANGUAGE_SYMBOL:
      case MySQLParser::MODIFIES_SYMBOL:
      case MySQLParser::NO_SYMBOL:
      case MySQLParser::READS_SYMBOL:
      case MySQLParser::SQL_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2404);
        routineOption();
        break;
      }

      case MySQLParser::DETERMINISTIC_SYMBOL:
      case MySQLParser::NOT_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2406);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::NOT_SYMBOL) {
          setState(2405);
          match(MySQLParser::NOT_SYMBOL);
        }
        setState(2408);
        match(MySQLParser::DETERMINISTIC_SYMBOL);
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RoutineAlterOptionsContext ------------------------------------------------------------------

MySQLParser::RoutineAlterOptionsContext::RoutineAlterOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::RoutineCreateOptionContext *> MySQLParser::RoutineAlterOptionsContext::routineCreateOption() {
  return getRuleContexts<MySQLParser::RoutineCreateOptionContext>();
}

MySQLParser::RoutineCreateOptionContext* MySQLParser::RoutineAlterOptionsContext::routineCreateOption(size_t i) {
  return getRuleContext<MySQLParser::RoutineCreateOptionContext>(i);
}


size_t MySQLParser::RoutineAlterOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleRoutineAlterOptions;
}

void MySQLParser::RoutineAlterOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRoutineAlterOptions(this);
}

void MySQLParser::RoutineAlterOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRoutineAlterOptions(this);
}


std::any MySQLParser::RoutineAlterOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRoutineAlterOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RoutineAlterOptionsContext* MySQLParser::routineAlterOptions() {
  RoutineAlterOptionsContext *_localctx = _tracker.createInstance<RoutineAlterOptionsContext>(_ctx, getState());
  enterRule(_localctx, 114, MySQLParser::RuleRoutineAlterOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2412); 
    _errHandler->sync(this);
    _la = _input->LA(1);
    do {
      setState(2411);
      routineCreateOption();
      setState(2414); 
      _errHandler->sync(this);
      _la = _input->LA(1);
    } while (((((_la - 119) & ~ 0x3fULL) == 0) &&
      ((1ULL << (_la - 119)) & ((1ULL << (MySQLParser::COMMENT_SYMBOL - 119))
      | (1ULL << (MySQLParser::CONTAINS_SYMBOL - 119))
      | (1ULL << (MySQLParser::DETERMINISTIC_SYMBOL - 119)))) != 0) || _la == MySQLParser::LANGUAGE_SYMBOL || ((((_la - 378) & ~ 0x3fULL) == 0) &&
      ((1ULL << (_la - 378)) & ((1ULL << (MySQLParser::MODIFIES_SYMBOL - 378))
      | (1ULL << (MySQLParser::NOT_SYMBOL - 378))
      | (1ULL << (MySQLParser::NO_SYMBOL - 378)))) != 0) || _la == MySQLParser::READS_SYMBOL || _la == MySQLParser::SQL_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RoutineOptionContext ------------------------------------------------------------------

MySQLParser::RoutineOptionContext::RoutineOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TextLiteralContext* MySQLParser::RoutineOptionContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::COMMENT_SYMBOL() {
  return getToken(MySQLParser::COMMENT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::LANGUAGE_SYMBOL() {
  return getToken(MySQLParser::LANGUAGE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::SQL_SYMBOL() {
  return getToken(MySQLParser::SQL_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::RoutineOptionContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::NO_SYMBOL() {
  return getToken(MySQLParser::NO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::CONTAINS_SYMBOL() {
  return getToken(MySQLParser::CONTAINS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::DATA_SYMBOL() {
  return getToken(MySQLParser::DATA_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::READS_SYMBOL() {
  return getToken(MySQLParser::READS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::MODIFIES_SYMBOL() {
  return getToken(MySQLParser::MODIFIES_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::SECURITY_SYMBOL() {
  return getToken(MySQLParser::SECURITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::DEFINER_SYMBOL() {
  return getToken(MySQLParser::DEFINER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::INVOKER_SYMBOL() {
  return getToken(MySQLParser::INVOKER_SYMBOL, 0);
}


size_t MySQLParser::RoutineOptionContext::getRuleIndex() const {
  return MySQLParser::RuleRoutineOption;
}

void MySQLParser::RoutineOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRoutineOption(this);
}

void MySQLParser::RoutineOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRoutineOption(this);
}


std::any MySQLParser::RoutineOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRoutineOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RoutineOptionContext* MySQLParser::routineOption() {
  RoutineOptionContext *_localctx = _tracker.createInstance<RoutineOptionContext>(_ctx, getState());
  enterRule(_localctx, 116, MySQLParser::RuleRoutineOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2437);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::COMMENT_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2416);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::COMMENT_SYMBOL);
        setState(2417);
        textLiteral();
        break;
      }

      case MySQLParser::LANGUAGE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2418);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::LANGUAGE_SYMBOL);
        setState(2422);
        _errHandler->sync(this);
        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 137, _ctx)) {
        case 1: {
          setState(2419);
          match(MySQLParser::SQL_SYMBOL);
          break;
        }

        case 2: {
          setState(2420);

          if (!(serverVersion >= 80032)) throw FailedPredicateException(this, "serverVersion >= 80032");
          setState(2421);
          identifier();
          break;
        }

        default:
          break;
        }
        break;
      }

      case MySQLParser::NO_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(2424);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::NO_SYMBOL);
        setState(2425);
        match(MySQLParser::SQL_SYMBOL);
        break;
      }

      case MySQLParser::CONTAINS_SYMBOL: {
        enterOuterAlt(_localctx, 4);
        setState(2426);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::CONTAINS_SYMBOL);
        setState(2427);
        match(MySQLParser::SQL_SYMBOL);
        break;
      }

      case MySQLParser::READS_SYMBOL: {
        enterOuterAlt(_localctx, 5);
        setState(2428);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::READS_SYMBOL);
        setState(2429);
        match(MySQLParser::SQL_SYMBOL);
        setState(2430);
        match(MySQLParser::DATA_SYMBOL);
        break;
      }

      case MySQLParser::MODIFIES_SYMBOL: {
        enterOuterAlt(_localctx, 6);
        setState(2431);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::MODIFIES_SYMBOL);
        setState(2432);
        match(MySQLParser::SQL_SYMBOL);
        setState(2433);
        match(MySQLParser::DATA_SYMBOL);
        break;
      }

      case MySQLParser::SQL_SYMBOL: {
        enterOuterAlt(_localctx, 7);
        setState(2434);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::SQL_SYMBOL);
        setState(2435);
        match(MySQLParser::SECURITY_SYMBOL);
        setState(2436);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->security = _input->LT(1);
        _la = _input->LA(1);
        if (!(_la == MySQLParser::DEFINER_SYMBOL || _la == MySQLParser::INVOKER_SYMBOL)) {
          antlrcpp::downCast<RoutineOptionContext *>(_localctx)->security = _errHandler->recoverInline(this);
        }
        else {
          _errHandler->reportMatch(this);
          consume();
        }
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateIndexContext ------------------------------------------------------------------

MySQLParser::CreateIndexContext::CreateIndexContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::IndexNameContext* MySQLParser::CreateIndexContext::indexName() {
  return getRuleContext<MySQLParser::IndexNameContext>(0);
}

MySQLParser::CreateIndexTargetContext* MySQLParser::CreateIndexContext::createIndexTarget() {
  return getRuleContext<MySQLParser::CreateIndexTargetContext>(0);
}

tree::TerminalNode* MySQLParser::CreateIndexContext::INDEX_SYMBOL() {
  return getToken(MySQLParser::INDEX_SYMBOL, 0);
}

MySQLParser::OnlineOptionContext* MySQLParser::CreateIndexContext::onlineOption() {
  return getRuleContext<MySQLParser::OnlineOptionContext>(0);
}

tree::TerminalNode* MySQLParser::CreateIndexContext::FULLTEXT_SYMBOL() {
  return getToken(MySQLParser::FULLTEXT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateIndexContext::SPATIAL_SYMBOL() {
  return getToken(MySQLParser::SPATIAL_SYMBOL, 0);
}

MySQLParser::IndexLockAndAlgorithmContext* MySQLParser::CreateIndexContext::indexLockAndAlgorithm() {
  return getRuleContext<MySQLParser::IndexLockAndAlgorithmContext>(0);
}

tree::TerminalNode* MySQLParser::CreateIndexContext::UNIQUE_SYMBOL() {
  return getToken(MySQLParser::UNIQUE_SYMBOL, 0);
}

MySQLParser::IndexTypeClauseContext* MySQLParser::CreateIndexContext::indexTypeClause() {
  return getRuleContext<MySQLParser::IndexTypeClauseContext>(0);
}

std::vector<MySQLParser::IndexOptionContext *> MySQLParser::CreateIndexContext::indexOption() {
  return getRuleContexts<MySQLParser::IndexOptionContext>();
}

MySQLParser::IndexOptionContext* MySQLParser::CreateIndexContext::indexOption(size_t i) {
  return getRuleContext<MySQLParser::IndexOptionContext>(i);
}

std::vector<MySQLParser::FulltextIndexOptionContext *> MySQLParser::CreateIndexContext::fulltextIndexOption() {
  return getRuleContexts<MySQLParser::FulltextIndexOptionContext>();
}

MySQLParser::FulltextIndexOptionContext* MySQLParser::CreateIndexContext::fulltextIndexOption(size_t i) {
  return getRuleContext<MySQLParser::FulltextIndexOptionContext>(i);
}

std::vector<MySQLParser::SpatialIndexOptionContext *> MySQLParser::CreateIndexContext::spatialIndexOption() {
  return getRuleContexts<MySQLParser::SpatialIndexOptionContext>();
}

MySQLParser::SpatialIndexOptionContext* MySQLParser::CreateIndexContext::spatialIndexOption(size_t i) {
  return getRuleContext<MySQLParser::SpatialIndexOptionContext>(i);
}


size_t MySQLParser::CreateIndexContext::getRuleIndex() const {
  return MySQLParser::RuleCreateIndex;
}

void MySQLParser::CreateIndexContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateIndex(this);
}

void MySQLParser::CreateIndexContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateIndex(this);
}


std::any MySQLParser::CreateIndexContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateIndex(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateIndexContext* MySQLParser::createIndex() {
  CreateIndexContext *_localctx = _tracker.createInstance<CreateIndexContext>(_ctx, getState());
  enterRule(_localctx, 118, MySQLParser::RuleCreateIndex);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2440);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OFFLINE_SYMBOL

    || _la == MySQLParser::ONLINE_SYMBOL) {
      setState(2439);
      onlineOption();
    }
    setState(2477);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::INDEX_SYMBOL:
      case MySQLParser::UNIQUE_SYMBOL: {
        setState(2443);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::UNIQUE_SYMBOL) {
          setState(2442);
          match(MySQLParser::UNIQUE_SYMBOL);
        }
        setState(2445);
        antlrcpp::downCast<CreateIndexContext *>(_localctx)->type = match(MySQLParser::INDEX_SYMBOL);
        setState(2446);
        indexName();
        setState(2448);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::TYPE_SYMBOL

        || _la == MySQLParser::USING_SYMBOL) {
          setState(2447);
          indexTypeClause();
        }
        setState(2450);
        createIndexTarget();
        setState(2454);
        _errHandler->sync(this);
        alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 142, _ctx);
        while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
          if (alt == 1) {
            setState(2451);
            indexOption(); 
          }
          setState(2456);
          _errHandler->sync(this);
          alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 142, _ctx);
        }
        break;
      }

      case MySQLParser::FULLTEXT_SYMBOL: {
        setState(2457);
        antlrcpp::downCast<CreateIndexContext *>(_localctx)->type = match(MySQLParser::FULLTEXT_SYMBOL);
        setState(2458);
        match(MySQLParser::INDEX_SYMBOL);
        setState(2459);
        indexName();
        setState(2460);
        createIndexTarget();
        setState(2464);
        _errHandler->sync(this);
        alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 143, _ctx);
        while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
          if (alt == 1) {
            setState(2461);
            fulltextIndexOption(); 
          }
          setState(2466);
          _errHandler->sync(this);
          alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 143, _ctx);
        }
        break;
      }

      case MySQLParser::SPATIAL_SYMBOL: {
        setState(2467);
        antlrcpp::downCast<CreateIndexContext *>(_localctx)->type = match(MySQLParser::SPATIAL_SYMBOL);
        setState(2468);
        match(MySQLParser::INDEX_SYMBOL);
        setState(2469);
        indexName();
        setState(2470);
        createIndexTarget();
        setState(2474);
        _errHandler->sync(this);
        alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 144, _ctx);
        while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
          if (alt == 1) {
            setState(2471);
            spatialIndexOption(); 
          }
          setState(2476);
          _errHandler->sync(this);
          alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 144, _ctx);
        }
        break;
      }

    default:
      throw NoViableAltException(this);
    }
    setState(2480);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ALGORITHM_SYMBOL || _la == MySQLParser::LOCK_SYMBOL) {
      setState(2479);
      indexLockAndAlgorithm();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- IndexNameAndTypeContext ------------------------------------------------------------------

MySQLParser::IndexNameAndTypeContext::IndexNameAndTypeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::IndexNameContext* MySQLParser::IndexNameAndTypeContext::indexName() {
  return getRuleContext<MySQLParser::IndexNameContext>(0);
}

tree::TerminalNode* MySQLParser::IndexNameAndTypeContext::USING_SYMBOL() {
  return getToken(MySQLParser::USING_SYMBOL, 0);
}

MySQLParser::IndexTypeContext* MySQLParser::IndexNameAndTypeContext::indexType() {
  return getRuleContext<MySQLParser::IndexTypeContext>(0);
}

tree::TerminalNode* MySQLParser::IndexNameAndTypeContext::TYPE_SYMBOL() {
  return getToken(MySQLParser::TYPE_SYMBOL, 0);
}


size_t MySQLParser::IndexNameAndTypeContext::getRuleIndex() const {
  return MySQLParser::RuleIndexNameAndType;
}

void MySQLParser::IndexNameAndTypeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterIndexNameAndType(this);
}

void MySQLParser::IndexNameAndTypeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitIndexNameAndType(this);
}


std::any MySQLParser::IndexNameAndTypeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitIndexNameAndType(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::IndexNameAndTypeContext* MySQLParser::indexNameAndType() {
  IndexNameAndTypeContext *_localctx = _tracker.createInstance<IndexNameAndTypeContext>(_ctx, getState());
  enterRule(_localctx, 120, MySQLParser::RuleIndexNameAndType);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2492);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 148, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2482);
      indexName();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2484);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 147, _ctx)) {
      case 1: {
        setState(2483);
        indexName();
        break;
      }

      default:
        break;
      }
      setState(2486);
      match(MySQLParser::USING_SYMBOL);
      setState(2487);
      indexType();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(2488);
      indexName();
      setState(2489);
      match(MySQLParser::TYPE_SYMBOL);
      setState(2490);
      indexType();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateIndexTargetContext ------------------------------------------------------------------

MySQLParser::CreateIndexTargetContext::CreateIndexTargetContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateIndexTargetContext::ON_SYMBOL() {
  return getToken(MySQLParser::ON_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::CreateIndexTargetContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::KeyListWithExpressionContext* MySQLParser::CreateIndexTargetContext::keyListWithExpression() {
  return getRuleContext<MySQLParser::KeyListWithExpressionContext>(0);
}


size_t MySQLParser::CreateIndexTargetContext::getRuleIndex() const {
  return MySQLParser::RuleCreateIndexTarget;
}

void MySQLParser::CreateIndexTargetContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateIndexTarget(this);
}

void MySQLParser::CreateIndexTargetContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateIndexTarget(this);
}


std::any MySQLParser::CreateIndexTargetContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateIndexTarget(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateIndexTargetContext* MySQLParser::createIndexTarget() {
  CreateIndexTargetContext *_localctx = _tracker.createInstance<CreateIndexTargetContext>(_ctx, getState());
  enterRule(_localctx, 122, MySQLParser::RuleCreateIndexTarget);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2494);
    match(MySQLParser::ON_SYMBOL);
    setState(2495);
    tableRef();
    setState(2496);
    keyListWithExpression();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateLogfileGroupContext ------------------------------------------------------------------

MySQLParser::CreateLogfileGroupContext::CreateLogfileGroupContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateLogfileGroupContext::LOGFILE_SYMBOL() {
  return getToken(MySQLParser::LOGFILE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateLogfileGroupContext::GROUP_SYMBOL() {
  return getToken(MySQLParser::GROUP_SYMBOL, 0);
}

MySQLParser::LogfileGroupNameContext* MySQLParser::CreateLogfileGroupContext::logfileGroupName() {
  return getRuleContext<MySQLParser::LogfileGroupNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateLogfileGroupContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateLogfileGroupContext::UNDOFILE_SYMBOL() {
  return getToken(MySQLParser::UNDOFILE_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::CreateLogfileGroupContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

MySQLParser::LogfileGroupOptionsContext* MySQLParser::CreateLogfileGroupContext::logfileGroupOptions() {
  return getRuleContext<MySQLParser::LogfileGroupOptionsContext>(0);
}


size_t MySQLParser::CreateLogfileGroupContext::getRuleIndex() const {
  return MySQLParser::RuleCreateLogfileGroup;
}

void MySQLParser::CreateLogfileGroupContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateLogfileGroup(this);
}

void MySQLParser::CreateLogfileGroupContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateLogfileGroup(this);
}


std::any MySQLParser::CreateLogfileGroupContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateLogfileGroup(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateLogfileGroupContext* MySQLParser::createLogfileGroup() {
  CreateLogfileGroupContext *_localctx = _tracker.createInstance<CreateLogfileGroupContext>(_ctx, getState());
  enterRule(_localctx, 124, MySQLParser::RuleCreateLogfileGroup);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2498);
    match(MySQLParser::LOGFILE_SYMBOL);
    setState(2499);
    match(MySQLParser::GROUP_SYMBOL);
    setState(2500);
    logfileGroupName();
    setState(2501);
    match(MySQLParser::ADD_SYMBOL);
    setState(2502);
    match(MySQLParser::UNDOFILE_SYMBOL);
    setState(2503);
    textLiteral();
    setState(2505);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::COMMENT_SYMBOL || _la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::INITIAL_SIZE_SYMBOL || _la == MySQLParser::NODEGROUP_SYMBOL

    || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::REDO_BUFFER_SIZE_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL

    || _la == MySQLParser::UNDO_BUFFER_SIZE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
      setState(2504);
      logfileGroupOptions();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LogfileGroupOptionsContext ------------------------------------------------------------------

MySQLParser::LogfileGroupOptionsContext::LogfileGroupOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::LogfileGroupOptionContext *> MySQLParser::LogfileGroupOptionsContext::logfileGroupOption() {
  return getRuleContexts<MySQLParser::LogfileGroupOptionContext>();
}

MySQLParser::LogfileGroupOptionContext* MySQLParser::LogfileGroupOptionsContext::logfileGroupOption(size_t i) {
  return getRuleContext<MySQLParser::LogfileGroupOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::LogfileGroupOptionsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::LogfileGroupOptionsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::LogfileGroupOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleLogfileGroupOptions;
}

void MySQLParser::LogfileGroupOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLogfileGroupOptions(this);
}

void MySQLParser::LogfileGroupOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLogfileGroupOptions(this);
}


std::any MySQLParser::LogfileGroupOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLogfileGroupOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LogfileGroupOptionsContext* MySQLParser::logfileGroupOptions() {
  LogfileGroupOptionsContext *_localctx = _tracker.createInstance<LogfileGroupOptionsContext>(_ctx, getState());
  enterRule(_localctx, 126, MySQLParser::RuleLogfileGroupOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2507);
    logfileGroupOption();
    setState(2514);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL || _la == MySQLParser::COMMENT_SYMBOL || _la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::INITIAL_SIZE_SYMBOL || _la == MySQLParser::NODEGROUP_SYMBOL

    || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::REDO_BUFFER_SIZE_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL

    || _la == MySQLParser::UNDO_BUFFER_SIZE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
      setState(2509);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::COMMA_SYMBOL) {
        setState(2508);
        match(MySQLParser::COMMA_SYMBOL);
      }
      setState(2511);
      logfileGroupOption();
      setState(2516);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LogfileGroupOptionContext ------------------------------------------------------------------

MySQLParser::LogfileGroupOptionContext::LogfileGroupOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TsOptionInitialSizeContext* MySQLParser::LogfileGroupOptionContext::tsOptionInitialSize() {
  return getRuleContext<MySQLParser::TsOptionInitialSizeContext>(0);
}

MySQLParser::TsOptionUndoRedoBufferSizeContext* MySQLParser::LogfileGroupOptionContext::tsOptionUndoRedoBufferSize() {
  return getRuleContext<MySQLParser::TsOptionUndoRedoBufferSizeContext>(0);
}

MySQLParser::TsOptionNodegroupContext* MySQLParser::LogfileGroupOptionContext::tsOptionNodegroup() {
  return getRuleContext<MySQLParser::TsOptionNodegroupContext>(0);
}

MySQLParser::TsOptionEngineContext* MySQLParser::LogfileGroupOptionContext::tsOptionEngine() {
  return getRuleContext<MySQLParser::TsOptionEngineContext>(0);
}

MySQLParser::TsOptionWaitContext* MySQLParser::LogfileGroupOptionContext::tsOptionWait() {
  return getRuleContext<MySQLParser::TsOptionWaitContext>(0);
}

MySQLParser::TsOptionCommentContext* MySQLParser::LogfileGroupOptionContext::tsOptionComment() {
  return getRuleContext<MySQLParser::TsOptionCommentContext>(0);
}


size_t MySQLParser::LogfileGroupOptionContext::getRuleIndex() const {
  return MySQLParser::RuleLogfileGroupOption;
}

void MySQLParser::LogfileGroupOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLogfileGroupOption(this);
}

void MySQLParser::LogfileGroupOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLogfileGroupOption(this);
}


std::any MySQLParser::LogfileGroupOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLogfileGroupOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LogfileGroupOptionContext* MySQLParser::logfileGroupOption() {
  LogfileGroupOptionContext *_localctx = _tracker.createInstance<LogfileGroupOptionContext>(_ctx, getState());
  enterRule(_localctx, 128, MySQLParser::RuleLogfileGroupOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2523);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::INITIAL_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2517);
        tsOptionInitialSize();
        break;
      }

      case MySQLParser::REDO_BUFFER_SIZE_SYMBOL:
      case MySQLParser::UNDO_BUFFER_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2518);
        tsOptionUndoRedoBufferSize();
        break;
      }

      case MySQLParser::NODEGROUP_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(2519);
        tsOptionNodegroup();
        break;
      }

      case MySQLParser::ENGINE_SYMBOL:
      case MySQLParser::STORAGE_SYMBOL: {
        enterOuterAlt(_localctx, 4);
        setState(2520);
        tsOptionEngine();
        break;
      }

      case MySQLParser::NO_WAIT_SYMBOL:
      case MySQLParser::WAIT_SYMBOL: {
        enterOuterAlt(_localctx, 5);
        setState(2521);
        tsOptionWait();
        break;
      }

      case MySQLParser::COMMENT_SYMBOL: {
        enterOuterAlt(_localctx, 6);
        setState(2522);
        tsOptionComment();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateServerContext ------------------------------------------------------------------

MySQLParser::CreateServerContext::CreateServerContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateServerContext::SERVER_SYMBOL() {
  return getToken(MySQLParser::SERVER_SYMBOL, 0);
}

MySQLParser::ServerNameContext* MySQLParser::CreateServerContext::serverName() {
  return getRuleContext<MySQLParser::ServerNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateServerContext::FOREIGN_SYMBOL() {
  return getToken(MySQLParser::FOREIGN_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateServerContext::DATA_SYMBOL() {
  return getToken(MySQLParser::DATA_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateServerContext::WRAPPER_SYMBOL() {
  return getToken(MySQLParser::WRAPPER_SYMBOL, 0);
}

MySQLParser::TextOrIdentifierContext* MySQLParser::CreateServerContext::textOrIdentifier() {
  return getRuleContext<MySQLParser::TextOrIdentifierContext>(0);
}

MySQLParser::ServerOptionsContext* MySQLParser::CreateServerContext::serverOptions() {
  return getRuleContext<MySQLParser::ServerOptionsContext>(0);
}


size_t MySQLParser::CreateServerContext::getRuleIndex() const {
  return MySQLParser::RuleCreateServer;
}

void MySQLParser::CreateServerContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateServer(this);
}

void MySQLParser::CreateServerContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateServer(this);
}


std::any MySQLParser::CreateServerContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateServer(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateServerContext* MySQLParser::createServer() {
  CreateServerContext *_localctx = _tracker.createInstance<CreateServerContext>(_ctx, getState());
  enterRule(_localctx, 130, MySQLParser::RuleCreateServer);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2525);
    match(MySQLParser::SERVER_SYMBOL);
    setState(2526);
    serverName();
    setState(2527);
    match(MySQLParser::FOREIGN_SYMBOL);
    setState(2528);
    match(MySQLParser::DATA_SYMBOL);
    setState(2529);
    match(MySQLParser::WRAPPER_SYMBOL);
    setState(2530);
    textOrIdentifier();
    setState(2531);
    serverOptions();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ServerOptionsContext ------------------------------------------------------------------

MySQLParser::ServerOptionsContext::ServerOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ServerOptionsContext::OPTIONS_SYMBOL() {
  return getToken(MySQLParser::OPTIONS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ServerOptionsContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

std::vector<MySQLParser::ServerOptionContext *> MySQLParser::ServerOptionsContext::serverOption() {
  return getRuleContexts<MySQLParser::ServerOptionContext>();
}

MySQLParser::ServerOptionContext* MySQLParser::ServerOptionsContext::serverOption(size_t i) {
  return getRuleContext<MySQLParser::ServerOptionContext>(i);
}

tree::TerminalNode* MySQLParser::ServerOptionsContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

std::vector<tree::TerminalNode *> MySQLParser::ServerOptionsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::ServerOptionsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::ServerOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleServerOptions;
}

void MySQLParser::ServerOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterServerOptions(this);
}

void MySQLParser::ServerOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitServerOptions(this);
}


std::any MySQLParser::ServerOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitServerOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ServerOptionsContext* MySQLParser::serverOptions() {
  ServerOptionsContext *_localctx = _tracker.createInstance<ServerOptionsContext>(_ctx, getState());
  enterRule(_localctx, 132, MySQLParser::RuleServerOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2533);
    match(MySQLParser::OPTIONS_SYMBOL);
    setState(2534);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(2535);
    serverOption();
    setState(2540);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(2536);
      match(MySQLParser::COMMA_SYMBOL);
      setState(2537);
      serverOption();
      setState(2542);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
    setState(2543);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ServerOptionContext ------------------------------------------------------------------

MySQLParser::ServerOptionContext::ServerOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TextLiteralContext* MySQLParser::ServerOptionContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::HOST_SYMBOL() {
  return getToken(MySQLParser::HOST_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::DATABASE_SYMBOL() {
  return getToken(MySQLParser::DATABASE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::USER_SYMBOL() {
  return getToken(MySQLParser::USER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::PASSWORD_SYMBOL() {
  return getToken(MySQLParser::PASSWORD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::SOCKET_SYMBOL() {
  return getToken(MySQLParser::SOCKET_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::OWNER_SYMBOL() {
  return getToken(MySQLParser::OWNER_SYMBOL, 0);
}

MySQLParser::Ulong_numberContext* MySQLParser::ServerOptionContext::ulong_number() {
  return getRuleContext<MySQLParser::Ulong_numberContext>(0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::PORT_SYMBOL() {
  return getToken(MySQLParser::PORT_SYMBOL, 0);
}


size_t MySQLParser::ServerOptionContext::getRuleIndex() const {
  return MySQLParser::RuleServerOption;
}

void MySQLParser::ServerOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterServerOption(this);
}

void MySQLParser::ServerOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitServerOption(this);
}


std::any MySQLParser::ServerOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitServerOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ServerOptionContext* MySQLParser::serverOption() {
  ServerOptionContext *_localctx = _tracker.createInstance<ServerOptionContext>(_ctx, getState());
  enterRule(_localctx, 134, MySQLParser::RuleServerOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2559);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::HOST_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2545);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::HOST_SYMBOL);
        setState(2546);
        textLiteral();
        break;
      }

      case MySQLParser::DATABASE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2547);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::DATABASE_SYMBOL);
        setState(2548);
        textLiteral();
        break;
      }

      case MySQLParser::USER_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(2549);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::USER_SYMBOL);
        setState(2550);
        textLiteral();
        break;
      }

      case MySQLParser::PASSWORD_SYMBOL: {
        enterOuterAlt(_localctx, 4);
        setState(2551);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::PASSWORD_SYMBOL);
        setState(2552);
        textLiteral();
        break;
      }

      case MySQLParser::SOCKET_SYMBOL: {
        enterOuterAlt(_localctx, 5);
        setState(2553);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::SOCKET_SYMBOL);
        setState(2554);
        textLiteral();
        break;
      }

      case MySQLParser::OWNER_SYMBOL: {
        enterOuterAlt(_localctx, 6);
        setState(2555);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::OWNER_SYMBOL);
        setState(2556);
        textLiteral();
        break;
      }

      case MySQLParser::PORT_SYMBOL: {
        enterOuterAlt(_localctx, 7);
        setState(2557);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::PORT_SYMBOL);
        setState(2558);
        ulong_number();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateTablespaceContext ------------------------------------------------------------------

MySQLParser::CreateTablespaceContext::CreateTablespaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateTablespaceContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

MySQLParser::TablespaceNameContext* MySQLParser::CreateTablespaceContext::tablespaceName() {
  return getRuleContext<MySQLParser::TablespaceNameContext>(0);
}

MySQLParser::TsDataFileNameContext* MySQLParser::CreateTablespaceContext::tsDataFileName() {
  return getRuleContext<MySQLParser::TsDataFileNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateTablespaceContext::USE_SYMBOL() {
  return getToken(MySQLParser::USE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTablespaceContext::LOGFILE_SYMBOL() {
  return getToken(MySQLParser::LOGFILE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTablespaceContext::GROUP_SYMBOL() {
  return getToken(MySQLParser::GROUP_SYMBOL, 0);
}

MySQLParser::LogfileGroupRefContext* MySQLParser::CreateTablespaceContext::logfileGroupRef() {
  return getRuleContext<MySQLParser::LogfileGroupRefContext>(0);
}

MySQLParser::TablespaceOptionsContext* MySQLParser::CreateTablespaceContext::tablespaceOptions() {
  return getRuleContext<MySQLParser::TablespaceOptionsContext>(0);
}


size_t MySQLParser::CreateTablespaceContext::getRuleIndex() const {
  return MySQLParser::RuleCreateTablespace;
}

void MySQLParser::CreateTablespaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateTablespace(this);
}

void MySQLParser::CreateTablespaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateTablespace(this);
}


std::any MySQLParser::CreateTablespaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateTablespace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateTablespaceContext* MySQLParser::createTablespace() {
  CreateTablespaceContext *_localctx = _tracker.createInstance<CreateTablespaceContext>(_ctx, getState());
  enterRule(_localctx, 136, MySQLParser::RuleCreateTablespace);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2561);
    match(MySQLParser::TABLESPACE_SYMBOL);
    setState(2562);
    tablespaceName();
    setState(2563);
    tsDataFileName();
    setState(2568);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 155, _ctx)) {
    case 1: {
      setState(2564);
      match(MySQLParser::USE_SYMBOL);
      setState(2565);
      match(MySQLParser::LOGFILE_SYMBOL);
      setState(2566);
      match(MySQLParser::GROUP_SYMBOL);
      setState(2567);
      logfileGroupRef();
      break;
    }

    default:
      break;
    }
    setState(2571);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 156, _ctx)) {
    case 1: {
      setState(2570);
      tablespaceOptions();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateUndoTablespaceContext ------------------------------------------------------------------

MySQLParser::CreateUndoTablespaceContext::CreateUndoTablespaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateUndoTablespaceContext::UNDO_SYMBOL() {
  return getToken(MySQLParser::UNDO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateUndoTablespaceContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

MySQLParser::TablespaceNameContext* MySQLParser::CreateUndoTablespaceContext::tablespaceName() {
  return getRuleContext<MySQLParser::TablespaceNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateUndoTablespaceContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

MySQLParser::TsDataFileContext* MySQLParser::CreateUndoTablespaceContext::tsDataFile() {
  return getRuleContext<MySQLParser::TsDataFileContext>(0);
}

MySQLParser::UndoTableSpaceOptionsContext* MySQLParser::CreateUndoTablespaceContext::undoTableSpaceOptions() {
  return getRuleContext<MySQLParser::UndoTableSpaceOptionsContext>(0);
}


size_t MySQLParser::CreateUndoTablespaceContext::getRuleIndex() const {
  return MySQLParser::RuleCreateUndoTablespace;
}

void MySQLParser::CreateUndoTablespaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateUndoTablespace(this);
}

void MySQLParser::CreateUndoTablespaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateUndoTablespace(this);
}


std::any MySQLParser::CreateUndoTablespaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateUndoTablespace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateUndoTablespaceContext* MySQLParser::createUndoTablespace() {
  CreateUndoTablespaceContext *_localctx = _tracker.createInstance<CreateUndoTablespaceContext>(_ctx, getState());
  enterRule(_localctx, 138, MySQLParser::RuleCreateUndoTablespace);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2573);
    match(MySQLParser::UNDO_SYMBOL);
    setState(2574);
    match(MySQLParser::TABLESPACE_SYMBOL);
    setState(2575);
    tablespaceName();
    setState(2576);
    match(MySQLParser::ADD_SYMBOL);
    setState(2577);
    tsDataFile();
    setState(2579);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL) {
      setState(2578);
      undoTableSpaceOptions();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsDataFileNameContext ------------------------------------------------------------------

MySQLParser::TsDataFileNameContext::TsDataFileNameContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsDataFileNameContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

MySQLParser::TsDataFileContext* MySQLParser::TsDataFileNameContext::tsDataFile() {
  return getRuleContext<MySQLParser::TsDataFileContext>(0);
}


size_t MySQLParser::TsDataFileNameContext::getRuleIndex() const {
  return MySQLParser::RuleTsDataFileName;
}

void MySQLParser::TsDataFileNameContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsDataFileName(this);
}

void MySQLParser::TsDataFileNameContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsDataFileName(this);
}


std::any MySQLParser::TsDataFileNameContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsDataFileName(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsDataFileNameContext* MySQLParser::tsDataFileName() {
  TsDataFileNameContext *_localctx = _tracker.createInstance<TsDataFileNameContext>(_ctx, getState());
  enterRule(_localctx, 140, MySQLParser::RuleTsDataFileName);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2588);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 159, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2581);
      match(MySQLParser::ADD_SYMBOL);
      setState(2582);
      tsDataFile();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2583);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(2586);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 158, _ctx)) {
      case 1: {
        setState(2584);
        match(MySQLParser::ADD_SYMBOL);
        setState(2585);
        tsDataFile();
        break;
      }

      default:
        break;
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsDataFileContext ------------------------------------------------------------------

MySQLParser::TsDataFileContext::TsDataFileContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsDataFileContext::DATAFILE_SYMBOL() {
  return getToken(MySQLParser::DATAFILE_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::TsDataFileContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}


size_t MySQLParser::TsDataFileContext::getRuleIndex() const {
  return MySQLParser::RuleTsDataFile;
}

void MySQLParser::TsDataFileContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsDataFile(this);
}

void MySQLParser::TsDataFileContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsDataFile(this);
}


std::any MySQLParser::TsDataFileContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsDataFile(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsDataFileContext* MySQLParser::tsDataFile() {
  TsDataFileContext *_localctx = _tracker.createInstance<TsDataFileContext>(_ctx, getState());
  enterRule(_localctx, 142, MySQLParser::RuleTsDataFile);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2590);
    match(MySQLParser::DATAFILE_SYMBOL);
    setState(2591);
    textLiteral();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TablespaceOptionsContext ------------------------------------------------------------------

MySQLParser::TablespaceOptionsContext::TablespaceOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::TablespaceOptionContext *> MySQLParser::TablespaceOptionsContext::tablespaceOption() {
  return getRuleContexts<MySQLParser::TablespaceOptionContext>();
}

MySQLParser::TablespaceOptionContext* MySQLParser::TablespaceOptionsContext::tablespaceOption(size_t i) {
  return getRuleContext<MySQLParser::TablespaceOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::TablespaceOptionsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::TablespaceOptionsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::TablespaceOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleTablespaceOptions;
}

void MySQLParser::TablespaceOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTablespaceOptions(this);
}

void MySQLParser::TablespaceOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTablespaceOptions(this);
}


std::any MySQLParser::TablespaceOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTablespaceOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TablespaceOptionsContext* MySQLParser::tablespaceOptions() {
  TablespaceOptionsContext *_localctx = _tracker.createInstance<TablespaceOptionsContext>(_ctx, getState());
  enterRule(_localctx, 144, MySQLParser::RuleTablespaceOptions);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2593);
    tablespaceOption();
    setState(2600);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 161, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2595);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 160, _ctx)) {
        case 1: {
          setState(2594);
          match(MySQLParser::COMMA_SYMBOL);
          break;
        }

        default:
          break;
        }
        setState(2597);
        tablespaceOption(); 
      }
      setState(2602);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 161, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TablespaceOptionContext ------------------------------------------------------------------

MySQLParser::TablespaceOptionContext::TablespaceOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TsOptionInitialSizeContext* MySQLParser::TablespaceOptionContext::tsOptionInitialSize() {
  return getRuleContext<MySQLParser::TsOptionInitialSizeContext>(0);
}

MySQLParser::TsOptionAutoextendSizeContext* MySQLParser::TablespaceOptionContext::tsOptionAutoextendSize() {
  return getRuleContext<MySQLParser::TsOptionAutoextendSizeContext>(0);
}

MySQLParser::TsOptionMaxSizeContext* MySQLParser::TablespaceOptionContext::tsOptionMaxSize() {
  return getRuleContext<MySQLParser::TsOptionMaxSizeContext>(0);
}

MySQLParser::TsOptionExtentSizeContext* MySQLParser::TablespaceOptionContext::tsOptionExtentSize() {
  return getRuleContext<MySQLParser::TsOptionExtentSizeContext>(0);
}

MySQLParser::TsOptionNodegroupContext* MySQLParser::TablespaceOptionContext::tsOptionNodegroup() {
  return getRuleContext<MySQLParser::TsOptionNodegroupContext>(0);
}

MySQLParser::TsOptionEngineContext* MySQLParser::TablespaceOptionContext::tsOptionEngine() {
  return getRuleContext<MySQLParser::TsOptionEngineContext>(0);
}

MySQLParser::TsOptionWaitContext* MySQLParser::TablespaceOptionContext::tsOptionWait() {
  return getRuleContext<MySQLParser::TsOptionWaitContext>(0);
}

MySQLParser::TsOptionCommentContext* MySQLParser::TablespaceOptionContext::tsOptionComment() {
  return getRuleContext<MySQLParser::TsOptionCommentContext>(0);
}

MySQLParser::TsOptionFileblockSizeContext* MySQLParser::TablespaceOptionContext::tsOptionFileblockSize() {
  return getRuleContext<MySQLParser::TsOptionFileblockSizeContext>(0);
}

MySQLParser::TsOptionEncryptionContext* MySQLParser::TablespaceOptionContext::tsOptionEncryption() {
  return getRuleContext<MySQLParser::TsOptionEncryptionContext>(0);
}


size_t MySQLParser::TablespaceOptionContext::getRuleIndex() const {
  return MySQLParser::RuleTablespaceOption;
}

void MySQLParser::TablespaceOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTablespaceOption(this);
}

void MySQLParser::TablespaceOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTablespaceOption(this);
}


std::any MySQLParser::TablespaceOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTablespaceOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TablespaceOptionContext* MySQLParser::tablespaceOption() {
  TablespaceOptionContext *_localctx = _tracker.createInstance<TablespaceOptionContext>(_ctx, getState());
  enterRule(_localctx, 146, MySQLParser::RuleTablespaceOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2615);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 162, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2603);
      tsOptionInitialSize();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2604);
      tsOptionAutoextendSize();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(2605);
      tsOptionMaxSize();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(2606);
      tsOptionExtentSize();
      break;
    }

    case 5: {
      enterOuterAlt(_localctx, 5);
      setState(2607);
      tsOptionNodegroup();
      break;
    }

    case 6: {
      enterOuterAlt(_localctx, 6);
      setState(2608);
      tsOptionEngine();
      break;
    }

    case 7: {
      enterOuterAlt(_localctx, 7);
      setState(2609);
      tsOptionWait();
      break;
    }

    case 8: {
      enterOuterAlt(_localctx, 8);
      setState(2610);
      tsOptionComment();
      break;
    }

    case 9: {
      enterOuterAlt(_localctx, 9);
      setState(2611);

      if (!(serverVersion >= 50707)) throw FailedPredicateException(this, "serverVersion >= 50707");
      setState(2612);
      tsOptionFileblockSize();
      break;
    }

    case 10: {
      enterOuterAlt(_localctx, 10);
      setState(2613);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(2614);
      tsOptionEncryption();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionInitialSizeContext ------------------------------------------------------------------

MySQLParser::TsOptionInitialSizeContext::TsOptionInitialSizeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionInitialSizeContext::INITIAL_SIZE_SYMBOL() {
  return getToken(MySQLParser::INITIAL_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::TsOptionInitialSizeContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionInitialSizeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionInitialSizeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionInitialSize;
}

void MySQLParser::TsOptionInitialSizeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionInitialSize(this);
}

void MySQLParser::TsOptionInitialSizeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionInitialSize(this);
}


std::any MySQLParser::TsOptionInitialSizeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionInitialSize(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionInitialSizeContext* MySQLParser::tsOptionInitialSize() {
  TsOptionInitialSizeContext *_localctx = _tracker.createInstance<TsOptionInitialSizeContext>(_ctx, getState());
  enterRule(_localctx, 148, MySQLParser::RuleTsOptionInitialSize);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2617);
    match(MySQLParser::INITIAL_SIZE_SYMBOL);
    setState(2619);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 163, _ctx)) {
    case 1: {
      setState(2618);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2621);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionUndoRedoBufferSizeContext ------------------------------------------------------------------

MySQLParser::TsOptionUndoRedoBufferSizeContext::TsOptionUndoRedoBufferSizeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::SizeNumberContext* MySQLParser::TsOptionUndoRedoBufferSizeContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionUndoRedoBufferSizeContext::UNDO_BUFFER_SIZE_SYMBOL() {
  return getToken(MySQLParser::UNDO_BUFFER_SIZE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::TsOptionUndoRedoBufferSizeContext::REDO_BUFFER_SIZE_SYMBOL() {
  return getToken(MySQLParser::REDO_BUFFER_SIZE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::TsOptionUndoRedoBufferSizeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionUndoRedoBufferSizeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionUndoRedoBufferSize;
}

void MySQLParser::TsOptionUndoRedoBufferSizeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionUndoRedoBufferSize(this);
}

void MySQLParser::TsOptionUndoRedoBufferSizeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionUndoRedoBufferSize(this);
}


std::any MySQLParser::TsOptionUndoRedoBufferSizeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionUndoRedoBufferSize(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionUndoRedoBufferSizeContext* MySQLParser::tsOptionUndoRedoBufferSize() {
  TsOptionUndoRedoBufferSizeContext *_localctx = _tracker.createInstance<TsOptionUndoRedoBufferSizeContext>(_ctx, getState());
  enterRule(_localctx, 150, MySQLParser::RuleTsOptionUndoRedoBufferSize);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2623);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::REDO_BUFFER_SIZE_SYMBOL || _la == MySQLParser::UNDO_BUFFER_SIZE_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2625);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 164, _ctx)) {
    case 1: {
      setState(2624);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2627);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionAutoextendSizeContext ------------------------------------------------------------------

MySQLParser::TsOptionAutoextendSizeContext::TsOptionAutoextendSizeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionAutoextendSizeContext::AUTOEXTEND_SIZE_SYMBOL() {
  return getToken(MySQLParser::AUTOEXTEND_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::TsOptionAutoextendSizeContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionAutoextendSizeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionAutoextendSizeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionAutoextendSize;
}

void MySQLParser::TsOptionAutoextendSizeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionAutoextendSize(this);
}

void MySQLParser::TsOptionAutoextendSizeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionAutoextendSize(this);
}


std::any MySQLParser::TsOptionAutoextendSizeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionAutoextendSize(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionAutoextendSizeContext* MySQLParser::tsOptionAutoextendSize() {
  TsOptionAutoextendSizeContext *_localctx = _tracker.createInstance<TsOptionAutoextendSizeContext>(_ctx, getState());
  enterRule(_localctx, 152, MySQLParser::RuleTsOptionAutoextendSize);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2629);
    match(MySQLParser::AUTOEXTEND_SIZE_SYMBOL);
    setState(2631);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 165, _ctx)) {
    case 1: {
      setState(2630);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2633);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionMaxSizeContext ------------------------------------------------------------------

MySQLParser::TsOptionMaxSizeContext::TsOptionMaxSizeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionMaxSizeContext::MAX_SIZE_SYMBOL() {
  return getToken(MySQLParser::MAX_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::TsOptionMaxSizeContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionMaxSizeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionMaxSizeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionMaxSize;
}

void MySQLParser::TsOptionMaxSizeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionMaxSize(this);
}

void MySQLParser::TsOptionMaxSizeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionMaxSize(this);
}


std::any MySQLParser::TsOptionMaxSizeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionMaxSize(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionMaxSizeContext* MySQLParser::tsOptionMaxSize() {
  TsOptionMaxSizeContext *_localctx = _tracker.createInstance<TsOptionMaxSizeContext>(_ctx, getState());
  enterRule(_localctx, 154, MySQLParser::RuleTsOptionMaxSize);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2635);
    match(MySQLParser::MAX_SIZE_SYMBOL);
    setState(2637);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 166, _ctx)) {
    case 1: {
      setState(2636);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2639);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionExtentSizeContext ------------------------------------------------------------------

MySQLParser::TsOptionExtentSizeContext::TsOptionExtentSizeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionExtentSizeContext::EXTENT_SIZE_SYMBOL() {
  return getToken(MySQLParser::EXTENT_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::TsOptionExtentSizeContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionExtentSizeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionExtentSizeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionExtentSize;
}

void MySQLParser::TsOptionExtentSizeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionExtentSize(this);
}

void MySQLParser::TsOptionExtentSizeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionExtentSize(this);
}


std::any MySQLParser::TsOptionExtentSizeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionExtentSize(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionExtentSizeContext* MySQLParser::tsOptionExtentSize() {
  TsOptionExtentSizeContext *_localctx = _tracker.createInstance<TsOptionExtentSizeContext>(_ctx, getState());
  enterRule(_localctx, 156, MySQLParser::RuleTsOptionExtentSize);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2641);
    match(MySQLParser::EXTENT_SIZE_SYMBOL);
    setState(2643);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 167, _ctx)) {
    case 1: {
      setState(2642);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2645);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionNodegroupContext ------------------------------------------------------------------

MySQLParser::TsOptionNodegroupContext::TsOptionNodegroupContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionNodegroupContext::NODEGROUP_SYMBOL() {
  return getToken(MySQLParser::NODEGROUP_SYMBOL, 0);
}

MySQLParser::Real_ulong_numberContext* MySQLParser::TsOptionNodegroupContext::real_ulong_number() {
  return getRuleContext<MySQLParser::Real_ulong_numberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionNodegroupContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionNodegroupContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionNodegroup;
}

void MySQLParser::TsOptionNodegroupContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionNodegroup(this);
}

void MySQLParser::TsOptionNodegroupContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionNodegroup(this);
}


std::any MySQLParser::TsOptionNodegroupContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionNodegroup(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionNodegroupContext* MySQLParser::tsOptionNodegroup() {
  TsOptionNodegroupContext *_localctx = _tracker.createInstance<TsOptionNodegroupContext>(_ctx, getState());
  enterRule(_localctx, 158, MySQLParser::RuleTsOptionNodegroup);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2647);
    match(MySQLParser::NODEGROUP_SYMBOL);
    setState(2649);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::EQUAL_OPERATOR) {
      setState(2648);
      match(MySQLParser::EQUAL_OPERATOR);
    }
    setState(2651);
    real_ulong_number();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionEngineContext ------------------------------------------------------------------

MySQLParser::TsOptionEngineContext::TsOptionEngineContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionEngineContext::ENGINE_SYMBOL() {
  return getToken(MySQLParser::ENGINE_SYMBOL, 0);
}

MySQLParser::EngineRefContext* MySQLParser::TsOptionEngineContext::engineRef() {
  return getRuleContext<MySQLParser::EngineRefContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionEngineContext::STORAGE_SYMBOL() {
  return getToken(MySQLParser::STORAGE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::TsOptionEngineContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionEngineContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionEngine;
}

void MySQLParser::TsOptionEngineContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionEngine(this);
}

void MySQLParser::TsOptionEngineContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionEngine(this);
}


std::any MySQLParser::TsOptionEngineContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionEngine(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionEngineContext* MySQLParser::tsOptionEngine() {
  TsOptionEngineContext *_localctx = _tracker.createInstance<TsOptionEngineContext>(_ctx, getState());
  enterRule(_localctx, 160, MySQLParser::RuleTsOptionEngine);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2654);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::STORAGE_SYMBOL) {
      setState(2653);
      match(MySQLParser::STORAGE_SYMBOL);
    }
    setState(2656);
    match(MySQLParser::ENGINE_SYMBOL);
    setState(2658);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 170, _ctx)) {
    case 1: {
      setState(2657);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2660);
    engineRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionWaitContext ------------------------------------------------------------------

MySQLParser::TsOptionWaitContext::TsOptionWaitContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionWaitContext::WAIT_SYMBOL() {
  return getToken(MySQLParser::WAIT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::TsOptionWaitContext::NO_WAIT_SYMBOL() {
  return getToken(MySQLParser::NO_WAIT_SYMBOL, 0);
}


size_t MySQLParser::TsOptionWaitContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionWait;
}

void MySQLParser::TsOptionWaitContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionWait(this);
}

void MySQLParser::TsOptionWaitContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionWait(this);
}


std::any MySQLParser::TsOptionWaitContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionWait(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionWaitContext* MySQLParser::tsOptionWait() {
  TsOptionWaitContext *_localctx = _tracker.createInstance<TsOptionWaitContext>(_ctx, getState());
  enterRule(_localctx, 162, MySQLParser::RuleTsOptionWait);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2662);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::WAIT_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionCommentContext ------------------------------------------------------------------

MySQLParser::TsOptionCommentContext::TsOptionCommentContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionCommentContext::COMMENT_SYMBOL() {
  return getToken(MySQLParser::COMMENT_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::TsOptionCommentContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionCommentContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionCommentContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionComment;
}

void MySQLParser::TsOptionCommentContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionComment(this);
}

void MySQLParser::TsOptionCommentContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionComment(this);
}


std::any MySQLParser::TsOptionCommentContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionComment(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionCommentContext* MySQLParser::tsOptionComment() {
  TsOptionCommentContext *_localctx = _tracker.createInstance<TsOptionCommentContext>(_ctx, getState());
  enterRule(_localctx, 164, MySQLParser::RuleTsOptionComment);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2664);
    match(MySQLParser::COMMENT_SYMBOL);
    setState(2666);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 171, _ctx)) {
    case 1: {
      setState(2665);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2668);
    textLiteral();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionFileblockSizeContext ------------------------------------------------------------------

MySQLParser::TsOptionFileblockSizeContext::TsOptionFileblockSizeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionFileblockSizeContext::FILE_BLOCK_SIZE_SYMBOL() {
  return getToken(MySQLParser::FILE_BLOCK_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::TsOptionFileblockSizeContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionFileblockSizeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionFileblockSizeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionFileblockSize;
}

void MySQLParser::TsOptionFileblockSizeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionFileblockSize(this);
}

void MySQLParser::TsOptionFileblockSizeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionFileblockSize(this);
}


std::any MySQLParser::TsOptionFileblockSizeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionFileblockSize(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionFileblockSizeContext* MySQLParser::tsOptionFileblockSize() {
  TsOptionFileblockSizeContext *_localctx = _tracker.createInstance<TsOptionFileblockSizeContext>(_ctx, getState());
  enterRule(_localctx, 166, MySQLParser::RuleTsOptionFileblockSize);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2670);
    match(MySQLParser::FILE_BLOCK_SIZE_SYMBOL);
    setState(2672);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 172, _ctx)) {
    case 1: {
      setState(2671);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2674);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionEncryptionContext ------------------------------------------------------------------

MySQLParser::TsOptionEncryptionContext::TsOptionEncryptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionEncryptionContext::ENCRYPTION_SYMBOL() {
  return getToken(MySQLParser::ENCRYPTION_SYMBOL, 0);
}

MySQLParser::TextStringLiteralContext* MySQLParser::TsOptionEncryptionContext::textStringLiteral() {
  return getRuleContext<MySQLParser::TextStringLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionEncryptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionEncryptionContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionEncryption;
}

void MySQLParser::TsOptionEncryptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionEncryption(this);
}

void MySQLParser::TsOptionEncryptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionEncryption(this);
}


std::any MySQLParser::TsOptionEncryptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionEncryption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionEncryptionContext* MySQLParser::tsOptionEncryption() {
  TsOptionEncryptionContext *_localctx = _tracker.createInstance<TsOptionEncryptionContext>(_ctx, getState());
  enterRule(_localctx, 168, MySQLParser::RuleTsOptionEncryption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2676);
    match(MySQLParser::ENCRYPTION_SYMBOL);
    setState(2678);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 173, _ctx)) {
    case 1: {
      setState(2677);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2680);
    textStringLiteral();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionEngineAttributeContext ------------------------------------------------------------------

MySQLParser::TsOptionEngineAttributeContext::TsOptionEngineAttributeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionEngineAttributeContext::ENGINE_SYMBOL() {
  return getToken(MySQLParser::ENGINE_SYMBOL, 0);
}

MySQLParser::JsonAttributeContext* MySQLParser::TsOptionEngineAttributeContext::jsonAttribute() {
  return getRuleContext<MySQLParser::JsonAttributeContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionEngineAttributeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionEngineAttributeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionEngineAttribute;
}

void MySQLParser::TsOptionEngineAttributeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionEngineAttribute(this);
}

void MySQLParser::TsOptionEngineAttributeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionEngineAttribute(this);
}


std::any MySQLParser::TsOptionEngineAttributeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionEngineAttribute(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionEngineAttributeContext* MySQLParser::tsOptionEngineAttribute() {
  TsOptionEngineAttributeContext *_localctx = _tracker.createInstance<TsOptionEngineAttributeContext>(_ctx, getState());
  enterRule(_localctx, 170, MySQLParser::RuleTsOptionEngineAttribute);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2682);
    match(MySQLParser::ENGINE_SYMBOL);
    setState(2684);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 174, _ctx)) {
    case 1: {
      setState(2683);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2686);
    jsonAttribute();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateViewContext ------------------------------------------------------------------

MySQLParser::CreateViewContext::CreateViewContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateViewContext::VIEW_SYMBOL() {
  return getToken(MySQLParser::VIEW_SYMBOL, 0);
}

MySQLParser::ViewNameContext* MySQLParser::CreateViewContext::viewName() {
  return getRuleContext<MySQLParser::ViewNameContext>(0);
}

MySQLParser::ViewTailContext* MySQLParser::CreateViewContext::viewTail() {
  return getRuleContext<MySQLParser::ViewTailContext>(0);
}

MySQLParser::ViewReplaceOrAlgorithmContext* MySQLParser::CreateViewContext::viewReplaceOrAlgorithm() {
  return getRuleContext<MySQLParser::ViewReplaceOrAlgorithmContext>(0);
}

MySQLParser::DefinerClauseContext* MySQLParser::CreateViewContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

MySQLParser::ViewSuidContext* MySQLParser::CreateViewContext::viewSuid() {
  return getRuleContext<MySQLParser::ViewSuidContext>(0);
}


size_t MySQLParser::CreateViewContext::getRuleIndex() const {
  return MySQLParser::RuleCreateView;
}

void MySQLParser::CreateViewContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateView(this);
}

void MySQLParser::CreateViewContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateView(this);
}


std::any MySQLParser::CreateViewContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateView(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateViewContext* MySQLParser::createView() {
  CreateViewContext *_localctx = _tracker.createInstance<CreateViewContext>(_ctx, getState());
  enterRule(_localctx, 172, MySQLParser::RuleCreateView);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2689);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ALGORITHM_SYMBOL || _la == MySQLParser::OR_SYMBOL) {
      setState(2688);
      viewReplaceOrAlgorithm();
    }
    setState(2692);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(2691);
      definerClause();
    }
    setState(2695);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::SQL_SYMBOL) {
      setState(2694);
      viewSuid();
    }
    setState(2697);
    match(MySQLParser::VIEW_SYMBOL);
    setState(2698);
    viewName();
    setState(2699);
    viewTail();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ViewReplaceOrAlgorithmContext ------------------------------------------------------------------

MySQLParser::ViewReplaceOrAlgorithmContext::ViewReplaceOrAlgorithmContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ViewReplaceOrAlgorithmContext::OR_SYMBOL() {
  return getToken(MySQLParser::OR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewReplaceOrAlgorithmContext::REPLACE_SYMBOL() {
  return getToken(MySQLParser::REPLACE_SYMBOL, 0);
}

MySQLParser::ViewAlgorithmContext* MySQLParser::ViewReplaceOrAlgorithmContext::viewAlgorithm() {
  return getRuleContext<MySQLParser::ViewAlgorithmContext>(0);
}


size_t MySQLParser::ViewReplaceOrAlgorithmContext::getRuleIndex() const {
  return MySQLParser::RuleViewReplaceOrAlgorithm;
}

void MySQLParser::ViewReplaceOrAlgorithmContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterViewReplaceOrAlgorithm(this);
}

void MySQLParser::ViewReplaceOrAlgorithmContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitViewReplaceOrAlgorithm(this);
}


std::any MySQLParser::ViewReplaceOrAlgorithmContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitViewReplaceOrAlgorithm(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ViewReplaceOrAlgorithmContext* MySQLParser::viewReplaceOrAlgorithm() {
  ViewReplaceOrAlgorithmContext *_localctx = _tracker.createInstance<ViewReplaceOrAlgorithmContext>(_ctx, getState());
  enterRule(_localctx, 174, MySQLParser::RuleViewReplaceOrAlgorithm);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2707);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::OR_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2701);
        match(MySQLParser::OR_SYMBOL);
        setState(2702);
        match(MySQLParser::REPLACE_SYMBOL);
        setState(2704);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::ALGORITHM_SYMBOL) {
          setState(2703);
          viewAlgorithm();
        }
        break;
      }

      case MySQLParser::ALGORITHM_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2706);
        viewAlgorithm();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ViewAlgorithmContext ------------------------------------------------------------------

MySQLParser::ViewAlgorithmContext::ViewAlgorithmContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ViewAlgorithmContext::ALGORITHM_SYMBOL() {
  return getToken(MySQLParser::ALGORITHM_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewAlgorithmContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}

tree::TerminalNode* MySQLParser::ViewAlgorithmContext::UNDEFINED_SYMBOL() {
  return getToken(MySQLParser::UNDEFINED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewAlgorithmContext::MERGE_SYMBOL() {
  return getToken(MySQLParser::MERGE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewAlgorithmContext::TEMPTABLE_SYMBOL() {
  return getToken(MySQLParser::TEMPTABLE_SYMBOL, 0);
}


size_t MySQLParser::ViewAlgorithmContext::getRuleIndex() const {
  return MySQLParser::RuleViewAlgorithm;
}

void MySQLParser::ViewAlgorithmContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterViewAlgorithm(this);
}

void MySQLParser::ViewAlgorithmContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitViewAlgorithm(this);
}


std::any MySQLParser::ViewAlgorithmContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitViewAlgorithm(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ViewAlgorithmContext* MySQLParser::viewAlgorithm() {
  ViewAlgorithmContext *_localctx = _tracker.createInstance<ViewAlgorithmContext>(_ctx, getState());
  enterRule(_localctx, 176, MySQLParser::RuleViewAlgorithm);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2709);
    match(MySQLParser::ALGORITHM_SYMBOL);
    setState(2710);
    match(MySQLParser::EQUAL_OPERATOR);
    setState(2711);
    antlrcpp::downCast<ViewAlgorithmContext *>(_localctx)->algorithm = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::MERGE_SYMBOL || _la == MySQLParser::TEMPTABLE_SYMBOL

    || _la == MySQLParser::UNDEFINED_SYMBOL)) {
      antlrcpp::downCast<ViewAlgorithmContext *>(_localctx)->algorithm = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ViewSuidContext ------------------------------------------------------------------

MySQLParser::ViewSuidContext::ViewSuidContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ViewSuidContext::SQL_SYMBOL() {
  return getToken(MySQLParser::SQL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewSuidContext::SECURITY_SYMBOL() {
  return getToken(MySQLParser::SECURITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewSuidContext::DEFINER_SYMBOL() {
  return getToken(MySQLParser::DEFINER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewSuidContext::INVOKER_SYMBOL() {
  return getToken(MySQLParser::INVOKER_SYMBOL, 0);
}


size_t MySQLParser::ViewSuidContext::getRuleIndex() const {
  return MySQLParser::RuleViewSuid;
}

void MySQLParser::ViewSuidContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterViewSuid(this);
}

void MySQLParser::ViewSuidContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitViewSuid(this);
}


std::any MySQLParser::ViewSuidContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitViewSuid(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ViewSuidContext* MySQLParser::viewSuid() {
  ViewSuidContext *_localctx = _tracker.createInstance<ViewSuidContext>(_ctx, getState());
  enterRule(_localctx, 178, MySQLParser::RuleViewSuid);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2713);
    match(MySQLParser::SQL_SYMBOL);
    setState(2714);
    match(MySQLParser::SECURITY_SYMBOL);
    setState(2715);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::DEFINER_SYMBOL || _la == MySQLParser::INVOKER_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateTriggerContext ------------------------------------------------------------------

MySQLParser::CreateTriggerContext::CreateTriggerContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::TRIGGER_SYMBOL() {
  return getToken(MySQLParser::TRIGGER_SYMBOL, 0);
}

MySQLParser::TriggerNameContext* MySQLParser::CreateTriggerContext::triggerName() {
  return getRuleContext<MySQLParser::TriggerNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::ON_SYMBOL() {
  return getToken(MySQLParser::ON_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::CreateTriggerContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::FOR_SYMBOL() {
  return getToken(MySQLParser::FOR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::EACH_SYMBOL() {
  return getToken(MySQLParser::EACH_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::ROW_SYMBOL() {
  return getToken(MySQLParser::ROW_SYMBOL, 0);
}

MySQLParser::CompoundStatementContext* MySQLParser::CreateTriggerContext::compoundStatement() {
  return getRuleContext<MySQLParser::CompoundStatementContext>(0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::BEFORE_SYMBOL() {
  return getToken(MySQLParser::BEFORE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::AFTER_SYMBOL() {
  return getToken(MySQLParser::AFTER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::INSERT_SYMBOL() {
  return getToken(MySQLParser::INSERT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::UPDATE_SYMBOL() {
  return getToken(MySQLParser::UPDATE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::DELETE_SYMBOL() {
  return getToken(MySQLParser::DELETE_SYMBOL, 0);
}

MySQLParser::DefinerClauseContext* MySQLParser::CreateTriggerContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateTriggerContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}

MySQLParser::TriggerFollowsPrecedesClauseContext* MySQLParser::CreateTriggerContext::triggerFollowsPrecedesClause() {
  return getRuleContext<MySQLParser::TriggerFollowsPrecedesClauseContext>(0);
}


size_t MySQLParser::CreateTriggerContext::getRuleIndex() const {
  return MySQLParser::RuleCreateTrigger;
}

void MySQLParser::CreateTriggerContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateTrigger(this);
}

void MySQLParser::CreateTriggerContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateTrigger(this);
}


std::any MySQLParser::CreateTriggerContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateTrigger(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateTriggerContext* MySQLParser::createTrigger() {
  CreateTriggerContext *_localctx = _tracker.createInstance<CreateTriggerContext>(_ctx, getState());
  enterRule(_localctx, 180, MySQLParser::RuleCreateTrigger);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2718);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(2717);
      definerClause();
    }
    setState(2720);
    match(MySQLParser::TRIGGER_SYMBOL);
    setState(2723);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 181, _ctx)) {
    case 1: {
      setState(2721);

      if (!(serverVersion >= 80029)) throw FailedPredicateException(this, "serverVersion >= 80029");
      setState(2722);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2725);
    triggerName();
    setState(2726);
    antlrcpp::downCast<CreateTriggerContext *>(_localctx)->timing = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::AFTER_SYMBOL

    || _la == MySQLParser::BEFORE_SYMBOL)) {
      antlrcpp::downCast<CreateTriggerContext *>(_localctx)->timing = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2727);
    antlrcpp::downCast<CreateTriggerContext *>(_localctx)->event = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::DELETE_SYMBOL || _la == MySQLParser::INSERT_SYMBOL || _la == MySQLParser::UPDATE_SYMBOL)) {
      antlrcpp::downCast<CreateTriggerContext *>(_localctx)->event = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2728);
    match(MySQLParser::ON_SYMBOL);
    setState(2729);
    tableRef();
    setState(2730);
    match(MySQLParser::FOR_SYMBOL);
    setState(2731);
    match(MySQLParser::EACH_SYMBOL);
    setState(2732);
    match(MySQLParser::ROW_SYMBOL);
    setState(2734);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 182, _ctx)) {
    case 1: {
      setState(2733);
      triggerFollowsPrecedesClause();
      break;
    }

    default:
      break;
    }
    setState(2736);
    compoundStatement();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TriggerFollowsPrecedesClauseContext ------------------------------------------------------------------

MySQLParser::TriggerFollowsPrecedesClauseContext::TriggerFollowsPrecedesClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TextOrIdentifierContext* MySQLParser::TriggerFollowsPrecedesClauseContext::textOrIdentifier() {
  return getRuleContext<MySQLParser::TextOrIdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::TriggerFollowsPrecedesClauseContext::FOLLOWS_SYMBOL() {
  return getToken(MySQLParser::FOLLOWS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::TriggerFollowsPrecedesClauseContext::PRECEDES_SYMBOL() {
  return getToken(MySQLParser::PRECEDES_SYMBOL, 0);
}


size_t MySQLParser::TriggerFollowsPrecedesClauseContext::getRuleIndex() const {
  return MySQLParser::RuleTriggerFollowsPrecedesClause;
}

void MySQLParser::TriggerFollowsPrecedesClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTriggerFollowsPrecedesClause(this);
}

void MySQLParser::TriggerFollowsPrecedesClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTriggerFollowsPrecedesClause(this);
}


std::any MySQLParser::TriggerFollowsPrecedesClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTriggerFollowsPrecedesClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TriggerFollowsPrecedesClauseContext* MySQLParser::triggerFollowsPrecedesClause() {
  TriggerFollowsPrecedesClauseContext *_localctx = _tracker.createInstance<TriggerFollowsPrecedesClauseContext>(_ctx, getState());
  enterRule(_localctx, 182, MySQLParser::RuleTriggerFollowsPrecedesClause);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2738);
    antlrcpp::downCast<TriggerFollowsPrecedesClauseContext *>(_localctx)->ordering = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::FOLLOWS_SYMBOL || _la == MySQLParser::PRECEDES_SYMBOL)) {
      antlrcpp::downCast<TriggerFollowsPrecedesClauseContext *>(_localctx)->ordering = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2739);
    textOrIdentifier();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateEventContext ------------------------------------------------------------------

MySQLParser::CreateEventContext::CreateEventContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateEventContext::EVENT_SYMBOL() {
  return getToken(MySQLParser::EVENT_SYMBOL, 0);
}

MySQLParser::EventNameContext* MySQLParser::CreateEventContext::eventName() {
  return getRuleContext<MySQLParser::EventNameContext>(0);
}

std::vector<tree::TerminalNode *> MySQLParser::CreateEventContext::ON_SYMBOL() {
  return getTokens(MySQLParser::ON_SYMBOL);
}

tree::TerminalNode* MySQLParser::CreateEventContext::ON_SYMBOL(size_t i) {
  return getToken(MySQLParser::ON_SYMBOL, i);
}

tree::TerminalNode* MySQLParser::CreateEventContext::SCHEDULE_SYMBOL() {
  return getToken(MySQLParser::SCHEDULE_SYMBOL, 0);
}

MySQLParser::ScheduleContext* MySQLParser::CreateEventContext::schedule() {
  return getRuleContext<MySQLParser::ScheduleContext>(0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::DO_SYMBOL() {
  return getToken(MySQLParser::DO_SYMBOL, 0);
}

MySQLParser::CompoundStatementContext* MySQLParser::CreateEventContext::compoundStatement() {
  return getRuleContext<MySQLParser::CompoundStatementContext>(0);
}

MySQLParser::DefinerClauseContext* MySQLParser::CreateEventContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateEventContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::COMPLETION_SYMBOL() {
  return getToken(MySQLParser::COMPLETION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::PRESERVE_SYMBOL() {
  return getToken(MySQLParser::PRESERVE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::ENABLE_SYMBOL() {
  return getToken(MySQLParser::ENABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::DISABLE_SYMBOL() {
  return getToken(MySQLParser::DISABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::COMMENT_SYMBOL() {
  return getToken(MySQLParser::COMMENT_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::CreateEventContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::NOT_SYMBOL() {
  return getToken(MySQLParser::NOT_SYMBOL, 0);
}

MySQLParser::ReplicaContext* MySQLParser::CreateEventContext::replica() {
  return getRuleContext<MySQLParser::ReplicaContext>(0);
}


size_t MySQLParser::CreateEventContext::getRuleIndex() const {
  return MySQLParser::RuleCreateEvent;
}

void MySQLParser::CreateEventContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateEvent(this);
}

void MySQLParser::CreateEventContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateEvent(this);
}


std::any MySQLParser::CreateEventContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateEvent(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateEventContext* MySQLParser::createEvent() {
  CreateEventContext *_localctx = _tracker.createInstance<CreateEventContext>(_ctx, getState());
  enterRule(_localctx, 184, MySQLParser::RuleCreateEvent);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2742);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(2741);
      definerClause();
    }
    setState(2744);
    match(MySQLParser::EVENT_SYMBOL);
    setState(2746);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 184, _ctx)) {
    case 1: {
      setState(2745);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2748);
    eventName();
    setState(2749);
    match(MySQLParser::ON_SYMBOL);
    setState(2750);
    match(MySQLParser::SCHEDULE_SYMBOL);
    setState(2751);
    schedule();
    setState(2758);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ON_SYMBOL) {
      setState(2752);
      match(MySQLParser::ON_SYMBOL);
      setState(2753);
      match(MySQLParser::COMPLETION_SYMBOL);
      setState(2755);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::NOT_SYMBOL) {
        setState(2754);
        match(MySQLParser::NOT_SYMBOL);
      }
      setState(2757);
      match(MySQLParser::PRESERVE_SYMBOL);
    }
    setState(2766);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::ENABLE_SYMBOL: {
        setState(2760);
        match(MySQLParser::ENABLE_SYMBOL);
        break;
      }

      case MySQLParser::DISABLE_SYMBOL: {
        setState(2761);
        match(MySQLParser::DISABLE_SYMBOL);
        setState(2764);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::ON_SYMBOL) {
          setState(2762);
          match(MySQLParser::ON_SYMBOL);
          setState(2763);
          replica();
        }
        break;
      }

      case MySQLParser::COMMENT_SYMBOL:
      case MySQLParser::DO_SYMBOL: {
        break;
      }

    default:
      break;
    }
    setState(2770);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::COMMENT_SYMBOL) {
      setState(2768);
      match(MySQLParser::COMMENT_SYMBOL);
      setState(2769);
      textLiteral();
    }
    setState(2772);
    match(MySQLParser::DO_SYMBOL);
    setState(2773);
    compoundStatement();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateRoleContext ------------------------------------------------------------------

MySQLParser::CreateRoleContext::CreateRoleContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateRoleContext::ROLE_SYMBOL() {
  return getToken(MySQLParser::ROLE_SYMBOL, 0);
}

MySQLParser::RoleListContext* MySQLParser::CreateRoleContext::roleList() {
  return getRuleContext<MySQLParser::RoleListContext>(0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateRoleContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}


size_t MySQLParser::CreateRoleContext::getRuleIndex() const {
  return MySQLParser::RuleCreateRole;
}

void MySQLParser::CreateRoleContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateRole(this);
}

void MySQLParser::CreateRoleContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateRole(this);
}


std::any MySQLParser::CreateRoleContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateRole(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateRoleContext* MySQLParser::createRole() {
  CreateRoleContext *_localctx = _tracker.createInstance<CreateRoleContext>(_ctx, getState());
  enterRule(_localctx, 186, MySQLParser::RuleCreateRole);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2775);
    match(MySQLParser::ROLE_SYMBOL);
    setState(2777);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 190, _ctx)) {
    case 1: {
      setState(2776);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2779);
    roleList();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateSpatialReferenceContext ------------------------------------------------------------------

MySQLParser::CreateSpatialReferenceContext::CreateSpatialReferenceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateSpatialReferenceContext::OR_SYMBOL() {
  return getToken(MySQLParser::OR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateSpatialReferenceContext::REPLACE_SYMBOL() {
  return getToken(MySQLParser::REPLACE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateSpatialReferenceContext::SPATIAL_SYMBOL() {
  return getToken(MySQLParser::SPATIAL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateSpatialReferenceContext::REFERENCE_SYMBOL() {
  return getToken(MySQLParser::REFERENCE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateSpatialReferenceContext::SYSTEM_SYMBOL() {
  return getToken(MySQLParser::SYSTEM_SYMBOL, 0);
}

MySQLParser::Real_ulonglong_numberContext* MySQLParser::CreateSpatialReferenceContext::real_ulonglong_number() {
  return getRuleContext<MySQLParser::Real_ulonglong_numberContext>(0);
}

std::vector<MySQLParser::SrsAttributeContext *> MySQLParser::CreateSpatialReferenceContext::srsAttribute() {
  return getRuleContexts<MySQLParser::SrsAttributeContext>();
}

MySQLParser::SrsAttributeContext* MySQLParser::CreateSpatialReferenceContext::srsAttribute(size_t i) {
  return getRuleContext<MySQLParser::SrsAttributeContext>(i);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateSpatialReferenceContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}


size_t MySQLParser::CreateSpatialReferenceContext::getRuleIndex() const {
  return MySQLParser::RuleCreateSpatialReference;
}

void MySQLParser::CreateSpatialReferenceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateSpatialReference(this);
}

void MySQLParser::CreateSpatialReferenceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateSpatialReference(this);
}


std::any MySQLParser::CreateSpatialReferenceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateSpatialReference(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateSpatialReferenceContext* MySQLParser::createSpatialReference() {
  CreateSpatialReferenceContext *_localctx = _tracker.createInstance<CreateSpatialReferenceContext>(_ctx, getState());
  enterRule(_localctx, 188, MySQLParser::RuleCreateSpatialReference);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2806);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::OR_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2781);
        match(MySQLParser::OR_SYMBOL);
        setState(2782);
        match(MySQLParser::REPLACE_SYMBOL);
        setState(2783);
        match(MySQLParser::SPATIAL_SYMBOL);
        setState(2784);
        match(MySQLParser::REFERENCE_SYMBOL);
        setState(2785);
        match(MySQLParser::SYSTEM_SYMBOL);
        setState(2786);
        real_ulonglong_number();
        setState(2790);
        _errHandler->sync(this);
        _la = _input->LA(1);
        while (_la == MySQLParser::NAME_SYMBOL || ((((_la - 740) & ~ 0x3fULL) == 0) &&
          ((1ULL << (_la - 740)) & ((1ULL << (MySQLParser::DEFINITION_SYMBOL - 740))
          | (1ULL << (MySQLParser::DESCRIPTION_SYMBOL - 740))
          | (1ULL << (MySQLParser::ORGANIZATION_SYMBOL - 740)))) != 0)) {
          setState(2787);
          srsAttribute();
          setState(2792);
          _errHandler->sync(this);
          _la = _input->LA(1);
        }
        break;
      }

      case MySQLParser::SPATIAL_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2793);
        match(MySQLParser::SPATIAL_SYMBOL);
        setState(2794);
        match(MySQLParser::REFERENCE_SYMBOL);
        setState(2795);
        match(MySQLParser::SYSTEM_SYMBOL);
        setState(2797);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 192, _ctx)) {
        case 1: {
          setState(2796);
          ifNotExists();
          break;
        }

        default:
          break;
        }
        setState(2799);
        real_ulonglong_number();
        setState(2803);
        _errHandler->sync(this);
        _la = _input->LA(1);
        while (_la == MySQLParser::NAME_SYMBOL || ((((_la - 740) & ~ 0x3fULL) == 0) &&
          ((1ULL << (_la - 740)) & ((1ULL << (MySQLParser::DEFINITION_SYMBOL - 740))
          | (1ULL << (MySQLParser::DESCRIPTION_SYMBOL - 740))
          | (1ULL << (MySQLParser::ORGANIZATION_SYMBOL - 740)))) != 0)) {
          setState(2800);
          srsAttribute();
          setState(2805);
          _errHandler->sync(this);
          _la = _input->LA(1);
        }
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SrsAttributeContext ------------------------------------------------------------------

MySQLParser::SrsAttributeContext::SrsAttributeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::NAME_SYMBOL() {
  return getToken(MySQLParser::NAME_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::TEXT_SYMBOL() {
  return getToken(MySQLParser::TEXT_SYMBOL, 0);
}

MySQLParser::TextStringNoLinebreakContext* MySQLParser::SrsAttributeContext::textStringNoLinebreak() {
  return getRuleContext<MySQLParser::TextStringNoLinebreakContext>(0);
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::DEFINITION_SYMBOL() {
  return getToken(MySQLParser::DEFINITION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::ORGANIZATION_SYMBOL() {
  return getToken(MySQLParser::ORGANIZATION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::IDENTIFIED_SYMBOL() {
  return getToken(MySQLParser::IDENTIFIED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::BY_SYMBOL() {
  return getToken(MySQLParser::BY_SYMBOL, 0);
}

MySQLParser::Real_ulonglong_numberContext* MySQLParser::SrsAttributeContext::real_ulonglong_number() {
  return getRuleContext<MySQLParser::Real_ulonglong_numberContext>(0);
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::DESCRIPTION_SYMBOL() {
  return getToken(MySQLParser::DESCRIPTION_SYMBOL, 0);
}


size_t MySQLParser::SrsAttributeContext::getRuleIndex() const {
  return MySQLParser::RuleSrsAttribute;
}

void MySQLParser::SrsAttributeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSrsAttribute(this);
}

void MySQLParser::SrsAttributeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSrsAttribute(this);
}


std::any MySQLParser::SrsAttributeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSrsAttribute(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SrsAttributeContext* MySQLParser::srsAttribute() {
  SrsAttributeContext *_localctx = _tracker.createInstance<SrsAttributeContext>(_ctx, getState());
  enterRule(_localctx, 190, MySQLParser::RuleSrsAttribute);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2823);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::NAME_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2808);
        match(MySQLParser::NAME_SYMBOL);
        setState(2809);
        match(MySQLParser::TEXT_SYMBOL);
        setState(2810);
        textStringNoLinebreak();
        break;
      }

      case MySQLParser::DEFINITION_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2811);
        match(MySQLParser::DEFINITION_SYMBOL);
        setState(2812);
        match(MySQLParser::TEXT_SYMBOL);
        setState(2813);
        textStringNoLinebreak();
        break;
      }

      case MySQLParser::ORGANIZATION_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(2814);
        match(MySQLParser::ORGANIZATION_SYMBOL);
        setState(2815);
        textStringNoLinebreak();
        setState(2816);
        match(MySQLParser::IDENTIFIED_SYMBOL);
        setState(2817);
        match(MySQLParser::BY_SYMBOL);
        setState(2818);
        real_ulonglong_number();
        break;
      }

      case MySQLParser::DESCRIPTION_SYMBOL: {
        enterOuterAlt(_localctx, 4);
        setState(2820);
        match(MySQLParser::DESCRIPTION_SYMBOL);
        setState(2821);
        match(MySQLParser::TEXT_SYMBOL);
        setState(2822);
        textStringNoLinebreak();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropStatementContext ------------------------------------------------------------------

MySQLParser::DropStatementContext::DropStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropStatementContext::DROP_SYMBOL() {
  return getToken(MySQLParser::DROP_SYMBOL, 0);
}

MySQLParser::DropDatabaseContext* MySQLParser::DropStatementContext::dropDatabase() {
  return getRuleContext<MySQLParser::DropDatabaseContext>(0);
}

MySQLParser::DropEventContext* MySQLParser::DropStatementContext::dropEvent() {
  return getRuleContext<MySQLParser::DropEventContext>(0);
}

MySQLParser::DropFunctionContext* MySQLParser::DropStatementContext::dropFunction() {
  return getRuleContext<MySQLParser::DropFunctionContext>(0);
}

MySQLParser::DropProcedureContext* MySQLParser::DropStatementContext::dropProcedure() {
  return getRuleContext<MySQLParser::DropProcedureContext>(0);
}

MySQLParser::DropIndexContext* MySQLParser::DropStatementContext::dropIndex() {
  return getRuleContext<MySQLParser::DropIndexContext>(0);
}

MySQLParser::DropLogfileGroupContext* MySQLParser::DropStatementContext::dropLogfileGroup() {
  return getRuleContext<MySQLParser::DropLogfileGroupContext>(0);
}

MySQLParser::DropServerContext* MySQLParser::DropStatementContext::dropServer() {
  return getRuleContext<MySQLParser::DropServerContext>(0);
}

MySQLParser::DropTableContext* MySQLParser::DropStatementContext::dropTable() {
  return getRuleContext<MySQLParser::DropTableContext>(0);
}

MySQLParser::DropTableSpaceContext* MySQLParser::DropStatementContext::dropTableSpace() {
  return getRuleContext<MySQLParser::DropTableSpaceContext>(0);
}

MySQLParser::DropTriggerContext* MySQLParser::DropStatementContext::dropTrigger() {
  return getRuleContext<MySQLParser::DropTriggerContext>(0);
}

MySQLParser::DropViewContext* MySQLParser::DropStatementContext::dropView() {
  return getRuleContext<MySQLParser::DropViewContext>(0);
}

MySQLParser::DropRoleContext* MySQLParser::DropStatementContext::dropRole() {
  return getRuleContext<MySQLParser::DropRoleContext>(0);
}

MySQLParser::DropSpatialReferenceContext* MySQLParser::DropStatementContext::dropSpatialReference() {
  return getRuleContext<MySQLParser::DropSpatialReferenceContext>(0);
}

MySQLParser::DropUndoTablespaceContext* MySQLParser::DropStatementContext::dropUndoTablespace() {
  return getRuleContext<MySQLParser::DropUndoTablespaceContext>(0);
}


size_t MySQLParser::DropStatementContext::getRuleIndex() const {
  return MySQLParser::RuleDropStatement;
}

void MySQLParser::DropStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropStatement(this);
}

void MySQLParser::DropStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropStatement(this);
}


std::any MySQLParser::DropStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropStatementContext* MySQLParser::dropStatement() {
  DropStatementContext *_localctx = _tracker.createInstance<DropStatementContext>(_ctx, getState());
  enterRule(_localctx, 192, MySQLParser::RuleDropStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2825);
    match(MySQLParser::DROP_SYMBOL);
    setState(2843);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 196, _ctx)) {
    case 1: {
      setState(2826);
      dropDatabase();
      break;
    }

    case 2: {
      setState(2827);
      dropEvent();
      break;
    }

    case 3: {
      setState(2828);
      dropFunction();
      break;
    }

    case 4: {
      setState(2829);
      dropProcedure();
      break;
    }

    case 5: {
      setState(2830);
      dropIndex();
      break;
    }

    case 6: {
      setState(2831);
      dropLogfileGroup();
      break;
    }

    case 7: {
      setState(2832);
      dropServer();
      break;
    }

    case 8: {
      setState(2833);
      dropTable();
      break;
    }

    case 9: {
      setState(2834);
      dropTableSpace();
      break;
    }

    case 10: {
      setState(2835);
      dropTrigger();
      break;
    }

    case 11: {
      setState(2836);
      dropView();
      break;
    }

    case 12: {
      setState(2837);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(2838);
      dropRole();
      break;
    }

    case 13: {
      setState(2839);

      if (!(serverVersion >= 80011)) throw FailedPredicateException(this, "serverVersion >= 80011");
      setState(2840);
      dropSpatialReference();
      break;
    }

    case 14: {
      setState(2841);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(2842);
      dropUndoTablespace();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropDatabaseContext ------------------------------------------------------------------

MySQLParser::DropDatabaseContext::DropDatabaseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropDatabaseContext::DATABASE_SYMBOL() {
  return getToken(MySQLParser::DATABASE_SYMBOL, 0);
}

MySQLParser::SchemaRefContext* MySQLParser::DropDatabaseContext::schemaRef() {
  return getRuleContext<MySQLParser::SchemaRefContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropDatabaseContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropDatabaseContext::getRuleIndex() const {
  return MySQLParser::RuleDropDatabase;
}

void MySQLParser::DropDatabaseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropDatabase(this);
}

void MySQLParser::DropDatabaseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropDatabase(this);
}


std::any MySQLParser::DropDatabaseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropDatabase(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropDatabaseContext* MySQLParser::dropDatabase() {
  DropDatabaseContext *_localctx = _tracker.createInstance<DropDatabaseContext>(_ctx, getState());
  enterRule(_localctx, 194, MySQLParser::RuleDropDatabase);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2845);
    match(MySQLParser::DATABASE_SYMBOL);
    setState(2847);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 197, _ctx)) {
    case 1: {
      setState(2846);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2849);
    schemaRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropEventContext ------------------------------------------------------------------

MySQLParser::DropEventContext::DropEventContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropEventContext::EVENT_SYMBOL() {
  return getToken(MySQLParser::EVENT_SYMBOL, 0);
}

MySQLParser::EventRefContext* MySQLParser::DropEventContext::eventRef() {
  return getRuleContext<MySQLParser::EventRefContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropEventContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropEventContext::getRuleIndex() const {
  return MySQLParser::RuleDropEvent;
}

void MySQLParser::DropEventContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropEvent(this);
}

void MySQLParser::DropEventContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropEvent(this);
}


std::any MySQLParser::DropEventContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropEvent(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropEventContext* MySQLParser::dropEvent() {
  DropEventContext *_localctx = _tracker.createInstance<DropEventContext>(_ctx, getState());
  enterRule(_localctx, 196, MySQLParser::RuleDropEvent);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2851);
    match(MySQLParser::EVENT_SYMBOL);
    setState(2853);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 198, _ctx)) {
    case 1: {
      setState(2852);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2855);
    eventRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropFunctionContext ------------------------------------------------------------------

MySQLParser::DropFunctionContext::DropFunctionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropFunctionContext::FUNCTION_SYMBOL() {
  return getToken(MySQLParser::FUNCTION_SYMBOL, 0);
}

MySQLParser::FunctionRefContext* MySQLParser::DropFunctionContext::functionRef() {
  return getRuleContext<MySQLParser::FunctionRefContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropFunctionContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropFunctionContext::getRuleIndex() const {
  return MySQLParser::RuleDropFunction;
}

void MySQLParser::DropFunctionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropFunction(this);
}

void MySQLParser::DropFunctionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropFunction(this);
}


std::any MySQLParser::DropFunctionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropFunction(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropFunctionContext* MySQLParser::dropFunction() {
  DropFunctionContext *_localctx = _tracker.createInstance<DropFunctionContext>(_ctx, getState());
  enterRule(_localctx, 198, MySQLParser::RuleDropFunction);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2857);
    match(MySQLParser::FUNCTION_SYMBOL);
    setState(2859);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 199, _ctx)) {
    case 1: {
      setState(2858);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2861);
    functionRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropProcedureContext ------------------------------------------------------------------

MySQLParser::DropProcedureContext::DropProcedureContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropProcedureContext::PROCEDURE_SYMBOL() {
  return getToken(MySQLParser::PROCEDURE_SYMBOL, 0);
}

MySQLParser::ProcedureRefContext* MySQLParser::DropProcedureContext::procedureRef() {
  return getRuleContext<MySQLParser::ProcedureRefContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropProcedureContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropProcedureContext::getRuleIndex() const {
  return MySQLParser::RuleDropProcedure;
}

void MySQLParser::DropProcedureContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropProcedure(this);
}

void MySQLParser::DropProcedureContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropProcedure(this);
}


std::any MySQLParser::DropProcedureContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropProcedure(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropProcedureContext* MySQLParser::dropProcedure() {
  DropProcedureContext *_localctx = _tracker.createInstance<DropProcedureContext>(_ctx, getState());
  enterRule(_localctx, 200, MySQLParser::RuleDropProcedure);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2863);
    match(MySQLParser::PROCEDURE_SYMBOL);
    setState(2865);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 200, _ctx)) {
    case 1: {
      setState(2864);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2867);
    procedureRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropIndexContext ------------------------------------------------------------------

MySQLParser::DropIndexContext::DropIndexContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::IndexRefContext* MySQLParser::DropIndexContext::indexRef() {
  return getRuleContext<MySQLParser::IndexRefContext>(0);
}

tree::TerminalNode* MySQLParser::DropIndexContext::ON_SYMBOL() {
  return getToken(MySQLParser::ON_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::DropIndexContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

tree::TerminalNode* MySQLParser::DropIndexContext::INDEX_SYMBOL() {
  return getToken(MySQLParser::INDEX_SYMBOL, 0);
}

MySQLParser::OnlineOptionContext* MySQLParser::DropIndexContext::onlineOption() {
  return getRuleContext<MySQLParser::OnlineOptionContext>(0);
}

MySQLParser::IndexLockAndAlgorithmContext* MySQLParser::DropIndexContext::indexLockAndAlgorithm() {
  return getRuleContext<MySQLParser::IndexLockAndAlgorithmContext>(0);
}


size_t MySQLParser::DropIndexContext::getRuleIndex() const {
  return MySQLParser::RuleDropIndex;
}

void MySQLParser::DropIndexContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropIndex(this);
}

void MySQLParser::DropIndexContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropIndex(this);
}


std::any MySQLParser::DropIndexContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropIndex(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropIndexContext* MySQLParser::dropIndex() {
  DropIndexContext *_localctx = _tracker.createInstance<DropIndexContext>(_ctx, getState());
  enterRule(_localctx, 202, MySQLParser::RuleDropIndex);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2870);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OFFLINE_SYMBOL

    || _la == MySQLParser::ONLINE_SYMBOL) {
      setState(2869);
      onlineOption();
    }
    setState(2872);
    antlrcpp::downCast<DropIndexContext *>(_localctx)->type = match(MySQLParser::INDEX_SYMBOL);
    setState(2873);
    indexRef();
    setState(2874);
    match(MySQLParser::ON_SYMBOL);
    setState(2875);
    tableRef();
    setState(2877);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ALGORITHM_SYMBOL || _la == MySQLParser::LOCK_SYMBOL) {
      setState(2876);
      indexLockAndAlgorithm();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropLogfileGroupContext ------------------------------------------------------------------

MySQLParser::DropLogfileGroupContext::DropLogfileGroupContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropLogfileGroupContext::LOGFILE_SYMBOL() {
  return getToken(MySQLParser::LOGFILE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropLogfileGroupContext::GROUP_SYMBOL() {
  return getToken(MySQLParser::GROUP_SYMBOL, 0);
}

MySQLParser::LogfileGroupRefContext* MySQLParser::DropLogfileGroupContext::logfileGroupRef() {
  return getRuleContext<MySQLParser::LogfileGroupRefContext>(0);
}

std::vector<MySQLParser::DropLogfileGroupOptionContext *> MySQLParser::DropLogfileGroupContext::dropLogfileGroupOption() {
  return getRuleContexts<MySQLParser::DropLogfileGroupOptionContext>();
}

MySQLParser::DropLogfileGroupOptionContext* MySQLParser::DropLogfileGroupContext::dropLogfileGroupOption(size_t i) {
  return getRuleContext<MySQLParser::DropLogfileGroupOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::DropLogfileGroupContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::DropLogfileGroupContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::DropLogfileGroupContext::getRuleIndex() const {
  return MySQLParser::RuleDropLogfileGroup;
}

void MySQLParser::DropLogfileGroupContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropLogfileGroup(this);
}

void MySQLParser::DropLogfileGroupContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropLogfileGroup(this);
}


std::any MySQLParser::DropLogfileGroupContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropLogfileGroup(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropLogfileGroupContext* MySQLParser::dropLogfileGroup() {
  DropLogfileGroupContext *_localctx = _tracker.createInstance<DropLogfileGroupContext>(_ctx, getState());
  enterRule(_localctx, 204, MySQLParser::RuleDropLogfileGroup);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2879);
    match(MySQLParser::LOGFILE_SYMBOL);
    setState(2880);
    match(MySQLParser::GROUP_SYMBOL);
    setState(2881);
    logfileGroupRef();
    setState(2892);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
      setState(2882);
      dropLogfileGroupOption();
      setState(2889);
      _errHandler->sync(this);
      _la = _input->LA(1);
      while (_la == MySQLParser::COMMA_SYMBOL || _la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
        setState(2884);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::COMMA_SYMBOL) {
          setState(2883);
          match(MySQLParser::COMMA_SYMBOL);
        }
        setState(2886);
        dropLogfileGroupOption();
        setState(2891);
        _errHandler->sync(this);
        _la = _input->LA(1);
      }
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropLogfileGroupOptionContext ------------------------------------------------------------------

MySQLParser::DropLogfileGroupOptionContext::DropLogfileGroupOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TsOptionWaitContext* MySQLParser::DropLogfileGroupOptionContext::tsOptionWait() {
  return getRuleContext<MySQLParser::TsOptionWaitContext>(0);
}

MySQLParser::TsOptionEngineContext* MySQLParser::DropLogfileGroupOptionContext::tsOptionEngine() {
  return getRuleContext<MySQLParser::TsOptionEngineContext>(0);
}


size_t MySQLParser::DropLogfileGroupOptionContext::getRuleIndex() const {
  return MySQLParser::RuleDropLogfileGroupOption;
}

void MySQLParser::DropLogfileGroupOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropLogfileGroupOption(this);
}

void MySQLParser::DropLogfileGroupOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropLogfileGroupOption(this);
}


std::any MySQLParser::DropLogfileGroupOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropLogfileGroupOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropLogfileGroupOptionContext* MySQLParser::dropLogfileGroupOption() {
  DropLogfileGroupOptionContext *_localctx = _tracker.createInstance<DropLogfileGroupOptionContext>(_ctx, getState());
  enterRule(_localctx, 206, MySQLParser::RuleDropLogfileGroupOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2896);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::NO_WAIT_SYMBOL:
      case MySQLParser::WAIT_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2894);
        tsOptionWait();
        break;
      }

      case MySQLParser::ENGINE_SYMBOL:
      case MySQLParser::STORAGE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2895);
        tsOptionEngine();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropServerContext ------------------------------------------------------------------

MySQLParser::DropServerContext::DropServerContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropServerContext::SERVER_SYMBOL() {
  return getToken(MySQLParser::SERVER_SYMBOL, 0);
}

MySQLParser::ServerRefContext* MySQLParser::DropServerContext::serverRef() {
  return getRuleContext<MySQLParser::ServerRefContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropServerContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropServerContext::getRuleIndex() const {
  return MySQLParser::RuleDropServer;
}

void MySQLParser::DropServerContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropServer(this);
}

void MySQLParser::DropServerContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropServer(this);
}


std::any MySQLParser::DropServerContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropServer(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropServerContext* MySQLParser::dropServer() {
  DropServerContext *_localctx = _tracker.createInstance<DropServerContext>(_ctx, getState());
  enterRule(_localctx, 208, MySQLParser::RuleDropServer);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2898);
    match(MySQLParser::SERVER_SYMBOL);
    setState(2900);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 207, _ctx)) {
    case 1: {
      setState(2899);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2902);
    serverRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropTableContext ------------------------------------------------------------------

MySQLParser::DropTableContext::DropTableContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TableRefListContext* MySQLParser::DropTableContext::tableRefList() {
  return getRuleContext<MySQLParser::TableRefListContext>(0);
}

tree::TerminalNode* MySQLParser::DropTableContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropTableContext::TABLES_SYMBOL() {
  return getToken(MySQLParser::TABLES_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropTableContext::TEMPORARY_SYMBOL() {
  return getToken(MySQLParser::TEMPORARY_SYMBOL, 0);
}

MySQLParser::IfExistsContext* MySQLParser::DropTableContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}

tree::TerminalNode* MySQLParser::DropTableContext::RESTRICT_SYMBOL() {
  return getToken(MySQLParser::RESTRICT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropTableContext::CASCADE_SYMBOL() {
  return getToken(MySQLParser::CASCADE_SYMBOL, 0);
}


size_t MySQLParser::DropTableContext::getRuleIndex() const {
  return MySQLParser::RuleDropTable;
}

void MySQLParser::DropTableContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropTable(this);
}

void MySQLParser::DropTableContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropTable(this);
}


std::any MySQLParser::DropTableContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropTable(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropTableContext* MySQLParser::dropTable() {
  DropTableContext *_localctx = _tracker.createInstance<DropTableContext>(_ctx, getState());
  enterRule(_localctx, 210, MySQLParser::RuleDropTable);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2905);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::TEMPORARY_SYMBOL) {
      setState(2904);
      match(MySQLParser::TEMPORARY_SYMBOL);
    }
    setState(2907);
    antlrcpp::downCast<DropTableContext *>(_localctx)->type = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::TABLES_SYMBOL

    || _la == MySQLParser::TABLE_SYMBOL)) {
      antlrcpp::downCast<DropTableContext *>(_localctx)->type = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2909);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 209, _ctx)) {
    case 1: {
      setState(2908);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2911);
    tableRefList();
    setState(2913);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::CASCADE_SYMBOL || _la == MySQLParser::RESTRICT_SYMBOL) {
      setState(2912);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::CASCADE_SYMBOL || _la == MySQLParser::RESTRICT_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropTableSpaceContext ------------------------------------------------------------------

MySQLParser::DropTableSpaceContext::DropTableSpaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropTableSpaceContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

MySQLParser::TablespaceRefContext* MySQLParser::DropTableSpaceContext::tablespaceRef() {
  return getRuleContext<MySQLParser::TablespaceRefContext>(0);
}

std::vector<MySQLParser::DropLogfileGroupOptionContext *> MySQLParser::DropTableSpaceContext::dropLogfileGroupOption() {
  return getRuleContexts<MySQLParser::DropLogfileGroupOptionContext>();
}

MySQLParser::DropLogfileGroupOptionContext* MySQLParser::DropTableSpaceContext::dropLogfileGroupOption(size_t i) {
  return getRuleContext<MySQLParser::DropLogfileGroupOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::DropTableSpaceContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::DropTableSpaceContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::DropTableSpaceContext::getRuleIndex() const {
  return MySQLParser::RuleDropTableSpace;
}

void MySQLParser::DropTableSpaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropTableSpace(this);
}

void MySQLParser::DropTableSpaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropTableSpace(this);
}


std::any MySQLParser::DropTableSpaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropTableSpace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropTableSpaceContext* MySQLParser::dropTableSpace() {
  DropTableSpaceContext *_localctx = _tracker.createInstance<DropTableSpaceContext>(_ctx, getState());
  enterRule(_localctx, 212, MySQLParser::RuleDropTableSpace);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2915);
    match(MySQLParser::TABLESPACE_SYMBOL);
    setState(2916);
    tablespaceRef();
    setState(2927);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
      setState(2917);
      dropLogfileGroupOption();
      setState(2924);
      _errHandler->sync(this);
      _la = _input->LA(1);
      while (_la == MySQLParser::COMMA_SYMBOL || _la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
        setState(2919);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::COMMA_SYMBOL) {
          setState(2918);
          match(MySQLParser::COMMA_SYMBOL);
        }
        setState(2921);
        dropLogfileGroupOption();
        setState(2926);
        _errHandler->sync(this);
        _la = _input->LA(1);
      }
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropTriggerContext ------------------------------------------------------------------

MySQLParser::DropTriggerContext::DropTriggerContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropTriggerContext::TRIGGER_SYMBOL() {
  return getToken(MySQLParser::TRIGGER_SYMBOL, 0);
}

MySQLParser::TriggerRefContext* MySQLParser::DropTriggerContext::triggerRef() {
  return getRuleContext<MySQLParser::TriggerRefContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropTriggerContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropTriggerContext::getRuleIndex() const {
  return MySQLParser::RuleDropTrigger;
}

void MySQLParser::DropTriggerContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropTrigger(this);
}

void MySQLParser::DropTriggerContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropTrigger(this);
}


std::any MySQLParser::DropTriggerContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropTrigger(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropTriggerContext* MySQLParser::dropTrigger() {
  DropTriggerContext *_localctx = _tracker.createInstance<DropTriggerContext>(_ctx, getState());
  enterRule(_localctx, 214, MySQLParser::RuleDropTrigger);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2929);
    match(MySQLParser::TRIGGER_SYMBOL);
    setState(2931);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 214, _ctx)) {
    case 1: {
      setState(2930);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2933);
    triggerRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropViewContext ------------------------------------------------------------------

MySQLParser::DropViewContext::DropViewContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropViewContext::VIEW_SYMBOL() {
  return getToken(MySQLParser::VIEW_SYMBOL, 0);
}

MySQLParser::ViewRefListContext* MySQLParser::DropViewContext::viewRefList() {
  return getRuleContext<MySQLParser::ViewRefListContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropViewContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}

tree::TerminalNode* MySQLParser::DropViewContext::RESTRICT_SYMBOL() {
  return getToken(MySQLParser::RESTRICT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropViewContext::CASCADE_SYMBOL() {
  return getToken(MySQLParser::CASCADE_SYMBOL, 0);
}


size_t MySQLParser::DropViewContext::getRuleIndex() const {
  return MySQLParser::RuleDropView;
}

void MySQLParser::DropViewContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropView(this);
}

void MySQLParser::DropViewContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropView(this);
}


std::any MySQLParser::DropViewContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropView(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropViewContext* MySQLParser::dropView() {
  DropViewContext *_localctx = _tracker.createInstance<DropViewContext>(_ctx, getState());
  enterRule(_localctx, 216, MySQLParser::RuleDropView);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2935);
    match(MySQLParser::VIEW_SYMBOL);
    setState(2937);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 215, _ctx)) {
    case 1: {
      setState(2936);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2939);
    viewRefList();
    setState(2941);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::CASCADE_SYMBOL || _la == MySQLParser::RESTRICT_SYMBOL) {
      setState(2940);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::CASCADE_SYMBOL || _la == MySQLParser::RESTRICT_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropRoleContext ------------------------------------------------------------------

MySQLParser::DropRoleContext::DropRoleContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropRoleContext::ROLE_SYMBOL() {
  return getToken(MySQLParser::ROLE_SYMBOL, 0);
}

MySQLParser::RoleListContext* MySQLParser::DropRoleContext::roleList() {
  return getRuleContext<MySQLParser::RoleListContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropRoleContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropRoleContext::getRuleIndex() const {
  return MySQLParser::RuleDropRole;
}

void MySQLParser::DropRoleContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropRole(this);
}

void MySQLParser::DropRoleContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropRole(this);
}


std::any MySQLParser::DropRoleContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropRole(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropRoleContext* MySQLParser::dropRole() {
  DropRoleContext *_localctx = _tracker.createInstance<DropRoleContext>(_ctx, getState());
  enterRule(_localctx, 218, MySQLParser::RuleDropRole);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2943);
    match(MySQLParser::ROLE_SYMBOL);
    setState(2945);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 217, _ctx)) {
    case 1: {
      setState(2944);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2947);
    roleList();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropSpatialReferenceContext ------------------------------------------------------------------

MySQLParser::DropSpatialReferenceContext::DropSpatialReferenceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropSpatialReferenceContext::SPATIAL_SYMBOL() {
  return getToken(MySQLParser::SPATIAL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropSpatialReferenceContext::REFERENCE_SYMBOL() {
  return getToken(MySQLParser::REFERENCE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropSpatialReferenceContext::SYSTEM_SYMBOL() {
  return getToken(MySQLParser::SYSTEM_SYMBOL, 0);
}

MySQLParser::Real_ulonglong_numberContext* MySQLParser::DropSpatialReferenceContext::real_ulonglong_number() {
  return getRuleContext<MySQLParser::Real_ulonglong_numberContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropSpatialReferenceContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropSpatialReferenceContext::getRuleIndex() const {
  return MySQLParser::RuleDropSpatialReference;
}

void MySQLParser::DropSpatialReferenceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropSpatialReference(this);
}

void MySQLParser::DropSpatialReferenceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropSpatialReference(this);
}


std::any MySQLParser::DropSpatialReferenceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropSpatialReference(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropSpatialReferenceContext* MySQLParser::dropSpatialReference() {
  DropSpatialReferenceContext *_localctx = _tracker.createInstance<DropSpatialReferenceContext>(_ctx, getState());
  enterRule(_localctx, 220, MySQLParser::RuleDropSpatialReference);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2949);
    match(MySQLParser::SPATIAL_SYMBOL);
    setState(2950);
    match(MySQLParser::REFERENCE_SYMBOL);
    setState(2951);
    match(MySQLParser::SYSTEM_SYMBOL);
    setState(2953);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 218, _ctx)) {
    case 1: {
      setState(2952);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2955);
    real_ulonglong_number();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropUndoTablespaceContext ------------------------------------------------------------------

MySQLParser::DropUndoTablespaceContext::DropUndoTablespaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropUndoTablespaceContext::UNDO_SYMBOL() {
  return getToken(MySQLParser::UNDO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropUndoTablespaceContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

MySQLParser::TablespaceRefContext* MySQLParser::DropUndoTablespaceContext::tablespaceRef() {
  return getRuleContext<MySQLParser::TablespaceRefContext>(0);
}

MySQLParser::UndoTableSpaceOptionsContext* MySQLParser::DropUndoTablespaceContext::undoTableSpaceOptions() {
  return getRuleContext<MySQLParser::UndoTableSpaceOptionsContext>(0);
}


size_t MySQLParser::DropUndoTablespaceContext::getRuleIndex() const {
  return MySQLParser::RuleDropUndoTablespace;
}

void MySQLParser::DropUndoTablespaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropUndoTablespace(this);
}

void MySQLParser::DropUndoTablespaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropUndoTablespace(this);
}


std::any MySQLParser::DropUndoTablespaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropUndoTablespace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropUndoTablespaceContext* MySQLParser::dropUndoTablespace() {
  DropUndoTablespaceContext *_localctx = _tracker.createInstance<DropUndoTablespaceContext>(_ctx, getState());
  enterRule(_localctx, 222, MySQLParser::RuleDropUndoTablespace);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2957);
    match(MySQLParser::UNDO_SYMBOL);
    setState(2958);
    match(MySQLParser::TABLESPACE_SYMBOL);
    setState(2959);
    tablespaceRef();
    setState(2961);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL) {
      setState(2960);
      undoTableSpaceOptions();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RenameTableStatementContext ------------------------------------------------------------------

MySQLParser::RenameTableStatementContext::RenameTableStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::RenameTableStatementContext::RENAME_SYMBOL() {
  return getToken(MySQLParser::RENAME_SYMBOL, 0);
}

std::vector<MySQLParser::RenamePairContext *> MySQLParser::RenameTableStatementContext::renamePair() {
  return getRuleContexts<MySQLParser::RenamePairContext>();
}

MySQLParser::RenamePairContext* MySQLParser::RenameTableStatementContext::renamePair(size_t i) {
  return getRuleContext<MySQLParser::RenamePairContext>(i);
}

tree::TerminalNode* MySQLParser::RenameTableStatementContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RenameTableStatementContext::TABLES_SYMBOL() {
  return getToken(MySQLParser::TABLES_SYMBOL, 0);
}

std::vector<tree::TerminalNode *> MySQLParser::RenameTableStatementContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::RenameTableStatementContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::RenameTableStatementContext::getRuleIndex() const {
  return MySQLParser::RuleRenameTableStatement;
}

void MySQLParser::RenameTableStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRenameTableStatement(this);
}

void MySQLParser::RenameTableStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRenameTableStatement(this);
}


std::any MySQLParser::RenameTableStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRenameTableStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RenameTableStatementContext* MySQLParser::renameTableStatement() {
  RenameTableStatementContext *_localctx = _tracker.createInstance<RenameTableStatementContext>(_ctx, getState());
  enterRule(_localctx, 224, MySQLParser::RuleRenameTableStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2963);
    match(MySQLParser::RENAME_SYMBOL);
    setState(2964);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::TABLES_SYMBOL

    || _la == MySQLParser::TABLE_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2965);
    renamePair();
    setState(2970);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(2966);
      match(MySQLParser::COMMA_SYMBOL);
      setState(2967);
      renamePair();
      setState(2972);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RenamePairContext ------------------------------------------------------------------

MySQLParser::RenamePairContext::RenamePairContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TableRefContext* MySQLParser::RenamePairContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

tree::TerminalNode* MySQLParser::RenamePairContext::TO_SYMBOL() {
  return getToken(MySQLParser::TO_SYMBOL, 0);
}

MySQLParser::TableNameContext* MySQLParser::RenamePairContext::tableName() {
  return getRuleContext<MySQLParser::TableNameContext>(0);
}


size_t MySQLParser::RenamePairContext::getRuleIndex() const {
  return MySQLParser::RuleRenamePair;
}

void MySQLParser::RenamePairContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRenamePair(this);
}

void MySQLParser::RenamePairContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRenamePair(this);
}


std::any MySQLParser::RenamePairContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRenamePair(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RenamePairContext* MySQLParser::renamePair() {
  RenamePairContext *_localctx = _tracker.createInstance<RenamePairContext>(_ctx, getState());
  enterRule(_localctx, 226, MySQLParser::RuleRenamePair);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2973);
    tableRef();
    setState(2974);
    match(MySQLParser::TO_SYMBOL);
    setState(2975);
    tableName();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TruncateTableStatementContext ------------------------------------------------------------------

MySQLParser::TruncateTableStatementContext::TruncateTableStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TruncateTableStatementContext::TRUNCATE_SYMBOL() {
  return getToken(MySQLParser::TRUNCATE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::TruncateTableStatementContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

tree::TerminalNode* MySQLParser::TruncateTableStatementContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}


size_t MySQLParser::TruncateTableStatementContext::getRuleIndex() const {
  return MySQLParser::RuleTruncateTableStatement;
}

void MySQLParser::TruncateTableStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTruncateTableStatement(this);
}

void MySQLParser::TruncateTableStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTruncateTableStatement(this);
}


std::any MySQLParser::TruncateTableStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTruncateTableStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TruncateTableStatementContext* MySQLParser::truncateTableStatement() {
  TruncateTableStatementContext *_localctx = _tracker.createInstance<TruncateTableStatementContext>(_ctx, getState());
  enterRule(_localctx, 228, MySQLParser::RuleTruncateTableStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2977);
    match(MySQLParser::TRUNCATE_SYMBOL);
    setState(2979);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 221, _ctx)) {
    case 1: {
      setState(2978);
      match(MySQLParser::TABLE_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(2981);
    tableRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ImportStatementContext ------------------------------------------------------------------

MySQLParser::ImportStatementContext::ImportStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ImportStatementContext::IMPORT_SYMBOL() {
  return getToken(MySQLParser::IMPORT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ImportStatementContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ImportStatementContext::FROM_SYMBOL() {
  return getToken(MySQLParser::FROM_SYMBOL, 0);
}

MySQLParser::TextStringLiteralListContext* MySQLParser::ImportStatementContext::textStringLiteralList() {
  return getRuleContext<MySQLParser::TextStringLiteralListContext>(0);
}


size_t MySQLParser::ImportStatementContext::getRuleIndex() const {
  return MySQLParser::RuleImportStatement;
}

void MySQLParser::ImportStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterImportStatement(this);
}

void MySQLParser::ImportStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitImportStatement(this);
}


std::any MySQLParser::ImportStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitImportStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ImportStatementContext* MySQLParser::importStatement() {
  ImportStatementContext *_localctx = _tracker.createInstance<ImportStatementContext>(_ctx, getState());
  enterRule(_localctx, 230, MySQLParser::RuleImportStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2983);
    match(MySQLParser::IMPORT_SYMBOL);
    setState(2984);
    match(MySQLParser::TABLE_SYMBOL);
    setState(2985);
    match(MySQLParser::FROM_SYMBOL);
    setState(2986);
    textStringLiteralList();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CallStatementContext ------------------------------------------------------------------

MySQLParser::CallStatementContext::CallStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CallStatementContext::CALL_SYMBOL() {
  return getToken(MySQLParser::CALL_SYMBOL, 0);
}

MySQLParser::ProcedureRefContext* MySQLParser::CallStatementContext::procedureRef() {
  return getRuleContext<MySQLParser::ProcedureRefContext>(0);
}

tree::TerminalNode* MySQLParser::CallStatementContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CallStatementContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::ExprListContext* MySQLParser::CallStatementContext::exprList() {
  return getRuleContext<MySQLParser::ExprListContext>(0);
}


size_t MySQLParser::CallStatementContext::getRuleIndex() const {
  return MySQLParser::RuleCallStatement;
}

void MySQLParser::CallStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCallStatement(this);
}

void MySQLParser::CallStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCallStatement(this);
}


std::any MySQLParser::CallStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCallStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CallStatementContext* MySQLParser::callStatement() {
  CallStatementContext *_localctx = _tracker.createInstance<CallStatementContext>(_ctx, getState());
  enterRule(_localctx, 232, MySQLParser::RuleCallStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2988);
    match(MySQLParser::CALL_SYMBOL);
    setState(2989);
    procedureRef();
    setState(2995);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OPEN_PAR_SYMBOL) {
      setState(2990);
      match(MySQLParser::OPEN_PAR_SYMBOL);
      setState(2992);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 222, _ctx)) {
      case 1: {
        setState(2991);
        exprList();
        break;
      }

      default:
        break;
      }
      setState(2994);
      match(MySQLParser::CLOSE_PAR_SYMBOL);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DeleteStatementContext ------------------------------------------------------------------

MySQLParser::DeleteStatementContext::DeleteStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DeleteStatementContext::DELETE_SYMBOL() {
  return getToken(MySQLParser::DELETE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DeleteStatementContext::FROM_SYMBOL() {
  return getToken(MySQLParser::FROM_SYMBOL, 0);
}

MySQLParser::TableAliasRefListContext* MySQLParser::DeleteStatementContext::tableAliasRefList() {
  return getRuleContext<MySQLParser::TableAliasRefListContext>(0);
}

MySQLParser::TableReferenceListContext* MySQLParser::DeleteStatementContext::tableReferenceList() {
  return getRuleContext<MySQLParser::TableReferenceListContext>(0);
}

MySQLParser::WithClauseContext* MySQLParser::DeleteStatementContext::withClause() {
  return getRuleContext<MySQLParser::WithClauseContext>(0);
}

std::vector<MySQLParser::DeleteStatementOptionContext *> MySQLParser::DeleteStatementContext::deleteStatementOption() {
  return getRuleContexts<MySQLParser::DeleteStatementOptionContext>();
}

MySQLParser::DeleteStatementOptionContext* MySQLParser::DeleteStatementContext::deleteStatementOption(size_t i) {
  return getRuleContext<MySQLParser::DeleteStatementOptionContext>(i);
}

tree::TerminalNode* MySQLParser::DeleteStatementContext::USING_SYMBOL() {
  return getToken(MySQLParser::USING_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::DeleteStatementContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::WhereClauseContext* MySQLParser::DeleteStatementContext::whereClause() {
  return getRuleContext<MySQLParser::WhereClauseContext>(0);
}

MySQLParser::TableAliasContext* MySQLParser::DeleteStatementContext::tableAlias() {
  return getRuleContext<MySQLParser::TableAliasContext>(0);
}

MySQLParser::PartitionDeleteContext* MySQLParser::DeleteStatementContext::partitionDelete() {
  return getRuleContext<MySQLParser::PartitionDeleteContext>(0);
}

MySQLParser::OrderClauseContext* MySQLParser::DeleteStatementContext::orderClause() {
  return getRuleContext<MySQLParser::OrderClauseContext>(0);
}

MySQLParser::SimpleLimitClauseContext* MySQLParser::DeleteStatementContext::simpleLimitClause() {
  return getRuleContext<MySQLParser::SimpleLimitClauseContext>(0);
}


size_t MySQLParser::DeleteStatementContext::getRuleIndex() const {
  return MySQLParser::RuleDeleteStatement;
}

void MySQLParser::DeleteStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDeleteStatement(this);
}

void MySQLParser::DeleteStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDeleteStatement(this);
}


std::any MySQLParser::DeleteStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDeleteStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DeleteStatementContext* MySQLParser::deleteStatement() {
  DeleteStatementContext *_localctx = _tracker.createInstance<DeleteStatementContext>(_ctx, getState());
  enterRule(_localctx, 234, MySQLParser::RuleDeleteStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2999);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 224, _ctx)) {
    case 1: {
      setState(2997);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(2998);
      withClause();
      break;
    }

    default:
      break;
    }
    setState(3001);
    match(MySQLParser::DELETE_SYMBOL);
    setState(3005);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 225, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3002);
        deleteStatementOption(); 
      }
      setState(3007);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 225, _ctx);
    }
    setState(3040);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 234, _ctx)) {
    case 1: {
      setState(3008);
      match(MySQLParser::FROM_SYMBOL);
      setState(3032);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 232, _ctx)) {
      case 1: {
        setState(3009);
        tableAliasRefList();
        setState(3010);
        match(MySQLParser::USING_SYMBOL);
        setState(3011);
        tableReferenceList();
        setState(3013);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::WHERE_SYMBOL) {
          setState(3012);
          whereClause();
        }
        break;
      }

      case 2: {
        setState(3015);
        tableRef();
        setState(3018);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 227, _ctx)) {
        case 1: {
          setState(3016);

          if (!(serverVersion >= 80017)) throw FailedPredicateException(this, "serverVersion >= 80017");
          setState(3017);
          tableAlias();
          break;
        }

        default:
          break;
        }
        setState(3021);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::PARTITION_SYMBOL) {
          setState(3020);
          partitionDelete();
        }
        setState(3024);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::WHERE_SYMBOL) {
          setState(3023);
          whereClause();
        }
        setState(3027);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::ORDER_SYMBOL) {
          setState(3026);
          orderClause();
        }
        setState(3030);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::LIMIT_SYMBOL) {
          setState(3029);
          simpleLimitClause();
        }
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(3034);
      tableAliasRefList();
      setState(3035);
      match(MySQLParser::FROM_SYMBOL);
      setState(3036);
      tableReferenceList();
      setState(3038);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::WHERE_SYMBOL) {
        setState(3037);
        whereClause();
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- PartitionDeleteContext ------------------------------------------------------------------

MySQLParser::PartitionDeleteContext::PartitionDeleteContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::PartitionDeleteContext::PARTITION_SYMBOL() {
  return getToken(MySQLParser::PARTITION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::PartitionDeleteContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

MySQLParser::IdentifierListContext* MySQLParser::PartitionDeleteContext::identifierList() {
  return getRuleContext<MySQLParser::IdentifierListContext>(0);
}

tree::TerminalNode* MySQLParser::PartitionDeleteContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}


size_t MySQLParser::PartitionDeleteContext::getRuleIndex() const {
  return MySQLParser::RulePartitionDelete;
}

void MySQLParser::PartitionDeleteContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterPartitionDelete(this);
}

void MySQLParser::PartitionDeleteContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitPartitionDelete(this);
}


std::any MySQLParser::PartitionDeleteContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitPartitionDelete(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::PartitionDeleteContext* MySQLParser::partitionDelete() {
  PartitionDeleteContext *_localctx = _tracker.createInstance<PartitionDeleteContext>(_ctx, getState());
  enterRule(_localctx, 236, MySQLParser::RulePartitionDelete);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3042);
    match(MySQLParser::PARTITION_SYMBOL);
    setState(3043);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3044);
    identifierList();
    setState(3045);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DeleteStatementOptionContext ------------------------------------------------------------------

MySQLParser::DeleteStatementOptionContext::DeleteStatementOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DeleteStatementOptionContext::QUICK_SYMBOL() {
  return getToken(MySQLParser::QUICK_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DeleteStatementOptionContext::LOW_PRIORITY_SYMBOL() {
  return getToken(MySQLParser::LOW_PRIORITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DeleteStatementOptionContext::IGNORE_SYMBOL() {
  return getToken(MySQLParser::IGNORE_SYMBOL, 0);
}


size_t MySQLParser::DeleteStatementOptionContext::getRuleIndex() const {
  return MySQLParser::RuleDeleteStatementOption;
}

void MySQLParser::DeleteStatementOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDeleteStatementOption(this);
}

void MySQLParser::DeleteStatementOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDeleteStatementOption(this);
}


std::any MySQLParser::DeleteStatementOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDeleteStatementOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DeleteStatementOptionContext* MySQLParser::deleteStatementOption() {
  DeleteStatementOptionContext *_localctx = _tracker.createInstance<DeleteStatementOptionContext>(_ctx, getState());
  enterRule(_localctx, 238, MySQLParser::RuleDeleteStatementOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3047);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::IGNORE_SYMBOL

    || _la == MySQLParser::LOW_PRIORITY_SYMBOL || _la == MySQLParser::QUICK_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DoStatementContext ------------------------------------------------------------------

MySQLParser::DoStatementContext::DoStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DoStatementContext::DO_SYMBOL() {
  return getToken(MySQLParser::DO_SYMBOL, 0);
}

MySQLParser::ExprListContext* MySQLParser::DoStatementContext::exprList() {
  return getRuleContext<MySQLParser::ExprListContext>(0);
}

MySQLParser::SelectItemListContext* MySQLParser::DoStatementContext::selectItemList() {
  return getRuleContext<MySQLParser::SelectItemListContext>(0);
}


size_t MySQLParser::DoStatementContext::getRuleIndex() const {
  return MySQLParser::RuleDoStatement;
}

void MySQLParser::DoStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDoStatement(this);
}

void MySQLParser::DoStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDoStatement(this);
}


std::any MySQLParser::DoStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDoStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DoStatementContext* MySQLParser::doStatement() {
  DoStatementContext *_localctx = _tracker.createInstance<DoStatementContext>(_ctx, getState());
  enterRule(_localctx, 240, MySQLParser::RuleDoStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3049);
    match(MySQLParser::DO_SYMBOL);
    setState(3054);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 235, _ctx)) {
    case 1: {
      setState(3050);

      if (!(serverVersion < 50709)) throw FailedPredicateException(this, "serverVersion < 50709");
      setState(3051);
      exprList();
      break;
    }

    case 2: {
      setState(3052);

      if (!(serverVersion >= 50709)) throw FailedPredicateException(this, "serverVersion >= 50709");
      setState(3053);
      selectItemList();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- HandlerStatementContext ------------------------------------------------------------------

MySQLParser::HandlerStatementContext::HandlerStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::HandlerStatementContext::HANDLER_SYMBOL() {
  return getToken(MySQLParser::HANDLER_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::HandlerStatementContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

tree::TerminalNode* MySQLParser::HandlerStatementContext::OPEN_SYMBOL() {
  return getToken(MySQLParser::OPEN_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::HandlerStatementContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::HandlerStatementContext::CLOSE_SYMBOL() {
  return getToken(MySQLParser::CLOSE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::HandlerStatementContext::READ_SYMBOL() {
  return getToken(MySQLParser::READ_SYMBOL, 0);
}

MySQLParser::HandlerReadOrScanContext* MySQLParser::HandlerStatementContext::handlerReadOrScan() {
  return getRuleContext<MySQLParser::HandlerReadOrScanContext>(0);
}

MySQLParser::TableAliasContext* MySQLParser::HandlerStatementContext::tableAlias() {
  return getRuleContext<MySQLParser::TableAliasContext>(0);
}

MySQLParser::WhereClauseContext* MySQLParser::HandlerStatementContext::whereClause() {
  return getRuleContext<MySQLParser::WhereClauseContext>(0);
}

MySQLParser::LimitClauseContext* MySQLParser::HandlerStatementContext::limitClause() {
  return getRuleContext<MySQLParser::LimitClauseContext>(0);
}


size_t MySQLParser::HandlerStatementContext::getRuleIndex() const {
  return MySQLParser::RuleHandlerStatement;
}

void MySQLParser::HandlerStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterHandlerStatement(this);
}

void MySQLParser::HandlerStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitHandlerStatement(this);
}


std::any MySQLParser::HandlerStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitHandlerStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::HandlerStatementContext* MySQLParser::handlerStatement() {
  HandlerStatementContext *_localctx = _tracker.createInstance<HandlerStatementContext>(_ctx, getState());
  enterRule(_localctx, 242, MySQLParser::RuleHandlerStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3056);
    match(MySQLParser::HANDLER_SYMBOL);
    setState(3074);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 240, _ctx)) {
    case 1: {
      setState(3057);
      tableRef();
      setState(3058);
      match(MySQLParser::OPEN_SYMBOL);
      setState(3060);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 236, _ctx)) {
      case 1: {
        setState(3059);
        tableAlias();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(3062);
      identifier();
      setState(3072);
      _errHandler->sync(this);
      switch (_input->LA(1)) {
        case MySQLParser::CLOSE_SYMBOL: {
          setState(3063);
          match(MySQLParser::CLOSE_SYMBOL);
          break;
        }

        case MySQLParser::READ_SYMBOL: {
          setState(3064);
          match(MySQLParser::READ_SYMBOL);
          setState(3065);
          handlerReadOrScan();
          setState(3067);
          _errHandler->sync(this);

          _la = _input->LA(1);
          if (_la == MySQLParser::WHERE_SYMBOL) {
            setState(3066);
            whereClause();
          }
          setState(3070);
          _errHandler->sync(this);

          _la = _input->LA(1);
          if (_la == MySQLParser::LIMIT_SYMBOL) {
            setState(3069);
            limitClause();
          }
          break;
        }

      default:
        throw NoViableAltException(this);
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- HandlerReadOrScanContext ------------------------------------------------------------------

MySQLParser::HandlerReadOrScanContext::HandlerReadOrScanContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::FIRST_SYMBOL() {
  return getToken(MySQLParser::FIRST_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::NEXT_SYMBOL() {
  return getToken(MySQLParser::NEXT_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::HandlerReadOrScanContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

MySQLParser::ValuesContext* MySQLParser::HandlerReadOrScanContext::values() {
  return getRuleContext<MySQLParser::ValuesContext>(0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::PREV_SYMBOL() {
  return getToken(MySQLParser::PREV_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::LAST_SYMBOL() {
  return getToken(MySQLParser::LAST_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::LESS_THAN_OPERATOR() {
  return getToken(MySQLParser::LESS_THAN_OPERATOR, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::GREATER_THAN_OPERATOR() {
  return getToken(MySQLParser::GREATER_THAN_OPERATOR, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::LESS_OR_EQUAL_OPERATOR() {
  return getToken(MySQLParser::LESS_OR_EQUAL_OPERATOR, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::GREATER_OR_EQUAL_OPERATOR() {
  return getToken(MySQLParser::GREATER_OR_EQUAL_OPERATOR, 0);
}


size_t MySQLParser::HandlerReadOrScanContext::getRuleIndex() const {
  return MySQLParser::RuleHandlerReadOrScan;
}

void MySQLParser::HandlerReadOrScanContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterHandlerReadOrScan(this);
}

void MySQLParser::HandlerReadOrScanContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitHandlerReadOrScan(this);
}


std::any MySQLParser::HandlerReadOrScanContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitHandlerReadOrScan(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::HandlerReadOrScanContext* MySQLParser::handlerReadOrScan() {
  HandlerReadOrScanContext *_localctx = _tracker.createInstance<HandlerReadOrScanContext>(_ctx, getState());
  enterRule(_localctx, 244, MySQLParser::RuleHandlerReadOrScan);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3086);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 242, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3076);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::FIRST_SYMBOL || _la == MySQLParser::NEXT_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3077);
      identifier();
      setState(3084);
      _errHandler->sync(this);
      switch (_input->LA(1)) {
        case MySQLParser::FIRST_SYMBOL:
        case MySQLParser::LAST_SYMBOL:
        case MySQLParser::NEXT_SYMBOL:
        case MySQLParser::PREV_SYMBOL: {
          setState(3078);
          _la = _input->LA(1);
          if (!(_la == MySQLParser::FIRST_SYMBOL || _la == MySQLParser::LAST_SYMBOL || _la == MySQLParser::NEXT_SYMBOL

          || _la == MySQLParser::PREV_SYMBOL)) {
          _errHandler->recoverInline(this);
          }
          else {
            _errHandler->reportMatch(this);
            consume();
          }
          break;
        }

        case MySQLParser::EQUAL_OPERATOR:
        case MySQLParser::GREATER_OR_EQUAL_OPERATOR:
        case MySQLParser::GREATER_THAN_OPERATOR:
        case MySQLParser::LESS_OR_EQUAL_OPERATOR:
        case MySQLParser::LESS_THAN_OPERATOR: {
          setState(3079);
          _la = _input->LA(1);
          if (!((((_la & ~ 0x3fULL) == 0) &&
            ((1ULL << _la) & ((1ULL << MySQLParser::EQUAL_OPERATOR)
            | (1ULL << MySQLParser::GREATER_OR_EQUAL_OPERATOR)
            | (1ULL << MySQLParser::GREATER_THAN_OPERATOR)
            | (1ULL << MySQLParser::LESS_OR_EQUAL_OPERATOR)
            | (1ULL << MySQLParser::LESS_THAN_OPERATOR))) != 0))) {
          _errHandler->recoverInline(this);
          }
          else {
            _errHandler->reportMatch(this);
            consume();
          }
          setState(3080);
          match(MySQLParser::OPEN_PAR_SYMBOL);
          setState(3081);
          values();
          setState(3082);
          match(MySQLParser::CLOSE_PAR_SYMBOL);
          break;
        }

      default:
        throw NoViableAltException(this);
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InsertStatementContext ------------------------------------------------------------------

MySQLParser::InsertStatementContext::InsertStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::InsertStatementContext::INSERT_SYMBOL() {
  return getToken(MySQLParser::INSERT_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::InsertStatementContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::InsertFromConstructorContext* MySQLParser::InsertStatementContext::insertFromConstructor() {
  return getRuleContext<MySQLParser::InsertFromConstructorContext>(0);
}

tree::TerminalNode* MySQLParser::InsertStatementContext::SET_SYMBOL() {
  return getToken(MySQLParser::SET_SYMBOL, 0);
}

MySQLParser::UpdateListContext* MySQLParser::InsertStatementContext::updateList() {
  return getRuleContext<MySQLParser::UpdateListContext>(0);
}

MySQLParser::InsertQueryExpressionContext* MySQLParser::InsertStatementContext::insertQueryExpression() {
  return getRuleContext<MySQLParser::InsertQueryExpressionContext>(0);
}

MySQLParser::InsertLockOptionContext* MySQLParser::InsertStatementContext::insertLockOption() {
  return getRuleContext<MySQLParser::InsertLockOptionContext>(0);
}

tree::TerminalNode* MySQLParser::InsertStatementContext::IGNORE_SYMBOL() {
  return getToken(MySQLParser::IGNORE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertStatementContext::INTO_SYMBOL() {
  return getToken(MySQLParser::INTO_SYMBOL, 0);
}

MySQLParser::UsePartitionContext* MySQLParser::InsertStatementContext::usePartition() {
  return getRuleContext<MySQLParser::UsePartitionContext>(0);
}

MySQLParser::InsertUpdateListContext* MySQLParser::InsertStatementContext::insertUpdateList() {
  return getRuleContext<MySQLParser::InsertUpdateListContext>(0);
}

MySQLParser::ValuesReferenceContext* MySQLParser::InsertStatementContext::valuesReference() {
  return getRuleContext<MySQLParser::ValuesReferenceContext>(0);
}


size_t MySQLParser::InsertStatementContext::getRuleIndex() const {
  return MySQLParser::RuleInsertStatement;
}

void MySQLParser::InsertStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInsertStatement(this);
}

void MySQLParser::InsertStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInsertStatement(this);
}


std::any MySQLParser::InsertStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInsertStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InsertStatementContext* MySQLParser::insertStatement() {
  InsertStatementContext *_localctx = _tracker.createInstance<InsertStatementContext>(_ctx, getState());
  enterRule(_localctx, 246, MySQLParser::RuleInsertStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3088);
    match(MySQLParser::INSERT_SYMBOL);
    setState(3090);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 243, _ctx)) {
    case 1: {
      setState(3089);
      insertLockOption();
      break;
    }

    default:
      break;
    }
    setState(3093);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 244, _ctx)) {
    case 1: {
      setState(3092);
      match(MySQLParser::IGNORE_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(3096);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 245, _ctx)) {
    case 1: {
      setState(3095);
      match(MySQLParser::INTO_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(3098);
    tableRef();
    setState(3100);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 246, _ctx)) {
    case 1: {
      setState(3099);
      usePartition();
      break;
    }

    default:
      break;
    }
    setState(3112);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 249, _ctx)) {
    case 1: {
      setState(3102);
      insertFromConstructor();
      setState(3104);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 247, _ctx)) {
      case 1: {
        setState(3103);
        valuesReference();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(3106);
      match(MySQLParser::SET_SYMBOL);
      setState(3107);
      updateList();
      setState(3109);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 248, _ctx)) {
      case 1: {
        setState(3108);
        valuesReference();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 3: {
      setState(3111);
      insertQueryExpression();
      break;
    }

    default:
      break;
    }
    setState(3115);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ON_SYMBOL) {
      setState(3114);
      insertUpdateList();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InsertLockOptionContext ------------------------------------------------------------------

MySQLParser::InsertLockOptionContext::InsertLockOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::InsertLockOptionContext::LOW_PRIORITY_SYMBOL() {
  return getToken(MySQLParser::LOW_PRIORITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertLockOptionContext::DELAYED_SYMBOL() {
  return getToken(MySQLParser::DELAYED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertLockOptionContext::HIGH_PRIORITY_SYMBOL() {
  return getToken(MySQLParser::HIGH_PRIORITY_SYMBOL, 0);
}


size_t MySQLParser::InsertLockOptionContext::getRuleIndex() const {
  return MySQLParser::RuleInsertLockOption;
}

void MySQLParser::InsertLockOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInsertLockOption(this);
}

void MySQLParser::InsertLockOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInsertLockOption(this);
}


std::any MySQLParser::InsertLockOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInsertLockOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InsertLockOptionContext* MySQLParser::insertLockOption() {
  InsertLockOptionContext *_localctx = _tracker.createInstance<InsertLockOptionContext>(_ctx, getState());
  enterRule(_localctx, 248, MySQLParser::RuleInsertLockOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3117);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::DELAYED_SYMBOL || _la == MySQLParser::HIGH_PRIORITY_SYMBOL || _la == MySQLParser::LOW_PRIORITY_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InsertFromConstructorContext ------------------------------------------------------------------

MySQLParser::InsertFromConstructorContext::InsertFromConstructorContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::InsertValuesContext* MySQLParser::InsertFromConstructorContext::insertValues() {
  return getRuleContext<MySQLParser::InsertValuesContext>(0);
}

tree::TerminalNode* MySQLParser::InsertFromConstructorContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertFromConstructorContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::FieldsContext* MySQLParser::InsertFromConstructorContext::fields() {
  return getRuleContext<MySQLParser::FieldsContext>(0);
}


size_t MySQLParser::InsertFromConstructorContext::getRuleIndex() const {
  return MySQLParser::RuleInsertFromConstructor;
}

void MySQLParser::InsertFromConstructorContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInsertFromConstructor(this);
}

void MySQLParser::InsertFromConstructorContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInsertFromConstructor(this);
}


std::any MySQLParser::InsertFromConstructorContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInsertFromConstructor(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InsertFromConstructorContext* MySQLParser::insertFromConstructor() {
  InsertFromConstructorContext *_localctx = _tracker.createInstance<InsertFromConstructorContext>(_ctx, getState());
  enterRule(_localctx, 250, MySQLParser::RuleInsertFromConstructor);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3124);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OPEN_PAR_SYMBOL) {
      setState(3119);
      match(MySQLParser::OPEN_PAR_SYMBOL);
      setState(3121);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 251, _ctx)) {
      case 1: {
        setState(3120);
        fields();
        break;
      }

      default:
        break;
      }
      setState(3123);
      match(MySQLParser::CLOSE_PAR_SYMBOL);
    }
    setState(3126);
    insertValues();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- FieldsContext ------------------------------------------------------------------

MySQLParser::FieldsContext::FieldsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::InsertIdentifierContext *> MySQLParser::FieldsContext::insertIdentifier() {
  return getRuleContexts<MySQLParser::InsertIdentifierContext>();
}

MySQLParser::InsertIdentifierContext* MySQLParser::FieldsContext::insertIdentifier(size_t i) {
  return getRuleContext<MySQLParser::InsertIdentifierContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::FieldsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::FieldsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::FieldsContext::getRuleIndex() const {
  return MySQLParser::RuleFields;
}

void MySQLParser::FieldsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterFields(this);
}

void MySQLParser::FieldsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitFields(this);
}


std::any MySQLParser::FieldsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitFields(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::FieldsContext* MySQLParser::fields() {
  FieldsContext *_localctx = _tracker.createInstance<FieldsContext>(_ctx, getState());
  enterRule(_localctx, 252, MySQLParser::RuleFields);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3128);
    insertIdentifier();
    setState(3133);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(3129);
      match(MySQLParser::COMMA_SYMBOL);
      setState(3130);
      insertIdentifier();
      setState(3135);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InsertValuesContext ------------------------------------------------------------------

MySQLParser::InsertValuesContext::InsertValuesContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::ValueListContext* MySQLParser::InsertValuesContext::valueList() {
  return getRuleContext<MySQLParser::ValueListContext>(0);
}

tree::TerminalNode* MySQLParser::InsertValuesContext::VALUES_SYMBOL() {
  return getToken(MySQLParser::VALUES_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertValuesContext::VALUE_SYMBOL() {
  return getToken(MySQLParser::VALUE_SYMBOL, 0);
}


size_t MySQLParser::InsertValuesContext::getRuleIndex() const {
  return MySQLParser::RuleInsertValues;
}

void MySQLParser::InsertValuesContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInsertValues(this);
}

void MySQLParser::InsertValuesContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInsertValues(this);
}


std::any MySQLParser::InsertValuesContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInsertValues(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InsertValuesContext* MySQLParser::insertValues() {
  InsertValuesContext *_localctx = _tracker.createInstance<InsertValuesContext>(_ctx, getState());
  enterRule(_localctx, 254, MySQLParser::RuleInsertValues);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3136);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::VALUES_SYMBOL

    || _la == MySQLParser::VALUE_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(3137);
    valueList();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InsertQueryExpressionContext ------------------------------------------------------------------

MySQLParser::InsertQueryExpressionContext::InsertQueryExpressionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionContext* MySQLParser::InsertQueryExpressionContext::queryExpression() {
  return getRuleContext<MySQLParser::QueryExpressionContext>(0);
}

MySQLParser::QueryExpressionParensContext* MySQLParser::InsertQueryExpressionContext::queryExpressionParens() {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(0);
}

MySQLParser::QueryExpressionWithOptLockingClausesContext* MySQLParser::InsertQueryExpressionContext::queryExpressionWithOptLockingClauses() {
  return getRuleContext<MySQLParser::QueryExpressionWithOptLockingClausesContext>(0);
}

tree::TerminalNode* MySQLParser::InsertQueryExpressionContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertQueryExpressionContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::FieldsContext* MySQLParser::InsertQueryExpressionContext::fields() {
  return getRuleContext<MySQLParser::FieldsContext>(0);
}


size_t MySQLParser::InsertQueryExpressionContext::getRuleIndex() const {
  return MySQLParser::RuleInsertQueryExpression;
}

void MySQLParser::InsertQueryExpressionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInsertQueryExpression(this);
}

void MySQLParser::InsertQueryExpressionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInsertQueryExpression(this);
}


std::any MySQLParser::InsertQueryExpressionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInsertQueryExpression(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InsertQueryExpressionContext* MySQLParser::insertQueryExpression() {
  InsertQueryExpressionContext *_localctx = _tracker.createInstance<InsertQueryExpressionContext>(_ctx, getState());
  enterRule(_localctx, 256, MySQLParser::RuleInsertQueryExpression);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3149);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 256, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3139);
      queryExpression();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3140);
      queryExpressionParens();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(3146);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 255, _ctx)) {
      case 1: {
        setState(3141);
        match(MySQLParser::OPEN_PAR_SYMBOL);
        setState(3143);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 254, _ctx)) {
        case 1: {
          setState(3142);
          fields();
          break;
        }

        default:
          break;
        }
        setState(3145);
        match(MySQLParser::CLOSE_PAR_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(3148);
      queryExpressionWithOptLockingClauses();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ValueListContext ------------------------------------------------------------------

MySQLParser::ValueListContext::ValueListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<tree::TerminalNode *> MySQLParser::ValueListContext::OPEN_PAR_SYMBOL() {
  return getTokens(MySQLParser::OPEN_PAR_SYMBOL);
}

tree::TerminalNode* MySQLParser::ValueListContext::OPEN_PAR_SYMBOL(size_t i) {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, i);
}

std::vector<tree::TerminalNode *> MySQLParser::ValueListContext::CLOSE_PAR_SYMBOL() {
  return getTokens(MySQLParser::CLOSE_PAR_SYMBOL);
}

tree::TerminalNode* MySQLParser::ValueListContext::CLOSE_PAR_SYMBOL(size_t i) {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, i);
}

std::vector<MySQLParser::ValuesContext *> MySQLParser::ValueListContext::values() {
  return getRuleContexts<MySQLParser::ValuesContext>();
}

MySQLParser::ValuesContext* MySQLParser::ValueListContext::values(size_t i) {
  return getRuleContext<MySQLParser::ValuesContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::ValueListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::ValueListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::ValueListContext::getRuleIndex() const {
  return MySQLParser::RuleValueList;
}

void MySQLParser::ValueListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterValueList(this);
}

void MySQLParser::ValueListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitValueList(this);
}


std::any MySQLParser::ValueListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitValueList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ValueListContext* MySQLParser::valueList() {
  ValueListContext *_localctx = _tracker.createInstance<ValueListContext>(_ctx, getState());
  enterRule(_localctx, 258, MySQLParser::RuleValueList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3151);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3153);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 257, _ctx)) {
    case 1: {
      setState(3152);
      values();
      break;
    }

    default:
      break;
    }
    setState(3155);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
    setState(3164);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 259, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3156);
        match(MySQLParser::COMMA_SYMBOL);
        setState(3157);
        match(MySQLParser::OPEN_PAR_SYMBOL);
        setState(3159);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 258, _ctx)) {
        case 1: {
          setState(3158);
          values();
          break;
        }

        default:
          break;
        }
        setState(3161);
        match(MySQLParser::CLOSE_PAR_SYMBOL); 
      }
      setState(3166);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 259, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ValuesContext ------------------------------------------------------------------

MySQLParser::ValuesContext::ValuesContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::ExprContext *> MySQLParser::ValuesContext::expr() {
  return getRuleContexts<MySQLParser::ExprContext>();
}

MySQLParser::ExprContext* MySQLParser::ValuesContext::expr(size_t i) {
  return getRuleContext<MySQLParser::ExprContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::ValuesContext::DEFAULT_SYMBOL() {
  return getTokens(MySQLParser::DEFAULT_SYMBOL);
}

tree::TerminalNode* MySQLParser::ValuesContext::DEFAULT_SYMBOL(size_t i) {
  return getToken(MySQLParser::DEFAULT_SYMBOL, i);
}

std::vector<tree::TerminalNode *> MySQLParser::ValuesContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::ValuesContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::ValuesContext::getRuleIndex() const {
  return MySQLParser::RuleValues;
}

void MySQLParser::ValuesContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterValues(this);
}

void MySQLParser::ValuesContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitValues(this);
}


std::any MySQLParser::ValuesContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitValues(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ValuesContext* MySQLParser::values() {
  ValuesContext *_localctx = _tracker.createInstance<ValuesContext>(_ctx, getState());
  enterRule(_localctx, 260, MySQLParser::RuleValues);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3169);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 260, _ctx)) {
    case 1: {
      setState(3167);
      expr(0);
      break;
    }

    case 2: {
      setState(3168);
      match(MySQLParser::DEFAULT_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(3178);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(3171);
      match(MySQLParser::COMMA_SYMBOL);
      setState(3174);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 261, _ctx)) {
      case 1: {
        setState(3172);
        expr(0);
        break;
      }

      case 2: {
        setState(3173);
        match(MySQLParser::DEFAULT_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(3180);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ValuesReferenceContext ------------------------------------------------------------------

MySQLParser::ValuesReferenceContext::ValuesReferenceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ValuesReferenceContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::ValuesReferenceContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

MySQLParser::ColumnInternalRefListContext* MySQLParser::ValuesReferenceContext::columnInternalRefList() {
  return getRuleContext<MySQLParser::ColumnInternalRefListContext>(0);
}


size_t MySQLParser::ValuesReferenceContext::getRuleIndex() const {
  return MySQLParser::RuleValuesReference;
}

void MySQLParser::ValuesReferenceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterValuesReference(this);
}

void MySQLParser::ValuesReferenceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitValuesReference(this);
}


std::any MySQLParser::ValuesReferenceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitValuesReference(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ValuesReferenceContext* MySQLParser::valuesReference() {
  ValuesReferenceContext *_localctx = _tracker.createInstance<ValuesReferenceContext>(_ctx, getState());
  enterRule(_localctx, 262, MySQLParser::RuleValuesReference);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3181);

    if (!( serverVersion >= 80018)) throw FailedPredicateException(this, " serverVersion >= 80018");
    setState(3182);
    match(MySQLParser::AS_SYMBOL);
    setState(3183);
    identifier();
    setState(3185);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OPEN_PAR_SYMBOL) {
      setState(3184);
      columnInternalRefList();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InsertUpdateListContext ------------------------------------------------------------------

MySQLParser::InsertUpdateListContext::InsertUpdateListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::InsertUpdateListContext::ON_SYMBOL() {
  return getToken(MySQLParser::ON_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertUpdateListContext::DUPLICATE_SYMBOL() {
  return getToken(MySQLParser::DUPLICATE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertUpdateListContext::KEY_SYMBOL() {
  return getToken(MySQLParser::KEY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertUpdateListContext::UPDATE_SYMBOL() {
  return getToken(MySQLParser::UPDATE_SYMBOL, 0);
}

MySQLParser::UpdateListContext* MySQLParser::InsertUpdateListContext::updateList() {
  return getRuleContext<MySQLParser::UpdateListContext>(0);
}


size_t MySQLParser::InsertUpdateListContext::getRuleIndex() const {
  return MySQLParser::RuleInsertUpdateList;
}

void MySQLParser::InsertUpdateListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInsertUpdateList(this);
}

void MySQLParser::InsertUpdateListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInsertUpdateList(this);
}


std::any MySQLParser::InsertUpdateListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInsertUpdateList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InsertUpdateListContext* MySQLParser::insertUpdateList() {
  InsertUpdateListContext *_localctx = _tracker.createInstance<InsertUpdateListContext>(_ctx, getState());
  enterRule(_localctx, 264, MySQLParser::RuleInsertUpdateList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3187);
    match(MySQLParser::ON_SYMBOL);
    setState(3188);
    match(MySQLParser::DUPLICATE_SYMBOL);
    setState(3189);
    match(MySQLParser::KEY_SYMBOL);
    setState(3190);
    match(MySQLParser::UPDATE_SYMBOL);
    setState(3191);
    updateList();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LoadStatementContext ------------------------------------------------------------------

MySQLParser::LoadStatementContext::LoadStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LoadStatementContext::LOAD_SYMBOL() {
  return getToken(MySQLParser::LOAD_SYMBOL, 0);
}

MySQLParser::DataOrXmlContext* MySQLParser::LoadStatementContext::dataOrXml() {
  return getRuleContext<MySQLParser::DataOrXmlContext>(0);
}

MySQLParser::TextStringLiteralContext* MySQLParser::LoadStatementContext::textStringLiteral() {
  return getRuleContext<MySQLParser::TextStringLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::INTO_SYMBOL() {
  return getToken(MySQLParser::INTO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::LoadStatementContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::LoadDataFileTailContext* MySQLParser::LoadStatementContext::loadDataFileTail() {
  return getRuleContext<MySQLParser::LoadDataFileTailContext>(0);
}

MySQLParser::LoadDataLockContext* MySQLParser::LoadStatementContext::loadDataLock() {
  return getRuleContext<MySQLParser::LoadDataLockContext>(0);
}

MySQLParser::LoadFromContext* MySQLParser::LoadStatementContext::loadFrom() {
  return getRuleContext<MySQLParser::LoadFromContext>(0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::LOCAL_SYMBOL() {
  return getToken(MySQLParser::LOCAL_SYMBOL, 0);
}

MySQLParser::LoadSourceTypeContext* MySQLParser::LoadStatementContext::loadSourceType() {
  return getRuleContext<MySQLParser::LoadSourceTypeContext>(0);
}

MySQLParser::SourceCountContext* MySQLParser::LoadStatementContext::sourceCount() {
  return getRuleContext<MySQLParser::SourceCountContext>(0);
}

MySQLParser::SourceOrderContext* MySQLParser::LoadStatementContext::sourceOrder() {
  return getRuleContext<MySQLParser::SourceOrderContext>(0);
}

MySQLParser::UsePartitionContext* MySQLParser::LoadStatementContext::usePartition() {
  return getRuleContext<MySQLParser::UsePartitionContext>(0);
}

MySQLParser::CharsetClauseContext* MySQLParser::LoadStatementContext::charsetClause() {
  return getRuleContext<MySQLParser::CharsetClauseContext>(0);
}

MySQLParser::XmlRowsIdentifiedByContext* MySQLParser::LoadStatementContext::xmlRowsIdentifiedBy() {
  return getRuleContext<MySQLParser::XmlRowsIdentifiedByContext>(0);
}

MySQLParser::FieldsClauseContext* MySQLParser::LoadStatementContext::fieldsClause() {
  return getRuleContext<MySQLParser::FieldsClauseContext>(0);
}

MySQLParser::LinesClauseContext* MySQLParser::LoadStatementContext::linesClause() {
  return getRuleContext<MySQLParser::LinesClauseContext>(0);
}

MySQLParser::LoadParallelContext* MySQLParser::LoadStatementContext::loadParallel() {
  return getRuleContext<MySQLParser::LoadParallelContext>(0);
}

MySQLParser::LoadMemoryContext* MySQLParser::LoadStatementContext::loadMemory() {
  return getRuleContext<MySQLParser::LoadMemoryContext>(0);
}

MySQLParser::LoadAlgorithmContext* MySQLParser::LoadStatementContext::loadAlgorithm() {
  return getRuleContext<MySQLParser::LoadAlgorithmContext>(0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::REPLACE_SYMBOL() {
  return getToken(MySQLParser::REPLACE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::IGNORE_SYMBOL() {
  return getToken(MySQLParser::IGNORE_SYMBOL, 0);
}


size_t MySQLParser::LoadStatementContext::getRuleIndex() const {
  return MySQLParser::RuleLoadStatement;
}

void MySQLParser::LoadStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLoadStatement(this);
}

void MySQLParser::LoadStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLoadStatement(this);
}


std::any MySQLParser::LoadStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLoadStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LoadStatementContext* MySQLParser::loadStatement() {
  LoadStatementContext *_localctx = _tracker.createInstance<LoadStatementContext>(_ctx, getState());
  enterRule(_localctx, 266, MySQLParser::RuleLoadStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3193);
    match(MySQLParser::LOAD_SYMBOL);
    setState(3194);
    dataOrXml();
    setState(3196);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 264, _ctx)) {
    case 1: {
      setState(3195);
      loadDataLock();
      break;
    }

    default:
      break;
    }
    setState(3199);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 265, _ctx)) {
    case 1: {
      setState(3198);
      loadFrom();
      break;
    }

    default:
      break;
    }
    setState(3202);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 266, _ctx)) {
    case 1: {
      setState(3201);
      match(MySQLParser::LOCAL_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(3205);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 267, _ctx)) {
    case 1: {
      setState(3204);
      loadSourceType();
      break;
    }

    default:
      break;
    }
    setState(3207);
    textStringLiteral();
    setState(3209);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 268, _ctx)) {
    case 1: {
      setState(3208);
      sourceCount();
      break;
    }

    default:
      break;
    }
    setState(3212);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 269, _ctx)) {
    case 1: {
      setState(3211);
      sourceOrder();
      break;
    }

    default:
      break;
    }
    setState(3215);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::IGNORE_SYMBOL || _la == MySQLParser::REPLACE_SYMBOL) {
      setState(3214);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::IGNORE_SYMBOL || _la == MySQLParser::REPLACE_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
    }
    setState(3217);
    match(MySQLParser::INTO_SYMBOL);
    setState(3218);
    match(MySQLParser::TABLE_SYMBOL);
    setState(3219);
    tableRef();
    setState(3221);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 271, _ctx)) {
    case 1: {
      setState(3220);
      usePartition();
      break;
    }

    default:
      break;
    }
    setState(3224);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 272, _ctx)) {
    case 1: {
      setState(3223);
      charsetClause();
      break;
    }

    default:
      break;
    }
    setState(3227);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 273, _ctx)) {
    case 1: {
      setState(3226);
      xmlRowsIdentifiedBy();
      break;
    }

    default:
      break;
    }
    setState(3230);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 274, _ctx)) {
    case 1: {
      setState(3229);
      fieldsClause();
      break;
    }

    default:
      break;
    }
    setState(3233);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 275, _ctx)) {
    case 1: {
      setState(3232);
      linesClause();
      break;
    }

    default:
      break;
    }
    setState(3235);
    loadDataFileTail();
    setState(3237);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 276, _ctx)) {
    case 1: {
      setState(3236);
      loadParallel();
      break;
    }

    default:
      break;
    }
    setState(3240);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 277, _ctx)) {
    case 1: {
      setState(3239);
      loadMemory();
      break;
    }

    default:
      break;
    }
    setState(3243);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 278, _ctx)) {
    case 1: {
      setState(3242);
      loadAlgorithm();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DataOrXmlContext ------------------------------------------------------------------

MySQLParser::DataOrXmlContext::DataOrXmlContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DataOrXmlContext::DATA_SYMBOL() {
  return getToken(MySQLParser::DATA_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DataOrXmlContext::XML_SYMBOL() {
  return getToken(MySQLParser::XML_SYMBOL, 0);
}


size_t MySQLParser::DataOrXmlContext::getRuleIndex() const {
  return MySQLParser::RuleDataOrXml;
}

void MySQLParser::DataOrXmlContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDataOrXml(this);
}

void MySQLParser::DataOrXmlContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDataOrXml(this);
}


std::any MySQLParser::DataOrXmlContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDataOrXml(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DataOrXmlContext* MySQLParser::dataOrXml() {
  DataOrXmlContext *_localctx = _tracker.createInstance<DataOrXmlContext>(_ctx, getState());
  enterRule(_localctx, 268, MySQLParser::RuleDataOrXml);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3245);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::DATA_SYMBOL || _la == MySQLParser::XML_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LoadDataLockContext ------------------------------------------------------------------

MySQLParser::LoadDataLockContext::LoadDataLockContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LoadDataLockContext::LOW_PRIORITY_SYMBOL() {
  return getToken(MySQLParser::LOW_PRIORITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadDataLockContext::CONCURRENT_SYMBOL() {
  return getToken(MySQLParser::CONCURRENT_SYMBOL, 0);
}


size_t MySQLParser::LoadDataLockContext::getRuleIndex() const {
  return MySQLParser::RuleLoadDataLock;
}

void MySQLParser::LoadDataLockContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLoadDataLock(this);
}

void MySQLParser::LoadDataLockContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLoadDataLock(this);
}


std::any MySQLParser::LoadDataLockContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLoadDataLock(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LoadDataLockContext* MySQLParser::loadDataLock() {
  LoadDataLockContext *_localctx = _tracker.createInstance<LoadDataLockContext>(_ctx, getState());
  enterRule(_localctx, 270, MySQLParser::RuleLoadDataLock);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3247);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::CONCURRENT_SYMBOL || _la == MySQLParser::LOW_PRIORITY_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LoadFromContext ------------------------------------------------------------------

MySQLParser::LoadFromContext::LoadFromContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LoadFromContext::FROM_SYMBOL() {
  return getToken(MySQLParser::FROM_SYMBOL, 0);
}


size_t MySQLParser::LoadFromContext::getRuleIndex() const {
  return MySQLParser::RuleLoadFrom;
}

void MySQLParser::LoadFromContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLoadFrom(this);
}

void MySQLParser::LoadFromContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLoadFrom(this);
}


std::any MySQLParser::LoadFromContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLoadFrom(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LoadFromContext* MySQLParser::loadFrom() {
  LoadFromContext *_localctx = _tracker.createInstance<LoadFromContext>(_ctx, getState());
  enterRule(_localctx, 272, MySQLParser::RuleLoadFrom);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3249);

    if (!(serverVersion >= 80200)) throw FailedPredicateException(this, "serverVersion >= 80200");
    setState(3250);
    match(MySQLParser::FROM_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LoadSourceTypeContext ------------------------------------------------------------------

MySQLParser::LoadSourceTypeContext::LoadSourceTypeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LoadSourceTypeContext::INFILE_SYMBOL() {
  return getToken(MySQLParser::INFILE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadSourceTypeContext::URL_SYMBOL() {
  return getToken(MySQLParser::URL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadSourceTypeContext::S3_SYMBOL() {
  return getToken(MySQLParser::S3_SYMBOL, 0);
}


size_t MySQLParser::LoadSourceTypeContext::getRuleIndex() const {
  return MySQLParser::RuleLoadSourceType;
}

void MySQLParser::LoadSourceTypeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLoadSourceType(this);
}

void MySQLParser::LoadSourceTypeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLoadSourceType(this);
}


std::any MySQLParser::LoadSourceTypeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLoadSourceType(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LoadSourceTypeContext* MySQLParser::loadSourceType() {
  LoadSourceTypeContext *_localctx = _tracker.createInstance<LoadSourceTypeContext>(_ctx, getState());
  enterRule(_localctx, 274, MySQLParser::RuleLoadSourceType);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3255);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 279, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3252);
      match(MySQLParser::INFILE_SYMBOL);
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3253);

      if (!(serverVersion >= 80200)) throw FailedPredicateException(this, "serverVersion >= 80200");
      setState(3254);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::URL_SYMBOL

      || _la == MySQLParser::S3_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SourceCountContext ------------------------------------------------------------------

MySQLParser::SourceCountContext::SourceCountContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::SourceCountContext::COUNT_SYMBOL() {
  return getToken(MySQLParser::COUNT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SourceCountContext::INT_NUMBER() {
  return getToken(MySQLParser::INT_NUMBER, 0);
}

MySQLParser::PureIdentifierContext* MySQLParser::SourceCountContext::pureIdentifier() {
  return getRuleContext<MySQLParser::PureIdentifierContext>(0);
}


size_t MySQLParser::SourceCountContext::getRuleIndex() const {
  return MySQLParser::RuleSourceCount;
}

void MySQLParser::SourceCountContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSourceCount(this);
}

void MySQLParser::SourceCountContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSourceCount(this);
}


std::any MySQLParser::SourceCountContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSourceCount(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SourceCountContext* MySQLParser::sourceCount() {
  SourceCountContext *_localctx = _tracker.createInstance<SourceCountContext>(_ctx, getState());
  enterRule(_localctx, 276, MySQLParser::RuleSourceCount);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3257);

    if (!(serverVersion >= 80200)) throw FailedPredicateException(this, "serverVersion >= 80200");
    setState(3263);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 280, _ctx)) {
    case 1: {
      setState(3258);
      match(MySQLParser::COUNT_SYMBOL);
      setState(3259);
      match(MySQLParser::INT_NUMBER);
      break;
    }

    case 2: {
      setState(3260);
      pureIdentifier();
      setState(3261);
      match(MySQLParser::INT_NUMBER);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SourceOrderContext ------------------------------------------------------------------

MySQLParser::SourceOrderContext::SourceOrderContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::SourceOrderContext::IN_SYMBOL() {
  return getToken(MySQLParser::IN_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SourceOrderContext::PRIMARY_SYMBOL() {
  return getToken(MySQLParser::PRIMARY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SourceOrderContext::KEY_SYMBOL() {
  return getToken(MySQLParser::KEY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SourceOrderContext::ORDER_SYMBOL() {
  return getToken(MySQLParser::ORDER_SYMBOL, 0);
}


size_t MySQLParser::SourceOrderContext::getRuleIndex() const {
  return MySQLParser::RuleSourceOrder;
}

void MySQLParser::SourceOrderContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSourceOrder(this);
}

void MySQLParser::SourceOrderContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSourceOrder(this);
}


std::any MySQLParser::SourceOrderContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSourceOrder(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SourceOrderContext* MySQLParser::sourceOrder() {
  SourceOrderContext *_localctx = _tracker.createInstance<SourceOrderContext>(_ctx, getState());
  enterRule(_localctx, 278, MySQLParser::RuleSourceOrder);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3265);

    if (!(serverVersion >= 80200)) throw FailedPredicateException(this, "serverVersion >= 80200");
    setState(3266);
    match(MySQLParser::IN_SYMBOL);
    setState(3267);
    match(MySQLParser::PRIMARY_SYMBOL);
    setState(3268);
    match(MySQLParser::KEY_SYMBOL);
    setState(3269);
    match(MySQLParser::ORDER_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- XmlRowsIdentifiedByContext ------------------------------------------------------------------

MySQLParser::XmlRowsIdentifiedByContext::XmlRowsIdentifiedByContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::XmlRowsIdentifiedByContext::ROWS_SYMBOL() {
  return getToken(MySQLParser::ROWS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::XmlRowsIdentifiedByContext::IDENTIFIED_SYMBOL() {
  return getToken(MySQLParser::IDENTIFIED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::XmlRowsIdentifiedByContext::BY_SYMBOL() {
  return getToken(MySQLParser::BY_SYMBOL, 0);
}

MySQLParser::TextStringContext* MySQLParser::XmlRowsIdentifiedByContext::textString() {
  return getRuleContext<MySQLParser::TextStringContext>(0);
}


size_t MySQLParser::XmlRowsIdentifiedByContext::getRuleIndex() const {
  return MySQLParser::RuleXmlRowsIdentifiedBy;
}

void MySQLParser::XmlRowsIdentifiedByContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterXmlRowsIdentifiedBy(this);
}

void MySQLParser::XmlRowsIdentifiedByContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitXmlRowsIdentifiedBy(this);
}


std::any MySQLParser::XmlRowsIdentifiedByContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitXmlRowsIdentifiedBy(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::XmlRowsIdentifiedByContext* MySQLParser::xmlRowsIdentifiedBy() {
  XmlRowsIdentifiedByContext *_localctx = _tracker.createInstance<XmlRowsIdentifiedByContext>(_ctx, getState());
  enterRule(_localctx, 280, MySQLParser::RuleXmlRowsIdentifiedBy);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3271);
    match(MySQLParser::ROWS_SYMBOL);
    setState(3272);
    match(MySQLParser::IDENTIFIED_SYMBOL);
    setState(3273);
    match(MySQLParser::BY_SYMBOL);
    setState(3274);
    textString();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LoadDataFileTailContext ------------------------------------------------------------------

MySQLParser::LoadDataFileTailContext::LoadDataFileTailContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LoadDataFileTailContext::IGNORE_SYMBOL() {
  return getToken(MySQLParser::IGNORE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadDataFileTailContext::INT_NUMBER() {
  return getToken(MySQLParser::INT_NUMBER, 0);
}

MySQLParser::LoadDataFileTargetListContext* MySQLParser::LoadDataFileTailContext::loadDataFileTargetList() {
  return getRuleContext<MySQLParser::LoadDataFileTargetListContext>(0);
}

tree::TerminalNode* MySQLParser::LoadDataFileTailContext::SET_SYMBOL() {
  return getToken(MySQLParser::SET_SYMBOL, 0);
}

MySQLParser::UpdateListContext* MySQLParser::LoadDataFileTailContext::updateList() {
  return getRuleContext<MySQLParser::UpdateListContext>(0);
}

tree::TerminalNode* MySQLParser::LoadDataFileTailContext::LINES_SYMBOL() {
  return getToken(MySQLParser::LINES_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadDataFileTailContext::ROWS_SYMBOL() {
  return getToken(MySQLParser::ROWS_SYMBOL, 0);
}


size_t MySQLParser::LoadDataFileTailContext::getRuleIndex() const {
  return MySQLParser::RuleLoadDataFileTail;
}

void MySQLParser::LoadDataFileTailContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLoadDataFileTail(this);
}

void MySQLParser::LoadDataFileTailContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLoadDataFileTail(this);
}


std::any MySQLParser::LoadDataFileTailContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLoadDataFileTail(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LoadDataFileTailContext* MySQLParser::loadDataFileTail() {
  LoadDataFileTailContext *_localctx = _tracker.createInstance<LoadDataFileTailContext>(_ctx, getState());
  enterRule(_localctx, 282, MySQLParser::RuleLoadDataFileTail);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3279);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 281, _ctx)) {
    case 1: {
      setState(3276);
      match(MySQLParser::IGNORE_SYMBOL);
      setState(3277);
      match(MySQLParser::INT_NUMBER);
      setState(3278);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::LINES_SYMBOL || _la == MySQLParser::ROWS_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      break;
    }

    default:
      break;
    }
    setState(3282);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 282, _ctx)) {
    case 1: {
      setState(3281);
      loadDataFileTargetList();
      break;
    }

    default:
      break;
    }
    setState(3286);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 283, _ctx)) {
    case 1: {
      setState(3284);
      match(MySQLParser::SET_SYMBOL);
      setState(3285);
      updateList();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LoadDataFileTargetListContext ------------------------------------------------------------------

MySQLParser::LoadDataFileTargetListContext::LoadDataFileTargetListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LoadDataFileTargetListContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadDataFileTargetListContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::FieldOrVariableListContext* MySQLParser::LoadDataFileTargetListContext::fieldOrVariableList() {
  return getRuleContext<MySQLParser::FieldOrVariableListContext>(0);
}


size_t MySQLParser::LoadDataFileTargetListContext::getRuleIndex() const {
  return MySQLParser::RuleLoadDataFileTargetList;
}

void MySQLParser::LoadDataFileTargetListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLoadDataFileTargetList(this);
}

void MySQLParser::LoadDataFileTargetListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLoadDataFileTargetList(this);
}


std::any MySQLParser::LoadDataFileTargetListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLoadDataFileTargetList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LoadDataFileTargetListContext* MySQLParser::loadDataFileTargetList() {
  LoadDataFileTargetListContext *_localctx = _tracker.createInstance<LoadDataFileTargetListContext>(_ctx, getState());
  enterRule(_localctx, 284, MySQLParser::RuleLoadDataFileTargetList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3288);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3290);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 284, _ctx)) {
    case 1: {
      setState(3289);
      fieldOrVariableList();
      break;
    }

    default:
      break;
    }
    setState(3292);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- FieldOrVariableListContext ------------------------------------------------------------------

MySQLParser::FieldOrVariableListContext::FieldOrVariableListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::ColumnRefContext *> MySQLParser::FieldOrVariableListContext::columnRef() {
  return getRuleContexts<MySQLParser::ColumnRefContext>();
}

MySQLParser::ColumnRefContext* MySQLParser::FieldOrVariableListContext::columnRef(size_t i) {
  return getRuleContext<MySQLParser::ColumnRefContext>(i);
}

std::vector<MySQLParser::UserVariableContext *> MySQLParser::FieldOrVariableListContext::userVariable() {
  return getRuleContexts<MySQLParser::UserVariableContext>();
}

MySQLParser::UserVariableContext* MySQLParser::FieldOrVariableListContext::userVariable(size_t i) {
  return getRuleContext<MySQLParser::UserVariableContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::FieldOrVariableListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::FieldOrVariableListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::FieldOrVariableListContext::getRuleIndex() const {
  return MySQLParser::RuleFieldOrVariableList;
}

void MySQLParser::FieldOrVariableListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterFieldOrVariableList(this);
}

void MySQLParser::FieldOrVariableListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitFieldOrVariableList(this);
}


std::any MySQLParser::FieldOrVariableListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitFieldOrVariableList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::FieldOrVariableListContext* MySQLParser::fieldOrVariableList() {
  FieldOrVariableListContext *_localctx = _tracker.createInstance<FieldOrVariableListContext>(_ctx, getState());
  enterRule(_localctx, 286, MySQLParser::RuleFieldOrVariableList);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3296);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 285, _ctx)) {
    case 1: {
      setState(3294);
      columnRef();
      break;
    }

    case 2: {
      setState(3295);
      userVariable();
      break;
    }

    default:
      break;
    }
    setState(3305);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(3298);
      match(MySQLParser::COMMA_SYMBOL);
      setState(3301);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 286, _ctx)) {
      case 1: {
        setState(3299);
        columnRef();
        break;
      }

      case 2: {
        setState(3300);
        userVariable();
        break;
      }

      default:
        break;
      }
      setState(3307);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LoadAlgorithmContext ------------------------------------------------------------------

MySQLParser::LoadAlgorithmContext::LoadAlgorithmContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LoadAlgorithmContext::ALGORITHM_SYMBOL() {
  return getToken(MySQLParser::ALGORITHM_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadAlgorithmContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}

tree::TerminalNode* MySQLParser::LoadAlgorithmContext::BULK_SYMBOL() {
  return getToken(MySQLParser::BULK_SYMBOL, 0);
}


size_t MySQLParser::LoadAlgorithmContext::getRuleIndex() const {
  return MySQLParser::RuleLoadAlgorithm;
}

void MySQLParser::LoadAlgorithmContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLoadAlgorithm(this);
}

void MySQLParser::LoadAlgorithmContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLoadAlgorithm(this);
}


std::any MySQLParser::LoadAlgorithmContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLoadAlgorithm(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LoadAlgorithmContext* MySQLParser::loadAlgorithm() {
  LoadAlgorithmContext *_localctx = _tracker.createInstance<LoadAlgorithmContext>(_ctx, getState());
  enterRule(_localctx, 288, MySQLParser::RuleLoadAlgorithm);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3308);

    if (!(serverVersion >= 80200)) throw FailedPredicateException(this, "serverVersion >= 80200");
    setState(3309);
    match(MySQLParser::ALGORITHM_SYMBOL);
    setState(3310);
    match(MySQLParser::EQUAL_OPERATOR);
    setState(3311);
    match(MySQLParser::BULK_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LoadParallelContext ------------------------------------------------------------------

MySQLParser::LoadParallelContext::LoadParallelContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LoadParallelContext::PARALLEL_SYMBOL() {
  return getToken(MySQLParser::PARALLEL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadParallelContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}

tree::TerminalNode* MySQLParser::LoadParallelContext::INT_NUMBER() {
  return getToken(MySQLParser::INT_NUMBER, 0);
}


size_t MySQLParser::LoadParallelContext::getRuleIndex() const {
  return MySQLParser::RuleLoadParallel;
}

void MySQLParser::LoadParallelContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLoadParallel(this);
}

void MySQLParser::LoadParallelContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLoadParallel(this);
}


std::any MySQLParser::LoadParallelContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLoadParallel(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LoadParallelContext* MySQLParser::loadParallel() {
  LoadParallelContext *_localctx = _tracker.createInstance<LoadParallelContext>(_ctx, getState());
  enterRule(_localctx, 290, MySQLParser::RuleLoadParallel);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3313);

    if (!(serverVersion >= 80200)) throw FailedPredicateException(this, "serverVersion >= 80200");
    setState(3314);
    match(MySQLParser::PARALLEL_SYMBOL);
    setState(3315);
    match(MySQLParser::EQUAL_OPERATOR);
    setState(3316);
    match(MySQLParser::INT_NUMBER);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LoadMemoryContext ------------------------------------------------------------------

MySQLParser::LoadMemoryContext::LoadMemoryContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LoadMemoryContext::MEMORY_SYMBOL() {
  return getToken(MySQLParser::MEMORY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadMemoryContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::LoadMemoryContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}


size_t MySQLParser::LoadMemoryContext::getRuleIndex() const {
  return MySQLParser::RuleLoadMemory;
}

void MySQLParser::LoadMemoryContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLoadMemory(this);
}

void MySQLParser::LoadMemoryContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLoadMemory(this);
}


std::any MySQLParser::LoadMemoryContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLoadMemory(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LoadMemoryContext* MySQLParser::loadMemory() {
  LoadMemoryContext *_localctx = _tracker.createInstance<LoadMemoryContext>(_ctx, getState());
  enterRule(_localctx, 292, MySQLParser::RuleLoadMemory);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3318);

    if (!(serverVersion >= 80200)) throw FailedPredicateException(this, "serverVersion >= 80200");
    setState(3319);
    match(MySQLParser::MEMORY_SYMBOL);
    setState(3320);
    match(MySQLParser::EQUAL_OPERATOR);
    setState(3321);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ReplaceStatementContext ------------------------------------------------------------------

MySQLParser::ReplaceStatementContext::ReplaceStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ReplaceStatementContext::REPLACE_SYMBOL() {
  return getToken(MySQLParser::REPLACE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::ReplaceStatementContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::InsertFromConstructorContext* MySQLParser::ReplaceStatementContext::insertFromConstructor() {
  return getRuleContext<MySQLParser::InsertFromConstructorContext>(0);
}

tree::TerminalNode* MySQLParser::ReplaceStatementContext::SET_SYMBOL() {
  return getToken(MySQLParser::SET_SYMBOL, 0);
}

MySQLParser::UpdateListContext* MySQLParser::ReplaceStatementContext::updateList() {
  return getRuleContext<MySQLParser::UpdateListContext>(0);
}

MySQLParser::InsertQueryExpressionContext* MySQLParser::ReplaceStatementContext::insertQueryExpression() {
  return getRuleContext<MySQLParser::InsertQueryExpressionContext>(0);
}

tree::TerminalNode* MySQLParser::ReplaceStatementContext::INTO_SYMBOL() {
  return getToken(MySQLParser::INTO_SYMBOL, 0);
}

MySQLParser::UsePartitionContext* MySQLParser::ReplaceStatementContext::usePartition() {
  return getRuleContext<MySQLParser::UsePartitionContext>(0);
}

tree::TerminalNode* MySQLParser::ReplaceStatementContext::LOW_PRIORITY_SYMBOL() {
  return getToken(MySQLParser::LOW_PRIORITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ReplaceStatementContext::DELAYED_SYMBOL() {
  return getToken(MySQLParser::DELAYED_SYMBOL, 0);
}


size_t MySQLParser::ReplaceStatementContext::getRuleIndex() const {
  return MySQLParser::RuleReplaceStatement;
}

void MySQLParser::ReplaceStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterReplaceStatement(this);
}

void MySQLParser::ReplaceStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitReplaceStatement(this);
}


std::any MySQLParser::ReplaceStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitReplaceStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ReplaceStatementContext* MySQLParser::replaceStatement() {
  ReplaceStatementContext *_localctx = _tracker.createInstance<ReplaceStatementContext>(_ctx, getState());
  enterRule(_localctx, 294, MySQLParser::RuleReplaceStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3323);
    match(MySQLParser::REPLACE_SYMBOL);
    setState(3325);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 288, _ctx)) {
    case 1: {
      setState(3324);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::DELAYED_SYMBOL || _la == MySQLParser::LOW_PRIORITY_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      break;
    }

    default:
      break;
    }
    setState(3328);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 289, _ctx)) {
    case 1: {
      setState(3327);
      match(MySQLParser::INTO_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(3330);
    tableRef();
    setState(3332);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 290, _ctx)) {
    case 1: {
      setState(3331);
      usePartition();
      break;
    }

    default:
      break;
    }
    setState(3338);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 291, _ctx)) {
    case 1: {
      setState(3334);
      insertFromConstructor();
      break;
    }

    case 2: {
      setState(3335);
      match(MySQLParser::SET_SYMBOL);
      setState(3336);
      updateList();
      break;
    }

    case 3: {
      setState(3337);
      insertQueryExpression();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SelectStatementContext ------------------------------------------------------------------

MySQLParser::SelectStatementContext::SelectStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionContext* MySQLParser::SelectStatementContext::queryExpression() {
  return getRuleContext<MySQLParser::QueryExpressionContext>(0);
}

MySQLParser::LockingClauseListContext* MySQLParser::SelectStatementContext::lockingClauseList() {
  return getRuleContext<MySQLParser::LockingClauseListContext>(0);
}

MySQLParser::SelectStatementWithIntoContext* MySQLParser::SelectStatementContext::selectStatementWithInto() {
  return getRuleContext<MySQLParser::SelectStatementWithIntoContext>(0);
}


size_t MySQLParser::SelectStatementContext::getRuleIndex() const {
  return MySQLParser::RuleSelectStatement;
}

void MySQLParser::SelectStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSelectStatement(this);
}

void MySQLParser::SelectStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSelectStatement(this);
}


std::any MySQLParser::SelectStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSelectStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SelectStatementContext* MySQLParser::selectStatement() {
  SelectStatementContext *_localctx = _tracker.createInstance<SelectStatementContext>(_ctx, getState());
  enterRule(_localctx, 296, MySQLParser::RuleSelectStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3345);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 293, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3340);
      queryExpression();
      setState(3342);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 292, _ctx)) {
      case 1: {
        setState(3341);
        lockingClauseList();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3344);
      selectStatementWithInto();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SelectStatementWithIntoContext ------------------------------------------------------------------

MySQLParser::SelectStatementWithIntoContext::SelectStatementWithIntoContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::SelectStatementWithIntoContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

MySQLParser::SelectStatementWithIntoContext* MySQLParser::SelectStatementWithIntoContext::selectStatementWithInto() {
  return getRuleContext<MySQLParser::SelectStatementWithIntoContext>(0);
}

tree::TerminalNode* MySQLParser::SelectStatementWithIntoContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::QueryExpressionContext* MySQLParser::SelectStatementWithIntoContext::queryExpression() {
  return getRuleContext<MySQLParser::QueryExpressionContext>(0);
}

MySQLParser::IntoClauseContext* MySQLParser::SelectStatementWithIntoContext::intoClause() {
  return getRuleContext<MySQLParser::IntoClauseContext>(0);
}

MySQLParser::LockingClauseListContext* MySQLParser::SelectStatementWithIntoContext::lockingClauseList() {
  return getRuleContext<MySQLParser::LockingClauseListContext>(0);
}

MySQLParser::QueryExpressionParensContext* MySQLParser::SelectStatementWithIntoContext::queryExpressionParens() {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(0);
}


size_t MySQLParser::SelectStatementWithIntoContext::getRuleIndex() const {
  return MySQLParser::RuleSelectStatementWithInto;
}

void MySQLParser::SelectStatementWithIntoContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSelectStatementWithInto(this);
}

void MySQLParser::SelectStatementWithIntoContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSelectStatementWithInto(this);
}


std::any MySQLParser::SelectStatementWithIntoContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSelectStatementWithInto(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SelectStatementWithIntoContext* MySQLParser::selectStatementWithInto() {
  SelectStatementWithIntoContext *_localctx = _tracker.createInstance<SelectStatementWithIntoContext>(_ctx, getState());
  enterRule(_localctx, 298, MySQLParser::RuleSelectStatementWithInto);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3364);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 295, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3347);
      match(MySQLParser::OPEN_PAR_SYMBOL);
      setState(3348);
      selectStatementWithInto();
      setState(3349);
      match(MySQLParser::CLOSE_PAR_SYMBOL);
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3351);
      queryExpression();
      setState(3352);
      intoClause();
      setState(3354);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 294, _ctx)) {
      case 1: {
        setState(3353);
        lockingClauseList();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(3356);
      queryExpression();
      setState(3357);
      lockingClauseList();
      setState(3358);
      intoClause();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(3360);

      if (!(serverVersion >= 80024 && serverVersion < 80031)) throw FailedPredicateException(this, "serverVersion >= 80024 && serverVersion < 80031");
      setState(3361);
      queryExpressionParens();
      setState(3362);
      intoClause();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QueryExpressionContext ------------------------------------------------------------------

MySQLParser::QueryExpressionContext::QueryExpressionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionBodyContext* MySQLParser::QueryExpressionContext::queryExpressionBody() {
  return getRuleContext<MySQLParser::QueryExpressionBodyContext>(0);
}

MySQLParser::WithClauseContext* MySQLParser::QueryExpressionContext::withClause() {
  return getRuleContext<MySQLParser::WithClauseContext>(0);
}

MySQLParser::OrderClauseContext* MySQLParser::QueryExpressionContext::orderClause() {
  return getRuleContext<MySQLParser::OrderClauseContext>(0);
}

MySQLParser::LimitClauseContext* MySQLParser::QueryExpressionContext::limitClause() {
  return getRuleContext<MySQLParser::LimitClauseContext>(0);
}

MySQLParser::ProcedureAnalyseClauseContext* MySQLParser::QueryExpressionContext::procedureAnalyseClause() {
  return getRuleContext<MySQLParser::ProcedureAnalyseClauseContext>(0);
}


size_t MySQLParser::QueryExpressionContext::getRuleIndex() const {
  return MySQLParser::RuleQueryExpression;
}

void MySQLParser::QueryExpressionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQueryExpression(this);
}

void MySQLParser::QueryExpressionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQueryExpression(this);
}


std::any MySQLParser::QueryExpressionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQueryExpression(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryExpressionContext* MySQLParser::queryExpression() {
  QueryExpressionContext *_localctx = _tracker.createInstance<QueryExpressionContext>(_ctx, getState());
  enterRule(_localctx, 300, MySQLParser::RuleQueryExpression);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3368);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 296, _ctx)) {
    case 1: {
      setState(3366);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(3367);
      withClause();
      break;
    }

    default:
      break;
    }
    setState(3370);
    queryExpressionBody();
    setState(3372);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 297, _ctx)) {
    case 1: {
      setState(3371);
      orderClause();
      break;
    }

    default:
      break;
    }
    setState(3375);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 298, _ctx)) {
    case 1: {
      setState(3374);
      limitClause();
      break;
    }

    default:
      break;
    }
    setState(3379);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 299, _ctx)) {
    case 1: {
      setState(3377);

      if (!(serverVersion < 80000)) throw FailedPredicateException(this, "serverVersion < 80000");
      setState(3378);
      procedureAnalyseClause();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QueryExpressionBodyContext ------------------------------------------------------------------

MySQLParser::QueryExpressionBodyContext::QueryExpressionBodyContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryPrimaryContext* MySQLParser::QueryExpressionBodyContext::queryPrimary() {
  return getRuleContext<MySQLParser::QueryPrimaryContext>(0);
}

MySQLParser::QueryExpressionParensContext* MySQLParser::QueryExpressionBodyContext::queryExpressionParens() {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(0);
}

std::vector<MySQLParser::QueryExpressionBodyContext *> MySQLParser::QueryExpressionBodyContext::queryExpressionBody() {
  return getRuleContexts<MySQLParser::QueryExpressionBodyContext>();
}

MySQLParser::QueryExpressionBodyContext* MySQLParser::QueryExpressionBodyContext::queryExpressionBody(size_t i) {
  return getRuleContext<MySQLParser::QueryExpressionBodyContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::QueryExpressionBodyContext::UNION_SYMBOL() {
  return getTokens(MySQLParser::UNION_SYMBOL);
}

tree::TerminalNode* MySQLParser::QueryExpressionBodyContext::UNION_SYMBOL(size_t i) {
  return getToken(MySQLParser::UNION_SYMBOL, i);
}

std::vector<tree::TerminalNode *> MySQLParser::QueryExpressionBodyContext::EXCEPT_SYMBOL() {
  return getTokens(MySQLParser::EXCEPT_SYMBOL);
}

tree::TerminalNode* MySQLParser::QueryExpressionBodyContext::EXCEPT_SYMBOL(size_t i) {
  return getToken(MySQLParser::EXCEPT_SYMBOL, i);
}

std::vector<tree::TerminalNode *> MySQLParser::QueryExpressionBodyContext::INTERSECT_SYMBOL() {
  return getTokens(MySQLParser::INTERSECT_SYMBOL);
}

tree::TerminalNode* MySQLParser::QueryExpressionBodyContext::INTERSECT_SYMBOL(size_t i) {
  return getToken(MySQLParser::INTERSECT_SYMBOL, i);
}

std::vector<MySQLParser::UnionOptionContext *> MySQLParser::QueryExpressionBodyContext::unionOption() {
  return getRuleContexts<MySQLParser::UnionOptionContext>();
}

MySQLParser::UnionOptionContext* MySQLParser::QueryExpressionBodyContext::unionOption(size_t i) {
  return getRuleContext<MySQLParser::UnionOptionContext>(i);
}


size_t MySQLParser::QueryExpressionBodyContext::getRuleIndex() const {
  return MySQLParser::RuleQueryExpressionBody;
}

void MySQLParser::QueryExpressionBodyContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQueryExpressionBody(this);
}

void MySQLParser::QueryExpressionBodyContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQueryExpressionBody(this);
}


std::any MySQLParser::QueryExpressionBodyContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQueryExpressionBody(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryExpressionBodyContext* MySQLParser::queryExpressionBody() {
  QueryExpressionBodyContext *_localctx = _tracker.createInstance<QueryExpressionBodyContext>(_ctx, getState());
  enterRule(_localctx, 302, MySQLParser::RuleQueryExpressionBody);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3383);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 300, _ctx)) {
    case 1: {
      setState(3381);
      queryPrimary();
      break;
    }

    case 2: {
      setState(3382);
      queryExpressionParens();
      break;
    }

    default:
      break;
    }
    setState(3396);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 303, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3388);
        _errHandler->sync(this);
        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 301, _ctx)) {
        case 1: {
          setState(3385);
          match(MySQLParser::UNION_SYMBOL);
          break;
        }

        case 2: {
          setState(3386);

          if (!(serverVersion >= 80031)) throw FailedPredicateException(this, "serverVersion >= 80031");
          setState(3387);
          _la = _input->LA(1);
          if (!(_la == MySQLParser::EXCEPT_SYMBOL || _la == MySQLParser::INTERSECT_SYMBOL)) {
          _errHandler->recoverInline(this);
          }
          else {
            _errHandler->reportMatch(this);
            consume();
          }
          break;
        }

        default:
          break;
        }
        setState(3391);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 302, _ctx)) {
        case 1: {
          setState(3390);
          unionOption();
          break;
        }

        default:
          break;
        }
        setState(3393);
        queryExpressionBody(); 
      }
      setState(3398);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 303, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QueryExpressionParensContext ------------------------------------------------------------------

MySQLParser::QueryExpressionParensContext::QueryExpressionParensContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::QueryExpressionParensContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QueryExpressionParensContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::QueryExpressionParensContext* MySQLParser::QueryExpressionParensContext::queryExpressionParens() {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(0);
}

MySQLParser::QueryExpressionWithOptLockingClausesContext* MySQLParser::QueryExpressionParensContext::queryExpressionWithOptLockingClauses() {
  return getRuleContext<MySQLParser::QueryExpressionWithOptLockingClausesContext>(0);
}


size_t MySQLParser::QueryExpressionParensContext::getRuleIndex() const {
  return MySQLParser::RuleQueryExpressionParens;
}

void MySQLParser::QueryExpressionParensContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQueryExpressionParens(this);
}

void MySQLParser::QueryExpressionParensContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQueryExpressionParens(this);
}


std::any MySQLParser::QueryExpressionParensContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQueryExpressionParens(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryExpressionParensContext* MySQLParser::queryExpressionParens() {
  QueryExpressionParensContext *_localctx = _tracker.createInstance<QueryExpressionParensContext>(_ctx, getState());
  enterRule(_localctx, 304, MySQLParser::RuleQueryExpressionParens);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3399);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3402);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 304, _ctx)) {
    case 1: {
      setState(3400);
      queryExpressionParens();
      break;
    }

    case 2: {
      setState(3401);
      queryExpressionWithOptLockingClauses();
      break;
    }

    default:
      break;
    }
    setState(3404);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QueryPrimaryContext ------------------------------------------------------------------

MySQLParser::QueryPrimaryContext::QueryPrimaryContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QuerySpecificationContext* MySQLParser::QueryPrimaryContext::querySpecification() {
  return getRuleContext<MySQLParser::QuerySpecificationContext>(0);
}

MySQLParser::TableValueConstructorContext* MySQLParser::QueryPrimaryContext::tableValueConstructor() {
  return getRuleContext<MySQLParser::TableValueConstructorContext>(0);
}

MySQLParser::ExplicitTableContext* MySQLParser::QueryPrimaryContext::explicitTable() {
  return getRuleContext<MySQLParser::ExplicitTableContext>(0);
}


size_t MySQLParser::QueryPrimaryContext::getRuleIndex() const {
  return MySQLParser::RuleQueryPrimary;
}

void MySQLParser::QueryPrimaryContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQueryPrimary(this);
}

void MySQLParser::QueryPrimaryContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQueryPrimary(this);
}


std::any MySQLParser::QueryPrimaryContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQueryPrimary(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryPrimaryContext* MySQLParser::queryPrimary() {
  QueryPrimaryContext *_localctx = _tracker.createInstance<QueryPrimaryContext>(_ctx, getState());
  enterRule(_localctx, 306, MySQLParser::RuleQueryPrimary);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3411);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 305, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3406);
      querySpecification();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3407);

      if (!(serverVersion >= 80019)) throw FailedPredicateException(this, "serverVersion >= 80019");
      setState(3408);
      tableValueConstructor();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(3409);

      if (!(serverVersion >= 80019)) throw FailedPredicateException(this, "serverVersion >= 80019");
      setState(3410);
      explicitTable();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QuerySpecificationContext ------------------------------------------------------------------

MySQLParser::QuerySpecificationContext::QuerySpecificationContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::QuerySpecificationContext::SELECT_SYMBOL() {
  return getToken(MySQLParser::SELECT_SYMBOL, 0);
}

MySQLParser::SelectItemListContext* MySQLParser::QuerySpecificationContext::selectItemList() {
  return getRuleContext<MySQLParser::SelectItemListContext>(0);
}

std::vector<MySQLParser::SelectOptionContext *> MySQLParser::QuerySpecificationContext::selectOption() {
  return getRuleContexts<MySQLParser::SelectOptionContext>();
}

MySQLParser::SelectOptionContext* MySQLParser::QuerySpecificationContext::selectOption(size_t i) {
  return getRuleContext<MySQLParser::SelectOptionContext>(i);
}

MySQLParser::IntoClauseContext* MySQLParser::QuerySpecificationContext::intoClause() {
  return getRuleContext<MySQLParser::IntoClauseContext>(0);
}

MySQLParser::FromClauseContext* MySQLParser::QuerySpecificationContext::fromClause() {
  return getRuleContext<MySQLParser::FromClauseContext>(0);
}

MySQLParser::WhereClauseContext* MySQLParser::QuerySpecificationContext::whereClause() {
  return getRuleContext<MySQLParser::WhereClauseContext>(0);
}

MySQLParser::GroupByClauseContext* MySQLParser::QuerySpecificationContext::groupByClause() {
  return getRuleContext<MySQLParser::GroupByClauseContext>(0);
}

MySQLParser::HavingClauseContext* MySQLParser::QuerySpecificationContext::havingClause() {
  return getRuleContext<MySQLParser::HavingClauseContext>(0);
}

MySQLParser::WindowClauseContext* MySQLParser::QuerySpecificationContext::windowClause() {
  return getRuleContext<MySQLParser::WindowClauseContext>(0);
}

MySQLParser::QualifyClauseContext* MySQLParser::QuerySpecificationContext::qualifyClause() {
  return getRuleContext<MySQLParser::QualifyClauseContext>(0);
}


size_t MySQLParser::QuerySpecificationContext::getRuleIndex() const {
  return MySQLParser::RuleQuerySpecification;
}

void MySQLParser::QuerySpecificationContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQuerySpecification(this);
}

void MySQLParser::QuerySpecificationContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQuerySpecification(this);
}


std::any MySQLParser::QuerySpecificationContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQuerySpecification(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QuerySpecificationContext* MySQLParser::querySpecification() {
  QuerySpecificationContext *_localctx = _tracker.createInstance<QuerySpecificationContext>(_ctx, getState());
  enterRule(_localctx, 308, MySQLParser::RuleQuerySpecification);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3413);
    match(MySQLParser::SELECT_SYMBOL);
    setState(3417);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 306, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3414);
        selectOption(); 
      }
      setState(3419);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 306, _ctx);
    }
    setState(3420);
    selectItemList();
    setState(3422);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 307, _ctx)) {
    case 1: {
      setState(3421);
      intoClause();
      break;
    }

    default:
      break;
    }
    setState(3425);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 308, _ctx)) {
    case 1: {
      setState(3424);
      fromClause();
      break;
    }

    default:
      break;
    }
    setState(3428);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 309, _ctx)) {
    case 1: {
      setState(3427);
      whereClause();
      break;
    }

    default:
      break;
    }
    setState(3431);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 310, _ctx)) {
    case 1: {
      setState(3430);
      groupByClause();
      break;
    }

    default:
      break;
    }
    setState(3434);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 311, _ctx)) {
    case 1: {
      setState(3433);
      havingClause();
      break;
    }

    default:
      break;
    }
    setState(3438);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 312, _ctx)) {
    case 1: {
      setState(3436);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(3437);
      windowClause();
      break;
    }

    default:
      break;
    }
    setState(3441);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 313, _ctx)) {
    case 1: {
      setState(3440);
      qualifyClause();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SubqueryContext ------------------------------------------------------------------

MySQLParser::SubqueryContext::SubqueryContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionParensContext* MySQLParser::SubqueryContext::queryExpressionParens() {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(0);
}


size_t MySQLParser::SubqueryContext::getRuleIndex() const {
  return MySQLParser::RuleSubquery;
}

void MySQLParser::SubqueryContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSubquery(this);
}

void MySQLParser::SubqueryContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSubquery(this);
}


std::any MySQLParser::SubqueryContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSubquery(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SubqueryContext* MySQLParser::subquery() {
  SubqueryContext *_localctx = _tracker.createInstance<SubqueryContext>(_ctx, getState());
  enterRule(_localctx, 310, MySQLParser::RuleSubquery);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3443);
    queryExpressionParens();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QuerySpecOptionContext ------------------------------------------------------------------

MySQLParser::QuerySpecOptionContext::QuerySpecOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::ALL_SYMBOL() {
  return getToken(MySQLParser::ALL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::DISTINCT_SYMBOL() {
  return getToken(MySQLParser::DISTINCT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::STRAIGHT_JOIN_SYMBOL() {
  return getToken(MySQLParser::STRAIGHT_JOIN_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::HIGH_PRIORITY_SYMBOL() {
  return getToken(MySQLParser::HIGH_PRIORITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::SQL_SMALL_RESULT_SYMBOL() {
  return getToken(MySQLParser::SQL_SMALL_RESULT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::SQL_BIG_RESULT_SYMBOL() {
  return getToken(MySQLParser::SQL_BIG_RESULT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::SQL_BUFFER_RESULT_SYMBOL() {
  return getToken(MySQLParser::SQL_BUFFER_RESULT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::SQL_CALC_FOUND_ROWS_SYMBOL() {
  return getToken(MySQLParser::SQL_CALC_FOUND_ROWS_SYMBOL, 0);
}


size_t MySQLParser::QuerySpecOptionContext::getRuleIndex() const {
  return MySQLParser::RuleQuerySpecOption;
}

void MySQLParser::QuerySpecOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQuerySpecOption(this);
}

void MySQLParser::QuerySpecOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQuerySpecOption(this);
}


std::any MySQLParser::QuerySpecOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQuerySpecOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QuerySpecOptionContext* MySQLParser::querySpecOption() {
  QuerySpecOptionContext *_localctx = _tracker.createInstance<QuerySpecOptionContext>(_ctx, getState());
  enterRule(_localctx, 312, MySQLParser::RuleQuerySpecOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3445);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::ALL_SYMBOL || _la == MySQLParser::DISTINCT_SYMBOL || _la == MySQLParser::HIGH_PRIORITY_SYMBOL || ((((_la - 557) & ~ 0x3fULL) == 0) &&
      ((1ULL << (_la - 557)) & ((1ULL << (MySQLParser::SQL_BIG_RESULT_SYMBOL - 557))
      | (1ULL << (MySQLParser::SQL_BUFFER_RESULT_SYMBOL - 557))
      | (1ULL << (MySQLParser::SQL_CALC_FOUND_ROWS_SYMBOL - 557))
      | (1ULL << (MySQLParser::SQL_SMALL_RESULT_SYMBOL - 557))
      | (1ULL << (MySQLParser::STRAIGHT_JOIN_SYMBOL - 557)))) != 0))) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LimitClauseContext ------------------------------------------------------------------

MySQLParser::LimitClauseContext::LimitClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LimitClauseContext::LIMIT_SYMBOL() {
  return getToken(MySQLParser::LIMIT_SYMBOL, 0);
}

MySQLParser::LimitOptionsContext* MySQLParser::LimitClauseContext::limitOptions() {
  return getRuleContext<MySQLParser::LimitOptionsContext>(0);
}


size_t MySQLParser::LimitClauseContext::getRuleIndex() const {
  return MySQLParser::RuleLimitClause;
}

void MySQLParser::LimitClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLimitClause(this);
}

void MySQLParser::LimitClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLimitClause(this);
}


std::any MySQLParser::LimitClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLimitClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LimitClauseContext* MySQLParser::limitClause() {
  LimitClauseContext *_localctx = _tracker.createInstance<LimitClauseContext>(_ctx, getState());
  enterRule(_localctx, 314, MySQLParser::RuleLimitClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3447);
    match(MySQLParser::LIMIT_SYMBOL);
    setState(3448);
    limitOptions();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SimpleLimitClauseContext ------------------------------------------------------------------

MySQLParser::SimpleLimitClauseContext::SimpleLimitClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::SimpleLimitClauseContext::LIMIT_SYMBOL() {
  return getToken(MySQLParser::LIMIT_SYMBOL, 0);
}

MySQLParser::LimitOptionContext* MySQLParser::SimpleLimitClauseContext::limitOption() {
  return getRuleContext<MySQLParser::LimitOptionContext>(0);
}


size_t MySQLParser::SimpleLimitClauseContext::getRuleIndex() const {
  return MySQLParser::RuleSimpleLimitClause;
}

void MySQLParser::SimpleLimitClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSimpleLimitClause(this);
}

void MySQLParser::SimpleLimitClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSimpleLimitClause(this);
}


std::any MySQLParser::SimpleLimitClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSimpleLimitClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SimpleLimitClauseContext* MySQLParser::simpleLimitClause() {
  SimpleLimitClauseContext *_localctx = _tracker.createInstance<SimpleLimitClauseContext>(_ctx, getState());
  enterRule(_localctx, 316, MySQLParser::RuleSimpleLimitClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3450);
    match(MySQLParser::LIMIT_SYMBOL);
    setState(3451);
    limitOption();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LimitOptionsContext ------------------------------------------------------------------

MySQLParser::LimitOptionsContext::LimitOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::LimitOptionContext *> MySQLParser::LimitOptionsContext::limitOption() {
  return getRuleContexts<MySQLParser::LimitOptionContext>();
}

MySQLParser::LimitOptionContext* MySQLParser::LimitOptionsContext::limitOption(size_t i) {
  return getRuleContext<MySQLParser::LimitOptionContext>(i);
}

tree::TerminalNode* MySQLParser::LimitOptionsContext::COMMA_SYMBOL() {
  return getToken(MySQLParser::COMMA_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LimitOptionsContext::OFFSET_SYMBOL() {
  return getToken(MySQLParser::OFFSET_SYMBOL, 0);
}


size_t MySQLParser::LimitOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleLimitOptions;
}

void MySQLParser::LimitOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLimitOptions(this);
}

void MySQLParser::LimitOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLimitOptions(this);
}


std::any MySQLParser::LimitOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLimitOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LimitOptionsContext* MySQLParser::limitOptions() {
  LimitOptionsContext *_localctx = _tracker.createInstance<LimitOptionsContext>(_ctx, getState());
  enterRule(_localctx, 318, MySQLParser::RuleLimitOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3453);
    limitOption();
    setState(3456);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 314, _ctx)) {
    case 1: {
      setState(3454);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::COMMA_SYMBOL || _la == MySQLParser::OFFSET_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      setState(3455);
      limitOption();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LimitOptionContext ------------------------------------------------------------------

MySQLParser::LimitOptionContext::LimitOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::IdentifierContext* MySQLParser::LimitOptionContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::LimitOptionContext::PARAM_MARKER() {
  return getToken(MySQLParser::PARAM_MARKER, 0);
}

tree::TerminalNode* MySQLParser::LimitOptionContext::ULONGLONG_NUMBER() {
  return getToken(MySQLParser::ULONGLONG_NUMBER, 0);
}

tree::TerminalNode* MySQLParser::LimitOptionContext::LONG_NUMBER() {
  return getToken(MySQLParser::LONG_NUMBER, 0);
}

tree::TerminalNode* MySQLParser::LimitOptionContext::INT_NUMBER() {
  return getToken(MySQLParser::INT_NUMBER, 0);
}


size_t MySQLParser::LimitOptionContext::getRuleIndex() const {
  return MySQLParser::RuleLimitOption;
}

void MySQLParser::LimitOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLimitOption(this);
}

void MySQLParser::LimitOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLimitOption(this);
}


std::any MySQLParser::LimitOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLimitOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LimitOptionContext* MySQLParser::limitOption() {
  LimitOptionContext *_localctx = _tracker.createInstance<LimitOptionContext>(_ctx, getState());
  enterRule(_localctx, 320, MySQLParser::RuleLimitOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3460);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 315, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3458);
      identifier();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3459);
      _la = _input->LA(1);
      if (!((((_la & ~ 0x3fULL) == 0) &&
        ((1ULL << _la) & ((1ULL << MySQLParser::INT_NUMBER)
        | (1ULL << MySQLParser::LONG_NUMBER)
        | (1ULL << MySQLParser::ULONGLONG_NUMBER)
        | (1ULL << MySQLParser::PARAM_MARKER))) != 0))) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- IntoClauseContext ------------------------------------------------------------------

MySQLParser::IntoClauseContext::IntoClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::IntoClauseContext::INTO_SYMBOL() {
  return getToken(MySQLParser::INTO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::IntoClauseContext::OUTFILE_SYMBOL() {
  return getToken(MySQLParser::OUTFILE_SYMBOL, 0);
}

MySQLParser::TextStringLiteralContext* MySQLParser::IntoClauseContext::textStringLiteral() {
  return getRuleContext<MySQLParser::TextStringLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::IntoClauseContext::DUMPFILE_SYMBOL() {
  return getToken(MySQLParser::DUMPFILE_SYMBOL, 0);
}

std::vector<MySQLParser::TextOrIdentifierContext *> MySQLParser::IntoClauseContext::textOrIdentifier() {
  return getRuleContexts<MySQLParser::TextOrIdentifierContext>();
}

MySQLParser::TextOrIdentifierContext* MySQLParser::IntoClauseContext::textOrIdentifier(size_t i) {
  return getRuleContext<MySQLParser::TextOrIdentifierContext>(i);
}

std::vector<MySQLParser::UserVariableContext *> MySQLParser::IntoClauseContext::userVariable() {
  return getRuleContexts<MySQLParser::UserVariableContext>();
}

MySQLParser::UserVariableContext* MySQLParser::IntoClauseContext::userVariable(size_t i) {
  return getRuleContext<MySQLParser::UserVariableContext>(i);
}

MySQLParser::CharsetClauseContext* MySQLParser::IntoClauseContext::charsetClause() {
  return getRuleContext<MySQLParser::CharsetClauseContext>(0);
}

MySQLParser::FieldsClauseContext* MySQLParser::IntoClauseContext::fieldsClause() {
  return getRuleContext<MySQLParser::FieldsClauseContext>(0);
}

MySQLParser::LinesClauseContext* MySQLParser::IntoClauseContext::linesClause() {
  return getRuleContext<MySQLParser::LinesClauseContext>(0);
}

std::vector<tree::TerminalNode *> MySQLParser::IntoClauseContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::IntoClauseContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::IntoClauseContext::getRuleIndex() const {
  return MySQLParser::RuleIntoClause;
}

void MySQLParser::IntoClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterIntoClause(this);
}

void MySQLParser::IntoClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitIntoClause(this);
}


std::any MySQLParser::IntoClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitIntoClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::IntoClauseContext* MySQLParser::intoClause() {
  IntoClauseContext *_localctx = _tracker.createInstance<IntoClauseContext>(_ctx, getState());
  enterRule(_localctx, 322, MySQLParser::RuleIntoClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3462);
    match(MySQLParser::INTO_SYMBOL);
    setState(3490);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 322, _ctx)) {
    case 1: {
      setState(3463);
      match(MySQLParser::OUTFILE_SYMBOL);
      setState(3464);
      textStringLiteral();
      setState(3466);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 316, _ctx)) {
      case 1: {
        setState(3465);
        charsetClause();
        break;
      }

      default:
        break;
      }
      setState(3469);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 317, _ctx)) {
      case 1: {
        setState(3468);
        fieldsClause();
        break;
      }

      default:
        break;
      }
      setState(3472);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 318, _ctx)) {
      case 1: {
        setState(3471);
        linesClause();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(3474);
      match(MySQLParser::DUMPFILE_SYMBOL);
      setState(3475);
      textStringLiteral();
      break;
    }

    case 3: {
      setState(3478);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 319, _ctx)) {
      case 1: {
        setState(3476);
        textOrIdentifier();
        break;
      }

      case 2: {
        setState(3477);
        userVariable();
        break;
      }

      default:
        break;
      }
      setState(3487);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 321, _ctx);
      while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
        if (alt == 1) {
          setState(3480);
          match(MySQLParser::COMMA_SYMBOL);
          setState(3483);
          _errHandler->sync(this);
          switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 320, _ctx)) {
          case 1: {
            setState(3481);
            textOrIdentifier();
            break;
          }

          case 2: {
            setState(3482);
            userVariable();
            break;
          }

          default:
            break;
          } 
        }
        setState(3489);
        _errHandler->sync(this);
        alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 321, _ctx);
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ProcedureAnalyseClauseContext ------------------------------------------------------------------

MySQLParser::ProcedureAnalyseClauseContext::ProcedureAnalyseClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ProcedureAnalyseClauseContext::PROCEDURE_SYMBOL() {
  return getToken(MySQLParser::PROCEDURE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ProcedureAnalyseClauseContext::ANALYSE_SYMBOL() {
  return getToken(MySQLParser::ANALYSE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ProcedureAnalyseClauseContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ProcedureAnalyseClauseContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

std::vector<tree::TerminalNode *> MySQLParser::ProcedureAnalyseClauseContext::INT_NUMBER() {
  return getTokens(MySQLParser::INT_NUMBER);
}

tree::TerminalNode* MySQLParser::ProcedureAnalyseClauseContext::INT_NUMBER(size_t i) {
  return getToken(MySQLParser::INT_NUMBER, i);
}

tree::TerminalNode* MySQLParser::ProcedureAnalyseClauseContext::COMMA_SYMBOL() {
  return getToken(MySQLParser::COMMA_SYMBOL, 0);
}


size_t MySQLParser::ProcedureAnalyseClauseContext::getRuleIndex() const {
  return MySQLParser::RuleProcedureAnalyseClause;
}

void MySQLParser::ProcedureAnalyseClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterProcedureAnalyseClause(this);
}

void MySQLParser::ProcedureAnalyseClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitProcedureAnalyseClause(this);
}


std::any MySQLParser::ProcedureAnalyseClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitProcedureAnalyseClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ProcedureAnalyseClauseContext* MySQLParser::procedureAnalyseClause() {
  ProcedureAnalyseClauseContext *_localctx = _tracker.createInstance<ProcedureAnalyseClauseContext>(_ctx, getState());
  enterRule(_localctx, 324, MySQLParser::RuleProcedureAnalyseClause);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3492);
    match(MySQLParser::PROCEDURE_SYMBOL);
    setState(3493);
    match(MySQLParser::ANALYSE_SYMBOL);
    setState(3494);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3500);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::INT_NUMBER) {
      setState(3495);
      match(MySQLParser::INT_NUMBER);
      setState(3498);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::COMMA_SYMBOL) {
        setState(3496);
        match(MySQLParser::COMMA_SYMBOL);
        setState(3497);
        match(MySQLParser::INT_NUMBER);
      }
    }
    setState(3502);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- HavingClauseContext ------------------------------------------------------------------

MySQLParser::HavingClauseContext::HavingClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::HavingClauseContext::HAVING_SYMBOL() {
  return getToken(MySQLParser::HAVING_SYMBOL, 0);
}

MySQLParser::ExprContext* MySQLParser::HavingClauseContext::expr() {
  return getRuleContext<MySQLParser::ExprContext>(0);
}


size_t MySQLParser::HavingClauseContext::getRuleIndex() const {
  return MySQLParser::RuleHavingClause;
}

void MySQLParser::HavingClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterHavingClause(this);
}

void MySQLParser::HavingClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitHavingClause(this);
}


std::any MySQLParser::HavingClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitHavingClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::HavingClauseContext* MySQLParser::havingClause() {
  HavingClauseContext *_localctx = _tracker.createInstance<HavingClauseContext>(_ctx, getState());
  enterRule(_localctx, 326, MySQLParser::RuleHavingClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3504);
    match(MySQLParser::HAVING_SYMBOL);
    setState(3505);
    expr(0);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QualifyClauseContext ------------------------------------------------------------------

MySQLParser::QualifyClauseContext::QualifyClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::QualifyClauseContext::QUALIFY_SYMBOL() {
  return getToken(MySQLParser::QUALIFY_SYMBOL, 0);
}

MySQLParser::ExprContext* MySQLParser::QualifyClauseContext::expr() {
  return getRuleContext<MySQLParser::ExprContext>(0);
}


size_t MySQLParser::QualifyClauseContext::getRuleIndex() const {
  return MySQLParser::RuleQualifyClause;
}

void MySQLParser::QualifyClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQualifyClause(this);
}

void MySQLParser::QualifyClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQualifyClause(this);
}


std::any MySQLParser::QualifyClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQualifyClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QualifyClauseContext* MySQLParser::qualifyClause() {
  QualifyClauseContext *_localctx = _tracker.createInstance<QualifyClauseContext>(_ctx, getState());
  enterRule(_localctx, 328, MySQLParser::RuleQualifyClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3507);

    if (!(serverVersion >= 80300)) throw FailedPredicateException(this, "serverVersion >= 80300");
    setState(3508);
    match(MySQLParser::QUALIFY_SYMBOL);
    setState(3509);
    expr(0);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowClauseContext ------------------------------------------------------------------

MySQLParser::WindowClauseContext::WindowClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WindowClauseContext::WINDOW_SYMBOL() {
  return getToken(MySQLParser::WINDOW_SYMBOL, 0);
}

std::vector<MySQLParser::WindowDefinitionContext *> MySQLParser::WindowClauseContext::windowDefinition() {
  return getRuleContexts<MySQLParser::WindowDefinitionContext>();
}

MySQLParser::WindowDefinitionContext* MySQLParser::WindowClauseContext::windowDefinition(size_t i) {
  return getRuleContext<MySQLParser::WindowDefinitionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::WindowClauseContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::WindowClauseContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::WindowClauseContext::getRuleIndex() const {
  return MySQLParser::RuleWindowClause;
}

void MySQLParser::WindowClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowClause(this);
}

void MySQLParser::WindowClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowClause(this);
}


std::any MySQLParser::WindowClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowClauseContext* MySQLParser::windowClause() {
  WindowClauseContext *_localctx = _tracker.createInstance<WindowClauseContext>(_ctx, getState());
  enterRule(_localctx, 330, MySQLParser::RuleWindowClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3511);
    match(MySQLParser::WINDOW_SYMBOL);
    setState(3512);
    windowDefinition();
    setState(3517);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 325, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3513);
        match(MySQLParser::COMMA_SYMBOL);
        setState(3514);
        windowDefinition(); 
      }
      setState(3519);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 325, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowDefinitionContext ------------------------------------------------------------------

MySQLParser::WindowDefinitionContext::WindowDefinitionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::WindowNameContext* MySQLParser::WindowDefinitionContext::windowName() {
  return getRuleContext<MySQLParser::WindowNameContext>(0);
}

tree::TerminalNode* MySQLParser::WindowDefinitionContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}

MySQLParser::WindowSpecContext* MySQLParser::WindowDefinitionContext::windowSpec() {
  return getRuleContext<MySQLParser::WindowSpecContext>(0);
}


size_t MySQLParser::WindowDefinitionContext::getRuleIndex() const {
  return MySQLParser::RuleWindowDefinition;
}

void MySQLParser::WindowDefinitionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowDefinition(this);
}

void MySQLParser::WindowDefinitionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowDefinition(this);
}


std::any MySQLParser::WindowDefinitionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowDefinition(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowDefinitionContext* MySQLParser::windowDefinition() {
  WindowDefinitionContext *_localctx = _tracker.createInstance<WindowDefinitionContext>(_ctx, getState());
  enterRule(_localctx, 332, MySQLParser::RuleWindowDefinition);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3520);
    windowName();
    setState(3521);
    match(MySQLParser::AS_SYMBOL);
    setState(3522);
    windowSpec();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowSpecContext ------------------------------------------------------------------

MySQLParser::WindowSpecContext::WindowSpecContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WindowSpecContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

MySQLParser::WindowSpecDetailsContext* MySQLParser::WindowSpecContext::windowSpecDetails() {
  return getRuleContext<MySQLParser::WindowSpecDetailsContext>(0);
}

tree::TerminalNode* MySQLParser::WindowSpecContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}


size_t MySQLParser::WindowSpecContext::getRuleIndex() const {
  return MySQLParser::RuleWindowSpec;
}

void MySQLParser::WindowSpecContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowSpec(this);
}

void MySQLParser::WindowSpecContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowSpec(this);
}


std::any MySQLParser::WindowSpecContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowSpec(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowSpecContext* MySQLParser::windowSpec() {
  WindowSpecContext *_localctx = _tracker.createInstance<WindowSpecContext>(_ctx, getState());
  enterRule(_localctx, 334, MySQLParser::RuleWindowSpec);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3524);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3525);
    windowSpecDetails();
    setState(3526);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowSpecDetailsContext ------------------------------------------------------------------

MySQLParser::WindowSpecDetailsContext::WindowSpecDetailsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::WindowNameContext* MySQLParser::WindowSpecDetailsContext::windowName() {
  return getRuleContext<MySQLParser::WindowNameContext>(0);
}

tree::TerminalNode* MySQLParser::WindowSpecDetailsContext::PARTITION_SYMBOL() {
  return getToken(MySQLParser::PARTITION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowSpecDetailsContext::BY_SYMBOL() {
  return getToken(MySQLParser::BY_SYMBOL, 0);
}

MySQLParser::OrderListContext* MySQLParser::WindowSpecDetailsContext::orderList() {
  return getRuleContext<MySQLParser::OrderListContext>(0);
}

MySQLParser::OrderClauseContext* MySQLParser::WindowSpecDetailsContext::orderClause() {
  return getRuleContext<MySQLParser::OrderClauseContext>(0);
}

MySQLParser::WindowFrameClauseContext* MySQLParser::WindowSpecDetailsContext::windowFrameClause() {
  return getRuleContext<MySQLParser::WindowFrameClauseContext>(0);
}


size_t MySQLParser::WindowSpecDetailsContext::getRuleIndex() const {
  return MySQLParser::RuleWindowSpecDetails;
}

void MySQLParser::WindowSpecDetailsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowSpecDetails(this);
}

void MySQLParser::WindowSpecDetailsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowSpecDetails(this);
}


std::any MySQLParser::WindowSpecDetailsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowSpecDetails(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowSpecDetailsContext* MySQLParser::windowSpecDetails() {
  WindowSpecDetailsContext *_localctx = _tracker.createInstance<WindowSpecDetailsContext>(_ctx, getState());
  enterRule(_localctx, 336, MySQLParser::RuleWindowSpecDetails);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3529);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 326, _ctx)) {
    case 1: {
      setState(3528);
      windowName();
      break;
    }

    default:
      break;
    }
    setState(3534);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::PARTITION_SYMBOL) {
      setState(3531);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(3532);
      match(MySQLParser::BY_SYMBOL);
      setState(3533);
      orderList();
    }
    setState(3537);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ORDER_SYMBOL) {
      setState(3536);
      orderClause();
    }
    setState(3540);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::RANGE_SYMBOL

    || _la == MySQLParser::ROWS_SYMBOL || _la == MySQLParser::GROUPS_SYMBOL) {
      setState(3539);
      windowFrameClause();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameClauseContext ------------------------------------------------------------------

MySQLParser::WindowFrameClauseContext::WindowFrameClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::WindowFrameUnitsContext* MySQLParser::WindowFrameClauseContext::windowFrameUnits() {
  return getRuleContext<MySQLParser::WindowFrameUnitsContext>(0);
}

MySQLParser::WindowFrameExtentContext* MySQLParser::WindowFrameClauseContext::windowFrameExtent() {
  return getRuleContext<MySQLParser::WindowFrameExtentContext>(0);
}

MySQLParser::WindowFrameExclusionContext* MySQLParser::WindowFrameClauseContext::windowFrameExclusion() {
  return getRuleContext<MySQLParser::WindowFrameExclusionContext>(0);
}


size_t MySQLParser::WindowFrameClauseContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameClause;
}

void MySQLParser::WindowFrameClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameClause(this);
}

void MySQLParser::WindowFrameClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameClause(this);
}


std::any MySQLParser::WindowFrameClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameClauseContext* MySQLParser::windowFrameClause() {
  WindowFrameClauseContext *_localctx = _tracker.createInstance<WindowFrameClauseContext>(_ctx, getState());
  enterRule(_localctx, 338, MySQLParser::RuleWindowFrameClause);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3542);
    windowFrameUnits();
    setState(3543);
    windowFrameExtent();
    setState(3545);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::EXCLUDE_SYMBOL) {
      setState(3544);
      windowFrameExclusion();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameUnitsContext ------------------------------------------------------------------

MySQLParser::WindowFrameUnitsContext::WindowFrameUnitsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WindowFrameUnitsContext::ROWS_SYMBOL() {
  return getToken(MySQLParser::ROWS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameUnitsContext::RANGE_SYMBOL() {
  return getToken(MySQLParser::RANGE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameUnitsContext::GROUPS_SYMBOL() {
  return getToken(MySQLParser::GROUPS_SYMBOL, 0);
}


size_t MySQLParser::WindowFrameUnitsContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameUnits;
}

void MySQLParser::WindowFrameUnitsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameUnits(this);
}

void MySQLParser::WindowFrameUnitsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameUnits(this);
}


std::any MySQLParser::WindowFrameUnitsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameUnits(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameUnitsContext* MySQLParser::windowFrameUnits() {
  WindowFrameUnitsContext *_localctx = _tracker.createInstance<WindowFrameUnitsContext>(_ctx, getState());
  enterRule(_localctx, 340, MySQLParser::RuleWindowFrameUnits);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3547);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::RANGE_SYMBOL

    || _la == MySQLParser::ROWS_SYMBOL || _la == MySQLParser::GROUPS_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameExtentContext ------------------------------------------------------------------

MySQLParser::WindowFrameExtentContext::WindowFrameExtentContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::WindowFrameStartContext* MySQLParser::WindowFrameExtentContext::windowFrameStart() {
  return getRuleContext<MySQLParser::WindowFrameStartContext>(0);
}

MySQLParser::WindowFrameBetweenContext* MySQLParser::WindowFrameExtentContext::windowFrameBetween() {
  return getRuleContext<MySQLParser::WindowFrameBetweenContext>(0);
}


size_t MySQLParser::WindowFrameExtentContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameExtent;
}

void MySQLParser::WindowFrameExtentContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameExtent(this);
}

void MySQLParser::WindowFrameExtentContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameExtent(this);
}


std::any MySQLParser::WindowFrameExtentContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameExtent(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameExtentContext* MySQLParser::windowFrameExtent() {
  WindowFrameExtentContext *_localctx = _tracker.createInstance<WindowFrameExtentContext>(_ctx, getState());
  enterRule(_localctx, 342, MySQLParser::RuleWindowFrameExtent);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3551);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::INT_NUMBER:
      case MySQLParser::LONG_NUMBER:
      case MySQLParser::ULONGLONG_NUMBER:
      case MySQLParser::PARAM_MARKER:
      case MySQLParser::DECIMAL_NUMBER:
      case MySQLParser::FLOAT_NUMBER:
      case MySQLParser::CURRENT_SYMBOL:
      case MySQLParser::INTERVAL_SYMBOL:
      case MySQLParser::UNBOUNDED_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(3549);
        windowFrameStart();
        break;
      }

      case MySQLParser::BETWEEN_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(3550);
        windowFrameBetween();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameStartContext ------------------------------------------------------------------

MySQLParser::WindowFrameStartContext::WindowFrameStartContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WindowFrameStartContext::UNBOUNDED_SYMBOL() {
  return getToken(MySQLParser::UNBOUNDED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameStartContext::PRECEDING_SYMBOL() {
  return getToken(MySQLParser::PRECEDING_SYMBOL, 0);
}

MySQLParser::UlonglongNumberContext* MySQLParser::WindowFrameStartContext::ulonglongNumber() {
  return getRuleContext<MySQLParser::UlonglongNumberContext>(0);
}

tree::TerminalNode* MySQLParser::WindowFrameStartContext::PARAM_MARKER() {
  return getToken(MySQLParser::PARAM_MARKER, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameStartContext::INTERVAL_SYMBOL() {
  return getToken(MySQLParser::INTERVAL_SYMBOL, 0);
}

MySQLParser::ExprContext* MySQLParser::WindowFrameStartContext::expr() {
  return getRuleContext<MySQLParser::ExprContext>(0);
}

MySQLParser::IntervalContext* MySQLParser::WindowFrameStartContext::interval() {
  return getRuleContext<MySQLParser::IntervalContext>(0);
}

tree::TerminalNode* MySQLParser::WindowFrameStartContext::CURRENT_SYMBOL() {
  return getToken(MySQLParser::CURRENT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameStartContext::ROW_SYMBOL() {
  return getToken(MySQLParser::ROW_SYMBOL, 0);
}


size_t MySQLParser::WindowFrameStartContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameStart;
}

void MySQLParser::WindowFrameStartContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameStart(this);
}

void MySQLParser::WindowFrameStartContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameStart(this);
}


std::any MySQLParser::WindowFrameStartContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameStart(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameStartContext* MySQLParser::windowFrameStart() {
  WindowFrameStartContext *_localctx = _tracker.createInstance<WindowFrameStartContext>(_ctx, getState());
  enterRule(_localctx, 344, MySQLParser::RuleWindowFrameStart);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3567);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::UNBOUNDED_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(3553);
        match(MySQLParser::UNBOUNDED_SYMBOL);
        setState(3554);
        match(MySQLParser::PRECEDING_SYMBOL);
        break;
      }

      case MySQLParser::INT_NUMBER:
      case MySQLParser::LONG_NUMBER:
      case MySQLParser::ULONGLONG_NUMBER:
      case MySQLParser::DECIMAL_NUMBER:
      case MySQLParser::FLOAT_NUMBER: {
        enterOuterAlt(_localctx, 2);
        setState(3555);
        ulonglongNumber();
        setState(3556);
        match(MySQLParser::PRECEDING_SYMBOL);
        break;
      }

      case MySQLParser::PARAM_MARKER: {
        enterOuterAlt(_localctx, 3);
        setState(3558);
        match(MySQLParser::PARAM_MARKER);
        setState(3559);
        match(MySQLParser::PRECEDING_SYMBOL);
        break;
      }

      case MySQLParser::INTERVAL_SYMBOL: {
        enterOuterAlt(_localctx, 4);
        setState(3560);
        match(MySQLParser::INTERVAL_SYMBOL);
        setState(3561);
        expr(0);
        setState(3562);
        interval();
        setState(3563);
        match(MySQLParser::PRECEDING_SYMBOL);
        break;
      }

      case MySQLParser::CURRENT_SYMBOL: {
        enterOuterAlt(_localctx, 5);
        setState(3565);
        match(MySQLParser::CURRENT_SYMBOL);
        setState(3566);
        match(MySQLParser::ROW_SYMBOL);
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameBetweenContext ------------------------------------------------------------------

MySQLParser::WindowFrameBetweenContext::WindowFrameBetweenContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WindowFrameBetweenContext::BETWEEN_SYMBOL() {
  return getToken(MySQLParser::BETWEEN_SYMBOL, 0);
}

std::vector<MySQLParser::WindowFrameBoundContext *> MySQLParser::WindowFrameBetweenContext::windowFrameBound() {
  return getRuleContexts<MySQLParser::WindowFrameBoundContext>();
}

MySQLParser::WindowFrameBoundContext* MySQLParser::WindowFrameBetweenContext::windowFrameBound(size_t i) {
  return getRuleContext<MySQLParser::WindowFrameBoundContext>(i);
}

tree::TerminalNode* MySQLParser::WindowFrameBetweenContext::AND_SYMBOL() {
  return getToken(MySQLParser::AND_SYMBOL, 0);
}


size_t MySQLParser::WindowFrameBetweenContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameBetween;
}

void MySQLParser::WindowFrameBetweenContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameBetween(this);
}

void MySQLParser::WindowFrameBetweenContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameBetween(this);
}


std::any MySQLParser::WindowFrameBetweenContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameBetween(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameBetweenContext* MySQLParser::windowFrameBetween() {
  WindowFrameBetweenContext *_localctx = _tracker.createInstance<WindowFrameBetweenContext>(_ctx, getState());
  enterRule(_localctx, 346, MySQLParser::RuleWindowFrameBetween);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3569);
    match(MySQLParser::BETWEEN_SYMBOL);
    setState(3570);
    windowFrameBound();
    setState(3571);
    match(MySQLParser::AND_SYMBOL);
    setState(3572);
    windowFrameBound();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameBoundContext ------------------------------------------------------------------

MySQLParser::WindowFrameBoundContext::WindowFrameBoundContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::WindowFrameStartContext* MySQLParser::WindowFrameBoundContext::windowFrameStart() {
  return getRuleContext<MySQLParser::WindowFrameStartContext>(0);
}

tree::TerminalNode* MySQLParser::WindowFrameBoundContext::UNBOUNDED_SYMBOL() {
  return getToken(MySQLParser::UNBOUNDED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameBoundContext::FOLLOWING_SYMBOL() {
  return getToken(MySQLParser::FOLLOWING_SYMBOL, 0);
}

MySQLParser::UlonglongNumberContext* MySQLParser::WindowFrameBoundContext::ulonglongNumber() {
  return getRuleContext<MySQLParser::UlonglongNumberContext>(0);
}

tree::TerminalNode* MySQLParser::WindowFrameBoundContext::PARAM_MARKER() {
  return getToken(MySQLParser::PARAM_MARKER, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameBoundContext::INTERVAL_SYMBOL() {
  return getToken(MySQLParser::INTERVAL_SYMBOL, 0);
}

MySQLParser::ExprContext* MySQLParser::WindowFrameBoundContext::expr() {
  return getRuleContext<MySQLParser::ExprContext>(0);
}

MySQLParser::IntervalContext* MySQLParser::WindowFrameBoundContext::interval() {
  return getRuleContext<MySQLParser::IntervalContext>(0);
}


size_t MySQLParser::WindowFrameBoundContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameBound;
}

void MySQLParser::WindowFrameBoundContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameBound(this);
}

void MySQLParser::WindowFrameBoundContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameBound(this);
}


std::any MySQLParser::WindowFrameBoundContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameBound(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameBoundContext* MySQLParser::windowFrameBound() {
  WindowFrameBoundContext *_localctx = _tracker.createInstance<WindowFrameBoundContext>(_ctx, getState());
  enterRule(_localctx, 348, MySQLParser::RuleWindowFrameBound);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3587);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 333, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3574);
      windowFrameStart();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3575);
      match(MySQLParser::UNBOUNDED_SYMBOL);
      setState(3576);
      match(MySQLParser::FOLLOWING_SYMBOL);
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(3577);
      ulonglongNumber();
      setState(3578);
      match(MySQLParser::FOLLOWING_SYMBOL);
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(3580);
      match(MySQLParser::PARAM_MARKER);
      setState(3581);
      match(MySQLParser::FOLLOWING_SYMBOL);
      break;
    }

    case 5: {
      enterOuterAlt(_localctx, 5);
      setState(3582);
      match(MySQLParser::INTERVAL_SYMBOL);
      setState(3583);
      expr(0);
      setState(3584);
      interval();
      setState(3585);
      match(MySQLParser::FOLLOWING_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameExclusionContext ------------------------------------------------------------------

MySQLParser::WindowFrameExclusionContext::WindowFrameExclusionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::EXCLUDE_SYMBOL() {
  return getToken(MySQLParser::EXCLUDE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::CURRENT_SYMBOL() {
  return getToken(MySQLParser::CURRENT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::ROW_SYMBOL() {
  return getToken(MySQLParser::ROW_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::GROUP_SYMBOL() {
  return getToken(MySQLParser::GROUP_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::TIES_SYMBOL() {
  return getToken(MySQLParser::TIES_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::NO_SYMBOL() {
  return getToken(MySQLParser::NO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::OTHERS_SYMBOL() {
  return getToken(MySQLParser::OTHERS_SYMBOL, 0);
}


size_t MySQLParser::WindowFrameExclusionContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameExclusion;
}

void MySQLParser::WindowFrameExclusionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameExclusion(this);
}

void MySQLParser::WindowFrameExclusionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameExclusion(this);
}


std::any MySQLParser::WindowFrameExclusionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameExclusion(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameExclusionContext* MySQLParser::windowFrameExclusion() {
  WindowFrameExclusionContext *_localctx = _tracker.createInstance<WindowFrameExclusionContext>(_ctx, getState());
  enterRule(_localctx, 350, MySQLParser::RuleWindowFrameExclusion);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3589);
    match(MySQLParser::EXCLUDE_SYMBOL);
    setState(3596);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::CURRENT_SYMBOL: {
        setState(3590);
        match(MySQLParser::CURRENT_SYMBOL);
        setState(3591);
        match(MySQLParser::ROW_SYMBOL);
        break;
      }

      case MySQLParser::GROUP_SYMBOL: {
        setState(3592);
        match(MySQLParser::GROUP_SYMBOL);
        break;
      }

      case MySQLParser::TIES_SYMBOL: {
        setState(3593);
        match(MySQLParser::TIES_SYMBOL);
        break;
      }

      case MySQLParser::NO_SYMBOL: {
        setState(3594);
        match(MySQLParser::NO_SYMBOL);
        setState(3595);
        match(MySQLParser::OTHERS_SYMBOL);
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WithClauseContext ------------------------------------------------------------------

MySQLParser::WithClauseContext::WithClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WithClauseContext::WITH_SYMBOL() {
  return getToken(MySQLParser::WITH_SYMBOL, 0);
}

std::vector<MySQLParser::CommonTableExpressionContext *> MySQLParser::WithClauseContext::commonTableExpression() {
  return getRuleContexts<MySQLParser::CommonTableExpressionContext>();
}

MySQLParser::CommonTableExpressionContext* MySQLParser::WithClauseContext::commonTableExpression(size_t i) {
  return getRuleContext<MySQLParser::CommonTableExpressionContext>(i);
}

tree::TerminalNode* MySQLParser::WithClauseContext::RECURSIVE_SYMBOL() {
  return getToken(MySQLParser::RECURSIVE_SYMBOL, 0);
}

std::vector<tree::TerminalNode *> MySQLParser::WithClauseContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::WithClauseContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::WithClauseContext::getRuleIndex() const {
  return MySQLParser::RuleWithClause;
}

void MySQLParser::WithClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWithClause(this);
}

void MySQLParser::WithClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWithClause(this);
}


std::any MySQLParser::WithClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWithClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WithClauseContext* MySQLParser::withClause() {
  WithClauseContext *_localctx = _tracker.createInstance<WithClauseContext>(_ctx, getState());
  enterRule(_localctx, 352, MySQLParser::RuleWithClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3598);
    match(MySQLParser::WITH_SYMBOL);
    setState(3600);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 335, _ctx)) {
    case 1: {
      setState(3599);
      match(MySQLParser::RECURSIVE_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(3602);
    commonTableExpression();
    setState(3607);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 336, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3603);
        match(MySQLParser::COMMA_SYMBOL);
        setState(3604);
        commonTableExpression(); 
      }
      setState(3609);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 336, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CommonTableExpressionContext ------------------------------------------------------------------

MySQLParser::CommonTableExpressionContext::CommonTableExpressionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::IdentifierContext* MySQLParser::CommonTableExpressionContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::CommonTableExpressionContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}

MySQLParser::SubqueryContext* MySQLParser::CommonTableExpressionContext::subquery() {
  return getRuleContext<MySQLParser::SubqueryContext>(0);
}

MySQLParser::ColumnInternalRefListContext* MySQLParser::CommonTableExpressionContext::columnInternalRefList() {
  return getRuleContext<MySQLParser::ColumnInternalRefListContext>(0);
}


size_t MySQLParser::CommonTableExpressionContext::getRuleIndex() const {
  return MySQLParser::RuleCommonTableExpression;
}

void MySQLParser::CommonTableExpressionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCommonTableExpression(this);
}

void MySQLParser::CommonTableExpressionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCommonTableExpression(this);
}


std::any MySQLParser::CommonTableExpressionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCommonTableExpression(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CommonTableExpressionContext* MySQLParser::commonTableExpression() {
  CommonTableExpressionContext *_localctx = _tracker.createInstance<CommonTableExpressionContext>(_ctx, getState());
  enterRule(_localctx, 354, MySQLParser::RuleCommonTableExpression);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3610);
    identifier();
    setState(3612);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OPEN_PAR_SYMBOL) {
      setState(3611);
      columnInternalRefList();
    }
    setState(3614);
    match(MySQLParser::AS_SYMBOL);
    setState(3615);
    subquery();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- GroupByClauseContext ------------------------------------------------------------------

MySQLParser::GroupByClauseContext::GroupByClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::GroupByClauseContext::GROUP_SYMBOL() {
  return getToken(MySQLParser::GROUP_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::GroupByClauseContext::BY_SYMBOL() {
  return getToken(MySQLParser::BY_SYMBOL, 0);
}

MySQLParser::OrderListContext* MySQLParser::GroupByClauseContext::orderList() {
  return getRuleContext<MySQLParser::OrderListContext>(0);
}

MySQLParser::OlapOptionContext* MySQLParser::GroupByClauseContext::olapOption() {
  return getRuleContext<MySQLParser::OlapOptionContext>(0);
}

tree::TerminalNode* MySQLParser::GroupByClauseContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

MySQLParser::GroupListContext* MySQLParser::GroupByClauseContext::groupList() {
  return getRuleContext<MySQLParser::GroupListContext>(0);
}

tree::TerminalNode* MySQLParser::GroupByClauseContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::GroupByClauseContext::ROLLUP_SYMBOL() {
  return getToken(MySQLParser::ROLLUP_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::GroupByClauseContext::CUBE_SYMBOL() {
  return getToken(MySQLParser::CUBE_SYMBOL, 0);
}


size_t MySQLParser::GroupByClauseContext::getRuleIndex() const {
  return MySQLParser::RuleGroupByClause;
}

void MySQLParser::GroupByClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterGroupByClause(this);
}

void MySQLParser::GroupByClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitGroupByClause(this);
}


std::any MySQLParser::GroupByClauseContext::accept(tree::ParseTreeVisitor *visitor)