# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core import AsyncPipelineClient
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._utils.serialization import Deserializer, Serializer
from ...operations._targets_operations import (
    build_create_or_update_request,
    build_delete_request,
    build_get_request,
    build_list_request,
)
from .._configuration import ChaosManagementClientConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class TargetsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.chaos.aio.ChaosManagementClient`'s
        :attr:`targets` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: ChaosManagementClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        resource_group_name: str,
        parent_provider_namespace: str,
        parent_resource_type: str,
        parent_resource_name: str,
        continuation_token_parameter: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.Target"]:
        """Get a list of Target resources that extend a tracked regional resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param parent_provider_namespace: The parent resource provider namespace. Required.
        :type parent_provider_namespace: str
        :param parent_resource_type: The parent resource type. Required.
        :type parent_resource_type: str
        :param parent_resource_name: The parent resource name. Required.
        :type parent_resource_name: str
        :param continuation_token_parameter: String that sets the continuation token. Default value is
         None.
        :type continuation_token_parameter: str
        :return: An iterator like instance of either Target or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.chaos.models.Target]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.TargetListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_request(
                    resource_group_name=resource_group_name,
                    parent_provider_namespace=parent_provider_namespace,
                    parent_resource_type=parent_resource_type,
                    parent_resource_name=parent_resource_name,
                    subscription_id=self._config.subscription_id,
                    continuation_token_parameter=continuation_token_parameter,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("TargetListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(
        self,
        resource_group_name: str,
        parent_provider_namespace: str,
        parent_resource_type: str,
        parent_resource_name: str,
        target_name: str,
        **kwargs: Any
    ) -> _models.Target:
        """Get a Target resource that extends a tracked regional resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param parent_provider_namespace: The parent resource provider namespace. Required.
        :type parent_provider_namespace: str
        :param parent_resource_type: The parent resource type. Required.
        :type parent_resource_type: str
        :param parent_resource_name: The parent resource name. Required.
        :type parent_resource_name: str
        :param target_name: String that represents a Target resource name. Required.
        :type target_name: str
        :return: Target or the result of cls(response)
        :rtype: ~azure.mgmt.chaos.models.Target
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.Target] = kwargs.pop("cls", None)

        _request = build_get_request(
            resource_group_name=resource_group_name,
            parent_provider_namespace=parent_provider_namespace,
            parent_resource_type=parent_resource_type,
            parent_resource_name=parent_resource_name,
            target_name=target_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Target", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update(
        self,
        resource_group_name: str,
        parent_provider_namespace: str,
        parent_resource_type: str,
        parent_resource_name: str,
        target_name: str,
        resource: _models.Target,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Target:
        """Create or update a Target resource that extends a tracked regional resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param parent_provider_namespace: The parent resource provider namespace. Required.
        :type parent_provider_namespace: str
        :param parent_resource_type: The parent resource type. Required.
        :type parent_resource_type: str
        :param parent_resource_name: The parent resource name. Required.
        :type parent_resource_name: str
        :param target_name: String that represents a Target resource name. Required.
        :type target_name: str
        :param resource: Target resource to be created or updated. Required.
        :type resource: ~azure.mgmt.chaos.models.Target
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Target or the result of cls(response)
        :rtype: ~azure.mgmt.chaos.models.Target
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update(
        self,
        resource_group_name: str,
        parent_provider_namespace: str,
        parent_resource_type: str,
        parent_resource_name: str,
        target_name: str,
        resource: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Target:
        """Create or update a Target resource that extends a tracked regional resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param parent_provider_namespace: The parent resource provider namespace. Required.
        :type parent_provider_namespace: str
        :param parent_resource_type: The parent resource type. Required.
        :type parent_resource_type: str
        :param parent_resource_name: The parent resource name. Required.
        :type parent_resource_name: str
        :param target_name: String that represents a Target resource name. Required.
        :type target_name: str
        :param resource: Target resource to be created or updated. Required.
        :type resource: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Target or the result of cls(response)
        :rtype: ~azure.mgmt.chaos.models.Target
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update(
        self,
        resource_group_name: str,
        parent_provider_namespace: str,
        parent_resource_type: str,
        parent_resource_name: str,
        target_name: str,
        resource: Union[_models.Target, IO[bytes]],
        **kwargs: Any
    ) -> _models.Target:
        """Create or update a Target resource that extends a tracked regional resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param parent_provider_namespace: The parent resource provider namespace. Required.
        :type parent_provider_namespace: str
        :param parent_resource_type: The parent resource type. Required.
        :type parent_resource_type: str
        :param parent_resource_name: The parent resource name. Required.
        :type parent_resource_name: str
        :param target_name: String that represents a Target resource name. Required.
        :type target_name: str
        :param resource: Target resource to be created or updated. Is either a Target type or a
         IO[bytes] type. Required.
        :type resource: ~azure.mgmt.chaos.models.Target or IO[bytes]
        :return: Target or the result of cls(response)
        :rtype: ~azure.mgmt.chaos.models.Target
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Target] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(resource, (IOBase, bytes)):
            _content = resource
        else:
            _json = self._serialize.body(resource, "Target")

        _request = build_create_or_update_request(
            resource_group_name=resource_group_name,
            parent_provider_namespace=parent_provider_namespace,
            parent_resource_type=parent_resource_type,
            parent_resource_name=parent_resource_name,
            target_name=target_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Target", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete(
        self,
        resource_group_name: str,
        parent_provider_namespace: str,
        parent_resource_type: str,
        parent_resource_name: str,
        target_name: str,
        **kwargs: Any
    ) -> None:
        """Delete a Target resource that extends a tracked regional resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param parent_provider_namespace: The parent resource provider namespace. Required.
        :type parent_provider_namespace: str
        :param parent_resource_type: The parent resource type. Required.
        :type parent_resource_type: str
        :param parent_resource_name: The parent resource name. Required.
        :type parent_resource_name: str
        :param target_name: String that represents a Target resource name. Required.
        :type target_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_request(
            resource_group_name=resource_group_name,
            parent_provider_namespace=parent_provider_namespace,
            parent_resource_type=parent_resource_type,
            parent_resource_name=parent_resource_name,
            target_name=target_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
