RabbitMQ `3.9.15` is a maintenance release in the `3.9.x` release series.

Please refer to the **Upgrading to 3.9** section from [v3.9.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.9.0) if upgrading from a version prior to 3.9.0.

This release requires at least Erlang 23.2, and supports Erlang 24. [RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on Erlang version requirements for RabbitMQ.


## Changes Worth Mentioning

Release notes are kept under [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.9.x/release-notes).
Contributors are encouraged to update them together with their changes. This helps with release automation and a more consistent release schedule.

### Core Server

#### Bug Fixes

 * Stream delivery rate could drop if concurrent stream consumers consumed in a way
   that made them reach the end of the stream often.

   GitHub issue: [#4371](https://github.com/rabbitmq/rabbitmq-server/pull/4371)

 * If a cluster that had streams enabled was upgraded with a jump of multiple
   patch releases, stream state could fail an upgrade.

   GitHub issue: [#4510](https://github.com/rabbitmq/rabbitmq-server/issues/4510)

 * Significantly faster queue re-import from [definitions](https://rabbitmq.com/definitions.html)
   on subsequent node restarts. Initial definition import still takes
   the same amount of time as before.

   GitHub issue: [#4538](https://github.com/rabbitmq/rabbitmq-server/pull/4538)

 * When a policy contained keys unsupported by a particular queue
   type, and later updated or superseded by a higher priority policy,
   effective optional argument list could become inconsistent (policy
   would not have the expected effect).

   Kudos to @jaroslaw-bochniak for providing very detailed reproduction steps.

   GitHub issue: [#4463](https://github.com/rabbitmq/rabbitmq-server/pull/4463)

 * Priority queues could run into an exception in some cases.

   Contributed by @luos and @olikasg.

   GitHub issue: [#4405](https://github.com/rabbitmq/rabbitmq-server/issues/4405)

 * Maintenance mode could run into a timeout during queue leadership transfer.

   Contributed by @felixhuettner.

   GitHub issue: [#4468](https://github.com/rabbitmq/rabbitmq-server/pull/4468)


### Prometheus Plugin

#### Bug Fixes

 * Prometheus collector could run into an exception early on node's
   schema database sync.

   GitHub issue: [#4376](https://github.com/rabbitmq/rabbitmq-server/pull/4376)


### Management Plugin

#### Bug Fixes

 * Connection data transfer rate units were incorrectly displayed when
   rate was less than 1 kiB per second.

   Contributed by @zgabi.

   GitHub issue: [#4523](https://github.com/rabbitmq/rabbitmq-server/issues/4523)

 * `rabbitmqadmin` now correctly loads TLS-related keys from its configuration file.

   Contributed by @fwolfsjaeger.

   GitHub issue: [#4408](https://github.com/rabbitmq/rabbitmq-server/pull/4408)

 * Corrected a help message for node memory usage tool tip.

   Contributed by @etc-crontab.

   GitHub issue: [#4493](https://github.com/rabbitmq/rabbitmq-server/issues/4493)


### LDAP Plugin

#### Enhancements

  * More Erlang 24.3's `eldap` library compatibility improvements.

    GitHub issue: [#4448](https://github.com/rabbitmq/rabbitmq-server/pull/4448)


## Dependency Upgrades

 * `ra` upgraded [from `2.0.4` to `2.0.9`](https://github.com/rabbitmq/ra/compare/v2.0.4...v2.0.9)
 * `prometheus` upgraded from [`4.8.1` to `4.8.2`](https://github.com/deadtrickster/prometheus.erl/compare/06425c21a39c1564164f1cc3fe5bdfa8b23b1f78...v4.8.2)
 * `eetcd` upgraded from [`0.3.3` to `0.3.5`](https://github.com/zhongwencool/eetcd/compare/v0.3.3...v0.3.5)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.9.15.tar.xz`
instead of the source tarball produced by GitHub.
