#!/usr/bin/env bash

# Copyright (C) 2016 Red Hat, Inc. All rights reserved.
#
# This copyrighted material is made available to anyone wishing to use,
# modify, copy, or redistribute it subject to the terms and conditions
# of the GNU General Public License v.2.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA



. lib/inittest --skip-with-lvmpolld

env printf "" || skip # skip if printf is not available

# create the PV with PV ext vsn 1 and a vg
create_pv_with_ext_vsn1_and_vg()
{
  VG_NAME="LVMTEST12345pvextupdatevg"
  LV_NAME="lvol0"

  # FIXME
  # echo -e is bashism, dash builtin sh doesn't do \xNN in printf either
  # printf comes from coreutils, and is probably not posix either

  # PV header with PV extension version 1
  env printf \
"\x4c\x41\x42\x45\x4c\x4f\x4e\x45\x01\x00\x00\x00\x00\x00\x00\x00"\
"\x78\x1c\x12\x43\x20\x00\x00\x00\x4c\x56\x4d\x32\x20\x30\x30\x31"\
"\x64\x35\x56\x33\x38\x5a\x57\x49\x63\x7a\x64\x63\x34\x38\x37\x67"\
"\x4d\x79\x46\x4b\x6c\x6d\x68\x39\x4e\x73\x34\x6f\x78\x61\x6b\x51"\
"\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00"\
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"\
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00"\
"\x00\xf0\x0f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"\
"\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"\
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" | dd of="$1" bs=512 seek=1 conv=notrunc

  # MDA header
  env printf \
"\xd8\x36\x2c\xf6\x20\x4c\x56\x4d\x32\x20\x78\x5b\x35\x41\x25\x72"\
"\x30\x4e\x2a\x3e\x01\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00"\
"\x00\xf0\x0f\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x00"\
"\x06\x04\x00\x00\x00\x00\x00\x00\x07\x3d\x06\x28\x00\x00\x00\x00"\
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" | dd of="$1" bs=4096 seek=1 conv=notrunc

  # VG metadata
  env printf \
"\x4c\x56\x4d\x54\x45\x53\x54\x31\x32\x33\x34\x35\x70\x76\x65\x78"\
"\x74\x75\x70\x64\x61\x74\x65\x76\x67\x20\x7b\x0a\x69\x64\x20\x3d"\
"\x20\x22\x42\x72\x47\x6f\x34\x33\x2d\x36\x35\x62\x48\x2d\x41\x55"\
"\x6d\x43\x2d\x77\x56\x74\x71\x2d\x51\x53\x63\x66\x2d\x6b\x5a\x51"\
"\x45\x2d\x58\x51\x6e\x79\x31\x44\x22\x0a\x73\x65\x71\x6e\x6f\x20"\
"\x3d\x20\x31\x0a\x66\x6f\x72\x6d\x61\x74\x20\x3d\x20\x22\x6c\x76"\
"\x6d\x32\x22\x0a\x73\x74\x61\x74\x75\x73\x20\x3d\x20\x5b\x22\x52"\
"\x45\x53\x49\x5a\x45\x41\x42\x4c\x45\x22\x2c\x20\x22\x52\x45\x41"\
"\x44\x22\x2c\x20\x22\x57\x52\x49\x54\x45\x22\x5d\x0a\x66\x6c\x61"\
"\x67\x73\x20\x3d\x20\x5b\x5d\x0a\x65\x78\x74\x65\x6e\x74\x5f\x73"\
"\x69\x7a\x65\x20\x3d\x20\x38\x31\x39\x32\x0a\x6d\x61\x78\x5f\x6c"\
"\x76\x20\x3d\x20\x30\x0a\x6d\x61\x78\x5f\x70\x76\x20\x3d\x20\x30"\
"\x0a\x6d\x65\x74\x61\x64\x61\x74\x61\x5f\x63\x6f\x70\x69\x65\x73"\
"\x20\x3d\x20\x30\x0a\x0a\x70\x68\x79\x73\x69\x63\x61\x6c\x5f\x76"\
"\x6f\x6c\x75\x6d\x65\x73\x20\x7b\x0a\x0a\x70\x76\x30\x20\x7b\x0a"\
"\x69\x64\x20\x3d\x20\x22\x64\x35\x56\x33\x38\x5a\x2d\x57\x49\x63"\
"\x7a\x2d\x64\x63\x34\x38\x2d\x37\x67\x4d\x79\x2d\x46\x4b\x6c\x6d"\
"\x2d\x68\x39\x4e\x73\x2d\x34\x6f\x78\x61\x6b\x51\x22\x0a\x64\x65"\
"\x76\x69\x63\x65\x20\x3d\x20\x22\x2f\x64\x65\x76\x2f\x6c\x6f\x6f"\
"\x70\x30\x22\x0a\x0a\x73\x74\x61\x74\x75\x73\x20\x3d\x20\x5b\x22"\
"\x41\x4c\x4c\x4f\x43\x41\x54\x41\x42\x4c\x45\x22\x5d\x0a\x66\x6c"\
"\x61\x67\x73\x20\x3d\x20\x5b\x5d\x0a\x64\x65\x76\x5f\x73\x69\x7a"\
"\x65\x20\x3d\x20\x31\x36\x33\x38\x34\x0a\x70\x65\x5f\x73\x74\x61"\
"\x72\x74\x20\x3d\x20\x32\x30\x34\x38\x0a\x70\x65\x5f\x63\x6f\x75"\
"\x6e\x74\x20\x3d\x20\x31\x0a\x7d\x0a\x7d\x0a\x0a\x7d\x0a\x23\x20"\
"\x47\x65\x6e\x65\x72\x61\x74\x65\x64\x20\x62\x79\x20\x4c\x56\x4d"\
"\x32\x20\x76\x65\x72\x73\x69\x6f\x6e\x20\x32\x2e\x30\x32\x2e\x31"\
"\x34\x32\x28\x32\x29\x2d\x67\x69\x74\x20\x28\x32\x30\x31\x36\x2d"\
"\x30\x32\x2d\x31\x35\x29\x3a\x20\x57\x65\x64\x20\x4a\x75\x6c\x20"\
"\x32\x37\x20\x31\x31\x3a\x32\x35\x3a\x30\x37\x20\x32\x30\x31\x36"\
"\x0a\x0a\x63\x6f\x6e\x74\x65\x6e\x74\x73\x20\x3d\x20\x22\x54\x65"\
"\x78\x74\x20\x46\x6f\x72\x6d\x61\x74\x20\x56\x6f\x6c\x75\x6d\x65"\
"\x20\x47\x72\x6f\x75\x70\x22\x0a\x76\x65\x72\x73\x69\x6f\x6e\x20"\
"\x3d\x20\x31\x0a\x0a\x64\x65\x73\x63\x72\x69\x70\x74\x69\x6f\x6e"\
"\x20\x3d\x20\x22\x22\x0a\x0a\x63\x72\x65\x61\x74\x69\x6f\x6e\x5f"\
"\x68\x6f\x73\x74\x20\x3d\x20\x22\x66\x65\x64\x6f\x72\x61\x2e\x76"\
"\x69\x72\x74\x22\x09\x23\x20\x4c\x69\x6e\x75\x78\x20\x66\x65\x64"\
"\x6f\x72\x61\x2e\x76\x69\x72\x74\x20\x34\x2e\x36\x2e\x34\x2d\x33"\
"\x30\x31\x2e\x66\x63\x32\x34\x2e\x78\x38\x36\x5f\x36\x34\x20\x23"\
"\x31\x20\x53\x4d\x50\x20\x54\x75\x65\x20\x4a\x75\x6c\x20\x31\x32"\
"\x20\x31\x31\x3a\x35\x30\x3a\x30\x30\x20\x55\x54\x43\x20\x32\x30"\
"\x31\x36\x20\x78\x38\x36\x5f\x36\x34\x0a\x63\x72\x65\x61\x74\x69"\
"\x6f\x6e\x5f\x74\x69\x6d\x65\x20\x3d\x20\x31\x34\x36\x39\x36\x31"\
"\x31\x35\x30\x37\x09\x23\x20\x57\x65\x64\x20\x4a\x75\x6c\x20\x32"\
"\x37\x20\x31\x31\x3a\x32\x35\x3a\x30\x37\x20\x32\x30\x31\x36\x0a"\
"\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"\
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" | dd of="$1" bs=4608 seek=1 conv=notrunc

  env printf \
"\x4c\x56\x4d\x54\x45\x53\x54\x31\x32\x33\x34\x35\x70\x76\x65\x78"\
"\x74\x75\x70\x64\x61\x74\x65\x76\x67\x20\x7b\x0a\x69\x64\x20\x3d"\
"\x20\x22\x42\x72\x47\x6f\x34\x33\x2d\x36\x35\x62\x48\x2d\x41\x55"\
"\x6d\x43\x2d\x77\x56\x74\x71\x2d\x51\x53\x63\x66\x2d\x6b\x5a\x51"\
"\x45\x2d\x58\x51\x6e\x79\x31\x44\x22\x0a\x73\x65\x71\x6e\x6f\x20"\
"\x3d\x20\x32\x0a\x66\x6f\x72\x6d\x61\x74\x20\x3d\x20\x22\x6c\x76"\
"\x6d\x32\x22\x0a\x73\x74\x61\x74\x75\x73\x20\x3d\x20\x5b\x22\x52"\
"\x45\x53\x49\x5a\x45\x41\x42\x4c\x45\x22\x2c\x20\x22\x52\x45\x41"\
"\x44\x22\x2c\x20\x22\x57\x52\x49\x54\x45\x22\x5d\x0a\x66\x6c\x61"\
"\x67\x73\x20\x3d\x20\x5b\x5d\x0a\x65\x78\x74\x65\x6e\x74\x5f\x73"\
"\x69\x7a\x65\x20\x3d\x20\x38\x31\x39\x32\x0a\x6d\x61\x78\x5f\x6c"\
"\x76\x20\x3d\x20\x30\x0a\x6d\x61\x78\x5f\x70\x76\x20\x3d\x20\x30"\
"\x0a\x6d\x65\x74\x61\x64\x61\x74\x61\x5f\x63\x6f\x70\x69\x65\x73"\
"\x20\x3d\x20\x30\x0a\x0a\x70\x68\x79\x73\x69\x63\x61\x6c\x5f\x76"\
"\x6f\x6c\x75\x6d\x65\x73\x20\x7b\x0a\x0a\x70\x76\x30\x20\x7b\x0a"\
"\x69\x64\x20\x3d\x20\x22\x64\x35\x56\x33\x38\x5a\x2d\x57\x49\x63"\
"\x7a\x2d\x64\x63\x34\x38\x2d\x37\x67\x4d\x79\x2d\x46\x4b\x6c\x6d"\
"\x2d\x68\x39\x4e\x73\x2d\x34\x6f\x78\x61\x6b\x51\x22\x0a\x64\x65"\
"\x76\x69\x63\x65\x20\x3d\x20\x22\x2f\x64\x65\x76\x2f\x6c\x6f\x6f"\
"\x70\x30\x22\x0a\x0a\x73\x74\x61\x74\x75\x73\x20\x3d\x20\x5b\x22"\
"\x41\x4c\x4c\x4f\x43\x41\x54\x41\x42\x4c\x45\x22\x5d\x0a\x66\x6c"\
"\x61\x67\x73\x20\x3d\x20\x5b\x5d\x0a\x64\x65\x76\x5f\x73\x69\x7a"\
"\x65\x20\x3d\x20\x31\x36\x33\x38\x34\x0a\x70\x65\x5f\x73\x74\x61"\
"\x72\x74\x20\x3d\x20\x32\x30\x34\x38\x0a\x70\x65\x5f\x63\x6f\x75"\
"\x6e\x74\x20\x3d\x20\x31\x0a\x7d\x0a\x7d\x0a\x0a\x6c\x6f\x67\x69"\
"\x63\x61\x6c\x5f\x76\x6f\x6c\x75\x6d\x65\x73\x20\x7b\x0a\x0a\x6c"\
"\x76\x6f\x6c\x30\x20\x7b\x0a\x69\x64\x20\x3d\x20\x22\x46\x73\x36"\
"\x6c\x6a\x6b\x2d\x4a\x65\x5a\x35\x2d\x55\x4e\x75\x37\x2d\x32\x41"\
"\x33\x50\x2d\x76\x30\x41\x43\x2d\x64\x63\x64\x36\x2d\x32\x33\x38"\
"\x39\x4d\x76\x22\x0a\x73\x74\x61\x74\x75\x73\x20\x3d\x20\x5b\x22"\
"\x52\x45\x41\x44\x22\x2c\x20\x22\x57\x52\x49\x54\x45\x22\x2c\x20"\
"\x22\x56\x49\x53\x49\x42\x4c\x45\x22\x5d\x0a\x66\x6c\x61\x67\x73"\
"\x20\x3d\x20\x5b\x5d\x0a\x63\x72\x65\x61\x74\x69\x6f\x6e\x5f\x68"\
"\x6f\x73\x74\x20\x3d\x20\x22\x66\x65\x64\x6f\x72\x61\x2e\x76\x69"\
"\x72\x74\x22\x0a\x63\x72\x65\x61\x74\x69\x6f\x6e\x5f\x74\x69\x6d"\
"\x65\x20\x3d\x20\x31\x34\x36\x39\x36\x31\x31\x35\x31\x30\x0a\x73"\
"\x65\x67\x6d\x65\x6e\x74\x5f\x63\x6f\x75\x6e\x74\x20\x3d\x20\x31"\
"\x0a\x0a\x73\x65\x67\x6d\x65\x6e\x74\x31\x20\x7b\x0a\x73\x74\x61"\
"\x72\x74\x5f\x65\x78\x74\x65\x6e\x74\x20\x3d\x20\x30\x0a\x65\x78"\
"\x74\x65\x6e\x74\x5f\x63\x6f\x75\x6e\x74\x20\x3d\x20\x31\x0a\x0a"\
"\x74\x79\x70\x65\x20\x3d\x20\x22\x73\x74\x72\x69\x70\x65\x64\x22"\
"\x0a\x73\x74\x72\x69\x70\x65\x5f\x63\x6f\x75\x6e\x74\x20\x3d\x20"\
"\x31\x0a\x0a\x73\x74\x72\x69\x70\x65\x73\x20\x3d\x20\x5b\x0a\x22"\
"\x70\x76\x30\x22\x2c\x20\x30\x0a\x5d\x0a\x7d\x0a\x7d\x0a\x7d\x0a"\
"\x7d\x0a\x23\x20\x47\x65\x6e\x65\x72\x61\x74\x65\x64\x20\x62\x79"\
"\x20\x4c\x56\x4d\x32\x20\x76\x65\x72\x73\x69\x6f\x6e\x20\x32\x2e"\
"\x30\x32\x2e\x31\x34\x32\x28\x32\x29\x2d\x67\x69\x74\x20\x28\x32"\
"\x30\x31\x36\x2d\x30\x32\x2d\x31\x35\x29\x3a\x20\x57\x65\x64\x20"\
"\x4a\x75\x6c\x20\x32\x37\x20\x31\x31\x3a\x32\x35\x3a\x31\x30\x20"\
"\x32\x30\x31\x36\x0a\x0a\x63\x6f\x6e\x74\x65\x6e\x74\x73\x20\x3d"\
"\x20\x22\x54\x65\x78\x74\x20\x46\x6f\x72\x6d\x61\x74\x20\x56\x6f"\
"\x6c\x75\x6d\x65\x20\x47\x72\x6f\x75\x70\x22\x0a\x76\x65\x72\x73"\
"\x69\x6f\x6e\x20\x3d\x20\x31\x0a\x0a\x64\x65\x73\x63\x72\x69\x70"\
"\x74\x69\x6f\x6e\x20\x3d\x20\x22\x22\x0a\x0a\x63\x72\x65\x61\x74"\
"\x69\x6f\x6e\x5f\x68\x6f\x73\x74\x20\x3d\x20\x22\x66\x65\x64\x6f"\
"\x72\x61\x2e\x76\x69\x72\x74\x22\x09\x23\x20\x4c\x69\x6e\x75\x78"\
"\x20\x66\x65\x64\x6f\x72\x61\x2e\x76\x69\x72\x74\x20\x34\x2e\x36"\
"\x2e\x34\x2d\x33\x30\x31\x2e\x66\x63\x32\x34\x2e\x78\x38\x36\x5f"\
"\x36\x34\x20\x23\x31\x20\x53\x4d\x50\x20\x54\x75\x65\x20\x4a\x75"\
"\x6c\x20\x31\x32\x20\x31\x31\x3a\x35\x30\x3a\x30\x30\x20\x55\x54"\
"\x43\x20\x32\x30\x31\x36\x20\x78\x38\x36\x5f\x36\x34\x0a\x63\x72"\
"\x65\x61\x74\x69\x6f\x6e\x5f\x74\x69\x6d\x65\x20\x3d\x20\x31\x34"\
"\x36\x39\x36\x31\x31\x35\x31\x30\x09\x23\x20\x57\x65\x64\x20\x4a"\
"\x75\x6c\x20\x32\x37\x20\x31\x31\x3a\x32\x35\x3a\x31\x30\x20\x32"\
"\x30\x31\x36\x0a\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"\
"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" | dd of="$1" bs=5632 seek=1 conv=notrunc
}

aux prepare_devs 1 8

create_pv_with_ext_vsn1_and_vg "$dev1"

# pvs doesn't update PV header because it holds only VG read lock
check pv_field "$dev1" pv_ext_vsn 1
check pv_field "$dev1" pv_in_use "used"
check pv_field "$dev1" vg_name "$VG_NAME"
lvs "$VG_NAME"/"$LV_NAME"

# an LVM command taking VG write lock will also cause PV header update to recent version
vgchange --addtag test $VG_NAME
check pv_field "$dev1" pv_ext_vsn 2
check pv_field "$dev1" pv_in_use "used"
check pv_field "$dev1" vg_name "$VG_NAME"
lvs "$VG_NAME"/"$LV_NAME"
