/* This testcase is part of GDB, the GNU debugger.

   Copyright 2021-2026 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

static void
break_here_execer ()
{}

int
main ()
{
  /* FORK is defined to fork or vfork by the test.  */
  int pid = FORK ();
  if (pid != 0)
    {
      /* Parent.  */
      break_here_execer ();
    }
  else
    {
      /* EXECEE is defined by the test.  */
      int ret = execl (EXECEE, EXECEE, NULL);
      perror ("exec");
      abort ();
    }

    return 0;
}
