-- CA2011B.ADA

--                             Grant of Unlimited Rights
--
--     Under contracts F33600-87-D-0337, F33600-84-D-0280, MDA903-79-C-0687,
--     F08630-91-C-0015, and DCA100-97-D-0025, the U.S. Government obtained 
--     unlimited rights in the software and documentation contained herein.
--     Unlimited rights are defined in DFAR 252.227-7013(a)(19).  By making 
--     this public release, the Government intends to confer upon all 
--     recipients unlimited rights  equal to those held by the Government.  
--     These rights include rights to use, duplicate, release or disclose the 
--     released technical data and computer software in whole or in part, in 
--     any manner and for any purpose whatsoever, and to have or permit others 
--     to do so.
--
--                                    DISCLAIMER
--
--     ALL MATERIALS OR INFORMATION HEREIN RELEASED, MADE AVAILABLE OR
--     DISCLOSED ARE AS IS.  THE GOVERNMENT MAKES NO EXPRESS OR IMPLIED 
--     WARRANTY AS TO ANY MATTER WHATSOEVER, INCLUDING THE CONDITIONS OF THE
--     SOFTWARE, DOCUMENTATION OR OTHER INFORMATION RELEASED, MADE AVAILABLE 
--     OR DISCLOSED, OR THE OWNERSHIP, MERCHANTABILITY, OR FITNESS FOR A
--     PARTICULAR PURPOSE OF SAID MATERIAL.
--*
-- OBJECTIVE:
--     CHECK THAT FOR A SUBPROGRAM DECLARATION-STUB-BODY TRIPLE, THE
--     DECLARATION-STUB AND STUB-BODY SPECIFICATIONS CAN CONFORM, BUT
--     THE DECLARATION-BODY SPECIFICATIONS NEED NOT.

-- HISTORY:
--     JET 08/01/88  CREATED ORIGINAL TEST.

PACKAGE CA2011B0 IS
     SUBTYPE T IS INTEGER RANGE -100 .. 100;
     I : T := 0;
END CA2011B0;

WITH CA2011B0; USE CA2011B0;
PACKAGE CA2011B1 IS
     PROCEDURE P1 (X : CA2011B0.T);
     PROCEDURE P2 (X : T);
END CA2011B1;

WITH REPORT; USE REPORT;
PRAGMA ELABORATE (REPORT);
PACKAGE BODY CA2011B1 IS
     PACKAGE CA2011BX RENAMES CA2011B0;
     PROCEDURE P1 (X : T) IS SEPARATE;
     PROCEDURE P2 (X : CA2011BX.T) IS SEPARATE;
END CA2011B1;

SEPARATE (CA2011B1)
PROCEDURE P1 (X : CA2011BX.T) IS
BEGIN
     I := IDENT_INT(X);
END P1;

SEPARATE (CA2011B1)
PROCEDURE P2 (X : CA2011BX.T) IS
BEGIN
     I := IDENT_INT(X);
END P2;

WITH REPORT; USE REPORT;
WITH CA2011B0, CA2011B1;
PROCEDURE CA2011B IS

     PACKAGE P1 IS
          SUBTYPE T IS INTEGER RANGE -100 .. 100;
     END P1;
     USE P1;

     FUNCTION F1 RETURN P1.T;
     FUNCTION F2 RETURN T;

     PACKAGE P2 RENAMES P1;

     FUNCTION F1 RETURN T IS SEPARATE;
     FUNCTION F2 RETURN P2.T IS SEPARATE;

BEGIN
     TEST ("CA2011B", "CHECK THAT FOR A SUBPROGRAM DECLARATION-STUB-" &
                      "BODY TRIPLE, THE DECLARATION-STUB AND STUB-" &
                      "BODY SPECIFICATIONS CAN CONFORM, BUT THE " &
                      "DECLARATON-BODY SPECIFICATIONS NEED NOT");

     IF F1 /= IDENT_INT(100) THEN
          FAILED ("INCORRECT RETURN VALUE FROM FUNCTION 1");
     END IF;

     IF F2 /= IDENT_INT(-100) THEN
          FAILED ("INCORRECT RETURN VALUE FROM FUNCTION 2");
     END IF;

     CA2011B1.P1(3);
     IF CA2011B0.I /= IDENT_INT(3) THEN
          FAILED ("INCORRECT RETURN VALUE FROM PROCEDURE 1");
     END IF;

     CA2011B1.P2(4);
     IF CA2011B0.I /= IDENT_INT(4) THEN
          FAILED ("INCORRECT RETURN VALUE FROM PROCEDURE 2");
     END IF;

     RESULT;
END CA2011B;

SEPARATE (CA2011B)
FUNCTION F1 RETURN P2.T IS
BEGIN
     RETURN 100;
END F1;

SEPARATE (CA2011B)
FUNCTION F2 RETURN P2.T IS
BEGIN
     RETURN -100;
END F2;
