/* { dg-additional-options "-fdiagnostics-text-art-charset=unicode" } */
/* { dg-skip-if "" { powerpc-ibm-aix* } } */

#include <string.h>

void test (void)
{
  char buf[11];
  strcpy (buf, "サツキ");
  strcat (buf, "メイ"); /* { dg-warning "stack-based buffer overflow" } */
  /* { dg-message "write of 5 bytes to beyond the end of 'buf'" "" { target *-*-* } .-1 } */
}

/* { dg-begin-multiline-output "" }
                                                ┌──────┬────┐┌────┬────┬────┬────┬──────┐
                                                │ [0]  │[1] ││[2] │[3] │[4] │[5] │ [6]  │
                                                ├──────┼────┤├────┼────┼────┼────┼──────┤
                                                │ 0xe3 │0x83││0xa1│0xe3│0x82│0xa4│ 0x00 │
                                                ├──────┴────┴┴────┼────┴────┴────┼──────┤
                                                │     U+30e1      │    U+30a4    │U+0000│
                                                ├─────────────────┼──────────────┼──────┤
                                                │       メ        │      イ      │ NUL  │
                                                ├─────────────────┴──────────────┴──────┤
                                                │   string literal (type: 'char[7]')    │
                                                └───────────────────────────────────────┘
                                                   │     │     │    │    │    │     │
                                                   │     │     │    │    │    │     │
                                                   v     v     v    v    v    v     v
  ┌────┬────────────────────────────────────────┬──────┬────┐┌──────────────────────────┐
  │[0] │                  ...                   │ [9]  │[10]││                          │
  ├────┼────┬────┬────┬────┬────┬────┬────┬────┬┼──────┼────┘│                          │
  │0xe3│0x82│0xb5│0xe3│0x83│0x84│0xe3│0x82│0xad││ 0x00 │     │                          │
  ├────┴────┴────┼────┴────┴────┼────┴────┴────┤├──────┤     │                          │
  │    U+30b5    │    U+30c4    │    U+30ad    ││U+0000│     │    after valid range     │
  ├──────────────┼──────────────┼──────────────┤├──────┤     │                          │
  │      サ      │      ツ      │      キ      ││ NUL  │     │                          │
  ├──────────────┴──────────────┴──────────────┴┴──────┴────┐│                          │
  │                'buf' (type: 'char[11]')                 ││                          │
  └─────────────────────────────────────────────────────────┘└──────────────────────────┘
  ├────────────────────────────┬────────────────────────────┤├────────────┬─────────────┤
                               │                                          │
                     ╭─────────┴────────╮                       ╭─────────┴─────────╮
                     │capacity: 11 bytes│                       │overflow of 5 bytes│
                     ╰──────────────────╯                       ╰───────────────────╯
   { dg-end-multiline-output "" } */
