; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc < %s -mtriple=arm64-linux-gnu | FileCheck %s
; RUN: llc < %s -mtriple=arm64-linux-gnu -global-isel | FileCheck %s

define float @test_fminv_v2f32(<2 x float> %in) {
; CHECK-LABEL: test_fminv_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fminp s0, v0.2s
; CHECK-NEXT:    ret
  %min = call float @llvm.aarch64.neon.fminv.f32.v2f32(<2 x float> %in)
  ret float %min
}

define float @test_fminv_v4f32(<4 x float> %in) {
; CHECK-LABEL: test_fminv_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fminv s0, v0.4s
; CHECK-NEXT:    ret
  %min = call float @llvm.aarch64.neon.fminv.f32.v4f32(<4 x float> %in)
  ret float %min
}

define double @test_fminv_v2f64(<2 x double> %in) {
; CHECK-LABEL: test_fminv_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fminp d0, v0.2d
; CHECK-NEXT:    ret
  %min = call double @llvm.aarch64.neon.fminv.f64.v2f64(<2 x double> %in)
  ret double %min
}

declare float @llvm.aarch64.neon.fminv.f32.v2f32(<2 x float>)
declare float @llvm.aarch64.neon.fminv.f32.v4f32(<4 x float>)
declare double @llvm.aarch64.neon.fminv.f64.v2f64(<2 x double>)

define float @test_fmaxv_v2f32(<2 x float> %in) {
; CHECK-LABEL: test_fmaxv_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmaxp s0, v0.2s
; CHECK-NEXT:    ret
  %max = call float @llvm.aarch64.neon.fmaxv.f32.v2f32(<2 x float> %in)
  ret float %max
}

define float @test_fmaxv_v4f32(<4 x float> %in) {
; CHECK-LABEL: test_fmaxv_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmaxv s0, v0.4s
; CHECK-NEXT:    ret
  %max = call float @llvm.aarch64.neon.fmaxv.f32.v4f32(<4 x float> %in)
  ret float %max
}

define double @test_fmaxv_v2f64(<2 x double> %in) {
; CHECK-LABEL: test_fmaxv_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmaxp d0, v0.2d
; CHECK-NEXT:    ret
  %max = call double @llvm.aarch64.neon.fmaxv.f64.v2f64(<2 x double> %in)
  ret double %max
}

declare float @llvm.aarch64.neon.fmaxv.f32.v2f32(<2 x float>)
declare float @llvm.aarch64.neon.fmaxv.f32.v4f32(<4 x float>)
declare double @llvm.aarch64.neon.fmaxv.f64.v2f64(<2 x double>)

define float @test_fminnmv_v2f32(<2 x float> %in) {
; CHECK-LABEL: test_fminnmv_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fminnmp s0, v0.2s
; CHECK-NEXT:    ret
  %minnm = call float @llvm.aarch64.neon.fminnmv.f32.v2f32(<2 x float> %in)
  ret float %minnm
}

define float @test_fminnmv_v4f32(<4 x float> %in) {
; CHECK-LABEL: test_fminnmv_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fminnmv s0, v0.4s
; CHECK-NEXT:    ret
  %minnm = call float @llvm.aarch64.neon.fminnmv.f32.v4f32(<4 x float> %in)
  ret float %minnm
}

define double @test_fminnmv_v2f64(<2 x double> %in) {
; CHECK-LABEL: test_fminnmv_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fminnmp d0, v0.2d
; CHECK-NEXT:    ret
  %minnm = call double @llvm.aarch64.neon.fminnmv.f64.v2f64(<2 x double> %in)
  ret double %minnm
}

declare float @llvm.aarch64.neon.fminnmv.f32.v2f32(<2 x float>)
declare float @llvm.aarch64.neon.fminnmv.f32.v4f32(<4 x float>)
declare double @llvm.aarch64.neon.fminnmv.f64.v2f64(<2 x double>)

define float @test_fmaxnmv_v2f32(<2 x float> %in) {
; CHECK-LABEL: test_fmaxnmv_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmaxnmp s0, v0.2s
; CHECK-NEXT:    ret
  %maxnm = call float @llvm.aarch64.neon.fmaxnmv.f32.v2f32(<2 x float> %in)
  ret float %maxnm
}

define float @test_fmaxnmv_v4f32(<4 x float> %in) {
; CHECK-LABEL: test_fmaxnmv_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmaxnmv s0, v0.4s
; CHECK-NEXT:    ret
  %maxnm = call float @llvm.aarch64.neon.fmaxnmv.f32.v4f32(<4 x float> %in)
  ret float %maxnm
}

define double @test_fmaxnmv_v2f64(<2 x double> %in) {
; CHECK-LABEL: test_fmaxnmv_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmaxnmp d0, v0.2d
; CHECK-NEXT:    ret
  %maxnm = call double @llvm.aarch64.neon.fmaxnmv.f64.v2f64(<2 x double> %in)
  ret double %maxnm
}

declare float @llvm.aarch64.neon.fmaxnmv.f32.v2f32(<2 x float>)
declare float @llvm.aarch64.neon.fmaxnmv.f32.v4f32(<4 x float>)
declare double @llvm.aarch64.neon.fmaxnmv.f64.v2f64(<2 x double>)
