; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=verify,iroutliner -ir-outlining-no-cost < %s | FileCheck %s

; This test checks that floating point commutative instructions are not treated
; as commutative.  Even though an ffadd is technically commutative, the order
; of operands still needs to be enforced since the process of fadding floating
; point values requires the order to be the same.

; We make sure that we outline the identical regions from the first two
; functions, but not the third.  this is because the operands are in a different
; order in a floating point instruction in this section.

define void @outline_from_fadd1() {
; CHECK-LABEL: @outline_from_fadd1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca double, align 4
; CHECK-NEXT:    [[B:%.*]] = alloca double, align 4
; CHECK-NEXT:    [[C:%.*]] = alloca double, align 4
; CHECK-NEXT:    call void @outlined_ir_func_0(ptr [[A]], ptr [[B]], ptr [[C]])
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca double, align 4
  %b = alloca double, align 4
  %c = alloca double, align 4
  store double 2.0, ptr %a, align 4
  store double 3.0, ptr %b, align 4
  store double 4.0, ptr %c, align 4
  %al = load double, ptr %a
  %bl = load double, ptr %b
  %cl = load double, ptr %c
  %0 = fadd double %al, %bl
  %1 = fadd double %al, %cl
  %2 = fadd double %bl, %cl
  ret void
}

define void @outline_from_fadd2.0() {
; CHECK-LABEL: @outline_from_fadd2.0(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca double, align 4
; CHECK-NEXT:    [[B:%.*]] = alloca double, align 4
; CHECK-NEXT:    [[C:%.*]] = alloca double, align 4
; CHECK-NEXT:    call void @outlined_ir_func_0(ptr [[A]], ptr [[B]], ptr [[C]])
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca double, align 4
  %b = alloca double, align 4
  %c = alloca double, align 4
  store double 2.0, ptr %a, align 4
  store double 3.0, ptr %b, align 4
  store double 4.0, ptr %c, align 4
  %al = load double, ptr %a
  %bl = load double, ptr %b
  %cl = load double, ptr %c
  %0 = fadd double %al, %bl
  %1 = fadd double %al, %cl
  %2 = fadd double %bl, %cl
  ret void
}

define void @outline_from_flipped_fadd3.0() {
; CHECK-LABEL: @outline_from_flipped_fadd3.0(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca double, align 4
; CHECK-NEXT:    [[B:%.*]] = alloca double, align 4
; CHECK-NEXT:    [[C:%.*]] = alloca double, align 4
; CHECK-NEXT:    store double 2.000000e+00, ptr [[A]], align 4
; CHECK-NEXT:    store double 3.000000e+00, ptr [[B]], align 4
; CHECK-NEXT:    store double 4.000000e+00, ptr [[C]], align 4
; CHECK-NEXT:    [[AL:%.*]] = load double, ptr [[A]], align 8
; CHECK-NEXT:    [[BL:%.*]] = load double, ptr [[B]], align 8
; CHECK-NEXT:    [[CL:%.*]] = load double, ptr [[C]], align 8
; CHECK-NEXT:    [[TMP0:%.*]] = fadd double [[BL]], [[AL]]
; CHECK-NEXT:    [[TMP1:%.*]] = fadd double [[CL]], [[AL]]
; CHECK-NEXT:    [[TMP2:%.*]] = fadd double [[CL]], [[BL]]
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca double, align 4
  %b = alloca double, align 4
  %c = alloca double, align 4
  store double 2.0, ptr %a, align 4
  store double 3.0, ptr %b, align 4
  store double 4.0, ptr %c, align 4
  %al = load double, ptr %a
  %bl = load double, ptr %b
  %cl = load double, ptr %c
  %0 = fadd double %bl, %al
  %1 = fadd double %cl, %al
  %2 = fadd double %cl, %bl
  ret void
}

; CHECK: define internal void @outlined_ir_func_0(ptr [[ARG0:%.*]], ptr [[ARG1:%.*]], ptr [[ARG2:%.*]]) #0 {
; CHECK: entry_to_outline:
; CHECK-NEXT:    store double 2.000000e+00, ptr [[ARG0]], align 4
; CHECK-NEXT:    store double 3.000000e+00, ptr [[ARG1]], align 4
; CHECK-NEXT:    store double 4.000000e+00, ptr [[ARG2]], align 4
; CHECK-NEXT:    [[AL:%.*]] = load double, ptr [[ARG0]], align 8
; CHECK-NEXT:    [[BL:%.*]] = load double, ptr [[ARG1]], align 8
; CHECK-NEXT:    [[CL:%.*]] = load double, ptr [[ARG2]], align 8
; CHECK-NEXT:    [[TMP0:%.*]] = fadd double [[AL]], [[BL]]
; CHECK-NEXT:    [[TMP1:%.*]] = fadd double [[AL]], [[CL]]
; CHECK-NEXT:    [[TMP2:%.*]] = fadd double [[BL]], [[CL]]

