; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+v,+f,+d,+zvfhmin,+zvfbfmin \
; RUN:     -target-abi=ilp32d -verify-machineinstrs | FileCheck %s --check-prefix=RV32
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv64 -mattr=+v,+f,+d,+zvfhmin,+zvfbfmin \
; RUN:     -target-abi=lp64d -verify-machineinstrs | FileCheck %s --check-prefix=RV64-i32
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+v,+f,+d,+zvfhmin,+zvfbfmin \
; RUN:     -target-abi=lp64d -verify-machineinstrs | FileCheck %s --check-prefix=RV64-i64

define <1 x iXLen> @lrint_v1f32(<1 x float> %x) {
; RV32-LABEL: lrint_v1f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_v1f32:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v8
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_v1f32:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v9, v8
; RV64-i64-NEXT:    vmv1r.v v8, v9
; RV64-i64-NEXT:    ret
  %a = call <1 x iXLen> @llvm.lrint.v1iXLen.v1f32(<1 x float> %x)
  ret <1 x iXLen> %a
}
declare <1 x iXLen> @llvm.lrint.v1iXLen.v1f32(<1 x float>)

define <2 x iXLen> @lrint_v2f32(<2 x float> %x) {
; RV32-LABEL: lrint_v2f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_v2f32:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v8
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_v2f32:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v9, v8
; RV64-i64-NEXT:    vmv1r.v v8, v9
; RV64-i64-NEXT:    ret
  %a = call <2 x iXLen> @llvm.lrint.v2iXLen.v2f32(<2 x float> %x)
  ret <2 x iXLen> %a
}
declare <2 x iXLen> @llvm.lrint.v2iXLen.v2f32(<2 x float>)

define <3 x iXLen> @lrint_v3f32(<3 x float> %x) {
; RV32-LABEL: lrint_v3f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_v3f32:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v8
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_v3f32:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV64-i64-NEXT:    vmv1r.v v10, v8
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v10
; RV64-i64-NEXT:    ret
  %a = call <3 x iXLen> @llvm.lrint.v3iXLen.v3f32(<3 x float> %x)
  ret <3 x iXLen> %a
}
declare <3 x iXLen> @llvm.lrint.v3iXLen.v3f32(<3 x float>)

define <4 x iXLen> @lrint_v4f32(<4 x float> %x) {
; RV32-LABEL: lrint_v4f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_v4f32:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v8
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_v4f32:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV64-i64-NEXT:    vmv1r.v v10, v8
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v10
; RV64-i64-NEXT:    ret
  %a = call <4 x iXLen> @llvm.lrint.v4iXLen.v4f32(<4 x float> %x)
  ret <4 x iXLen> %a
}
declare <4 x iXLen> @llvm.lrint.v4iXLen.v4f32(<4 x float>)

define <8 x iXLen> @lrint_v8f32(<8 x float> %x) {
; RV32-LABEL: lrint_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_v8f32:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v8
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_v8f32:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV64-i64-NEXT:    vmv2r.v v12, v8
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v12
; RV64-i64-NEXT:    ret
  %a = call <8 x iXLen> @llvm.lrint.v8iXLen.v8f32(<8 x float> %x)
  ret <8 x iXLen> %a
}
declare <8 x iXLen> @llvm.lrint.v8iXLen.v8f32(<8 x float>)

define <16 x iXLen> @lrint_v16f32(<16 x float> %x) {
; RV32-LABEL: lrint_v16f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_v16f32:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v8
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_v16f32:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; RV64-i64-NEXT:    vmv4r.v v16, v8
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v16
; RV64-i64-NEXT:    ret
  %a = call <16 x iXLen> @llvm.lrint.v16iXLen.v16f32(<16 x float> %x)
  ret <16 x iXLen> %a
}
declare <16 x iXLen> @llvm.lrint.v16iXLen.v16f32(<16 x float>)

define <1 x iXLen> @lrint_v1f64(<1 x double> %x) {
; RV32-LABEL: lrint_v1f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; RV32-NEXT:    vfncvt.x.f.w v9, v8
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_v1f64:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; RV64-i32-NEXT:    vfncvt.x.f.w v9, v8
; RV64-i32-NEXT:    vmv1r.v v8, v9
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_v1f64:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV64-i64-NEXT:    vfcvt.x.f.v v8, v8
; RV64-i64-NEXT:    ret
  %a = call <1 x iXLen> @llvm.lrint.v1iXLen.v1f64(<1 x double> %x)
  ret <1 x iXLen> %a
}
declare <1 x iXLen> @llvm.lrint.v1iXLen.v1f64(<1 x double>)

define <2 x iXLen> @lrint_v2f64(<2 x double> %x) {
; RV32-LABEL: lrint_v2f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; RV32-NEXT:    vfncvt.x.f.w v9, v8
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_v2f64:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; RV64-i32-NEXT:    vfncvt.x.f.w v9, v8
; RV64-i32-NEXT:    vmv1r.v v8, v9
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_v2f64:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV64-i64-NEXT:    vfcvt.x.f.v v8, v8
; RV64-i64-NEXT:    ret
  %a = call <2 x iXLen> @llvm.lrint.v2iXLen.v2f64(<2 x double> %x)
  ret <2 x iXLen> %a
}
declare <2 x iXLen> @llvm.lrint.v2iXLen.v2f64(<2 x double>)

define <4 x iXLen> @lrint_v4f64(<4 x double> %x) {
; RV32-LABEL: lrint_v4f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV32-NEXT:    vfncvt.x.f.w v10, v8
; RV32-NEXT:    vmv.v.v v8, v10
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_v4f64:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV64-i32-NEXT:    vfncvt.x.f.w v10, v8
; RV64-i32-NEXT:    vmv.v.v v8, v10
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_v4f64:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; RV64-i64-NEXT:    vfcvt.x.f.v v8, v8
; RV64-i64-NEXT:    ret
  %a = call <4 x iXLen> @llvm.lrint.v4iXLen.v4f64(<4 x double> %x)
  ret <4 x iXLen> %a
}
declare <4 x iXLen> @llvm.lrint.v4iXLen.v4f64(<4 x double>)

define <8 x iXLen> @lrint_v8f64(<8 x double> %x) {
; RV32-LABEL: lrint_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vfncvt.x.f.w v12, v8
; RV32-NEXT:    vmv.v.v v8, v12
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_v8f64:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV64-i32-NEXT:    vfncvt.x.f.w v12, v8
; RV64-i32-NEXT:    vmv.v.v v8, v12
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_v8f64:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-i64-NEXT:    vfcvt.x.f.v v8, v8
; RV64-i64-NEXT:    ret
  %a = call <8 x iXLen> @llvm.lrint.v8iXLen.v8f64(<8 x double> %x)
  ret <8 x iXLen> %a
}
declare <8 x iXLen> @llvm.lrint.v8iXLen.v8f64(<8 x double>)

define <1 x iXLen> @lrint_v1f16(<1 x half> %x) {
; RV32-LABEL: lrint_v1f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; RV32-NEXT:    vfwcvt.f.f.v v9, v8
; RV32-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v9
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_v1f16:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; RV64-i32-NEXT:    vfwcvt.f.f.v v9, v8
; RV64-i32-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v9
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_v1f16:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; RV64-i64-NEXT:    vfwcvt.f.f.v v9, v8
; RV64-i64-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v9
; RV64-i64-NEXT:    ret
  %a = call <1 x iXLen> @llvm.lrint.v1iXLen.v1f16(<1 x half> %x)
  ret <1 x iXLen> %a
}
declare <1 x iXLen> @llvm.lrint.v1iXLen.v1f16(<1 x half>)

define <2 x iXLen> @lrint_v2f16(<2 x half> %x) {
; RV32-LABEL: lrint_v2f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; RV32-NEXT:    vfwcvt.f.f.v v9, v8
; RV32-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v9
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_v2f16:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; RV64-i32-NEXT:    vfwcvt.f.f.v v9, v8
; RV64-i32-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v9
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_v2f16:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; RV64-i64-NEXT:    vfwcvt.f.f.v v9, v8
; RV64-i64-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v9
; RV64-i64-NEXT:    ret
  %a = call <2 x iXLen> @llvm.lrint.v2iXLen.v2f16(<2 x half> %x)
  ret <2 x iXLen> %a
}
declare <2 x iXLen> @llvm.lrint.v2iXLen.v2f16(<2 x half>)

define <3 x iXLen> @lrint_v3f16(<3 x half> %x) {
; RV32-LABEL: lrint_v3f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; RV32-NEXT:    vfwcvt.f.f.v v9, v8
; RV32-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v9
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_v3f16:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; RV64-i32-NEXT:    vfwcvt.f.f.v v9, v8
; RV64-i32-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v9
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_v3f16:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; RV64-i64-NEXT:    vfwcvt.f.f.v v10, v8
; RV64-i64-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v10
; RV64-i64-NEXT:    ret
  %a = call <3 x iXLen> @llvm.lrint.v3iXLen.v3f16(<3 x half> %x)
  ret <3 x iXLen> %a
}
declare <3 x iXLen> @llvm.lrint.v3iXLen.v3f16(<3 x half>)

define <4 x iXLen> @lrint_v4f16(<4 x half> %x) {
; RV32-LABEL: lrint_v4f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; RV32-NEXT:    vfwcvt.f.f.v v9, v8
; RV32-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v9
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_v4f16:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; RV64-i32-NEXT:    vfwcvt.f.f.v v9, v8
; RV64-i32-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v9
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_v4f16:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; RV64-i64-NEXT:    vfwcvt.f.f.v v10, v8
; RV64-i64-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v10
; RV64-i64-NEXT:    ret
  %a = call <4 x iXLen> @llvm.lrint.v4iXLen.v4f16(<4 x half> %x)
  ret <4 x iXLen> %a
}
declare <4 x iXLen> @llvm.lrint.v4iXLen.v4f16(<4 x half>)

define <8 x iXLen> @lrint_v8f16(<8 x half> %x) {
; RV32-LABEL: lrint_v8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV32-NEXT:    vfwcvt.f.f.v v10, v8
; RV32-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v10
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_v8f16:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV64-i32-NEXT:    vfwcvt.f.f.v v10, v8
; RV64-i32-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v10
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_v8f16:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV64-i64-NEXT:    vfwcvt.f.f.v v12, v8
; RV64-i64-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v12
; RV64-i64-NEXT:    ret
  %a = call <8 x iXLen> @llvm.lrint.v8iXLen.v8f16(<8 x half> %x)
  ret <8 x iXLen> %a
}
declare <8 x iXLen> @llvm.lrint.v8iXLen.v8f16(<8 x half>)

define <16 x iXLen> @lrint_v16f16(<16 x half> %x) {
; RV32-LABEL: lrint_v16f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; RV32-NEXT:    vfwcvt.f.f.v v12, v8
; RV32-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v12
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_v16f16:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; RV64-i32-NEXT:    vfwcvt.f.f.v v12, v8
; RV64-i32-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v12
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_v16f16:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; RV64-i64-NEXT:    vfwcvt.f.f.v v16, v8
; RV64-i64-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v16
; RV64-i64-NEXT:    ret
  %a = call <16 x iXLen> @llvm.lrint.v16iXLen.v16f16(<16 x half> %x)
  ret <16 x iXLen> %a
}
declare <16 x iXLen> @llvm.lrint.v16iXLen.v16f16(<16 x half>)

define <1 x iXLen> @lrint_v1bf16(<1 x bfloat> %x) {
; RV32-LABEL: lrint_v1bf16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; RV32-NEXT:    vfwcvtbf16.f.f.v v9, v8
; RV32-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v9
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_v1bf16:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; RV64-i32-NEXT:    vfwcvtbf16.f.f.v v9, v8
; RV64-i32-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v9
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_v1bf16:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; RV64-i64-NEXT:    vfwcvtbf16.f.f.v v9, v8
; RV64-i64-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v9
; RV64-i64-NEXT:    ret
  %a = call <1 x iXLen> @llvm.lrint.v1iXLen.v1bf16(<1 x bfloat> %x)
  ret <1 x iXLen> %a
}
declare <1 x iXLen> @llvm.lrint.v1iXLen.v1bf16(<1 x bfloat>)

define <2 x iXLen> @lrint_v2bf16(<2 x bfloat> %x) {
; RV32-LABEL: lrint_v2bf16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; RV32-NEXT:    vfwcvtbf16.f.f.v v9, v8
; RV32-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v9
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_v2bf16:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; RV64-i32-NEXT:    vfwcvtbf16.f.f.v v9, v8
; RV64-i32-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v9
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_v2bf16:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; RV64-i64-NEXT:    vfwcvtbf16.f.f.v v9, v8
; RV64-i64-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v9
; RV64-i64-NEXT:    ret
  %a = call <2 x iXLen> @llvm.lrint.v2iXLen.v2bf16(<2 x bfloat> %x)
  ret <2 x iXLen> %a
}
declare <2 x iXLen> @llvm.lrint.v2iXLen.v2bf16(<2 x bfloat>)

define <3 x iXLen> @lrint_v3bf16(<3 x bfloat> %x) {
; RV32-LABEL: lrint_v3bf16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; RV32-NEXT:    vfwcvtbf16.f.f.v v9, v8
; RV32-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v9
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_v3bf16:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; RV64-i32-NEXT:    vfwcvtbf16.f.f.v v9, v8
; RV64-i32-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v9
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_v3bf16:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; RV64-i64-NEXT:    vfwcvtbf16.f.f.v v10, v8
; RV64-i64-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v10
; RV64-i64-NEXT:    ret
  %a = call <3 x iXLen> @llvm.lrint.v3iXLen.v3bf16(<3 x bfloat> %x)
  ret <3 x iXLen> %a
}
declare <3 x iXLen> @llvm.lrint.v3iXLen.v3bf16(<3 x bfloat>)

define <4 x iXLen> @lrint_v4bf16(<4 x bfloat> %x) {
; RV32-LABEL: lrint_v4bf16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; RV32-NEXT:    vfwcvtbf16.f.f.v v9, v8
; RV32-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v9
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_v4bf16:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; RV64-i32-NEXT:    vfwcvtbf16.f.f.v v9, v8
; RV64-i32-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v9
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_v4bf16:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; RV64-i64-NEXT:    vfwcvtbf16.f.f.v v10, v8
; RV64-i64-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v10
; RV64-i64-NEXT:    ret
  %a = call <4 x iXLen> @llvm.lrint.v4iXLen.v4bf16(<4 x bfloat> %x)
  ret <4 x iXLen> %a
}
declare <4 x iXLen> @llvm.lrint.v4iXLen.v4bf16(<4 x bfloat>)

define <8 x iXLen> @lrint_v8bf16(<8 x bfloat> %x) {
; RV32-LABEL: lrint_v8bf16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV32-NEXT:    vfwcvtbf16.f.f.v v10, v8
; RV32-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v10
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_v8bf16:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV64-i32-NEXT:    vfwcvtbf16.f.f.v v10, v8
; RV64-i32-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v10
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_v8bf16:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV64-i64-NEXT:    vfwcvtbf16.f.f.v v12, v8
; RV64-i64-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v12
; RV64-i64-NEXT:    ret
  %a = call <8 x iXLen> @llvm.lrint.v8iXLen.v8bf16(<8 x bfloat> %x)
  ret <8 x iXLen> %a
}
declare <8 x iXLen> @llvm.lrint.v8iXLen.v8bf16(<8 x bfloat>)

define <16 x iXLen> @lrint_v16bf16(<16 x bfloat> %x) {
; RV32-LABEL: lrint_v16bf16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; RV32-NEXT:    vfwcvtbf16.f.f.v v12, v8
; RV32-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v12
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_v16bf16:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; RV64-i32-NEXT:    vfwcvtbf16.f.f.v v12, v8
; RV64-i32-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v12
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_v16bf16:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; RV64-i64-NEXT:    vfwcvtbf16.f.f.v v16, v8
; RV64-i64-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v16
; RV64-i64-NEXT:    ret
  %a = call <16 x iXLen> @llvm.lrint.v16iXLen.v16bf16(<16 x bfloat> %x)
  ret <16 x iXLen> %a
}
declare <16 x iXLen> @llvm.lrint.v16iXLen.v16bf16(<16 x bfloat>)

define <32 x iXLen> @lrint_v32bf16(<32 x bfloat> %x) {
; RV32-LABEL: lrint_v32bf16:
; RV32:       # %bb.0:
; RV32-NEXT:    li a0, 32
; RV32-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; RV32-NEXT:    vfwcvtbf16.f.f.v v16, v8
; RV32-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v16
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_v32bf16:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    li a0, 32
; RV64-i32-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; RV64-i32-NEXT:    vfwcvtbf16.f.f.v v16, v8
; RV64-i32-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v16
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_v32bf16:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; RV64-i64-NEXT:    vfwcvtbf16.f.f.v v16, v8
; RV64-i64-NEXT:    vsetivli zero, 16, e16, m4, ta, ma
; RV64-i64-NEXT:    vslidedown.vi v20, v8, 16
; RV64-i64-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v16
; RV64-i64-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; RV64-i64-NEXT:    vfwcvtbf16.f.f.v v24, v20
; RV64-i64-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v16, v24
; RV64-i64-NEXT:    ret
  %a = call <32 x iXLen> @llvm.lrint.v32iXLen.v32bf16(<32 x bfloat> %x)
  ret <32 x iXLen> %a
}
declare <32 x iXLen> @llvm.lrint.v32iXLen.v32bf16(<32 x bfloat>)
