# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=bdver2 -iterations=300 -timeline -timeline-max-iterations=3 < %s | FileCheck %s

vmulps   %xmm0, %xmm1, %xmm2
vhaddps  %xmm2, %xmm2, %xmm3
vhaddps  %xmm3, %xmm3, %xmm4

# CHECK:      Iterations:        300
# CHECK-NEXT: Instructions:      900
# CHECK-NEXT: Total Cycles:      1709
# CHECK-NEXT: Total uOps:        2100

# CHECK:      Dispatch Width:    4
# CHECK-NEXT: uOps Per Cycle:    1.23
# CHECK-NEXT: IPC:               0.53
# CHECK-NEXT: Block RThroughput: 5.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      5     1.00                        vmulps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  3      11    2.50                        vhaddps	%xmm2, %xmm2, %xmm3
# CHECK-NEXT:  3      11    2.50                        vhaddps	%xmm3, %xmm3, %xmm4

# CHECK:      Resources:
# CHECK-NEXT: [0.0] - PdAGLU01
# CHECK-NEXT: [0.1] - PdAGLU01
# CHECK-NEXT: [1]   - PdBranch
# CHECK-NEXT: [2]   - PdCount
# CHECK-NEXT: [3]   - PdDiv
# CHECK-NEXT: [4]   - PdEX0
# CHECK-NEXT: [5]   - PdEX1
# CHECK-NEXT: [6]   - PdFPCVT
# CHECK-NEXT: [7.0] - PdFPFMA
# CHECK-NEXT: [7.1] - PdFPFMA
# CHECK-NEXT: [8.0] - PdFPMAL
# CHECK-NEXT: [8.1] - PdFPMAL
# CHECK-NEXT: [9]   - PdFPMMA
# CHECK-NEXT: [10]  - PdFPSTO
# CHECK-NEXT: [11]  - PdFPU0
# CHECK-NEXT: [12]  - PdFPU1
# CHECK-NEXT: [13]  - PdFPU2
# CHECK-NEXT: [14]  - PdFPU3
# CHECK-NEXT: [15]  - PdFPXBR
# CHECK-NEXT: [16.0] - PdLoad
# CHECK-NEXT: [16.1] - PdLoad
# CHECK-NEXT: [17]  - PdMul
# CHECK-NEXT: [18]  - PdStore

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0.0]  [0.1]  [1]    [2]    [3]    [4]    [5]    [6]    [7.0]  [7.1]  [8.0]  [8.1]  [9]    [10]   [11]   [12]   [13]   [14]   [15]   [16.0] [16.1] [17]   [18]
# CHECK-NEXT:  -      -      -      -      -      -      -      -     5.50   5.50    -      -      -      -     2.00   1.00    -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0.0]  [0.1]  [1]    [2]    [3]    [4]    [5]    [6]    [7.0]  [7.1]  [8.0]  [8.1]  [9]    [10]   [11]   [12]   [13]   [14]   [15]   [16.0] [16.1] [17]   [18]   Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.49   0.51    -      -      -      -      -     1.00    -      -      -      -      -      -      -     vmulps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.53   2.47    -      -      -      -     1.00    -      -      -      -      -      -      -      -     vhaddps	%xmm2, %xmm2, %xmm3
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.48   2.52    -      -      -      -     1.00    -      -      -      -      -      -      -      -     vhaddps	%xmm3, %xmm3, %xmm4

# CHECK:      Timeline view:
# CHECK-NEXT:                     0123456789          01234
# CHECK-NEXT: Index     0123456789          0123456789

# CHECK:      [0,0]     DeeeeeER  .    .    .    .    .   .   vmulps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: [0,1]     D=====eeeeeeeeeeeER .    .    .   .   vhaddps	%xmm2, %xmm2, %xmm3
# CHECK-NEXT: [0,2]     .D===============eeeeeeeeeeeER.   .   vhaddps	%xmm3, %xmm3, %xmm4
# CHECK-NEXT: [1,0]     .DeeeeeE---------------------R.   .   vmulps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: [1,1]     . D====eeeeeeeeeeeE----------R.   .   vhaddps	%xmm2, %xmm2, %xmm3
# CHECK-NEXT: [1,2]     .  D==============eeeeeeeeeeeER   .   vhaddps	%xmm3, %xmm3, %xmm4
# CHECK-NEXT: [2,0]     .  DeeeeeE--------------------R   .   vmulps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: [2,1]     .   D======eeeeeeeeeeeE-------R   .   vhaddps	%xmm2, %xmm2, %xmm3
# CHECK-NEXT: [2,2]     .    D================eeeeeeeeeeeER   vhaddps	%xmm3, %xmm3, %xmm4

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     3     1.0    1.0    13.7      vmulps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 1.     3     6.0    0.7    5.7       vhaddps	%xmm2, %xmm2, %xmm3
# CHECK-NEXT: 2.     3     16.0   0.0    0.0       vhaddps	%xmm3, %xmm3, %xmm4
# CHECK-NEXT:        3     7.7    0.6    6.4       <total>
