; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S < %s -passes=slp-vectorizer -slp-max-reg-size=128 -slp-min-reg-size=128 | FileCheck %s

declare void @llvm.sideeffect()

; SLP vectorization across a @llvm.sideeffect.

define void @test_sideeffect(ptr %p) {
; CHECK-LABEL: @test_sideeffect(
; CHECK-NEXT:    call void @llvm.sideeffect()
; CHECK-NEXT:    call void @llvm.sideeffect()
; CHECK-NEXT:    [[TMP2:%.*]] = load <4 x float>, ptr [[P:%.*]], align 4
; CHECK-NEXT:    store <4 x float> [[TMP2]], ptr [[P]], align 4
; CHECK-NEXT:    ret void
;
  %p1 = getelementptr float, ptr %p, i64 1
  %p2 = getelementptr float, ptr %p, i64 2
  %p3 = getelementptr float, ptr %p, i64 3
  %l0 = load float, ptr %p
  %l1 = load float, ptr %p1
  %l2 = load float, ptr %p2
  call void @llvm.sideeffect()
  %l3 = load float, ptr %p3
  store float %l0, ptr %p
  call void @llvm.sideeffect()
  store float %l1, ptr %p1
  store float %l2, ptr %p2
  store float %l3, ptr %p3
  ret void
}

declare void @foo()

define void @test_inaccessiblememonly(ptr %p) {
; CHECK-LABEL: @test_inaccessiblememonly(
; CHECK-NEXT:    call void @foo() #[[ATTR1:[0-9]+]]
; CHECK-NEXT:    call void @foo() #[[ATTR1]]
; CHECK-NEXT:    [[TMP2:%.*]] = load <4 x float>, ptr [[P:%.*]], align 4
; CHECK-NEXT:    store <4 x float> [[TMP2]], ptr [[P]], align 4
; CHECK-NEXT:    ret void
;
  %p1 = getelementptr float, ptr %p, i64 1
  %p2 = getelementptr float, ptr %p, i64 2
  %p3 = getelementptr float, ptr %p, i64 3
  %l0 = load float, ptr %p
  %l1 = load float, ptr %p1
  %l2 = load float, ptr %p2
  call void @foo() inaccessiblememonly
  %l3 = load float, ptr %p3
  store float %l0, ptr %p
  call void @foo() inaccessiblememonly
  store float %l1, ptr %p1
  store float %l2, ptr %p2
  store float %l3, ptr %p3
  ret void
}
