; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=correlated-propagation -S | FileCheck %s

define void @test1(ptr %ptr) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    [[A:%.*]] = load i8, ptr [[PTR:%.*]], align 1
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    ret void
;
  %A = load i8, ptr %ptr
  br label %bb
bb:
  icmp ne ptr %ptr, null
  ret void
}

define void @test1_no_null_opt(ptr %ptr) #0 {
; CHECK-LABEL: @test1_no_null_opt(
; CHECK-NEXT:    [[A:%.*]] = load i8, ptr [[PTR:%.*]], align 1
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ne ptr [[PTR]], null
; CHECK-NEXT:    ret void
;
  %A = load i8, ptr %ptr
  br label %bb
bb:
  icmp ne ptr %ptr, null
  ret void
}

define void @test2(ptr %ptr) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    store i8 0, ptr [[PTR:%.*]], align 1
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    ret void
;
  store i8 0, ptr %ptr
  br label %bb
bb:
  icmp ne ptr %ptr, null
  ret void
}

define void @test2_no_null_opt(ptr %ptr) #0 {
; CHECK-LABEL: @test2_no_null_opt(
; CHECK-NEXT:    store i8 0, ptr [[PTR:%.*]], align 1
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ne ptr [[PTR]], null
; CHECK-NEXT:    ret void
;
  store i8 0, ptr %ptr
  br label %bb
bb:
  icmp ne ptr %ptr, null
  ret void
}

define void @test3() {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    [[PTR:%.*]] = alloca i8, align 1
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    ret void
;
  %ptr = alloca i8
  br label %bb
bb:
  icmp ne ptr %ptr, null
  ret void
}

;; OK to remove icmp here since ptr is coming from alloca.

define void @test3_no_null_opt() #0 {
; CHECK-LABEL: @test3_no_null_opt(
; CHECK-NEXT:    [[PTR:%.*]] = alloca i8, align 1
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    ret void
;
  %ptr = alloca i8
  br label %bb
bb:
  icmp ne ptr %ptr, null
  ret void
}

declare void @llvm.memcpy.p0.p0.i32(ptr, ptr, i32, i1)

define void @test4(ptr %dest, ptr %src) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr [[DEST:%.*]], ptr [[SRC:%.*]], i32 1, i1 false)
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    ret void
;
  call void @llvm.memcpy.p0.p0.i32(ptr %dest, ptr %src, i32 1, i1 false)
  br label %bb
bb:
  icmp ne ptr %dest, null
  icmp ne ptr %src, null
  ret void
}

define void @test4_no_null_opt(ptr %dest, ptr %src) #0 {
; CHECK-LABEL: @test4_no_null_opt(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr [[DEST:%.*]], ptr [[SRC:%.*]], i32 1, i1 false)
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ne ptr [[DEST]], null
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne ptr [[SRC]], null
; CHECK-NEXT:    ret void
;
  call void @llvm.memcpy.p0.p0.i32(ptr %dest, ptr %src, i32 1, i1 false)
  br label %bb
bb:
  icmp ne ptr %dest, null
  icmp ne ptr %src, null
  ret void
}

declare void @llvm.memmove.p0.p0.i32(ptr, ptr, i32, i1)
define void @test5(ptr %dest, ptr %src) {
; CHECK-LABEL: @test5(
; CHECK-NEXT:    call void @llvm.memmove.p0.p0.i32(ptr [[DEST:%.*]], ptr [[SRC:%.*]], i32 1, i1 false)
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    ret void
;
  call void @llvm.memmove.p0.p0.i32(ptr %dest, ptr %src, i32 1, i1 false)
  br label %bb
bb:
  icmp ne ptr %dest, null
  icmp ne ptr %src, null
  ret void
}

define void @test5_no_null_opt(ptr %dest, ptr %src) #0 {
; CHECK-LABEL: @test5_no_null_opt(
; CHECK-NEXT:    call void @llvm.memmove.p0.p0.i32(ptr [[DEST:%.*]], ptr [[SRC:%.*]], i32 1, i1 false)
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ne ptr [[DEST]], null
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne ptr [[SRC]], null
; CHECK-NEXT:    ret void
;
  call void @llvm.memmove.p0.p0.i32(ptr %dest, ptr %src, i32 1, i1 false)
  br label %bb
bb:
  icmp ne ptr %dest, null
  icmp ne ptr %src, null
  ret void
}

declare void @llvm.memset.p0.i32(ptr, i8, i32, i1)
define void @test6(ptr %dest) {
; CHECK-LABEL: @test6(
; CHECK-NEXT:    call void @llvm.memset.p0.i32(ptr [[DEST:%.*]], i8 -1, i32 1, i1 false)
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    ret void
;
  call void @llvm.memset.p0.i32(ptr %dest, i8 255, i32 1, i1 false)
  br label %bb
bb:
  icmp ne ptr %dest, null
  ret void
}

define void @test6_no_null_opt(ptr %dest) #0 {
; CHECK-LABEL: @test6_no_null_opt(
; CHECK-NEXT:    call void @llvm.memset.p0.i32(ptr [[DEST:%.*]], i8 -1, i32 1, i1 false)
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ne ptr [[DEST]], null
; CHECK-NEXT:    ret void
;
  call void @llvm.memset.p0.i32(ptr %dest, i8 255, i32 1, i1 false)
  br label %bb
bb:
  icmp ne ptr %dest, null
  ret void
}

define void @test7(ptr %dest, ptr %src, i32 %len) {
; CHECK-LABEL: @test7(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr [[DEST:%.*]], ptr [[SRC:%.*]], i32 [[LEN:%.*]], i1 false)
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    [[KEEP1:%.*]] = icmp ne ptr [[DEST]], null
; CHECK-NEXT:    [[KEEP2:%.*]] = icmp ne ptr [[SRC]], null
; CHECK-NEXT:    ret void
;
  call void @llvm.memcpy.p0.p0.i32(ptr %dest, ptr %src, i32 %len, i1 false)
  br label %bb
bb:
  %KEEP1 = icmp ne ptr %dest, null
  %KEEP2 = icmp ne ptr %src, null
  ret void
}

declare void @llvm.memcpy.p1.p1.i32(ptr addrspace(1), ptr addrspace(1), i32, i1)
define void @test8(ptr addrspace(1) %dest, ptr addrspace(1) %src) {
; CHECK-LABEL: @test8(
; CHECK-NEXT:    call void @llvm.memcpy.p1.p1.i32(ptr addrspace(1) [[DEST:%.*]], ptr addrspace(1) [[SRC:%.*]], i32 1, i1 false)
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    [[KEEP1:%.*]] = icmp ne ptr addrspace(1) [[DEST]], null
; CHECK-NEXT:    [[KEEP2:%.*]] = icmp ne ptr addrspace(1) [[SRC]], null
; CHECK-NEXT:    ret void
;
  call void @llvm.memcpy.p1.p1.i32(ptr addrspace(1) %dest, ptr addrspace(1) %src, i32 1, i1 false)
  br label %bb
bb:
  %KEEP1 = icmp ne ptr addrspace(1) %dest, null
  %KEEP2 = icmp ne ptr addrspace(1) %src, null
  ret void
}

define void @test9(ptr %dest, ptr %src) {
; CHECK-LABEL: @test9(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr [[DEST:%.*]], ptr [[SRC:%.*]], i32 1, i1 true)
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    [[KEEP1:%.*]] = icmp ne ptr [[DEST]], null
; CHECK-NEXT:    [[KEEP2:%.*]] = icmp ne ptr [[SRC]], null
; CHECK-NEXT:    ret void
;
  call void @llvm.memcpy.p0.p0.i32(ptr %dest, ptr %src, i32 1, i1 true)
  br label %bb
bb:
  %KEEP1 = icmp ne ptr %dest, null
  %KEEP2 = icmp ne ptr %src, null
  ret void
}

declare void @test10_helper(ptr %arg1, ptr %arg2, i32 %non-pointer-arg)

define void @test10(ptr %arg1, ptr %arg2, i32 %non-pointer-arg) {
; CHECK-LABEL: @test10(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[IS_NULL:%.*]] = icmp eq ptr [[ARG1:%.*]], null
; CHECK-NEXT:    br i1 [[IS_NULL]], label [[NULL:%.*]], label [[NON_NULL:%.*]]
; CHECK:       non_null:
; CHECK-NEXT:    call void @test10_helper(ptr nonnull [[ARG1]], ptr [[ARG2:%.*]], i32 [[NON_POINTER_ARG:%.*]])
; CHECK-NEXT:    br label [[NULL]]
; CHECK:       null:
; CHECK-NEXT:    call void @test10_helper(ptr [[ARG1]], ptr [[ARG2]], i32 [[NON_POINTER_ARG]])
; CHECK-NEXT:    ret void
;
entry:
  %is_null = icmp eq ptr %arg1, null
  br i1 %is_null, label %null, label %non_null

non_null:
  call void @test10_helper(ptr %arg1, ptr %arg2, i32 %non-pointer-arg)
  br label %null

null:
  call void @test10_helper(ptr %arg1, ptr %arg2, i32 %non-pointer-arg)
  ret void
}

declare void @test11_helper(ptr %arg)

define void @test11(ptr %arg1, ptr %arg2) {
; CHECK-LABEL: @test11(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[IS_NULL:%.*]] = icmp eq ptr [[ARG1:%.*]], null
; CHECK-NEXT:    br i1 [[IS_NULL]], label [[NULL:%.*]], label [[NON_NULL:%.*]]
; CHECK:       non_null:
; CHECK-NEXT:    br label [[MERGE:%.*]]
; CHECK:       null:
; CHECK-NEXT:    [[ANOTHER_ARG:%.*]] = alloca i8, align 1
; CHECK-NEXT:    br label [[MERGE]]
; CHECK:       merge:
; CHECK-NEXT:    [[MERGED_ARG:%.*]] = phi ptr [ [[ANOTHER_ARG]], [[NULL]] ], [ [[ARG1]], [[NON_NULL]] ]
; CHECK-NEXT:    call void @test11_helper(ptr nonnull [[MERGED_ARG]])
; CHECK-NEXT:    ret void
;
entry:
  %is_null = icmp eq ptr %arg1, null
  br i1 %is_null, label %null, label %non_null

non_null:
  br label %merge

null:
  %another_arg = alloca i8
  br label %merge

merge:
  %merged_arg = phi ptr [%another_arg, %null], [%arg1, %non_null]
  call void @test11_helper(ptr %merged_arg)
  ret void
}

declare void @test12_helper(ptr %arg)

define void @test12(ptr %arg1, ptr %arg2) {
; CHECK-LABEL: @test12(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[IS_NULL:%.*]] = icmp eq ptr [[ARG1:%.*]], null
; CHECK-NEXT:    br i1 [[IS_NULL]], label [[NULL:%.*]], label [[NON_NULL:%.*]]
; CHECK:       non_null:
; CHECK-NEXT:    br label [[MERGE:%.*]]
; CHECK:       null:
; CHECK-NEXT:    [[ANOTHER_ARG:%.*]] = load ptr, ptr [[ARG2:%.*]], align 8, !nonnull !0
; CHECK-NEXT:    br label [[MERGE]]
; CHECK:       merge:
; CHECK-NEXT:    [[MERGED_ARG:%.*]] = phi ptr [ [[ANOTHER_ARG]], [[NULL]] ], [ [[ARG1]], [[NON_NULL]] ]
; CHECK-NEXT:    call void @test12_helper(ptr nonnull [[MERGED_ARG]])
; CHECK-NEXT:    ret void
;
entry:
  %is_null = icmp eq ptr %arg1, null
  br i1 %is_null, label %null, label %non_null

non_null:
  br label %merge

null:
  %another_arg = load ptr, ptr %arg2, !nonnull !{}
  br label %merge

merge:
  %merged_arg = phi ptr [%another_arg, %null], [%arg1, %non_null]
  call void @test12_helper(ptr %merged_arg)
  ret void
}

define i1 @test_store_same_block(ptr %arg) {
; CHECK-LABEL: @test_store_same_block(
; CHECK-NEXT:    store i8 0, ptr [[ARG:%.*]], align 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne ptr [[ARG]], null
; CHECK-NEXT:    ret i1 true
;
  store i8 0, ptr %arg
  %cmp = icmp ne ptr %arg, null
  ret i1 %cmp
}


define i1 @test_known_nonnull_at_callsite(ptr %src) {
; CHECK-LABEL: @test_known_nonnull_at_callsite(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    call void @callee(ptr noundef nonnull [[SRC:%.*]])
; CHECK-NEXT:    [[NONNULL:%.*]] = icmp eq ptr [[SRC]], null
; CHECK-NEXT:    ret i1 false
;
entry:
  call void @callee(ptr noundef nonnull %src)
  %nonnull = icmp eq ptr %src, null
  ret i1 %nonnull
}

define i1 @test_known_nonnull_mixed(ptr %src) {
; CHECK-LABEL: @test_known_nonnull_mixed(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    call void @callee2(ptr nonnull [[SRC:%.*]])
; CHECK-NEXT:    [[NONNULL:%.*]] = icmp eq ptr [[SRC]], null
; CHECK-NEXT:    ret i1 false
;
entry:
  call void @callee2(ptr nonnull %src)
  %nonnull = icmp eq ptr %src, null
  ret i1 %nonnull
}

define i1 @test_known_nonnull_at_callsite_dereferenceable(ptr %src) {
; CHECK-LABEL: @test_known_nonnull_at_callsite_dereferenceable(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    call void @callee(ptr dereferenceable(1) [[SRC:%.*]])
; CHECK-NEXT:    [[NONNULL:%.*]] = icmp eq ptr [[SRC]], null
; CHECK-NEXT:    ret i1 false
;
entry:
  call void @callee(ptr dereferenceable(1) %src)
  %nonnull = icmp eq ptr %src, null
  ret i1 %nonnull
}

define i1 @test_known_nonnull_at_callsite_gep_inbounds(ptr %src, i64 %x) {
; CHECK-LABEL: @test_known_nonnull_at_callsite_gep_inbounds(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds i8, ptr [[SRC:%.*]], i64 [[X:%.*]]
; CHECK-NEXT:    call void @callee(ptr noundef nonnull [[GEP]])
; CHECK-NEXT:    [[NONNULL:%.*]] = icmp eq ptr [[SRC]], null
; CHECK-NEXT:    ret i1 false
;
entry:
  %gep = getelementptr inbounds i8, ptr %src, i64 %x
  call void @callee(ptr noundef nonnull %gep)
  %nonnull = icmp eq ptr %src, null
  ret i1 %nonnull
}

; Negative tests

define i1 @test_known_nonnull_at_callsite_without_noundef(ptr %src) {
; CHECK-LABEL: @test_known_nonnull_at_callsite_without_noundef(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    call void @callee(ptr nonnull [[SRC:%.*]])
; CHECK-NEXT:    [[NONNULL:%.*]] = icmp eq ptr [[SRC]], null
; CHECK-NEXT:    ret i1 [[NONNULL]]
;
entry:
  call void @callee(ptr nonnull %src)
  %nonnull = icmp eq ptr %src, null
  ret i1 %nonnull
}

define i1 @test_known_nonnull_at_callsite_dereferenceable_null_is_defined(ptr %src) #0 {
; CHECK-LABEL: @test_known_nonnull_at_callsite_dereferenceable_null_is_defined(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    call void @callee(ptr dereferenceable(1) [[SRC:%.*]])
; CHECK-NEXT:    [[NONNULL:%.*]] = icmp eq ptr [[SRC]], null
; CHECK-NEXT:    ret i1 [[NONNULL]]
;
entry:
  call void @callee(ptr dereferenceable(1) %src)
  %nonnull = icmp eq ptr %src, null
  ret i1 %nonnull
}

define i1 @test_known_nonnull_at_callsite_gep_without_inbounds(ptr %src, i64 %x) {
; CHECK-LABEL: @test_known_nonnull_at_callsite_gep_without_inbounds(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr i8, ptr [[SRC:%.*]], i64 [[X:%.*]]
; CHECK-NEXT:    call void @callee(ptr noundef nonnull [[GEP]])
; CHECK-NEXT:    [[NONNULL:%.*]] = icmp eq ptr [[SRC]], null
; CHECK-NEXT:    ret i1 [[NONNULL]]
;
entry:
  %gep = getelementptr i8, ptr %src, i64 %x
  call void @callee(ptr noundef nonnull %gep)
  %nonnull = icmp eq ptr %src, null
  ret i1 %nonnull
}

declare void @callee(ptr)
declare void @callee2(ptr noundef)

attributes #0 = { null_pointer_is_valid }
