; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i386-unknown-unknown -mattr=+movdiri -mattr=+movdir64b | FileCheck %s --check-prefix=X32
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+movdiri -mattr=+movdir64b --show-mc-encoding | FileCheck %s --check-prefix=X64
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+movdiri -mattr=+movdir64b,+egpr --show-mc-encoding | FileCheck %s --check-prefix=EGPR

define void @test_movdiri(ptr %p, i32 %v) {
; X32-LABEL: test_movdiri:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movdiri %eax, (%ecx)
; X32-NEXT:    retl
;
; X64-LABEL: test_movdiri:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movdiri %esi, (%rdi) # encoding: [0x0f,0x38,0xf9,0x37]
; X64-NEXT:    retq # encoding: [0xc3]
;
; EGPR-LABEL: test_movdiri:
; EGPR:       # %bb.0: # %entry
; EGPR-NEXT:    movdiri %esi, (%rdi) # EVEX TO LEGACY Compression encoding: [0x0f,0x38,0xf9,0x37]
; EGPR-NEXT:    retq # encoding: [0xc3]
entry:
  call void @llvm.x86.directstore32(ptr %p, i32 %v)
  ret void
}

declare void @llvm.x86.directstore32(ptr, i32)

define void @test_movdir64b(ptr %dst, ptr %src) {
; X32-LABEL: test_movdir64b:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movdir64b (%eax), %ecx
; X32-NEXT:    retl
;
; X64-LABEL: test_movdir64b:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movdir64b (%rsi), %rdi # encoding: [0x66,0x0f,0x38,0xf8,0x3e]
; X64-NEXT:    retq # encoding: [0xc3]
;
; EGPR-LABEL: test_movdir64b:
; EGPR:       # %bb.0: # %entry
; EGPR-NEXT:    movdir64b (%rsi), %rdi # EVEX TO LEGACY Compression encoding: [0x66,0x0f,0x38,0xf8,0x3e]
; EGPR-NEXT:    retq # encoding: [0xc3]
entry:
  call void @llvm.x86.movdir64b(ptr %dst, ptr %src)
  ret void
}

declare void @llvm.x86.movdir64b(ptr, ptr)
