; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+ndd -verify-machineinstrs --show-mc-encoding | FileCheck %s

define i8 @sar8m1(ptr %ptr) {
; CHECK-LABEL: sar8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sarb (%rdi), %al # encoding: [0x62,0xf4,0x7c,0x18,0xd0,0x3f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %sar = ashr i8 %a, 1
  ret i8 %sar
}

define i16 @sar16m1(ptr %ptr) {
; CHECK-LABEL: sar16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sarw (%rdi), %ax # encoding: [0x62,0xf4,0x7d,0x18,0xd1,0x3f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %sar = ashr i16 %a, 1
  ret i16 %sar
}

define i32 @sar32m1(ptr %ptr) {
; CHECK-LABEL: sar32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sarl (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0xd1,0x3f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %sar = ashr i32 %a, 1
  ret i32 %sar
}

define i64 @sar64m1(ptr %ptr) {
; CHECK-LABEL: sar64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sarq (%rdi), %rax # encoding: [0x62,0xf4,0xfc,0x18,0xd1,0x3f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %sar = ashr i64 %a, 1
  ret i64 %sar
}

define i8 @sar8mcl(ptr %ptr, i8 %cl) {
; CHECK-LABEL: sar8mcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    sarb %cl, (%rdi), %al # encoding: [0x62,0xf4,0x7c,0x18,0xd2,0x3f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %sar = ashr i8 %a, %cl
  ret i8 %sar
}

define i8 @sar8mcl_mask(ptr %ptr, i8 %cl) {
; CHECK-LABEL: sar8mcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    sarb %cl, (%rdi), %al # encoding: [0x62,0xf4,0x7c,0x18,0xd2,0x3f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %shamt = and i8 %cl, 31
  %sar = ashr i8 %a, %shamt
  ret i8 %sar
}

define i16 @sar16mcl(ptr %ptr, i16 %cl) {
; CHECK-LABEL: sar16mcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    sarw %cl, (%rdi), %ax # encoding: [0x62,0xf4,0x7d,0x18,0xd3,0x3f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %sar = ashr i16 %a, %cl
  ret i16 %sar
}

define i16 @sar16mcl_mask(ptr %ptr, i16 %cl) {
; CHECK-LABEL: sar16mcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    sarw %cl, (%rdi), %ax # encoding: [0x62,0xf4,0x7d,0x18,0xd3,0x3f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %shamt = and i16 %cl, 31
  %sar = ashr i16 %a, %shamt
  ret i16 %sar
}

define i32 @sar32mcl(ptr %ptr, i32 %cl) {
; CHECK-LABEL: sar32mcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    sarl %cl, (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0xd3,0x3f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %sar = ashr i32 %a, %cl
  ret i32 %sar
}

define i32 @sar32mcl_mask(ptr %ptr, i32 %cl) {
; CHECK-LABEL: sar32mcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    sarl %cl, (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0xd3,0x3f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %shamt = and i32 %cl, 31
  %sar = ashr i32 %a, %shamt
  ret i32 %sar
}

define i64 @sar64mcl(ptr %ptr, i64 %cl) {
; CHECK-LABEL: sar64mcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $rcx
; CHECK-NEXT:    sarq %cl, (%rdi), %rax # encoding: [0x62,0xf4,0xfc,0x18,0xd3,0x3f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %sar = ashr i64 %a, %cl
  ret i64 %sar
}

define i64 @sar64mcl_mask(ptr %ptr, i64 %cl) {
; CHECK-LABEL: sar64mcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $rcx
; CHECK-NEXT:    sarq %cl, (%rdi), %rax # encoding: [0x62,0xf4,0xfc,0x18,0xd3,0x3f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %shamt = and i64 %cl, 63
  %sar = ashr i64 %a, %shamt
  ret i64 %sar
}

define i8 @sar8mi(ptr %ptr) {
; CHECK-LABEL: sar8mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sarb $4, (%rdi), %al # encoding: [0x62,0xf4,0x7c,0x18,0xc0,0x3f,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %sar = ashr i8 %a, 4
  ret i8 %sar
}

define i16 @sar16mi(ptr %ptr) {
; CHECK-LABEL: sar16mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sarw $4, (%rdi), %ax # encoding: [0x62,0xf4,0x7d,0x18,0xc1,0x3f,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %sar = ashr i16 %a, 4
  ret i16 %sar
}

define i32 @sar32mi(ptr %ptr) {
; CHECK-LABEL: sar32mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sarl $4, (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0xc1,0x3f,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %sar = ashr i32 %a, 4
  ret i32 %sar
}

define i64 @sar64mi(ptr %ptr) {
; CHECK-LABEL: sar64mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sarq $4, (%rdi), %rax # encoding: [0x62,0xf4,0xfc,0x18,0xc1,0x3f,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %sar = ashr i64 %a, 4
  ret i64 %sar
}

define i8 @sar8r1(i8 noundef %a) {
; CHECK-LABEL: sar8r1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sarb %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0xd0,0xff]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %sar = ashr i8 %a, 1
  ret i8 %sar
}

define i16 @sar16r1(i16 noundef %a) {
; CHECK-LABEL: sar16r1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sarw %di, %ax # encoding: [0x62,0xf4,0x7d,0x18,0xd1,0xff]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %sar = ashr i16 %a, 1
  ret i16 %sar
}

define i32 @sar32r1(i32 noundef %a) {
; CHECK-LABEL: sar32r1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sarl %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0xd1,0xff]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %sar = ashr i32 %a, 1
  ret i32 %sar
}

define i64 @sar64r1(i64 noundef %a) {
; CHECK-LABEL: sar64r1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sarq %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0xd1,0xff]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %sar = ashr i64 %a, 1
  ret i64 %sar
}

define i8 @sar8rcl(i8 noundef %a, i8 %cl) {
; CHECK-LABEL: sar8rcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    sarb %cl, %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0xd2,0xff]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %sar = ashr i8 %a, %cl
  ret i8 %sar
}

define i8 @sar8rcl_mask(i8 noundef %a, i8 %cl) {
; CHECK-LABEL: sar8rcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    sarb %cl, %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0xd2,0xff]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shamt = and i8 %cl, 31
  %sar = ashr i8 %a, %shamt
  ret i8 %sar
}

define i16 @sar16rcl(i16 noundef %a, i16 %cl) {
; CHECK-LABEL: sar16rcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    sarw %cl, %di, %ax # encoding: [0x62,0xf4,0x7d,0x18,0xd3,0xff]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %sar = ashr i16 %a, %cl
  ret i16 %sar
}

define i16 @sar16rcl_mask(i16 noundef %a, i16 %cl) {
; CHECK-LABEL: sar16rcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    sarw %cl, %di, %ax # encoding: [0x62,0xf4,0x7d,0x18,0xd3,0xff]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shamt = and i16 %cl, 31
  %sar = ashr i16 %a, %shamt
  ret i16 %sar
}

define i32 @sar32rcl(i32 noundef %a, i32 %cl) {
; CHECK-LABEL: sar32rcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    sarl %cl, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0xd3,0xff]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %sar = ashr i32 %a, %cl
  ret i32 %sar
}

define i32 @sar32rcl_mask(i32 noundef %a, i32 %cl) {
; CHECK-LABEL: sar32rcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    sarl %cl, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0xd3,0xff]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shamt = and i32 %cl, 31
  %sar = ashr i32 %a, %shamt
  ret i32 %sar
}

define i64 @sar64rcl(i64 noundef %a, i64 %cl) {
; CHECK-LABEL: sar64rcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $rcx
; CHECK-NEXT:    sarq %cl, %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0xd3,0xff]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %sar = ashr i64 %a, %cl
  ret i64 %sar
}

define i64 @sar64rcl_mask(i64 noundef %a, i64 %cl) {
; CHECK-LABEL: sar64rcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $rcx
; CHECK-NEXT:    sarq %cl, %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0xd3,0xff]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shamt = and i64 %cl, 63
  %sar = ashr i64 %a, %shamt
  ret i64 %sar
}

define i8 @sar8ri(i8 noundef %a) {
; CHECK-LABEL: sar8ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sarb $4, %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0xc0,0xff,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %sar = ashr i8 %a, 4
  ret i8 %sar
}

define i16 @sar16ri(i16 noundef %a) {
; CHECK-LABEL: sar16ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sarw $4, %di, %ax # encoding: [0x62,0xf4,0x7d,0x18,0xc1,0xff,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %sar = ashr i16 %a, 4
  ret i16 %sar
}

define i32 @sar32ri(i32 noundef %a) {
; CHECK-LABEL: sar32ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sarl $4, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0xc1,0xff,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %sar = ashr i32 %a, 4
  ret i32 %sar
}

define i64 @sar64ri(i64 noundef %a) {
; CHECK-LABEL: sar64ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sarq $4, %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0xc1,0xff,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %sar = ashr i64 %a, 4
  ret i64 %sar
}

define void @sar8m1_legacy(ptr %ptr) {
; CHECK-LABEL: sar8m1_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sarb (%rdi) # encoding: [0xd0,0x3f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %sar = ashr i8 %a, 1
  store i8 %sar, ptr %ptr
  ret void
}

define void @sar16m1_legacy(ptr %ptr) {
; CHECK-LABEL: sar16m1_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sarw (%rdi) # encoding: [0x66,0xd1,0x3f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %sar = ashr i16 %a, 1
  store i16 %sar, ptr %ptr
  ret void
}

define void @sar32m1_legacy(ptr %ptr) {
; CHECK-LABEL: sar32m1_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sarl (%rdi) # encoding: [0xd1,0x3f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %sar = ashr i32 %a, 1
  store i32 %sar, ptr %ptr
  ret void
}

define void @sar64m1_legacy(ptr %ptr) {
; CHECK-LABEL: sar64m1_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sarq (%rdi) # encoding: [0x48,0xd1,0x3f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %sar = ashr i64 %a, 1
  store i64 %sar, ptr %ptr
  ret void
}

define void @sar8mcl_legacy(ptr %ptr, i8 %cl) {
; CHECK-LABEL: sar8mcl_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    sarb %cl, (%rdi) # encoding: [0xd2,0x3f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %sar = ashr i8 %a, %cl
  store i8 %sar, ptr %ptr
  ret void
}

define void @sar16mcl_legacy(ptr %ptr, i16 %cl) {
; CHECK-LABEL: sar16mcl_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    sarw %cl, (%rdi) # encoding: [0x66,0xd3,0x3f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %sar = ashr i16 %a, %cl
  store i16 %sar, ptr %ptr
  ret void
}

define void @sar32mcl_legacy(ptr %ptr, i32 %cl) {
; CHECK-LABEL: sar32mcl_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    sarl %cl, (%rdi) # encoding: [0xd3,0x3f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %sar = ashr i32 %a, %cl
  store i32 %sar, ptr %ptr
  ret void
}

define void @sar64mcl_legacy(ptr %ptr, i64 %cl) {
; CHECK-LABEL: sar64mcl_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $rcx
; CHECK-NEXT:    sarq %cl, (%rdi) # encoding: [0x48,0xd3,0x3f]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %sar = ashr i64 %a, %cl
  store i64 %sar, ptr %ptr
  ret void
}

define void @sar8mi_legacy(ptr %ptr) {
; CHECK-LABEL: sar8mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sarb $4, (%rdi) # encoding: [0xc0,0x3f,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %sar = ashr i8 %a, 4
  store i8 %sar, ptr %ptr
  ret void
}

define void @sar16mi_legacy(ptr %ptr) {
; CHECK-LABEL: sar16mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sarw $4, (%rdi) # encoding: [0x66,0xc1,0x3f,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %sar = ashr i16 %a, 4
  store i16 %sar, ptr %ptr
  ret void
}

define void @sar32mi_legacy(ptr %ptr) {
; CHECK-LABEL: sar32mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sarl $4, (%rdi) # encoding: [0xc1,0x3f,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %sar = ashr i32 %a, 4
  store i32 %sar, ptr %ptr
  ret void
}

define void @sar64mi_legacy(ptr %ptr) {
; CHECK-LABEL: sar64mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sarq $4, (%rdi) # encoding: [0x48,0xc1,0x3f,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %sar = ashr i64 %a, 4
  store i64 %sar, ptr %ptr
  ret void
}
