; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc < %s -mtriple=nvptx64 -mcpu=sm_20 -mattr=+ptx70 | FileCheck -check-prefixes CHECK,PTX70 %s
; RUN: %if ptxas %{ llc < %s -mtriple=nvptx64 -mcpu=sm_20 | %ptxas-verify %}
; RUN: %if ptxas-11.0 %{ llc < %s -mtriple=nvptx64 -mcpu=sm_20 -mattr=+ptx70 | %ptxas-verify %}
; RUN: llc < %s -mtriple=nvptx64 -mcpu=sm_20 -mattr=+ptx71 | FileCheck -check-prefixes CHECK,PTX71 %s
; RUN: %if ptxas-11.0 %{ llc < %s -mtriple=nvptx64 -mcpu=sm_20 -mattr=+ptx71 | %ptxas-verify %}

target triple = "nvptx64-nvidia-cuda"

define i16 @bswap16(i16 %a) {
; CHECK-LABEL: bswap16(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b16 %rs1, [bswap16_param_0];
; CHECK-NEXT:    shr.u16 %rs2, %rs1, 8;
; CHECK-NEXT:    shl.b16 %rs3, %rs1, 8;
; CHECK-NEXT:    or.b16 %rs4, %rs3, %rs2;
; CHECK-NEXT:    cvt.u32.u16 %r1, %rs4;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r1;
; CHECK-NEXT:    ret;
  %b = tail call i16 @llvm.bswap.i16(i16 %a)
  ret i16 %b
}


define i32 @bswap32(i32 %a) {
; CHECK-LABEL: bswap32(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [bswap32_param_0];
; CHECK-NEXT:    prmt.b32 %r2, %r1, 0, 0x123U;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r2;
; CHECK-NEXT:    ret;
  %b = tail call i32 @llvm.bswap.i32(i32 %a)
  ret i32 %b
}


define <2 x i16> @bswapv2i16(<2 x i16> %a) #0 {
; CHECK-LABEL: bswapv2i16(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [bswapv2i16_param_0];
; CHECK-NEXT:    prmt.b32 %r2, %r1, 0, 0x2301U;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r2;
; CHECK-NEXT:    ret;
  %b = tail call <2 x i16> @llvm.bswap.v2i16(<2 x i16> %a)
  ret <2 x i16> %b
}

define i64 @bswap64(i64 %a) {
; PTX70-LABEL: bswap64(
; PTX70:       {
; PTX70-NEXT:    .reg .b32 %r<5>;
; PTX70-NEXT:    .reg .b64 %rd<3>;
; PTX70-EMPTY:
; PTX70-NEXT:  // %bb.0:
; PTX70-NEXT:    ld.param.b64 %rd1, [bswap64_param_0];
; PTX70-NEXT:    { .reg .b32 tmp; mov.b64 {%r1, tmp}, %rd1; }
; PTX70-NEXT:    prmt.b32 %r2, %r1, 0, 0x123U;
; PTX70-NEXT:    { .reg .b32 tmp; mov.b64 {tmp, %r3}, %rd1; }
; PTX70-NEXT:    prmt.b32 %r4, %r3, 0, 0x123U;
; PTX70-NEXT:    mov.b64 %rd2, {%r4, %r2};
; PTX70-NEXT:    st.param.b64 [func_retval0], %rd2;
; PTX70-NEXT:    ret;
;
; PTX71-LABEL: bswap64(
; PTX71:       {
; PTX71-NEXT:    .reg .b32 %r<5>;
; PTX71-NEXT:    .reg .b64 %rd<3>;
; PTX71-EMPTY:
; PTX71-NEXT:  // %bb.0:
; PTX71-NEXT:    ld.param.b64 %rd1, [bswap64_param_0];
; PTX71-NEXT:    mov.b64 {%r1, _}, %rd1;
; PTX71-NEXT:    prmt.b32 %r2, %r1, 0, 0x123U;
; PTX71-NEXT:    mov.b64 {_, %r3}, %rd1;
; PTX71-NEXT:    prmt.b32 %r4, %r3, 0, 0x123U;
; PTX71-NEXT:    mov.b64 %rd2, {%r4, %r2};
; PTX71-NEXT:    st.param.b64 [func_retval0], %rd2;
; PTX71-NEXT:    ret;
  %b = tail call i64 @llvm.bswap.i64(i64 %a)
  ret i64 %b
}

declare i16 @llvm.bswap.i16(i16)
declare i32 @llvm.bswap.i32(i32)
declare <2 x i16> @llvm.bswap.v2i16(<2 x i16>)
declare i64 @llvm.bswap.i64(i64)
