; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu -O0 -global-isel -stop-after=irtranslator -o - %s | FileCheck %s

; Tests vectors of i1 types can appropriately extended first before return handles it.
define <4 x i1> @ret_v4i1(ptr %v) {
  ; CHECK-LABEL: name: ret_v4i1
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $x0
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x0
  ; CHECK-NEXT:   [[LOAD:%[0-9]+]]:_(<4 x s1>) = G_LOAD [[COPY]](p0) :: (load (<4 x s1>) from %ir.v)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(<4 x s16>) = G_ANYEXT [[LOAD]](<4 x s1>)
  ; CHECK-NEXT:   $d0 = COPY [[ANYEXT]](<4 x s16>)
  ; CHECK-NEXT:   RET_ReallyLR implicit $d0
  %v2 = load <4 x i1>, ptr %v
  ret <4 x i1> %v2
}

define <1 x i12> @ret_v1i12(i12 %v1, i12 %v2) {
  ; CHECK-LABEL: name: ret_v1i12
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $w0, $w1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s12) = G_TRUNC [[COPY]](s32)
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $w1
  ; CHECK-NEXT:   [[TRUNC1:%[0-9]+]]:_(s12) = G_TRUNC [[COPY1]](s32)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[TRUNC]](s12)
  ; CHECK-NEXT:   $w0 = COPY [[ANYEXT]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0
  %a = insertelement <1 x i12> poison, i12 %v1, i32 0
  ret <1 x i12> %a
}

define <2 x i12> @ret_v2i12(i12 %v1, i12 %v2) {
  ; CHECK-LABEL: name: ret_v2i12
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $w0, $w1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s12) = G_TRUNC [[COPY]](s32)
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $w1
  ; CHECK-NEXT:   [[TRUNC1:%[0-9]+]]:_(s12) = G_TRUNC [[COPY1]](s32)
  ; CHECK-NEXT:   [[DEF:%[0-9]+]]:_(<2 x s12>) = G_IMPLICIT_DEF
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 0
  ; CHECK-NEXT:   [[C1:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[IVEC:%[0-9]+]]:_(<2 x s12>) = G_INSERT_VECTOR_ELT [[DEF]], [[TRUNC]](s12), [[C]](s64)
  ; CHECK-NEXT:   [[IVEC1:%[0-9]+]]:_(<2 x s12>) = G_INSERT_VECTOR_ELT [[IVEC]], [[TRUNC1]](s12), [[C1]](s64)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(<2 x s32>) = G_ANYEXT [[IVEC1]](<2 x s12>)
  ; CHECK-NEXT:   $d0 = COPY [[ANYEXT]](<2 x s32>)
  ; CHECK-NEXT:   RET_ReallyLR implicit $d0
  %a = insertelement <2 x i12> poison, i12 %v1, i32 0
  %b = insertelement <2 x i12> %a, i12 %v2, i32 1
  ret <2 x i12> %b
}

define <3 x i12> @ret_v3i12(i12 %v1, i12 %v2) {
  ; CHECK-LABEL: name: ret_v3i12
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $w0, $w1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s12) = G_TRUNC [[COPY]](s32)
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $w1
  ; CHECK-NEXT:   [[TRUNC1:%[0-9]+]]:_(s12) = G_TRUNC [[COPY1]](s32)
  ; CHECK-NEXT:   [[DEF:%[0-9]+]]:_(<3 x s12>) = G_IMPLICIT_DEF
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 0
  ; CHECK-NEXT:   [[C1:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[C2:%[0-9]+]]:_(s64) = G_CONSTANT i64 2
  ; CHECK-NEXT:   [[IVEC:%[0-9]+]]:_(<3 x s12>) = G_INSERT_VECTOR_ELT [[DEF]], [[TRUNC]](s12), [[C]](s64)
  ; CHECK-NEXT:   [[IVEC1:%[0-9]+]]:_(<3 x s12>) = G_INSERT_VECTOR_ELT [[IVEC]], [[TRUNC1]](s12), [[C1]](s64)
  ; CHECK-NEXT:   [[IVEC2:%[0-9]+]]:_(<3 x s12>) = G_INSERT_VECTOR_ELT [[IVEC1]], [[TRUNC1]](s12), [[C2]](s64)
  ; CHECK-NEXT:   [[UV:%[0-9]+]]:_(s12), [[UV1:%[0-9]+]]:_(s12), [[UV2:%[0-9]+]]:_(s12) = G_UNMERGE_VALUES [[IVEC2]](<3 x s12>)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[UV]](s12)
  ; CHECK-NEXT:   [[ANYEXT1:%[0-9]+]]:_(s32) = G_ANYEXT [[UV1]](s12)
  ; CHECK-NEXT:   [[ANYEXT2:%[0-9]+]]:_(s32) = G_ANYEXT [[UV2]](s12)
  ; CHECK-NEXT:   $w0 = COPY [[ANYEXT]](s32)
  ; CHECK-NEXT:   $w1 = COPY [[ANYEXT1]](s32)
  ; CHECK-NEXT:   $w2 = COPY [[ANYEXT2]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0, implicit $w1, implicit $w2
  %a = insertelement <3 x i12> poison, i12 %v1, i32 0
  %b = insertelement <3 x i12> %a, i12 %v2, i32 1
  %c = insertelement <3 x i12> %b, i12 %v2, i32 2
  ret <3 x i12> %c
}

define <4 x i12> @ret_v4i12(i12 %v1, i12 %v2) {
  ; CHECK-LABEL: name: ret_v4i12
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $w0, $w1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s12) = G_TRUNC [[COPY]](s32)
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $w1
  ; CHECK-NEXT:   [[TRUNC1:%[0-9]+]]:_(s12) = G_TRUNC [[COPY1]](s32)
  ; CHECK-NEXT:   [[DEF:%[0-9]+]]:_(<4 x s12>) = G_IMPLICIT_DEF
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 0
  ; CHECK-NEXT:   [[C1:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[C2:%[0-9]+]]:_(s64) = G_CONSTANT i64 2
  ; CHECK-NEXT:   [[C3:%[0-9]+]]:_(s64) = G_CONSTANT i64 3
  ; CHECK-NEXT:   [[IVEC:%[0-9]+]]:_(<4 x s12>) = G_INSERT_VECTOR_ELT [[DEF]], [[TRUNC]](s12), [[C]](s64)
  ; CHECK-NEXT:   [[IVEC1:%[0-9]+]]:_(<4 x s12>) = G_INSERT_VECTOR_ELT [[IVEC]], [[TRUNC1]](s12), [[C1]](s64)
  ; CHECK-NEXT:   [[IVEC2:%[0-9]+]]:_(<4 x s12>) = G_INSERT_VECTOR_ELT [[IVEC1]], [[TRUNC]](s12), [[C2]](s64)
  ; CHECK-NEXT:   [[IVEC3:%[0-9]+]]:_(<4 x s12>) = G_INSERT_VECTOR_ELT [[IVEC2]], [[TRUNC1]](s12), [[C3]](s64)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(<4 x s16>) = G_ANYEXT [[IVEC3]](<4 x s12>)
  ; CHECK-NEXT:   $d0 = COPY [[ANYEXT]](<4 x s16>)
  ; CHECK-NEXT:   RET_ReallyLR implicit $d0
  %a = insertelement <4 x i12> poison, i12 %v1, i32 0
  %b = insertelement <4 x i12> %a, i12 %v2, i32 1
  %c = insertelement <4 x i12> %b, i12 %v1, i32 2
  %d = insertelement <4 x i12> %c, i12 %v2, i32 3
  ret <4 x i12> %d
}

define <5 x i12> @ret_v5i12(i12 %v1, i12 %v2) {
  ; CHECK-LABEL: name: ret_v5i12
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $w0, $w1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s12) = G_TRUNC [[COPY]](s32)
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $w1
  ; CHECK-NEXT:   [[TRUNC1:%[0-9]+]]:_(s12) = G_TRUNC [[COPY1]](s32)
  ; CHECK-NEXT:   [[DEF:%[0-9]+]]:_(<5 x s12>) = G_IMPLICIT_DEF
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 0
  ; CHECK-NEXT:   [[C1:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[C2:%[0-9]+]]:_(s64) = G_CONSTANT i64 2
  ; CHECK-NEXT:   [[C3:%[0-9]+]]:_(s64) = G_CONSTANT i64 3
  ; CHECK-NEXT:   [[C4:%[0-9]+]]:_(s64) = G_CONSTANT i64 4
  ; CHECK-NEXT:   [[IVEC:%[0-9]+]]:_(<5 x s12>) = G_INSERT_VECTOR_ELT [[DEF]], [[TRUNC1]](s12), [[C]](s64)
  ; CHECK-NEXT:   [[IVEC1:%[0-9]+]]:_(<5 x s12>) = G_INSERT_VECTOR_ELT [[IVEC]], [[TRUNC]](s12), [[C1]](s64)
  ; CHECK-NEXT:   [[IVEC2:%[0-9]+]]:_(<5 x s12>) = G_INSERT_VECTOR_ELT [[IVEC1]], [[TRUNC]](s12), [[C2]](s64)
  ; CHECK-NEXT:   [[IVEC3:%[0-9]+]]:_(<5 x s12>) = G_INSERT_VECTOR_ELT [[IVEC2]], [[TRUNC1]](s12), [[C3]](s64)
  ; CHECK-NEXT:   [[IVEC4:%[0-9]+]]:_(<5 x s12>) = G_INSERT_VECTOR_ELT [[IVEC3]], [[TRUNC1]](s12), [[C4]](s64)
  ; CHECK-NEXT:   [[UV:%[0-9]+]]:_(s12), [[UV1:%[0-9]+]]:_(s12), [[UV2:%[0-9]+]]:_(s12), [[UV3:%[0-9]+]]:_(s12), [[UV4:%[0-9]+]]:_(s12) = G_UNMERGE_VALUES [[IVEC4]](<5 x s12>)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[UV]](s12)
  ; CHECK-NEXT:   [[ANYEXT1:%[0-9]+]]:_(s32) = G_ANYEXT [[UV1]](s12)
  ; CHECK-NEXT:   [[ANYEXT2:%[0-9]+]]:_(s32) = G_ANYEXT [[UV2]](s12)
  ; CHECK-NEXT:   [[ANYEXT3:%[0-9]+]]:_(s32) = G_ANYEXT [[UV3]](s12)
  ; CHECK-NEXT:   [[ANYEXT4:%[0-9]+]]:_(s32) = G_ANYEXT [[UV4]](s12)
  ; CHECK-NEXT:   $w0 = COPY [[ANYEXT]](s32)
  ; CHECK-NEXT:   $w1 = COPY [[ANYEXT1]](s32)
  ; CHECK-NEXT:   $w2 = COPY [[ANYEXT2]](s32)
  ; CHECK-NEXT:   $w3 = COPY [[ANYEXT3]](s32)
  ; CHECK-NEXT:   $w4 = COPY [[ANYEXT4]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0, implicit $w1, implicit $w2, implicit $w3, implicit $w4
  %a = insertelement <5 x i12> poison, i12 %v2, i32 0
  %b = insertelement <5 x i12> %a, i12 %v1, i32 1
  %c = insertelement <5 x i12> %b, i12 %v1, i32 2
  %d = insertelement <5 x i12> %c, i12 %v2, i32 3
  %e = insertelement <5 x i12> %d, i12 %v2, i32 4
  ret <5 x i12> %e
}

define <6 x i12> @ret_v6i12(i12 %v1, i12 %v2) {
  ; CHECK-LABEL: name: ret_v6i12
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $w0, $w1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s12) = G_TRUNC [[COPY]](s32)
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $w1
  ; CHECK-NEXT:   [[TRUNC1:%[0-9]+]]:_(s12) = G_TRUNC [[COPY1]](s32)
  ; CHECK-NEXT:   [[DEF:%[0-9]+]]:_(<6 x s12>) = G_IMPLICIT_DEF
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 0
  ; CHECK-NEXT:   [[C1:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[C2:%[0-9]+]]:_(s64) = G_CONSTANT i64 2
  ; CHECK-NEXT:   [[C3:%[0-9]+]]:_(s64) = G_CONSTANT i64 3
  ; CHECK-NEXT:   [[C4:%[0-9]+]]:_(s64) = G_CONSTANT i64 4
  ; CHECK-NEXT:   [[C5:%[0-9]+]]:_(s64) = G_CONSTANT i64 5
  ; CHECK-NEXT:   [[IVEC:%[0-9]+]]:_(<6 x s12>) = G_INSERT_VECTOR_ELT [[DEF]], [[TRUNC1]](s12), [[C]](s64)
  ; CHECK-NEXT:   [[IVEC1:%[0-9]+]]:_(<6 x s12>) = G_INSERT_VECTOR_ELT [[IVEC]], [[TRUNC]](s12), [[C1]](s64)
  ; CHECK-NEXT:   [[IVEC2:%[0-9]+]]:_(<6 x s12>) = G_INSERT_VECTOR_ELT [[IVEC1]], [[TRUNC]](s12), [[C2]](s64)
  ; CHECK-NEXT:   [[IVEC3:%[0-9]+]]:_(<6 x s12>) = G_INSERT_VECTOR_ELT [[IVEC2]], [[TRUNC1]](s12), [[C3]](s64)
  ; CHECK-NEXT:   [[IVEC4:%[0-9]+]]:_(<6 x s12>) = G_INSERT_VECTOR_ELT [[IVEC3]], [[TRUNC1]](s12), [[C4]](s64)
  ; CHECK-NEXT:   [[IVEC5:%[0-9]+]]:_(<6 x s12>) = G_INSERT_VECTOR_ELT [[IVEC4]], [[TRUNC]](s12), [[C5]](s64)
  ; CHECK-NEXT:   [[UV:%[0-9]+]]:_(s12), [[UV1:%[0-9]+]]:_(s12), [[UV2:%[0-9]+]]:_(s12), [[UV3:%[0-9]+]]:_(s12), [[UV4:%[0-9]+]]:_(s12), [[UV5:%[0-9]+]]:_(s12) = G_UNMERGE_VALUES [[IVEC5]](<6 x s12>)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[UV]](s12)
  ; CHECK-NEXT:   [[ANYEXT1:%[0-9]+]]:_(s32) = G_ANYEXT [[UV1]](s12)
  ; CHECK-NEXT:   [[ANYEXT2:%[0-9]+]]:_(s32) = G_ANYEXT [[UV2]](s12)
  ; CHECK-NEXT:   [[ANYEXT3:%[0-9]+]]:_(s32) = G_ANYEXT [[UV3]](s12)
  ; CHECK-NEXT:   [[ANYEXT4:%[0-9]+]]:_(s32) = G_ANYEXT [[UV4]](s12)
  ; CHECK-NEXT:   [[ANYEXT5:%[0-9]+]]:_(s32) = G_ANYEXT [[UV5]](s12)
  ; CHECK-NEXT:   $w0 = COPY [[ANYEXT]](s32)
  ; CHECK-NEXT:   $w1 = COPY [[ANYEXT1]](s32)
  ; CHECK-NEXT:   $w2 = COPY [[ANYEXT2]](s32)
  ; CHECK-NEXT:   $w3 = COPY [[ANYEXT3]](s32)
  ; CHECK-NEXT:   $w4 = COPY [[ANYEXT4]](s32)
  ; CHECK-NEXT:   $w5 = COPY [[ANYEXT5]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0, implicit $w1, implicit $w2, implicit $w3, implicit $w4, implicit $w5
  %a = insertelement <6 x i12> poison, i12 %v2, i32 0
  %b = insertelement <6 x i12> %a, i12 %v1, i32 1
  %c = insertelement <6 x i12> %b, i12 %v1, i32 2
  %d = insertelement <6 x i12> %c, i12 %v2, i32 3
  %e = insertelement <6 x i12> %d, i12 %v2, i32 4
  %f = insertelement <6 x i12> %e, i12 %v1, i32 5
  ret <6 x i12> %f
}

define <7 x i12> @ret_v7i12(i12 %v1, i12 %v2) {
  ; CHECK-LABEL: name: ret_v7i12
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $w0, $w1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s12) = G_TRUNC [[COPY]](s32)
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $w1
  ; CHECK-NEXT:   [[TRUNC1:%[0-9]+]]:_(s12) = G_TRUNC [[COPY1]](s32)
  ; CHECK-NEXT:   [[DEF:%[0-9]+]]:_(<7 x s12>) = G_IMPLICIT_DEF
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 0
  ; CHECK-NEXT:   [[C1:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[C2:%[0-9]+]]:_(s64) = G_CONSTANT i64 2
  ; CHECK-NEXT:   [[C3:%[0-9]+]]:_(s64) = G_CONSTANT i64 3
  ; CHECK-NEXT:   [[C4:%[0-9]+]]:_(s64) = G_CONSTANT i64 4
  ; CHECK-NEXT:   [[C5:%[0-9]+]]:_(s64) = G_CONSTANT i64 5
  ; CHECK-NEXT:   [[C6:%[0-9]+]]:_(s64) = G_CONSTANT i64 6
  ; CHECK-NEXT:   [[IVEC:%[0-9]+]]:_(<7 x s12>) = G_INSERT_VECTOR_ELT [[DEF]], [[TRUNC1]](s12), [[C]](s64)
  ; CHECK-NEXT:   [[IVEC1:%[0-9]+]]:_(<7 x s12>) = G_INSERT_VECTOR_ELT [[IVEC]], [[TRUNC]](s12), [[C1]](s64)
  ; CHECK-NEXT:   [[IVEC2:%[0-9]+]]:_(<7 x s12>) = G_INSERT_VECTOR_ELT [[IVEC1]], [[TRUNC]](s12), [[C2]](s64)
  ; CHECK-NEXT:   [[IVEC3:%[0-9]+]]:_(<7 x s12>) = G_INSERT_VECTOR_ELT [[IVEC2]], [[TRUNC1]](s12), [[C3]](s64)
  ; CHECK-NEXT:   [[IVEC4:%[0-9]+]]:_(<7 x s12>) = G_INSERT_VECTOR_ELT [[IVEC3]], [[TRUNC1]](s12), [[C4]](s64)
  ; CHECK-NEXT:   [[IVEC5:%[0-9]+]]:_(<7 x s12>) = G_INSERT_VECTOR_ELT [[IVEC4]], [[TRUNC]](s12), [[C5]](s64)
  ; CHECK-NEXT:   [[IVEC6:%[0-9]+]]:_(<7 x s12>) = G_INSERT_VECTOR_ELT [[IVEC5]], [[TRUNC]](s12), [[C6]](s64)
  ; CHECK-NEXT:   [[UV:%[0-9]+]]:_(s12), [[UV1:%[0-9]+]]:_(s12), [[UV2:%[0-9]+]]:_(s12), [[UV3:%[0-9]+]]:_(s12), [[UV4:%[0-9]+]]:_(s12), [[UV5:%[0-9]+]]:_(s12), [[UV6:%[0-9]+]]:_(s12) = G_UNMERGE_VALUES [[IVEC6]](<7 x s12>)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[UV]](s12)
  ; CHECK-NEXT:   [[ANYEXT1:%[0-9]+]]:_(s32) = G_ANYEXT [[UV1]](s12)
  ; CHECK-NEXT:   [[ANYEXT2:%[0-9]+]]:_(s32) = G_ANYEXT [[UV2]](s12)
  ; CHECK-NEXT:   [[ANYEXT3:%[0-9]+]]:_(s32) = G_ANYEXT [[UV3]](s12)
  ; CHECK-NEXT:   [[ANYEXT4:%[0-9]+]]:_(s32) = G_ANYEXT [[UV4]](s12)
  ; CHECK-NEXT:   [[ANYEXT5:%[0-9]+]]:_(s32) = G_ANYEXT [[UV5]](s12)
  ; CHECK-NEXT:   [[ANYEXT6:%[0-9]+]]:_(s32) = G_ANYEXT [[UV6]](s12)
  ; CHECK-NEXT:   $w0 = COPY [[ANYEXT]](s32)
  ; CHECK-NEXT:   $w1 = COPY [[ANYEXT1]](s32)
  ; CHECK-NEXT:   $w2 = COPY [[ANYEXT2]](s32)
  ; CHECK-NEXT:   $w3 = COPY [[ANYEXT3]](s32)
  ; CHECK-NEXT:   $w4 = COPY [[ANYEXT4]](s32)
  ; CHECK-NEXT:   $w5 = COPY [[ANYEXT5]](s32)
  ; CHECK-NEXT:   $w6 = COPY [[ANYEXT6]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0, implicit $w1, implicit $w2, implicit $w3, implicit $w4, implicit $w5, implicit $w6
  %a = insertelement <7 x i12> poison, i12 %v2, i32 0
  %b = insertelement <7 x i12> %a, i12 %v1, i32 1
  %c = insertelement <7 x i12> %b, i12 %v1, i32 2
  %d = insertelement <7 x i12> %c, i12 %v2, i32 3
  %e = insertelement <7 x i12> %d, i12 %v2, i32 4
  %f = insertelement <7 x i12> %e, i12 %v1, i32 5
  %g = insertelement <7 x i12> %f, i12 %v1, i32 6
  ret <7 x i12> %g
}

define <8 x i12> @ret_v8i12(i12 %v1, i12 %v2) {
  ; CHECK-LABEL: name: ret_v8i12
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $w0, $w1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s12) = G_TRUNC [[COPY]](s32)
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $w1
  ; CHECK-NEXT:   [[TRUNC1:%[0-9]+]]:_(s12) = G_TRUNC [[COPY1]](s32)
  ; CHECK-NEXT:   [[DEF:%[0-9]+]]:_(<8 x s12>) = G_IMPLICIT_DEF
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 0
  ; CHECK-NEXT:   [[C1:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[C2:%[0-9]+]]:_(s64) = G_CONSTANT i64 2
  ; CHECK-NEXT:   [[C3:%[0-9]+]]:_(s64) = G_CONSTANT i64 3
  ; CHECK-NEXT:   [[C4:%[0-9]+]]:_(s64) = G_CONSTANT i64 4
  ; CHECK-NEXT:   [[C5:%[0-9]+]]:_(s64) = G_CONSTANT i64 5
  ; CHECK-NEXT:   [[C6:%[0-9]+]]:_(s64) = G_CONSTANT i64 6
  ; CHECK-NEXT:   [[C7:%[0-9]+]]:_(s64) = G_CONSTANT i64 7
  ; CHECK-NEXT:   [[IVEC:%[0-9]+]]:_(<8 x s12>) = G_INSERT_VECTOR_ELT [[DEF]], [[TRUNC1]](s12), [[C]](s64)
  ; CHECK-NEXT:   [[IVEC1:%[0-9]+]]:_(<8 x s12>) = G_INSERT_VECTOR_ELT [[IVEC]], [[TRUNC]](s12), [[C1]](s64)
  ; CHECK-NEXT:   [[IVEC2:%[0-9]+]]:_(<8 x s12>) = G_INSERT_VECTOR_ELT [[IVEC1]], [[TRUNC]](s12), [[C2]](s64)
  ; CHECK-NEXT:   [[IVEC3:%[0-9]+]]:_(<8 x s12>) = G_INSERT_VECTOR_ELT [[IVEC2]], [[TRUNC1]](s12), [[C3]](s64)
  ; CHECK-NEXT:   [[IVEC4:%[0-9]+]]:_(<8 x s12>) = G_INSERT_VECTOR_ELT [[IVEC3]], [[TRUNC1]](s12), [[C4]](s64)
  ; CHECK-NEXT:   [[IVEC5:%[0-9]+]]:_(<8 x s12>) = G_INSERT_VECTOR_ELT [[IVEC4]], [[TRUNC]](s12), [[C5]](s64)
  ; CHECK-NEXT:   [[IVEC6:%[0-9]+]]:_(<8 x s12>) = G_INSERT_VECTOR_ELT [[IVEC5]], [[TRUNC]](s12), [[C6]](s64)
  ; CHECK-NEXT:   [[IVEC7:%[0-9]+]]:_(<8 x s12>) = G_INSERT_VECTOR_ELT [[IVEC6]], [[TRUNC]](s12), [[C7]](s64)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(<8 x s16>) = G_ANYEXT [[IVEC7]](<8 x s12>)
  ; CHECK-NEXT:   $q0 = COPY [[ANYEXT]](<8 x s16>)
  ; CHECK-NEXT:   RET_ReallyLR implicit $q0
  %a = insertelement <8 x i12> poison, i12 %v2, i32 0
  %b = insertelement <8 x i12> %a, i12 %v1, i32 1
  %c = insertelement <8 x i12> %b, i12 %v1, i32 2
  %d = insertelement <8 x i12> %c, i12 %v2, i32 3
  %e = insertelement <8 x i12> %d, i12 %v2, i32 4
  %f = insertelement <8 x i12> %e, i12 %v1, i32 5
  %g = insertelement <8 x i12> %f, i12 %v1, i32 6
  %h = insertelement <8 x i12> %g, i12 %v1, i32 7
  ret <8 x i12> %h
}

define <12 x i12> @ret_v12i12(i12 %v1, i12 %v2) {
  ; CHECK-LABEL: name: ret_v12i12
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $w0, $w1, $x8
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x8
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s12) = G_TRUNC [[COPY1]](s32)
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $w1
  ; CHECK-NEXT:   [[TRUNC1:%[0-9]+]]:_(s12) = G_TRUNC [[COPY2]](s32)
  ; CHECK-NEXT:   [[DEF:%[0-9]+]]:_(<12 x s12>) = G_IMPLICIT_DEF
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 0
  ; CHECK-NEXT:   [[C1:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[C2:%[0-9]+]]:_(s64) = G_CONSTANT i64 2
  ; CHECK-NEXT:   [[C3:%[0-9]+]]:_(s64) = G_CONSTANT i64 3
  ; CHECK-NEXT:   [[C4:%[0-9]+]]:_(s64) = G_CONSTANT i64 4
  ; CHECK-NEXT:   [[C5:%[0-9]+]]:_(s64) = G_CONSTANT i64 5
  ; CHECK-NEXT:   [[C6:%[0-9]+]]:_(s64) = G_CONSTANT i64 6
  ; CHECK-NEXT:   [[C7:%[0-9]+]]:_(s64) = G_CONSTANT i64 7
  ; CHECK-NEXT:   [[C8:%[0-9]+]]:_(s64) = G_CONSTANT i64 8
  ; CHECK-NEXT:   [[C9:%[0-9]+]]:_(s64) = G_CONSTANT i64 9
  ; CHECK-NEXT:   [[C10:%[0-9]+]]:_(s64) = G_CONSTANT i64 10
  ; CHECK-NEXT:   [[C11:%[0-9]+]]:_(s64) = G_CONSTANT i64 11
  ; CHECK-NEXT:   [[IVEC:%[0-9]+]]:_(<12 x s12>) = G_INSERT_VECTOR_ELT [[DEF]], [[TRUNC1]](s12), [[C]](s64)
  ; CHECK-NEXT:   [[IVEC1:%[0-9]+]]:_(<12 x s12>) = G_INSERT_VECTOR_ELT [[IVEC]], [[TRUNC]](s12), [[C1]](s64)
  ; CHECK-NEXT:   [[IVEC2:%[0-9]+]]:_(<12 x s12>) = G_INSERT_VECTOR_ELT [[IVEC1]], [[TRUNC]](s12), [[C2]](s64)
  ; CHECK-NEXT:   [[IVEC3:%[0-9]+]]:_(<12 x s12>) = G_INSERT_VECTOR_ELT [[IVEC2]], [[TRUNC1]](s12), [[C3]](s64)
  ; CHECK-NEXT:   [[IVEC4:%[0-9]+]]:_(<12 x s12>) = G_INSERT_VECTOR_ELT [[IVEC3]], [[TRUNC1]](s12), [[C4]](s64)
  ; CHECK-NEXT:   [[IVEC5:%[0-9]+]]:_(<12 x s12>) = G_INSERT_VECTOR_ELT [[IVEC4]], [[TRUNC]](s12), [[C5]](s64)
  ; CHECK-NEXT:   [[IVEC6:%[0-9]+]]:_(<12 x s12>) = G_INSERT_VECTOR_ELT [[IVEC5]], [[TRUNC]](s12), [[C6]](s64)
  ; CHECK-NEXT:   [[IVEC7:%[0-9]+]]:_(<12 x s12>) = G_INSERT_VECTOR_ELT [[IVEC6]], [[TRUNC]](s12), [[C7]](s64)
  ; CHECK-NEXT:   [[IVEC8:%[0-9]+]]:_(<12 x s12>) = G_INSERT_VECTOR_ELT [[IVEC7]], [[TRUNC]](s12), [[C8]](s64)
  ; CHECK-NEXT:   [[IVEC9:%[0-9]+]]:_(<12 x s12>) = G_INSERT_VECTOR_ELT [[IVEC8]], [[TRUNC]](s12), [[C9]](s64)
  ; CHECK-NEXT:   [[IVEC10:%[0-9]+]]:_(<12 x s12>) = G_INSERT_VECTOR_ELT [[IVEC9]], [[TRUNC]](s12), [[C10]](s64)
  ; CHECK-NEXT:   [[IVEC11:%[0-9]+]]:_(<12 x s12>) = G_INSERT_VECTOR_ELT [[IVEC10]], [[TRUNC]](s12), [[C11]](s64)
  ; CHECK-NEXT:   G_STORE [[IVEC11]](<12 x s12>), [[COPY]](p0) :: (store (<12 x s12>), align 32)
  ; CHECK-NEXT:   RET_ReallyLR
  %a = insertelement <12 x i12> poison, i12 %v2, i32 0
  %b = insertelement <12 x i12> %a, i12 %v1, i32 1
  %c = insertelement <12 x i12> %b, i12 %v1, i32 2
  %d = insertelement <12 x i12> %c, i12 %v2, i32 3
  %e = insertelement <12 x i12> %d, i12 %v2, i32 4
  %f = insertelement <12 x i12> %e, i12 %v1, i32 5
  %g = insertelement <12 x i12> %f, i12 %v1, i32 6
  %h = insertelement <12 x i12> %g, i12 %v1, i32 7
  %i = insertelement <12 x i12> %h, i12 %v1, i32 8
  %j = insertelement <12 x i12> %i, i12 %v1, i32 9
  %k = insertelement <12 x i12> %j, i12 %v1, i32 10
  %l = insertelement <12 x i12> %k, i12 %v1, i32 11
  ret <12 x i12> %l
}


define <1 x i100> @ret_v1i100(i100 %v1, i100 %v2) {
  ; CHECK-LABEL: name: ret_v1i100
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $x0, $x1, $x2, $x3
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s64) = COPY $x0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x1
  ; CHECK-NEXT:   [[MV:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY]](s64), [[COPY1]](s64)
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s100) = G_TRUNC [[MV]](s128)
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s64) = COPY $x2
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(s64) = COPY $x3
  ; CHECK-NEXT:   [[MV1:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY2]](s64), [[COPY3]](s64)
  ; CHECK-NEXT:   [[TRUNC1:%[0-9]+]]:_(s100) = G_TRUNC [[MV1]](s128)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(s128) = G_ANYEXT [[TRUNC]](s100)
  ; CHECK-NEXT:   [[UV:%[0-9]+]]:_(s64), [[UV1:%[0-9]+]]:_(s64) = G_UNMERGE_VALUES [[ANYEXT]](s128)
  ; CHECK-NEXT:   $x0 = COPY [[UV]](s64)
  ; CHECK-NEXT:   $x1 = COPY [[UV1]](s64)
  ; CHECK-NEXT:   RET_ReallyLR implicit $x0, implicit $x1
  %a = insertelement <1 x i100> poison, i100 %v1, i32 0
  ret <1 x i100> %a
}

define <2 x i100> @ret_v2i100(i100 %v1, i100 %v2) {
  ; CHECK-LABEL: name: ret_v2i100
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $x0, $x1, $x2, $x3
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s64) = COPY $x0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x1
  ; CHECK-NEXT:   [[MV:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY]](s64), [[COPY1]](s64)
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s100) = G_TRUNC [[MV]](s128)
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s64) = COPY $x2
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(s64) = COPY $x3
  ; CHECK-NEXT:   [[MV1:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY2]](s64), [[COPY3]](s64)
  ; CHECK-NEXT:   [[TRUNC1:%[0-9]+]]:_(s100) = G_TRUNC [[MV1]](s128)
  ; CHECK-NEXT:   [[DEF:%[0-9]+]]:_(<2 x s100>) = G_IMPLICIT_DEF
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 0
  ; CHECK-NEXT:   [[C1:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[IVEC:%[0-9]+]]:_(<2 x s100>) = G_INSERT_VECTOR_ELT [[DEF]], [[TRUNC]](s100), [[C]](s64)
  ; CHECK-NEXT:   [[IVEC1:%[0-9]+]]:_(<2 x s100>) = G_INSERT_VECTOR_ELT [[IVEC]], [[TRUNC1]](s100), [[C1]](s64)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(<2 x s128>) = G_ANYEXT [[IVEC1]](<2 x s100>)
  ; CHECK-NEXT:   [[UV:%[0-9]+]]:_(s64), [[UV1:%[0-9]+]]:_(s64), [[UV2:%[0-9]+]]:_(s64), [[UV3:%[0-9]+]]:_(s64) = G_UNMERGE_VALUES [[ANYEXT]](<2 x s128>)
  ; CHECK-NEXT:   $x0 = COPY [[UV]](s64)
  ; CHECK-NEXT:   $x1 = COPY [[UV1]](s64)
  ; CHECK-NEXT:   $x2 = COPY [[UV2]](s64)
  ; CHECK-NEXT:   $x3 = COPY [[UV3]](s64)
  ; CHECK-NEXT:   RET_ReallyLR implicit $x0, implicit $x1, implicit $x2, implicit $x3
  %a = insertelement <2 x i100> poison, i100 %v1, i32 0
  %b = insertelement <2 x i100> %a, i100 %v2, i32 1
  ret <2 x i100> %b
}

define <3 x i100> @ret_v3i100(i100 %v1, i100 %v2) {
  ; CHECK-LABEL: name: ret_v3i100
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $x0, $x1, $x2, $x3
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s64) = COPY $x0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x1
  ; CHECK-NEXT:   [[MV:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY]](s64), [[COPY1]](s64)
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s100) = G_TRUNC [[MV]](s128)
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s64) = COPY $x2
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(s64) = COPY $x3
  ; CHECK-NEXT:   [[MV1:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY2]](s64), [[COPY3]](s64)
  ; CHECK-NEXT:   [[TRUNC1:%[0-9]+]]:_(s100) = G_TRUNC [[MV1]](s128)
  ; CHECK-NEXT:   [[DEF:%[0-9]+]]:_(<3 x s100>) = G_IMPLICIT_DEF
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 0
  ; CHECK-NEXT:   [[C1:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[C2:%[0-9]+]]:_(s64) = G_CONSTANT i64 2
  ; CHECK-NEXT:   [[IVEC:%[0-9]+]]:_(<3 x s100>) = G_INSERT_VECTOR_ELT [[DEF]], [[TRUNC]](s100), [[C]](s64)
  ; CHECK-NEXT:   [[IVEC1:%[0-9]+]]:_(<3 x s100>) = G_INSERT_VECTOR_ELT [[IVEC]], [[TRUNC1]](s100), [[C1]](s64)
  ; CHECK-NEXT:   [[IVEC2:%[0-9]+]]:_(<3 x s100>) = G_INSERT_VECTOR_ELT [[IVEC1]], [[TRUNC1]](s100), [[C2]](s64)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(<3 x s128>) = G_ANYEXT [[IVEC2]](<3 x s100>)
  ; CHECK-NEXT:   [[UV:%[0-9]+]]:_(s64), [[UV1:%[0-9]+]]:_(s64), [[UV2:%[0-9]+]]:_(s64), [[UV3:%[0-9]+]]:_(s64), [[UV4:%[0-9]+]]:_(s64), [[UV5:%[0-9]+]]:_(s64) = G_UNMERGE_VALUES [[ANYEXT]](<3 x s128>)
  ; CHECK-NEXT:   $x0 = COPY [[UV]](s64)
  ; CHECK-NEXT:   $x1 = COPY [[UV1]](s64)
  ; CHECK-NEXT:   $x2 = COPY [[UV2]](s64)
  ; CHECK-NEXT:   $x3 = COPY [[UV3]](s64)
  ; CHECK-NEXT:   $x4 = COPY [[UV4]](s64)
  ; CHECK-NEXT:   $x5 = COPY [[UV5]](s64)
  ; CHECK-NEXT:   RET_ReallyLR implicit $x0, implicit $x1, implicit $x2, implicit $x3, implicit $x4, implicit $x5
  %a = insertelement <3 x i100> poison, i100 %v1, i32 0
  %b = insertelement <3 x i100> %a, i100 %v2, i32 1
  %c = insertelement <3 x i100> %b, i100 %v2, i32 2
  ret <3 x i100> %c
}

define <4 x i100> @ret_v4i100(i100 %v1, i100 %v2) {
  ; CHECK-LABEL: name: ret_v4i100
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $x0, $x1, $x2, $x3
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s64) = COPY $x0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x1
  ; CHECK-NEXT:   [[MV:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY]](s64), [[COPY1]](s64)
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s100) = G_TRUNC [[MV]](s128)
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s64) = COPY $x2
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(s64) = COPY $x3
  ; CHECK-NEXT:   [[MV1:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY2]](s64), [[COPY3]](s64)
  ; CHECK-NEXT:   [[TRUNC1:%[0-9]+]]:_(s100) = G_TRUNC [[MV1]](s128)
  ; CHECK-NEXT:   [[DEF:%[0-9]+]]:_(<4 x s100>) = G_IMPLICIT_DEF
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 0
  ; CHECK-NEXT:   [[C1:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[C2:%[0-9]+]]:_(s64) = G_CONSTANT i64 2
  ; CHECK-NEXT:   [[C3:%[0-9]+]]:_(s64) = G_CONSTANT i64 3
  ; CHECK-NEXT:   [[IVEC:%[0-9]+]]:_(<4 x s100>) = G_INSERT_VECTOR_ELT [[DEF]], [[TRUNC]](s100), [[C]](s64)
  ; CHECK-NEXT:   [[IVEC1:%[0-9]+]]:_(<4 x s100>) = G_INSERT_VECTOR_ELT [[IVEC]], [[TRUNC1]](s100), [[C1]](s64)
  ; CHECK-NEXT:   [[IVEC2:%[0-9]+]]:_(<4 x s100>) = G_INSERT_VECTOR_ELT [[IVEC1]], [[TRUNC]](s100), [[C2]](s64)
  ; CHECK-NEXT:   [[IVEC3:%[0-9]+]]:_(<4 x s100>) = G_INSERT_VECTOR_ELT [[IVEC2]], [[TRUNC1]](s100), [[C3]](s64)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(<4 x s128>) = G_ANYEXT [[IVEC3]](<4 x s100>)
  ; CHECK-NEXT:   [[UV:%[0-9]+]]:_(s64), [[UV1:%[0-9]+]]:_(s64), [[UV2:%[0-9]+]]:_(s64), [[UV3:%[0-9]+]]:_(s64), [[UV4:%[0-9]+]]:_(s64), [[UV5:%[0-9]+]]:_(s64), [[UV6:%[0-9]+]]:_(s64), [[UV7:%[0-9]+]]:_(s64) = G_UNMERGE_VALUES [[ANYEXT]](<4 x s128>)
  ; CHECK-NEXT:   $x0 = COPY [[UV]](s64)
  ; CHECK-NEXT:   $x1 = COPY [[UV1]](s64)
  ; CHECK-NEXT:   $x2 = COPY [[UV2]](s64)
  ; CHECK-NEXT:   $x3 = COPY [[UV3]](s64)
  ; CHECK-NEXT:   $x4 = COPY [[UV4]](s64)
  ; CHECK-NEXT:   $x5 = COPY [[UV5]](s64)
  ; CHECK-NEXT:   $x6 = COPY [[UV6]](s64)
  ; CHECK-NEXT:   $x7 = COPY [[UV7]](s64)
  ; CHECK-NEXT:   RET_ReallyLR implicit $x0, implicit $x1, implicit $x2, implicit $x3, implicit $x4, implicit $x5, implicit $x6, implicit $x7
  %a = insertelement <4 x i100> poison, i100 %v1, i32 0
  %b = insertelement <4 x i100> %a, i100 %v2, i32 1
  %c = insertelement <4 x i100> %b, i100 %v1, i32 2
  %d = insertelement <4 x i100> %c, i100 %v2, i32 3
  ret <4 x i100> %d
}
