; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=ipsccp -S < %s | FileCheck %s

define i8 @ashr_and(i8 %x) {
; CHECK-LABEL: @ashr_and(
; CHECK-NEXT:    [[PX:%.*]] = and i8 [[X:%.*]], 127
; CHECK-NEXT:    [[R:%.*]] = lshr i8 [[PX]], 1
; CHECK-NEXT:    ret i8 [[R]]
;
  %px = and i8 %x, 127
  %r = ashr i8 %px, 1
  ret i8 %r
}

define i8 @ashr_const(i8 %x) {
; CHECK-LABEL: @ashr_const(
; CHECK-NEXT:    [[R:%.*]] = lshr i8 42, [[X:%.*]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %r = ashr i8 42, %x
  ret i8 %r
}

define i8 @ashr_zext(i7 %x, i8 %y) {
; CHECK-LABEL: @ashr_zext(
; CHECK-NEXT:    [[PX:%.*]] = zext i7 [[X:%.*]] to i8
; CHECK-NEXT:    [[R:%.*]] = lshr i8 [[PX]], [[Y:%.*]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %px = zext i7 %x to i8
  %r = ashr i8 %px, %y
  ret i8 %r
}

; negative test

define i8 @ashr_not_nonneg(i7 %x, i8 %y) {
; CHECK-LABEL: @ashr_not_nonneg(
; CHECK-NEXT:    [[PX:%.*]] = sext i7 [[X:%.*]] to i8
; CHECK-NEXT:    [[R:%.*]] = ashr i8 [[PX]], [[Y:%.*]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %px = sext i7 %x to i8
  %r = ashr i8 %px, %y
  ret i8 %r
}

; x is known non-negative in t block

define i32 @dominating_condition(i32 %x) {
; CHECK-LABEL: @dominating_condition(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sge i32 [[X:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       t:
; CHECK-NEXT:    [[A:%.*]] = lshr i32 [[X]], 16
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       f:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[COND:%.*]] = phi i32 [ [[A]], [[T]] ], [ 42, [[F]] ]
; CHECK-NEXT:    ret i32 [[COND]]
;
entry:
  %cmp = icmp sge i32 %x, 0
  br i1 %cmp, label %t, label %f

t:
  %a = ashr i32 %x, 16
  br label %exit

f:
  br label %exit

exit:
  %cond = phi i32 [ %a, %t ], [ 42, %f ]
  ret i32 %cond
}

; x is known non-negative in f block

define i32 @dominating_condition_alt(i32 %x, i32 %y) {
; CHECK-LABEL: @dominating_condition_alt(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[X:%.*]], 2000000000
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       t:
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       f:
; CHECK-NEXT:    [[A:%.*]] = lshr i32 [[X]], [[Y:%.*]]
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[COND:%.*]] = phi i32 [ -42, [[T]] ], [ [[A]], [[F]] ]
; CHECK-NEXT:    ret i32 [[COND]]
;
entry:
  %cmp = icmp ugt i32 %x, 2000000000
  br i1 %cmp, label %t, label %f

t:
  br label %exit

f:
  %a = ashr i32 %x, %y
  br label %exit

exit:
  %cond = phi i32 [ -42, %t ], [ %a, %f ]
  ret i32 %cond
}
