; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-globals
; RUN: opt --mtriple=amdgcn-amd-amdhsa --data-layout=A5 -S -passes=openmp-opt < %s | FileCheck %s --check-prefixes=AMDGPU
; RUN: opt --mtriple=nvptx64-- -S -passes=openmp-opt < %s | FileCheck %s --check-prefixes=NVPTX

%struct.ident_t = type { i32, i32, i32, i32, ptr }
%struct.KernelEnvironmentTy = type { %struct.ConfigurationEnvironmentTy, ptr, ptr }
%struct.ConfigurationEnvironmentTy = type { i8, i8, i8, i32, i32, i32, i32, i32, i32 }

@0 = private unnamed_addr constant [23 x i8] c";unknown;unknown;0;0;;\00", align 1
@1 = private unnamed_addr constant %struct.ident_t { i32 0, i32 2, i32 0, i32 0, ptr @0 }, align 8
@spmd_callees_kernel_environment = local_unnamed_addr constant %struct.KernelEnvironmentTy { %struct.ConfigurationEnvironmentTy { i8 1, i8 0, i8 1, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0 }, ptr @1, ptr null }
@spmd_callees_metadata_kernel_environment = local_unnamed_addr constant %struct.KernelEnvironmentTy { %struct.ConfigurationEnvironmentTy { i8 1, i8 0, i8 1, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0 }, ptr @1, ptr null }
@spmd_and_non_spmd_callees_metadata_kernel_environment = local_unnamed_addr constant %struct.KernelEnvironmentTy { %struct.ConfigurationEnvironmentTy { i8 1, i8 0, i8 1, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0 }, ptr @1, ptr null }
@spmd_and_non_spmd_callee_kernel_environment = local_unnamed_addr constant %struct.KernelEnvironmentTy { %struct.ConfigurationEnvironmentTy { i8 1, i8 0, i8 1, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0 }, ptr @1, ptr null }

; Function Attrs: alwaysinline convergent norecurse nounwind
;.
; AMDGPU: @[[GLOB0:[0-9]+]] = private unnamed_addr constant [23 x i8] c"
; AMDGPU: @[[GLOB1:[0-9]+]] = private unnamed_addr constant %struct.ident_t { i32 0, i32 2, i32 0, i32 0, ptr @[[GLOB0]] }, align 8
; AMDGPU: @spmd_callees_kernel_environment = local_unnamed_addr constant %struct.KernelEnvironmentTy { %struct.ConfigurationEnvironmentTy { i8 0, i8 1, i8 3, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0 }, ptr @[[GLOB1]], ptr null }
; AMDGPU: @spmd_callees_metadata_kernel_environment = local_unnamed_addr constant %struct.KernelEnvironmentTy { %struct.ConfigurationEnvironmentTy { i8 0, i8 0, i8 3, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0 }, ptr @[[GLOB1]], ptr null }
; AMDGPU: @spmd_and_non_spmd_callees_metadata_kernel_environment = local_unnamed_addr constant %struct.KernelEnvironmentTy { %struct.ConfigurationEnvironmentTy { i8 0, i8 0, i8 1, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0 }, ptr @[[GLOB1]], ptr null }
; AMDGPU: @spmd_and_non_spmd_callee_kernel_environment = local_unnamed_addr constant %struct.KernelEnvironmentTy { %struct.ConfigurationEnvironmentTy { i8 0, i8 0, i8 1, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0 }, ptr @[[GLOB1]], ptr null }
;.
; NVPTX: @[[GLOB0:[0-9]+]] = private unnamed_addr constant [23 x i8] c"
; NVPTX: @[[GLOB1:[0-9]+]] = private unnamed_addr constant %struct.ident_t { i32 0, i32 2, i32 0, i32 0, ptr @[[GLOB0]] }, align 8
; NVPTX: @spmd_callees_kernel_environment = local_unnamed_addr constant %struct.KernelEnvironmentTy { %struct.ConfigurationEnvironmentTy { i8 0, i8 1, i8 3, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0 }, ptr @[[GLOB1]], ptr null }
; NVPTX: @spmd_callees_metadata_kernel_environment = local_unnamed_addr constant %struct.KernelEnvironmentTy { %struct.ConfigurationEnvironmentTy { i8 0, i8 0, i8 3, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0 }, ptr @[[GLOB1]], ptr null }
; NVPTX: @spmd_and_non_spmd_callees_metadata_kernel_environment = local_unnamed_addr constant %struct.KernelEnvironmentTy { %struct.ConfigurationEnvironmentTy { i8 0, i8 0, i8 1, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0 }, ptr @[[GLOB1]], ptr null }
; NVPTX: @spmd_and_non_spmd_callee_kernel_environment = local_unnamed_addr constant %struct.KernelEnvironmentTy { %struct.ConfigurationEnvironmentTy { i8 0, i8 0, i8 1, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0 }, ptr @[[GLOB1]], ptr null }
;.
define weak ptx_kernel void @spmd_callees(i1 %c) #0 {
; AMDGPU-LABEL: define {{[^@]+}}@spmd_callees
; AMDGPU-SAME: (i1 [[C:%.*]]) #[[ATTR0:[0-9]+]] {
; AMDGPU-NEXT:    call void @spmd_callees__debug(i1 [[C]])
; AMDGPU-NEXT:    ret void
;
; NVPTX-LABEL: define {{[^@]+}}@spmd_callees
; NVPTX-SAME: (i1 [[C:%.*]]) #[[ATTR0:[0-9]+]] {
; NVPTX-NEXT:    call void @spmd_callees__debug(i1 [[C]])
; NVPTX-NEXT:    ret void
;
  call void @spmd_callees__debug(i1 %c)
  ret void
}

define internal void @spmd_callees__debug(i1 %c) {
; AMDGPU-LABEL: define {{[^@]+}}@spmd_callees__debug
; AMDGPU-SAME: (i1 [[C:%.*]]) #[[ATTR1:[0-9]+]] {
; AMDGPU-NEXT:  entry:
; AMDGPU-NEXT:    [[DOTZERO_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
; AMDGPU-NEXT:    [[DOTZERO_ADDR_CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTZERO_ADDR]] to ptr
; AMDGPU-NEXT:    [[DOTTHREADID_TEMP_:%.*]] = alloca ptr, align 8, addrspace(5)
; AMDGPU-NEXT:    [[DOTTHREADID_TEMP__CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTTHREADID_TEMP_]] to ptr
; AMDGPU-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_target_init(ptr @spmd_callees_kernel_environment, ptr null)
; AMDGPU-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP0]], -1
; AMDGPU-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[COMMON_RET:%.*]]
; AMDGPU:       common.ret:
; AMDGPU-NEXT:    ret void
; AMDGPU:       user_code.entry:
; AMDGPU-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]]) #[[ATTR10:[0-9]+]]
; AMDGPU-NEXT:    store i32 0, ptr addrspace(5) [[DOTZERO_ADDR]], align 4
; AMDGPU-NEXT:    store i32 [[TMP1]], ptr addrspace(5) [[DOTTHREADID_TEMP_]], align 4, !tbaa [[TBAA12:![0-9]+]]
; AMDGPU-NEXT:    [[FP:%.*]] = select i1 [[C]], ptr @__omp_outlined_spmd_amenable1, ptr @__omp_outlined_spmd_amenable2
; AMDGPU-NEXT:    [[TMP2:%.*]] = icmp eq ptr [[FP]], @__omp_outlined_spmd_amenable2
; AMDGPU-NEXT:    br i1 [[TMP2]], label [[TMP3:%.*]], label [[TMP4:%.*]]
; AMDGPU:       3:
; AMDGPU-NEXT:    call void @__omp_outlined_spmd_amenable2(ptr [[DOTTHREADID_TEMP__CAST]], ptr [[DOTZERO_ADDR_CAST]]) #[[ATTR10]]
; AMDGPU-NEXT:    br label [[TMP7:%.*]]
; AMDGPU:       4:
; AMDGPU-NEXT:    br i1 true, label [[TMP5:%.*]], label [[TMP6:%.*]]
; AMDGPU:       5:
; AMDGPU-NEXT:    call void @__omp_outlined_spmd_amenable1(ptr [[DOTTHREADID_TEMP__CAST]], ptr [[DOTZERO_ADDR_CAST]]) #[[ATTR10]]
; AMDGPU-NEXT:    br label [[TMP7]]
; AMDGPU:       6:
; AMDGPU-NEXT:    unreachable
; AMDGPU:       7:
; AMDGPU-NEXT:    call void @__kmpc_target_deinit()
; AMDGPU-NEXT:    br label [[COMMON_RET]]
;
; NVPTX-LABEL: define {{[^@]+}}@spmd_callees__debug
; NVPTX-SAME: (i1 [[C:%.*]]) #[[ATTR1:[0-9]+]] {
; NVPTX-NEXT:  entry:
; NVPTX-NEXT:    [[DOTZERO_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
; NVPTX-NEXT:    [[DOTZERO_ADDR_CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTZERO_ADDR]] to ptr
; NVPTX-NEXT:    [[DOTTHREADID_TEMP_:%.*]] = alloca ptr, align 8, addrspace(5)
; NVPTX-NEXT:    [[DOTTHREADID_TEMP__CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTTHREADID_TEMP_]] to ptr
; NVPTX-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_target_init(ptr @spmd_callees_kernel_environment, ptr null)
; NVPTX-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP0]], -1
; NVPTX-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[COMMON_RET:%.*]]
; NVPTX:       common.ret:
; NVPTX-NEXT:    ret void
; NVPTX:       user_code.entry:
; NVPTX-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]]) #[[ATTR10:[0-9]+]]
; NVPTX-NEXT:    store i32 0, ptr addrspace(5) [[DOTZERO_ADDR]], align 4
; NVPTX-NEXT:    store i32 [[TMP1]], ptr addrspace(5) [[DOTTHREADID_TEMP_]], align 4, !tbaa [[TBAA12:![0-9]+]]
; NVPTX-NEXT:    [[FP:%.*]] = select i1 [[C]], ptr @__omp_outlined_spmd_amenable1, ptr @__omp_outlined_spmd_amenable2
; NVPTX-NEXT:    [[TMP2:%.*]] = icmp eq ptr [[FP]], @__omp_outlined_spmd_amenable2
; NVPTX-NEXT:    br i1 [[TMP2]], label [[TMP3:%.*]], label [[TMP4:%.*]]
; NVPTX:       3:
; NVPTX-NEXT:    call void @__omp_outlined_spmd_amenable2(ptr [[DOTTHREADID_TEMP__CAST]], ptr [[DOTZERO_ADDR_CAST]]) #[[ATTR10]]
; NVPTX-NEXT:    br label [[TMP7:%.*]]
; NVPTX:       4:
; NVPTX-NEXT:    br i1 true, label [[TMP5:%.*]], label [[TMP6:%.*]]
; NVPTX:       5:
; NVPTX-NEXT:    call void @__omp_outlined_spmd_amenable1(ptr [[DOTTHREADID_TEMP__CAST]], ptr [[DOTZERO_ADDR_CAST]]) #[[ATTR10]]
; NVPTX-NEXT:    br label [[TMP7]]
; NVPTX:       6:
; NVPTX-NEXT:    unreachable
; NVPTX:       7:
; NVPTX-NEXT:    call void @__kmpc_target_deinit()
; NVPTX-NEXT:    br label [[COMMON_RET]]
;
entry:
  %.zero.addr = alloca ptr, align 8, addrspace(5)
  %.zero.addr.cast = addrspacecast ptr addrspace(5) %.zero.addr to ptr
  %.threadid_temp. = alloca ptr, align 8, addrspace(5)
  %.threadid_temp..cast = addrspacecast ptr addrspace(5) %.threadid_temp. to ptr
  %0 = call i32 @__kmpc_target_init(ptr @spmd_callees_kernel_environment, ptr null)
  %exec_user_code = icmp eq i32 %0, -1
  br i1 %exec_user_code, label %user_code.entry, label %common.ret

common.ret:                                       ; preds = %user_code.entry, %entry
  ret void

user_code.entry:                                  ; preds = %entry
  %1 = call i32 @__kmpc_global_thread_num(ptr @1)
  store i32 0, ptr %.zero.addr.cast, align 4
  store i32 %1, ptr %.threadid_temp..cast, align 4, !tbaa !12
  %fp = select i1 %c, ptr @__omp_outlined_spmd_amenable1, ptr @__omp_outlined_spmd_amenable2
  call void %fp(ptr %.threadid_temp..cast, ptr %.zero.addr.cast) #8
  call void @__kmpc_target_deinit()
  br label %common.ret
}

define internal void @__omp_outlined_spmd_amenable1(ptr noalias %.global_tid., ptr noalias %.bound_tid.) {
; AMDGPU-LABEL: define {{[^@]+}}@__omp_outlined_spmd_amenable1
; AMDGPU-SAME: (ptr noalias [[DOTGLOBAL_TID_:%.*]], ptr noalias [[DOTBOUND_TID_:%.*]]) {
; AMDGPU-NEXT:  entry:
; AMDGPU-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca ptr, align 8, addrspace(5)
; AMDGPU-NEXT:    [[CAPTURED_VARS_ADDRS_CAST:%.*]] = addrspacecast ptr addrspace(5) [[CAPTURED_VARS_ADDRS]] to ptr
; AMDGPU-NEXT:    br label [[FOR_COND:%.*]]
; AMDGPU:       for.cond:
; AMDGPU-NEXT:    [[I_0:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[INC:%.*]], [[FOR_BODY:%.*]] ]
; AMDGPU-NEXT:    [[CMP:%.*]] = icmp slt i32 [[I_0]], 100
; AMDGPU-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_COND_CLEANUP:%.*]]
; AMDGPU:       for.cond.cleanup:
; AMDGPU-NEXT:    call void @spmd_amenable() #[[ATTR6:[0-9]+]]
; AMDGPU-NEXT:    ret void
; AMDGPU:       for.body:
; AMDGPU-NEXT:    [[TMP0:%.*]] = load i32, ptr [[DOTGLOBAL_TID_]], align 4, !tbaa [[TBAA12]]
; AMDGPU-NEXT:    call void @__kmpc_parallel_51(ptr @[[GLOB1]], i32 [[TMP0]], i32 1, i32 -1, i32 -1, ptr @__omp_outlined__1, ptr @__omp_outlined__1_wrapper, ptr [[CAPTURED_VARS_ADDRS_CAST]], i64 0)
; AMDGPU-NEXT:    [[INC]] = add nsw i32 [[I_0]], 1
; AMDGPU-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP16:![0-9]+]]
;
; NVPTX-LABEL: define {{[^@]+}}@__omp_outlined_spmd_amenable1
; NVPTX-SAME: (ptr noalias [[DOTGLOBAL_TID_:%.*]], ptr noalias [[DOTBOUND_TID_:%.*]]) {
; NVPTX-NEXT:  entry:
; NVPTX-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca ptr, align 8, addrspace(5)
; NVPTX-NEXT:    [[CAPTURED_VARS_ADDRS_CAST:%.*]] = addrspacecast ptr addrspace(5) [[CAPTURED_VARS_ADDRS]] to ptr
; NVPTX-NEXT:    br label [[FOR_COND:%.*]]
; NVPTX:       for.cond:
; NVPTX-NEXT:    [[I_0:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[INC:%.*]], [[FOR_BODY:%.*]] ]
; NVPTX-NEXT:    [[CMP:%.*]] = icmp slt i32 [[I_0]], 100
; NVPTX-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_COND_CLEANUP:%.*]]
; NVPTX:       for.cond.cleanup:
; NVPTX-NEXT:    call void @spmd_amenable() #[[ATTR6:[0-9]+]]
; NVPTX-NEXT:    ret void
; NVPTX:       for.body:
; NVPTX-NEXT:    [[TMP0:%.*]] = load i32, ptr [[DOTGLOBAL_TID_]], align 4, !tbaa [[TBAA12]]
; NVPTX-NEXT:    call void @__kmpc_parallel_51(ptr @[[GLOB1]], i32 [[TMP0]], i32 1, i32 -1, i32 -1, ptr @__omp_outlined__1, ptr @__omp_outlined__1_wrapper, ptr [[CAPTURED_VARS_ADDRS_CAST]], i64 0)
; NVPTX-NEXT:    [[INC]] = add nsw i32 [[I_0]], 1
; NVPTX-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP16:![0-9]+]]
;
entry:
  %captured_vars_addrs = alloca ptr, align 8, addrspace(5)
  %captured_vars_addrs.cast = addrspacecast ptr addrspace(5) %captured_vars_addrs to ptr
  br label %for.cond

for.cond:                                         ; preds = %for.body, %entry
  %i.0 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %cmp = icmp slt i32 %i.0, 100
  br i1 %cmp, label %for.body, label %for.cond.cleanup

for.cond.cleanup:                                 ; preds = %for.cond
  call void @spmd_amenable() #4
  ret void

for.body:                                         ; preds = %for.cond
  %0 = load i32, ptr %.global_tid., align 4, !tbaa !12
  call void @__kmpc_parallel_51(ptr @1, i32 %0, i32 1, i32 -1, i32 -1, ptr @__omp_outlined__1, ptr @__omp_outlined__1_wrapper, ptr %captured_vars_addrs.cast, i64 0)
  %inc = add nsw i32 %i.0, 1
  br label %for.cond, !llvm.loop !16
}

define internal void @__omp_outlined__1(ptr noalias %.global_tid., ptr noalias %.bound_tid.) {
; AMDGPU-LABEL: define {{[^@]+}}@__omp_outlined__1
; AMDGPU-SAME: (ptr noalias [[DOTGLOBAL_TID_:%.*]], ptr noalias [[DOTBOUND_TID_:%.*]]) {
; AMDGPU-NEXT:  entry:
; AMDGPU-NEXT:    call void @unknown() #[[ATTR7:[0-9]+]]
; AMDGPU-NEXT:    ret void
;
; NVPTX-LABEL: define {{[^@]+}}@__omp_outlined__1
; NVPTX-SAME: (ptr noalias [[DOTGLOBAL_TID_:%.*]], ptr noalias [[DOTBOUND_TID_:%.*]]) {
; NVPTX-NEXT:  entry:
; NVPTX-NEXT:    call void @unknown() #[[ATTR7:[0-9]+]]
; NVPTX-NEXT:    ret void
;
entry:
  call void @unknown() #5
  ret void
}

; Function Attrs: convergent norecurse nounwind
define internal void @__omp_outlined__1_wrapper(i16 zeroext %0, i32 %1) #1 {
; AMDGPU-LABEL: define {{[^@]+}}@__omp_outlined__1_wrapper
; AMDGPU-SAME: (i16 zeroext [[TMP0:%.*]], i32 [[TMP1:%.*]]) #[[ATTR2:[0-9]+]] {
; AMDGPU-NEXT:  entry:
; AMDGPU-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8, addrspace(5)
; AMDGPU-NEXT:    [[DOTADDR1_CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR1]] to ptr
; AMDGPU-NEXT:    [[DOTZERO_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
; AMDGPU-NEXT:    [[DOTZERO_ADDR_CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTZERO_ADDR]] to ptr
; AMDGPU-NEXT:    [[GLOBAL_ARGS:%.*]] = alloca ptr, align 8, addrspace(5)
; AMDGPU-NEXT:    [[GLOBAL_ARGS_CAST:%.*]] = addrspacecast ptr addrspace(5) [[GLOBAL_ARGS]] to ptr
; AMDGPU-NEXT:    call void @__kmpc_get_shared_variables(ptr [[GLOBAL_ARGS_CAST]])
; AMDGPU-NEXT:    call void @__omp_outlined__1(ptr [[DOTADDR1_CAST]], ptr [[DOTZERO_ADDR_CAST]]) #[[ATTR10]]
; AMDGPU-NEXT:    ret void
;
; NVPTX-LABEL: define {{[^@]+}}@__omp_outlined__1_wrapper
; NVPTX-SAME: (i16 zeroext [[TMP0:%.*]], i32 [[TMP1:%.*]]) #[[ATTR2:[0-9]+]] {
; NVPTX-NEXT:  entry:
; NVPTX-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8, addrspace(5)
; NVPTX-NEXT:    [[DOTADDR1_CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR1]] to ptr
; NVPTX-NEXT:    [[DOTZERO_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
; NVPTX-NEXT:    [[DOTZERO_ADDR_CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTZERO_ADDR]] to ptr
; NVPTX-NEXT:    [[GLOBAL_ARGS:%.*]] = alloca ptr, align 8, addrspace(5)
; NVPTX-NEXT:    [[GLOBAL_ARGS_CAST:%.*]] = addrspacecast ptr addrspace(5) [[GLOBAL_ARGS]] to ptr
; NVPTX-NEXT:    call void @__kmpc_get_shared_variables(ptr [[GLOBAL_ARGS_CAST]])
; NVPTX-NEXT:    call void @__omp_outlined__1(ptr [[DOTADDR1_CAST]], ptr [[DOTZERO_ADDR_CAST]]) #[[ATTR10]]
; NVPTX-NEXT:    ret void
;
entry:
  %.addr1 = alloca ptr, align 8, addrspace(5)
  %.addr1.cast = addrspacecast ptr addrspace(5) %.addr1 to ptr
  %.zero.addr = alloca ptr, align 8, addrspace(5)
  %.zero.addr.cast = addrspacecast ptr addrspace(5) %.zero.addr to ptr
  %global_args = alloca ptr, align 8, addrspace(5)
  %global_args.cast = addrspacecast ptr addrspace(5) %global_args to ptr
  store i32 %1, ptr %.addr1.cast, align 4, !tbaa !12
  store i32 0, ptr %.zero.addr.cast, align 4
  call void @__kmpc_get_shared_variables(ptr %global_args.cast)
  call void @__omp_outlined__1(ptr %.addr1.cast, ptr %.zero.addr.cast) #8
  ret void
}

define internal void @__omp_outlined_spmd_amenable2(ptr noalias %.global_tid., ptr noalias %.bound_tid.) {
; AMDGPU-LABEL: define {{[^@]+}}@__omp_outlined_spmd_amenable2
; AMDGPU-SAME: (ptr noalias [[DOTGLOBAL_TID_:%.*]], ptr noalias [[DOTBOUND_TID_:%.*]]) {
; AMDGPU-NEXT:  entry:
; AMDGPU-NEXT:    [[X_H2S:%.*]] = alloca i8, i64 4, align 4, addrspace(5)
; AMDGPU-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca ptr, align 8, addrspace(5)
; AMDGPU-NEXT:    [[CAPTURED_VARS_ADDRS_CAST:%.*]] = addrspacecast ptr addrspace(5) [[CAPTURED_VARS_ADDRS]] to ptr
; AMDGPU-NEXT:    [[MALLOC_CAST:%.*]] = addrspacecast ptr addrspace(5) [[X_H2S]] to ptr
; AMDGPU-NEXT:    call void @use(ptr captures(none) [[MALLOC_CAST]]) #[[ATTR6]]
; AMDGPU-NEXT:    br label [[FOR_COND:%.*]]
; AMDGPU:       for.cond:
; AMDGPU-NEXT:    [[I_0:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[INC:%.*]], [[FOR_BODY:%.*]] ]
; AMDGPU-NEXT:    [[CMP:%.*]] = icmp slt i32 [[I_0]], 100
; AMDGPU-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_COND_CLEANUP:%.*]]
; AMDGPU:       for.cond.cleanup:
; AMDGPU-NEXT:    call void @spmd_amenable() #[[ATTR6]]
; AMDGPU-NEXT:    ret void
; AMDGPU:       for.body:
; AMDGPU-NEXT:    [[TMP0:%.*]] = load i32, ptr [[DOTGLOBAL_TID_]], align 4, !tbaa [[TBAA12]]
; AMDGPU-NEXT:    call void @__kmpc_parallel_51(ptr @[[GLOB1]], i32 [[TMP0]], i32 1, i32 -1, i32 -1, ptr @__omp_outlined__3, ptr @__omp_outlined__3_wrapper, ptr [[CAPTURED_VARS_ADDRS_CAST]], i64 0)
; AMDGPU-NEXT:    [[INC]] = add nsw i32 [[I_0]], 1
; AMDGPU-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP19:![0-9]+]]
;
; NVPTX-LABEL: define {{[^@]+}}@__omp_outlined_spmd_amenable2
; NVPTX-SAME: (ptr noalias [[DOTGLOBAL_TID_:%.*]], ptr noalias [[DOTBOUND_TID_:%.*]]) {
; NVPTX-NEXT:  entry:
; NVPTX-NEXT:    [[X_H2S:%.*]] = alloca i8, i64 4, align 4
; NVPTX-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca ptr, align 8, addrspace(5)
; NVPTX-NEXT:    [[CAPTURED_VARS_ADDRS_CAST:%.*]] = addrspacecast ptr addrspace(5) [[CAPTURED_VARS_ADDRS]] to ptr
; NVPTX-NEXT:    call void @use(ptr captures(none) [[X_H2S]]) #[[ATTR6]]
; NVPTX-NEXT:    br label [[FOR_COND:%.*]]
; NVPTX:       for.cond:
; NVPTX-NEXT:    [[I_0:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[INC:%.*]], [[FOR_BODY:%.*]] ]
; NVPTX-NEXT:    [[CMP:%.*]] = icmp slt i32 [[I_0]], 100
; NVPTX-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_COND_CLEANUP:%.*]]
; NVPTX:       for.cond.cleanup:
; NVPTX-NEXT:    call void @spmd_amenable() #[[ATTR6]]
; NVPTX-NEXT:    ret void
; NVPTX:       for.body:
; NVPTX-NEXT:    [[TMP0:%.*]] = load i32, ptr [[DOTGLOBAL_TID_]], align 4, !tbaa [[TBAA12]]
; NVPTX-NEXT:    call void @__kmpc_parallel_51(ptr @[[GLOB1]], i32 [[TMP0]], i32 1, i32 -1, i32 -1, ptr @__omp_outlined__3, ptr @__omp_outlined__3_wrapper, ptr [[CAPTURED_VARS_ADDRS_CAST]], i64 0)
; NVPTX-NEXT:    [[INC]] = add nsw i32 [[I_0]], 1
; NVPTX-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP19:![0-9]+]]
;
entry:
  %captured_vars_addrs = alloca ptr, align 8, addrspace(5)
  %captured_vars_addrs.cast = addrspacecast ptr addrspace(5) %captured_vars_addrs to ptr
  %x = call align 4 ptr @__kmpc_alloc_shared(i64 4)
  call void @use(ptr captures(none) %x) #4
  br label %for.cond

for.cond:                                         ; preds = %for.body, %entry
  %i.0 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %cmp = icmp slt i32 %i.0, 100
  br i1 %cmp, label %for.body, label %for.cond.cleanup

for.cond.cleanup:                                 ; preds = %for.cond
  call void @spmd_amenable() #4
  call void @__kmpc_free_shared(ptr %x, i64 4)
  ret void

for.body:                                         ; preds = %for.cond
  %0 = load i32, ptr %.global_tid., align 4, !tbaa !12
  call void @__kmpc_parallel_51(ptr @1, i32 %0, i32 1, i32 -1, i32 -1, ptr @__omp_outlined__3, ptr @__omp_outlined__3_wrapper, ptr %captured_vars_addrs.cast, i64 0)
  %inc = add nsw i32 %i.0, 1
  br label %for.cond, !llvm.loop !19
}

define internal void @__omp_outlined__3(ptr noalias %.global_tid., ptr noalias %.bound_tid.) {
; AMDGPU-LABEL: define {{[^@]+}}@__omp_outlined__3
; AMDGPU-SAME: (ptr noalias [[DOTGLOBAL_TID_:%.*]], ptr noalias [[DOTBOUND_TID_:%.*]]) {
; AMDGPU-NEXT:  entry:
; AMDGPU-NEXT:    call void @unknown() #[[ATTR7]]
; AMDGPU-NEXT:    ret void
;
; NVPTX-LABEL: define {{[^@]+}}@__omp_outlined__3
; NVPTX-SAME: (ptr noalias [[DOTGLOBAL_TID_:%.*]], ptr noalias [[DOTBOUND_TID_:%.*]]) {
; NVPTX-NEXT:  entry:
; NVPTX-NEXT:    call void @unknown() #[[ATTR7]]
; NVPTX-NEXT:    ret void
;
entry:
  call void @unknown() #5
  ret void
}

; Function Attrs: convergent norecurse nounwind
define internal void @__omp_outlined__3_wrapper(i16 zeroext %0, i32 %1) #1 {
; AMDGPU-LABEL: define {{[^@]+}}@__omp_outlined__3_wrapper
; AMDGPU-SAME: (i16 zeroext [[TMP0:%.*]], i32 [[TMP1:%.*]]) #[[ATTR2]] {
; AMDGPU-NEXT:  entry:
; AMDGPU-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8, addrspace(5)
; AMDGPU-NEXT:    [[DOTADDR1_CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR1]] to ptr
; AMDGPU-NEXT:    [[DOTZERO_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
; AMDGPU-NEXT:    [[DOTZERO_ADDR_CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTZERO_ADDR]] to ptr
; AMDGPU-NEXT:    [[GLOBAL_ARGS:%.*]] = alloca ptr, align 8, addrspace(5)
; AMDGPU-NEXT:    [[GLOBAL_ARGS_CAST:%.*]] = addrspacecast ptr addrspace(5) [[GLOBAL_ARGS]] to ptr
; AMDGPU-NEXT:    call void @__kmpc_get_shared_variables(ptr [[GLOBAL_ARGS_CAST]])
; AMDGPU-NEXT:    call void @__omp_outlined__3(ptr [[DOTADDR1_CAST]], ptr [[DOTZERO_ADDR_CAST]]) #[[ATTR10]]
; AMDGPU-NEXT:    ret void
;
; NVPTX-LABEL: define {{[^@]+}}@__omp_outlined__3_wrapper
; NVPTX-SAME: (i16 zeroext [[TMP0:%.*]], i32 [[TMP1:%.*]]) #[[ATTR2]] {
; NVPTX-NEXT:  entry:
; NVPTX-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8, addrspace(5)
; NVPTX-NEXT:    [[DOTADDR1_CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR1]] to ptr
; NVPTX-NEXT:    [[DOTZERO_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
; NVPTX-NEXT:    [[DOTZERO_ADDR_CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTZERO_ADDR]] to ptr
; NVPTX-NEXT:    [[GLOBAL_ARGS:%.*]] = alloca ptr, align 8, addrspace(5)
; NVPTX-NEXT:    [[GLOBAL_ARGS_CAST:%.*]] = addrspacecast ptr addrspace(5) [[GLOBAL_ARGS]] to ptr
; NVPTX-NEXT:    call void @__kmpc_get_shared_variables(ptr [[GLOBAL_ARGS_CAST]])
; NVPTX-NEXT:    call void @__omp_outlined__3(ptr [[DOTADDR1_CAST]], ptr [[DOTZERO_ADDR_CAST]]) #[[ATTR10]]
; NVPTX-NEXT:    ret void
;
entry:
  %.addr1 = alloca ptr, align 8, addrspace(5)
  %.addr1.cast = addrspacecast ptr addrspace(5) %.addr1 to ptr
  %.zero.addr = alloca ptr, align 8, addrspace(5)
  %.zero.addr.cast = addrspacecast ptr addrspace(5) %.zero.addr to ptr
  %global_args = alloca ptr, align 8, addrspace(5)
  %global_args.cast = addrspacecast ptr addrspace(5) %global_args to ptr
  store i32 %1, ptr %.addr1.cast, align 4, !tbaa !12
  store i32 0, ptr %.zero.addr.cast, align 4
  call void @__kmpc_get_shared_variables(ptr %global_args.cast)
  call void @__omp_outlined__3(ptr %.addr1.cast, ptr %.zero.addr.cast) #8
  ret void
}

; Function Attrs: alwaysinline convergent norecurse nounwind
define weak ptx_kernel void @spmd_and_non_spmd_callee(i1 %c) #0 {
; AMDGPU-LABEL: define {{[^@]+}}@spmd_and_non_spmd_callee
; AMDGPU-SAME: (i1 [[C:%.*]]) #[[ATTR0]] {
; AMDGPU-NEXT:  entry:
; AMDGPU-NEXT:    [[WORKER_WORK_FN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
; AMDGPU-NEXT:    [[DOTZERO_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
; AMDGPU-NEXT:    [[DOTZERO_ADDR_CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTZERO_ADDR]] to ptr
; AMDGPU-NEXT:    [[DOTTHREADID_TEMP_:%.*]] = alloca ptr, align 8, addrspace(5)
; AMDGPU-NEXT:    [[DOTTHREADID_TEMP__CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTTHREADID_TEMP_]] to ptr
; AMDGPU-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_target_init(ptr @spmd_and_non_spmd_callee_kernel_environment, ptr null)
; AMDGPU-NEXT:    [[THREAD_IS_WORKER:%.*]] = icmp ne i32 [[TMP0]], -1
; AMDGPU-NEXT:    br i1 [[THREAD_IS_WORKER]], label [[IS_WORKER_CHECK:%.*]], label [[THREAD_USER_CODE_CHECK:%.*]]
; AMDGPU:       is_worker_check:
; AMDGPU-NEXT:    [[BLOCK_HW_SIZE:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
; AMDGPU-NEXT:    [[WARP_SIZE:%.*]] = call i32 @__kmpc_get_warp_size()
; AMDGPU-NEXT:    [[BLOCK_SIZE:%.*]] = sub i32 [[BLOCK_HW_SIZE]], [[WARP_SIZE]]
; AMDGPU-NEXT:    [[THREAD_IS_MAIN_OR_WORKER:%.*]] = icmp slt i32 [[TMP0]], [[BLOCK_SIZE]]
; AMDGPU-NEXT:    br i1 [[THREAD_IS_MAIN_OR_WORKER]], label [[WORKER_STATE_MACHINE_BEGIN:%.*]], label [[WORKER_STATE_MACHINE_FINISHED:%.*]]
; AMDGPU:       worker_state_machine.begin:
; AMDGPU-NEXT:    call void @__kmpc_barrier_simple_generic(ptr @[[GLOB1]], i32 [[TMP0]])
; AMDGPU-NEXT:    [[WORKER_WORK_FN_ADDR_GENERIC:%.*]] = addrspacecast ptr addrspace(5) [[WORKER_WORK_FN_ADDR]] to ptr
; AMDGPU-NEXT:    [[WORKER_IS_ACTIVE:%.*]] = call i1 @__kmpc_kernel_parallel(ptr [[WORKER_WORK_FN_ADDR_GENERIC]])
; AMDGPU-NEXT:    [[WORKER_WORK_FN:%.*]] = load ptr, ptr [[WORKER_WORK_FN_ADDR_GENERIC]], align 8
; AMDGPU-NEXT:    [[WORKER_IS_DONE:%.*]] = icmp eq ptr [[WORKER_WORK_FN]], null
; AMDGPU-NEXT:    br i1 [[WORKER_IS_DONE]], label [[WORKER_STATE_MACHINE_FINISHED]], label [[WORKER_STATE_MACHINE_IS_ACTIVE_CHECK:%.*]]
; AMDGPU:       worker_state_machine.finished:
; AMDGPU-NEXT:    ret void
; AMDGPU:       worker_state_machine.is_active.check:
; AMDGPU-NEXT:    br i1 [[WORKER_IS_ACTIVE]], label [[WORKER_STATE_MACHINE_PARALLEL_REGION_FALLBACK_EXECUTE:%.*]], label [[WORKER_STATE_MACHINE_DONE_BARRIER:%.*]]
; AMDGPU:       worker_state_machine.parallel_region.fallback.execute:
; AMDGPU-NEXT:    call void [[WORKER_WORK_FN]](i16 0, i32 [[TMP0]])
; AMDGPU-NEXT:    br label [[WORKER_STATE_MACHINE_PARALLEL_REGION_END:%.*]]
; AMDGPU:       worker_state_machine.parallel_region.end:
; AMDGPU-NEXT:    call void @__kmpc_kernel_end_parallel()
; AMDGPU-NEXT:    br label [[WORKER_STATE_MACHINE_DONE_BARRIER]]
; AMDGPU:       worker_state_machine.done.barrier:
; AMDGPU-NEXT:    call void @__kmpc_barrier_simple_generic(ptr @[[GLOB1]], i32 [[TMP0]])
; AMDGPU-NEXT:    br label [[WORKER_STATE_MACHINE_BEGIN]]
; AMDGPU:       thread.user_code.check:
; AMDGPU-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP0]], -1
; AMDGPU-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[COMMON_RET:%.*]]
; AMDGPU:       common.ret:
; AMDGPU-NEXT:    ret void
; AMDGPU:       user_code.entry:
; AMDGPU-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]]) #[[ATTR10]]
; AMDGPU-NEXT:    store i32 0, ptr addrspace(5) [[DOTZERO_ADDR]], align 4
; AMDGPU-NEXT:    store i32 [[TMP1]], ptr addrspace(5) [[DOTTHREADID_TEMP_]], align 4, !tbaa [[TBAA12]]
; AMDGPU-NEXT:    [[FP:%.*]] = select i1 [[C]], ptr @__omp_outlined_spmd_amenable3, ptr @__omp_outlined_not_spmd_amenable
; AMDGPU-NEXT:    [[TMP2:%.*]] = icmp eq ptr [[FP]], @__omp_outlined_not_spmd_amenable
; AMDGPU-NEXT:    br i1 [[TMP2]], label [[TMP3:%.*]], label [[TMP4:%.*]]
; AMDGPU:       3:
; AMDGPU-NEXT:    call void @__omp_outlined_not_spmd_amenable(ptr [[DOTTHREADID_TEMP__CAST]], ptr [[DOTZERO_ADDR_CAST]]) #[[ATTR10]]
; AMDGPU-NEXT:    br label [[TMP7:%.*]]
; AMDGPU:       4:
; AMDGPU-NEXT:    br i1 true, label [[TMP5:%.*]], label [[TMP6:%.*]]
; AMDGPU:       5:
; AMDGPU-NEXT:    call void @__omp_outlined_spmd_amenable3(ptr [[DOTTHREADID_TEMP__CAST]], ptr [[DOTZERO_ADDR_CAST]]) #[[ATTR10]]
; AMDGPU-NEXT:    br label [[TMP7]]
; AMDGPU:       6:
; AMDGPU-NEXT:    unreachable
; AMDGPU:       7:
; AMDGPU-NEXT:    call void @__kmpc_target_deinit()
; AMDGPU-NEXT:    br label [[COMMON_RET]]
;
; NVPTX-LABEL: define {{[^@]+}}@spmd_and_non_spmd_callee
; NVPTX-SAME: (i1 [[C:%.*]]) #[[ATTR0]] {
; NVPTX-NEXT:  entry:
; NVPTX-NEXT:    [[WORKER_WORK_FN_ADDR:%.*]] = alloca ptr, align 8
; NVPTX-NEXT:    [[DOTZERO_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
; NVPTX-NEXT:    [[DOTZERO_ADDR_CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTZERO_ADDR]] to ptr
; NVPTX-NEXT:    [[DOTTHREADID_TEMP_:%.*]] = alloca ptr, align 8, addrspace(5)
; NVPTX-NEXT:    [[DOTTHREADID_TEMP__CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTTHREADID_TEMP_]] to ptr
; NVPTX-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_target_init(ptr @spmd_and_non_spmd_callee_kernel_environment, ptr null)
; NVPTX-NEXT:    [[THREAD_IS_WORKER:%.*]] = icmp ne i32 [[TMP0]], -1
; NVPTX-NEXT:    br i1 [[THREAD_IS_WORKER]], label [[IS_WORKER_CHECK:%.*]], label [[THREAD_USER_CODE_CHECK:%.*]]
; NVPTX:       is_worker_check:
; NVPTX-NEXT:    [[BLOCK_HW_SIZE:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
; NVPTX-NEXT:    [[WARP_SIZE:%.*]] = call i32 @__kmpc_get_warp_size()
; NVPTX-NEXT:    [[BLOCK_SIZE:%.*]] = sub i32 [[BLOCK_HW_SIZE]], [[WARP_SIZE]]
; NVPTX-NEXT:    [[THREAD_IS_MAIN_OR_WORKER:%.*]] = icmp slt i32 [[TMP0]], [[BLOCK_SIZE]]
; NVPTX-NEXT:    br i1 [[THREAD_IS_MAIN_OR_WORKER]], label [[WORKER_STATE_MACHINE_BEGIN:%.*]], label [[WORKER_STATE_MACHINE_FINISHED:%.*]]
; NVPTX:       worker_state_machine.begin:
; NVPTX-NEXT:    call void @__kmpc_barrier_simple_generic(ptr @[[GLOB1]], i32 [[TMP0]])
; NVPTX-NEXT:    [[WORKER_IS_ACTIVE:%.*]] = call i1 @__kmpc_kernel_parallel(ptr [[WORKER_WORK_FN_ADDR]])
; NVPTX-NEXT:    [[WORKER_WORK_FN:%.*]] = load ptr, ptr [[WORKER_WORK_FN_ADDR]], align 8
; NVPTX-NEXT:    [[WORKER_IS_DONE:%.*]] = icmp eq ptr [[WORKER_WORK_FN]], null
; NVPTX-NEXT:    br i1 [[WORKER_IS_DONE]], label [[WORKER_STATE_MACHINE_FINISHED]], label [[WORKER_STATE_MACHINE_IS_ACTIVE_CHECK:%.*]]
; NVPTX:       worker_state_machine.finished:
; NVPTX-NEXT:    ret void
; NVPTX:       worker_state_machine.is_active.check:
; NVPTX-NEXT:    br i1 [[WORKER_IS_ACTIVE]], label [[WORKER_STATE_MACHINE_PARALLEL_REGION_FALLBACK_EXECUTE:%.*]], label [[WORKER_STATE_MACHINE_DONE_BARRIER:%.*]]
; NVPTX:       worker_state_machine.parallel_region.fallback.execute:
; NVPTX-NEXT:    call void [[WORKER_WORK_FN]](i16 0, i32 [[TMP0]])
; NVPTX-NEXT:    br label [[WORKER_STATE_MACHINE_PARALLEL_REGION_END:%.*]]
; NVPTX:       worker_state_machine.parallel_region.end:
; NVPTX-NEXT:    call void @__kmpc_kernel_end_parallel()
; NVPTX-NEXT:    br label [[WORKER_STATE_MACHINE_DONE_BARRIER]]
; NVPTX:       worker_state_machine.done.barrier:
; NVPTX-NEXT:    call void @__kmpc_barrier_simple_generic(ptr @[[GLOB1]], i32 [[TMP0]])
; NVPTX-NEXT:    br label [[WORKER_STATE_MACHINE_BEGIN]]
; NVPTX:       thread.user_code.check:
; NVPTX-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP0]], -1
; NVPTX-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[COMMON_RET:%.*]]
; NVPTX:       common.ret:
; NVPTX-NEXT:    ret void
; NVPTX:       user_code.entry:
; NVPTX-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]]) #[[ATTR10]]
; NVPTX-NEXT:    store i32 0, ptr addrspace(5) [[DOTZERO_ADDR]], align 4
; NVPTX-NEXT:    store i32 [[TMP1]], ptr addrspace(5) [[DOTTHREADID_TEMP_]], align 4, !tbaa [[TBAA12]]
; NVPTX-NEXT:    [[FP:%.*]] = select i1 [[C]], ptr @__omp_outlined_spmd_amenable3, ptr @__omp_outlined_not_spmd_amenable
; NVPTX-NEXT:    [[TMP2:%.*]] = icmp eq ptr [[FP]], @__omp_outlined_not_spmd_amenable
; NVPTX-NEXT:    br i1 [[TMP2]], label [[TMP3:%.*]], label [[TMP4:%.*]]
; NVPTX:       3:
; NVPTX-NEXT:    call void @__omp_outlined_not_spmd_amenable(ptr [[DOTTHREADID_TEMP__CAST]], ptr [[DOTZERO_ADDR_CAST]]) #[[ATTR10]]
; NVPTX-NEXT:    br label [[TMP7:%.*]]
; NVPTX:       4:
; NVPTX-NEXT:    br i1 true, label [[TMP5:%.*]], label [[TMP6:%.*]]
; NVPTX:       5:
; NVPTX-NEXT:    call void @__omp_outlined_spmd_amenable3(ptr [[DOTTHREADID_TEMP__CAST]], ptr [[DOTZERO_ADDR_CAST]]) #[[ATTR10]]
; NVPTX-NEXT:    br label [[TMP7]]
; NVPTX:       6:
; NVPTX-NEXT:    unreachable
; NVPTX:       7:
; NVPTX-NEXT:    call void @__kmpc_target_deinit()
; NVPTX-NEXT:    br label [[COMMON_RET]]
;
entry:
  %.zero.addr = alloca ptr, align 8, addrspace(5)
  %.zero.addr.cast = addrspacecast ptr addrspace(5) %.zero.addr to ptr
  %.threadid_temp. = alloca ptr, align 8, addrspace(5)
  %.threadid_temp..cast = addrspacecast ptr addrspace(5) %.threadid_temp. to ptr
  %0 = call i32 @__kmpc_target_init(ptr @spmd_and_non_spmd_callee_kernel_environment, ptr null)
  %exec_user_code = icmp eq i32 %0, -1
  br i1 %exec_user_code, label %user_code.entry, label %common.ret

common.ret:                                       ; preds = %user_code.entry, %entry
  ret void

user_code.entry:                                  ; preds = %entry
  %1 = call i32 @__kmpc_global_thread_num(ptr @1)
  store i32 0, ptr %.zero.addr.cast, align 4
  store i32 %1, ptr %.threadid_temp..cast, align 4, !tbaa !12
  %fp = select i1 %c, ptr @__omp_outlined_spmd_amenable3, ptr @__omp_outlined_not_spmd_amenable
  call void %fp(ptr %.threadid_temp..cast, ptr %.zero.addr.cast) #8
  call void @__kmpc_target_deinit()
  br label %common.ret
}

define internal void @__omp_outlined_spmd_amenable3(ptr noalias %.global_tid., ptr noalias %.bound_tid.) {
; AMDGPU-LABEL: define {{[^@]+}}@__omp_outlined_spmd_amenable3
; AMDGPU-SAME: (ptr noalias [[DOTGLOBAL_TID_:%.*]], ptr noalias [[DOTBOUND_TID_:%.*]]) {
; AMDGPU-NEXT:  entry:
; AMDGPU-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca ptr, align 8, addrspace(5)
; AMDGPU-NEXT:    [[CAPTURED_VARS_ADDRS_CAST:%.*]] = addrspacecast ptr addrspace(5) [[CAPTURED_VARS_ADDRS]] to ptr
; AMDGPU-NEXT:    [[X:%.*]] = call align 4 ptr @__kmpc_alloc_shared(i64 4) #[[ATTR10]]
; AMDGPU-NEXT:    br label [[FOR_COND:%.*]]
; AMDGPU:       for.cond:
; AMDGPU-NEXT:    [[I_0:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[INC:%.*]], [[FOR_BODY:%.*]] ]
; AMDGPU-NEXT:    [[CMP:%.*]] = icmp slt i32 [[I_0]], 100
; AMDGPU-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_COND_CLEANUP:%.*]]
; AMDGPU:       for.cond.cleanup:
; AMDGPU-NEXT:    call void @spmd_amenable() #[[ATTR6]]
; AMDGPU-NEXT:    call void @__kmpc_free_shared(ptr [[X]], i64 4) #[[ATTR10]]
; AMDGPU-NEXT:    ret void
; AMDGPU:       for.body:
; AMDGPU-NEXT:    store ptr [[X]], ptr addrspace(5) [[CAPTURED_VARS_ADDRS]], align 8, !tbaa [[TBAA20:![0-9]+]]
; AMDGPU-NEXT:    [[TMP0:%.*]] = load i32, ptr [[DOTGLOBAL_TID_]], align 4, !tbaa [[TBAA12]]
; AMDGPU-NEXT:    call void @__kmpc_parallel_51(ptr @[[GLOB1]], i32 [[TMP0]], i32 1, i32 -1, i32 -1, ptr @__omp_outlined__5, ptr @__omp_outlined__5_wrapper, ptr [[CAPTURED_VARS_ADDRS_CAST]], i64 1)
; AMDGPU-NEXT:    [[INC]] = add nsw i32 [[I_0]], 1
; AMDGPU-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP22:![0-9]+]]
;
; NVPTX-LABEL: define {{[^@]+}}@__omp_outlined_spmd_amenable3
; NVPTX-SAME: (ptr noalias [[DOTGLOBAL_TID_:%.*]], ptr noalias [[DOTBOUND_TID_:%.*]]) {
; NVPTX-NEXT:  entry:
; NVPTX-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca ptr, align 8, addrspace(5)
; NVPTX-NEXT:    [[CAPTURED_VARS_ADDRS_CAST:%.*]] = addrspacecast ptr addrspace(5) [[CAPTURED_VARS_ADDRS]] to ptr
; NVPTX-NEXT:    [[X:%.*]] = call align 4 ptr @__kmpc_alloc_shared(i64 4) #[[ATTR10]]
; NVPTX-NEXT:    br label [[FOR_COND:%.*]]
; NVPTX:       for.cond:
; NVPTX-NEXT:    [[I_0:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[INC:%.*]], [[FOR_BODY:%.*]] ]
; NVPTX-NEXT:    [[CMP:%.*]] = icmp slt i32 [[I_0]], 100
; NVPTX-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_COND_CLEANUP:%.*]]
; NVPTX:       for.cond.cleanup:
; NVPTX-NEXT:    call void @spmd_amenable() #[[ATTR6]]
; NVPTX-NEXT:    call void @__kmpc_free_shared(ptr [[X]], i64 4) #[[ATTR10]]
; NVPTX-NEXT:    ret void
; NVPTX:       for.body:
; NVPTX-NEXT:    store ptr [[X]], ptr addrspace(5) [[CAPTURED_VARS_ADDRS]], align 8, !tbaa [[TBAA20:![0-9]+]]
; NVPTX-NEXT:    [[TMP0:%.*]] = load i32, ptr [[DOTGLOBAL_TID_]], align 4, !tbaa [[TBAA12]]
; NVPTX-NEXT:    call void @__kmpc_parallel_51(ptr @[[GLOB1]], i32 [[TMP0]], i32 1, i32 -1, i32 -1, ptr @__omp_outlined__5, ptr @__omp_outlined__5_wrapper, ptr [[CAPTURED_VARS_ADDRS_CAST]], i64 1)
; NVPTX-NEXT:    [[INC]] = add nsw i32 [[I_0]], 1
; NVPTX-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP22:![0-9]+]]
;
entry:
  %captured_vars_addrs = alloca ptr, align 8, addrspace(5)
  %captured_vars_addrs.cast = addrspacecast ptr addrspace(5) %captured_vars_addrs to ptr
  %x = call align 4 ptr @__kmpc_alloc_shared(i64 4)
  br label %for.cond

for.cond:                                         ; preds = %for.body, %entry
  %i.0 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %cmp = icmp slt i32 %i.0, 100
  br i1 %cmp, label %for.body, label %for.cond.cleanup

for.cond.cleanup:                                 ; preds = %for.cond
  call void @spmd_amenable() #4
  call void @__kmpc_free_shared(ptr %x, i64 4)
  ret void

for.body:                                         ; preds = %for.cond
  store ptr %x, ptr %captured_vars_addrs.cast, align 8, !tbaa !20
  %0 = load i32, ptr %.global_tid., align 4, !tbaa !12
  call void @__kmpc_parallel_51(ptr @1, i32 %0, i32 1, i32 -1, i32 -1, ptr @__omp_outlined__5, ptr @__omp_outlined__5_wrapper, ptr %captured_vars_addrs.cast, i64 1)
  %inc = add nsw i32 %i.0, 1
  br label %for.cond, !llvm.loop !22
}

define internal void @__omp_outlined__5(ptr noalias %.global_tid., ptr noalias %.bound_tid., ptr nonnull align 4 dereferenceable(4) %x) {
; AMDGPU-LABEL: define {{[^@]+}}@__omp_outlined__5
; AMDGPU-SAME: (ptr noalias [[DOTGLOBAL_TID_:%.*]], ptr noalias [[DOTBOUND_TID_:%.*]], ptr nonnull align 4 dereferenceable(4) [[X:%.*]]) {
; AMDGPU-NEXT:  entry:
; AMDGPU-NEXT:    [[TMP0:%.*]] = load i32, ptr [[X]], align 4, !tbaa [[TBAA12]]
; AMDGPU-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP0]], 1
; AMDGPU-NEXT:    store i32 [[INC]], ptr [[X]], align 4, !tbaa [[TBAA12]]
; AMDGPU-NEXT:    call void @unknown() #[[ATTR7]]
; AMDGPU-NEXT:    ret void
;
; NVPTX-LABEL: define {{[^@]+}}@__omp_outlined__5
; NVPTX-SAME: (ptr noalias [[DOTGLOBAL_TID_:%.*]], ptr noalias [[DOTBOUND_TID_:%.*]], ptr nonnull align 4 dereferenceable(4) [[X:%.*]]) {
; NVPTX-NEXT:  entry:
; NVPTX-NEXT:    [[TMP0:%.*]] = load i32, ptr [[X]], align 4, !tbaa [[TBAA12]]
; NVPTX-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP0]], 1
; NVPTX-NEXT:    store i32 [[INC]], ptr [[X]], align 4, !tbaa [[TBAA12]]
; NVPTX-NEXT:    call void @unknown() #[[ATTR7]]
; NVPTX-NEXT:    ret void
;
entry:
  %0 = load i32, ptr %x, align 4, !tbaa !12
  %inc = add nsw i32 %0, 1
  store i32 %inc, ptr %x, align 4, !tbaa !12
  call void @unknown() #5
  ret void
}

; Function Attrs: convergent norecurse nounwind
define internal void @__omp_outlined__5_wrapper(i16 zeroext %0, i32 %1) #1 {
; AMDGPU-LABEL: define {{[^@]+}}@__omp_outlined__5_wrapper
; AMDGPU-SAME: (i16 zeroext [[TMP0:%.*]], i32 [[TMP1:%.*]]) #[[ATTR2]] {
; AMDGPU-NEXT:  entry:
; AMDGPU-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8, addrspace(5)
; AMDGPU-NEXT:    [[DOTADDR1_CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR1]] to ptr
; AMDGPU-NEXT:    [[DOTZERO_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
; AMDGPU-NEXT:    [[DOTZERO_ADDR_CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTZERO_ADDR]] to ptr
; AMDGPU-NEXT:    [[GLOBAL_ARGS:%.*]] = alloca ptr, align 8, addrspace(5)
; AMDGPU-NEXT:    [[GLOBAL_ARGS_CAST:%.*]] = addrspacecast ptr addrspace(5) [[GLOBAL_ARGS]] to ptr
; AMDGPU-NEXT:    call void @__kmpc_get_shared_variables(ptr [[GLOBAL_ARGS_CAST]])
; AMDGPU-NEXT:    [[TMP2:%.*]] = load ptr, ptr addrspace(5) [[GLOBAL_ARGS]], align 8
; AMDGPU-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP2]], align 8, !tbaa [[TBAA20]]
; AMDGPU-NEXT:    call void @__omp_outlined__5(ptr [[DOTADDR1_CAST]], ptr [[DOTZERO_ADDR_CAST]], ptr [[TMP3]]) #[[ATTR10]]
; AMDGPU-NEXT:    ret void
;
; NVPTX-LABEL: define {{[^@]+}}@__omp_outlined__5_wrapper
; NVPTX-SAME: (i16 zeroext [[TMP0:%.*]], i32 [[TMP1:%.*]]) #[[ATTR2]] {
; NVPTX-NEXT:  entry:
; NVPTX-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8, addrspace(5)
; NVPTX-NEXT:    [[DOTADDR1_CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR1]] to ptr
; NVPTX-NEXT:    [[DOTZERO_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
; NVPTX-NEXT:    [[DOTZERO_ADDR_CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTZERO_ADDR]] to ptr
; NVPTX-NEXT:    [[GLOBAL_ARGS:%.*]] = alloca ptr, align 8, addrspace(5)
; NVPTX-NEXT:    [[GLOBAL_ARGS_CAST:%.*]] = addrspacecast ptr addrspace(5) [[GLOBAL_ARGS]] to ptr
; NVPTX-NEXT:    call void @__kmpc_get_shared_variables(ptr [[GLOBAL_ARGS_CAST]])
; NVPTX-NEXT:    [[TMP2:%.*]] = load ptr, ptr addrspace(5) [[GLOBAL_ARGS]], align 8
; NVPTX-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP2]], align 8, !tbaa [[TBAA20]]
; NVPTX-NEXT:    call void @__omp_outlined__5(ptr [[DOTADDR1_CAST]], ptr [[DOTZERO_ADDR_CAST]], ptr [[TMP3]]) #[[ATTR10]]
; NVPTX-NEXT:    ret void
;
entry:
  %.addr1 = alloca ptr, align 8, addrspace(5)
  %.addr1.cast = addrspacecast ptr addrspace(5) %.addr1 to ptr
  %.zero.addr = alloca ptr, align 8, addrspace(5)
  %.zero.addr.cast = addrspacecast ptr addrspace(5) %.zero.addr to ptr
  %global_args = alloca ptr, align 8, addrspace(5)
  %global_args.cast = addrspacecast ptr addrspace(5) %global_args to ptr
  store i32 %1, ptr %.addr1.cast, align 4, !tbaa !12
  store i32 0, ptr %.zero.addr.cast, align 4
  call void @__kmpc_get_shared_variables(ptr %global_args.cast)
  %2 = load ptr, ptr %global_args.cast, align 8
  %3 = load ptr, ptr %2, align 8, !tbaa !20
  call void @__omp_outlined__5(ptr %.addr1.cast, ptr %.zero.addr.cast, ptr %3) #8
  ret void
}

; Function Attrs: alwaysinline convergent norecurse nounwind
define weak ptx_kernel void @spmd_callees_metadata(ptr %fp) #0 {
; AMDGPU-LABEL: define {{[^@]+}}@spmd_callees_metadata
; AMDGPU-SAME: (ptr [[FP:%.*]]) #[[ATTR0]] {
; AMDGPU-NEXT:  entry:
; AMDGPU-NEXT:    [[DOTZERO_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
; AMDGPU-NEXT:    [[DOTZERO_ADDR_CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTZERO_ADDR]] to ptr
; AMDGPU-NEXT:    [[DOTTHREADID_TEMP_:%.*]] = alloca ptr, align 8, addrspace(5)
; AMDGPU-NEXT:    [[DOTTHREADID_TEMP__CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTTHREADID_TEMP_]] to ptr
; AMDGPU-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_target_init(ptr @spmd_callees_metadata_kernel_environment, ptr null)
; AMDGPU-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP0]], -1
; AMDGPU-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[COMMON_RET:%.*]]
; AMDGPU:       common.ret:
; AMDGPU-NEXT:    ret void
; AMDGPU:       user_code.entry:
; AMDGPU-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]]) #[[ATTR10]]
; AMDGPU-NEXT:    store i32 0, ptr addrspace(5) [[DOTZERO_ADDR]], align 4
; AMDGPU-NEXT:    store i32 [[TMP1]], ptr addrspace(5) [[DOTTHREADID_TEMP_]], align 4, !tbaa [[TBAA12]]
; AMDGPU-NEXT:    call void @__omp_outlined_spmd_amenable_external(ptr [[DOTTHREADID_TEMP__CAST]], ptr [[DOTZERO_ADDR_CAST]])
; AMDGPU-NEXT:    call void @__kmpc_target_deinit()
; AMDGPU-NEXT:    br label [[COMMON_RET]]
;
; NVPTX-LABEL: define {{[^@]+}}@spmd_callees_metadata
; NVPTX-SAME: (ptr [[FP:%.*]]) #[[ATTR0]] {
; NVPTX-NEXT:  entry:
; NVPTX-NEXT:    [[DOTZERO_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
; NVPTX-NEXT:    [[DOTZERO_ADDR_CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTZERO_ADDR]] to ptr
; NVPTX-NEXT:    [[DOTTHREADID_TEMP_:%.*]] = alloca ptr, align 8, addrspace(5)
; NVPTX-NEXT:    [[DOTTHREADID_TEMP__CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTTHREADID_TEMP_]] to ptr
; NVPTX-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_target_init(ptr @spmd_callees_metadata_kernel_environment, ptr null)
; NVPTX-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP0]], -1
; NVPTX-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[COMMON_RET:%.*]]
; NVPTX:       common.ret:
; NVPTX-NEXT:    ret void
; NVPTX:       user_code.entry:
; NVPTX-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]]) #[[ATTR10]]
; NVPTX-NEXT:    store i32 0, ptr addrspace(5) [[DOTZERO_ADDR]], align 4
; NVPTX-NEXT:    store i32 [[TMP1]], ptr addrspace(5) [[DOTTHREADID_TEMP_]], align 4, !tbaa [[TBAA12]]
; NVPTX-NEXT:    call void @__omp_outlined_spmd_amenable_external(ptr [[DOTTHREADID_TEMP__CAST]], ptr [[DOTZERO_ADDR_CAST]])
; NVPTX-NEXT:    call void @__kmpc_target_deinit()
; NVPTX-NEXT:    br label [[COMMON_RET]]
;
entry:
  %.zero.addr = alloca ptr, align 8, addrspace(5)
  %.zero.addr.cast = addrspacecast ptr addrspace(5) %.zero.addr to ptr
  %.threadid_temp. = alloca ptr, align 8, addrspace(5)
  %.threadid_temp..cast = addrspacecast ptr addrspace(5) %.threadid_temp. to ptr
  %0 = call i32 @__kmpc_target_init(ptr @spmd_callees_metadata_kernel_environment, ptr null)
  %exec_user_code = icmp eq i32 %0, -1
  br i1 %exec_user_code, label %user_code.entry, label %common.ret

common.ret:                                       ; preds = %user_code.entry, %entry
  ret void

user_code.entry:                                  ; preds = %entry
  %1 = call i32 @__kmpc_global_thread_num(ptr @1)
  store i32 0, ptr %.zero.addr.cast, align 4
  store i32 %1, ptr %.threadid_temp..cast, align 4, !tbaa !12
  call void %fp(ptr %.threadid_temp..cast, ptr %.zero.addr.cast), !callees !23
  call void @__kmpc_target_deinit()
  br label %common.ret
}

; Function Attrs: alwaysinline convergent norecurse nounwind
define weak ptx_kernel void @spmd_and_non_spmd_callees_metadata(ptr %fp) #0 {
; AMDGPU-LABEL: define {{[^@]+}}@spmd_and_non_spmd_callees_metadata
; AMDGPU-SAME: (ptr [[FP:%.*]]) #[[ATTR0]] {
; AMDGPU-NEXT:  entry:
; AMDGPU-NEXT:    [[WORKER_WORK_FN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
; AMDGPU-NEXT:    [[DOTZERO_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
; AMDGPU-NEXT:    [[DOTZERO_ADDR_CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTZERO_ADDR]] to ptr
; AMDGPU-NEXT:    [[DOTTHREADID_TEMP_:%.*]] = alloca ptr, align 8, addrspace(5)
; AMDGPU-NEXT:    [[DOTTHREADID_TEMP__CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTTHREADID_TEMP_]] to ptr
; AMDGPU-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_target_init(ptr @spmd_and_non_spmd_callees_metadata_kernel_environment, ptr null)
; AMDGPU-NEXT:    [[THREAD_IS_WORKER:%.*]] = icmp ne i32 [[TMP0]], -1
; AMDGPU-NEXT:    br i1 [[THREAD_IS_WORKER]], label [[IS_WORKER_CHECK:%.*]], label [[THREAD_USER_CODE_CHECK:%.*]]
; AMDGPU:       is_worker_check:
; AMDGPU-NEXT:    [[BLOCK_HW_SIZE:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
; AMDGPU-NEXT:    [[WARP_SIZE:%.*]] = call i32 @__kmpc_get_warp_size()
; AMDGPU-NEXT:    [[BLOCK_SIZE:%.*]] = sub i32 [[BLOCK_HW_SIZE]], [[WARP_SIZE]]
; AMDGPU-NEXT:    [[THREAD_IS_MAIN_OR_WORKER:%.*]] = icmp slt i32 [[TMP0]], [[BLOCK_SIZE]]
; AMDGPU-NEXT:    br i1 [[THREAD_IS_MAIN_OR_WORKER]], label [[WORKER_STATE_MACHINE_BEGIN:%.*]], label [[WORKER_STATE_MACHINE_FINISHED:%.*]]
; AMDGPU:       worker_state_machine.begin:
; AMDGPU-NEXT:    call void @__kmpc_barrier_simple_generic(ptr @[[GLOB1]], i32 [[TMP0]])
; AMDGPU-NEXT:    [[WORKER_WORK_FN_ADDR_GENERIC:%.*]] = addrspacecast ptr addrspace(5) [[WORKER_WORK_FN_ADDR]] to ptr
; AMDGPU-NEXT:    [[WORKER_IS_ACTIVE:%.*]] = call i1 @__kmpc_kernel_parallel(ptr [[WORKER_WORK_FN_ADDR_GENERIC]])
; AMDGPU-NEXT:    [[WORKER_WORK_FN:%.*]] = load ptr, ptr [[WORKER_WORK_FN_ADDR_GENERIC]], align 8
; AMDGPU-NEXT:    [[WORKER_IS_DONE:%.*]] = icmp eq ptr [[WORKER_WORK_FN]], null
; AMDGPU-NEXT:    br i1 [[WORKER_IS_DONE]], label [[WORKER_STATE_MACHINE_FINISHED]], label [[WORKER_STATE_MACHINE_IS_ACTIVE_CHECK:%.*]]
; AMDGPU:       worker_state_machine.finished:
; AMDGPU-NEXT:    ret void
; AMDGPU:       worker_state_machine.is_active.check:
; AMDGPU-NEXT:    br i1 [[WORKER_IS_ACTIVE]], label [[WORKER_STATE_MACHINE_PARALLEL_REGION_FALLBACK_EXECUTE:%.*]], label [[WORKER_STATE_MACHINE_DONE_BARRIER:%.*]]
; AMDGPU:       worker_state_machine.parallel_region.fallback.execute:
; AMDGPU-NEXT:    call void [[WORKER_WORK_FN]](i16 0, i32 [[TMP0]])
; AMDGPU-NEXT:    br label [[WORKER_STATE_MACHINE_PARALLEL_REGION_END:%.*]]
; AMDGPU:       worker_state_machine.parallel_region.end:
; AMDGPU-NEXT:    call void @__kmpc_kernel_end_parallel()
; AMDGPU-NEXT:    br label [[WORKER_STATE_MACHINE_DONE_BARRIER]]
; AMDGPU:       worker_state_machine.done.barrier:
; AMDGPU-NEXT:    call void @__kmpc_barrier_simple_generic(ptr @[[GLOB1]], i32 [[TMP0]])
; AMDGPU-NEXT:    br label [[WORKER_STATE_MACHINE_BEGIN]]
; AMDGPU:       thread.user_code.check:
; AMDGPU-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP0]], -1
; AMDGPU-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[COMMON_RET:%.*]]
; AMDGPU:       common.ret:
; AMDGPU-NEXT:    ret void
; AMDGPU:       user_code.entry:
; AMDGPU-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]]) #[[ATTR10]]
; AMDGPU-NEXT:    store i32 0, ptr addrspace(5) [[DOTZERO_ADDR]], align 4
; AMDGPU-NEXT:    store i32 [[TMP1]], ptr addrspace(5) [[DOTTHREADID_TEMP_]], align 4, !tbaa [[TBAA12]]
; AMDGPU-NEXT:    [[TMP2:%.*]] = icmp eq ptr [[FP]], @__omp_outlined_spmd_amenable_external
; AMDGPU-NEXT:    br i1 [[TMP2]], label [[TMP3:%.*]], label [[TMP4:%.*]]
; AMDGPU:       3:
; AMDGPU-NEXT:    call void @__omp_outlined_spmd_amenable_external(ptr [[DOTTHREADID_TEMP__CAST]], ptr [[DOTZERO_ADDR_CAST]])
; AMDGPU-NEXT:    br label [[TMP7:%.*]]
; AMDGPU:       4:
; AMDGPU-NEXT:    br i1 true, label [[TMP5:%.*]], label [[TMP6:%.*]]
; AMDGPU:       5:
; AMDGPU-NEXT:    call void @__omp_outlined_not_spmd_amenable_external(ptr [[DOTTHREADID_TEMP__CAST]], ptr [[DOTZERO_ADDR_CAST]])
; AMDGPU-NEXT:    br label [[TMP7]]
; AMDGPU:       6:
; AMDGPU-NEXT:    unreachable
; AMDGPU:       7:
; AMDGPU-NEXT:    call void @__kmpc_target_deinit()
; AMDGPU-NEXT:    br label [[COMMON_RET]]
;
; NVPTX-LABEL: define {{[^@]+}}@spmd_and_non_spmd_callees_metadata
; NVPTX-SAME: (ptr [[FP:%.*]]) #[[ATTR0]] {
; NVPTX-NEXT:  entry:
; NVPTX-NEXT:    [[WORKER_WORK_FN_ADDR:%.*]] = alloca ptr, align 8
; NVPTX-NEXT:    [[DOTZERO_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
; NVPTX-NEXT:    [[DOTZERO_ADDR_CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTZERO_ADDR]] to ptr
; NVPTX-NEXT:    [[DOTTHREADID_TEMP_:%.*]] = alloca ptr, align 8, addrspace(5)
; NVPTX-NEXT:    [[DOTTHREADID_TEMP__CAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTTHREADID_TEMP_]] to ptr
; NVPTX-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_target_init(ptr @spmd_and_non_spmd_callees_metadata_kernel_environment, ptr null)
; NVPTX-NEXT:    [[THREAD_IS_WORKER:%.*]] = icmp ne i32 [[TMP0]], -1
; NVPTX-NEXT:    br i1 [[THREAD_IS_WORKER]], label [[IS_WORKER_CHECK:%.*]], label [[THREAD_USER_CODE_CHECK:%.*]]
; NVPTX:       is_worker_check:
; NVPTX-NEXT:    [[BLOCK_HW_SIZE:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
; NVPTX-NEXT:    [[WARP_SIZE:%.*]] = call i32 @__kmpc_get_warp_size()
; NVPTX-NEXT:    [[BLOCK_SIZE:%.*]] = sub i32 [[BLOCK_HW_SIZE]], [[WARP_SIZE]]
; NVPTX-NEXT:    [[THREAD_IS_MAIN_OR_WORKER:%.*]] = icmp slt i32 [[TMP0]], [[BLOCK_SIZE]]
; NVPTX-NEXT:    br i1 [[THREAD_IS_MAIN_OR_WORKER]], label [[WORKER_STATE_MACHINE_BEGIN:%.*]], label [[WORKER_STATE_MACHINE_FINISHED:%.*]]
; NVPTX:       worker_state_machine.begin:
; NVPTX-NEXT:    call void @__kmpc_barrier_simple_generic(ptr @[[GLOB1]], i32 [[TMP0]])
; NVPTX-NEXT:    [[WORKER_IS_ACTIVE:%.*]] = call i1 @__kmpc_kernel_parallel(ptr [[WORKER_WORK_FN_ADDR]])
; NVPTX-NEXT:    [[WORKER_WORK_FN:%.*]] = load ptr, ptr [[WORKER_WORK_FN_ADDR]], align 8
; NVPTX-NEXT:    [[WORKER_IS_DONE:%.*]] = icmp eq ptr [[WORKER_WORK_FN]], null
; NVPTX-NEXT:    br i1 [[WORKER_IS_DONE]], label [[WORKER_STATE_MACHINE_FINISHED]], label [[WORKER_STATE_MACHINE_IS_ACTIVE_CHECK:%.*]]
; NVPTX:       worker_state_machine.finished:
; NVPTX-NEXT:    ret void
; NVPTX:       worker_state_machine.is_active.check:
; NVPTX-NEXT:    br i1 [[WORKER_IS_ACTIVE]], label [[WORKER_STATE_MACHINE_PARALLEL_REGION_FALLBACK_EXECUTE:%.*]], label [[WORKER_STATE_MACHINE_DONE_BARRIER:%.*]]
; NVPTX:       worker_state_machine.parallel_region.fallback.execute:
; NVPTX-NEXT:    call void [[WORKER_WORK_FN]](i16 0, i32 [[TMP0]])
; NVPTX-NEXT:    br label [[WORKER_STATE_MACHINE_PARALLEL_REGION_END:%.*]]
; NVPTX:       worker_state_machine.parallel_region.end:
; NVPTX-NEXT:    call void @__kmpc_kernel_end_parallel()
; NVPTX-NEXT:    br label [[WORKER_STATE_MACHINE_DONE_BARRIER]]
; NVPTX:       worker_state_machine.done.barrier:
; NVPTX-NEXT:    call void @__kmpc_barrier_simple_generic(ptr @[[GLOB1]], i32 [[TMP0]])
; NVPTX-NEXT:    br label [[WORKER_STATE_MACHINE_BEGIN]]
; NVPTX:       thread.user_code.check:
; NVPTX-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP0]], -1
; NVPTX-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[COMMON_RET:%.*]]
; NVPTX:       common.ret:
; NVPTX-NEXT:    ret void
; NVPTX:       user_code.entry:
; NVPTX-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]]) #[[ATTR10]]
; NVPTX-NEXT:    store i32 0, ptr addrspace(5) [[DOTZERO_ADDR]], align 4
; NVPTX-NEXT:    store i32 [[TMP1]], ptr addrspace(5) [[DOTTHREADID_TEMP_]], align 4, !tbaa [[TBAA12]]
; NVPTX-NEXT:    [[TMP2:%.*]] = icmp eq ptr [[FP]], @__omp_outlined_spmd_amenable_external
; NVPTX-NEXT:    br i1 [[TMP2]], label [[TMP3:%.*]], label [[TMP4:%.*]]
; NVPTX:       3:
; NVPTX-NEXT:    call void @__omp_outlined_spmd_amenable_external(ptr [[DOTTHREADID_TEMP__CAST]], ptr [[DOTZERO_ADDR_CAST]])
; NVPTX-NEXT:    br label [[TMP7:%.*]]
; NVPTX:       4:
; NVPTX-NEXT:    br i1 true, label [[TMP5:%.*]], label [[TMP6:%.*]]
; NVPTX:       5:
; NVPTX-NEXT:    call void @__omp_outlined_not_spmd_amenable_external(ptr [[DOTTHREADID_TEMP__CAST]], ptr [[DOTZERO_ADDR_CAST]])
; NVPTX-NEXT:    br label [[TMP7]]
; NVPTX:       6:
; NVPTX-NEXT:    unreachable
; NVPTX:       7:
; NVPTX-NEXT:    call void @__kmpc_target_deinit()
; NVPTX-NEXT:    br label [[COMMON_RET]]
;
entry:
  %.zero.addr = alloca ptr, align 8, addrspace(5)
  %.zero.addr.cast = addrspacecast ptr addrspace(5) %.zero.addr to ptr
  %.threadid_temp. = alloca ptr, align 8, addrspace(5)
  %.threadid_temp..cast = addrspacecast ptr addrspace(5) %.threadid_temp. to ptr
  %0 = call i32 @__kmpc_target_init(ptr @spmd_and_non_spmd_callees_metadata_kernel_environment, ptr null)
  %exec_user_code = icmp eq i32 %0, -1
  br i1 %exec_user_code, label %user_code.entry, label %common.ret

common.ret:                                       ; preds = %user_code.entry, %entry
  ret void

user_code.entry:                                  ; preds = %entry
  %1 = call i32 @__kmpc_global_thread_num(ptr @1)
  store i32 0, ptr %.zero.addr.cast, align 4
  store i32 %1, ptr %.threadid_temp..cast, align 4, !tbaa !12
  call void %fp(ptr %.threadid_temp..cast, ptr %.zero.addr.cast), !callees !24
  call void @__kmpc_target_deinit()
  br label %common.ret
}

define void @__omp_outlined_spmd_amenable_external(ptr noalias %.global_tid., ptr noalias %.bound_tid.) {
; AMDGPU-LABEL: define {{[^@]+}}@__omp_outlined_spmd_amenable_external
; AMDGPU-SAME: (ptr noalias [[DOTGLOBAL_TID_:%.*]], ptr noalias [[DOTBOUND_TID_:%.*]]) {
; AMDGPU-NEXT:  entry:
; AMDGPU-NEXT:    br label [[FOR_COND:%.*]]
; AMDGPU:       for.cond:
; AMDGPU-NEXT:    [[I_0:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[INC:%.*]], [[FOR_BODY:%.*]] ]
; AMDGPU-NEXT:    [[CMP:%.*]] = icmp slt i32 [[I_0]], 100
; AMDGPU-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_COND_CLEANUP:%.*]]
; AMDGPU:       for.cond.cleanup:
; AMDGPU-NEXT:    call void @spmd_amenable() #[[ATTR6]]
; AMDGPU-NEXT:    ret void
; AMDGPU:       for.body:
; AMDGPU-NEXT:    [[TMP0:%.*]] = load i32, ptr [[DOTGLOBAL_TID_]], align 4, !tbaa [[TBAA12]]
; AMDGPU-NEXT:    call void @__kmpc_parallel_51(ptr @[[GLOB1]], i32 [[TMP0]], i32 1, i32 -1, i32 -1, ptr @__omp_outlined__7, ptr @__omp_outlined__7_wrapper, ptr undef, i64 0)
; AMDGPU-NEXT:    [[INC]] = add nsw i32 [[I_0]], 1
; AMDGPU-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP23:![0-9]+]]
;
; NVPTX-LABEL: define {{[^@]+}}@__omp_outlined_spmd_amenable_external
; NVPTX-SAME: (ptr noalias [[DOTGLOBAL_TID_:%.*]], ptr noalias [[DOTBOUND_TID_:%.*]]) {
; NVPTX-NEXT:  entry:
; NVPTX-NEXT:    br label [[FOR_COND:%.*]]
; NVPTX:       for.cond:
; NVPTX-NEXT:    [[I_0:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[INC:%.*]], [[FOR_BODY:%.*]] ]
; NVPTX-NEXT:    [[CMP:%.*]] = icmp slt i32 [[I_0]], 100
; NVPTX-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_COND_CLEANUP:%.*]]
; NVPTX:       for.cond.cleanup:
; NVPTX-NEXT:    call void @spmd_amenable() #[[ATTR6]]
; NVPTX-NEXT:    ret void
; NVPTX:       for.body:
; NVPTX-NEXT:    [[TMP0:%.*]] = load i32, ptr [[DOTGLOBAL_TID_]], align 4, !tbaa [[TBAA12]]
; NVPTX-NEXT:    call void @__kmpc_parallel_51(ptr @[[GLOB1]], i32 [[TMP0]], i32 1, i32 -1, i32 -1, ptr @__omp_outlined__7, ptr @__omp_outlined__7_wrapper, ptr undef, i64 0)
; NVPTX-NEXT:    [[INC]] = add nsw i32 [[I_0]], 1
; NVPTX-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP23:![0-9]+]]
;
entry:
  br label %for.cond

for.cond:                                         ; preds = %for.body, %entry
  %i.0 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %cmp = icmp slt i32 %i.0, 100
  br i1 %cmp, label %for.body, label %for.cond.cleanup

for.cond.cleanup:                                 ; preds = %for.cond
  call void @spmd_amenable() #4
  ret void

for.body:                                         ; preds = %for.cond
  %0 = load i32, ptr %.global_tid., align 4, !tbaa !12
  call void @__kmpc_parallel_51(ptr @1, i32 %0, i32 1, i32 -1, i32 -1, ptr @__omp_outlined__7, ptr @__omp_outlined__7_wrapper, ptr undef, i64 0)
  %inc = add nsw i32 %i.0, 1
  br label %for.cond, !llvm.loop !25
}

define internal void @__omp_outlined__7(ptr noalias %.global_tid., ptr noalias %.bound_tid., ptr nonnull align 4 dereferenceable(4) %x) {
; AMDGPU-LABEL: define {{[^@]+}}@__omp_outlined__7
; AMDGPU-SAME: (ptr noalias [[DOTGLOBAL_TID_:%.*]], ptr noalias [[DOTBOUND_TID_:%.*]], ptr nonnull align 4 dereferenceable(4) [[X:%.*]]) {
; AMDGPU-NEXT:  entry:
; AMDGPU-NEXT:    ret void
;
; NVPTX-LABEL: define {{[^@]+}}@__omp_outlined__7
; NVPTX-SAME: (ptr noalias [[DOTGLOBAL_TID_:%.*]], ptr noalias [[DOTBOUND_TID_:%.*]], ptr nonnull align 4 dereferenceable(4) [[X:%.*]]) {
; NVPTX-NEXT:  entry:
; NVPTX-NEXT:    ret void
;
entry:
  ret void
}

; Function Attrs: convergent norecurse nounwind
define internal void @__omp_outlined__7_wrapper(i16 zeroext %0, i32 %1) #1 {
; AMDGPU-LABEL: define {{[^@]+}}@__omp_outlined__7_wrapper
; AMDGPU-SAME: (i16 zeroext [[TMP0:%.*]], i32 [[TMP1:%.*]]) #[[ATTR3:[0-9]+]] {
; AMDGPU-NEXT:  entry:
; AMDGPU-NEXT:    ret void
;
; NVPTX-LABEL: define {{[^@]+}}@__omp_outlined__7_wrapper
; NVPTX-SAME: (i16 zeroext [[TMP0:%.*]], i32 [[TMP1:%.*]]) #[[ATTR3:[0-9]+]] {
; NVPTX-NEXT:  entry:
; NVPTX-NEXT:    ret void
;
entry:
  ret void
}

define void @__omp_outlined_not_spmd_amenable_external(ptr noalias %.global_tid., ptr noalias %.bound_tid.) {
; AMDGPU-LABEL: define {{[^@]+}}@__omp_outlined_not_spmd_amenable_external
; AMDGPU-SAME: (ptr noalias [[DOTGLOBAL_TID_:%.*]], ptr noalias [[DOTBOUND_TID_:%.*]]) {
; AMDGPU-NEXT:    call void @__omp_outlined_not_spmd_amenable(ptr [[DOTGLOBAL_TID_]], ptr [[DOTBOUND_TID_]])
; AMDGPU-NEXT:    ret void
;
; NVPTX-LABEL: define {{[^@]+}}@__omp_outlined_not_spmd_amenable_external
; NVPTX-SAME: (ptr noalias [[DOTGLOBAL_TID_:%.*]], ptr noalias [[DOTBOUND_TID_:%.*]]) {
; NVPTX-NEXT:    call void @__omp_outlined_not_spmd_amenable(ptr [[DOTGLOBAL_TID_]], ptr [[DOTBOUND_TID_]])
; NVPTX-NEXT:    ret void
;
  call void @__omp_outlined_not_spmd_amenable(ptr %.global_tid., ptr %.bound_tid.)
  ret void
}

define internal void @__omp_outlined_not_spmd_amenable(ptr noalias %.global_tid., ptr noalias %.bound_tid.) {
; AMDGPU-LABEL: define {{[^@]+}}@__omp_outlined_not_spmd_amenable
; AMDGPU-SAME: (ptr noalias [[DOTGLOBAL_TID_:%.*]], ptr noalias [[DOTBOUND_TID_:%.*]]) {
; AMDGPU-NEXT:  entry:
; AMDGPU-NEXT:    call void @unknown() #[[ATTR7]]
; AMDGPU-NEXT:    ret void
;
; NVPTX-LABEL: define {{[^@]+}}@__omp_outlined_not_spmd_amenable
; NVPTX-SAME: (ptr noalias [[DOTGLOBAL_TID_:%.*]], ptr noalias [[DOTBOUND_TID_:%.*]]) {
; NVPTX-NEXT:  entry:
; NVPTX-NEXT:    call void @unknown() #[[ATTR7]]
; NVPTX-NEXT:    ret void
;
entry:
  call void @unknown() #5
  ret void
}

; Function Attrs: nosync nounwind
declare void @__kmpc_free_shared(ptr captures(none), i64) #2

; Function Attrs: nofree nosync nounwind
declare ptr @__kmpc_alloc_shared(i64) #3

; Function Attrs: convergent
declare void @use(ptr captures(none)) #4

; Function Attrs: convergent
declare void @unknown() #5

; Function Attrs: convergent
declare void @unknowni32p(ptr) #5

; Function Attrs: nocallback nofree nosync nounwind willreturn memory(argmem: readwrite)
declare void @llvm.lifetime.start.p0(i64 immarg, ptr captures(none)) #6

define weak i32 @__kmpc_target_init(ptr %0, ptr %1) {
; AMDGPU-LABEL: define {{[^@]+}}@__kmpc_target_init
; AMDGPU-SAME: (ptr [[TMP0:%.*]], ptr [[TMP1:%.*]]) {
; AMDGPU-NEXT:    ret i32 0
;
; NVPTX-LABEL: define {{[^@]+}}@__kmpc_target_init
; NVPTX-SAME: (ptr [[TMP0:%.*]], ptr [[TMP1:%.*]]) {
; NVPTX-NEXT:    ret i32 0
;
  ret i32 0
}

declare void @__kmpc_get_shared_variables(ptr)

; Function Attrs: alwaysinline
declare void @__kmpc_parallel_51(ptr, i32, i32, i32, i32, ptr, ptr, ptr, i64) #7

; Function Attrs: nocallback nofree nosync nounwind willreturn memory(argmem: readwrite)
declare void @llvm.lifetime.end.p0(i64 immarg, ptr captures(none)) #6

; Function Attrs: convergent
declare void @spmd_amenable() #4

; Function Attrs: nounwind
declare i32 @__kmpc_global_thread_num(ptr) #8

declare void @__kmpc_target_deinit()

define internal void @__omp_outlined__9(ptr noalias %.global_tid., ptr noalias %.bound_tid.) {
entry:
  call void @unknown() #5
  ret void
}

; Function Attrs: convergent norecurse nounwind
define internal void @__omp_outlined__9_wrapper(i16 zeroext %0, i32 %1) #1 {
entry:
  %.addr1 = alloca ptr, align 8, addrspace(5)
  %.addr1.cast = addrspacecast ptr addrspace(5) %.addr1 to ptr
  %.zero.addr = alloca ptr, align 8, addrspace(5)
  %.zero.addr.cast = addrspacecast ptr addrspace(5) %.zero.addr to ptr
  %global_args = alloca ptr, align 8, addrspace(5)
  %global_args.cast = addrspacecast ptr addrspace(5) %global_args to ptr
  store i32 %1, ptr %.addr1.cast, align 4, !tbaa !12
  store i32 0, ptr %.zero.addr.cast, align 4
  call void @__kmpc_get_shared_variables(ptr %global_args.cast)
  call void @__omp_outlined__9(ptr %.addr1.cast, ptr %.zero.addr.cast) #8
  ret void
}

declare fastcc i32 @__kmpc_get_hardware_thread_id_in_block()

attributes #0 = { alwaysinline convergent norecurse nounwind "kernel" }
attributes #1 = { convergent norecurse nounwind }
attributes #2 = { nosync nounwind }
attributes #3 = { nofree nosync nounwind }
attributes #4 = { convergent "llvm.assume"="ompx_spmd_amenable" }
attributes #5 = { convergent }
attributes #6 = { nocallback nofree nosync nounwind willreturn memory(argmem: readwrite) }
attributes #7 = { alwaysinline }
attributes #8 = { nounwind }

!omp_offload.info = !{!0, !1, !2, !3, !4, !5}
!llvm.module.flags = !{!6, !7, !8, !9, !10}
!llvm.ident = !{!11}

!0 = !{i32 0, i32 64770, i32 541341486, !"", i32 74, i32 5}
!1 = !{i32 0, i32 64770, i32 541341486, !"sequential_loop_to_stack_var", i32 20, i32 1}
!2 = !{i32 0, i32 64770, i32 541341486, !"sequential_loop", i32 5, i32 0}
!3 = !{i32 0, i32 64770, i32 541341486, !"sequential_loop_to_shared_var", i32 35, i32 2}
!4 = !{i32 0, i32 64770, i32 541341486, !"do_not_spmdize_target", i32 65, i32 4}
!5 = !{i32 0, i32 64770, i32 541341486, !"sequential_loop_to_shared_var_guarded", i32 50, i32 3}
!6 = !{i32 1, !"wchar_size", i32 4}
!7 = !{i32 7, !"openmp", i32 50}
!8 = !{i32 7, !"openmp-device", i32 50}
!9 = !{i32 8, !"PIC Level", i32 2}
!10 = !{i32 7, !"frame-pointer", i32 2}
!11 = !{!"clang version 14.0.0"}
!12 = !{!13, !13, i64 0}
!13 = !{!"int", !14, i64 0}
!14 = !{!"omnipotent char", !15, i64 0}
!15 = !{!"Simple C/C++ TBAA"}
!16 = distinct !{!16, !17, !18}
!17 = !{!"llvm.loop.mustprogress"}
!18 = !{!"llvm.loop.unroll.disable"}
!19 = distinct !{!19, !17, !18}
!20 = !{!21, !21, i64 0}
!21 = !{!"any pointer", !14, i64 0}
!22 = distinct !{!22, !17, !18}
!23 = !{ptr @__omp_outlined_spmd_amenable_external, ptr @__omp_outlined_not_spmd_amenable}
!24 = !{ptr @__omp_outlined_spmd_amenable_external, ptr @__omp_outlined_not_spmd_amenable_external}
!25 = distinct !{!25, !17, !18}
;.
; AMDGPU: attributes #[[ATTR0]] = { alwaysinline convergent norecurse nounwind "kernel" }
; AMDGPU: attributes #[[ATTR1]] = { norecurse }
; AMDGPU: attributes #[[ATTR2]] = { convergent norecurse nounwind }
; AMDGPU: attributes #[[ATTR3]] = { norecurse nounwind }
; AMDGPU: attributes #[[ATTR4:[0-9]+]] = { nosync nounwind }
; AMDGPU: attributes #[[ATTR5:[0-9]+]] = { nofree nosync nounwind allocsize(0) }
; AMDGPU: attributes #[[ATTR6]] = { convergent "llvm.assume"="ompx_spmd_amenable" }
; AMDGPU: attributes #[[ATTR7]] = { convergent }
; AMDGPU: attributes #[[ATTR8:[0-9]+]] = { nocallback nofree nosync nounwind willreturn memory(argmem: readwrite) }
; AMDGPU: attributes #[[ATTR9:[0-9]+]] = { alwaysinline }
; AMDGPU: attributes #[[ATTR10]] = { nounwind }
; AMDGPU: attributes #[[ATTR11:[0-9]+]] = { convergent nounwind }
;.
; NVPTX: attributes #[[ATTR0]] = { alwaysinline convergent norecurse nounwind "kernel" }
; NVPTX: attributes #[[ATTR1]] = { norecurse }
; NVPTX: attributes #[[ATTR2]] = { convergent norecurse nounwind }
; NVPTX: attributes #[[ATTR3]] = { norecurse nounwind }
; NVPTX: attributes #[[ATTR4:[0-9]+]] = { nosync nounwind }
; NVPTX: attributes #[[ATTR5:[0-9]+]] = { nofree nosync nounwind allocsize(0) }
; NVPTX: attributes #[[ATTR6]] = { convergent "llvm.assume"="ompx_spmd_amenable" }
; NVPTX: attributes #[[ATTR7]] = { convergent }
; NVPTX: attributes #[[ATTR8:[0-9]+]] = { nocallback nofree nosync nounwind willreturn memory(argmem: readwrite) }
; NVPTX: attributes #[[ATTR9:[0-9]+]] = { alwaysinline }
; NVPTX: attributes #[[ATTR10]] = { nounwind }
; NVPTX: attributes #[[ATTR11:[0-9]+]] = { convergent nounwind }
;.
; AMDGPU: [[META0:![0-9]+]] = !{i32 0, i32 64770, i32 541341486, !"", i32 74, i32 5}
; AMDGPU: [[META1:![0-9]+]] = !{i32 0, i32 64770, i32 541341486, !"sequential_loop_to_stack_var", i32 20, i32 1}
; AMDGPU: [[META2:![0-9]+]] = !{i32 0, i32 64770, i32 541341486, !"sequential_loop", i32 5, i32 0}
; AMDGPU: [[META3:![0-9]+]] = !{i32 0, i32 64770, i32 541341486, !"sequential_loop_to_shared_var", i32 35, i32 2}
; AMDGPU: [[META4:![0-9]+]] = !{i32 0, i32 64770, i32 541341486, !"do_not_spmdize_target", i32 65, i32 4}
; AMDGPU: [[META5:![0-9]+]] = !{i32 0, i32 64770, i32 541341486, !"sequential_loop_to_shared_var_guarded", i32 50, i32 3}
; AMDGPU: [[META6:![0-9]+]] = !{i32 1, !"wchar_size", i32 4}
; AMDGPU: [[META7:![0-9]+]] = !{i32 7, !"openmp", i32 50}
; AMDGPU: [[META8:![0-9]+]] = !{i32 7, !"openmp-device", i32 50}
; AMDGPU: [[META9:![0-9]+]] = !{i32 8, !"PIC Level", i32 2}
; AMDGPU: [[META10:![0-9]+]] = !{i32 7, !"frame-pointer", i32 2}
; AMDGPU: [[META11:![0-9]+]] = !{!"{{.*}}clang version {{.*}}"}
; AMDGPU: [[TBAA12]] = !{[[META13:![0-9]+]], [[META13]], i64 0}
; AMDGPU: [[META13]] = !{!"int", [[META14:![0-9]+]], i64 0}
; AMDGPU: [[META14]] = !{!"omnipotent char", [[META15:![0-9]+]], i64 0}
; AMDGPU: [[META15]] = !{!"Simple C/C++ TBAA"}
; AMDGPU: [[LOOP16]] = distinct !{[[LOOP16]], [[META17:![0-9]+]], [[META18:![0-9]+]]}
; AMDGPU: [[META17]] = !{!"llvm.loop.mustprogress"}
; AMDGPU: [[META18]] = !{!"llvm.loop.unroll.disable"}
; AMDGPU: [[LOOP19]] = distinct !{[[LOOP19]], [[META17]], [[META18]]}
; AMDGPU: [[TBAA20]] = !{[[META21:![0-9]+]], [[META21]], i64 0}
; AMDGPU: [[META21]] = !{!"any pointer", [[META14]], i64 0}
; AMDGPU: [[LOOP22]] = distinct !{[[LOOP22]], [[META17]], [[META18]]}
; AMDGPU: [[LOOP23]] = distinct !{[[LOOP23]], [[META17]], [[META18]]}
;.
; NVPTX: [[META0:![0-9]+]] = !{i32 0, i32 64770, i32 541341486, !"", i32 74, i32 5}
; NVPTX: [[META1:![0-9]+]] = !{i32 0, i32 64770, i32 541341486, !"sequential_loop_to_stack_var", i32 20, i32 1}
; NVPTX: [[META2:![0-9]+]] = !{i32 0, i32 64770, i32 541341486, !"sequential_loop", i32 5, i32 0}
; NVPTX: [[META3:![0-9]+]] = !{i32 0, i32 64770, i32 541341486, !"sequential_loop_to_shared_var", i32 35, i32 2}
; NVPTX: [[META4:![0-9]+]] = !{i32 0, i32 64770, i32 541341486, !"do_not_spmdize_target", i32 65, i32 4}
; NVPTX: [[META5:![0-9]+]] = !{i32 0, i32 64770, i32 541341486, !"sequential_loop_to_shared_var_guarded", i32 50, i32 3}
; NVPTX: [[META6:![0-9]+]] = !{i32 1, !"wchar_size", i32 4}
; NVPTX: [[META7:![0-9]+]] = !{i32 7, !"openmp", i32 50}
; NVPTX: [[META8:![0-9]+]] = !{i32 7, !"openmp-device", i32 50}
; NVPTX: [[META9:![0-9]+]] = !{i32 8, !"PIC Level", i32 2}
; NVPTX: [[META10:![0-9]+]] = !{i32 7, !"frame-pointer", i32 2}
; NVPTX: [[META11:![0-9]+]] = !{!"{{.*}}clang version {{.*}}"}
; NVPTX: [[TBAA12]] = !{[[META13:![0-9]+]], [[META13]], i64 0}
; NVPTX: [[META13]] = !{!"int", [[META14:![0-9]+]], i64 0}
; NVPTX: [[META14]] = !{!"omnipotent char", [[META15:![0-9]+]], i64 0}
; NVPTX: [[META15]] = !{!"Simple C/C++ TBAA"}
; NVPTX: [[LOOP16]] = distinct !{[[LOOP16]], [[META17:![0-9]+]], [[META18:![0-9]+]]}
; NVPTX: [[META17]] = !{!"llvm.loop.mustprogress"}
; NVPTX: [[META18]] = !{!"llvm.loop.unroll.disable"}
; NVPTX: [[LOOP19]] = distinct !{[[LOOP19]], [[META17]], [[META18]]}
; NVPTX: [[TBAA20]] = !{[[META21:![0-9]+]], [[META21]], i64 0}
; NVPTX: [[META21]] = !{!"any pointer", [[META14]], i64 0}
; NVPTX: [[LOOP22]] = distinct !{[[LOOP22]], [[META17]], [[META18]]}
; NVPTX: [[LOOP23]] = distinct !{[[LOOP23]], [[META17]], [[META18]]}
;.
