; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes=loop-vectorize -force-vector-interleave=1 -force-vector-width=4 -S < %s | FileCheck %s --check-prefix=CHECK

define i32 @select_icmp_switch(i32 %n, i32 %case, ptr %a, ptr %b) {
; CHECK-LABEL: define i32 @select_icmp_switch(
; CHECK-SAME: i32 [[N:%.*]], i32 [[CASE:%.*]], ptr [[A:%.*]], ptr [[B:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    [[CMP_SGT:%.*]] = icmp sgt i32 [[N]], 0
; CHECK-NEXT:    br i1 [[CMP_SGT]], label %[[FOR_BODY_PREHEADER:.*]], label %[[FOR_END:.*]]
; CHECK:       [[FOR_BODY_PREHEADER]]:
; CHECK-NEXT:    [[WIDE_TRIP_COUNT:%.*]] = zext i32 [[N]] to i64
; CHECK-NEXT:    br label %[[FOR_BODY:.*]]
; CHECK:       [[FOR_BODY]]:
; CHECK-NEXT:    [[INDVARS:%.*]] = phi i64 [ 0, %[[FOR_BODY_PREHEADER]] ], [ [[INDVARS_NEXT:%.*]], %[[FOR_INC:.*]] ]
; CHECK-NEXT:    [[RDX_PHI:%.*]] = phi i32 [ 0, %[[FOR_BODY_PREHEADER]] ], [ [[RDX_PHI_NEXT:%.*]], %[[FOR_INC]] ]
; CHECK-NEXT:    switch i32 [[CASE]], label %[[SW_BB0:.*]] [
; CHECK-NEXT:      i32 0, label %[[SW_BB0]]
; CHECK-NEXT:      i32 1, label %[[SW_BB1:.*]]
; CHECK-NEXT:    ]
; CHECK:       [[SW_BB0]]:
; CHECK-NEXT:    [[A_ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[A]], i64 [[INDVARS]]
; CHECK-NEXT:    [[A_VALUE:%.*]] = load i8, ptr [[A_ARRAYIDX]], align 1
; CHECK-NEXT:    [[CMP_A:%.*]] = icmp eq i8 [[A_VALUE]], -1
; CHECK-NEXT:    [[TRUNC_BB0:%.*]] = trunc i64 [[INDVARS]] to i32
; CHECK-NEXT:    [[SELECT_BB0:%.*]] = select i1 [[CMP_A]], i32 [[RDX_PHI]], i32 [[TRUNC_BB0]]
; CHECK-NEXT:    br label %[[FOR_INC]]
; CHECK:       [[SW_BB1]]:
; CHECK-NEXT:    [[B_ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[B]], i64 [[INDVARS]]
; CHECK-NEXT:    [[B_VALUE:%.*]] = load i8, ptr [[B_ARRAYIDX]], align 1
; CHECK-NEXT:    [[CMP_B:%.*]] = icmp eq i8 [[B_VALUE]], -1
; CHECK-NEXT:    [[TRUNC_BB1:%.*]] = trunc i64 [[INDVARS]] to i32
; CHECK-NEXT:    [[SELECT_BB1:%.*]] = select i1 [[CMP_B]], i32 [[RDX_PHI]], i32 [[TRUNC_BB1]]
; CHECK-NEXT:    br label %[[FOR_INC]]
; CHECK:       [[FOR_INC]]:
; CHECK-NEXT:    [[RDX_PHI_NEXT]] = phi i32 [ [[SELECT_BB0]], %[[SW_BB0]] ], [ [[SELECT_BB1]], %[[SW_BB1]] ]
; CHECK-NEXT:    [[INDVARS_NEXT]] = add nuw nsw i64 [[INDVARS]], 1
; CHECK-NEXT:    [[EXITCOND_NOT:%.*]] = icmp eq i64 [[INDVARS_NEXT]], [[WIDE_TRIP_COUNT]]
; CHECK-NEXT:    br i1 [[EXITCOND_NOT]], label %[[FOR_END_LOOPEXIT:.*]], label %[[FOR_BODY]]
; CHECK:       [[FOR_END_LOOPEXIT]]:
; CHECK-NEXT:    [[RDX_PHI_NEXT_LCSSA:%.*]] = phi i32 [ [[RDX_PHI_NEXT]], %[[FOR_INC]] ]
; CHECK-NEXT:    br label %[[FOR_END]]
; CHECK:       [[FOR_END]]:
; CHECK-NEXT:    [[SELECT_LCSSA:%.*]] = phi i32 [ 0, %[[ENTRY]] ], [ [[RDX_PHI_NEXT_LCSSA]], %[[FOR_END_LOOPEXIT]] ]
; CHECK-NEXT:    ret i32 [[SELECT_LCSSA]]
;
entry:
  %cmp.sgt = icmp sgt i32 %n, 0
  br i1 %cmp.sgt, label %for.body.preheader, label %for.end

for.body.preheader:
  %wide.trip.count = zext i32 %n to i64
  br label %for.body

for.body:
  %indvars = phi i64 [ 0, %for.body.preheader ], [ %indvars.next, %for.inc ]
  %rdx.phi = phi i32 [ 0, %for.body.preheader ], [ %rdx.phi.next, %for.inc ]
  switch i32 %case, label %sw.bb0 [
  i32 0, label %sw.bb0
  i32 1, label %sw.bb1
  ]

sw.bb0:
  %a.arrayidx = getelementptr inbounds i8, ptr %a, i64 %indvars
  %a.value = load i8, ptr %a.arrayidx, align 1
  %cmp.a = icmp eq i8 %a.value, -1
  %trunc.bb0 = trunc i64 %indvars to i32
  %select.bb0 = select i1 %cmp.a, i32 %rdx.phi, i32 %trunc.bb0
  br label %for.inc

sw.bb1:
  %b.arrayidx = getelementptr inbounds i8, ptr %b, i64 %indvars
  %b.value = load i8, ptr %b.arrayidx, align 1
  %cmp.b = icmp eq i8 %b.value, -1
  %trunc.bb1 = trunc i64 %indvars to i32
  %select.bb1 = select i1 %cmp.b, i32 %rdx.phi, i32 %trunc.bb1
  br label %for.inc

for.inc:
  %rdx.phi.next = phi i32 [ %select.bb0, %sw.bb0 ], [ %select.bb1, %sw.bb1 ]
  %indvars.next = add nuw nsw i64 %indvars, 1
  %exitcond.not = icmp eq i64 %indvars.next, %wide.trip.count
  br i1 %exitcond.not, label %for.end, label %for.body

for.end:
  %select.lcssa = phi i32 [ %rdx.phi.next, %for.inc ], [ 0, %entry ]
  ret i32 %select.lcssa
}
