; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes='loop-mssa(loop-instsimplify,loop-simplifycfg,simple-loop-unswitch)' -S %s | FileCheck %s

; Test case from PR54023. After SimpleLoopUnswitch, one of the loops processed
; by LoopSimplifyCFG will have exit blocks with predecessors outside the loop
; (i.e. it is not in loop-simplify/canonical form).
define i32 @test(i32 %v, i1 %c.1, i1 %c.2) {
; CHECK-LABEL: @test(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[OUTER_HEADER:%.*]]
; CHECK:       outer.header:
; CHECK-NEXT:    br i1 [[C_1:%.*]], label [[OUTER_LATCH:%.*]], label [[INNER_HEADER_PREHEADER:%.*]]
; CHECK:       inner.header.preheader:
; CHECK-NEXT:    br label [[INNER_HEADER:%.*]]
; CHECK:       inner.header:
; CHECK-NEXT:    [[CMP_2:%.*]] = icmp ne i32 [[V:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP_2]], label [[EXIT:%.*]], label [[INNER_LATCH:%.*]]
; CHECK:       inner.latch:
; CHECK-NEXT:    br i1 [[C_2:%.*]], label [[OUTER_LATCH_LOOPEXIT:%.*]], label [[INNER_HEADER]]
; CHECK:       outer.latch.loopexit:
; CHECK-NEXT:    br label [[OUTER_LATCH]]
; CHECK:       outer.latch:
; CHECK-NEXT:    br label [[OUTER_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = phi i32 [ [[V]], [[INNER_HEADER]] ]
; CHECK-NEXT:    br label [[EXIT_SPLIT:%.*]]
; CHECK:       exit.split:
; CHECK-NEXT:    [[RES_SPLIT:%.*]] = phi i32 [ [[RES]], [[EXIT]] ]
; CHECK-NEXT:    ret i32 [[RES_SPLIT]]
;
entry:
  br label %outer.header

outer.header:
  %g.0 = phi i32 [ 10, %outer.latch ], [ 1, %entry ]
  %cmp.1 = icmp eq i32 %g.0, 0
  br i1 %c.1, label %outer.latch, label %inner.header

inner.header:
  %cmp.2 = icmp ne i32 %v, 0
  %or.cond = or i1 %cmp.1, %cmp.2
  br i1 %or.cond, label %exit, label %inner.latch

inner.latch:
  br i1 %c.2, label %outer.latch, label %inner.header

outer.latch:
  br label %outer.header

exit:
  %res = phi i32 [ %v, %inner.header ]
  ret i32 %res
}
