; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -S -passes=indvars < %s | FileCheck %s

; Check that SCEV is able to recognize and use guards to prove
; conditions gaurding loop entries and backedges.  This isn't intended
; to be a comprehensive test of SCEV's simplification capabilities,
; tests directly testing e.g. if SCEV can elide a sext should go
; elsewhere.

target datalayout = "n8:16:32:64"

declare void @llvm.experimental.guard(i1, ...)

declare void @use(i64 %x)

define void @test_1(ptr %cond_buf, ptr %len_buf) {
; CHECK-LABEL: define void @test_1
; CHECK-SAME: (ptr [[COND_BUF:%.*]], ptr [[LEN_BUF:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LEN:%.*]] = load i32, ptr [[LEN_BUF]], align 4, !range [[RNG0:![0-9]+]]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_INC:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[IV_INC]] = add nsw i32 [[IV]], 1
; CHECK-NEXT:    call void (i1, ...) @llvm.experimental.guard(i1 true) [ "deopt"() ]
; CHECK-NEXT:    [[IV_INC_CMP:%.*]] = icmp samesign ult i32 [[IV_INC]], [[LEN]]
; CHECK-NEXT:    call void (i1, ...) @llvm.experimental.guard(i1 [[IV_INC_CMP]]) [ "deopt"() ]
; CHECK-NEXT:    [[BECOND:%.*]] = load volatile i1, ptr [[COND_BUF]], align 1
; CHECK-NEXT:    br i1 [[BECOND]], label [[LOOP]], label [[LEAVE:%.*]]
; CHECK:       leave:
; CHECK-NEXT:    ret void
;
entry:
  %len = load i32, ptr %len_buf, !range !{i32 1, i32 2147483648}
  br label %loop

loop:

  %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
  %iv.inc = add i32 %iv, 1

  %iv.cmp = icmp slt i32 %iv, %len
  call void(i1, ...) @llvm.experimental.guard(i1 %iv.cmp) [ "deopt"() ]

  %iv.inc.cmp = icmp slt i32 %iv.inc, %len
  call void(i1, ...) @llvm.experimental.guard(i1 %iv.inc.cmp) [ "deopt"() ]

  %becond = load volatile i1, ptr %cond_buf
  br i1 %becond, label %loop, label %leave

leave:
  ret void
}

define void @test_2(i32 %n, ptr %len_buf) {
; CHECK-LABEL: define void @test_2
; CHECK-SAME: (i32 [[N:%.*]], ptr [[LEN_BUF:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LEN:%.*]] = load i32, ptr [[LEN_BUF]], align 4, !range [[RNG1:![0-9]+]]
; CHECK-NEXT:    [[TMP0:%.*]] = sext i32 [[LEN]] to i64
; CHECK-NEXT:    [[TMP1:%.*]] = zext i32 [[N]] to i64
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[LOOP]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    call void @use(i64 [[INDVARS_IV]])
; CHECK-NEXT:    [[IV_INC_CMP:%.*]] = icmp samesign ult i64 [[INDVARS_IV_NEXT]], [[TMP0]]
; CHECK-NEXT:    call void (i1, ...) @llvm.experimental.guard(i1 [[IV_INC_CMP]]) [ "deopt"() ]
; CHECK-NEXT:    [[BECOND:%.*]] = icmp ne i64 [[INDVARS_IV]], [[TMP1]]
; CHECK-NEXT:    br i1 [[BECOND]], label [[LOOP]], label [[LEAVE:%.*]]
; CHECK:       leave:
; CHECK-NEXT:    ret void
;

entry:
  %len = load i32, ptr %len_buf, !range !{i32 0, i32 2147483648}
  br label %loop

loop:

  %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
  %iv.inc = add i32 %iv, 1

  %iv.sext = sext i32 %iv to i64
  call void @use(i64 %iv.sext)

  %iv.inc.cmp = icmp slt i32 %iv.inc, %len
  call void(i1, ...) @llvm.experimental.guard(i1 %iv.inc.cmp) [ "deopt"() ]

  %becond = icmp ne i32 %iv, %n
  br i1 %becond, label %loop, label %leave

leave:
  ret void
}

define void @test_3(ptr %cond_buf, ptr %len_buf) {
; CHECK-LABEL: define void @test_3
; CHECK-SAME: (ptr [[COND_BUF:%.*]], ptr [[LEN_BUF:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LEN:%.*]] = load i32, ptr [[LEN_BUF]], align 4
; CHECK-NEXT:    [[ENTRY_COND:%.*]] = icmp sgt i32 [[LEN]], 0
; CHECK-NEXT:    call void (i1, ...) @llvm.experimental.guard(i1 [[ENTRY_COND]]) [ "deopt"() ]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_INC:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[IV_INC]] = add nsw i32 [[IV]], 1
; CHECK-NEXT:    call void (i1, ...) @llvm.experimental.guard(i1 true) [ "deopt"() ]
; CHECK-NEXT:    [[IV_INC_CMP:%.*]] = icmp slt i32 [[IV_INC]], [[LEN]]
; CHECK-NEXT:    call void (i1, ...) @llvm.experimental.guard(i1 [[IV_INC_CMP]]) [ "deopt"() ]
; CHECK-NEXT:    [[BECOND:%.*]] = load volatile i1, ptr [[COND_BUF]], align 1
; CHECK-NEXT:    br i1 [[BECOND]], label [[LOOP]], label [[LEAVE:%.*]]
; CHECK:       leave:
; CHECK-NEXT:    ret void
;

entry:
  %len = load i32, ptr %len_buf
  %entry.cond = icmp sgt i32 %len, 0
  call void(i1, ...) @llvm.experimental.guard(i1 %entry.cond) [ "deopt"() ]
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
  %iv.inc = add i32 %iv, 1

  %iv.cmp = icmp slt i32 %iv, %len
  call void(i1, ...) @llvm.experimental.guard(i1 %iv.cmp) [ "deopt"() ]

  %iv.inc.cmp = icmp slt i32 %iv.inc, %len
  call void(i1, ...) @llvm.experimental.guard(i1 %iv.inc.cmp) [ "deopt"() ]

  %becond = load volatile i1, ptr %cond_buf
  br i1 %becond, label %loop, label %leave

leave:
  ret void
}

define void @test_4(ptr %cond_buf, ptr %len_buf) {
; CHECK-LABEL: define void @test_4
; CHECK-SAME: (ptr [[COND_BUF:%.*]], ptr [[LEN_BUF:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LEN:%.*]] = load i32, ptr [[LEN_BUF]], align 4
; CHECK-NEXT:    [[ENTRY_COND:%.*]] = icmp sgt i32 [[LEN]], 0
; CHECK-NEXT:    call void (i1, ...) @llvm.experimental.guard(i1 [[ENTRY_COND]]) [ "deopt"() ]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_INC:%.*]], [[BE:%.*]] ]
; CHECK-NEXT:    [[IV_INC]] = add i32 [[IV]], 1
; CHECK-NEXT:    [[COND:%.*]] = load volatile i1, ptr [[COND_BUF]], align 1
; CHECK-NEXT:    br i1 [[COND]], label [[LEFT:%.*]], label [[BE]]
; CHECK:       left:
; CHECK-NEXT:    [[IV_INC_CMP:%.*]] = icmp slt i32 [[IV_INC]], [[LEN]]
; CHECK-NEXT:    call void (i1, ...) @llvm.experimental.guard(i1 [[IV_INC_CMP]]) [ "deopt"() ]
; CHECK-NEXT:    br label [[BE]]
; CHECK:       be:
; CHECK-NEXT:    [[IV_CMP:%.*]] = icmp slt i32 [[IV]], [[LEN]]
; CHECK-NEXT:    call void (i1, ...) @llvm.experimental.guard(i1 [[IV_CMP]]) [ "deopt"() ]
; CHECK-NEXT:    [[BECOND:%.*]] = load volatile i1, ptr [[COND_BUF]], align 1
; CHECK-NEXT:    br i1 [[BECOND]], label [[LOOP]], label [[LEAVE:%.*]]
; CHECK:       leave:
; CHECK-NEXT:    ret void
;

entry:
  %len = load i32, ptr %len_buf
  %entry.cond = icmp sgt i32 %len, 0
  call void(i1, ...) @llvm.experimental.guard(i1 %entry.cond) [ "deopt"() ]
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.inc, %be ]
  %iv.inc = add i32 %iv, 1

  %cond = load volatile i1, ptr %cond_buf
  br i1 %cond, label %left, label %be

left:
  ; Does not dominate the backedge, so cannot be used in the inductive proof
  %iv.inc.cmp = icmp slt i32 %iv.inc, %len
  call void(i1, ...) @llvm.experimental.guard(i1 %iv.inc.cmp) [ "deopt"() ]
  br label %be

be:

  %iv.cmp = icmp slt i32 %iv, %len
  call void(i1, ...) @llvm.experimental.guard(i1 %iv.cmp) [ "deopt"() ]

  %becond = load volatile i1, ptr %cond_buf
  br i1 %becond, label %loop, label %leave

leave:
  ret void
}
