; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --include-generated-funcs
; RUN: opt -S -passes=verify,iroutliner -ir-outlining-no-cost < %s | FileCheck %s

; This test checks that we do not fail when there is a similarity group with
; an ending instruction that is also the end of the module.

@a = global ptr null

define void @foo() {
entry:
  br label %for.cond1

for.cond1:
  br label %for.body

for.body:
  %inc = add nsw i32 2, 1
  br label %for.cond1

for.end:
  %inc3 = add nsw i32 2, 1
  br label %for.cond1
}

; These are for testing if return instructions or unreachable instructions are
; matched for similarity.
define void @foo1() {
entry:
  br label %for.cond1

for.cond1:
  br label %for.body

for.body:
  %inc = add nsw i32 2, 1
  ret void

for.end:
  %inc3 = add nsw i32 2, 1
  ret void
}

define void @foo2() {
entry:
  br label %for.cond1

for.cond1:
  br label %for.body

for.body:
  %inc = add nsw i32 2, 1
  unreachable

for.end:
  %inc3 = add nsw i32 2, 1
  unreachable
}

; CHECK-LABEL: @foo(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_COND1:%.*]]
; CHECK:       for.cond1:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    call void @outlined_ir_func_1()
; CHECK-NEXT:    br label [[FOR_COND1]]
; CHECK:       for.end:
; CHECK-NEXT:    call void @outlined_ir_func_1()
; CHECK-NEXT:    br label [[FOR_COND1]]
;
;
; CHECK-LABEL: @foo1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    call void @outlined_ir_func_0()
; CHECK-NEXT:    ret void
; CHECK:       for.end:
; CHECK-NEXT:    [[INC3:%.*]] = add nsw i32 2, 1
; CHECK-NEXT:    ret void
;
;
; CHECK-LABEL: @foo2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    call void @outlined_ir_func_0()
; CHECK-NEXT:    unreachable
; CHECK:       for.end:
; CHECK-NEXT:    [[INC3:%.*]] = add nsw i32 2, 1
; CHECK-NEXT:    unreachable
;
;
; CHECK: define internal void @outlined_ir_func_0(
; CHECK-NEXT:  newFuncRoot:
; CHECK-NEXT:    br label [[ENTRY_TO_OUTLINE:%.*]]
; CHECK:       entry_to_outline:
; CHECK-NEXT:    br label [[FOR_COND1:%.*]]
; CHECK:       for.cond1:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INC:%.*]] = add nsw i32 2, 1
; CHECK-NEXT:    br label [[ENTRY_AFTER_OUTLINE_EXITSTUB:%.*]]
; CHECK:       entry_after_outline.exitStub:
; CHECK-NEXT:    ret void
;
;
; CHECK: define internal void @outlined_ir_func_1(
; CHECK-NEXT:  newFuncRoot:
; CHECK-NEXT:    br label [[FOR_BODY_TO_OUTLINE:%.*]]
; CHECK:       for.body_to_outline:
; CHECK-NEXT:    [[INC:%.*]] = add nsw i32 2, 1
; CHECK-NEXT:    br label [[FOR_COND1_EXITSTUB:%.*]]
; CHECK:       for.cond1.exitStub:
; CHECK-NEXT:    ret void
;
