; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt -passes=constraint-elimination -S %s | FileCheck %s

define i1 @abs_int_min_is_not_poison(i32 noundef %arg) {
; CHECK-LABEL: define i1 @abs_int_min_is_not_poison(
; CHECK-SAME: i32 noundef [[ARG:%.*]]) {
; CHECK-NEXT:    [[ABS:%.*]] = tail call i32 @llvm.abs.i32(i32 [[ARG]], i1 false)
; CHECK-NEXT:    ret i1 true
;
  %abs = tail call i32 @llvm.abs.i32(i32 %arg, i1 false)
  %cmp = icmp sge i32 %abs, %arg
  ret i1 %cmp
}

define i1 @abs_int_min_is_poison(i32 noundef %arg) {
; CHECK-LABEL: define i1 @abs_int_min_is_poison(
; CHECK-SAME: i32 noundef [[ARG:%.*]]) {
; CHECK-NEXT:    [[ABS:%.*]] = tail call i32 @llvm.abs.i32(i32 [[ARG]], i1 true)
; CHECK-NEXT:    ret i1 true
;
  %abs = tail call i32 @llvm.abs.i32(i32 %arg, i1 true)
  %cmp = icmp sge i32 %abs, %arg
  ret i1 %cmp
}

define i1 @abs_plus_one_min_is_not_poison(i32 noundef %arg) {
; CHECK-LABEL: define i1 @abs_plus_one_min_is_not_poison(
; CHECK-SAME: i32 noundef [[ARG:%.*]]) {
; CHECK-NEXT:    [[ABS:%.*]] = tail call i32 @llvm.abs.i32(i32 [[ARG]], i1 false)
; CHECK-NEXT:    [[ABS_PLUS_ONE:%.*]] = add nsw i32 [[ABS]], 1
; CHECK-NEXT:    ret i1 true
;
  %abs = tail call i32 @llvm.abs.i32(i32 %arg, i1 false)
  %abs_plus_one = add nsw i32 %abs, 1
  %cmp = icmp sge i32 %abs_plus_one, %arg
  ret i1 %cmp
}

define i1 @abs_plus_one_min_is_poison(i32 noundef %arg) {
; CHECK-LABEL: define i1 @abs_plus_one_min_is_poison(
; CHECK-SAME: i32 noundef [[ARG:%.*]]) {
; CHECK-NEXT:    [[ABS:%.*]] = tail call i32 @llvm.abs.i32(i32 [[ARG]], i1 true)
; CHECK-NEXT:    [[ABS_PLUS_ONE:%.*]] = add nsw i32 [[ABS]], 1
; CHECK-NEXT:    ret i1 true
;
  %abs = tail call i32 @llvm.abs.i32(i32 %arg, i1 true)
  %abs_plus_one = add nsw i32 %abs, 1
  %cmp = icmp sge i32 %abs_plus_one, %arg
  ret i1 %cmp
}

define i1 @arg_minus_one_strict_less_min_is_not_poison(i32 noundef %arg) {
; CHECK-LABEL: define i1 @arg_minus_one_strict_less_min_is_not_poison(
; CHECK-SAME: i32 noundef [[ARG:%.*]]) {
; CHECK-NEXT:    [[ABS:%.*]] = tail call i32 @llvm.abs.i32(i32 [[ARG]], i1 false)
; CHECK-NEXT:    [[ARG_MINUS_ONE:%.*]] = add nsw i32 [[ARG]], -1
; CHECK-NEXT:    ret i1 true
;
  %abs = tail call i32 @llvm.abs.i32(i32 %arg, i1 false)
  %arg_minus_one = add nsw i32 %arg, -1
  %cmp = icmp slt i32 %arg_minus_one, %abs
  ret i1 %cmp
}


define i1 @arg_minus_one_strict_less_min_is_poison(i32 noundef %arg) {
; CHECK-LABEL: define i1 @arg_minus_one_strict_less_min_is_poison(
; CHECK-SAME: i32 noundef [[ARG:%.*]]) {
; CHECK-NEXT:    [[ABS:%.*]] = tail call i32 @llvm.abs.i32(i32 [[ARG]], i1 true)
; CHECK-NEXT:    [[ARG_MINUS_ONE:%.*]] = add nsw i32 [[ARG]], -1
; CHECK-NEXT:    ret i1 true
;
  %abs = tail call i32 @llvm.abs.i32(i32 %arg, i1 true)
  %arg_minus_one = add nsw i32 %arg, -1
  %cmp = icmp slt i32 %arg_minus_one, %abs
  ret i1 %cmp
}

define i1 @arg_minus_one_strict_greater_min_is_not_poison(i32 noundef %arg) {
; CHECK-LABEL: define i1 @arg_minus_one_strict_greater_min_is_not_poison(
; CHECK-SAME: i32 noundef [[ARG:%.*]]) {
; CHECK-NEXT:    [[ABS:%.*]] = tail call i32 @llvm.abs.i32(i32 [[ARG]], i1 false)
; CHECK-NEXT:    [[ARG_MINUS_ONE:%.*]] = add nsw i32 [[ARG]], -1
; CHECK-NEXT:    ret i1 false
;
  %abs = tail call i32 @llvm.abs.i32(i32 %arg, i1 false)
  %arg_minus_one = add nsw i32 %arg, -1
  %cmp = icmp sgt i32 %arg_minus_one, %abs
  ret i1 %cmp
}

define i1 @arg_minus_one_strict_greater_min_is_poison(i32 noundef %arg) {
; CHECK-LABEL: define i1 @arg_minus_one_strict_greater_min_is_poison(
; CHECK-SAME: i32 noundef [[ARG:%.*]]) {
; CHECK-NEXT:    [[ABS:%.*]] = tail call i32 @llvm.abs.i32(i32 [[ARG]], i1 true)
; CHECK-NEXT:    [[ARG_MINUS_ONE:%.*]] = add nsw i32 [[ARG]], -1
; CHECK-NEXT:    ret i1 false
;
  %abs = tail call i32 @llvm.abs.i32(i32 %arg, i1 true)
  %arg_minus_one = add nsw i32 %arg, -1
  %cmp = icmp sgt i32 %arg_minus_one, %abs
  ret i1 %cmp
}

define i1 @abs_plus_one_unsigned_greater_or_equal_nonnegative_arg_min_is_not_poison(i32 noundef %arg) {
; CHECK-LABEL: define i1 @abs_plus_one_unsigned_greater_or_equal_nonnegative_arg_min_is_not_poison(
; CHECK-SAME: i32 noundef [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP_ARG_NONNEGATIVE:%.*]] = icmp sge i32 [[ARG]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[CMP_ARG_NONNEGATIVE]])
; CHECK-NEXT:    [[ABS:%.*]] = tail call i32 @llvm.abs.i32(i32 [[ARG]], i1 false)
; CHECK-NEXT:    [[ABS_PLUS_ONE:%.*]] = add nuw i32 [[ABS]], 1
; CHECK-NEXT:    ret i1 true
;
  %cmp_arg_nonnegative = icmp sge i32 %arg, 0
  call void @llvm.assume(i1 %cmp_arg_nonnegative)
  %abs = tail call i32 @llvm.abs.i32(i32 %arg, i1 false)
  %abs_plus_one = add nuw i32 %abs, 1
  %cmp = icmp uge i32 %abs_plus_one, %arg
  ret i1 %cmp
}

define i1 @abs_plus_one_unsigned_greater_or_equal_nonnegative_arg_min_is_poison(i32 noundef %arg) {
; CHECK-LABEL: define i1 @abs_plus_one_unsigned_greater_or_equal_nonnegative_arg_min_is_poison(
; CHECK-SAME: i32 noundef [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP_ARG_NONNEGATIVE:%.*]] = icmp sge i32 [[ARG]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[CMP_ARG_NONNEGATIVE]])
; CHECK-NEXT:    [[ABS:%.*]] = tail call i32 @llvm.abs.i32(i32 [[ARG]], i1 true)
; CHECK-NEXT:    [[ABS_PLUS_ONE:%.*]] = add nuw i32 [[ABS]], 1
; CHECK-NEXT:    ret i1 true
;
  %cmp_arg_nonnegative = icmp sge i32 %arg, 0
  call void @llvm.assume(i1 %cmp_arg_nonnegative)
  %abs = tail call i32 @llvm.abs.i32(i32 %arg, i1 true)
  %abs_plus_one = add nuw i32 %abs, 1
  %cmp = icmp uge i32 %abs_plus_one, %arg
  ret i1 %cmp
}

define i1 @abs_plus_one_unsigned_greater_or_equal_cannot_be_simplified(i32 noundef %arg) {
; CHECK-LABEL: define i1 @abs_plus_one_unsigned_greater_or_equal_cannot_be_simplified(
; CHECK-SAME: i32 noundef [[ARG:%.*]]) {
; CHECK-NEXT:    [[ABS:%.*]] = tail call i32 @llvm.abs.i32(i32 [[ARG]], i1 false)
; CHECK-NEXT:    [[ABS_PLUS_ONE:%.*]] = add nuw i32 [[ABS]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp uge i32 [[ABS_PLUS_ONE]], [[ARG]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %abs = tail call i32 @llvm.abs.i32(i32 %arg, i1 false)
  %abs_plus_one = add nuw i32 %abs, 1
  %cmp = icmp uge i32 %abs_plus_one, %arg
  ret i1 %cmp
}

define i1 @abs_constant_negative_arg() {
; CHECK-LABEL: define i1 @abs_constant_negative_arg() {
; CHECK-NEXT:    [[ABS:%.*]] = tail call i32 @llvm.abs.i32(i32 -3, i1 false)
; CHECK-NEXT:    [[CMP:%.*]] = icmp sge i32 [[ABS]], 3
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %abs = tail call i32 @llvm.abs.i32(i32 -3, i1 false)
  %cmp = icmp sge i32 %abs, 3
  ret i1 %cmp
}

define i1 @abs_constant_positive_arg() {
; CHECK-LABEL: define i1 @abs_constant_positive_arg() {
; CHECK-NEXT:    [[ABS:%.*]] = tail call i32 @llvm.abs.i32(i32 3, i1 false)
; CHECK-NEXT:    ret i1 true
;
  %abs = tail call i32 @llvm.abs.i32(i32 3, i1 false)
  %cmp = icmp sge i32 %abs, 3
  ret i1 %cmp
}

define i1 @abs_is_nonnegative_except_for_int_min_if_int_min_is_not_poison(i32 noundef %arg) {
; CHECK-LABEL: define i1 @abs_is_nonnegative_except_for_int_min_if_int_min_is_not_poison(
; CHECK-SAME: i32 noundef [[ARG:%.*]]) {
; CHECK-NEXT:    [[ABS:%.*]] = tail call i32 @llvm.abs.i32(i32 [[ARG]], i1 false)
; CHECK-NEXT:    [[CMP:%.*]] = icmp sge i32 [[ABS]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %abs = tail call i32 @llvm.abs.i32(i32 %arg, i1 false)
  %cmp = icmp sge i32 %abs, 0
  ret i1 %cmp
}

define i1 @abs_is_not_strictly_positive(i32 noundef %arg) {
; CHECK-LABEL: define i1 @abs_is_not_strictly_positive(
; CHECK-SAME: i32 noundef [[ARG:%.*]]) {
; CHECK-NEXT:    [[ABS:%.*]] = tail call i32 @llvm.abs.i32(i32 [[ARG]], i1 false)
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[ABS]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %abs = tail call i32 @llvm.abs.i32(i32 %arg, i1 false)
  %cmp = icmp sgt i32 %abs, 0
  ret i1 %cmp
}

define i1 @abs_is_nonnegative_int_min_is_not_poison(i32 noundef %arg) {
; CHECK-LABEL: define i1 @abs_is_nonnegative_int_min_is_not_poison(
; CHECK-SAME: i32 noundef [[ARG:%.*]]) {
; CHECK-NEXT:    [[ABS:%.*]] = tail call i32 @llvm.abs.i32(i32 [[ARG]], i1 false)
; CHECK-NEXT:    [[CMP:%.*]] = icmp sge i32 [[ABS]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %abs = tail call i32 @llvm.abs.i32(i32 %arg, i1 false)
  %cmp = icmp sge i32 %abs, 0
  ret i1 %cmp
}

define i1 @abs_is_nonnegative_int_min_is_poison(i32 noundef %arg) {
; CHECK-LABEL: define i1 @abs_is_nonnegative_int_min_is_poison(
; CHECK-SAME: i32 noundef [[ARG:%.*]]) {
; CHECK-NEXT:    [[ABS:%.*]] = tail call i32 @llvm.abs.i32(i32 [[ARG]], i1 true)
; CHECK-NEXT:    ret i1 true
;
  %abs = tail call i32 @llvm.abs.i32(i32 %arg, i1 true)
  %cmp = icmp sge i32 %abs, 0
  ret i1 %cmp
}

define i1 @abs_is_nonnegative_constant_arg() {
; CHECK-LABEL: define i1 @abs_is_nonnegative_constant_arg() {
; CHECK-NEXT:    [[ABS:%.*]] = tail call i32 @llvm.abs.i32(i32 -3, i1 true)
; CHECK-NEXT:    ret i1 true
;
  %abs = tail call i32 @llvm.abs.i32(i32 -3, i1 true)
  %cmp = icmp sge i32 %abs, 0
  ret i1 %cmp
}

declare i32 @llvm.abs.i32(i32, i1 immarg)
declare void @llvm.assume(i1)
