// RUN: llvm-mc -triple=amdgcn -mcpu=tonga -show-encoding %s | FileCheck %s

//---------------------------------------------------------------------------//
// VOP1/VOP3 F16
//---------------------------------------------------------------------------//

v_ceil_f16 v0, -1
// CHECK: [0xc1,0x8a,0x00,0x7e]

v_ceil_f16 v0, -2
// CHECK: [0xc2,0x8a,0x00,0x7e]

v_ceil_f16 v0, -16
// CHECK: [0xd0,0x8a,0x00,0x7e]

v_ceil_f16 v0, -0.5
// CHECK: [0xf1,0x8a,0x00,0x7e]

v_ceil_f16 v0, -1.0
// CHECK: [0xf3,0x8a,0x00,0x7e]

v_ceil_f16 v0, -2.0
// CHECK: [0xf5,0x8a,0x00,0x7e]

v_ceil_f16 v0, -4.0
// CHECK: [0xf7,0x8a,0x00,0x7e]

// Arbitrary f16 literal in hex
v_ceil_f16 v0, 0xabcd
// CHECK: [0xff,0x8a,0x00,0x7e,0xcd,0xab,0x00,0x00]

// '-' is a part of hex literal (not a 'neg' modifier)
v_ceil_f16 v0, -0x5433
// CHECK: [0xff,0x8a,0x00,0x7e,0xcd,0xab,0x00,0x00]

v_ceil_f16 v0, abs(0xabcd)
// CHECK: [0xff,0x8a,0x00,0x7e,0xcd,0x2b,0x00,0x00]

v_ceil_f16 v0, neg(0xabcd)
// CHECK: [0xff,0x8a,0x00,0x7e,0xcd,0x2b,0x00,0x00]

v_ceil_f16 v0, neg(abs(0xabcd))
// CHECK: [0xff,0x8a,0x00,0x7e,0xcd,0xab,0x00,0x00]

v_ceil_f16 v0, -abs(0xabcd)
// CHECK: [0xff,0x8a,0x00,0x7e,0xcd,0xab,0x00,0x00]

// 1/(2*pi) encoded as inline constant in VOP1
v_ceil_f16 v0, 0x3118
// CHECK: [0xf8,0x8a,0x00,0x7e]

// 1/(2*pi) encoded as inline constant in VOP3
v_ceil_f16_e64 v0, 0x3118
// CHECK: [0x00,0x00,0x85,0xd1,0xf8,0x00,0x00,0x00]

// neg(-1/(2*pi)) = 1/(2*pi)
v_ceil_f16 v0, neg(0xb118)
// CHECK: [0xf8,0x8a,0x00,0x7e]

// -1/(2*pi) cannot be encoded as inline constant in VOP1
v_ceil_f16 v0, 0xb118
// CHECK: [0xff,0x8a,0x00,0x7e,0x18,0xb1,0x00,0x00]

// -1/(2*pi) cannot be encoded as inline constant in VOP1
v_ceil_f16 v0, neg(0x3118)
// CHECK: [0xff,0x8a,0x00,0x7e,0x18,0xb1,0x00,0x00]

// -1/(2*pi) can be encoded as inline constant w/ modifiers in VOP3
v_ceil_f16_e64 v0, neg(0x3118)
// CHECK: [0x00,0x00,0x85,0xd1,0xf8,0x00,0x00,0x20]

v_ceil_f16_e64 v0, abs(0x3118)
// CHECK: 0x00,0x01,0x85,0xd1,0xf8,0x00,0x00,0x00]

v_ceil_f16_e64 v0, neg(abs(0x3118))
// CHECK: [0x00,0x01,0x85,0xd1,0xf8,0x00,0x00,0x20]

v_ceil_f16_e64 v0, neg(|v1|)
// CHECK: [0x00,0x01,0x85,0xd1,0x01,0x01,0x00,0x20]

v_ceil_f16_e64 v0, -|v1|
// CHECK: [0x00,0x01,0x85,0xd1,0x01,0x01,0x00,0x20]

//---------------------------------------------------------------------------//
// VOP1/VOP3 F64
//---------------------------------------------------------------------------//

// Encoded as inline constant 1 with 'neg' modifier
v_ceil_f64 v[0:1], neg(1)
// CHECK: [0x00,0x00,0x58,0xd1,0x81,0x00,0x00,0x20]

// Encoded as inline constant -1 with 'neg' modifier
v_ceil_f64 v[0:1], neg(-1)
// CHECK: [0x00,0x00,0x58,0xd1,0xc1,0x00,0x00,0x20]

v_ceil_f64_e32 v[0:1], 1.0
// CHECK: [0xf2,0x30,0x00,0x7e]

// abs(1.0) = 1.0
v_ceil_f64_e32 v[0:1], abs(1.0)
// CHECK: [0xf2,0x30,0x00,0x7e]

// neg(1.0) = -1.0
v_ceil_f64_e32 v[0:1], neg(1.0)
// CHECK: [0xf3,0x30,0x00,0x7e]

// 1/(2*pi) encoded as inline constant in VOP1
v_ceil_f64 v[0:1], 0x3fc45f306dc9c882
// CHECK: [0xf8,0x30,0x00,0x7e]

// 1/(2*pi) encoded as inline constant in VOP3
v_ceil_f64_e64 v[0:1], 0x3fc45f306dc9c882
// CHECK: [0x00,0x00,0x58,0xd1,0xf8,0x00,0x00,0x00]

// -1/(2*pi) cannot be encoded as inline constant in VOP1.
// It cannot be encoded as literal either due to int literal rules.
// So it is encoded as VOP3
v_ceil_f64 v[0:1], abs(0x3fc45f306dc9c882)
// CHECK: [0x00,0x01,0x58,0xd1,0xf8,0x00,0x00,0x00]

v_ceil_f64 v[0:1], neg(abs(0x3fc45f306dc9c882))
// CHECK: [0x00,0x01,0x58,0xd1,0xf8,0x00,0x00,0x20]


//---------------------------------------------------------------------------//
// VOP2/VOP3 F32
//---------------------------------------------------------------------------//

v_add_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x02]

v_add_f32 v5, -16, v2
// CHECK: [0xd0,0x04,0x0a,0x02]

v_add_f32 v5, 0x3e22f983, v2
// CHECK: [0xf8,0x04,0x0a,0x02]

// abs(1/(2*pi)) = 1/(2*pi)
v_add_f32 v5, abs(0x3e22f983), v2
// CHECK: [0xf8,0x04,0x0a,0x02]

// neg(-1/(2*pi)) = 1/(2*pi)
v_add_f32 v5, neg(0xbe22f983), v2
// CHECK: [0xf8,0x04,0x0a,0x02]

// -1/(2*pi) cannot be encoded as inline constant in VOP1
v_add_f32 v5, neg(0x3e22f983), v2
// CHECK: [0xff,0x04,0x0a,0x02,0x83,0xf9,0x22,0xbe]


v_add_f32_e64 v0, -2, s0
// CHECK: [0x00,0x00,0x01,0xd1,0xc2,0x00,0x00,0x00]

v_add_f32_e64 v0, -16, s0
// CHECK: [0x00,0x00,0x01,0xd1,0xd0,0x00,0x00,0x00]

v_add_f32_e64 v0, -0.5, s0
// CHECK: [0x00,0x00,0x01,0xd1,0xf1,0x00,0x00,0x00]

v_add_f32_e64 v0, -1.0, s0
// CHECK: [0x00,0x00,0x01,0xd1,0xf3,0x00,0x00,0x00]

v_add_f32_e64 v0, -2.0, s0
// CHECK: [0x00,0x00,0x01,0xd1,0xf5,0x00,0x00,0x00]

v_add_f32_e64 v0, -4.0, s0
// CHECK: [0x00,0x00,0x01,0xd1,0xf7,0x00,0x00,0x00]

v_add_f32_e64 v0, 0x3e22f983, s0
// CHECK: [0x00,0x00,0x01,0xd1,0xf8,0x00,0x00,0x00]

v_add_f32_e64 v0, neg(0x3e22f983), s0
// CHECK: [0x00,0x00,0x01,0xd1,0xf8,0x00,0x00,0x20]

//---------------------------------------------------------------------------//
// VOPC/VOP3
//---------------------------------------------------------------------------//

v_cmp_eq_f16 vcc, -1, v0
// CHECK: [0xc1,0x00,0x44,0x7c]

v_cmp_eq_f16_e64 s[0:1], s0, -1
// CHECK: [0x00,0x00,0x22,0xd0,0x00,0x82,0x01,0x00]

v_cmp_eq_f16_e64 s[0:1], s0, 0x3118
// CHECK: [0x00,0x00,0x22,0xd0,0x00,0xf0,0x01,0x00]

v_cmp_eq_f16_e64 s[0:1], s0, neg(0x3118)
// CHECK: [0x00,0x00,0x22,0xd0,0x00,0xf0,0x01,0x40]

v_cmp_eq_f32 vcc, -4.0, v0
// CHECK: [0xf7,0x00,0x84,0x7c]

// 1/(2*pi) can be encoded as inline constant
v_cmp_eq_f32 vcc, 0x3e22f983, v0
// CHECK: [0xf8,0x00,0x84,0x7c]

// -1/(2*pi) cannot be encoded as inline constant in VOPC
v_cmp_eq_f32 vcc, neg(0x3e22f983), v0
// CHECK: [0xff,0x00,0x84,0x7c,0x83,0xf9,0x22,0xbe]

// abs(1/(2*pi)) = 1/(2*pi)
v_cmp_eq_f32 vcc, abs(0x3e22f983), v0
// CHECK: [0xf8,0x00,0x84,0x7c]

// -1/(2*pi) can be encoded as inline constant w/ modifiers in VOP3
v_cmp_eq_f32_e64 vcc, neg(0x3e22f983), v0
// CHECK: [0x6a,0x00,0x42,0xd0,0xf8,0x00,0x02,0x20]

v_cmp_eq_f32_e64 vcc, v0, abs(0x3e22f983)
// CHECK: [0x6a,0x02,0x42,0xd0,0x00,0xf1,0x01,0x00]

v_cmp_eq_f32_e64 vcc, v0, -abs(0x3e22f983)
// CHECK: [0x6a,0x02,0x42,0xd0,0x00,0xf1,0x01,0x40]

//---------------------------------------------------------------------------//
// VOP3
//---------------------------------------------------------------------------//

v_add_f64 v[0:1], s[0:1], -1
// CHECK: [0x00,0x00,0x80,0xd2,0x00,0x82,0x01,0x00]

v_add_f64 v[0:1], s[0:1], -16
// CHECK: [0x00,0x00,0x80,0xd2,0x00,0xa0,0x01,0x00]

v_add_f64 v[0:1], s[0:1], -0.5
// CHECK: [0x00,0x00,0x80,0xd2,0x00,0xe2,0x01,0x00]

v_add_f64 v[0:1], s[0:1], -1.0
// CHECK: [0x00,0x00,0x80,0xd2,0x00,0xe6,0x01,0x00]

v_add_f64 v[0:1], s[0:1], -2.0
// CHECK: [0x00,0x00,0x80,0xd2,0x00,0xea,0x01,0x00]

v_add_f64 v[0:1], s[0:1], -4.0
// CHECK: [0x00,0x00,0x80,0xd2,0x00,0xee,0x01,0x00]

v_add_f64 v[4:5], s[0:1], 0x3fc45f306dc9c882
// CHECK: [0x04,0x00,0x80,0xd2,0x00,0xf0,0x01,0x00]

v_add_f64 v[4:5], s[0:1], neg(0x3fc45f306dc9c882)
// CHECK: [0x04,0x00,0x80,0xd2,0x00,0xf0,0x01,0x40]


v_cubeid_f32 v0, s0, s0, -1
// CHECK: [0x00,0x00,0xc4,0xd1,0x00,0x00,0x04,0x03]

v_cubeid_f32 v0, s0, s0, -4.0
// CHECK: [0x00,0x00,0xc4,0xd1,0x00,0x00,0xdc,0x03]

v_cubeid_f32 v0, s0, s0, 0x3e22f983
// CHECK: [0x00,0x00,0xc4,0xd1,0x00,0x00,0xe0,0x03]

v_cubeid_f32 v0, s0, s0, neg(0x3e22f983)
// CHECK: [0x00,0x00,0xc4,0xd1,0x00,0x00,0xe0,0x83]

v_cubeid_f32 v0, s0, s0, abs(0x3e22f983)
// CHECK: [0x00,0x04,0xc4,0xd1,0x00,0x00,0xe0,0x03]


//---------------------------------------------------------------------------//
// VOP3 Instructions without Input Modifiers but with Output Modifiers
//---------------------------------------------------------------------------//

v_cvt_f64_i32_e64 v[5:6], s1 clamp
// CHECK: [0x05,0x80,0x44,0xd1,0x01,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], s1 mul:2
// CHECK: [0x05,0x00,0x44,0xd1,0x01,0x00,0x00,0x08]

v_cvt_f64_i32_e64 v[5:6], s1 mul:4
// CHECK: [0x05,0x00,0x44,0xd1,0x01,0x00,0x00,0x10]

v_cvt_f64_i32_e64 v[5:6], s1 div:2
// CHECK: [0x05,0x00,0x44,0xd1,0x01,0x00,0x00,0x18]


v_cvt_f64_u32_e64 v[5:6], s1 clamp
// CHECK: [0x05,0x80,0x56,0xd1,0x01,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], s1 mul:2
// CHECK: [0x05,0x00,0x56,0xd1,0x01,0x00,0x00,0x08]

v_cvt_f64_u32_e64 v[5:6], s1 mul:4
// CHECK: [0x05,0x00,0x56,0xd1,0x01,0x00,0x00,0x10]

v_cvt_f64_u32_e64 v[5:6], s1 div:2
// CHECK: [0x05,0x00,0x56,0xd1,0x01,0x00,0x00,0x18]


v_cvt_f32_i32_e64 v5, s1 clamp
// CHECK: [0x05,0x80,0x45,0xd1,0x01,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, s1 mul:2
// CHECK: [0x05,0x00,0x45,0xd1,0x01,0x00,0x00,0x08]

v_cvt_f32_i32_e64 v5, s1 mul:4
// CHECK: [0x05,0x00,0x45,0xd1,0x01,0x00,0x00,0x10]

v_cvt_f32_i32_e64 v5, s1 div:2
// CHECK: [0x05,0x00,0x45,0xd1,0x01,0x00,0x00,0x18]


v_cvt_f32_u32_e64 v5, s1 clamp
// CHECK: [0x05,0x80,0x46,0xd1,0x01,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, s1 mul:2
// CHECK: [0x05,0x00,0x46,0xd1,0x01,0x00,0x00,0x08]

v_cvt_f32_u32_e64 v5, s1 mul:4
// CHECK: [0x05,0x00,0x46,0xd1,0x01,0x00,0x00,0x10]

v_cvt_f32_u32_e64 v5, s1 div:2
// CHECK: [0x05,0x00,0x46,0xd1,0x01,0x00,0x00,0x18]


v_cvt_off_f32_i4_e64 v5, s1 clamp
// CHECK: [0x05,0x80,0x4e,0xd1,0x01,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, s1 mul:2
// CHECK: [0x05,0x00,0x4e,0xd1,0x01,0x00,0x00,0x08]

v_cvt_off_f32_i4_e64 v5, s1 mul:4
// CHECK: [0x05,0x00,0x4e,0xd1,0x01,0x00,0x00,0x10]

v_cvt_off_f32_i4_e64 v5, s1 div:2
// CHECK: [0x05,0x00,0x4e,0xd1,0x01,0x00,0x00,0x18]


v_cvt_f32_ubyte0_e64 v5, s1 clamp
// CHECK: [0x05,0x80,0x51,0xd1,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, s1 mul:2
// CHECK: [0x05,0x00,0x51,0xd1,0x01,0x00,0x00,0x08]

v_cvt_f32_ubyte0_e64 v5, s1 mul:4
// CHECK: [0x05,0x00,0x51,0xd1,0x01,0x00,0x00,0x10]

v_cvt_f32_ubyte0_e64 v5, s1 div:2
// CHECK: [0x05,0x00,0x51,0xd1,0x01,0x00,0x00,0x18]


v_cvt_f32_ubyte1_e64 v5, s1 clamp
// CHECK: [0x05,0x80,0x52,0xd1,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, s1 mul:2
// CHECK: [0x05,0x00,0x52,0xd1,0x01,0x00,0x00,0x08]

v_cvt_f32_ubyte1_e64 v5, s1 mul:4
// CHECK: [0x05,0x00,0x52,0xd1,0x01,0x00,0x00,0x10]

v_cvt_f32_ubyte1_e64 v5, s1 div:2
// CHECK: [0x05,0x00,0x52,0xd1,0x01,0x00,0x00,0x18]


v_cvt_f32_ubyte2_e64 v5, s1 clamp
// CHECK: [0x05,0x80,0x53,0xd1,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, s1 mul:2
// CHECK: [0x05,0x00,0x53,0xd1,0x01,0x00,0x00,0x08]

v_cvt_f32_ubyte2_e64 v5, s1 mul:4
// CHECK: [0x05,0x00,0x53,0xd1,0x01,0x00,0x00,0x10]

v_cvt_f32_ubyte2_e64 v5, s1 div:2
// CHECK: [0x05,0x00,0x53,0xd1,0x01,0x00,0x00,0x18]


v_cvt_f32_ubyte3_e64 v5, s1 clamp
// CHECK: [0x05,0x80,0x54,0xd1,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, s1 mul:2
// CHECK: [0x05,0x00,0x54,0xd1,0x01,0x00,0x00,0x08]

v_cvt_f32_ubyte3_e64 v5, s1 mul:4
// CHECK: [0x05,0x00,0x54,0xd1,0x01,0x00,0x00,0x10]

v_cvt_f32_ubyte3_e64 v5, s1 div:2
// CHECK: [0x05,0x00,0x54,0xd1,0x01,0x00,0x00,0x18]


// NB: output modifiers are not supported for f16
v_cvt_f16_i16_e64 v5, s1 clamp
// CHECK: [0x05,0x80,0x7a,0xd1,0x01,0x00,0x00,0x00]

// NB: output modifiers are not supported for f16
v_cvt_f16_u16_e64 v5, s1 clamp
// CHECK: [0x05,0x80,0x79,0xd1,0x01,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, s1 noclamp
// CHECK: [0x05,0x00,0x79,0xd1,0x01,0x00,0x00,0x00]
