; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt < %s -S -passes='msan' -msan-poison-undef-vectors=true  2>&1 | FileCheck %s --check-prefixes=CHECK,CHECK-PRECISE
; RUN: opt < %s -S -passes='msan' -msan-poison-undef-vectors=false 2>&1 | FileCheck %s --check-prefixes=CHECK,CHECK-IMPRECISE
;
; Regression test case for computing shadows of partially poisoned vectors.
; Partially poisoned structs and arrays are not correctly implemented.

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

define <2 x i64> @left_poison(ptr %add.ptr) sanitize_memory {
; CHECK-LABEL: define <2 x i64> @left_poison(
; CHECK-SAME: ptr [[ADD_PTR:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-PRECISE:   store <2 x i64> <i64 -1, i64 0>, ptr @__msan_retval_tls, align 8
; CHECK-IMPRECISE: store <2 x i64> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i64> <i64 poison, i64 42>
;
  ret <2 x i64> <i64 poison, i64 42>
}

define <2 x i64> @right_poison(ptr %add.ptr) sanitize_memory {
; CHECK-LABEL: define <2 x i64> @right_poison(
; CHECK-SAME: ptr [[ADD_PTR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-PRECISE:   store <2 x i64> <i64 0, i64 -1>, ptr @__msan_retval_tls, align 8
; CHECK-IMPRECISE: store <2 x i64> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i64> <i64 42, i64 poison>
;
  ret <2 x i64> <i64 42, i64 poison>
}

define <2 x i64> @full_poison(ptr %add.ptr) sanitize_memory {
; CHECK-LABEL: define <2 x i64> @full_poison(
; CHECK-SAME: ptr [[ADD_PTR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    store <2 x i64> splat (i64 -1), ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i64> poison
;
  ret <2 x i64> <i64 poison, i64 poison>
}

define <2 x i64> @no_poison_or_undef(ptr %add.ptr) sanitize_memory {
; CHECK-LABEL: define <2 x i64> @no_poison_or_undef(
; CHECK-SAME: ptr [[ADD_PTR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    store <2 x i64> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i64> splat (i64 42)
;
  ret <2 x i64> <i64 42, i64 42>
}

define <2 x i64> @left_undef(ptr %add.ptr) sanitize_memory {
; CHECK-LABEL: define <2 x i64> @left_undef(
; CHECK-SAME: ptr [[ADD_PTR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-PRECISE:   store <2 x i64> <i64 -1, i64 0>, ptr @__msan_retval_tls, align 8
; CHECK-IMPRECISE: store <2 x i64> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i64> <i64 undef, i64 42>
;
  ret <2 x i64> <i64 undef, i64 42>
}

define <2 x i64> @right_undef(ptr %add.ptr) sanitize_memory {
; CHECK-LABEL: define <2 x i64> @right_undef(
; CHECK-SAME: ptr [[ADD_PTR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-PRECISE:   store <2 x i64> <i64 0, i64 -1>, ptr @__msan_retval_tls, align 8
; CHECK-IMPRECISE: store <2 x i64> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i64> <i64 42, i64 undef>
;
  ret <2 x i64> <i64 42, i64 undef>
}

define <2 x i64> @full_undef(ptr %add.ptr) sanitize_memory {
; CHECK-LABEL: define <2 x i64> @full_undef(
; CHECK-SAME: ptr [[ADD_PTR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    store <2 x i64> splat (i64 -1), ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x i64> undef
;
  ret <2 x i64> <i64 undef, i64 undef>
}

define {i64, i64}  @struct_left_undef() sanitize_memory {
; CHECK-LABEL: define { i64, i64 } @struct_left_undef(
; CHECK-SAME: ) #[[ATTR0]] {
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    store { i64, i64 } zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret { i64, i64 } { i64 undef, i64 42 }
;
  ret {i64, i64} { i64 undef, i64 42 }
}

define [2x i64]  @array_right_undef() sanitize_memory {
; CHECK-LABEL: define [2 x i64] @array_right_undef(
; CHECK-SAME: ) #[[ATTR0]] {
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    store [2 x i64] zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret [2 x i64] [i64 42, i64 undef]
; 
  ret [2x i64] [ i64 42, i64 undef ]
}
