; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+ssse3 | FileCheck %s --check-prefixes=SSE,SSSE3
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE,SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX

;
; Partial Vector Loads - PR16739
;

define <4 x float> @load_float4_float3(ptr nocapture readonly dereferenceable(16)) nofree nosync {
; SSE-LABEL: load_float4_float3:
; SSE:       # %bb.0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: load_float4_float3:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovups (%rdi), %xmm0
; AVX-NEXT:    retq
  %p1 = getelementptr inbounds <4 x float>, ptr %0, i64 0, i64 1
  %p2 = getelementptr inbounds <4 x float>, ptr %0, i64 0, i64 2
  %ld0 = load float, ptr %0, align 4
  %ld1 = load float, ptr %p1, align 4
  %ld2 = load float, ptr %p2, align 4
  %r0 = insertelement <4 x float> undef, float %ld0, i32 0
  %r1 = insertelement <4 x float> %r0,   float %ld1, i32 1
  %r2 = insertelement <4 x float> %r1,   float %ld2, i32 2
  ret <4 x float> %r2
}

define <4 x float> @load_float4_float3_0122(ptr nocapture readonly dereferenceable(16)) nofree nosync {
; SSE-LABEL: load_float4_float3_0122:
; SSE:       # %bb.0:
; SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0,0]
; SSE-NEXT:    retq
;
; AVX-LABEL: load_float4_float3_0122:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX-NEXT:    vmovups (%rdi), %xmm1
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm1[0,1],xmm0[0,0]
; AVX-NEXT:    retq
  %p1 = getelementptr inbounds <4 x float>, ptr %0, i64 0, i64 1
  %p2 = getelementptr inbounds <4 x float>, ptr %0, i64 0, i64 2
  %ld0 = load float, ptr %0, align 4
  %ld1 = load float, ptr %p1, align 4
  %ld2 = load float, ptr %p2, align 4
  %r0 = insertelement <4 x float> undef, float %ld0, i32 0
  %r1 = insertelement <4 x float> %r0,   float %ld1, i32 1
  %r2 = insertelement <4 x float> %r1,   float %ld2, i32 2
  %r3 = insertelement <4 x float> %r2,   float %ld2, i32 3
  ret <4 x float> %r3
}

define <8 x float> @load_float8_float3(ptr nocapture readonly dereferenceable(16)) nofree nosync {
; SSE-LABEL: load_float8_float3:
; SSE:       # %bb.0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: load_float8_float3:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovups (%rdi), %xmm0
; AVX-NEXT:    retq
  %p1 = getelementptr inbounds <4 x float>, ptr %0, i64 0, i64 1
  %p2 = getelementptr inbounds <4 x float>, ptr %0, i64 0, i64 2
  %ld0 = load float, ptr %0, align 4
  %ld1 = load float, ptr %p1, align 4
  %ld2 = load float, ptr %p2, align 4
  %r0 = insertelement <8 x float> undef, float %ld0, i32 0
  %r1 = insertelement <8 x float> %r0,   float %ld1, i32 1
  %r2 = insertelement <8 x float> %r1,   float %ld2, i32 2
  ret <8 x float> %r2
}

define <8 x float> @load_float8_float3_0122(ptr nocapture readonly dereferenceable(16)) nofree nosync {
; SSE-LABEL: load_float8_float3_0122:
; SSE:       # %bb.0:
; SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0,0]
; SSE-NEXT:    retq
;
; AVX-LABEL: load_float8_float3_0122:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX-NEXT:    vmovups (%rdi), %xmm1
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm1[0,1],xmm0[0,0]
; AVX-NEXT:    retq
  %p1 = getelementptr inbounds <4 x float>, ptr %0, i64 0, i64 1
  %p2 = getelementptr inbounds <4 x float>, ptr %0, i64 0, i64 2
  %ld0 = load float, ptr %0, align 4
  %ld1 = load float, ptr %p1, align 4
  %ld2 = load float, ptr %p2, align 4
  %r0 = insertelement <8 x float> undef, float %ld0, i32 0
  %r1 = insertelement <8 x float> %r0,   float %ld1, i32 1
  %r2 = insertelement <8 x float> %r1,   float %ld2, i32 2
  %r3 = insertelement <8 x float> %r2,   float %ld2, i32 3
  ret <8 x float> %r3
}

define <4 x float> @load_float4_float3_as_float2_float(ptr nocapture readonly dereferenceable(16)) nofree nosync {
; SSE-LABEL: load_float4_float3_as_float2_float:
; SSE:       # %bb.0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: load_float4_float3_as_float2_float:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovups (%rdi), %xmm0
; AVX-NEXT:    retq
  %2 = load <2 x float>, ptr %0, align 4
  %3 = extractelement <2 x float> %2, i32 0
  %4 = insertelement <4 x float> undef, float %3, i32 0
  %5 = extractelement <2 x float> %2, i32 1
  %6 = insertelement <4 x float> %4, float %5, i32 1
  %7 = getelementptr inbounds <4 x float>, ptr %0, i64 0, i64 2
  %8 = load float, ptr %7, align 4
  %9 = insertelement <4 x float> %6, float %8, i32 2
  ret <4 x float> %9
}

define <4 x float> @load_float4_float3_as_float2_float_0122(ptr nocapture readonly dereferenceable(16)) nofree nosync {
; SSE-LABEL: load_float4_float3_as_float2_float_0122:
; SSE:       # %bb.0:
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0,0]
; SSE-NEXT:    retq
;
; AVX-LABEL: load_float4_float3_as_float2_float_0122:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0,0]
; AVX-NEXT:    retq
  %2 = load <2 x float>, ptr %0, align 4
  %3 = extractelement <2 x float> %2, i32 0
  %4 = insertelement <4 x float> undef, float %3, i32 0
  %5 = extractelement <2 x float> %2, i32 1
  %6 = insertelement <4 x float> %4, float %5, i32 1
  %7 = getelementptr inbounds <4 x float>, ptr %0, i64 0, i64 2
  %8 = load float, ptr %7, align 4
  %9 = insertelement <4 x float> %6, float %8, i32 2
  %10 = insertelement <4 x float> %9, float %8, i32 3
  ret <4 x float> %10
}

define <4 x float> @load_float4_float3_trunc(ptr nocapture readonly dereferenceable(16)) {
; SSE-LABEL: load_float4_float3_trunc:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: load_float4_float3_trunc:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rdi), %xmm0
; AVX-NEXT:    retq
  %2 = load i64, ptr %0, align 16
  %3 = getelementptr inbounds <4 x float>, ptr %0, i64 0, i64 2
  %4 = load i64, ptr %3, align 8
  %5 = trunc i64 %2 to i32
  %6 = bitcast i32 %5 to float
  %7 = insertelement <4 x float> undef, float %6, i32 0
  %8 = lshr i64 %2, 32
  %9 = trunc i64 %8 to i32
  %10 = bitcast i32 %9 to float
  %11 = insertelement <4 x float> %7, float %10, i32 1
  %12 = trunc i64 %4 to i32
  %13 = bitcast i32 %12 to float
  %14 = insertelement <4 x float> %11, float %13, i32 2
  ret <4 x float> %14
}

define <4 x float> @load_float4_float3_trunc_0122(ptr nocapture readonly dereferenceable(16)) nofree nosync {
; SSE-LABEL: load_float4_float3_trunc_0122:
; SSE:       # %bb.0:
; SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0,0]
; SSE-NEXT:    retq
;
; AVX-LABEL: load_float4_float3_trunc_0122:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX-NEXT:    vmovaps (%rdi), %xmm1
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm1[0,1],xmm0[0,0]
; AVX-NEXT:    retq
  %2 = load i64, ptr %0, align 16
  %3 = getelementptr inbounds <4 x float>, ptr %0, i64 0, i64 2
  %4 = load i64, ptr %3, align 8
  %5 = trunc i64 %2 to i32
  %6 = bitcast i32 %5 to float
  %7 = insertelement <4 x float> undef, float %6, i32 0
  %8 = lshr i64 %2, 32
  %9 = trunc i64 %8 to i32
  %10 = bitcast i32 %9 to float
  %11 = insertelement <4 x float> %7, float %10, i32 1
  %12 = trunc i64 %4 to i32
  %13 = bitcast i32 %12 to float
  %14 = insertelement <4 x float> %11, float %13, i32 2
  %15 = insertelement <4 x float> %14, float %13, i32 3
  ret <4 x float> %15
}

define <4 x float> @load_float4_float3_trunc_0123(ptr nocapture readonly dereferenceable(16)) nofree nosync {
; SSE2-LABEL: load_float4_float3_trunc_0123:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movhps {{.*#+}} xmm0 = xmm0[0,1],mem[0,1]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: load_float4_float3_trunc_0123:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movaps (%rdi), %xmm0
; SSSE3-NEXT:    movhps {{.*#+}} xmm0 = xmm0[0,1],mem[0,1]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: load_float4_float3_trunc_0123:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movaps (%rdi), %xmm0
; SSE41-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1],mem[0],xmm0[3]
; SSE41-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0]
; SSE41-NEXT:    retq
;
; AVX-LABEL: load_float4_float3_trunc_0123:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rdi), %xmm0
; AVX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1],mem[0],xmm0[3]
; AVX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0]
; AVX-NEXT:    retq
  %2 = load i64, ptr %0, align 16
  %3 = getelementptr inbounds <4 x float>, ptr %0, i64 0, i64 2
  %4 = load i64, ptr %3, align 8
  %5 = trunc i64 %2 to i32
  %6 = bitcast i32 %5 to float
  %7 = insertelement <4 x float> undef, float %6, i32 0
  %8 = lshr i64 %2, 32
  %9 = trunc i64 %8 to i32
  %10 = bitcast i32 %9 to float
  %11 = insertelement <4 x float> %7, float %10, i32 1
  %12 = trunc i64 %4 to i32
  %13 = bitcast i32 %12 to float
  %14 = insertelement <4 x float> %11, float %13, i32 2
  %15 = lshr i64 %4, 32
  %16 = trunc i64 %15 to i32
  %17 = bitcast i32 %16 to float
  %18 = insertelement <4 x float> %14, float %17, i32 3
  ret <4 x float> %18
}

define <4 x float> @load_float4_float3_trunc_0123_unaligned(ptr nocapture readonly dereferenceable(16)) nofree nosync {
; SSE2-LABEL: load_float4_float3_trunc_0123_unaligned:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movups (%rdi), %xmm0
; SSE2-NEXT:    movhps {{.*#+}} xmm0 = xmm0[0,1],mem[0,1]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: load_float4_float3_trunc_0123_unaligned:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movups (%rdi), %xmm0
; SSSE3-NEXT:    movhps {{.*#+}} xmm0 = xmm0[0,1],mem[0,1]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: load_float4_float3_trunc_0123_unaligned:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movups (%rdi), %xmm0
; SSE41-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1],mem[0],xmm0[3]
; SSE41-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0]
; SSE41-NEXT:    retq
;
; AVX-LABEL: load_float4_float3_trunc_0123_unaligned:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovups (%rdi), %xmm0
; AVX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1],mem[0],xmm0[3]
; AVX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0]
; AVX-NEXT:    retq
  %2 = load i64, ptr %0, align 1
  %3 = getelementptr inbounds <4 x float>, ptr %0, i64 0, i64 2
  %4 = load i64, ptr %3, align 1
  %5 = trunc i64 %2 to i32
  %6 = bitcast i32 %5 to float
  %7 = insertelement <4 x float> undef, float %6, i32 0
  %8 = lshr i64 %2, 32
  %9 = trunc i64 %8 to i32
  %10 = bitcast i32 %9 to float
  %11 = insertelement <4 x float> %7, float %10, i32 1
  %12 = trunc i64 %4 to i32
  %13 = bitcast i32 %12 to float
  %14 = insertelement <4 x float> %11, float %13, i32 2
  %15 = lshr i64 %4, 32
  %16 = trunc i64 %15 to i32
  %17 = bitcast i32 %16 to float
  %18 = insertelement <4 x float> %14, float %17, i32 3
  ret <4 x float> %18
}

; PR21780
define <4 x double> @load_double4_0u2u(ptr nocapture readonly dereferenceable(32)) nofree nosync {
; SSE2-LABEL: load_double4_0u2u:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE2-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; SSE2-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0,0]
; SSE2-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0,0]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: load_double4_0u2u:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movddup {{.*#+}} xmm0 = mem[0,0]
; SSSE3-NEXT:    movddup {{.*#+}} xmm1 = mem[0,0]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: load_double4_0u2u:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movddup {{.*#+}} xmm0 = mem[0,0]
; SSE41-NEXT:    movddup {{.*#+}} xmm1 = mem[0,0]
; SSE41-NEXT:    retq
;
; AVX-LABEL: load_double4_0u2u:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovddup {{.*#+}} ymm0 = mem[0,0,2,2]
; AVX-NEXT:    retq
  %2 = load double, ptr %0, align 8
  %3 = insertelement <4 x double> undef, double %2, i32 0
  %4 = getelementptr inbounds double, ptr %0, i64 2
  %5 = load double, ptr %4, align 8
  %6 = insertelement <4 x double> %3, double %5, i32 2
  %7 = shufflevector <4 x double> %6, <4 x double> undef, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  ret <4 x double> %7
}

; Test case identified in rL366501
@h = dso_local local_unnamed_addr global i8 0, align 1
define dso_local i32 @load_partial_illegal_type()  {
; SSE2-LABEL: load_partial_illegal_type:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movzwl h(%rip), %eax
; SSE2-NEXT:    movd %eax, %xmm0
; SSE2-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    por {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: load_partial_illegal_type:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movzwl h(%rip), %eax
; SSSE3-NEXT:    movd %eax, %xmm0
; SSSE3-NEXT:    pshufb {{.*#+}} xmm0 = xmm0[0,1],zero,xmm0[3,u,u,u,u,u,u,u,u,u,u,u,u]
; SSSE3-NEXT:    por {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSSE3-NEXT:    movd %xmm0, %eax
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: load_partial_illegal_type:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movzwl h(%rip), %eax
; SSE41-NEXT:    movd %eax, %xmm0
; SSE41-NEXT:    movl $2, %eax
; SSE41-NEXT:    pinsrb $2, %eax, %xmm0
; SSE41-NEXT:    movd %xmm0, %eax
; SSE41-NEXT:    retq
;
; AVX-LABEL: load_partial_illegal_type:
; AVX:       # %bb.0:
; AVX-NEXT:    movzwl h(%rip), %eax
; AVX-NEXT:    vmovd %eax, %xmm0
; AVX-NEXT:    movl $2, %eax
; AVX-NEXT:    vpinsrb $2, %eax, %xmm0, %xmm0
; AVX-NEXT:    vmovd %xmm0, %eax
; AVX-NEXT:    retq
  %1 = load <2 x i8>, ptr @h, align 1
  %2 = shufflevector <2 x i8> %1, <2 x i8> undef, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %3 = insertelement <4 x i8> %2, i8 2, i32 2
  %4 = bitcast <4 x i8> %3 to i32
  ret i32 %4
}

define dso_local void @PR43227(ptr %explicit_0, ptr %explicit_1) {
; SSE-LABEL: PR43227:
; SSE:       # %bb.0:
; SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    xorps %xmm0, %xmm0
; SSE-NEXT:    movaps %xmm0, 672(%rsi)
; SSE-NEXT:    movaps %xmm1, 688(%rsi)
; SSE-NEXT:    retq
;
; AVX-LABEL: PR43227:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vmovaps %ymm0, 672(%rsi)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
  %1 = getelementptr i32, ptr %explicit_0, i64 63
  %2 = load <3 x i32>, ptr %1, align 1
  %3 = shufflevector <3 x i32> %2, <3 x i32> undef, <2 x i32> <i32 1, i32 2>
  %4 = shufflevector <2 x i32> %3, <2 x i32> undef, <8 x i32> <i32 0, i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5 = shufflevector <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 undef, i32 0, i32 undef, i32 0>, <8 x i32> %4, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 5, i32 9, i32 7>
  %6 = getelementptr inbounds <8 x i32>, ptr %explicit_1, i64 21
  store <8 x i32> %5, ptr %6, align 32
  ret void
}
