; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 | FileCheck %s

; Test 128-bit rotate by constant amount.
define i128 @f1(i128 %val) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vrepib %v1, 100
; CHECK-NEXT:    vsrlb %v2, %v0, %v1
; CHECK-NEXT:    vsrl %v1, %v2, %v1
; CHECK-NEXT:    vrepib %v2, 28
; CHECK-NEXT:    vslb %v0, %v0, %v2
; CHECK-NEXT:    vsl %v0, %v0, %v2
; CHECK-NEXT:    vo %v0, %v0, %v1
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14

  %parta = shl i128 %val, 28
  %partb = lshr i128 %val, 100

  %rotl = or i128 %parta, %partb

  ret i128 %rotl
}

; Test 128-bit rotate by constant amount (full bytes).
define i128 @f2(i128 %val) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vsldb %v0, %v0, %v0, 4
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14

  %parta = shl i128 %val, 32
  %partb = lshr i128 %val, 96

  %rotl = or i128 %parta, %partb

  ret i128 %rotl
}

; Test 128-bit rotate by variable amount.
define i128 @f3(i128 %val, i128 %amt) {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    l %r0, 12(%r4)
; CHECK-NEXT:    vlvgp %v1, %r0, %r0
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vrepb %v1, %v1, 15
; CHECK-NEXT:    vslb %v2, %v0, %v1
; CHECK-NEXT:    vsl %v1, %v2, %v1
; CHECK-NEXT:    vrepib %v2, 1
; CHECK-NEXT:    xilf %r0, 4294967295
; CHECK-NEXT:    vsrl %v0, %v0, %v2
; CHECK-NEXT:    vlvgp %v2, %r0, %r0
; CHECK-NEXT:    vrepb %v2, %v2, 15
; CHECK-NEXT:    vsrlb %v0, %v0, %v2
; CHECK-NEXT:    vsrl %v0, %v0, %v2
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14

  %inv = sub i128 128, %amt
  %parta = shl i128 %val, %amt
  %partb = lshr i128 %val, %inv

  %rotl = or i128 %parta, %partb

  ret i128 %rotl
}

