; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=riscv32 -mattr=+xmipscbop -mattr=+m -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32XMIPSPREFETCH
; RUN: llc -mtriple=riscv64 -mattr=+xmipscbop -mattr=+m -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64XMIPSPREFETCH

define void @prefetch_data_read(ptr noundef %ptr) nounwind {
; RV32XMIPSPREFETCH-LABEL: prefetch_data_read:
; RV32XMIPSPREFETCH:       # %bb.0: # %entry
; RV32XMIPSPREFETCH-NEXT:    mips.pref 8, 1(a0)
; RV32XMIPSPREFETCH-NEXT:    ret
;
; RV64XMIPSPREFETCH-LABEL: prefetch_data_read:
; RV64XMIPSPREFETCH:       # %bb.0: # %entry
; RV64XMIPSPREFETCH-NEXT:    mips.pref 8, 1(a0)
; RV64XMIPSPREFETCH-NEXT:    ret
entry:
  %arrayidx = getelementptr inbounds nuw i8, ptr %ptr, i64 1
  tail call void @llvm.prefetch.p0(ptr nonnull %arrayidx, i32 0, i32 0, i32 1)
  ret void
}

define void @prefetch_data_write(ptr noundef %ptr) nounwind  {
; RV32XMIPSPREFETCH-LABEL: prefetch_data_write:
; RV32XMIPSPREFETCH:       # %bb.0:
; RV32XMIPSPREFETCH-NEXT:    addi a0, a0, 512
; RV32XMIPSPREFETCH-NEXT:    mips.pref 9, 0(a0)
; RV32XMIPSPREFETCH-NEXT:    ret
;
; RV64XMIPSPREFETCH-LABEL: prefetch_data_write:
; RV64XMIPSPREFETCH:       # %bb.0:
; RV64XMIPSPREFETCH-NEXT:    addi a0, a0, 512
; RV64XMIPSPREFETCH-NEXT:    mips.pref 9, 0(a0)
; RV64XMIPSPREFETCH-NEXT:    ret
  %arrayidx = getelementptr inbounds nuw i8, ptr %ptr, i64 512
  tail call void @llvm.prefetch.p0(ptr nonnull %arrayidx, i32 1, i32 0, i32 1)
  ret void
}

define void @prefetch_inst_read(ptr noundef %ptr) nounwind  {
; RV32XMIPSPREFETCH-LABEL: prefetch_inst_read:
; RV32XMIPSPREFETCH:       # %bb.0:
; RV32XMIPSPREFETCH-NEXT:    ret
;
; RV64XMIPSPREFETCH-LABEL: prefetch_inst_read:
; RV64XMIPSPREFETCH:       # %bb.0:
; RV64XMIPSPREFETCH-NEXT:    ret
  %arrayidx = getelementptr inbounds nuw i8, ptr %ptr, i64 512
  tail call void @llvm.prefetch.p0(ptr nonnull %arrayidx, i32 0, i32 0, i32 0)
  ret void
}
