; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+f,+d,+zfbfmin,+zvfbfmin,+v -target-abi ilp32d -verify-machineinstrs < %s \
; RUN:   | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+f,+d,+zfbfmin,+zvfbfmin,+v -target-abi lp64d -verify-machineinstrs < %s \
; RUN:   | FileCheck %s
; RUN: llc -mtriple=riscv32 -mattr=+f,+d,+zvfbfmin,+v -target-abi ilp32d -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=NOZFBFMIN
; RUN: llc -mtriple=riscv64 -mattr=+f,+d,+zvfbfmin,+v -target-abi lp64d -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=NOZFBFMIN

define <vscale x 8 x bfloat> @vsplat_nxv8bf16(bfloat %f) {
; CHECK-LABEL: vsplat_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fmv.x.h a0, fa0
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    ret
;
; NOZFBFMIN-LABEL: vsplat_nxv8bf16:
; NOZFBFMIN:       # %bb.0:
; NOZFBFMIN-NEXT:    fmv.x.w a0, fa0
; NOZFBFMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; NOZFBFMIN-NEXT:    vmv.v.x v8, a0
; NOZFBFMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %f, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  ret <vscale x 8 x bfloat> %splat
}

define <vscale x 8 x bfloat> @vsplat_zero_nxv8bf16() {
; CHECK-LABEL: vsplat_zero_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    ret
;
; NOZFBFMIN-LABEL: vsplat_zero_nxv8bf16:
; NOZFBFMIN:       # %bb.0:
; NOZFBFMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; NOZFBFMIN-NEXT:    vmv.v.i v8, 0
; NOZFBFMIN-NEXT:    ret
  ret <vscale x 8 x bfloat> splat (bfloat zeroinitializer)
}

define <vscale x 8 x bfloat> @vsplat_negzero_nxv8bf16() {
; CHECK-LABEL: vsplat_negzero_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, 1048568
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    ret
;
; NOZFBFMIN-LABEL: vsplat_negzero_nxv8bf16:
; NOZFBFMIN:       # %bb.0:
; NOZFBFMIN-NEXT:    lui a0, 1048568
; NOZFBFMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; NOZFBFMIN-NEXT:    vmv.v.x v8, a0
; NOZFBFMIN-NEXT:    ret
  ret <vscale x 8 x bfloat> splat (bfloat -0.0)
}
