; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+v,+f,+d,+zvfhmin,+zvfbfmin \
; RUN:     -target-abi=ilp32d -verify-machineinstrs | FileCheck %s --check-prefix=RV32
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv64 -mattr=+v,+f,+d,+zvfhmin,+zvfbfmin \
; RUN:     -target-abi=lp64d -verify-machineinstrs | FileCheck %s --check-prefix=RV64-i32
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+v,+f,+d,+zvfhmin,+zvfbfmin \
; RUN:     -target-abi=lp64d -verify-machineinstrs | FileCheck %s --check-prefix=RV64-i64

define <vscale x 1 x iXLen> @lrint_nxv1f32(<vscale x 1 x float> %x) {
; RV32-LABEL: lrint_nxv1f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_nxv1f32:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v8
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_nxv1f32:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v9, v8
; RV64-i64-NEXT:    vmv1r.v v8, v9
; RV64-i64-NEXT:    ret
  %a = call <vscale x 1 x iXLen> @llvm.lrint.nxv1iXLen.nxv1f32(<vscale x 1 x float> %x)
  ret <vscale x 1 x iXLen> %a
}
declare <vscale x 1 x iXLen> @llvm.lrint.nxv1iXLen.nxv1f32(<vscale x 1 x float>)

define <vscale x 2 x iXLen> @lrint_nxv2f32(<vscale x 2 x float> %x) {
; RV32-LABEL: lrint_nxv2f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_nxv2f32:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v8
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_nxv2f32:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; RV64-i64-NEXT:    vmv1r.v v10, v8
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v10
; RV64-i64-NEXT:    ret
  %a = call <vscale x 2 x iXLen> @llvm.lrint.nxv2iXLen.nxv2f32(<vscale x 2 x float> %x)
  ret <vscale x 2 x iXLen> %a
}
declare <vscale x 2 x iXLen> @llvm.lrint.nxv2iXLen.nxv2f32(<vscale x 2 x float>)

define <vscale x 4 x iXLen> @lrint_nxv4f32(<vscale x 4 x float> %x) {
; RV32-LABEL: lrint_nxv4f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_nxv4f32:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v8
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_nxv4f32:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; RV64-i64-NEXT:    vmv2r.v v12, v8
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v12
; RV64-i64-NEXT:    ret
  %a = call <vscale x 4 x iXLen> @llvm.lrint.nxv4iXLen.nxv4f32(<vscale x 4 x float> %x)
  ret <vscale x 4 x iXLen> %a
}
declare <vscale x 4 x iXLen> @llvm.lrint.nxv4iXLen.nxv4f32(<vscale x 4 x float>)

define <vscale x 8 x iXLen> @lrint_nxv8f32(<vscale x 8 x float> %x) {
; RV32-LABEL: lrint_nxv8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_nxv8f32:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v8
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_nxv8f32:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; RV64-i64-NEXT:    vmv4r.v v16, v8
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v16
; RV64-i64-NEXT:    ret
  %a = call <vscale x 8 x iXLen> @llvm.lrint.nxv8iXLen.nxv8f32(<vscale x 8 x float> %x)
  ret <vscale x 8 x iXLen> %a
}
declare <vscale x 8 x iXLen> @llvm.lrint.nxv8iXLen.nxv8f32(<vscale x 8 x float>)

define <vscale x 16 x iXLen> @lrint_nxv16f32(<vscale x 16 x float> %x) {
; RV32-LABEL: lrint_nxv16f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_nxv16f32:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v8
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_nxv16f32:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v24, v8
; RV64-i64-NEXT:    vfwcvt.x.f.v v16, v12
; RV64-i64-NEXT:    vmv8r.v v8, v24
; RV64-i64-NEXT:    ret
  %a = call <vscale x 16 x iXLen> @llvm.lrint.nxv16iXLen.nxv16f32(<vscale x 16 x float> %x)
  ret <vscale x 16 x iXLen> %a
}
declare <vscale x 16 x iXLen> @llvm.lrint.nxv16iXLen.nxv16f32(<vscale x 16 x float>)

define <vscale x 1 x iXLen> @lrint_nxv1f64(<vscale x 1 x double> %x) {
; RV32-LABEL: lrint_nxv1f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; RV32-NEXT:    vfncvt.x.f.w v9, v8
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_nxv1f64:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; RV64-i32-NEXT:    vfncvt.x.f.w v9, v8
; RV64-i32-NEXT:    vmv1r.v v8, v9
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_nxv1f64:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV64-i64-NEXT:    vfcvt.x.f.v v8, v8
; RV64-i64-NEXT:    ret
  %a = call <vscale x 1 x iXLen> @llvm.lrint.nxv1iXLen.nxv1f64(<vscale x 1 x double> %x)
  ret <vscale x 1 x iXLen> %a
}
declare <vscale x 1 x iXLen> @llvm.lrint.nxv1iXLen.nxv1f64(<vscale x 1 x double>)

define <vscale x 2 x iXLen> @lrint_nxv2f64(<vscale x 2 x double> %x) {
; RV32-LABEL: lrint_nxv2f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; RV32-NEXT:    vfncvt.x.f.w v10, v8
; RV32-NEXT:    vmv.v.v v8, v10
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_nxv2f64:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; RV64-i32-NEXT:    vfncvt.x.f.w v10, v8
; RV64-i32-NEXT:    vmv.v.v v8, v10
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_nxv2f64:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV64-i64-NEXT:    vfcvt.x.f.v v8, v8
; RV64-i64-NEXT:    ret
  %a = call <vscale x 2 x iXLen> @llvm.lrint.nxv2iXLen.nxv2f64(<vscale x 2 x double> %x)
  ret <vscale x 2 x iXLen> %a
}
declare <vscale x 2 x iXLen> @llvm.lrint.nxv2iXLen.nxv2f64(<vscale x 2 x double>)

define <vscale x 4 x iXLen> @lrint_nxv4f64(<vscale x 4 x double> %x) {
; RV32-LABEL: lrint_nxv4f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; RV32-NEXT:    vfncvt.x.f.w v12, v8
; RV32-NEXT:    vmv.v.v v8, v12
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_nxv4f64:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; RV64-i32-NEXT:    vfncvt.x.f.w v12, v8
; RV64-i32-NEXT:    vmv.v.v v8, v12
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_nxv4f64:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV64-i64-NEXT:    vfcvt.x.f.v v8, v8
; RV64-i64-NEXT:    ret
  %a = call <vscale x 4 x iXLen> @llvm.lrint.nxv4iXLen.nxv4f64(<vscale x 4 x double> %x)
  ret <vscale x 4 x iXLen> %a
}
declare <vscale x 4 x iXLen> @llvm.lrint.nxv4iXLen.nxv4f64(<vscale x 4 x double>)

define <vscale x 8 x iXLen> @lrint_nxv8f64(<vscale x 8 x double> %x) {
; RV32-LABEL: lrint_nxv8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; RV32-NEXT:    vfncvt.x.f.w v16, v8
; RV32-NEXT:    vmv.v.v v8, v16
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_nxv8f64:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; RV64-i32-NEXT:    vfncvt.x.f.w v16, v8
; RV64-i32-NEXT:    vmv.v.v v8, v16
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_nxv8f64:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; RV64-i64-NEXT:    vfcvt.x.f.v v8, v8
; RV64-i64-NEXT:    ret
  %a = call <vscale x 8 x iXLen> @llvm.lrint.nxv8iXLen.nxv8f64(<vscale x 8 x double> %x)
  ret <vscale x 8 x iXLen> %a
}
declare <vscale x 8 x iXLen> @llvm.lrint.nxv8iXLen.nxv8f64(<vscale x 8 x double>)

define <vscale x 1 x iXLen> @lrint_nxv1f16(<vscale x 1 x half> %x) {
; RV32-LABEL: lrint_nxv1f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; RV32-NEXT:    vfwcvt.f.f.v v9, v8
; RV32-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v9
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_nxv1f16:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; RV64-i32-NEXT:    vfwcvt.f.f.v v9, v8
; RV64-i32-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v9
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_nxv1f16:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; RV64-i64-NEXT:    vfwcvt.f.f.v v9, v8
; RV64-i64-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v9
; RV64-i64-NEXT:    ret
  %a = call <vscale x 1 x iXLen> @llvm.lrint.nxv1iXLen.nxv1f16(<vscale x 1 x half> %x)
  ret <vscale x 1 x iXLen> %a
}
declare <vscale x 1 x iXLen> @llvm.lrint.nxv1iXLen.nxv1f16(<vscale x 1 x half>)

define <vscale x 2 x iXLen> @lrint_nxv2f16(<vscale x 2 x half> %x) {
; RV32-LABEL: lrint_nxv2f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; RV32-NEXT:    vfwcvt.f.f.v v9, v8
; RV32-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v9
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_nxv2f16:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; RV64-i32-NEXT:    vfwcvt.f.f.v v9, v8
; RV64-i32-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v9
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_nxv2f16:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; RV64-i64-NEXT:    vfwcvt.f.f.v v10, v8
; RV64-i64-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v10
; RV64-i64-NEXT:    ret
  %a = call <vscale x 2 x iXLen> @llvm.lrint.nxv2iXLen.nxv2f16(<vscale x 2 x half> %x)
  ret <vscale x 2 x iXLen> %a
}
declare <vscale x 2 x iXLen> @llvm.lrint.nxv2iXLen.nxv2f16(<vscale x 2 x half>)

define <vscale x 4 x iXLen> @lrint_nxv4f16(<vscale x 4 x half> %x) {
; RV32-LABEL: lrint_nxv4f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; RV32-NEXT:    vfwcvt.f.f.v v10, v8
; RV32-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v10
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_nxv4f16:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; RV64-i32-NEXT:    vfwcvt.f.f.v v10, v8
; RV64-i32-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v10
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_nxv4f16:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; RV64-i64-NEXT:    vfwcvt.f.f.v v12, v8
; RV64-i64-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v12
; RV64-i64-NEXT:    ret
  %a = call <vscale x 4 x iXLen> @llvm.lrint.nxv4iXLen.nxv4f16(<vscale x 4 x half> %x)
  ret <vscale x 4 x iXLen> %a
}
declare <vscale x 4 x iXLen> @llvm.lrint.nxv4iXLen.nxv4f16(<vscale x 4 x half>)

define <vscale x 8 x iXLen> @lrint_nxv8f16(<vscale x 8 x half> %x) {
; RV32-LABEL: lrint_nxv8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; RV32-NEXT:    vfwcvt.f.f.v v12, v8
; RV32-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v12
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_nxv8f16:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; RV64-i32-NEXT:    vfwcvt.f.f.v v12, v8
; RV64-i32-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v12
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_nxv8f16:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; RV64-i64-NEXT:    vfwcvt.f.f.v v16, v8
; RV64-i64-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v16
; RV64-i64-NEXT:    ret
  %a = call <vscale x 8 x iXLen> @llvm.lrint.nxv8iXLen.nxv8f16(<vscale x 8 x half> %x)
  ret <vscale x 8 x iXLen> %a
}
declare <vscale x 8 x iXLen> @llvm.lrint.nxv8iXLen.nxv8f16(<vscale x 8 x half>)

define <vscale x 16 x iXLen> @lrint_nxv16f16(<vscale x 16 x half> %x) {
; RV32-LABEL: lrint_nxv16f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; RV32-NEXT:    vfwcvt.f.f.v v16, v8
; RV32-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v16
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_nxv16f16:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; RV64-i32-NEXT:    vfwcvt.f.f.v v16, v8
; RV64-i32-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v16
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_nxv16f16:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; RV64-i64-NEXT:    vfwcvt.f.f.v v16, v8
; RV64-i64-NEXT:    vfwcvt.f.f.v v24, v10
; RV64-i64-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v16
; RV64-i64-NEXT:    vfwcvt.x.f.v v16, v24
; RV64-i64-NEXT:    ret
  %a = call <vscale x 16 x iXLen> @llvm.lrint.nxv16iXLen.nxv16f16(<vscale x 16 x half> %x)
  ret <vscale x 16 x iXLen> %a
}
declare <vscale x 16 x iXLen> @llvm.lrint.nxv16iXLen.nxv16f16(<vscale x 16 x half>)

define <vscale x 1 x iXLen> @lrint_nxv1bf16(<vscale x 1 x bfloat> %x) {
; RV32-LABEL: lrint_nxv1bf16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; RV32-NEXT:    vfwcvtbf16.f.f.v v9, v8
; RV32-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v9
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_nxv1bf16:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; RV64-i32-NEXT:    vfwcvtbf16.f.f.v v9, v8
; RV64-i32-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v9
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_nxv1bf16:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; RV64-i64-NEXT:    vfwcvtbf16.f.f.v v9, v8
; RV64-i64-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v9
; RV64-i64-NEXT:    ret
  %a = call <vscale x 1 x iXLen> @llvm.lrint.nxv1iXLen.nxv1bf16(<vscale x 1 x bfloat> %x)
  ret <vscale x 1 x iXLen> %a
}
declare <vscale x 1 x iXLen> @llvm.lrint.nxv1iXLen.nxv1bf16(<vscale x 1 x bfloat>)

define <vscale x 2 x iXLen> @lrint_nxv2bf16(<vscale x 2 x bfloat> %x) {
; RV32-LABEL: lrint_nxv2bf16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; RV32-NEXT:    vfwcvtbf16.f.f.v v9, v8
; RV32-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v9
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_nxv2bf16:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; RV64-i32-NEXT:    vfwcvtbf16.f.f.v v9, v8
; RV64-i32-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v9
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_nxv2bf16:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; RV64-i64-NEXT:    vfwcvtbf16.f.f.v v10, v8
; RV64-i64-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v10
; RV64-i64-NEXT:    ret
  %a = call <vscale x 2 x iXLen> @llvm.lrint.nxv2iXLen.nxv2bf16(<vscale x 2 x bfloat> %x)
  ret <vscale x 2 x iXLen> %a
}
declare <vscale x 2 x iXLen> @llvm.lrint.nxv2iXLen.nxv2bf16(<vscale x 2 x bfloat>)

define <vscale x 4 x iXLen> @lrint_nxv4bf16(<vscale x 4 x bfloat> %x) {
; RV32-LABEL: lrint_nxv4bf16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; RV32-NEXT:    vfwcvtbf16.f.f.v v10, v8
; RV32-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v10
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_nxv4bf16:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; RV64-i32-NEXT:    vfwcvtbf16.f.f.v v10, v8
; RV64-i32-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v10
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_nxv4bf16:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; RV64-i64-NEXT:    vfwcvtbf16.f.f.v v12, v8
; RV64-i64-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v12
; RV64-i64-NEXT:    ret
  %a = call <vscale x 4 x iXLen> @llvm.lrint.nxv4iXLen.nxv4bf16(<vscale x 4 x bfloat> %x)
  ret <vscale x 4 x iXLen> %a
}
declare <vscale x 4 x iXLen> @llvm.lrint.nxv4iXLen.nxv4bf16(<vscale x 4 x bfloat>)

define <vscale x 8 x iXLen> @lrint_nxv8bf16(<vscale x 8 x bfloat> %x) {
; RV32-LABEL: lrint_nxv8bf16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; RV32-NEXT:    vfwcvtbf16.f.f.v v12, v8
; RV32-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v12
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_nxv8bf16:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; RV64-i32-NEXT:    vfwcvtbf16.f.f.v v12, v8
; RV64-i32-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v12
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_nxv8bf16:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; RV64-i64-NEXT:    vfwcvtbf16.f.f.v v16, v8
; RV64-i64-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v16
; RV64-i64-NEXT:    ret
  %a = call <vscale x 8 x iXLen> @llvm.lrint.nxv8iXLen.nxv8bf16(<vscale x 8 x bfloat> %x)
  ret <vscale x 8 x iXLen> %a
}
declare <vscale x 8 x iXLen> @llvm.lrint.nxv8iXLen.nxv8bf16(<vscale x 8 x bfloat>)

define <vscale x 16 x iXLen> @lrint_nxv16bf16(<vscale x 16 x bfloat> %x) {
; RV32-LABEL: lrint_nxv16bf16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; RV32-NEXT:    vfwcvtbf16.f.f.v v16, v8
; RV32-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v16
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_nxv16bf16:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; RV64-i32-NEXT:    vfwcvtbf16.f.f.v v16, v8
; RV64-i32-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v16
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_nxv16bf16:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; RV64-i64-NEXT:    vfwcvtbf16.f.f.v v16, v8
; RV64-i64-NEXT:    vfwcvtbf16.f.f.v v24, v10
; RV64-i64-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v16
; RV64-i64-NEXT:    vfwcvt.x.f.v v16, v24
; RV64-i64-NEXT:    ret
  %a = call <vscale x 16 x iXLen> @llvm.lrint.nxv16iXLen.nxv16bf16(<vscale x 16 x bfloat> %x)
  ret <vscale x 16 x iXLen> %a
}
declare <vscale x 16 x iXLen> @llvm.lrint.nxv16iXLen.nxv16bf16(<vscale x 16 x bfloat>)

define <vscale x 32 x iXLen> @lrint_nxv32bf16(<vscale x 32 x bfloat> %x) {
; RV32-LABEL: lrint_nxv32bf16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; RV32-NEXT:    vfwcvtbf16.f.f.v v16, v8
; RV32-NEXT:    vfwcvtbf16.f.f.v v24, v12
; RV32-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v16
; RV32-NEXT:    vfcvt.x.f.v v16, v24
; RV32-NEXT:    ret
;
; RV64-i32-LABEL: lrint_nxv32bf16:
; RV64-i32:       # %bb.0:
; RV64-i32-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; RV64-i32-NEXT:    vfwcvtbf16.f.f.v v16, v8
; RV64-i32-NEXT:    vfwcvtbf16.f.f.v v24, v12
; RV64-i32-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; RV64-i32-NEXT:    vfcvt.x.f.v v8, v16
; RV64-i32-NEXT:    vfcvt.x.f.v v16, v24
; RV64-i32-NEXT:    ret
;
; RV64-i64-LABEL: lrint_nxv32bf16:
; RV64-i64:       # %bb.0:
; RV64-i64-NEXT:    addi sp, sp, -64
; RV64-i64-NEXT:    .cfi_def_cfa_offset 64
; RV64-i64-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; RV64-i64-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; RV64-i64-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; RV64-i64-NEXT:    .cfi_offset ra, -8
; RV64-i64-NEXT:    .cfi_offset s0, -16
; RV64-i64-NEXT:    .cfi_offset s1, -24
; RV64-i64-NEXT:    csrr a1, vlenb
; RV64-i64-NEXT:    slli a1, a1, 5
; RV64-i64-NEXT:    sub sp, sp, a1
; RV64-i64-NEXT:    .cfi_escape 0x0f, 0x0e, 0x72, 0x00, 0x11, 0xc0, 0x00, 0x22, 0x11, 0x20, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 64 + 32 * vlenb
; RV64-i64-NEXT:    mv s0, a0
; RV64-i64-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; RV64-i64-NEXT:    vfwcvtbf16.f.f.v v16, v8
; RV64-i64-NEXT:    vfwcvtbf16.f.f.v v20, v10
; RV64-i64-NEXT:    vfwcvtbf16.f.f.v v8, v12
; RV64-i64-NEXT:    vfwcvtbf16.f.f.v v24, v14
; RV64-i64-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; RV64-i64-NEXT:    vfwcvt.x.f.v v0, v16
; RV64-i64-NEXT:    csrr a0, vlenb
; RV64-i64-NEXT:    slli a0, a0, 3
; RV64-i64-NEXT:    mv a1, a0
; RV64-i64-NEXT:    slli a0, a0, 1
; RV64-i64-NEXT:    add a0, a0, a1
; RV64-i64-NEXT:    add a0, sp, a0
; RV64-i64-NEXT:    addi a0, a0, 32
; RV64-i64-NEXT:    vs8r.v v0, (a0) # vscale x 64-byte Folded Spill
; RV64-i64-NEXT:    vfwcvt.x.f.v v0, v20
; RV64-i64-NEXT:    csrr a0, vlenb
; RV64-i64-NEXT:    slli a0, a0, 4
; RV64-i64-NEXT:    add a0, sp, a0
; RV64-i64-NEXT:    addi a0, a0, 32
; RV64-i64-NEXT:    vs8r.v v0, (a0) # vscale x 64-byte Folded Spill
; RV64-i64-NEXT:    vfwcvt.x.f.v v16, v8
; RV64-i64-NEXT:    csrr a0, vlenb
; RV64-i64-NEXT:    slli a0, a0, 3
; RV64-i64-NEXT:    add a0, sp, a0
; RV64-i64-NEXT:    addi a0, a0, 32
; RV64-i64-NEXT:    vs8r.v v16, (a0) # vscale x 64-byte Folded Spill
; RV64-i64-NEXT:    vfwcvt.x.f.v v8, v24
; RV64-i64-NEXT:    addi a0, sp, 32
; RV64-i64-NEXT:    vs8r.v v8, (a0) # vscale x 64-byte Folded Spill
; RV64-i64-NEXT:    csrr s1, vlenb
; RV64-i64-NEXT:    li a1, 24
; RV64-i64-NEXT:    mv a0, s1
; RV64-i64-NEXT:    call __muldi3
; RV64-i64-NEXT:    add a0, s0, a0
; RV64-i64-NEXT:    addi a1, sp, 32
; RV64-i64-NEXT:    vl8r.v v8, (a1) # vscale x 64-byte Folded Reload
; RV64-i64-NEXT:    vs8r.v v8, (a0)
; RV64-i64-NEXT:    slli a0, s1, 4
; RV64-i64-NEXT:    slli s1, s1, 3
; RV64-i64-NEXT:    add a0, s0, a0
; RV64-i64-NEXT:    add s1, s0, s1
; RV64-i64-NEXT:    csrr a1, vlenb
; RV64-i64-NEXT:    slli a1, a1, 3
; RV64-i64-NEXT:    add a1, sp, a1
; RV64-i64-NEXT:    addi a1, a1, 32
; RV64-i64-NEXT:    vl8r.v v8, (a1) # vscale x 64-byte Folded Reload
; RV64-i64-NEXT:    vs8r.v v8, (a0)
; RV64-i64-NEXT:    csrr a0, vlenb
; RV64-i64-NEXT:    slli a0, a0, 4
; RV64-i64-NEXT:    add a0, sp, a0
; RV64-i64-NEXT:    addi a0, a0, 32
; RV64-i64-NEXT:    vl8r.v v8, (a0) # vscale x 64-byte Folded Reload
; RV64-i64-NEXT:    vs8r.v v8, (s1)
; RV64-i64-NEXT:    csrr a0, vlenb
; RV64-i64-NEXT:    slli a0, a0, 3
; RV64-i64-NEXT:    mv a1, a0
; RV64-i64-NEXT:    slli a0, a0, 1
; RV64-i64-NEXT:    add a0, a0, a1
; RV64-i64-NEXT:    add a0, sp, a0
; RV64-i64-NEXT:    addi a0, a0, 32
; RV64-i64-NEXT:    vl8r.v v8, (a0) # vscale x 64-byte Folded Reload
; RV64-i64-NEXT:    vs8r.v v8, (s0)
; RV64-i64-NEXT:    csrr a0, vlenb
; RV64-i64-NEXT:    slli a0, a0, 5
; RV64-i64-NEXT:    add sp, sp, a0
; RV64-i64-NEXT:    .cfi_def_cfa sp, 64
; RV64-i64-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; RV64-i64-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; RV64-i64-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; RV64-i64-NEXT:    .cfi_restore ra
; RV64-i64-NEXT:    .cfi_restore s0
; RV64-i64-NEXT:    .cfi_restore s1
; RV64-i64-NEXT:    addi sp, sp, 64
; RV64-i64-NEXT:    .cfi_def_cfa_offset 0
; RV64-i64-NEXT:    ret
  %a = call <vscale x 32 x iXLen> @llvm.lrint.nxv32iXLen.nxv32bf16(<vscale x 32 x bfloat> %x)
  ret <vscale x 32 x iXLen> %a
}
declare <vscale x 32 x iXLen> @llvm.lrint.nxv32iXLen.nxv32bf16(<vscale x 32 x bfloat>)
