; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v,+f,+d,+zvfhmin,+zvfbfmin -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefix=RV32
; RUN: llc -mtriple=riscv64 -mattr=+v,+f,+d,+zvfhmin,+zvfbfmin -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefix=RV64

define <1 x i64> @llround_v1f16(<1 x half> %x) nounwind {
; RV32-LABEL: llround_v1f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; RV32-NEXT:    vfwcvt.f.f.v v9, v8
; RV32-NEXT:    fsrmi a0, 4
; RV32-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV32-NEXT:    vfwcvt.x.f.v v8, v9
; RV32-NEXT:    fsrm a0
; RV32-NEXT:    ret
;
; RV64-LABEL: llround_v1f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; RV64-NEXT:    vfwcvt.f.f.v v9, v8
; RV64-NEXT:    fsrmi a0, 4
; RV64-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV64-NEXT:    vfwcvt.x.f.v v8, v9
; RV64-NEXT:    fsrm a0
; RV64-NEXT:    ret
  %a = call <1 x i64> @llvm.llround.v1i64.v1f16(<1 x half> %x)
  ret <1 x i64> %a
}
declare <1 x i64> @llvm.llround.v1i64.v1f16(<1 x half>)

define <2 x i64> @llround_v2f16(<2 x half> %x) nounwind {
; RV32-LABEL: llround_v2f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; RV32-NEXT:    vfwcvt.f.f.v v9, v8
; RV32-NEXT:    fsrmi a0, 4
; RV32-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV32-NEXT:    vfwcvt.x.f.v v8, v9
; RV32-NEXT:    fsrm a0
; RV32-NEXT:    ret
;
; RV64-LABEL: llround_v2f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; RV64-NEXT:    vfwcvt.f.f.v v9, v8
; RV64-NEXT:    fsrmi a0, 4
; RV64-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV64-NEXT:    vfwcvt.x.f.v v8, v9
; RV64-NEXT:    fsrm a0
; RV64-NEXT:    ret
  %a = call <2 x i64> @llvm.llround.v2i64.v2f16(<2 x half> %x)
  ret <2 x i64> %a
}
declare <2 x i64> @llvm.llround.v2i64.v2f16(<2 x half>)

define <3 x i64> @llround_v3f16(<3 x half> %x) nounwind {
; RV32-LABEL: llround_v3f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; RV32-NEXT:    vfwcvt.f.f.v v10, v8
; RV32-NEXT:    fsrmi a0, 4
; RV32-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; RV32-NEXT:    vfwcvt.x.f.v v8, v10
; RV32-NEXT:    fsrm a0
; RV32-NEXT:    ret
;
; RV64-LABEL: llround_v3f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; RV64-NEXT:    vfwcvt.f.f.v v10, v8
; RV64-NEXT:    fsrmi a0, 4
; RV64-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; RV64-NEXT:    vfwcvt.x.f.v v8, v10
; RV64-NEXT:    fsrm a0
; RV64-NEXT:    ret
  %a = call <3 x i64> @llvm.llround.v3i64.v3f16(<3 x half> %x)
  ret <3 x i64> %a
}
declare <3 x i64> @llvm.llround.v3i64.v3f16(<3 x half>)

define <4 x i64> @llround_v4f16(<4 x half> %x) nounwind {
; RV32-LABEL: llround_v4f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; RV32-NEXT:    vfwcvt.f.f.v v10, v8
; RV32-NEXT:    fsrmi a0, 4
; RV32-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; RV32-NEXT:    vfwcvt.x.f.v v8, v10
; RV32-NEXT:    fsrm a0
; RV32-NEXT:    ret
;
; RV64-LABEL: llround_v4f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; RV64-NEXT:    vfwcvt.f.f.v v10, v8
; RV64-NEXT:    fsrmi a0, 4
; RV64-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; RV64-NEXT:    vfwcvt.x.f.v v8, v10
; RV64-NEXT:    fsrm a0
; RV64-NEXT:    ret
  %a = call <4 x i64> @llvm.llround.v4i64.v4f16(<4 x half> %x)
  ret <4 x i64> %a
}
declare <4 x i64> @llvm.llround.v4i64.v4f16(<4 x half>)

define <8 x i64> @llround_v8f16(<8 x half> %x) nounwind {
; RV32-LABEL: llround_v8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV32-NEXT:    vfwcvt.f.f.v v12, v8
; RV32-NEXT:    fsrmi a0, 4
; RV32-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; RV32-NEXT:    vfwcvt.x.f.v v8, v12
; RV32-NEXT:    fsrm a0
; RV32-NEXT:    ret
;
; RV64-LABEL: llround_v8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV64-NEXT:    vfwcvt.f.f.v v12, v8
; RV64-NEXT:    fsrmi a0, 4
; RV64-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; RV64-NEXT:    vfwcvt.x.f.v v8, v12
; RV64-NEXT:    fsrm a0
; RV64-NEXT:    ret
  %a = call <8 x i64> @llvm.llround.v8i64.v8f16(<8 x half> %x)
  ret <8 x i64> %a
}
declare <8 x i64> @llvm.llround.v8i64.v8f16(<8 x half>)

define <16 x i64> @llround_v16f16(<16 x half> %x) nounwind {
; RV32-LABEL: llround_v16f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; RV32-NEXT:    vfwcvt.f.f.v v16, v8
; RV32-NEXT:    fsrmi a0, 4
; RV32-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; RV32-NEXT:    vfwcvt.x.f.v v8, v16
; RV32-NEXT:    fsrm a0
; RV32-NEXT:    ret
;
; RV64-LABEL: llround_v16f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; RV64-NEXT:    vfwcvt.f.f.v v16, v8
; RV64-NEXT:    fsrmi a0, 4
; RV64-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; RV64-NEXT:    vfwcvt.x.f.v v8, v16
; RV64-NEXT:    fsrm a0
; RV64-NEXT:    ret
  %a = call <16 x i64> @llvm.llround.v16i64.v16f16(<16 x half> %x)
  ret <16 x i64> %a
}
declare <16 x i64> @llvm.llround.v16i64.v16f16(<16 x half>)

define <1 x i64> @llround_v1i64_v1f32(<1 x float> %x) nounwind {
; RV32-LABEL: llround_v1i64_v1f32:
; RV32:       # %bb.0:
; RV32-NEXT:    fsrmi a0, 4
; RV32-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; RV32-NEXT:    vfwcvt.x.f.v v9, v8
; RV32-NEXT:    fsrm a0
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: llround_v1i64_v1f32:
; RV64:       # %bb.0:
; RV64-NEXT:    fsrmi a0, 4
; RV64-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; RV64-NEXT:    vfwcvt.x.f.v v9, v8
; RV64-NEXT:    fsrm a0
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %a = call <1 x i64> @llvm.llround.v1i64.v1f32(<1 x float> %x)
  ret <1 x i64> %a
}
declare <1 x i64> @llvm.llround.v1i64.v1f32(<1 x float>)

define <2 x i64> @llround_v2i64_v2f32(<2 x float> %x) nounwind {
; RV32-LABEL: llround_v2i64_v2f32:
; RV32:       # %bb.0:
; RV32-NEXT:    fsrmi a0, 4
; RV32-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; RV32-NEXT:    vfwcvt.x.f.v v9, v8
; RV32-NEXT:    fsrm a0
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: llround_v2i64_v2f32:
; RV64:       # %bb.0:
; RV64-NEXT:    fsrmi a0, 4
; RV64-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; RV64-NEXT:    vfwcvt.x.f.v v9, v8
; RV64-NEXT:    fsrm a0
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %a = call <2 x i64> @llvm.llround.v2i64.v2f32(<2 x float> %x)
  ret <2 x i64> %a
}
declare <2 x i64> @llvm.llround.v2i64.v2f32(<2 x float>)

define <3 x i64> @llround_v3i64_v3f32(<3 x float> %x) nounwind {
; RV32-LABEL: llround_v3i64_v3f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV32-NEXT:    vmv1r.v v10, v8
; RV32-NEXT:    fsrmi a0, 4
; RV32-NEXT:    vfwcvt.x.f.v v8, v10
; RV32-NEXT:    fsrm a0
; RV32-NEXT:    ret
;
; RV64-LABEL: llround_v3i64_v3f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV64-NEXT:    vmv1r.v v10, v8
; RV64-NEXT:    fsrmi a0, 4
; RV64-NEXT:    vfwcvt.x.f.v v8, v10
; RV64-NEXT:    fsrm a0
; RV64-NEXT:    ret
  %a = call <3 x i64> @llvm.llround.v3i64.v3f32(<3 x float> %x)
  ret <3 x i64> %a
}
declare <3 x i64> @llvm.llround.v3i64.v3f32(<3 x float>)

define <4 x i64> @llround_v4i64_v4f32(<4 x float> %x) nounwind {
; RV32-LABEL: llround_v4i64_v4f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV32-NEXT:    vmv1r.v v10, v8
; RV32-NEXT:    fsrmi a0, 4
; RV32-NEXT:    vfwcvt.x.f.v v8, v10
; RV32-NEXT:    fsrm a0
; RV32-NEXT:    ret
;
; RV64-LABEL: llround_v4i64_v4f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV64-NEXT:    vmv1r.v v10, v8
; RV64-NEXT:    fsrmi a0, 4
; RV64-NEXT:    vfwcvt.x.f.v v8, v10
; RV64-NEXT:    fsrm a0
; RV64-NEXT:    ret
  %a = call <4 x i64> @llvm.llround.v4i64.v4f32(<4 x float> %x)
  ret <4 x i64> %a
}
declare <4 x i64> @llvm.llround.v4i64.v4f32(<4 x float>)

define <8 x i64> @llround_v8i64_v8f32(<8 x float> %x) nounwind {
; RV32-LABEL: llround_v8i64_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vmv2r.v v12, v8
; RV32-NEXT:    fsrmi a0, 4
; RV32-NEXT:    vfwcvt.x.f.v v8, v12
; RV32-NEXT:    fsrm a0
; RV32-NEXT:    ret
;
; RV64-LABEL: llround_v8i64_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV64-NEXT:    vmv2r.v v12, v8
; RV64-NEXT:    fsrmi a0, 4
; RV64-NEXT:    vfwcvt.x.f.v v8, v12
; RV64-NEXT:    fsrm a0
; RV64-NEXT:    ret
  %a = call <8 x i64> @llvm.llround.v8i64.v8f32(<8 x float> %x)
  ret <8 x i64> %a
}
declare <8 x i64> @llvm.llround.v8i64.v8f32(<8 x float>)

define <16 x i64> @llround_v16i64_v16f32(<16 x float> %x) nounwind {
; RV32-LABEL: llround_v16i64_v16f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; RV32-NEXT:    vmv4r.v v16, v8
; RV32-NEXT:    fsrmi a0, 4
; RV32-NEXT:    vfwcvt.x.f.v v8, v16
; RV32-NEXT:    fsrm a0
; RV32-NEXT:    ret
;
; RV64-LABEL: llround_v16i64_v16f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; RV64-NEXT:    vmv4r.v v16, v8
; RV64-NEXT:    fsrmi a0, 4
; RV64-NEXT:    vfwcvt.x.f.v v8, v16
; RV64-NEXT:    fsrm a0
; RV64-NEXT:    ret
  %a = call <16 x i64> @llvm.llround.v16i64.v16f32(<16 x float> %x)
  ret <16 x i64> %a
}
declare <16 x i64> @llvm.llround.v16i64.v16f32(<16 x float>)

define <1 x i64> @llround_v1i64_v1f64(<1 x double> %x) nounwind {
; RV32-LABEL: llround_v1i64_v1f64:
; RV32:       # %bb.0:
; RV32-NEXT:    fsrmi a0, 4
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v8
; RV32-NEXT:    fsrm a0
; RV32-NEXT:    ret
;
; RV64-LABEL: llround_v1i64_v1f64:
; RV64:       # %bb.0:
; RV64-NEXT:    fsrmi a0, 4
; RV64-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV64-NEXT:    vfcvt.x.f.v v8, v8
; RV64-NEXT:    fsrm a0
; RV64-NEXT:    ret
  %a = call <1 x i64> @llvm.llround.v1i64.v1f64(<1 x double> %x)
  ret <1 x i64> %a
}
declare <1 x i64> @llvm.llround.v1i64.v1f64(<1 x double>)

define <2 x i64> @llround_v2i64_v2f64(<2 x double> %x) nounwind {
; RV32-LABEL: llround_v2i64_v2f64:
; RV32:       # %bb.0:
; RV32-NEXT:    fsrmi a0, 4
; RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v8
; RV32-NEXT:    fsrm a0
; RV32-NEXT:    ret
;
; RV64-LABEL: llround_v2i64_v2f64:
; RV64:       # %bb.0:
; RV64-NEXT:    fsrmi a0, 4
; RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV64-NEXT:    vfcvt.x.f.v v8, v8
; RV64-NEXT:    fsrm a0
; RV64-NEXT:    ret
  %a = call <2 x i64> @llvm.llround.v2i64.v2f64(<2 x double> %x)
  ret <2 x i64> %a
}
declare <2 x i64> @llvm.llround.v2i64.v2f64(<2 x double>)

define <4 x i64> @llround_v4i64_v4f64(<4 x double> %x) nounwind {
; RV32-LABEL: llround_v4i64_v4f64:
; RV32:       # %bb.0:
; RV32-NEXT:    fsrmi a0, 4
; RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v8
; RV32-NEXT:    fsrm a0
; RV32-NEXT:    ret
;
; RV64-LABEL: llround_v4i64_v4f64:
; RV64:       # %bb.0:
; RV64-NEXT:    fsrmi a0, 4
; RV64-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; RV64-NEXT:    vfcvt.x.f.v v8, v8
; RV64-NEXT:    fsrm a0
; RV64-NEXT:    ret
  %a = call <4 x i64> @llvm.llround.v4i64.v4f64(<4 x double> %x)
  ret <4 x i64> %a
}
declare <4 x i64> @llvm.llround.v4i64.v4f64(<4 x double>)

define <8 x i64> @llround_v8i64_v8f64(<8 x double> %x) nounwind {
; RV32-LABEL: llround_v8i64_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    fsrmi a0, 4
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v8
; RV32-NEXT:    fsrm a0
; RV32-NEXT:    ret
;
; RV64-LABEL: llround_v8i64_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    fsrmi a0, 4
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vfcvt.x.f.v v8, v8
; RV64-NEXT:    fsrm a0
; RV64-NEXT:    ret
  %a = call <8 x i64> @llvm.llround.v8i64.v8f64(<8 x double> %x)
  ret <8 x i64> %a
}
declare <8 x i64> @llvm.llround.v8i64.v8f64(<8 x double>)
