; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK,CHECK-I,RV32,RV32I
; RUN: llc -mtriple=riscv64 < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK,CHECK-I,RV64,RV64I
; RUN: llc -mtriple=riscv32 -mattr=+zbb < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK,CHECK-ZBB,RV32,RV32ZBB
; RUN: llc -mtriple=riscv64 -mattr=+zbb < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK,CHECK-ZBB,RV64,RV64ZBB
;
; test that masked-merge code is generated as "xor;and;xor" sequence or
; "andn ; and; or" if and-not is available.

define i32 @masked_merge0(i32 %a0, i32 %a1, i32 %a2) {
; CHECK-I-LABEL: masked_merge0:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    xor a1, a1, a2
; CHECK-I-NEXT:    and a0, a1, a0
; CHECK-I-NEXT:    xor a0, a0, a2
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: masked_merge0:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    and a1, a0, a1
; CHECK-ZBB-NEXT:    andn a0, a2, a0
; CHECK-ZBB-NEXT:    or a0, a1, a0
; CHECK-ZBB-NEXT:    ret
  %and0 = and i32 %a0, %a1
  %not = xor i32 %a0, -1
  %and1 = and i32 %not, %a2
  %or = or i32 %and0, %and1
  ret i32 %or
}

define i16 @masked_merge1(i16 %a0, i16 %a1, i16 %a2) {
; CHECK-I-LABEL: masked_merge1:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    xor a1, a1, a2
; CHECK-I-NEXT:    and a0, a1, a0
; CHECK-I-NEXT:    xor a0, a0, a2
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: masked_merge1:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    and a1, a0, a1
; CHECK-ZBB-NEXT:    andn a0, a2, a0
; CHECK-ZBB-NEXT:    or a0, a1, a0
; CHECK-ZBB-NEXT:    ret
  %and0 = and i16 %a0, %a1
  %not = xor i16 %a0, -1
  %and1 = and i16 %a2, %not
  %or = or i16 %and0, %and1
  ret i16 %or
}

define i8 @masked_merge2(i8 %a0, i8 %a1, i8 %a2) {
; CHECK-I-LABEL: masked_merge2:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    mv a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: masked_merge2:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    andn a2, a1, a0
; CHECK-ZBB-NEXT:    and a0, a1, a0
; CHECK-ZBB-NEXT:    or a0, a2, a0
; CHECK-ZBB-NEXT:    ret
  %not = xor i8 %a0, -1
  %and0 = and i8 %not, %a1
  %and1 = and i8 %a1, %a0
  %or = or i8 %and0, %and1
  ret i8 %or
}

define i64 @masked_merge3(i64 %a0, i64 %a1, i64 %a2) {
; RV32I-LABEL: masked_merge3:
; RV32I:       # %bb.0:
; RV32I-NEXT:    not a5, a5
; RV32I-NEXT:    not a4, a4
; RV32I-NEXT:    xor a3, a3, a5
; RV32I-NEXT:    xor a2, a2, a4
; RV32I-NEXT:    not a2, a2
; RV32I-NEXT:    not a3, a3
; RV32I-NEXT:    and a0, a2, a0
; RV32I-NEXT:    and a1, a3, a1
; RV32I-NEXT:    xor a0, a0, a4
; RV32I-NEXT:    xor a1, a1, a5
; RV32I-NEXT:    ret
;
; RV64I-LABEL: masked_merge3:
; RV64I:       # %bb.0:
; RV64I-NEXT:    not a2, a2
; RV64I-NEXT:    xor a1, a1, a2
; RV64I-NEXT:    not a1, a1
; RV64I-NEXT:    and a0, a1, a0
; RV64I-NEXT:    xor a0, a0, a2
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: masked_merge3:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    not a6, a0
; RV32ZBB-NEXT:    not a7, a1
; RV32ZBB-NEXT:    andn a1, a1, a3
; RV32ZBB-NEXT:    andn a0, a0, a2
; RV32ZBB-NEXT:    andn a2, a7, a5
; RV32ZBB-NEXT:    andn a3, a6, a4
; RV32ZBB-NEXT:    or a0, a3, a0
; RV32ZBB-NEXT:    or a1, a2, a1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: masked_merge3:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    not a3, a0
; RV64ZBB-NEXT:    andn a2, a3, a2
; RV64ZBB-NEXT:    andn a0, a0, a1
; RV64ZBB-NEXT:    or a0, a2, a0
; RV64ZBB-NEXT:    ret
  %v0 = xor i64 %a1, -1
  %v1 = xor i64 %a2, -1
  %not = xor i64 %a0, -1
  %and0 = and i64 %not, %v1
  %and1 = and i64 %v0, %a0
  %or = or i64 %and0, %and1
  ret i64 %or
}

define i32 @not_a_masked_merge0(i32 %a0, i32 %a1, i32 %a2) {
; RV32-LABEL: not_a_masked_merge0:
; RV32:       # %bb.0:
; RV32-NEXT:    and a1, a0, a1
; RV32-NEXT:    neg a0, a0
; RV32-NEXT:    and a0, a0, a2
; RV32-NEXT:    or a0, a1, a0
; RV32-NEXT:    ret
;
; RV64-LABEL: not_a_masked_merge0:
; RV64:       # %bb.0:
; RV64-NEXT:    and a1, a0, a1
; RV64-NEXT:    negw a0, a0
; RV64-NEXT:    and a0, a0, a2
; RV64-NEXT:    or a0, a1, a0
; RV64-NEXT:    ret
  %and0 = and i32 %a0, %a1
  %not_a_not = sub i32 0, %a0
  %and1 = and i32 %not_a_not, %a2
  %or = or i32 %and0, %and1
  ret i32 %or
}

define i32 @not_a_masked_merge1(i32 %a0, i32 %a1, i32 %a2, i32 %a3) {
; CHECK-I-LABEL: not_a_masked_merge1:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    and a0, a0, a1
; CHECK-I-NEXT:    not a1, a3
; CHECK-I-NEXT:    and a1, a1, a2
; CHECK-I-NEXT:    or a0, a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: not_a_masked_merge1:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    and a0, a0, a1
; CHECK-ZBB-NEXT:    andn a1, a2, a3
; CHECK-ZBB-NEXT:    or a0, a0, a1
; CHECK-ZBB-NEXT:    ret
  %and0 = and i32 %a0, %a1
  %not = xor i32 %a3, -1
  %and1 = and i32 %not, %a2
  %or = or i32 %and0, %and1
  ret i32 %or
}

define i32 @not_a_masked_merge2(i32 %a0, i32 %a1, i32 %a2) {
; CHECK-I-LABEL: not_a_masked_merge2:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    or a1, a0, a1
; CHECK-I-NEXT:    not a0, a0
; CHECK-I-NEXT:    and a0, a0, a2
; CHECK-I-NEXT:    or a0, a1, a0
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: not_a_masked_merge2:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    or a1, a0, a1
; CHECK-ZBB-NEXT:    andn a0, a2, a0
; CHECK-ZBB-NEXT:    or a0, a1, a0
; CHECK-ZBB-NEXT:    ret
  %not_an_and0 = or i32 %a0, %a1
  %not = xor i32 %a0, -1
  %and1 = and i32 %not, %a2
  %or = or i32 %not_an_and0, %and1
  ret i32 %or
}

define i32 @not_a_masked_merge3(i32 %a0, i32 %a1, i32 %a2) {
; CHECK-I-LABEL: not_a_masked_merge3:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    and a1, a0, a1
; CHECK-I-NEXT:    xor a0, a0, a2
; CHECK-I-NEXT:    not a0, a0
; CHECK-I-NEXT:    or a0, a1, a0
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: not_a_masked_merge3:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    and a1, a0, a1
; CHECK-ZBB-NEXT:    xor a0, a0, a2
; CHECK-ZBB-NEXT:    orn a0, a1, a0
; CHECK-ZBB-NEXT:    ret
  %and0 = and i32 %a0, %a1
  %not = xor i32 %a0, -1
  %not_an_and1 = xor i32 %not, %a2
  %or = or i32 %and0, %not_an_and1
  ret i32 %or
}

define i32 @not_a_masked_merge4(i32 %a0, i32 %a1, i32 %a2) {
; CHECK-LABEL: not_a_masked_merge4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and a0, a0, a1
; CHECK-NEXT:    ret
  %and0 = and i32 %a0, %a1
  %not = xor i32 %a2, -1
  %and1 = and i32 %not, %a2
  %or = or i32 %and0, %and1
  ret i32 %or
}

define i32 @masked_merge_no_transform0(i32 %a0, i32 %a1, i32 %a2, ptr %p1) {
; CHECK-I-LABEL: masked_merge_no_transform0:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    and a1, a0, a1
; CHECK-I-NEXT:    not a0, a0
; CHECK-I-NEXT:    and a0, a0, a2
; CHECK-I-NEXT:    or a0, a1, a0
; CHECK-I-NEXT:    sw a1, 0(a3)
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: masked_merge_no_transform0:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    and a1, a0, a1
; CHECK-ZBB-NEXT:    andn a0, a2, a0
; CHECK-ZBB-NEXT:    or a0, a1, a0
; CHECK-ZBB-NEXT:    sw a1, 0(a3)
; CHECK-ZBB-NEXT:    ret
  %and0 = and i32 %a0, %a1
  %not = xor i32 %a0, -1
  %and1 = and i32 %not, %a2
  %or = or i32 %and0, %and1
  store i32 %and0, ptr %p1
  ret i32 %or
}

define i32 @masked_merge_no_transform1(i32 %a0, i32 %a1, i32 %a2, ptr %p1) {
; CHECK-I-LABEL: masked_merge_no_transform1:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    and a1, a0, a1
; CHECK-I-NEXT:    not a4, a0
; CHECK-I-NEXT:    and a0, a4, a2
; CHECK-I-NEXT:    or a0, a1, a0
; CHECK-I-NEXT:    sw a4, 0(a3)
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: masked_merge_no_transform1:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    and a1, a0, a1
; CHECK-ZBB-NEXT:    not a4, a0
; CHECK-ZBB-NEXT:    andn a0, a2, a0
; CHECK-ZBB-NEXT:    or a0, a1, a0
; CHECK-ZBB-NEXT:    sw a4, 0(a3)
; CHECK-ZBB-NEXT:    ret
  %and0 = and i32 %a0, %a1
  %not = xor i32 %a0, -1
  %and1 = and i32 %not, %a2
  %or = or i32 %and0, %and1
  store i32 %not, ptr %p1
  ret i32 %or
}

define i32 @masked_merge_no_transform2(i32 %a0, i32 %a1, i32 %a2, ptr %p1) {
; CHECK-I-LABEL: masked_merge_no_transform2:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    and a1, a0, a1
; CHECK-I-NEXT:    not a0, a0
; CHECK-I-NEXT:    and a2, a0, a2
; CHECK-I-NEXT:    or a0, a1, a2
; CHECK-I-NEXT:    sw a2, 0(a3)
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: masked_merge_no_transform2:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    and a1, a0, a1
; CHECK-ZBB-NEXT:    andn a2, a2, a0
; CHECK-ZBB-NEXT:    or a0, a1, a2
; CHECK-ZBB-NEXT:    sw a2, 0(a3)
; CHECK-ZBB-NEXT:    ret
  %and0 = and i32 %a0, %a1
  %not = xor i32 %a0, -1
  %and1 = and i32 %not, %a2
  %or = or i32 %and0, %and1
  store i32 %and1, ptr %p1
  ret i32 %or
}
