; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -O0 -mtriple=mipsel-linux-gnu -global-isel -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32
; RUN: llc -O0 -mtriple=mipsel-linux-gnu -global-isel -mcpu=mips32r6 -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32R6

%struct.MemSize3_Align1 = type { [3 x i8], i8 }
%struct.MemSize3_Align2 = type { [3 x i8], i8 }
%struct.MemSize3_Align4 = type { [3 x i8], i8 }
%struct.MemSize3_Align8 = type { [3 x i8], i8, [4 x i8] }
%struct.MemSize5_Align1 = type <{ [5 x i8], i16, i8 }>
%struct.MemSize5_Align2 = type <{ [5 x i8], i16, i8 }>
%struct.MemSize5_Align4 = type <{ [5 x i8], i16, i8 }>
%struct.MemSize5_Align8 = type <{ [5 x i8], i16, i8 }>
%struct.MemSize6_Align1 = type { [6 x i8], i16 }
%struct.MemSize6_Align2 = type { [6 x i8], i16 }
%struct.MemSize6_Align4 = type { [6 x i8], i16 }
%struct.MemSize6_Align8 = type { [6 x i8], i16 }
%struct.MemSize7_Align1 = type { [7 x i8], i8 }
%struct.MemSize7_Align2 = type { [7 x i8], i8 }
%struct.MemSize7_Align4 = type { [7 x i8], i8 }
%struct.MemSize7_Align8 = type { [7 x i8], i8 }

@double_align1 = common global double 0.000000e+00, align 1
@double_align2 = common global double 0.000000e+00, align 2
@double_align4 = common global double 0.000000e+00, align 4
@double_align8 = common global double 0.000000e+00, align 8
@i64_align1 = common global i64 0, align 1
@i64_align2 = common global i64 0, align 2
@i64_align4 = common global i64 0, align 4
@i64_align8 = common global i64 0, align 8

define i32 @load3align1(ptr %S) {
; MIPS32-LABEL: load3align1:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    # implicit-def: $at
; MIPS32-NEXT:    lwl $1, 3($4)
; MIPS32-NEXT:    lwr $1, 0($4)
; MIPS32-NEXT:    lui $2, 255
; MIPS32-NEXT:    ori $2, $2, 65535
; MIPS32-NEXT:    and $2, $1, $2
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load3align1:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lw $1, 0($4)
; MIPS32R6-NEXT:    lui $2, 255
; MIPS32R6-NEXT:    ori $2, $2, 65535
; MIPS32R6-NEXT:    and $2, $1, $2
; MIPS32R6-NEXT:    jrc $ra
entry:
  %bf.load = load i24, ptr %S, align 1
  %bf.cast = zext i24 %bf.load to i32
  ret i32 %bf.cast
}

define i32 @load3align2(ptr %S) {
; MIPS32-LABEL: load3align2:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    # implicit-def: $at
; MIPS32-NEXT:    lwl $1, 3($4)
; MIPS32-NEXT:    lwr $1, 0($4)
; MIPS32-NEXT:    lui $2, 255
; MIPS32-NEXT:    ori $2, $2, 65535
; MIPS32-NEXT:    and $2, $1, $2
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load3align2:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lw $1, 0($4)
; MIPS32R6-NEXT:    lui $2, 255
; MIPS32R6-NEXT:    ori $2, $2, 65535
; MIPS32R6-NEXT:    and $2, $1, $2
; MIPS32R6-NEXT:    jrc $ra
entry:
  %bf.load = load i24, ptr %S, align 2
  %bf.cast = zext i24 %bf.load to i32
  ret i32 %bf.cast
}

define i32 @load3align4(ptr %S, i32 signext %a) {
; MIPS32-LABEL: load3align4:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lw $1, 0($4)
; MIPS32-NEXT:    lui $2, 255
; MIPS32-NEXT:    ori $2, $2, 65535
; MIPS32-NEXT:    and $2, $1, $2
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load3align4:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lw $1, 0($4)
; MIPS32R6-NEXT:    lui $2, 255
; MIPS32R6-NEXT:    ori $2, $2, 65535
; MIPS32R6-NEXT:    and $2, $1, $2
; MIPS32R6-NEXT:    jrc $ra
entry:
  %bf.load = load i24, ptr %S, align 4
  %bf.cast = zext i24 %bf.load to i32
  ret i32 %bf.cast
}

define i32 @load3align8(ptr %S, i32 signext %a) {
; MIPS32-LABEL: load3align8:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lw $1, 0($4)
; MIPS32-NEXT:    lui $2, 255
; MIPS32-NEXT:    ori $2, $2, 65535
; MIPS32-NEXT:    and $2, $1, $2
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load3align8:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lw $1, 0($4)
; MIPS32R6-NEXT:    lui $2, 255
; MIPS32R6-NEXT:    ori $2, $2, 65535
; MIPS32R6-NEXT:    and $2, $1, $2
; MIPS32R6-NEXT:    jrc $ra
entry:
  %bf.load = load i24, ptr %S, align 8
  %bf.cast = zext i24 %bf.load to i32
  ret i32 %bf.cast
}

define i64 @load5align1(ptr %S) {
; MIPS32-LABEL: load5align1:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    # implicit-def: $v0
; MIPS32-NEXT:    lwl $2, 3($4)
; MIPS32-NEXT:    lwr $2, 0($4)
; MIPS32-NEXT:    lbu $1, 4($4)
; MIPS32-NEXT:    addiu $3, $zero, 65535
; MIPS32-NEXT:    and $2, $2, $3
; MIPS32-NEXT:    andi $3, $1, 255
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load5align1:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lw $2, 0($4)
; MIPS32R6-NEXT:    lbu $1, 4($4)
; MIPS32R6-NEXT:    addiu $3, $zero, 65535
; MIPS32R6-NEXT:    and $2, $2, $3
; MIPS32R6-NEXT:    andi $3, $1, 255
; MIPS32R6-NEXT:    jrc $ra
entry:
  %bf.load = load i40, ptr %S, align 1
  %bf.cast = zext i40 %bf.load to i64
  ret i64 %bf.cast
}

define i64 @load5align2(ptr %S) {
; MIPS32-LABEL: load5align2:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    # implicit-def: $v0
; MIPS32-NEXT:    lwl $2, 3($4)
; MIPS32-NEXT:    lwr $2, 0($4)
; MIPS32-NEXT:    lbu $1, 4($4)
; MIPS32-NEXT:    addiu $3, $zero, 65535
; MIPS32-NEXT:    and $2, $2, $3
; MIPS32-NEXT:    andi $3, $1, 255
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load5align2:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lw $2, 0($4)
; MIPS32R6-NEXT:    lbu $1, 4($4)
; MIPS32R6-NEXT:    addiu $3, $zero, 65535
; MIPS32R6-NEXT:    and $2, $2, $3
; MIPS32R6-NEXT:    andi $3, $1, 255
; MIPS32R6-NEXT:    jrc $ra
entry:
  %bf.load = load i40, ptr %S, align 2
  %bf.cast = zext i40 %bf.load to i64
  ret i64 %bf.cast
}

define i64 @load5align4(ptr %S) {
; MIPS32-LABEL: load5align4:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lw $2, 0($4)
; MIPS32-NEXT:    lbu $1, 4($4)
; MIPS32-NEXT:    addiu $3, $zero, 65535
; MIPS32-NEXT:    and $2, $2, $3
; MIPS32-NEXT:    andi $3, $1, 255
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load5align4:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lw $2, 0($4)
; MIPS32R6-NEXT:    lbu $1, 4($4)
; MIPS32R6-NEXT:    addiu $3, $zero, 65535
; MIPS32R6-NEXT:    and $2, $2, $3
; MIPS32R6-NEXT:    andi $3, $1, 255
; MIPS32R6-NEXT:    jrc $ra
entry:
  %bf.load = load i40, ptr %S, align 4
  %bf.cast = zext i40 %bf.load to i64
  ret i64 %bf.cast
}

define i64 @load5align8(ptr %S) {
; MIPS32-LABEL: load5align8:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lw $2, 0($4)
; MIPS32-NEXT:    lbu $1, 4($4)
; MIPS32-NEXT:    addiu $3, $zero, 65535
; MIPS32-NEXT:    and $2, $2, $3
; MIPS32-NEXT:    andi $3, $1, 255
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load5align8:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lw $2, 0($4)
; MIPS32R6-NEXT:    lbu $1, 4($4)
; MIPS32R6-NEXT:    addiu $3, $zero, 65535
; MIPS32R6-NEXT:    and $2, $2, $3
; MIPS32R6-NEXT:    andi $3, $1, 255
; MIPS32R6-NEXT:    jrc $ra
entry:
  %bf.load = load i40, ptr %S, align 8
  %bf.cast = zext i40 %bf.load to i64
  ret i64 %bf.cast
}

define i64 @load6align1(ptr %S) {
; MIPS32-LABEL: load6align1:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    # implicit-def: $v0
; MIPS32-NEXT:    lwl $2, 3($4)
; MIPS32-NEXT:    lwr $2, 0($4)
; MIPS32-NEXT:    # implicit-def: $at
; MIPS32-NEXT:    lwl $1, 7($4)
; MIPS32-NEXT:    lwr $1, 4($4)
; MIPS32-NEXT:    addiu $3, $zero, 65535
; MIPS32-NEXT:    and $2, $2, $3
; MIPS32-NEXT:    andi $3, $1, 65535
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load6align1:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lw $2, 0($4)
; MIPS32R6-NEXT:    lhu $1, 4($4)
; MIPS32R6-NEXT:    addiu $3, $zero, 65535
; MIPS32R6-NEXT:    and $2, $2, $3
; MIPS32R6-NEXT:    andi $3, $1, 65535
; MIPS32R6-NEXT:    jrc $ra
entry:
  %bf.load = load i48, ptr %S, align 1
  %bf.cast = zext i48 %bf.load to i64
  ret i64 %bf.cast
}

define i64 @load6align2(ptr %S) {
; MIPS32-LABEL: load6align2:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    # implicit-def: $v0
; MIPS32-NEXT:    lwl $2, 3($4)
; MIPS32-NEXT:    lwr $2, 0($4)
; MIPS32-NEXT:    lhu $1, 4($4)
; MIPS32-NEXT:    addiu $3, $zero, 65535
; MIPS32-NEXT:    and $2, $2, $3
; MIPS32-NEXT:    andi $3, $1, 65535
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load6align2:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lw $2, 0($4)
; MIPS32R6-NEXT:    lhu $1, 4($4)
; MIPS32R6-NEXT:    addiu $3, $zero, 65535
; MIPS32R6-NEXT:    and $2, $2, $3
; MIPS32R6-NEXT:    andi $3, $1, 65535
; MIPS32R6-NEXT:    jrc $ra
entry:
  %bf.load = load i48, ptr %S, align 2
  %bf.cast = zext i48 %bf.load to i64
  ret i64 %bf.cast
}

define i64 @load6align4(ptr %S) {
; MIPS32-LABEL: load6align4:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lw $2, 0($4)
; MIPS32-NEXT:    lhu $1, 4($4)
; MIPS32-NEXT:    addiu $3, $zero, 65535
; MIPS32-NEXT:    and $2, $2, $3
; MIPS32-NEXT:    andi $3, $1, 65535
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load6align4:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lw $2, 0($4)
; MIPS32R6-NEXT:    lhu $1, 4($4)
; MIPS32R6-NEXT:    addiu $3, $zero, 65535
; MIPS32R6-NEXT:    and $2, $2, $3
; MIPS32R6-NEXT:    andi $3, $1, 65535
; MIPS32R6-NEXT:    jrc $ra
entry:
  %bf.load = load i48, ptr %S, align 4
  %bf.cast = zext i48 %bf.load to i64
  ret i64 %bf.cast
}

define i64 @load6align8(ptr %S) {
; MIPS32-LABEL: load6align8:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lw $2, 0($4)
; MIPS32-NEXT:    lhu $1, 4($4)
; MIPS32-NEXT:    addiu $3, $zero, 65535
; MIPS32-NEXT:    and $2, $2, $3
; MIPS32-NEXT:    andi $3, $1, 65535
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load6align8:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lw $2, 0($4)
; MIPS32R6-NEXT:    lhu $1, 4($4)
; MIPS32R6-NEXT:    addiu $3, $zero, 65535
; MIPS32R6-NEXT:    and $2, $2, $3
; MIPS32R6-NEXT:    andi $3, $1, 65535
; MIPS32R6-NEXT:    jrc $ra
entry:
  %bf.load = load i48, ptr %S, align 8
  %bf.cast = zext i48 %bf.load to i64
  ret i64 %bf.cast
}

define i64 @load7align1(ptr %S) {
; MIPS32-LABEL: load7align1:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    # implicit-def: $v0
; MIPS32-NEXT:    lwl $2, 3($4)
; MIPS32-NEXT:    lwr $2, 0($4)
; MIPS32-NEXT:    # implicit-def: $at
; MIPS32-NEXT:    lwl $1, 7($4)
; MIPS32-NEXT:    lwr $1, 4($4)
; MIPS32-NEXT:    addiu $4, $zero, 65535
; MIPS32-NEXT:    lui $3, 255
; MIPS32-NEXT:    ori $3, $3, 65535
; MIPS32-NEXT:    and $2, $2, $4
; MIPS32-NEXT:    and $3, $1, $3
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load7align1:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lw $2, 0($4)
; MIPS32R6-NEXT:    lw $1, 4($4)
; MIPS32R6-NEXT:    addiu $4, $zero, 65535
; MIPS32R6-NEXT:    lui $3, 255
; MIPS32R6-NEXT:    ori $3, $3, 65535
; MIPS32R6-NEXT:    and $2, $2, $4
; MIPS32R6-NEXT:    and $3, $1, $3
; MIPS32R6-NEXT:    jrc $ra
entry:
  %bf.load = load i56, ptr %S, align 1
  %bf.cast = zext i56 %bf.load to i64
  ret i64 %bf.cast
}

define i64 @load7align2(ptr %S) {
; MIPS32-LABEL: load7align2:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    # implicit-def: $v0
; MIPS32-NEXT:    lwl $2, 3($4)
; MIPS32-NEXT:    lwr $2, 0($4)
; MIPS32-NEXT:    # implicit-def: $at
; MIPS32-NEXT:    lwl $1, 7($4)
; MIPS32-NEXT:    lwr $1, 4($4)
; MIPS32-NEXT:    addiu $4, $zero, 65535
; MIPS32-NEXT:    lui $3, 255
; MIPS32-NEXT:    ori $3, $3, 65535
; MIPS32-NEXT:    and $2, $2, $4
; MIPS32-NEXT:    and $3, $1, $3
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load7align2:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lw $2, 0($4)
; MIPS32R6-NEXT:    lw $1, 4($4)
; MIPS32R6-NEXT:    addiu $4, $zero, 65535
; MIPS32R6-NEXT:    lui $3, 255
; MIPS32R6-NEXT:    ori $3, $3, 65535
; MIPS32R6-NEXT:    and $2, $2, $4
; MIPS32R6-NEXT:    and $3, $1, $3
; MIPS32R6-NEXT:    jrc $ra
entry:
  %bf.load = load i56, ptr %S, align 2
  %bf.cast = zext i56 %bf.load to i64
  ret i64 %bf.cast
}

define i64 @load7align4(ptr %S) {
; MIPS32-LABEL: load7align4:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lw $2, 0($4)
; MIPS32-NEXT:    lw $1, 4($4)
; MIPS32-NEXT:    addiu $4, $zero, 65535
; MIPS32-NEXT:    lui $3, 255
; MIPS32-NEXT:    ori $3, $3, 65535
; MIPS32-NEXT:    and $2, $2, $4
; MIPS32-NEXT:    and $3, $1, $3
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load7align4:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lw $2, 0($4)
; MIPS32R6-NEXT:    lw $1, 4($4)
; MIPS32R6-NEXT:    addiu $4, $zero, 65535
; MIPS32R6-NEXT:    lui $3, 255
; MIPS32R6-NEXT:    ori $3, $3, 65535
; MIPS32R6-NEXT:    and $2, $2, $4
; MIPS32R6-NEXT:    and $3, $1, $3
; MIPS32R6-NEXT:    jrc $ra
entry:
  %bf.load = load i56, ptr %S, align 4
  %bf.cast = zext i56 %bf.load to i64
  ret i64 %bf.cast
}

define i64 @load7align8(ptr %S) {
; MIPS32-LABEL: load7align8:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lw $2, 0($4)
; MIPS32-NEXT:    lw $1, 4($4)
; MIPS32-NEXT:    addiu $4, $zero, 65535
; MIPS32-NEXT:    lui $3, 255
; MIPS32-NEXT:    ori $3, $3, 65535
; MIPS32-NEXT:    and $2, $2, $4
; MIPS32-NEXT:    and $3, $1, $3
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load7align8:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lw $2, 0($4)
; MIPS32R6-NEXT:    lw $1, 4($4)
; MIPS32R6-NEXT:    addiu $4, $zero, 65535
; MIPS32R6-NEXT:    lui $3, 255
; MIPS32R6-NEXT:    ori $3, $3, 65535
; MIPS32R6-NEXT:    and $2, $2, $4
; MIPS32R6-NEXT:    and $3, $1, $3
; MIPS32R6-NEXT:    jrc $ra
entry:
  %bf.load = load i56, ptr %S, align 8
  %bf.cast = zext i56 %bf.load to i64
  ret i64 %bf.cast
}

define double @load_double_align1() {
; MIPS32-LABEL: load_double_align1:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(double_align1)
; MIPS32-NEXT:    addiu $3, $1, %lo(double_align1)
; MIPS32-NEXT:    # implicit-def: $at
; MIPS32-NEXT:    lwl $1, 3($3)
; MIPS32-NEXT:    lwr $1, 0($3)
; MIPS32-NEXT:    # implicit-def: $v0
; MIPS32-NEXT:    lwl $2, 7($3)
; MIPS32-NEXT:    lwr $2, 4($3)
; MIPS32-NEXT:    mtc1 $1, $f0
; MIPS32-NEXT:    mtc1 $2, $f1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load_double_align1:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(double_align1)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(double_align1)
; MIPS32R6-NEXT:    ldc1 $f0, 0($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = load double, ptr @double_align1, align 1
  ret double %0
}

define double @load_double_align2() {
; MIPS32-LABEL: load_double_align2:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(double_align2)
; MIPS32-NEXT:    addiu $3, $1, %lo(double_align2)
; MIPS32-NEXT:    # implicit-def: $at
; MIPS32-NEXT:    lwl $1, 3($3)
; MIPS32-NEXT:    lwr $1, 0($3)
; MIPS32-NEXT:    # implicit-def: $v0
; MIPS32-NEXT:    lwl $2, 7($3)
; MIPS32-NEXT:    lwr $2, 4($3)
; MIPS32-NEXT:    mtc1 $1, $f0
; MIPS32-NEXT:    mtc1 $2, $f1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load_double_align2:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(double_align2)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(double_align2)
; MIPS32R6-NEXT:    ldc1 $f0, 0($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = load double, ptr @double_align2, align 2
  ret double %0
}

define double @load_double_align4() {
; MIPS32-LABEL: load_double_align4:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(double_align4)
; MIPS32-NEXT:    addiu $2, $1, %lo(double_align4)
; MIPS32-NEXT:    lw $1, 0($2)
; MIPS32-NEXT:    lw $2, 4($2)
; MIPS32-NEXT:    mtc1 $1, $f0
; MIPS32-NEXT:    mtc1 $2, $f1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load_double_align4:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(double_align4)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(double_align4)
; MIPS32R6-NEXT:    ldc1 $f0, 0($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = load double, ptr @double_align4, align 4
  ret double %0
}

define double @load_double_align8() {
; MIPS32-LABEL: load_double_align8:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(double_align8)
; MIPS32-NEXT:    addiu $1, $1, %lo(double_align8)
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load_double_align8:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(double_align8)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(double_align8)
; MIPS32R6-NEXT:    ldc1 $f0, 0($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = load double, ptr @double_align8, align 8
  ret double %0
}

define i64 @load_i64_align1() {
; MIPS32-LABEL: load_i64_align1:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(i64_align1)
; MIPS32-NEXT:    addiu $1, $1, %lo(i64_align1)
; MIPS32-NEXT:    # implicit-def: $v0
; MIPS32-NEXT:    lwl $2, 3($1)
; MIPS32-NEXT:    lwr $2, 0($1)
; MIPS32-NEXT:    # implicit-def: $v1
; MIPS32-NEXT:    lwl $3, 7($1)
; MIPS32-NEXT:    lwr $3, 4($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load_i64_align1:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(i64_align1)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(i64_align1)
; MIPS32R6-NEXT:    lw $2, 0($1)
; MIPS32R6-NEXT:    lw $3, 4($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = load i64, ptr @i64_align1, align 1
  ret i64 %0
}

define i64 @load_i64_align2() {
; MIPS32-LABEL: load_i64_align2:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(i64_align2)
; MIPS32-NEXT:    addiu $1, $1, %lo(i64_align2)
; MIPS32-NEXT:    # implicit-def: $v0
; MIPS32-NEXT:    lwl $2, 3($1)
; MIPS32-NEXT:    lwr $2, 0($1)
; MIPS32-NEXT:    # implicit-def: $v1
; MIPS32-NEXT:    lwl $3, 7($1)
; MIPS32-NEXT:    lwr $3, 4($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load_i64_align2:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(i64_align2)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(i64_align2)
; MIPS32R6-NEXT:    lw $2, 0($1)
; MIPS32R6-NEXT:    lw $3, 4($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = load i64, ptr @i64_align2, align 2
  ret i64 %0
}

define i64 @load_i64_align4() {
; MIPS32-LABEL: load_i64_align4:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(i64_align4)
; MIPS32-NEXT:    addiu $1, $1, %lo(i64_align4)
; MIPS32-NEXT:    lw $2, 0($1)
; MIPS32-NEXT:    lw $3, 4($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load_i64_align4:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(i64_align4)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(i64_align4)
; MIPS32R6-NEXT:    lw $2, 0($1)
; MIPS32R6-NEXT:    lw $3, 4($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = load i64, ptr @i64_align4, align 4
  ret i64 %0
}

define i64 @load_i64_align8() {
; MIPS32-LABEL: load_i64_align8:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(i64_align8)
; MIPS32-NEXT:    addiu $1, $1, %lo(i64_align8)
; MIPS32-NEXT:    lw $2, 0($1)
; MIPS32-NEXT:    lw $3, 4($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: load_i64_align8:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(i64_align8)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(i64_align8)
; MIPS32R6-NEXT:    lw $2, 0($1)
; MIPS32R6-NEXT:    lw $3, 4($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  %0 = load i64, ptr @i64_align8, align 8
  ret i64 %0
}
