; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch64 -mattr=+d,-ld-seq-sa < %s | FileCheck %s --check-prefixes=LA64,NO-LD-SEQ-SA
; RUN: llc --mtriple=loongarch64 -mattr=+d,+ld-seq-sa < %s | FileCheck %s --check-prefixes=LA64,LD-SEQ-SA
; RUN: llc --mtriple=loongarch64 -mattr=+d,+lamcas < %s | FileCheck %s --check-prefix=LA64-LAMCAS

define void @cmpxchg_i8_acquire_acquire(ptr %ptr, i8 %cmp, i8 %val) nounwind {
; LA64-LABEL: cmpxchg_i8_acquire_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a3, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a4, $zero, 255
; LA64-NEXT:    sll.w $a4, $a4, $a3
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a3
; LA64-NEXT:    andi $a2, $a2, 255
; LA64-NEXT:    sll.w $a2, $a2, $a3
; LA64-NEXT:  .LBB0_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a3, $a0, 0
; LA64-NEXT:    and $a5, $a3, $a4
; LA64-NEXT:    bne $a5, $a1, .LBB0_3
; LA64-NEXT:  # %bb.2: # in Loop: Header=BB0_1 Depth=1
; LA64-NEXT:    andn $a5, $a3, $a4
; LA64-NEXT:    or $a5, $a5, $a2
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB0_1
; LA64-NEXT:    b .LBB0_4
; LA64-NEXT:  .LBB0_3:
; LA64-NEXT:    dbar 20
; LA64-NEXT:  .LBB0_4:
; LA64-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i8_acquire_acquire:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    amcas_db.b $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    ret
  %res = cmpxchg ptr %ptr, i8 %cmp, i8 %val acquire acquire
  ret void
}

define void @cmpxchg_i16_acquire_acquire(ptr %ptr, i16 %cmp, i16 %val) nounwind {
; LA64-LABEL: cmpxchg_i16_acquire_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a3, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a4, 15
; LA64-NEXT:    ori $a4, $a4, 4095
; LA64-NEXT:    sll.w $a4, $a4, $a3
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a3
; LA64-NEXT:    bstrpick.d $a2, $a2, 15, 0
; LA64-NEXT:    sll.w $a2, $a2, $a3
; LA64-NEXT:  .LBB1_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a3, $a0, 0
; LA64-NEXT:    and $a5, $a3, $a4
; LA64-NEXT:    bne $a5, $a1, .LBB1_3
; LA64-NEXT:  # %bb.2: # in Loop: Header=BB1_1 Depth=1
; LA64-NEXT:    andn $a5, $a3, $a4
; LA64-NEXT:    or $a5, $a5, $a2
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB1_1
; LA64-NEXT:    b .LBB1_4
; LA64-NEXT:  .LBB1_3:
; LA64-NEXT:    dbar 20
; LA64-NEXT:  .LBB1_4:
; LA64-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i16_acquire_acquire:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    amcas_db.h $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    ret
  %res = cmpxchg ptr %ptr, i16 %cmp, i16 %val acquire acquire
  ret void
}

define void @cmpxchg_i32_acquire_acquire(ptr %ptr, i32 %cmp, i32 %val) nounwind {
; LA64-LABEL: cmpxchg_i32_acquire_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:    addi.w $a1, $a1, 0
; LA64-NEXT:  .LBB2_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a3, $a0, 0
; LA64-NEXT:    bne $a3, $a1, .LBB2_3
; LA64-NEXT:  # %bb.2: # in Loop: Header=BB2_1 Depth=1
; LA64-NEXT:    move $a4, $a2
; LA64-NEXT:    sc.w $a4, $a0, 0
; LA64-NEXT:    beq $a4, $zero, .LBB2_1
; LA64-NEXT:    b .LBB2_4
; LA64-NEXT:  .LBB2_3:
; LA64-NEXT:    dbar 20
; LA64-NEXT:  .LBB2_4:
; LA64-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i32_acquire_acquire:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    amcas_db.w $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    ret
  %res = cmpxchg ptr %ptr, i32 %cmp, i32 %val acquire acquire
  ret void
}

define void @cmpxchg_i64_acquire_acquire(ptr %ptr, i64 %cmp, i64 %val) nounwind {
; LA64-LABEL: cmpxchg_i64_acquire_acquire:
; LA64:       # %bb.0:
; LA64-NEXT:  .LBB3_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.d $a3, $a0, 0
; LA64-NEXT:    bne $a3, $a1, .LBB3_3
; LA64-NEXT:  # %bb.2: # in Loop: Header=BB3_1 Depth=1
; LA64-NEXT:    move $a4, $a2
; LA64-NEXT:    sc.d $a4, $a0, 0
; LA64-NEXT:    beq $a4, $zero, .LBB3_1
; LA64-NEXT:    b .LBB3_4
; LA64-NEXT:  .LBB3_3:
; LA64-NEXT:    dbar 20
; LA64-NEXT:  .LBB3_4:
; LA64-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i64_acquire_acquire:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    amcas_db.d $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    ret
  %res = cmpxchg ptr %ptr, i64 %cmp, i64 %val acquire acquire
  ret void
}

define void @cmpxchg_i8_acquire_monotonic(ptr %ptr, i8 %cmp, i8 %val) nounwind {
; NO-LD-SEQ-SA-LABEL: cmpxchg_i8_acquire_monotonic:
; NO-LD-SEQ-SA:       # %bb.0:
; NO-LD-SEQ-SA-NEXT:    slli.d $a3, $a0, 3
; NO-LD-SEQ-SA-NEXT:    bstrins.d $a0, $zero, 1, 0
; NO-LD-SEQ-SA-NEXT:    ori $a4, $zero, 255
; NO-LD-SEQ-SA-NEXT:    sll.w $a4, $a4, $a3
; NO-LD-SEQ-SA-NEXT:    andi $a1, $a1, 255
; NO-LD-SEQ-SA-NEXT:    sll.w $a1, $a1, $a3
; NO-LD-SEQ-SA-NEXT:    andi $a2, $a2, 255
; NO-LD-SEQ-SA-NEXT:    sll.w $a2, $a2, $a3
; NO-LD-SEQ-SA-NEXT:  .LBB4_1: # =>This Inner Loop Header: Depth=1
; NO-LD-SEQ-SA-NEXT:    ll.w $a3, $a0, 0
; NO-LD-SEQ-SA-NEXT:    and $a5, $a3, $a4
; NO-LD-SEQ-SA-NEXT:    bne $a5, $a1, .LBB4_3
; NO-LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB4_1 Depth=1
; NO-LD-SEQ-SA-NEXT:    andn $a5, $a3, $a4
; NO-LD-SEQ-SA-NEXT:    or $a5, $a5, $a2
; NO-LD-SEQ-SA-NEXT:    sc.w $a5, $a0, 0
; NO-LD-SEQ-SA-NEXT:    beq $a5, $zero, .LBB4_1
; NO-LD-SEQ-SA-NEXT:    b .LBB4_4
; NO-LD-SEQ-SA-NEXT:  .LBB4_3:
; NO-LD-SEQ-SA-NEXT:    dbar 1792
; NO-LD-SEQ-SA-NEXT:  .LBB4_4:
; NO-LD-SEQ-SA-NEXT:    ret
;
; LD-SEQ-SA-LABEL: cmpxchg_i8_acquire_monotonic:
; LD-SEQ-SA:       # %bb.0:
; LD-SEQ-SA-NEXT:    slli.d $a3, $a0, 3
; LD-SEQ-SA-NEXT:    bstrins.d $a0, $zero, 1, 0
; LD-SEQ-SA-NEXT:    ori $a4, $zero, 255
; LD-SEQ-SA-NEXT:    sll.w $a4, $a4, $a3
; LD-SEQ-SA-NEXT:    andi $a1, $a1, 255
; LD-SEQ-SA-NEXT:    sll.w $a1, $a1, $a3
; LD-SEQ-SA-NEXT:    andi $a2, $a2, 255
; LD-SEQ-SA-NEXT:    sll.w $a2, $a2, $a3
; LD-SEQ-SA-NEXT:  .LBB4_1: # =>This Inner Loop Header: Depth=1
; LD-SEQ-SA-NEXT:    ll.w $a3, $a0, 0
; LD-SEQ-SA-NEXT:    and $a5, $a3, $a4
; LD-SEQ-SA-NEXT:    bne $a5, $a1, .LBB4_3
; LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB4_1 Depth=1
; LD-SEQ-SA-NEXT:    andn $a5, $a3, $a4
; LD-SEQ-SA-NEXT:    or $a5, $a5, $a2
; LD-SEQ-SA-NEXT:    sc.w $a5, $a0, 0
; LD-SEQ-SA-NEXT:    beq $a5, $zero, .LBB4_1
; LD-SEQ-SA-NEXT:    b .LBB4_4
; LD-SEQ-SA-NEXT:  .LBB4_3:
; LD-SEQ-SA-NEXT:  .LBB4_4:
; LD-SEQ-SA-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i8_acquire_monotonic:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    amcas_db.b $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    ret
  %res = cmpxchg ptr %ptr, i8 %cmp, i8 %val acquire monotonic
  ret void
}

define void @cmpxchg_i16_acquire_monotonic(ptr %ptr, i16 %cmp, i16 %val) nounwind {
; NO-LD-SEQ-SA-LABEL: cmpxchg_i16_acquire_monotonic:
; NO-LD-SEQ-SA:       # %bb.0:
; NO-LD-SEQ-SA-NEXT:    slli.d $a3, $a0, 3
; NO-LD-SEQ-SA-NEXT:    bstrins.d $a0, $zero, 1, 0
; NO-LD-SEQ-SA-NEXT:    lu12i.w $a4, 15
; NO-LD-SEQ-SA-NEXT:    ori $a4, $a4, 4095
; NO-LD-SEQ-SA-NEXT:    sll.w $a4, $a4, $a3
; NO-LD-SEQ-SA-NEXT:    bstrpick.d $a1, $a1, 15, 0
; NO-LD-SEQ-SA-NEXT:    sll.w $a1, $a1, $a3
; NO-LD-SEQ-SA-NEXT:    bstrpick.d $a2, $a2, 15, 0
; NO-LD-SEQ-SA-NEXT:    sll.w $a2, $a2, $a3
; NO-LD-SEQ-SA-NEXT:  .LBB5_1: # =>This Inner Loop Header: Depth=1
; NO-LD-SEQ-SA-NEXT:    ll.w $a3, $a0, 0
; NO-LD-SEQ-SA-NEXT:    and $a5, $a3, $a4
; NO-LD-SEQ-SA-NEXT:    bne $a5, $a1, .LBB5_3
; NO-LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB5_1 Depth=1
; NO-LD-SEQ-SA-NEXT:    andn $a5, $a3, $a4
; NO-LD-SEQ-SA-NEXT:    or $a5, $a5, $a2
; NO-LD-SEQ-SA-NEXT:    sc.w $a5, $a0, 0
; NO-LD-SEQ-SA-NEXT:    beq $a5, $zero, .LBB5_1
; NO-LD-SEQ-SA-NEXT:    b .LBB5_4
; NO-LD-SEQ-SA-NEXT:  .LBB5_3:
; NO-LD-SEQ-SA-NEXT:    dbar 1792
; NO-LD-SEQ-SA-NEXT:  .LBB5_4:
; NO-LD-SEQ-SA-NEXT:    ret
;
; LD-SEQ-SA-LABEL: cmpxchg_i16_acquire_monotonic:
; LD-SEQ-SA:       # %bb.0:
; LD-SEQ-SA-NEXT:    slli.d $a3, $a0, 3
; LD-SEQ-SA-NEXT:    bstrins.d $a0, $zero, 1, 0
; LD-SEQ-SA-NEXT:    lu12i.w $a4, 15
; LD-SEQ-SA-NEXT:    ori $a4, $a4, 4095
; LD-SEQ-SA-NEXT:    sll.w $a4, $a4, $a3
; LD-SEQ-SA-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LD-SEQ-SA-NEXT:    sll.w $a1, $a1, $a3
; LD-SEQ-SA-NEXT:    bstrpick.d $a2, $a2, 15, 0
; LD-SEQ-SA-NEXT:    sll.w $a2, $a2, $a3
; LD-SEQ-SA-NEXT:  .LBB5_1: # =>This Inner Loop Header: Depth=1
; LD-SEQ-SA-NEXT:    ll.w $a3, $a0, 0
; LD-SEQ-SA-NEXT:    and $a5, $a3, $a4
; LD-SEQ-SA-NEXT:    bne $a5, $a1, .LBB5_3
; LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB5_1 Depth=1
; LD-SEQ-SA-NEXT:    andn $a5, $a3, $a4
; LD-SEQ-SA-NEXT:    or $a5, $a5, $a2
; LD-SEQ-SA-NEXT:    sc.w $a5, $a0, 0
; LD-SEQ-SA-NEXT:    beq $a5, $zero, .LBB5_1
; LD-SEQ-SA-NEXT:    b .LBB5_4
; LD-SEQ-SA-NEXT:  .LBB5_3:
; LD-SEQ-SA-NEXT:  .LBB5_4:
; LD-SEQ-SA-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i16_acquire_monotonic:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    amcas_db.h $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    ret
  %res = cmpxchg ptr %ptr, i16 %cmp, i16 %val acquire monotonic
  ret void
}

define void @cmpxchg_i32_acquire_monotonic(ptr %ptr, i32 %cmp, i32 %val) nounwind {
; NO-LD-SEQ-SA-LABEL: cmpxchg_i32_acquire_monotonic:
; NO-LD-SEQ-SA:       # %bb.0:
; NO-LD-SEQ-SA-NEXT:    addi.w $a1, $a1, 0
; NO-LD-SEQ-SA-NEXT:  .LBB6_1: # =>This Inner Loop Header: Depth=1
; NO-LD-SEQ-SA-NEXT:    ll.w $a3, $a0, 0
; NO-LD-SEQ-SA-NEXT:    bne $a3, $a1, .LBB6_3
; NO-LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB6_1 Depth=1
; NO-LD-SEQ-SA-NEXT:    move $a4, $a2
; NO-LD-SEQ-SA-NEXT:    sc.w $a4, $a0, 0
; NO-LD-SEQ-SA-NEXT:    beq $a4, $zero, .LBB6_1
; NO-LD-SEQ-SA-NEXT:    b .LBB6_4
; NO-LD-SEQ-SA-NEXT:  .LBB6_3:
; NO-LD-SEQ-SA-NEXT:    dbar 1792
; NO-LD-SEQ-SA-NEXT:  .LBB6_4:
; NO-LD-SEQ-SA-NEXT:    ret
;
; LD-SEQ-SA-LABEL: cmpxchg_i32_acquire_monotonic:
; LD-SEQ-SA:       # %bb.0:
; LD-SEQ-SA-NEXT:    addi.w $a1, $a1, 0
; LD-SEQ-SA-NEXT:  .LBB6_1: # =>This Inner Loop Header: Depth=1
; LD-SEQ-SA-NEXT:    ll.w $a3, $a0, 0
; LD-SEQ-SA-NEXT:    bne $a3, $a1, .LBB6_3
; LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB6_1 Depth=1
; LD-SEQ-SA-NEXT:    move $a4, $a2
; LD-SEQ-SA-NEXT:    sc.w $a4, $a0, 0
; LD-SEQ-SA-NEXT:    beq $a4, $zero, .LBB6_1
; LD-SEQ-SA-NEXT:    b .LBB6_4
; LD-SEQ-SA-NEXT:  .LBB6_3:
; LD-SEQ-SA-NEXT:  .LBB6_4:
; LD-SEQ-SA-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i32_acquire_monotonic:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    amcas_db.w $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    ret
  %res = cmpxchg ptr %ptr, i32 %cmp, i32 %val acquire monotonic
  ret void
}

define void @cmpxchg_i64_acquire_monotonic(ptr %ptr, i64 %cmp, i64 %val) nounwind {
; NO-LD-SEQ-SA-LABEL: cmpxchg_i64_acquire_monotonic:
; NO-LD-SEQ-SA:       # %bb.0:
; NO-LD-SEQ-SA-NEXT:  .LBB7_1: # =>This Inner Loop Header: Depth=1
; NO-LD-SEQ-SA-NEXT:    ll.d $a3, $a0, 0
; NO-LD-SEQ-SA-NEXT:    bne $a3, $a1, .LBB7_3
; NO-LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB7_1 Depth=1
; NO-LD-SEQ-SA-NEXT:    move $a4, $a2
; NO-LD-SEQ-SA-NEXT:    sc.d $a4, $a0, 0
; NO-LD-SEQ-SA-NEXT:    beq $a4, $zero, .LBB7_1
; NO-LD-SEQ-SA-NEXT:    b .LBB7_4
; NO-LD-SEQ-SA-NEXT:  .LBB7_3:
; NO-LD-SEQ-SA-NEXT:    dbar 1792
; NO-LD-SEQ-SA-NEXT:  .LBB7_4:
; NO-LD-SEQ-SA-NEXT:    ret
;
; LD-SEQ-SA-LABEL: cmpxchg_i64_acquire_monotonic:
; LD-SEQ-SA:       # %bb.0:
; LD-SEQ-SA-NEXT:  .LBB7_1: # =>This Inner Loop Header: Depth=1
; LD-SEQ-SA-NEXT:    ll.d $a3, $a0, 0
; LD-SEQ-SA-NEXT:    bne $a3, $a1, .LBB7_3
; LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB7_1 Depth=1
; LD-SEQ-SA-NEXT:    move $a4, $a2
; LD-SEQ-SA-NEXT:    sc.d $a4, $a0, 0
; LD-SEQ-SA-NEXT:    beq $a4, $zero, .LBB7_1
; LD-SEQ-SA-NEXT:    b .LBB7_4
; LD-SEQ-SA-NEXT:  .LBB7_3:
; LD-SEQ-SA-NEXT:  .LBB7_4:
; LD-SEQ-SA-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i64_acquire_monotonic:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    amcas_db.d $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    ret
  %res = cmpxchg ptr %ptr, i64 %cmp, i64 %val acquire monotonic
  ret void
}

define i8 @cmpxchg_i8_acquire_acquire_reti8(ptr %ptr, i8 %cmp, i8 %val) nounwind {
; LA64-LABEL: cmpxchg_i8_acquire_acquire_reti8:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a3, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a4, $zero, 255
; LA64-NEXT:    sll.w $a4, $a4, $a3
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a3
; LA64-NEXT:    andi $a2, $a2, 255
; LA64-NEXT:    sll.w $a2, $a2, $a3
; LA64-NEXT:  .LBB8_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a5, $a0, 0
; LA64-NEXT:    and $a6, $a5, $a4
; LA64-NEXT:    bne $a6, $a1, .LBB8_3
; LA64-NEXT:  # %bb.2: # in Loop: Header=BB8_1 Depth=1
; LA64-NEXT:    andn $a6, $a5, $a4
; LA64-NEXT:    or $a6, $a6, $a2
; LA64-NEXT:    sc.w $a6, $a0, 0
; LA64-NEXT:    beq $a6, $zero, .LBB8_1
; LA64-NEXT:    b .LBB8_4
; LA64-NEXT:  .LBB8_3:
; LA64-NEXT:    dbar 20
; LA64-NEXT:  .LBB8_4:
; LA64-NEXT:    srl.w $a0, $a5, $a3
; LA64-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i8_acquire_acquire_reti8:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    amcas_db.b $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    move $a0, $a1
; LA64-LAMCAS-NEXT:    ret
  %tmp = cmpxchg ptr %ptr, i8 %cmp, i8 %val acquire acquire
  %res = extractvalue { i8, i1 } %tmp, 0
  ret i8 %res
}

define i16 @cmpxchg_i16_acquire_acquire_reti16(ptr %ptr, i16 %cmp, i16 %val) nounwind {
; LA64-LABEL: cmpxchg_i16_acquire_acquire_reti16:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a3, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a4, 15
; LA64-NEXT:    ori $a4, $a4, 4095
; LA64-NEXT:    sll.w $a4, $a4, $a3
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a3
; LA64-NEXT:    bstrpick.d $a2, $a2, 15, 0
; LA64-NEXT:    sll.w $a2, $a2, $a3
; LA64-NEXT:  .LBB9_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a5, $a0, 0
; LA64-NEXT:    and $a6, $a5, $a4
; LA64-NEXT:    bne $a6, $a1, .LBB9_3
; LA64-NEXT:  # %bb.2: # in Loop: Header=BB9_1 Depth=1
; LA64-NEXT:    andn $a6, $a5, $a4
; LA64-NEXT:    or $a6, $a6, $a2
; LA64-NEXT:    sc.w $a6, $a0, 0
; LA64-NEXT:    beq $a6, $zero, .LBB9_1
; LA64-NEXT:    b .LBB9_4
; LA64-NEXT:  .LBB9_3:
; LA64-NEXT:    dbar 20
; LA64-NEXT:  .LBB9_4:
; LA64-NEXT:    srl.w $a0, $a5, $a3
; LA64-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i16_acquire_acquire_reti16:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    amcas_db.h $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    move $a0, $a1
; LA64-LAMCAS-NEXT:    ret
  %tmp = cmpxchg ptr %ptr, i16 %cmp, i16 %val acquire acquire
  %res = extractvalue { i16, i1 } %tmp, 0
  ret i16 %res
}

define i32 @cmpxchg_i32_acquire_acquire_reti32(ptr %ptr, i32 %cmp, i32 %val) nounwind {
; LA64-LABEL: cmpxchg_i32_acquire_acquire_reti32:
; LA64:       # %bb.0:
; LA64-NEXT:    addi.w $a3, $a1, 0
; LA64-NEXT:  .LBB10_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a1, $a0, 0
; LA64-NEXT:    bne $a1, $a3, .LBB10_3
; LA64-NEXT:  # %bb.2: # in Loop: Header=BB10_1 Depth=1
; LA64-NEXT:    move $a4, $a2
; LA64-NEXT:    sc.w $a4, $a0, 0
; LA64-NEXT:    beq $a4, $zero, .LBB10_1
; LA64-NEXT:    b .LBB10_4
; LA64-NEXT:  .LBB10_3:
; LA64-NEXT:    dbar 20
; LA64-NEXT:  .LBB10_4:
; LA64-NEXT:    move $a0, $a1
; LA64-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i32_acquire_acquire_reti32:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    amcas_db.w $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    move $a0, $a1
; LA64-LAMCAS-NEXT:    ret
  %tmp = cmpxchg ptr %ptr, i32 %cmp, i32 %val acquire acquire
  %res = extractvalue { i32, i1 } %tmp, 0
  ret i32 %res
}

define i64 @cmpxchg_i64_acquire_acquire_reti64(ptr %ptr, i64 %cmp, i64 %val) nounwind {
; LA64-LABEL: cmpxchg_i64_acquire_acquire_reti64:
; LA64:       # %bb.0:
; LA64-NEXT:  .LBB11_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.d $a3, $a0, 0
; LA64-NEXT:    bne $a3, $a1, .LBB11_3
; LA64-NEXT:  # %bb.2: # in Loop: Header=BB11_1 Depth=1
; LA64-NEXT:    move $a4, $a2
; LA64-NEXT:    sc.d $a4, $a0, 0
; LA64-NEXT:    beq $a4, $zero, .LBB11_1
; LA64-NEXT:    b .LBB11_4
; LA64-NEXT:  .LBB11_3:
; LA64-NEXT:    dbar 20
; LA64-NEXT:  .LBB11_4:
; LA64-NEXT:    move $a0, $a3
; LA64-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i64_acquire_acquire_reti64:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    amcas_db.d $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    move $a0, $a1
; LA64-LAMCAS-NEXT:    ret
  %tmp = cmpxchg ptr %ptr, i64 %cmp, i64 %val acquire acquire
  %res = extractvalue { i64, i1 } %tmp, 0
  ret i64 %res
}

define i1 @cmpxchg_i8_acquire_acquire_reti1(ptr %ptr, i8 %cmp, i8 %val) nounwind {
; LA64-LABEL: cmpxchg_i8_acquire_acquire_reti1:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a3, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    ori $a4, $zero, 255
; LA64-NEXT:    sll.w $a4, $a4, $a3
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    sll.w $a1, $a1, $a3
; LA64-NEXT:    andi $a2, $a2, 255
; LA64-NEXT:    sll.w $a2, $a2, $a3
; LA64-NEXT:  .LBB12_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a3, $a0, 0
; LA64-NEXT:    and $a5, $a3, $a4
; LA64-NEXT:    bne $a5, $a1, .LBB12_3
; LA64-NEXT:  # %bb.2: # in Loop: Header=BB12_1 Depth=1
; LA64-NEXT:    andn $a5, $a3, $a4
; LA64-NEXT:    or $a5, $a5, $a2
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB12_1
; LA64-NEXT:    b .LBB12_4
; LA64-NEXT:  .LBB12_3:
; LA64-NEXT:    dbar 20
; LA64-NEXT:  .LBB12_4:
; LA64-NEXT:    and $a0, $a3, $a4
; LA64-NEXT:    xor $a0, $a1, $a0
; LA64-NEXT:    sltui $a0, $a0, 1
; LA64-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i8_acquire_acquire_reti1:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    ext.w.b $a3, $a1
; LA64-LAMCAS-NEXT:    amcas_db.b $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    xor $a0, $a1, $a3
; LA64-LAMCAS-NEXT:    sltui $a0, $a0, 1
; LA64-LAMCAS-NEXT:    ret
  %tmp = cmpxchg ptr %ptr, i8 %cmp, i8 %val acquire acquire
  %res = extractvalue { i8, i1 } %tmp, 1
  ret i1 %res
}

define i1 @cmpxchg_i16_acquire_acquire_reti1(ptr %ptr, i16 %cmp, i16 %val) nounwind {
; LA64-LABEL: cmpxchg_i16_acquire_acquire_reti1:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a3, $a0, 3
; LA64-NEXT:    bstrins.d $a0, $zero, 1, 0
; LA64-NEXT:    lu12i.w $a4, 15
; LA64-NEXT:    ori $a4, $a4, 4095
; LA64-NEXT:    sll.w $a4, $a4, $a3
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    sll.w $a1, $a1, $a3
; LA64-NEXT:    bstrpick.d $a2, $a2, 15, 0
; LA64-NEXT:    sll.w $a2, $a2, $a3
; LA64-NEXT:  .LBB13_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a3, $a0, 0
; LA64-NEXT:    and $a5, $a3, $a4
; LA64-NEXT:    bne $a5, $a1, .LBB13_3
; LA64-NEXT:  # %bb.2: # in Loop: Header=BB13_1 Depth=1
; LA64-NEXT:    andn $a5, $a3, $a4
; LA64-NEXT:    or $a5, $a5, $a2
; LA64-NEXT:    sc.w $a5, $a0, 0
; LA64-NEXT:    beq $a5, $zero, .LBB13_1
; LA64-NEXT:    b .LBB13_4
; LA64-NEXT:  .LBB13_3:
; LA64-NEXT:    dbar 20
; LA64-NEXT:  .LBB13_4:
; LA64-NEXT:    and $a0, $a3, $a4
; LA64-NEXT:    xor $a0, $a1, $a0
; LA64-NEXT:    sltui $a0, $a0, 1
; LA64-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i16_acquire_acquire_reti1:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    ext.w.h $a3, $a1
; LA64-LAMCAS-NEXT:    amcas_db.h $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    xor $a0, $a1, $a3
; LA64-LAMCAS-NEXT:    sltui $a0, $a0, 1
; LA64-LAMCAS-NEXT:    ret
  %tmp = cmpxchg ptr %ptr, i16 %cmp, i16 %val acquire acquire
  %res = extractvalue { i16, i1 } %tmp, 1
  ret i1 %res
}

define i1 @cmpxchg_i32_acquire_acquire_reti1(ptr %ptr, i32 %cmp, i32 %val) nounwind {
; LA64-LABEL: cmpxchg_i32_acquire_acquire_reti1:
; LA64:       # %bb.0:
; LA64-NEXT:    addi.w $a1, $a1, 0
; LA64-NEXT:  .LBB14_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.w $a3, $a0, 0
; LA64-NEXT:    bne $a3, $a1, .LBB14_3
; LA64-NEXT:  # %bb.2: # in Loop: Header=BB14_1 Depth=1
; LA64-NEXT:    move $a4, $a2
; LA64-NEXT:    sc.w $a4, $a0, 0
; LA64-NEXT:    beq $a4, $zero, .LBB14_1
; LA64-NEXT:    b .LBB14_4
; LA64-NEXT:  .LBB14_3:
; LA64-NEXT:    dbar 20
; LA64-NEXT:  .LBB14_4:
; LA64-NEXT:    xor $a0, $a3, $a1
; LA64-NEXT:    sltui $a0, $a0, 1
; LA64-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i32_acquire_acquire_reti1:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    addi.w $a3, $a1, 0
; LA64-LAMCAS-NEXT:    amcas_db.w $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    xor $a0, $a1, $a3
; LA64-LAMCAS-NEXT:    sltui $a0, $a0, 1
; LA64-LAMCAS-NEXT:    ret
  %tmp = cmpxchg ptr %ptr, i32 %cmp, i32 %val acquire acquire
  %res = extractvalue { i32, i1 } %tmp, 1
  ret i1 %res
}

define i1 @cmpxchg_i64_acquire_acquire_reti1(ptr %ptr, i64 %cmp, i64 %val) nounwind {
; LA64-LABEL: cmpxchg_i64_acquire_acquire_reti1:
; LA64:       # %bb.0:
; LA64-NEXT:  .LBB15_1: # =>This Inner Loop Header: Depth=1
; LA64-NEXT:    ll.d $a3, $a0, 0
; LA64-NEXT:    bne $a3, $a1, .LBB15_3
; LA64-NEXT:  # %bb.2: # in Loop: Header=BB15_1 Depth=1
; LA64-NEXT:    move $a4, $a2
; LA64-NEXT:    sc.d $a4, $a0, 0
; LA64-NEXT:    beq $a4, $zero, .LBB15_1
; LA64-NEXT:    b .LBB15_4
; LA64-NEXT:  .LBB15_3:
; LA64-NEXT:    dbar 20
; LA64-NEXT:  .LBB15_4:
; LA64-NEXT:    xor $a0, $a3, $a1
; LA64-NEXT:    sltui $a0, $a0, 1
; LA64-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i64_acquire_acquire_reti1:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    move $a3, $a1
; LA64-LAMCAS-NEXT:    amcas_db.d $a3, $a2, $a0
; LA64-LAMCAS-NEXT:    xor $a0, $a3, $a1
; LA64-LAMCAS-NEXT:    sltui $a0, $a0, 1
; LA64-LAMCAS-NEXT:    ret
  %tmp = cmpxchg ptr %ptr, i64 %cmp, i64 %val acquire acquire
  %res = extractvalue { i64, i1 } %tmp, 1
  ret i1 %res
}

define void @cmpxchg_i8_monotonic_monotonic(ptr %ptr, i8 %cmp, i8 %val) nounwind {
; NO-LD-SEQ-SA-LABEL: cmpxchg_i8_monotonic_monotonic:
; NO-LD-SEQ-SA:       # %bb.0:
; NO-LD-SEQ-SA-NEXT:    slli.d $a3, $a0, 3
; NO-LD-SEQ-SA-NEXT:    bstrins.d $a0, $zero, 1, 0
; NO-LD-SEQ-SA-NEXT:    ori $a4, $zero, 255
; NO-LD-SEQ-SA-NEXT:    sll.w $a4, $a4, $a3
; NO-LD-SEQ-SA-NEXT:    andi $a1, $a1, 255
; NO-LD-SEQ-SA-NEXT:    sll.w $a1, $a1, $a3
; NO-LD-SEQ-SA-NEXT:    andi $a2, $a2, 255
; NO-LD-SEQ-SA-NEXT:    sll.w $a2, $a2, $a3
; NO-LD-SEQ-SA-NEXT:  .LBB16_1: # =>This Inner Loop Header: Depth=1
; NO-LD-SEQ-SA-NEXT:    ll.w $a3, $a0, 0
; NO-LD-SEQ-SA-NEXT:    and $a5, $a3, $a4
; NO-LD-SEQ-SA-NEXT:    bne $a5, $a1, .LBB16_3
; NO-LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB16_1 Depth=1
; NO-LD-SEQ-SA-NEXT:    andn $a5, $a3, $a4
; NO-LD-SEQ-SA-NEXT:    or $a5, $a5, $a2
; NO-LD-SEQ-SA-NEXT:    sc.w $a5, $a0, 0
; NO-LD-SEQ-SA-NEXT:    beq $a5, $zero, .LBB16_1
; NO-LD-SEQ-SA-NEXT:    b .LBB16_4
; NO-LD-SEQ-SA-NEXT:  .LBB16_3:
; NO-LD-SEQ-SA-NEXT:    dbar 1792
; NO-LD-SEQ-SA-NEXT:  .LBB16_4:
; NO-LD-SEQ-SA-NEXT:    ret
;
; LD-SEQ-SA-LABEL: cmpxchg_i8_monotonic_monotonic:
; LD-SEQ-SA:       # %bb.0:
; LD-SEQ-SA-NEXT:    slli.d $a3, $a0, 3
; LD-SEQ-SA-NEXT:    bstrins.d $a0, $zero, 1, 0
; LD-SEQ-SA-NEXT:    ori $a4, $zero, 255
; LD-SEQ-SA-NEXT:    sll.w $a4, $a4, $a3
; LD-SEQ-SA-NEXT:    andi $a1, $a1, 255
; LD-SEQ-SA-NEXT:    sll.w $a1, $a1, $a3
; LD-SEQ-SA-NEXT:    andi $a2, $a2, 255
; LD-SEQ-SA-NEXT:    sll.w $a2, $a2, $a3
; LD-SEQ-SA-NEXT:  .LBB16_1: # =>This Inner Loop Header: Depth=1
; LD-SEQ-SA-NEXT:    ll.w $a3, $a0, 0
; LD-SEQ-SA-NEXT:    and $a5, $a3, $a4
; LD-SEQ-SA-NEXT:    bne $a5, $a1, .LBB16_3
; LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB16_1 Depth=1
; LD-SEQ-SA-NEXT:    andn $a5, $a3, $a4
; LD-SEQ-SA-NEXT:    or $a5, $a5, $a2
; LD-SEQ-SA-NEXT:    sc.w $a5, $a0, 0
; LD-SEQ-SA-NEXT:    beq $a5, $zero, .LBB16_1
; LD-SEQ-SA-NEXT:    b .LBB16_4
; LD-SEQ-SA-NEXT:  .LBB16_3:
; LD-SEQ-SA-NEXT:  .LBB16_4:
; LD-SEQ-SA-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i8_monotonic_monotonic:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    amcas.b $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    ret
  %res = cmpxchg ptr %ptr, i8 %cmp, i8 %val monotonic monotonic
  ret void
}

define void @cmpxchg_i16_monotonic_monotonic(ptr %ptr, i16 %cmp, i16 %val) nounwind {
; NO-LD-SEQ-SA-LABEL: cmpxchg_i16_monotonic_monotonic:
; NO-LD-SEQ-SA:       # %bb.0:
; NO-LD-SEQ-SA-NEXT:    slli.d $a3, $a0, 3
; NO-LD-SEQ-SA-NEXT:    bstrins.d $a0, $zero, 1, 0
; NO-LD-SEQ-SA-NEXT:    lu12i.w $a4, 15
; NO-LD-SEQ-SA-NEXT:    ori $a4, $a4, 4095
; NO-LD-SEQ-SA-NEXT:    sll.w $a4, $a4, $a3
; NO-LD-SEQ-SA-NEXT:    bstrpick.d $a1, $a1, 15, 0
; NO-LD-SEQ-SA-NEXT:    sll.w $a1, $a1, $a3
; NO-LD-SEQ-SA-NEXT:    bstrpick.d $a2, $a2, 15, 0
; NO-LD-SEQ-SA-NEXT:    sll.w $a2, $a2, $a3
; NO-LD-SEQ-SA-NEXT:  .LBB17_1: # =>This Inner Loop Header: Depth=1
; NO-LD-SEQ-SA-NEXT:    ll.w $a3, $a0, 0
; NO-LD-SEQ-SA-NEXT:    and $a5, $a3, $a4
; NO-LD-SEQ-SA-NEXT:    bne $a5, $a1, .LBB17_3
; NO-LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB17_1 Depth=1
; NO-LD-SEQ-SA-NEXT:    andn $a5, $a3, $a4
; NO-LD-SEQ-SA-NEXT:    or $a5, $a5, $a2
; NO-LD-SEQ-SA-NEXT:    sc.w $a5, $a0, 0
; NO-LD-SEQ-SA-NEXT:    beq $a5, $zero, .LBB17_1
; NO-LD-SEQ-SA-NEXT:    b .LBB17_4
; NO-LD-SEQ-SA-NEXT:  .LBB17_3:
; NO-LD-SEQ-SA-NEXT:    dbar 1792
; NO-LD-SEQ-SA-NEXT:  .LBB17_4:
; NO-LD-SEQ-SA-NEXT:    ret
;
; LD-SEQ-SA-LABEL: cmpxchg_i16_monotonic_monotonic:
; LD-SEQ-SA:       # %bb.0:
; LD-SEQ-SA-NEXT:    slli.d $a3, $a0, 3
; LD-SEQ-SA-NEXT:    bstrins.d $a0, $zero, 1, 0
; LD-SEQ-SA-NEXT:    lu12i.w $a4, 15
; LD-SEQ-SA-NEXT:    ori $a4, $a4, 4095
; LD-SEQ-SA-NEXT:    sll.w $a4, $a4, $a3
; LD-SEQ-SA-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LD-SEQ-SA-NEXT:    sll.w $a1, $a1, $a3
; LD-SEQ-SA-NEXT:    bstrpick.d $a2, $a2, 15, 0
; LD-SEQ-SA-NEXT:    sll.w $a2, $a2, $a3
; LD-SEQ-SA-NEXT:  .LBB17_1: # =>This Inner Loop Header: Depth=1
; LD-SEQ-SA-NEXT:    ll.w $a3, $a0, 0
; LD-SEQ-SA-NEXT:    and $a5, $a3, $a4
; LD-SEQ-SA-NEXT:    bne $a5, $a1, .LBB17_3
; LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB17_1 Depth=1
; LD-SEQ-SA-NEXT:    andn $a5, $a3, $a4
; LD-SEQ-SA-NEXT:    or $a5, $a5, $a2
; LD-SEQ-SA-NEXT:    sc.w $a5, $a0, 0
; LD-SEQ-SA-NEXT:    beq $a5, $zero, .LBB17_1
; LD-SEQ-SA-NEXT:    b .LBB17_4
; LD-SEQ-SA-NEXT:  .LBB17_3:
; LD-SEQ-SA-NEXT:  .LBB17_4:
; LD-SEQ-SA-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i16_monotonic_monotonic:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    amcas.h $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    ret
  %res = cmpxchg ptr %ptr, i16 %cmp, i16 %val monotonic monotonic
  ret void
}

define void @cmpxchg_i32_monotonic_monotonic(ptr %ptr, i32 %cmp, i32 %val) nounwind {
; NO-LD-SEQ-SA-LABEL: cmpxchg_i32_monotonic_monotonic:
; NO-LD-SEQ-SA:       # %bb.0:
; NO-LD-SEQ-SA-NEXT:    addi.w $a1, $a1, 0
; NO-LD-SEQ-SA-NEXT:  .LBB18_1: # =>This Inner Loop Header: Depth=1
; NO-LD-SEQ-SA-NEXT:    ll.w $a3, $a0, 0
; NO-LD-SEQ-SA-NEXT:    bne $a3, $a1, .LBB18_3
; NO-LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB18_1 Depth=1
; NO-LD-SEQ-SA-NEXT:    move $a4, $a2
; NO-LD-SEQ-SA-NEXT:    sc.w $a4, $a0, 0
; NO-LD-SEQ-SA-NEXT:    beq $a4, $zero, .LBB18_1
; NO-LD-SEQ-SA-NEXT:    b .LBB18_4
; NO-LD-SEQ-SA-NEXT:  .LBB18_3:
; NO-LD-SEQ-SA-NEXT:    dbar 1792
; NO-LD-SEQ-SA-NEXT:  .LBB18_4:
; NO-LD-SEQ-SA-NEXT:    ret
;
; LD-SEQ-SA-LABEL: cmpxchg_i32_monotonic_monotonic:
; LD-SEQ-SA:       # %bb.0:
; LD-SEQ-SA-NEXT:    addi.w $a1, $a1, 0
; LD-SEQ-SA-NEXT:  .LBB18_1: # =>This Inner Loop Header: Depth=1
; LD-SEQ-SA-NEXT:    ll.w $a3, $a0, 0
; LD-SEQ-SA-NEXT:    bne $a3, $a1, .LBB18_3
; LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB18_1 Depth=1
; LD-SEQ-SA-NEXT:    move $a4, $a2
; LD-SEQ-SA-NEXT:    sc.w $a4, $a0, 0
; LD-SEQ-SA-NEXT:    beq $a4, $zero, .LBB18_1
; LD-SEQ-SA-NEXT:    b .LBB18_4
; LD-SEQ-SA-NEXT:  .LBB18_3:
; LD-SEQ-SA-NEXT:  .LBB18_4:
; LD-SEQ-SA-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i32_monotonic_monotonic:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    amcas.w $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    ret
  %res = cmpxchg ptr %ptr, i32 %cmp, i32 %val monotonic monotonic
  ret void
}

define void @cmpxchg_i64_monotonic_monotonic(ptr %ptr, i64 %cmp, i64 %val) nounwind {
; NO-LD-SEQ-SA-LABEL: cmpxchg_i64_monotonic_monotonic:
; NO-LD-SEQ-SA:       # %bb.0:
; NO-LD-SEQ-SA-NEXT:  .LBB19_1: # =>This Inner Loop Header: Depth=1
; NO-LD-SEQ-SA-NEXT:    ll.d $a3, $a0, 0
; NO-LD-SEQ-SA-NEXT:    bne $a3, $a1, .LBB19_3
; NO-LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB19_1 Depth=1
; NO-LD-SEQ-SA-NEXT:    move $a4, $a2
; NO-LD-SEQ-SA-NEXT:    sc.d $a4, $a0, 0
; NO-LD-SEQ-SA-NEXT:    beq $a4, $zero, .LBB19_1
; NO-LD-SEQ-SA-NEXT:    b .LBB19_4
; NO-LD-SEQ-SA-NEXT:  .LBB19_3:
; NO-LD-SEQ-SA-NEXT:    dbar 1792
; NO-LD-SEQ-SA-NEXT:  .LBB19_4:
; NO-LD-SEQ-SA-NEXT:    ret
;
; LD-SEQ-SA-LABEL: cmpxchg_i64_monotonic_monotonic:
; LD-SEQ-SA:       # %bb.0:
; LD-SEQ-SA-NEXT:  .LBB19_1: # =>This Inner Loop Header: Depth=1
; LD-SEQ-SA-NEXT:    ll.d $a3, $a0, 0
; LD-SEQ-SA-NEXT:    bne $a3, $a1, .LBB19_3
; LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB19_1 Depth=1
; LD-SEQ-SA-NEXT:    move $a4, $a2
; LD-SEQ-SA-NEXT:    sc.d $a4, $a0, 0
; LD-SEQ-SA-NEXT:    beq $a4, $zero, .LBB19_1
; LD-SEQ-SA-NEXT:    b .LBB19_4
; LD-SEQ-SA-NEXT:  .LBB19_3:
; LD-SEQ-SA-NEXT:  .LBB19_4:
; LD-SEQ-SA-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i64_monotonic_monotonic:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    amcas.d $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    ret
  %res = cmpxchg ptr %ptr, i64 %cmp, i64 %val monotonic monotonic
  ret void
}

define i8 @cmpxchg_i8_monotonic_monotonic_reti8(ptr %ptr, i8 %cmp, i8 %val) nounwind {
; NO-LD-SEQ-SA-LABEL: cmpxchg_i8_monotonic_monotonic_reti8:
; NO-LD-SEQ-SA:       # %bb.0:
; NO-LD-SEQ-SA-NEXT:    slli.d $a3, $a0, 3
; NO-LD-SEQ-SA-NEXT:    bstrins.d $a0, $zero, 1, 0
; NO-LD-SEQ-SA-NEXT:    ori $a4, $zero, 255
; NO-LD-SEQ-SA-NEXT:    sll.w $a4, $a4, $a3
; NO-LD-SEQ-SA-NEXT:    andi $a1, $a1, 255
; NO-LD-SEQ-SA-NEXT:    sll.w $a1, $a1, $a3
; NO-LD-SEQ-SA-NEXT:    andi $a2, $a2, 255
; NO-LD-SEQ-SA-NEXT:    sll.w $a2, $a2, $a3
; NO-LD-SEQ-SA-NEXT:  .LBB20_1: # =>This Inner Loop Header: Depth=1
; NO-LD-SEQ-SA-NEXT:    ll.w $a5, $a0, 0
; NO-LD-SEQ-SA-NEXT:    and $a6, $a5, $a4
; NO-LD-SEQ-SA-NEXT:    bne $a6, $a1, .LBB20_3
; NO-LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB20_1 Depth=1
; NO-LD-SEQ-SA-NEXT:    andn $a6, $a5, $a4
; NO-LD-SEQ-SA-NEXT:    or $a6, $a6, $a2
; NO-LD-SEQ-SA-NEXT:    sc.w $a6, $a0, 0
; NO-LD-SEQ-SA-NEXT:    beq $a6, $zero, .LBB20_1
; NO-LD-SEQ-SA-NEXT:    b .LBB20_4
; NO-LD-SEQ-SA-NEXT:  .LBB20_3:
; NO-LD-SEQ-SA-NEXT:    dbar 1792
; NO-LD-SEQ-SA-NEXT:  .LBB20_4:
; NO-LD-SEQ-SA-NEXT:    srl.w $a0, $a5, $a3
; NO-LD-SEQ-SA-NEXT:    ret
;
; LD-SEQ-SA-LABEL: cmpxchg_i8_monotonic_monotonic_reti8:
; LD-SEQ-SA:       # %bb.0:
; LD-SEQ-SA-NEXT:    slli.d $a3, $a0, 3
; LD-SEQ-SA-NEXT:    bstrins.d $a0, $zero, 1, 0
; LD-SEQ-SA-NEXT:    ori $a4, $zero, 255
; LD-SEQ-SA-NEXT:    sll.w $a4, $a4, $a3
; LD-SEQ-SA-NEXT:    andi $a1, $a1, 255
; LD-SEQ-SA-NEXT:    sll.w $a1, $a1, $a3
; LD-SEQ-SA-NEXT:    andi $a2, $a2, 255
; LD-SEQ-SA-NEXT:    sll.w $a2, $a2, $a3
; LD-SEQ-SA-NEXT:  .LBB20_1: # =>This Inner Loop Header: Depth=1
; LD-SEQ-SA-NEXT:    ll.w $a5, $a0, 0
; LD-SEQ-SA-NEXT:    and $a6, $a5, $a4
; LD-SEQ-SA-NEXT:    bne $a6, $a1, .LBB20_3
; LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB20_1 Depth=1
; LD-SEQ-SA-NEXT:    andn $a6, $a5, $a4
; LD-SEQ-SA-NEXT:    or $a6, $a6, $a2
; LD-SEQ-SA-NEXT:    sc.w $a6, $a0, 0
; LD-SEQ-SA-NEXT:    beq $a6, $zero, .LBB20_1
; LD-SEQ-SA-NEXT:    b .LBB20_4
; LD-SEQ-SA-NEXT:  .LBB20_3:
; LD-SEQ-SA-NEXT:  .LBB20_4:
; LD-SEQ-SA-NEXT:    srl.w $a0, $a5, $a3
; LD-SEQ-SA-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i8_monotonic_monotonic_reti8:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    amcas.b $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    move $a0, $a1
; LA64-LAMCAS-NEXT:    ret
  %tmp = cmpxchg ptr %ptr, i8 %cmp, i8 %val monotonic monotonic
  %res = extractvalue { i8, i1 } %tmp, 0
  ret i8 %res
}

define i16 @cmpxchg_i16_monotonic_monotonic_reti16(ptr %ptr, i16 %cmp, i16 %val) nounwind {
; NO-LD-SEQ-SA-LABEL: cmpxchg_i16_monotonic_monotonic_reti16:
; NO-LD-SEQ-SA:       # %bb.0:
; NO-LD-SEQ-SA-NEXT:    slli.d $a3, $a0, 3
; NO-LD-SEQ-SA-NEXT:    bstrins.d $a0, $zero, 1, 0
; NO-LD-SEQ-SA-NEXT:    lu12i.w $a4, 15
; NO-LD-SEQ-SA-NEXT:    ori $a4, $a4, 4095
; NO-LD-SEQ-SA-NEXT:    sll.w $a4, $a4, $a3
; NO-LD-SEQ-SA-NEXT:    bstrpick.d $a1, $a1, 15, 0
; NO-LD-SEQ-SA-NEXT:    sll.w $a1, $a1, $a3
; NO-LD-SEQ-SA-NEXT:    bstrpick.d $a2, $a2, 15, 0
; NO-LD-SEQ-SA-NEXT:    sll.w $a2, $a2, $a3
; NO-LD-SEQ-SA-NEXT:  .LBB21_1: # =>This Inner Loop Header: Depth=1
; NO-LD-SEQ-SA-NEXT:    ll.w $a5, $a0, 0
; NO-LD-SEQ-SA-NEXT:    and $a6, $a5, $a4
; NO-LD-SEQ-SA-NEXT:    bne $a6, $a1, .LBB21_3
; NO-LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB21_1 Depth=1
; NO-LD-SEQ-SA-NEXT:    andn $a6, $a5, $a4
; NO-LD-SEQ-SA-NEXT:    or $a6, $a6, $a2
; NO-LD-SEQ-SA-NEXT:    sc.w $a6, $a0, 0
; NO-LD-SEQ-SA-NEXT:    beq $a6, $zero, .LBB21_1
; NO-LD-SEQ-SA-NEXT:    b .LBB21_4
; NO-LD-SEQ-SA-NEXT:  .LBB21_3:
; NO-LD-SEQ-SA-NEXT:    dbar 1792
; NO-LD-SEQ-SA-NEXT:  .LBB21_4:
; NO-LD-SEQ-SA-NEXT:    srl.w $a0, $a5, $a3
; NO-LD-SEQ-SA-NEXT:    ret
;
; LD-SEQ-SA-LABEL: cmpxchg_i16_monotonic_monotonic_reti16:
; LD-SEQ-SA:       # %bb.0:
; LD-SEQ-SA-NEXT:    slli.d $a3, $a0, 3
; LD-SEQ-SA-NEXT:    bstrins.d $a0, $zero, 1, 0
; LD-SEQ-SA-NEXT:    lu12i.w $a4, 15
; LD-SEQ-SA-NEXT:    ori $a4, $a4, 4095
; LD-SEQ-SA-NEXT:    sll.w $a4, $a4, $a3
; LD-SEQ-SA-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LD-SEQ-SA-NEXT:    sll.w $a1, $a1, $a3
; LD-SEQ-SA-NEXT:    bstrpick.d $a2, $a2, 15, 0
; LD-SEQ-SA-NEXT:    sll.w $a2, $a2, $a3
; LD-SEQ-SA-NEXT:  .LBB21_1: # =>This Inner Loop Header: Depth=1
; LD-SEQ-SA-NEXT:    ll.w $a5, $a0, 0
; LD-SEQ-SA-NEXT:    and $a6, $a5, $a4
; LD-SEQ-SA-NEXT:    bne $a6, $a1, .LBB21_3
; LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB21_1 Depth=1
; LD-SEQ-SA-NEXT:    andn $a6, $a5, $a4
; LD-SEQ-SA-NEXT:    or $a6, $a6, $a2
; LD-SEQ-SA-NEXT:    sc.w $a6, $a0, 0
; LD-SEQ-SA-NEXT:    beq $a6, $zero, .LBB21_1
; LD-SEQ-SA-NEXT:    b .LBB21_4
; LD-SEQ-SA-NEXT:  .LBB21_3:
; LD-SEQ-SA-NEXT:  .LBB21_4:
; LD-SEQ-SA-NEXT:    srl.w $a0, $a5, $a3
; LD-SEQ-SA-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i16_monotonic_monotonic_reti16:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    amcas.h $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    move $a0, $a1
; LA64-LAMCAS-NEXT:    ret
  %tmp = cmpxchg ptr %ptr, i16 %cmp, i16 %val monotonic monotonic
  %res = extractvalue { i16, i1 } %tmp, 0
  ret i16 %res
}

define i32 @cmpxchg_i32_monotonic_monotonic_reti32(ptr %ptr, i32 %cmp, i32 %val) nounwind {
; NO-LD-SEQ-SA-LABEL: cmpxchg_i32_monotonic_monotonic_reti32:
; NO-LD-SEQ-SA:       # %bb.0:
; NO-LD-SEQ-SA-NEXT:    addi.w $a3, $a1, 0
; NO-LD-SEQ-SA-NEXT:  .LBB22_1: # =>This Inner Loop Header: Depth=1
; NO-LD-SEQ-SA-NEXT:    ll.w $a1, $a0, 0
; NO-LD-SEQ-SA-NEXT:    bne $a1, $a3, .LBB22_3
; NO-LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB22_1 Depth=1
; NO-LD-SEQ-SA-NEXT:    move $a4, $a2
; NO-LD-SEQ-SA-NEXT:    sc.w $a4, $a0, 0
; NO-LD-SEQ-SA-NEXT:    beq $a4, $zero, .LBB22_1
; NO-LD-SEQ-SA-NEXT:    b .LBB22_4
; NO-LD-SEQ-SA-NEXT:  .LBB22_3:
; NO-LD-SEQ-SA-NEXT:    dbar 1792
; NO-LD-SEQ-SA-NEXT:  .LBB22_4:
; NO-LD-SEQ-SA-NEXT:    move $a0, $a1
; NO-LD-SEQ-SA-NEXT:    ret
;
; LD-SEQ-SA-LABEL: cmpxchg_i32_monotonic_monotonic_reti32:
; LD-SEQ-SA:       # %bb.0:
; LD-SEQ-SA-NEXT:    addi.w $a3, $a1, 0
; LD-SEQ-SA-NEXT:  .LBB22_1: # =>This Inner Loop Header: Depth=1
; LD-SEQ-SA-NEXT:    ll.w $a1, $a0, 0
; LD-SEQ-SA-NEXT:    bne $a1, $a3, .LBB22_3
; LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB22_1 Depth=1
; LD-SEQ-SA-NEXT:    move $a4, $a2
; LD-SEQ-SA-NEXT:    sc.w $a4, $a0, 0
; LD-SEQ-SA-NEXT:    beq $a4, $zero, .LBB22_1
; LD-SEQ-SA-NEXT:    b .LBB22_4
; LD-SEQ-SA-NEXT:  .LBB22_3:
; LD-SEQ-SA-NEXT:  .LBB22_4:
; LD-SEQ-SA-NEXT:    move $a0, $a1
; LD-SEQ-SA-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i32_monotonic_monotonic_reti32:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    amcas.w $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    move $a0, $a1
; LA64-LAMCAS-NEXT:    ret
  %tmp = cmpxchg ptr %ptr, i32 %cmp, i32 %val monotonic monotonic
  %res = extractvalue { i32, i1 } %tmp, 0
  ret i32 %res
}

define i64 @cmpxchg_i64_monotonic_monotonic_reti64(ptr %ptr, i64 %cmp, i64 %val) nounwind {
; NO-LD-SEQ-SA-LABEL: cmpxchg_i64_monotonic_monotonic_reti64:
; NO-LD-SEQ-SA:       # %bb.0:
; NO-LD-SEQ-SA-NEXT:  .LBB23_1: # =>This Inner Loop Header: Depth=1
; NO-LD-SEQ-SA-NEXT:    ll.d $a3, $a0, 0
; NO-LD-SEQ-SA-NEXT:    bne $a3, $a1, .LBB23_3
; NO-LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB23_1 Depth=1
; NO-LD-SEQ-SA-NEXT:    move $a4, $a2
; NO-LD-SEQ-SA-NEXT:    sc.d $a4, $a0, 0
; NO-LD-SEQ-SA-NEXT:    beq $a4, $zero, .LBB23_1
; NO-LD-SEQ-SA-NEXT:    b .LBB23_4
; NO-LD-SEQ-SA-NEXT:  .LBB23_3:
; NO-LD-SEQ-SA-NEXT:    dbar 1792
; NO-LD-SEQ-SA-NEXT:  .LBB23_4:
; NO-LD-SEQ-SA-NEXT:    move $a0, $a3
; NO-LD-SEQ-SA-NEXT:    ret
;
; LD-SEQ-SA-LABEL: cmpxchg_i64_monotonic_monotonic_reti64:
; LD-SEQ-SA:       # %bb.0:
; LD-SEQ-SA-NEXT:  .LBB23_1: # =>This Inner Loop Header: Depth=1
; LD-SEQ-SA-NEXT:    ll.d $a3, $a0, 0
; LD-SEQ-SA-NEXT:    bne $a3, $a1, .LBB23_3
; LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB23_1 Depth=1
; LD-SEQ-SA-NEXT:    move $a4, $a2
; LD-SEQ-SA-NEXT:    sc.d $a4, $a0, 0
; LD-SEQ-SA-NEXT:    beq $a4, $zero, .LBB23_1
; LD-SEQ-SA-NEXT:    b .LBB23_4
; LD-SEQ-SA-NEXT:  .LBB23_3:
; LD-SEQ-SA-NEXT:  .LBB23_4:
; LD-SEQ-SA-NEXT:    move $a0, $a3
; LD-SEQ-SA-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i64_monotonic_monotonic_reti64:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    amcas.d $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    move $a0, $a1
; LA64-LAMCAS-NEXT:    ret
  %tmp = cmpxchg ptr %ptr, i64 %cmp, i64 %val monotonic monotonic
  %res = extractvalue { i64, i1 } %tmp, 0
  ret i64 %res
}

define i1 @cmpxchg_i8_monotonic_monotonic_reti1(ptr %ptr, i8 %cmp, i8 %val) nounwind {
; NO-LD-SEQ-SA-LABEL: cmpxchg_i8_monotonic_monotonic_reti1:
; NO-LD-SEQ-SA:       # %bb.0:
; NO-LD-SEQ-SA-NEXT:    slli.d $a3, $a0, 3
; NO-LD-SEQ-SA-NEXT:    bstrins.d $a0, $zero, 1, 0
; NO-LD-SEQ-SA-NEXT:    ori $a4, $zero, 255
; NO-LD-SEQ-SA-NEXT:    sll.w $a4, $a4, $a3
; NO-LD-SEQ-SA-NEXT:    andi $a1, $a1, 255
; NO-LD-SEQ-SA-NEXT:    sll.w $a1, $a1, $a3
; NO-LD-SEQ-SA-NEXT:    andi $a2, $a2, 255
; NO-LD-SEQ-SA-NEXT:    sll.w $a2, $a2, $a3
; NO-LD-SEQ-SA-NEXT:  .LBB24_1: # =>This Inner Loop Header: Depth=1
; NO-LD-SEQ-SA-NEXT:    ll.w $a3, $a0, 0
; NO-LD-SEQ-SA-NEXT:    and $a5, $a3, $a4
; NO-LD-SEQ-SA-NEXT:    bne $a5, $a1, .LBB24_3
; NO-LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB24_1 Depth=1
; NO-LD-SEQ-SA-NEXT:    andn $a5, $a3, $a4
; NO-LD-SEQ-SA-NEXT:    or $a5, $a5, $a2
; NO-LD-SEQ-SA-NEXT:    sc.w $a5, $a0, 0
; NO-LD-SEQ-SA-NEXT:    beq $a5, $zero, .LBB24_1
; NO-LD-SEQ-SA-NEXT:    b .LBB24_4
; NO-LD-SEQ-SA-NEXT:  .LBB24_3:
; NO-LD-SEQ-SA-NEXT:    dbar 1792
; NO-LD-SEQ-SA-NEXT:  .LBB24_4:
; NO-LD-SEQ-SA-NEXT:    and $a0, $a3, $a4
; NO-LD-SEQ-SA-NEXT:    xor $a0, $a1, $a0
; NO-LD-SEQ-SA-NEXT:    sltui $a0, $a0, 1
; NO-LD-SEQ-SA-NEXT:    ret
;
; LD-SEQ-SA-LABEL: cmpxchg_i8_monotonic_monotonic_reti1:
; LD-SEQ-SA:       # %bb.0:
; LD-SEQ-SA-NEXT:    slli.d $a3, $a0, 3
; LD-SEQ-SA-NEXT:    bstrins.d $a0, $zero, 1, 0
; LD-SEQ-SA-NEXT:    ori $a4, $zero, 255
; LD-SEQ-SA-NEXT:    sll.w $a4, $a4, $a3
; LD-SEQ-SA-NEXT:    andi $a1, $a1, 255
; LD-SEQ-SA-NEXT:    sll.w $a1, $a1, $a3
; LD-SEQ-SA-NEXT:    andi $a2, $a2, 255
; LD-SEQ-SA-NEXT:    sll.w $a2, $a2, $a3
; LD-SEQ-SA-NEXT:  .LBB24_1: # =>This Inner Loop Header: Depth=1
; LD-SEQ-SA-NEXT:    ll.w $a3, $a0, 0
; LD-SEQ-SA-NEXT:    and $a5, $a3, $a4
; LD-SEQ-SA-NEXT:    bne $a5, $a1, .LBB24_3
; LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB24_1 Depth=1
; LD-SEQ-SA-NEXT:    andn $a5, $a3, $a4
; LD-SEQ-SA-NEXT:    or $a5, $a5, $a2
; LD-SEQ-SA-NEXT:    sc.w $a5, $a0, 0
; LD-SEQ-SA-NEXT:    beq $a5, $zero, .LBB24_1
; LD-SEQ-SA-NEXT:    b .LBB24_4
; LD-SEQ-SA-NEXT:  .LBB24_3:
; LD-SEQ-SA-NEXT:  .LBB24_4:
; LD-SEQ-SA-NEXT:    and $a0, $a3, $a4
; LD-SEQ-SA-NEXT:    xor $a0, $a1, $a0
; LD-SEQ-SA-NEXT:    sltui $a0, $a0, 1
; LD-SEQ-SA-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i8_monotonic_monotonic_reti1:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    ext.w.b $a3, $a1
; LA64-LAMCAS-NEXT:    amcas.b $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    xor $a0, $a1, $a3
; LA64-LAMCAS-NEXT:    sltui $a0, $a0, 1
; LA64-LAMCAS-NEXT:    ret
  %tmp = cmpxchg ptr %ptr, i8 %cmp, i8 %val monotonic monotonic
  %res = extractvalue { i8, i1 } %tmp, 1
  ret i1 %res
}

define i1 @cmpxchg_i16_monotonic_monotonic_reti1(ptr %ptr, i16 %cmp, i16 %val) nounwind {
; NO-LD-SEQ-SA-LABEL: cmpxchg_i16_monotonic_monotonic_reti1:
; NO-LD-SEQ-SA:       # %bb.0:
; NO-LD-SEQ-SA-NEXT:    slli.d $a3, $a0, 3
; NO-LD-SEQ-SA-NEXT:    bstrins.d $a0, $zero, 1, 0
; NO-LD-SEQ-SA-NEXT:    lu12i.w $a4, 15
; NO-LD-SEQ-SA-NEXT:    ori $a4, $a4, 4095
; NO-LD-SEQ-SA-NEXT:    sll.w $a4, $a4, $a3
; NO-LD-SEQ-SA-NEXT:    bstrpick.d $a1, $a1, 15, 0
; NO-LD-SEQ-SA-NEXT:    sll.w $a1, $a1, $a3
; NO-LD-SEQ-SA-NEXT:    bstrpick.d $a2, $a2, 15, 0
; NO-LD-SEQ-SA-NEXT:    sll.w $a2, $a2, $a3
; NO-LD-SEQ-SA-NEXT:  .LBB25_1: # =>This Inner Loop Header: Depth=1
; NO-LD-SEQ-SA-NEXT:    ll.w $a3, $a0, 0
; NO-LD-SEQ-SA-NEXT:    and $a5, $a3, $a4
; NO-LD-SEQ-SA-NEXT:    bne $a5, $a1, .LBB25_3
; NO-LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB25_1 Depth=1
; NO-LD-SEQ-SA-NEXT:    andn $a5, $a3, $a4
; NO-LD-SEQ-SA-NEXT:    or $a5, $a5, $a2
; NO-LD-SEQ-SA-NEXT:    sc.w $a5, $a0, 0
; NO-LD-SEQ-SA-NEXT:    beq $a5, $zero, .LBB25_1
; NO-LD-SEQ-SA-NEXT:    b .LBB25_4
; NO-LD-SEQ-SA-NEXT:  .LBB25_3:
; NO-LD-SEQ-SA-NEXT:    dbar 1792
; NO-LD-SEQ-SA-NEXT:  .LBB25_4:
; NO-LD-SEQ-SA-NEXT:    and $a0, $a3, $a4
; NO-LD-SEQ-SA-NEXT:    xor $a0, $a1, $a0
; NO-LD-SEQ-SA-NEXT:    sltui $a0, $a0, 1
; NO-LD-SEQ-SA-NEXT:    ret
;
; LD-SEQ-SA-LABEL: cmpxchg_i16_monotonic_monotonic_reti1:
; LD-SEQ-SA:       # %bb.0:
; LD-SEQ-SA-NEXT:    slli.d $a3, $a0, 3
; LD-SEQ-SA-NEXT:    bstrins.d $a0, $zero, 1, 0
; LD-SEQ-SA-NEXT:    lu12i.w $a4, 15
; LD-SEQ-SA-NEXT:    ori $a4, $a4, 4095
; LD-SEQ-SA-NEXT:    sll.w $a4, $a4, $a3
; LD-SEQ-SA-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LD-SEQ-SA-NEXT:    sll.w $a1, $a1, $a3
; LD-SEQ-SA-NEXT:    bstrpick.d $a2, $a2, 15, 0
; LD-SEQ-SA-NEXT:    sll.w $a2, $a2, $a3
; LD-SEQ-SA-NEXT:  .LBB25_1: # =>This Inner Loop Header: Depth=1
; LD-SEQ-SA-NEXT:    ll.w $a3, $a0, 0
; LD-SEQ-SA-NEXT:    and $a5, $a3, $a4
; LD-SEQ-SA-NEXT:    bne $a5, $a1, .LBB25_3
; LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB25_1 Depth=1
; LD-SEQ-SA-NEXT:    andn $a5, $a3, $a4
; LD-SEQ-SA-NEXT:    or $a5, $a5, $a2
; LD-SEQ-SA-NEXT:    sc.w $a5, $a0, 0
; LD-SEQ-SA-NEXT:    beq $a5, $zero, .LBB25_1
; LD-SEQ-SA-NEXT:    b .LBB25_4
; LD-SEQ-SA-NEXT:  .LBB25_3:
; LD-SEQ-SA-NEXT:  .LBB25_4:
; LD-SEQ-SA-NEXT:    and $a0, $a3, $a4
; LD-SEQ-SA-NEXT:    xor $a0, $a1, $a0
; LD-SEQ-SA-NEXT:    sltui $a0, $a0, 1
; LD-SEQ-SA-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i16_monotonic_monotonic_reti1:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    ext.w.h $a3, $a1
; LA64-LAMCAS-NEXT:    amcas.h $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    xor $a0, $a1, $a3
; LA64-LAMCAS-NEXT:    sltui $a0, $a0, 1
; LA64-LAMCAS-NEXT:    ret
  %tmp = cmpxchg ptr %ptr, i16 %cmp, i16 %val monotonic monotonic
  %res = extractvalue { i16, i1 } %tmp, 1
  ret i1 %res
}

define i1 @cmpxchg_i32_monotonic_monotonic_reti1(ptr %ptr, i32 %cmp, i32 %val) nounwind {
; NO-LD-SEQ-SA-LABEL: cmpxchg_i32_monotonic_monotonic_reti1:
; NO-LD-SEQ-SA:       # %bb.0:
; NO-LD-SEQ-SA-NEXT:    addi.w $a1, $a1, 0
; NO-LD-SEQ-SA-NEXT:  .LBB26_1: # =>This Inner Loop Header: Depth=1
; NO-LD-SEQ-SA-NEXT:    ll.w $a3, $a0, 0
; NO-LD-SEQ-SA-NEXT:    bne $a3, $a1, .LBB26_3
; NO-LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB26_1 Depth=1
; NO-LD-SEQ-SA-NEXT:    move $a4, $a2
; NO-LD-SEQ-SA-NEXT:    sc.w $a4, $a0, 0
; NO-LD-SEQ-SA-NEXT:    beq $a4, $zero, .LBB26_1
; NO-LD-SEQ-SA-NEXT:    b .LBB26_4
; NO-LD-SEQ-SA-NEXT:  .LBB26_3:
; NO-LD-SEQ-SA-NEXT:    dbar 1792
; NO-LD-SEQ-SA-NEXT:  .LBB26_4:
; NO-LD-SEQ-SA-NEXT:    xor $a0, $a3, $a1
; NO-LD-SEQ-SA-NEXT:    sltui $a0, $a0, 1
; NO-LD-SEQ-SA-NEXT:    ret
;
; LD-SEQ-SA-LABEL: cmpxchg_i32_monotonic_monotonic_reti1:
; LD-SEQ-SA:       # %bb.0:
; LD-SEQ-SA-NEXT:    addi.w $a1, $a1, 0
; LD-SEQ-SA-NEXT:  .LBB26_1: # =>This Inner Loop Header: Depth=1
; LD-SEQ-SA-NEXT:    ll.w $a3, $a0, 0
; LD-SEQ-SA-NEXT:    bne $a3, $a1, .LBB26_3
; LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB26_1 Depth=1
; LD-SEQ-SA-NEXT:    move $a4, $a2
; LD-SEQ-SA-NEXT:    sc.w $a4, $a0, 0
; LD-SEQ-SA-NEXT:    beq $a4, $zero, .LBB26_1
; LD-SEQ-SA-NEXT:    b .LBB26_4
; LD-SEQ-SA-NEXT:  .LBB26_3:
; LD-SEQ-SA-NEXT:  .LBB26_4:
; LD-SEQ-SA-NEXT:    xor $a0, $a3, $a1
; LD-SEQ-SA-NEXT:    sltui $a0, $a0, 1
; LD-SEQ-SA-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i32_monotonic_monotonic_reti1:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    addi.w $a3, $a1, 0
; LA64-LAMCAS-NEXT:    amcas.w $a1, $a2, $a0
; LA64-LAMCAS-NEXT:    xor $a0, $a1, $a3
; LA64-LAMCAS-NEXT:    sltui $a0, $a0, 1
; LA64-LAMCAS-NEXT:    ret
  %tmp = cmpxchg ptr %ptr, i32 %cmp, i32 %val monotonic monotonic
  %res = extractvalue { i32, i1 } %tmp, 1
  ret i1 %res
}

define i1 @cmpxchg_i64_monotonic_monotonic_reti1(ptr %ptr, i64 %cmp, i64 %val) nounwind {
; NO-LD-SEQ-SA-LABEL: cmpxchg_i64_monotonic_monotonic_reti1:
; NO-LD-SEQ-SA:       # %bb.0:
; NO-LD-SEQ-SA-NEXT:  .LBB27_1: # =>This Inner Loop Header: Depth=1
; NO-LD-SEQ-SA-NEXT:    ll.d $a3, $a0, 0
; NO-LD-SEQ-SA-NEXT:    bne $a3, $a1, .LBB27_3
; NO-LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB27_1 Depth=1
; NO-LD-SEQ-SA-NEXT:    move $a4, $a2
; NO-LD-SEQ-SA-NEXT:    sc.d $a4, $a0, 0
; NO-LD-SEQ-SA-NEXT:    beq $a4, $zero, .LBB27_1
; NO-LD-SEQ-SA-NEXT:    b .LBB27_4
; NO-LD-SEQ-SA-NEXT:  .LBB27_3:
; NO-LD-SEQ-SA-NEXT:    dbar 1792
; NO-LD-SEQ-SA-NEXT:  .LBB27_4:
; NO-LD-SEQ-SA-NEXT:    xor $a0, $a3, $a1
; NO-LD-SEQ-SA-NEXT:    sltui $a0, $a0, 1
; NO-LD-SEQ-SA-NEXT:    ret
;
; LD-SEQ-SA-LABEL: cmpxchg_i64_monotonic_monotonic_reti1:
; LD-SEQ-SA:       # %bb.0:
; LD-SEQ-SA-NEXT:  .LBB27_1: # =>This Inner Loop Header: Depth=1
; LD-SEQ-SA-NEXT:    ll.d $a3, $a0, 0
; LD-SEQ-SA-NEXT:    bne $a3, $a1, .LBB27_3
; LD-SEQ-SA-NEXT:  # %bb.2: # in Loop: Header=BB27_1 Depth=1
; LD-SEQ-SA-NEXT:    move $a4, $a2
; LD-SEQ-SA-NEXT:    sc.d $a4, $a0, 0
; LD-SEQ-SA-NEXT:    beq $a4, $zero, .LBB27_1
; LD-SEQ-SA-NEXT:    b .LBB27_4
; LD-SEQ-SA-NEXT:  .LBB27_3:
; LD-SEQ-SA-NEXT:  .LBB27_4:
; LD-SEQ-SA-NEXT:    xor $a0, $a3, $a1
; LD-SEQ-SA-NEXT:    sltui $a0, $a0, 1
; LD-SEQ-SA-NEXT:    ret
;
; LA64-LAMCAS-LABEL: cmpxchg_i64_monotonic_monotonic_reti1:
; LA64-LAMCAS:       # %bb.0:
; LA64-LAMCAS-NEXT:    move $a3, $a1
; LA64-LAMCAS-NEXT:    amcas.d $a3, $a2, $a0
; LA64-LAMCAS-NEXT:    xor $a0, $a3, $a1
; LA64-LAMCAS-NEXT:    sltui $a0, $a0, 1
; LA64-LAMCAS-NEXT:    ret
  %tmp = cmpxchg ptr %ptr, i64 %cmp, i64 %val monotonic monotonic
  %res = extractvalue { i64, i1 } %tmp, 1
  ret i1 %res
}
