; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc %s -o - -mtriple=armv8-none-eabi -mattr=+aes | FileCheck %s

declare <16 x i8> @llvm.arm.neon.aese(<16 x i8> %d, <16 x i8> %k)
declare <16 x i8> @llvm.arm.neon.aesd(<16 x i8> %d, <16 x i8> %k)

define arm_aapcs_vfpcc <16 x i8> @aese(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: aese:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    aese.8 q0, q1
; CHECK-NEXT:    bx lr
  %r = call <16 x i8> @llvm.arm.neon.aese(<16 x i8> %a, <16 x i8> %b)
  ret <16 x i8> %r
}

define arm_aapcs_vfpcc <16 x i8> @aese_c(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: aese_c:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    aese.8 q0, q1
; CHECK-NEXT:    bx lr
  %r = call <16 x i8> @llvm.arm.neon.aese(<16 x i8> %b, <16 x i8> %a)
  ret <16 x i8> %r
}

define arm_aapcs_vfpcc <16 x i8> @aesd(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: aesd:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    aesd.8 q0, q1
; CHECK-NEXT:    bx lr
  %r = call <16 x i8> @llvm.arm.neon.aesd(<16 x i8> %a, <16 x i8> %b)
  ret <16 x i8> %r
}

define arm_aapcs_vfpcc <16 x i8> @aesd_c(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: aesd_c:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    aesd.8 q0, q1
; CHECK-NEXT:    bx lr
  %r = call <16 x i8> @llvm.arm.neon.aesd(<16 x i8> %b, <16 x i8> %a)
  ret <16 x i8> %r
}
