; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 < %s | FileCheck -check-prefix=GFX9 %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga< %s | FileCheck -check-prefix=VI %s
; RUN: llc -mtriple=amdgcn -mcpu=bonaire < %s | FileCheck -check-prefix=CI %s


define amdgpu_kernel void @s_abs_v2i16(ptr addrspace(1) %out, <2 x i16> %val) #0 {
; GFX9-LABEL: s_abs_v2i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_pk_sub_i16 v1, 0, s2
; GFX9-NEXT:    v_pk_max_i16 v1, s2, v1
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 2 op_sel_hi:[1,0]
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: s_abs_v2i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_sub_i32 s3, 0, s2
; VI-NEXT:    s_lshr_b32 s4, s2, 16
; VI-NEXT:    s_ashr_i32 s5, s2, 16
; VI-NEXT:    s_sub_i32 s4, 0, s4
; VI-NEXT:    s_sext_i32_i16 s3, s3
; VI-NEXT:    s_sext_i32_i16 s2, s2
; VI-NEXT:    s_sext_i32_i16 s4, s4
; VI-NEXT:    s_max_i32 s2, s2, s3
; VI-NEXT:    s_max_i32 s4, s5, s4
; VI-NEXT:    s_add_i32 s2, s2, 2
; VI-NEXT:    s_lshl_b32 s3, s4, 16
; VI-NEXT:    s_and_b32 s2, s2, 0xffff
; VI-NEXT:    s_or_b32 s2, s3, s2
; VI-NEXT:    s_add_i32 s2, s2, 0x20000
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; CI-LABEL: s_abs_v2i16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dword s6, s[4:5], 0xb
; CI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshr_b32 s5, s6, 16
; CI-NEXT:    s_ashr_i32 s4, s6, 16
; CI-NEXT:    s_sext_i32_i16 s7, s6
; CI-NEXT:    s_sub_i32 s6, 0, s6
; CI-NEXT:    s_sub_i32 s5, 0, s5
; CI-NEXT:    s_sext_i32_i16 s6, s6
; CI-NEXT:    s_sext_i32_i16 s5, s5
; CI-NEXT:    s_max_i32 s4, s4, s5
; CI-NEXT:    s_max_i32 s5, s7, s6
; CI-NEXT:    s_add_i32 s5, s5, 2
; CI-NEXT:    s_lshl_b32 s4, s4, 16
; CI-NEXT:    s_and_b32 s5, s5, 0xffff
; CI-NEXT:    s_or_b32 s4, s4, s5
; CI-NEXT:    s_add_i32 s4, s4, 0x20000
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; CI-NEXT:    s_endpgm
  %neg = sub <2 x i16> zeroinitializer, %val
  %cond = icmp sgt <2 x i16> %val, %neg
  %res = select <2 x i1> %cond, <2 x i16> %val, <2 x i16> %neg
  %res2 = add <2 x i16> %res, <i16 2, i16 2>
  store <2 x i16> %res2, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v_abs_v2i16(ptr addrspace(1) %out, ptr addrspace(1) %src) #0 {
; GFX9-LABEL: v_abs_v2i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_sub_i16 v2, 0, v1
; GFX9-NEXT:    v_pk_max_i16 v1, v1, v2
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 2 op_sel_hi:[1,0]
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_abs_v2i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    v_mov_b32_e32 v4, 0
; VI-NEXT:    v_mov_b32_e32 v5, 2
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_sub_u16_e32 v2, 0, v3
; VI-NEXT:    v_sub_u16_sdwa v4, v4, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_max_i16_sdwa v4, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_max_i16_e32 v2, v3, v2
; VI-NEXT:    v_add_u16_e32 v2, 2, v2
; VI-NEXT:    v_add_u16_sdwa v3, v4, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_abs_v2i16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; CI-NEXT:    v_mov_b32_e32 v1, 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b64 s[4:5], s[2:3]
; CI-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; CI-NEXT:    s_mov_b64 s[2:3], s[6:7]
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_bfe_i32 v3, v2, 0, 16
; CI-NEXT:    v_ashrrev_i32_e32 v4, 16, v2
; CI-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; CI-NEXT:    v_sub_i32_e32 v2, vcc, 0, v2
; CI-NEXT:    v_bfe_i32 v2, v2, 0, 16
; CI-NEXT:    v_sub_i32_e32 v5, vcc, 0, v5
; CI-NEXT:    v_bfe_i32 v5, v5, 0, 16
; CI-NEXT:    v_max_i32_e32 v2, v3, v2
; CI-NEXT:    v_max_i32_e32 v3, v4, v5
; CI-NEXT:    v_add_i32_e32 v2, vcc, 2, v2
; CI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; CI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; CI-NEXT:    v_or_b32_e32 v2, v3, v2
; CI-NEXT:    v_add_i32_e32 v2, vcc, 0x20000, v2
; CI-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; CI-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.in = getelementptr inbounds <2 x i16>, ptr addrspace(1) %src, i32 %tid
  %gep.out = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i32 %tid
  %val = load <2 x i16>, ptr addrspace(1) %gep.in, align 4
  %neg = sub <2 x i16> zeroinitializer, %val
  %cond = icmp sgt <2 x i16> %val, %neg
  %res = select <2 x i1> %cond, <2 x i16> %val, <2 x i16> %neg
  %res2 = add <2 x i16> %res, <i16 2, i16 2>
  store <2 x i16> %res2, ptr addrspace(1) %gep.out, align 4
  ret void
}

define amdgpu_kernel void @s_abs_v2i16_2(ptr addrspace(1) %out, <2 x i16> %val) #0 {
; GFX9-LABEL: s_abs_v2i16_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_pk_sub_i16 v1, 0, s2
; GFX9-NEXT:    v_pk_max_i16 v1, s2, v1
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 2 op_sel_hi:[1,0]
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: s_abs_v2i16_2:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_sub_i32 s3, 0, s2
; VI-NEXT:    s_lshr_b32 s4, s2, 16
; VI-NEXT:    s_ashr_i32 s5, s2, 16
; VI-NEXT:    s_sub_i32 s4, 0, s4
; VI-NEXT:    s_sext_i32_i16 s3, s3
; VI-NEXT:    s_sext_i32_i16 s2, s2
; VI-NEXT:    s_sext_i32_i16 s4, s4
; VI-NEXT:    s_max_i32 s2, s2, s3
; VI-NEXT:    s_max_i32 s4, s5, s4
; VI-NEXT:    s_add_i32 s2, s2, 2
; VI-NEXT:    s_lshl_b32 s3, s4, 16
; VI-NEXT:    s_and_b32 s2, s2, 0xffff
; VI-NEXT:    s_or_b32 s2, s3, s2
; VI-NEXT:    s_add_i32 s2, s2, 0x20000
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; CI-LABEL: s_abs_v2i16_2:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dword s6, s[4:5], 0xb
; CI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshr_b32 s5, s6, 16
; CI-NEXT:    s_ashr_i32 s4, s6, 16
; CI-NEXT:    s_sext_i32_i16 s7, s6
; CI-NEXT:    s_sub_i32 s6, 0, s6
; CI-NEXT:    s_sub_i32 s5, 0, s5
; CI-NEXT:    s_sext_i32_i16 s6, s6
; CI-NEXT:    s_sext_i32_i16 s5, s5
; CI-NEXT:    s_max_i32 s4, s4, s5
; CI-NEXT:    s_max_i32 s5, s7, s6
; CI-NEXT:    s_add_i32 s5, s5, 2
; CI-NEXT:    s_lshl_b32 s4, s4, 16
; CI-NEXT:    s_and_b32 s5, s5, 0xffff
; CI-NEXT:    s_or_b32 s4, s4, s5
; CI-NEXT:    s_add_i32 s4, s4, 0x20000
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; CI-NEXT:    s_endpgm
  %z0 = insertelement <2 x i16> poison, i16 0, i16 0
  %z1 = insertelement <2 x i16> %z0, i16 0, i16 1
  %t0 = insertelement <2 x i16> poison, i16 2, i16 0
  %t1 = insertelement <2 x i16> %t0, i16 2, i16 1
  %neg = sub <2 x i16> %z1, %val
  %cond = icmp sgt <2 x i16> %val, %neg
  %res = select <2 x i1> %cond, <2 x i16> %val, <2 x i16> %neg
  %res2 = add <2 x i16> %res, %t1
  store <2 x i16> %res2, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v_abs_v2i16_2(ptr addrspace(1) %out, ptr addrspace(1) %src) #0 {
; GFX9-LABEL: v_abs_v2i16_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_sub_i16 v2, 0, v0
; GFX9-NEXT:    v_pk_max_i16 v0, v0, v2
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 2 op_sel_hi:[1,0]
; GFX9-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_abs_v2i16_2:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    v_mov_b32_e32 v3, 0
; VI-NEXT:    v_mov_b32_e32 v4, 2
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v2, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_sub_u16_e32 v5, 0, v2
; VI-NEXT:    v_sub_u16_sdwa v3, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_max_i16_sdwa v3, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_max_i16_e32 v2, v2, v5
; VI-NEXT:    v_add_u16_e32 v2, 2, v2
; VI-NEXT:    v_add_u16_sdwa v3, v3, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_abs_v2i16_2:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s10, 0
; CI-NEXT:    s_mov_b32 s11, s7
; CI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; CI-NEXT:    v_mov_b32_e32 v1, 0
; CI-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_mov_b32 s4, s0
; CI-NEXT:    s_mov_b32 s5, s1
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_bfe_i32 v1, v0, 0, 16
; CI-NEXT:    v_ashrrev_i32_e32 v2, 16, v0
; CI-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; CI-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; CI-NEXT:    v_bfe_i32 v0, v0, 0, 16
; CI-NEXT:    v_sub_i32_e32 v3, vcc, 0, v3
; CI-NEXT:    v_bfe_i32 v3, v3, 0, 16
; CI-NEXT:    v_max_i32_e32 v0, v1, v0
; CI-NEXT:    v_max_i32_e32 v1, v2, v3
; CI-NEXT:    v_add_i32_e32 v0, vcc, 2, v0
; CI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; CI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; CI-NEXT:    v_or_b32_e32 v0, v1, v0
; CI-NEXT:    v_add_i32_e32 v0, vcc, 0x20000, v0
; CI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; CI-NEXT:    s_endpgm
  %z0 = insertelement <2 x i16> poison, i16 0, i16 0
  %z1 = insertelement <2 x i16> %z0, i16 0, i16 1
  %t0 = insertelement <2 x i16> poison, i16 2, i16 0
  %t1 = insertelement <2 x i16> %t0, i16 2, i16 1
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.in = getelementptr inbounds <2 x i16>, ptr addrspace(1) %src, i32 %tid
  %val = load <2 x i16>, ptr addrspace(1) %gep.in, align 4
  %neg = sub <2 x i16> %z1, %val
  %cond = icmp sgt <2 x i16> %val, %neg
  %res = select <2 x i1> %cond, <2 x i16> %val, <2 x i16> %neg
  %res2 = add <2 x i16> %res, %t1
  store <2 x i16> %res2, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @s_abs_v4i16(ptr addrspace(1) %out, <4 x i16> %val) #0 {
; GFX9-LABEL: s_abs_v4i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_pk_sub_i16 v0, 0, s3
; GFX9-NEXT:    v_pk_sub_i16 v1, 0, s2
; GFX9-NEXT:    v_pk_max_i16 v3, s2, v1
; GFX9-NEXT:    v_pk_max_i16 v0, s3, v0
; GFX9-NEXT:    v_pk_add_u16 v1, v0, 2 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v3, 2 op_sel_hi:[1,0]
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: s_abs_v4i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s7, s2, 16
; VI-NEXT:    s_sub_i32 s7, 0, s7
; VI-NEXT:    s_sub_i32 s4, 0, s3
; VI-NEXT:    s_lshr_b32 s6, s3, 16
; VI-NEXT:    s_ashr_i32 s8, s2, 16
; VI-NEXT:    s_sext_i32_i16 s7, s7
; VI-NEXT:    s_sub_i32 s5, 0, s2
; VI-NEXT:    s_sub_i32 s6, 0, s6
; VI-NEXT:    s_max_i32 s7, s8, s7
; VI-NEXT:    s_ashr_i32 s8, s3, 16
; VI-NEXT:    s_sext_i32_i16 s4, s4
; VI-NEXT:    s_sext_i32_i16 s3, s3
; VI-NEXT:    s_sext_i32_i16 s6, s6
; VI-NEXT:    s_sext_i32_i16 s5, s5
; VI-NEXT:    s_sext_i32_i16 s2, s2
; VI-NEXT:    s_max_i32 s3, s3, s4
; VI-NEXT:    s_max_i32 s6, s8, s6
; VI-NEXT:    s_max_i32 s2, s2, s5
; VI-NEXT:    s_add_i32 s3, s3, 2
; VI-NEXT:    s_lshl_b32 s4, s6, 16
; VI-NEXT:    s_and_b32 s3, s3, 0xffff
; VI-NEXT:    s_add_i32 s2, s2, 2
; VI-NEXT:    s_or_b32 s3, s4, s3
; VI-NEXT:    s_lshl_b32 s4, s7, 16
; VI-NEXT:    s_and_b32 s2, s2, 0xffff
; VI-NEXT:    s_or_b32 s2, s4, s2
; VI-NEXT:    s_add_i32 s3, s3, 0x20000
; VI-NEXT:    s_add_i32 s2, s2, 0x20000
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; CI-LABEL: s_abs_v4i16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s4, s0
; CI-NEXT:    s_mov_b32 s5, s1
; CI-NEXT:    s_ashr_i32 s0, s3, 16
; CI-NEXT:    s_ashr_i32 s1, s2, 16
; CI-NEXT:    s_lshr_b32 s8, s2, 16
; CI-NEXT:    s_lshr_b32 s9, s3, 16
; CI-NEXT:    s_sext_i32_i16 s10, s3
; CI-NEXT:    s_sext_i32_i16 s11, s2
; CI-NEXT:    s_sub_i32 s3, 0, s3
; CI-NEXT:    s_sub_i32 s2, 0, s2
; CI-NEXT:    s_sext_i32_i16 s3, s3
; CI-NEXT:    s_sext_i32_i16 s2, s2
; CI-NEXT:    s_sub_i32 s9, 0, s9
; CI-NEXT:    s_sub_i32 s8, 0, s8
; CI-NEXT:    s_sext_i32_i16 s9, s9
; CI-NEXT:    s_sext_i32_i16 s8, s8
; CI-NEXT:    s_max_i32 s2, s11, s2
; CI-NEXT:    s_max_i32 s3, s10, s3
; CI-NEXT:    s_max_i32 s1, s1, s8
; CI-NEXT:    s_max_i32 s0, s0, s9
; CI-NEXT:    s_add_i32 s3, s3, 2
; CI-NEXT:    s_add_i32 s2, s2, 2
; CI-NEXT:    s_lshl_b32 s0, s0, 16
; CI-NEXT:    s_and_b32 s3, s3, 0xffff
; CI-NEXT:    s_lshl_b32 s1, s1, 16
; CI-NEXT:    s_and_b32 s2, s2, 0xffff
; CI-NEXT:    s_or_b32 s0, s0, s3
; CI-NEXT:    s_or_b32 s1, s1, s2
; CI-NEXT:    s_add_i32 s0, s0, 0x20000
; CI-NEXT:    s_add_i32 s1, s1, 0x20000
; CI-NEXT:    v_mov_b32_e32 v0, s1
; CI-NEXT:    v_mov_b32_e32 v1, s0
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; CI-NEXT:    s_endpgm
  %z0 = insertelement <4 x i16> poison, i16 0, i16 0
  %z1 = insertelement <4 x i16> %z0, i16 0, i16 1
  %z2 = insertelement <4 x i16> %z1, i16 0, i16 2
  %z3 = insertelement <4 x i16> %z2, i16 0, i16 3
  %t0 = insertelement <4 x i16> poison, i16 2, i16 0
  %t1 = insertelement <4 x i16> %t0, i16 2, i16 1
  %t2 = insertelement <4 x i16> %t1, i16 2, i16 2
  %t3 = insertelement <4 x i16> %t2, i16 2, i16 3
  %neg = sub <4 x i16> %z3, %val
  %cond = icmp sgt <4 x i16> %val, %neg
  %res = select <4 x i1> %cond, <4 x i16> %val, <4 x i16> %neg
  %res2 = add <4 x i16> %res, %t3
  store <4 x i16> %res2, ptr addrspace(1) %out, align 4
  ret void
}



define amdgpu_kernel void @v_abs_v4i16(ptr addrspace(1) %out, ptr addrspace(1) %src) #0 {
; GFX9-LABEL: v_abs_v4i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_sub_i16 v3, 0, v1
; GFX9-NEXT:    v_pk_sub_i16 v4, 0, v0
; GFX9-NEXT:    v_pk_max_i16 v0, v0, v4
; GFX9-NEXT:    v_pk_max_i16 v1, v1, v3
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 2 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 2 op_sel_hi:[1,0]
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_abs_v4i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; VI-NEXT:    v_mov_b32_e32 v4, 0
; VI-NEXT:    v_mov_b32_e32 v5, 2
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_sub_u16_e32 v6, 0, v1
; VI-NEXT:    v_sub_u16_sdwa v7, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_sub_u16_e32 v8, 0, v0
; VI-NEXT:    v_sub_u16_sdwa v4, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_max_i16_sdwa v4, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_max_i16_e32 v0, v0, v8
; VI-NEXT:    v_max_i16_sdwa v7, v1, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_max_i16_e32 v1, v1, v6
; VI-NEXT:    v_add_u16_e32 v1, 2, v1
; VI-NEXT:    v_add_u16_sdwa v6, v7, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_u16_e32 v0, 2, v0
; VI-NEXT:    v_add_u16_sdwa v4, v4, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v1, v6
; VI-NEXT:    v_or_b32_e32 v0, v0, v4
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_abs_v4i16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x9
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s10, 0
; CI-NEXT:    s_mov_b32 s11, s3
; CI-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b64 s[8:9], s[6:7]
; CI-NEXT:    v_mov_b32_e32 v1, 0
; CI-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[8:11], 0 addr64
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_mov_b32 s0, s4
; CI-NEXT:    s_mov_b32 s1, s5
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_bfe_i32 v2, v1, 0, 16
; CI-NEXT:    v_ashrrev_i32_e32 v3, 16, v1
; CI-NEXT:    v_bfe_i32 v4, v0, 0, 16
; CI-NEXT:    v_ashrrev_i32_e32 v5, 16, v0
; CI-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; CI-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; CI-NEXT:    v_sub_i32_e32 v1, vcc, 0, v1
; CI-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; CI-NEXT:    v_bfe_i32 v1, v1, 0, 16
; CI-NEXT:    v_sub_i32_e32 v7, vcc, 0, v7
; CI-NEXT:    v_bfe_i32 v0, v0, 0, 16
; CI-NEXT:    v_sub_i32_e32 v6, vcc, 0, v6
; CI-NEXT:    v_bfe_i32 v7, v7, 0, 16
; CI-NEXT:    v_bfe_i32 v6, v6, 0, 16
; CI-NEXT:    v_max_i32_e32 v0, v4, v0
; CI-NEXT:    v_max_i32_e32 v1, v2, v1
; CI-NEXT:    v_max_i32_e32 v2, v5, v6
; CI-NEXT:    v_max_i32_e32 v3, v3, v7
; CI-NEXT:    v_add_i32_e32 v1, vcc, 2, v1
; CI-NEXT:    v_add_i32_e32 v0, vcc, 2, v0
; CI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; CI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; CI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; CI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; CI-NEXT:    v_or_b32_e32 v1, v3, v1
; CI-NEXT:    v_or_b32_e32 v0, v2, v0
; CI-NEXT:    v_add_i32_e32 v1, vcc, 0x20000, v1
; CI-NEXT:    v_add_i32_e32 v0, vcc, 0x20000, v0
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
  %z0 = insertelement <4 x i16> poison, i16 0, i16 0
  %z1 = insertelement <4 x i16> %z0, i16 0, i16 1
  %z2 = insertelement <4 x i16> %z1, i16 0, i16 2
  %z3 = insertelement <4 x i16> %z2, i16 0, i16 3
  %t0 = insertelement <4 x i16> poison, i16 2, i16 0
  %t1 = insertelement <4 x i16> %t0, i16 2, i16 1
  %t2 = insertelement <4 x i16> %t1, i16 2, i16 2
  %t3 = insertelement <4 x i16> %t2, i16 2, i16 3
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.in = getelementptr inbounds <4 x i16>, ptr addrspace(1) %src, i32 %tid
  %val = load <4 x i16>, ptr addrspace(1) %gep.in, align 4
  %neg = sub <4 x i16> %z3, %val
  %cond = icmp sgt <4 x i16> %val, %neg
  %res = select <4 x i1> %cond, <4 x i16> %val, <4 x i16> %neg
  %res2 = add <4 x i16> %res, %t3
  store <4 x i16> %res2, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @s_min_max_v2i16(ptr addrspace(1) %out0, ptr addrspace(1) %out1, <2 x i16> %val0, <2 x i16> %val1) #0 {
; GFX9-LABEL: s_min_max_v2i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    v_pk_max_i16 v2, s6, v1
; GFX9-NEXT:    v_pk_min_i16 v1, s6, v1
; GFX9-NEXT:    global_store_dword v0, v2, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: s_min_max_v2i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    s_ashr_i32 s0, s5, 16
; VI-NEXT:    s_ashr_i32 s1, s4, 16
; VI-NEXT:    s_sext_i32_i16 s3, s5
; VI-NEXT:    s_sext_i32_i16 s4, s4
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    s_max_i32 s2, s1, s0
; VI-NEXT:    s_max_i32 s5, s4, s3
; VI-NEXT:    s_lshl_b32 s2, s2, 16
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_min_i32 s0, s1, s0
; VI-NEXT:    s_min_i32 s1, s4, s3
; VI-NEXT:    s_or_b32 s2, s5, s2
; VI-NEXT:    s_lshl_b32 s0, s0, 16
; VI-NEXT:    s_and_b32 s1, s1, 0xffff
; VI-NEXT:    s_or_b32 s0, s1, s0
; VI-NEXT:    v_mov_b32_e32 v4, s2
; VI-NEXT:    flat_store_dword v[0:1], v4
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    flat_store_dword v[2:3], v0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_endpgm
;
; CI-LABEL: s_min_max_v2i16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0xd
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s4, s0
; CI-NEXT:    s_ashr_i32 s10, s8, 16
; CI-NEXT:    s_ashr_i32 s11, s9, 16
; CI-NEXT:    s_sext_i32_i16 s8, s8
; CI-NEXT:    s_sext_i32_i16 s9, s9
; CI-NEXT:    s_max_i32 s12, s10, s11
; CI-NEXT:    s_mov_b32 s5, s1
; CI-NEXT:    s_max_i32 s13, s8, s9
; CI-NEXT:    v_mov_b32_e32 v0, s12
; CI-NEXT:    s_min_i32 s10, s10, s11
; CI-NEXT:    buffer_store_short v0, off, s[4:7], 0 offset:2
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s13
; CI-NEXT:    s_mov_b32 s0, s2
; CI-NEXT:    s_mov_b32 s1, s3
; CI-NEXT:    s_mov_b32 s2, s6
; CI-NEXT:    s_mov_b32 s3, s7
; CI-NEXT:    s_min_i32 s8, s8, s9
; CI-NEXT:    buffer_store_short v0, off, s[4:7], 0
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s10
; CI-NEXT:    buffer_store_short v0, off, s[0:3], 0 offset:2
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    s_endpgm
  %cond0 = icmp sgt <2 x i16> %val0, %val1
  %sel0 = select <2 x i1> %cond0, <2 x i16> %val0, <2 x i16> %val1
  %sel1 = select <2 x i1> %cond0, <2 x i16> %val1, <2 x i16> %val0

  store volatile <2 x i16> %sel0, ptr addrspace(1) %out0, align 4
  store volatile <2 x i16> %sel1, ptr addrspace(1) %out1, align 4
  ret void
}

define amdgpu_kernel void @v_min_max_v2i16(ptr addrspace(1) %out0, ptr addrspace(1) %out1, ptr addrspace(1) %ptr0, ptr addrspace(1) %ptr1) #0 {
; GFX9-LABEL: v_min_max_v2i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[12:13] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_load_dword v2, v0, s[14:15] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_max_i16 v3, v1, v2
; GFX9-NEXT:    v_pk_min_i16 v1, v1, v2
; GFX9-NEXT:    global_store_dword v0, v3, s[8:9]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v1, s[10:11]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_min_max_v2i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    v_mov_b32_e32 v3, s7
; VI-NEXT:    flat_load_dword v4, v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    flat_load_dword v5, v[2:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    v_max_i32_sdwa v6, sext(v4), sext(v5) dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; VI-NEXT:    v_max_i32_sdwa v7, sext(v4), sext(v5) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; VI-NEXT:    v_min_i32_sdwa v8, sext(v4), sext(v5) dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; VI-NEXT:    v_min_i32_sdwa v4, sext(v4), sext(v5) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; VI-NEXT:    v_or_b32_sdwa v5, v7, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v4, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    flat_store_dword v[0:1], v5
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    flat_store_dword v[2:3], v4
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_min_max_v2i16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_mov_b32 s14, s10
; CI-NEXT:    s_mov_b32 s15, s11
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s12, s4
; CI-NEXT:    s_mov_b32 s13, s5
; CI-NEXT:    s_mov_b32 s4, s6
; CI-NEXT:    s_mov_b32 s5, s7
; CI-NEXT:    s_mov_b32 s6, s10
; CI-NEXT:    s_mov_b32 s7, s11
; CI-NEXT:    buffer_load_sshort v0, off, s[12:15], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_load_sshort v1, off, s[12:15], 0 offset:2 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_load_sshort v2, off, s[4:7], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_load_sshort v3, off, s[4:7], 0 offset:2 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    s_mov_b32 s8, s0
; CI-NEXT:    s_mov_b32 s9, s1
; CI-NEXT:    s_mov_b32 s4, s2
; CI-NEXT:    s_mov_b32 s5, s3
; CI-NEXT:    v_max_i32_e32 v4, v0, v2
; CI-NEXT:    v_max_i32_e32 v5, v1, v3
; CI-NEXT:    v_min_i32_e32 v0, v0, v2
; CI-NEXT:    v_min_i32_e32 v1, v1, v3
; CI-NEXT:    buffer_store_short v5, off, s[8:11], 0 offset:2
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_store_short v4, off, s[8:11], 0
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_store_short v1, off, s[4:7], 0 offset:2
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_store_short v0, off, s[4:7], 0
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    s_endpgm
  %val0 = load volatile <2 x i16>, ptr addrspace(1) %ptr0
  %val1 = load volatile <2 x i16>, ptr addrspace(1) %ptr1

  %cond0 = icmp sgt <2 x i16> %val0, %val1
  %sel0 = select <2 x i1> %cond0, <2 x i16> %val0, <2 x i16> %val1
  %sel1 = select <2 x i1> %cond0, <2 x i16> %val1, <2 x i16> %val0

  store volatile <2 x i16> %sel0, ptr addrspace(1) %out0, align 4
  store volatile <2 x i16> %sel1, ptr addrspace(1) %out1, align 4
  ret void
}

define amdgpu_kernel void @s_min_max_v4i16(ptr addrspace(1) %out0, ptr addrspace(1) %out1, <4 x i16> %val0, <4 x i16> %val1) #0 {
; GFX9-LABEL: s_min_max_v4i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s15
; GFX9-NEXT:    v_mov_b32_e32 v5, s14
; GFX9-NEXT:    v_pk_max_i16 v1, s13, v2
; GFX9-NEXT:    v_pk_max_i16 v0, s12, v5
; GFX9-NEXT:    v_pk_min_i16 v3, s13, v2
; GFX9-NEXT:    v_pk_min_i16 v2, s12, v5
; GFX9-NEXT:    global_store_dwordx2 v4, v[0:1], s[8:9]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v4, v[2:3], s[10:11]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: s_min_max_v4i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    s_ashr_i32 s0, s7, 16
; VI-NEXT:    s_ashr_i32 s1, s5, 16
; VI-NEXT:    s_sext_i32_i16 s3, s7
; VI-NEXT:    s_sext_i32_i16 s5, s5
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    s_max_i32 s2, s1, s0
; VI-NEXT:    s_max_i32 s7, s5, s3
; VI-NEXT:    s_lshl_b32 s2, s2, 16
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    s_or_b32 s2, s7, s2
; VI-NEXT:    s_ashr_i32 s7, s6, 16
; VI-NEXT:    s_ashr_i32 s8, s4, 16
; VI-NEXT:    s_sext_i32_i16 s6, s6
; VI-NEXT:    s_sext_i32_i16 s4, s4
; VI-NEXT:    s_min_i32 s0, s1, s0
; VI-NEXT:    s_min_i32 s1, s5, s3
; VI-NEXT:    s_max_i32 s9, s8, s7
; VI-NEXT:    s_max_i32 s10, s4, s6
; VI-NEXT:    s_lshl_b32 s0, s0, 16
; VI-NEXT:    s_and_b32 s1, s1, 0xffff
; VI-NEXT:    s_lshl_b32 s9, s9, 16
; VI-NEXT:    s_and_b32 s10, s10, 0xffff
; VI-NEXT:    v_mov_b32_e32 v5, s2
; VI-NEXT:    s_or_b32 s0, s1, s0
; VI-NEXT:    s_min_i32 s1, s8, s7
; VI-NEXT:    s_min_i32 s2, s4, s6
; VI-NEXT:    s_or_b32 s9, s10, s9
; VI-NEXT:    s_lshl_b32 s1, s1, 16
; VI-NEXT:    s_and_b32 s2, s2, 0xffff
; VI-NEXT:    v_mov_b32_e32 v4, s9
; VI-NEXT:    s_or_b32 s1, s2, s1
; VI-NEXT:    v_mov_b32_e32 v6, s1
; VI-NEXT:    v_mov_b32_e32 v7, s0
; VI-NEXT:    flat_store_dwordx2 v[0:1], v[4:5]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[6:7]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_endpgm
;
; CI-LABEL: s_min_max_v4i16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_ashr_i32 s12, s5, 16
; CI-NEXT:    s_ashr_i32 s14, s7, 16
; CI-NEXT:    s_sext_i32_i16 s5, s5
; CI-NEXT:    s_sext_i32_i16 s7, s7
; CI-NEXT:    s_max_i32 s17, s12, s14
; CI-NEXT:    s_mov_b32 s8, s0
; CI-NEXT:    s_mov_b32 s9, s1
; CI-NEXT:    s_ashr_i32 s13, s4, 16
; CI-NEXT:    s_ashr_i32 s15, s6, 16
; CI-NEXT:    s_max_i32 s19, s5, s7
; CI-NEXT:    v_mov_b32_e32 v0, s17
; CI-NEXT:    s_sext_i32_i16 s4, s4
; CI-NEXT:    s_sext_i32_i16 s6, s6
; CI-NEXT:    s_max_i32 s16, s13, s15
; CI-NEXT:    buffer_store_short v0, off, s[8:11], 0 offset:6
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s19
; CI-NEXT:    s_max_i32 s18, s4, s6
; CI-NEXT:    buffer_store_short v0, off, s[8:11], 0 offset:4
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s16
; CI-NEXT:    s_min_i32 s12, s12, s14
; CI-NEXT:    buffer_store_short v0, off, s[8:11], 0 offset:2
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s18
; CI-NEXT:    s_mov_b32 s0, s2
; CI-NEXT:    s_mov_b32 s1, s3
; CI-NEXT:    s_mov_b32 s2, s10
; CI-NEXT:    s_mov_b32 s3, s11
; CI-NEXT:    s_min_i32 s5, s5, s7
; CI-NEXT:    buffer_store_short v0, off, s[8:11], 0
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s12
; CI-NEXT:    s_min_i32 s13, s13, s15
; CI-NEXT:    buffer_store_short v0, off, s[0:3], 0 offset:6
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s5
; CI-NEXT:    s_min_i32 s4, s4, s6
; CI-NEXT:    buffer_store_short v0, off, s[0:3], 0 offset:4
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s13
; CI-NEXT:    buffer_store_short v0, off, s[0:3], 0 offset:2
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    s_endpgm
  %cond0 = icmp sgt <4 x i16> %val0, %val1
  %sel0 = select <4 x i1> %cond0, <4 x i16> %val0, <4 x i16> %val1
  %sel1 = select <4 x i1> %cond0, <4 x i16> %val1, <4 x i16> %val0

  store volatile <4 x i16> %sel0, ptr addrspace(1) %out0, align 4
  store volatile <4 x i16> %sel1, ptr addrspace(1) %out1, align 4
  ret void
}

define amdgpu_kernel void @v_min_max_v2i16_user(ptr addrspace(1) %out0, ptr addrspace(1) %out1, ptr addrspace(1) %ptr0, ptr addrspace(1) %ptr1) #0 {
; GFX9-LABEL: v_min_max_v2i16_user:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[12:13] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_load_dword v2, v0, s[14:15] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX9-NEXT:    v_cmp_gt_i32_sdwa vcc, sext(v1), sext(v2) src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-NEXT:    v_cmp_gt_i32_sdwa s[0:1], sext(v1), sext(v2) src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v5, v2, v1, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v6, v4, v3, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v4, s[0:1]
; GFX9-NEXT:    v_and_b32_e32 v4, 0xffff, v5
; GFX9-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; GFX9-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 1, v2
; GFX9-NEXT:    v_lshl_or_b32 v4, v6, 16, v4
; GFX9-NEXT:    v_lshl_or_b32 v1, v3, 16, v1
; GFX9-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX9-NEXT:    global_store_dword v0, v4, s[8:9]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v1, s[10:11]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v0, 3, v2
; GFX9-NEXT:    global_store_byte v[0:1], v0, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_min_max_v2i16_user:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    v_mov_b32_e32 v3, s7
; VI-NEXT:    flat_load_dword v4, v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    flat_load_dword v5, v[2:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    v_ashrrev_i32_e32 v10, 16, v4
; VI-NEXT:    v_ashrrev_i32_e32 v11, 16, v5
; VI-NEXT:    v_bfe_i32 v6, v4, 0, 16
; VI-NEXT:    v_bfe_i32 v7, v5, 0, 16
; VI-NEXT:    v_lshrrev_b32_e32 v8, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v9, 16, v5
; VI-NEXT:    v_cmp_gt_i32_e32 vcc, v10, v11
; VI-NEXT:    v_cndmask_b32_e32 v10, v9, v8, vcc
; VI-NEXT:    v_cmp_gt_i32_e64 s[0:1], v6, v7
; VI-NEXT:    v_cndmask_b32_e64 v6, v5, v4, s[0:1]
; VI-NEXT:    v_cndmask_b32_e32 v7, v8, v9, vcc
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v10
; VI-NEXT:    v_cndmask_b32_e64 v4, v4, v5, s[0:1]
; VI-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; VI-NEXT:    v_cndmask_b32_e64 v9, 0, 1, s[0:1]
; VI-NEXT:    v_or_b32_sdwa v6, v6, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v5, 1, v5
; VI-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; VI-NEXT:    flat_store_dword v[0:1], v6
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_e32 v0, v9, v5
; VI-NEXT:    v_or_b32_sdwa v4, v4, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_and_b32_e32 v0, 3, v0
; VI-NEXT:    flat_store_dword v[2:3], v4
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    flat_store_byte v[0:1], v0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_min_max_v2i16_user:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_mov_b32 s2, s6
; CI-NEXT:    s_mov_b32 s3, s7
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s12
; CI-NEXT:    s_mov_b32 s1, s13
; CI-NEXT:    s_mov_b32 s12, s14
; CI-NEXT:    s_mov_b32 s13, s15
; CI-NEXT:    s_mov_b32 s14, s6
; CI-NEXT:    s_mov_b32 s15, s7
; CI-NEXT:    buffer_load_sshort v0, off, s[0:3], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_load_sshort v1, off, s[0:3], 0 offset:2 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_load_sshort v2, off, s[12:15], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_load_sshort v3, off, s[12:15], 0 offset:2 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    s_mov_b32 s4, s8
; CI-NEXT:    s_mov_b32 s5, s9
; CI-NEXT:    s_mov_b32 s12, s10
; CI-NEXT:    s_mov_b32 s13, s11
; CI-NEXT:    v_cmp_gt_i32_e32 vcc, v0, v2
; CI-NEXT:    v_cmp_gt_i32_e64 s[0:1], v1, v3
; CI-NEXT:    v_cndmask_b32_e32 v4, v2, v0, vcc
; CI-NEXT:    v_cndmask_b32_e64 v5, v3, v1, s[0:1]
; CI-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; CI-NEXT:    v_cndmask_b32_e64 v1, v1, v3, s[0:1]
; CI-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s[0:1]
; CI-NEXT:    buffer_store_short v5, off, s[4:7], 0 offset:2
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_store_short v4, off, s[4:7], 0
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_store_short v1, off, s[12:15], 0 offset:2
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_store_short v0, off, s[12:15], 0
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_lshlrev_b32_e32 v0, 1, v2
; CI-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; CI-NEXT:    v_or_b32_e32 v0, v1, v0
; CI-NEXT:    v_and_b32_e32 v0, 3, v0
; CI-NEXT:    buffer_store_byte v0, off, s[4:7], 0
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    s_endpgm
  %val0 = load volatile <2 x i16>, ptr addrspace(1) %ptr0
  %val1 = load volatile <2 x i16>, ptr addrspace(1) %ptr1

  %cond0 = icmp sgt <2 x i16> %val0, %val1
  %sel0 = select <2 x i1> %cond0, <2 x i16> %val0, <2 x i16> %val1
  %sel1 = select <2 x i1> %cond0, <2 x i16> %val1, <2 x i16> %val0

  store volatile <2 x i16> %sel0, ptr addrspace(1) %out0, align 4
  store volatile <2 x i16> %sel1, ptr addrspace(1) %out1, align 4
  store volatile <2 x i1> %cond0, ptr addrspace(1) poison
  ret void
}

define amdgpu_kernel void @u_min_max_v2i16(ptr addrspace(1) %out0, ptr addrspace(1) %out1, <2 x i16> %val0, <2 x i16> %val1) nounwind {
; GFX9-LABEL: u_min_max_v2i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    v_pk_max_u16 v2, s6, v1
; GFX9-NEXT:    v_pk_min_u16 v1, s6, v1
; GFX9-NEXT:    global_store_dword v0, v2, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: u_min_max_v2i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    s_and_b32 s1, s4, 0xffff
; VI-NEXT:    s_lshr_b32 s3, s5, 16
; VI-NEXT:    s_lshr_b32 s4, s4, 16
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    s_and_b32 s0, s5, 0xffff
; VI-NEXT:    s_max_u32 s5, s4, s3
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    s_max_u32 s2, s1, s0
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_min_u32 s0, s1, s0
; VI-NEXT:    s_min_u32 s1, s4, s3
; VI-NEXT:    s_or_b32 s2, s2, s5
; VI-NEXT:    s_lshl_b32 s1, s1, 16
; VI-NEXT:    s_or_b32 s0, s0, s1
; VI-NEXT:    v_mov_b32_e32 v4, s2
; VI-NEXT:    flat_store_dword v[0:1], v4
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    flat_store_dword v[2:3], v0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_endpgm
;
; CI-LABEL: u_min_max_v2i16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0xd
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s4, s0
; CI-NEXT:    s_lshr_b32 s10, s8, 16
; CI-NEXT:    s_lshr_b32 s11, s9, 16
; CI-NEXT:    s_and_b32 s8, s8, 0xffff
; CI-NEXT:    s_and_b32 s9, s9, 0xffff
; CI-NEXT:    s_max_u32 s13, s10, s11
; CI-NEXT:    s_mov_b32 s5, s1
; CI-NEXT:    s_max_u32 s12, s8, s9
; CI-NEXT:    v_mov_b32_e32 v0, s13
; CI-NEXT:    s_min_u32 s8, s8, s9
; CI-NEXT:    s_min_u32 s9, s10, s11
; CI-NEXT:    buffer_store_short v0, off, s[4:7], 0 offset:2
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s12
; CI-NEXT:    s_mov_b32 s0, s2
; CI-NEXT:    s_mov_b32 s1, s3
; CI-NEXT:    s_mov_b32 s2, s6
; CI-NEXT:    s_mov_b32 s3, s7
; CI-NEXT:    buffer_store_short v0, off, s[4:7], 0
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s9
; CI-NEXT:    buffer_store_short v0, off, s[0:3], 0 offset:2
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    s_endpgm
  %cond0 = icmp ugt <2 x i16> %val0, %val1
  %sel0 = select <2 x i1> %cond0, <2 x i16> %val0, <2 x i16> %val1
  %sel1 = select <2 x i1> %cond0, <2 x i16> %val1, <2 x i16> %val0

  store volatile <2 x i16> %sel0, ptr addrspace(1) %out0, align 4
  store volatile <2 x i16> %sel1, ptr addrspace(1) %out1, align 4
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x() #1

attributes #0 = { nounwind }
attributes #1 = { nounwind readnone }
