; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1200 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX12,GFX12-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1200 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX12,GFX12-GISEL %s

declare i32 @llvm.amdgcn.ds.bpermute.fi.b32(i32, i32) #0

define amdgpu_kernel void @ds_bpermute_fi_b32(ptr addrspace(1) %out, i32 %index, i32 %src) nounwind {
; GFX12-LABEL: ds_bpermute_fi_b32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    ds_bpermute_fi_b32 v0, v0, v1
; GFX12-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-NEXT:    s_endpgm
  %bpermute = call i32 @llvm.amdgcn.ds.bpermute.fi.b32(i32 %index, i32 %src) #0
  store i32 %bpermute, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @ds_bpermute_fi_b32_imm_offset(ptr addrspace(1) %out, i32 %base_index, i32 %src) nounwind {
; GFX12-SDAG-LABEL: ds_bpermute_fi_b32_imm_offset:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-SDAG-NEXT:    ds_bpermute_fi_b32 v0, v0, v1 offset:4
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-SDAG-NEXT:    s_wait_dscnt 0x0
; GFX12-SDAG-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: ds_bpermute_fi_b32_imm_offset:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_add_co_i32 s2, s2, 4
; GFX12-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, s3 :: v_dual_mov_b32 v0, s2
; GFX12-GISEL-NEXT:    ds_bpermute_fi_b32 v0, v0, v1
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-GISEL-NEXT:    s_wait_dscnt 0x0
; GFX12-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %index = add i32 %base_index, 4
  %bpermute = call i32 @llvm.amdgcn.ds.bpermute.fi.b32(i32 %index, i32 %src) #0
  store i32 %bpermute, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @ds_bpermute_fi_b32_imm_index(ptr addrspace(1) %out, i32 %base_index, i32 %src) nounwind {
; GFX12-SDAG-LABEL: ds_bpermute_fi_b32_imm_index:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b32 s0, s[4:5], 0x30
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s0
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-SDAG-NEXT:    ds_bpermute_fi_b32 v1, v0, v1 offset:64
; GFX12-SDAG-NEXT:    s_wait_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: ds_bpermute_fi_b32_imm_index:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b32 s0, s[4:5], 0x30
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, 64 :: v_dual_mov_b32 v1, s0
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-GISEL-NEXT:    ds_bpermute_fi_b32 v0, v0, v1
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-GISEL-NEXT:    s_wait_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %bpermute = call i32 @llvm.amdgcn.ds.bpermute.fi.b32(i32 64, i32 %src) #0
  store i32 %bpermute, ptr addrspace(1) %out, align 4
  ret void
}

define void @ds_bpermute_fi_b32_add_shl(ptr addrspace(1) %out, i32 %base_index, i32 %src) nounwind {
; GFX12-SDAG-LABEL: ds_bpermute_fi_b32_add_shl:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v2
; GFX12-SDAG-NEXT:    ds_bpermute_fi_b32 v2, v2, v3 offset:4
; GFX12-SDAG-NEXT:    s_wait_dscnt 0x0
; GFX12-SDAG-NEXT:    global_store_b32 v[0:1], v2, off
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: ds_bpermute_fi_b32_add_shl:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_lshl_add_u32 v2, v2, 2, 4
; GFX12-GISEL-NEXT:    ds_bpermute_fi_b32 v2, v2, v3
; GFX12-GISEL-NEXT:    s_wait_dscnt 0x0
; GFX12-GISEL-NEXT:    global_store_b32 v[0:1], v2, off
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %index = add i32 %base_index, 1
  %byte_index = shl i32 %index, 2
  %bpermute = call i32 @llvm.amdgcn.ds.bpermute.fi.b32(i32 %byte_index, i32 %src) #0
  store i32 %bpermute, ptr addrspace(1) %out, align 4
  ret void
}

define void @ds_bpermute_fi_b32_or_shl(ptr addrspace(1) %out, i32 %base_index, i32 %src) nounwind {
; GFX12-SDAG-LABEL: ds_bpermute_fi_b32_or_shl:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_and_b32_e32 v2, 62, v2
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v2
; GFX12-SDAG-NEXT:    ds_bpermute_fi_b32 v2, v2, v3 offset:4
; GFX12-SDAG-NEXT:    s_wait_dscnt 0x0
; GFX12-SDAG-NEXT:    global_store_b32 v[0:1], v2, off
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: ds_bpermute_fi_b32_or_shl:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_and_b32_e32 v2, 62, v2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_lshl_or_b32 v2, v2, 2, 4
; GFX12-GISEL-NEXT:    ds_bpermute_fi_b32 v2, v2, v3
; GFX12-GISEL-NEXT:    s_wait_dscnt 0x0
; GFX12-GISEL-NEXT:    global_store_b32 v[0:1], v2, off
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %masked = and i32 %base_index, 62
  %index = or i32 %masked, 1
  %byte_index = shl i32 %index, 2
  %bpermute = call i32 @llvm.amdgcn.ds.bpermute.fi.b32(i32 %byte_index, i32 %src) #0
  store i32 %bpermute, ptr addrspace(1) %out, align 4
  ret void
}

attributes #0 = { nounwind readnone convergent }
