; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible  < %s | FileCheck %s
; RUN: llc -mattr=+sme -force-streaming  < %s | FileCheck %s
; RUN: llc -force-streaming-compatible < %s | FileCheck %s --check-prefix=NONEON-NOSVE

target triple = "aarch64-unknown-linux-gnu"

; Although SVE immediate packing should be fully tested using scalable vectors,
; these tests protects against the possibility that scalable nodes, resulting
; from lowering fixed length vector operations, trigger different isel patterns.

; FIXME: These instructions should have the immediate form

;
; ADD
;

define void @add_v32i8(ptr %a) {
; CHECK-LABEL: add_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    add z0.b, z0.b, #7 // =0x7
; CHECK-NEXT:    add z1.b, z1.b, #7 // =0x7
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: add_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp]
; NONEON-NOSVE-NEXT:    add w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %res = add <32 x i8> %op1, splat(i8 7)
  store <32 x i8> %res, ptr %a
  ret void
}

define void @add_v16i16(ptr %a) {
; CHECK-LABEL: add_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    add z0.h, z0.h, #15 // =0xf
; CHECK-NEXT:    add z1.h, z1.h, #15 // =0xf
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: add_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    add w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    add w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    add w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    add w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    add w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    add w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    add w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    add w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    add w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    add w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    add w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    add w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    add w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    add w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    add w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp]
; NONEON-NOSVE-NEXT:    add w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = add <16 x i16> %op1, splat(i16 15)
  store <16 x i16> %res, ptr %a
  ret void
}

define void @add_v8i32(ptr %a) {
; CHECK-LABEL: add_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    add z0.s, z0.s, #31 // =0x1f
; CHECK-NEXT:    add z1.s, z1.s, #31 // =0x1f
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: add_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    add w9, w8, #31
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    add w8, w8, #31
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    add w9, w8, #31
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    add w8, w8, #31
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #12]
; NONEON-NOSVE-NEXT:    add w9, w8, #31
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    add w8, w8, #31
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #4]
; NONEON-NOSVE-NEXT:    add w9, w8, #31
; NONEON-NOSVE-NEXT:    ldr w8, [sp]
; NONEON-NOSVE-NEXT:    add w8, w8, #31
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = add <8 x i32> %op1, splat(i32 31)
  store <8 x i32> %res, ptr %a
  ret void
}

define void @add_v4i64(ptr %a) {
; CHECK-LABEL: add_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    add z0.d, z0.d, #63 // =0x3f
; CHECK-NEXT:    add z1.d, z1.d, #63 // =0x3f
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: add_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    add x9, x8, #63
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    add x8, x8, #63
; NONEON-NOSVE-NEXT:    stp x8, x9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #8]
; NONEON-NOSVE-NEXT:    add x9, x8, #63
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    add x8, x8, #63
; NONEON-NOSVE-NEXT:    stp x8, x9, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = add <4 x i64> %op1, splat(i64 63)
  store <4 x i64> %res, ptr %a
  ret void
}

;
; AND
;

define void @and_v32i8(ptr %a) {
; CHECK-LABEL: and_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    and z0.b, z0.b, #0x7
; CHECK-NEXT:    and z1.b, z1.b, #0x7
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: and_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %res = and <32 x i8> %op1, splat(i8 7)
  store <32 x i8> %res, ptr %a
  ret void
}

define void @and_v16i16(ptr %a) {
; CHECK-LABEL: and_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    and z0.h, z0.h, #0xf
; CHECK-NEXT:    and z1.h, z1.h, #0xf
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: and_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    and w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    and w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    and w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    and w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    and w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    and w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    and w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    and w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    and w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    and w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    and w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    and w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    and w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    and w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    and w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp]
; NONEON-NOSVE-NEXT:    and w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = and <16 x i16> %op1, splat(i16 15)
  store <16 x i16> %res, ptr %a
  ret void
}

define void @and_v8i32(ptr %a) {
; CHECK-LABEL: and_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    and z0.s, z0.s, #0x1f
; CHECK-NEXT:    and z1.s, z1.s, #0x1f
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: and_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    and w9, w8, #0x1f
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x1f
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    and w9, w8, #0x1f
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x1f
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #12]
; NONEON-NOSVE-NEXT:    and w9, w8, #0x1f
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x1f
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #4]
; NONEON-NOSVE-NEXT:    and w9, w8, #0x1f
; NONEON-NOSVE-NEXT:    ldr w8, [sp]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x1f
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = and <8 x i32> %op1, splat(i32 31)
  store <8 x i32> %res, ptr %a
  ret void
}

define void @and_v4i64(ptr %a) {
; CHECK-LABEL: and_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    and z0.d, z0.d, #0x3f
; CHECK-NEXT:    and z1.d, z1.d, #0x3f
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: and_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    and x9, x8, #0x3f
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    and x8, x8, #0x3f
; NONEON-NOSVE-NEXT:    stp x8, x9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #8]
; NONEON-NOSVE-NEXT:    and x9, x8, #0x3f
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    and x8, x8, #0x3f
; NONEON-NOSVE-NEXT:    stp x8, x9, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = and <4 x i64> %op1, splat(i64 63)
  store <4 x i64> %res, ptr %a
  ret void
}

;
; ASHR
;

define void @ashr_v32i8(ptr %a) {
; CHECK-LABEL: ashr_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    asr z0.b, z0.b, #7
; CHECK-NEXT:    asr z1.b, z1.b, #7
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ashr_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %res = ashr <32 x i8> %op1, splat(i8 7)
  store <32 x i8> %res, ptr %a
  ret void
}

define void @ashr_v16i16(ptr %a) {
; CHECK-LABEL: ashr_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    asr z0.h, z0.h, #15
; CHECK-NEXT:    asr z1.h, z1.h, #15
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ashr_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = ashr <16 x i16> %op1, splat(i16 15)
  store <16 x i16> %res, ptr %a
  ret void
}

define void @ashr_v8i32(ptr %a) {
; CHECK-LABEL: ashr_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    asr z0.s, z0.s, #31
; CHECK-NEXT:    asr z1.s, z1.s, #31
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ashr_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    asr w9, w8, #31
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    asr w8, w8, #31
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    asr w9, w8, #31
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    asr w8, w8, #31
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #12]
; NONEON-NOSVE-NEXT:    asr w9, w8, #31
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    asr w8, w8, #31
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #4]
; NONEON-NOSVE-NEXT:    asr w9, w8, #31
; NONEON-NOSVE-NEXT:    ldr w8, [sp]
; NONEON-NOSVE-NEXT:    asr w8, w8, #31
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = ashr <8 x i32> %op1, splat(i32 31)
  store <8 x i32> %res, ptr %a
  ret void
}

define void @ashr_v4i64(ptr %a) {
; CHECK-LABEL: ashr_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    asr z0.d, z0.d, #63
; CHECK-NEXT:    asr z1.d, z1.d, #63
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ashr_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    asr x9, x8, #63
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    asr x8, x8, #63
; NONEON-NOSVE-NEXT:    stp x8, x9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #8]
; NONEON-NOSVE-NEXT:    asr x9, x8, #63
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    asr x8, x8, #63
; NONEON-NOSVE-NEXT:    stp x8, x9, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = ashr <4 x i64> %op1, splat(i64 63)
  store <4 x i64> %res, ptr %a
  ret void
}

;
; ICMP
;

define void @icmp_eq_v32i8(ptr %a) {
; CHECK-LABEL: icmp_eq_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    cmpeq p1.b, p0/z, z0.b, #7
; CHECK-NEXT:    cmpeq p0.b, p0/z, z1.b, #7
; CHECK-NEXT:    mov z0.b, p1/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    mov z1.b, p0/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: icmp_eq_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp]
; NONEON-NOSVE-NEXT:    cmp w8, #7
; NONEON-NOSVE-NEXT:    csetm w8, eq
; NONEON-NOSVE-NEXT:    strb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %cmp = icmp eq <32 x i8> %op1, splat(i8 7)
  %res = sext <32 x i1> %cmp to <32 x i8>
  store <32 x i8> %res, ptr %a
  ret void
}

define void @icmp_sge_v16i16(ptr %a) {
; CHECK-LABEL: icmp_sge_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    cmpge p1.h, p0/z, z0.h, #15
; CHECK-NEXT:    cmpge p0.h, p0/z, z1.h, #15
; CHECK-NEXT:    mov z0.h, p1/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    mov z1.h, p0/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: icmp_sge_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    cmp w8, #14
; NONEON-NOSVE-NEXT:    csetm w8, gt
; NONEON-NOSVE-NEXT:    strh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w8, #14
; NONEON-NOSVE-NEXT:    csetm w8, gt
; NONEON-NOSVE-NEXT:    strh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    cmp w8, #14
; NONEON-NOSVE-NEXT:    csetm w8, gt
; NONEON-NOSVE-NEXT:    strh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w8, #14
; NONEON-NOSVE-NEXT:    csetm w8, gt
; NONEON-NOSVE-NEXT:    strh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w8, #14
; NONEON-NOSVE-NEXT:    csetm w8, gt
; NONEON-NOSVE-NEXT:    strh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w8, #14
; NONEON-NOSVE-NEXT:    csetm w8, gt
; NONEON-NOSVE-NEXT:    strh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w8, #14
; NONEON-NOSVE-NEXT:    csetm w8, gt
; NONEON-NOSVE-NEXT:    strh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w8, #14
; NONEON-NOSVE-NEXT:    csetm w8, gt
; NONEON-NOSVE-NEXT:    strh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w8, #14
; NONEON-NOSVE-NEXT:    csetm w8, gt
; NONEON-NOSVE-NEXT:    strh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w8, #14
; NONEON-NOSVE-NEXT:    csetm w8, gt
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w8, #14
; NONEON-NOSVE-NEXT:    csetm w8, gt
; NONEON-NOSVE-NEXT:    strh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w8, #14
; NONEON-NOSVE-NEXT:    csetm w8, gt
; NONEON-NOSVE-NEXT:    strh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w8, #14
; NONEON-NOSVE-NEXT:    csetm w8, gt
; NONEON-NOSVE-NEXT:    strh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w8, #14
; NONEON-NOSVE-NEXT:    csetm w8, gt
; NONEON-NOSVE-NEXT:    strh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    cmp w8, #14
; NONEON-NOSVE-NEXT:    csetm w8, gt
; NONEON-NOSVE-NEXT:    strh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp]
; NONEON-NOSVE-NEXT:    cmp w8, #14
; NONEON-NOSVE-NEXT:    csetm w8, gt
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %cmp = icmp sge <16 x i16> %op1, splat(i16 15)
  %res = sext <16 x i1> %cmp to <16 x i16>
  store <16 x i16> %res, ptr %a
  ret void
}

define void @icmp_sgt_v8i32(ptr %a) {
; CHECK-LABEL: icmp_sgt_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    cmpgt p1.s, p0/z, z0.s, #-8
; CHECK-NEXT:    cmpgt p0.s, p0/z, z1.s, #-8
; CHECK-NEXT:    mov z0.s, p1/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    mov z1.s, p0/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: icmp_sgt_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmn w8, #8
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    csetm w9, gt
; NONEON-NOSVE-NEXT:    cmn w8, #8
; NONEON-NOSVE-NEXT:    csetm w8, gt
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmn w8, #8
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    csetm w9, gt
; NONEON-NOSVE-NEXT:    cmn w8, #8
; NONEON-NOSVE-NEXT:    csetm w8, gt
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #12]
; NONEON-NOSVE-NEXT:    cmn w8, #8
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    csetm w9, gt
; NONEON-NOSVE-NEXT:    cmn w8, #8
; NONEON-NOSVE-NEXT:    csetm w8, gt
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #4]
; NONEON-NOSVE-NEXT:    cmn w8, #8
; NONEON-NOSVE-NEXT:    ldr w8, [sp]
; NONEON-NOSVE-NEXT:    csetm w9, gt
; NONEON-NOSVE-NEXT:    cmn w8, #8
; NONEON-NOSVE-NEXT:    csetm w8, gt
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %cmp = icmp sgt <8 x i32> %op1, splat(i32 -8)
  %res = sext <8 x i1> %cmp to <8 x i32>
  store <8 x i32> %res, ptr %a
  ret void
}

define void @icmp_ult_v4i64(ptr %a) {
; CHECK-LABEL: icmp_ult_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    cmplo p1.d, p0/z, z0.d, #63
; CHECK-NEXT:    cmplo p0.d, p0/z, z1.d, #63
; CHECK-NEXT:    mov z0.d, p1/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    mov z1.d, p0/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: icmp_ult_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp x8, #63
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    csetm x9, lo
; NONEON-NOSVE-NEXT:    cmp x8, #63
; NONEON-NOSVE-NEXT:    csetm x8, lo
; NONEON-NOSVE-NEXT:    stp x8, x9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp x8, #63
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    csetm x9, lo
; NONEON-NOSVE-NEXT:    cmp x8, #63
; NONEON-NOSVE-NEXT:    csetm x8, lo
; NONEON-NOSVE-NEXT:    stp x8, x9, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %cmp = icmp ult <4 x i64> %op1, splat(i64 63)
  %res = sext <4 x i1> %cmp to <4 x i64>
  store <4 x i64> %res, ptr %a
  ret void
}

;
; LSHR
;

define void @lshr_v32i8(ptr %a) {
; CHECK-LABEL: lshr_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    lsr z0.b, z0.b, #7
; CHECK-NEXT:    lsr z1.b, z1.b, #7
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: lshr_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #7, #1
; NONEON-NOSVE-NEXT:    strb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %res = lshr <32 x i8> %op1, splat(i8 7)
  store <32 x i8> %res, ptr %a
  ret void
}

define void @lshr_v16i16(ptr %a) {
; CHECK-LABEL: lshr_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    lsr z0.h, z0.h, #15
; CHECK-NEXT:    lsr z1.h, z1.h, #15
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: lshr_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #15, #1
; NONEON-NOSVE-NEXT:    strh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #15, #1
; NONEON-NOSVE-NEXT:    strh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #15, #1
; NONEON-NOSVE-NEXT:    strh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #15, #1
; NONEON-NOSVE-NEXT:    strh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #15, #1
; NONEON-NOSVE-NEXT:    strh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #15, #1
; NONEON-NOSVE-NEXT:    strh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #15, #1
; NONEON-NOSVE-NEXT:    strh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #15, #1
; NONEON-NOSVE-NEXT:    strh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #15, #1
; NONEON-NOSVE-NEXT:    strh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #15, #1
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #15, #1
; NONEON-NOSVE-NEXT:    strh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #15, #1
; NONEON-NOSVE-NEXT:    strh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #15, #1
; NONEON-NOSVE-NEXT:    strh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #15, #1
; NONEON-NOSVE-NEXT:    strh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #15, #1
; NONEON-NOSVE-NEXT:    strh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp]
; NONEON-NOSVE-NEXT:    ubfx w8, w8, #15, #1
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = lshr <16 x i16> %op1, splat(i16 15)
  store <16 x i16> %res, ptr %a
  ret void
}

define void @lshr_v8i32(ptr %a) {
; CHECK-LABEL: lshr_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    lsr z0.s, z0.s, #31
; CHECK-NEXT:    lsr z1.s, z1.s, #31
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: lshr_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    lsr w9, w8, #31
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #31
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    lsr w9, w8, #31
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #31
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #12]
; NONEON-NOSVE-NEXT:    lsr w9, w8, #31
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #31
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #4]
; NONEON-NOSVE-NEXT:    lsr w9, w8, #31
; NONEON-NOSVE-NEXT:    ldr w8, [sp]
; NONEON-NOSVE-NEXT:    lsr w8, w8, #31
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = lshr <8 x i32> %op1, splat(i32 31)
  store <8 x i32> %res, ptr %a
  ret void
}

define void @lshr_v4i64(ptr %a) {
; CHECK-LABEL: lshr_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    lsr z0.d, z0.d, #63
; CHECK-NEXT:    lsr z1.d, z1.d, #63
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: lshr_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    lsr x9, x8, #63
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    lsr x8, x8, #63
; NONEON-NOSVE-NEXT:    stp x8, x9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #8]
; NONEON-NOSVE-NEXT:    lsr x9, x8, #63
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    lsr x8, x8, #63
; NONEON-NOSVE-NEXT:    stp x8, x9, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = lshr <4 x i64> %op1, splat(i64 63)
  store <4 x i64> %res, ptr %a
  ret void
}

;
; MUL
;

define void @mul_v32i8(ptr %a) {
; CHECK-LABEL: mul_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    mul z0.b, z0.b, #7
; CHECK-NEXT:    mul z1.b, z1.b, #7
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: mul_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #3
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %res = mul <32 x i8> %op1, splat(i8 7)
  store <32 x i8> %res, ptr %a
  ret void
}

define void @mul_v16i16(ptr %a) {
; CHECK-LABEL: mul_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    mul z0.h, z0.h, #15
; CHECK-NEXT:    mul z1.h, z1.h, #15
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: mul_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #4
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #4
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #4
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #4
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #4
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #4
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #4
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #4
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #4
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #4
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #4
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #4
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #4
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #4
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #4
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #4
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = mul <16 x i16> %op1, splat(i16 15)
  store <16 x i16> %res, ptr %a
  ret void
}

define void @mul_v8i32(ptr %a) {
; CHECK-LABEL: mul_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    mul z0.s, z0.s, #31
; CHECK-NEXT:    mul z1.s, z1.s, #31
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: mul_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #5
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #5
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #5
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #5
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #12]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #5
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #5
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #4]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #5
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldr w8, [sp]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #5
; NONEON-NOSVE-NEXT:    sub w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = mul <8 x i32> %op1, splat(i32 31)
  store <8 x i32> %res, ptr %a
  ret void
}

define void @mul_v4i64(ptr %a) {
; CHECK-LABEL: mul_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    mul z0.d, z0.d, #63
; CHECK-NEXT:    mul z1.d, z1.d, #63
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: mul_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    lsl x9, x8, #6
; NONEON-NOSVE-NEXT:    sub x8, x9, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    lsl x9, x8, #6
; NONEON-NOSVE-NEXT:    sub x8, x9, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #8]
; NONEON-NOSVE-NEXT:    lsl x9, x8, #6
; NONEON-NOSVE-NEXT:    sub x8, x9, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    lsl x9, x8, #6
; NONEON-NOSVE-NEXT:    sub x8, x9, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = mul <4 x i64> %op1, splat(i64 63)
  store <4 x i64> %res, ptr %a
  ret void
}

;
; OR
;

define void @or_v32i8(ptr %a) {
; CHECK-LABEL: or_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    orr z0.b, z0.b, #0x7
; CHECK-NEXT:    orr z1.b, z1.b, #0x7
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: or_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %res = or <32 x i8> %op1, splat(i8 7)
  store <32 x i8> %res, ptr %a
  ret void
}

define void @or_v16i16(ptr %a) {
; CHECK-LABEL: or_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    orr z0.h, z0.h, #0xf
; CHECK-NEXT:    orr z1.h, z1.h, #0xf
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: or_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = or <16 x i16> %op1, splat(i16 15)
  store <16 x i16> %res, ptr %a
  ret void
}

define void @or_v8i32(ptr %a) {
; CHECK-LABEL: or_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    orr z0.s, z0.s, #0x1f
; CHECK-NEXT:    orr z1.s, z1.s, #0x1f
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: or_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    orr w9, w8, #0x1f
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x1f
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    orr w9, w8, #0x1f
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x1f
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #12]
; NONEON-NOSVE-NEXT:    orr w9, w8, #0x1f
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x1f
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #4]
; NONEON-NOSVE-NEXT:    orr w9, w8, #0x1f
; NONEON-NOSVE-NEXT:    ldr w8, [sp]
; NONEON-NOSVE-NEXT:    orr w8, w8, #0x1f
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = or <8 x i32> %op1, splat(i32 31)
  store <8 x i32> %res, ptr %a
  ret void
}

define void @or_v4i64(ptr %a) {
; CHECK-LABEL: or_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    orr z0.d, z0.d, #0x3f
; CHECK-NEXT:    orr z1.d, z1.d, #0x3f
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: or_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    orr x9, x8, #0x3f
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    orr x8, x8, #0x3f
; NONEON-NOSVE-NEXT:    stp x8, x9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #8]
; NONEON-NOSVE-NEXT:    orr x9, x8, #0x3f
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    orr x8, x8, #0x3f
; NONEON-NOSVE-NEXT:    stp x8, x9, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = or <4 x i64> %op1, splat(i64 63)
  store <4 x i64> %res, ptr %a
  ret void
}

;
; SHL
;

define void @shl_v32i8(ptr %a) {
; CHECK-LABEL: shl_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    lsl z0.b, z0.b, #7
; CHECK-NEXT:    lsl z1.b, z1.b, #7
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: shl_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %res = shl <32 x i8> %op1, splat(i8 7)
  store <32 x i8> %res, ptr %a
  ret void
}

define void @shl_v16i16(ptr %a) {
; CHECK-LABEL: shl_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    lsl z0.h, z0.h, #15
; CHECK-NEXT:    lsl z1.h, z1.h, #15
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: shl_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = shl <16 x i16> %op1, splat(i16 15)
  store <16 x i16> %res, ptr %a
  ret void
}

define void @shl_v8i32(ptr %a) {
; CHECK-LABEL: shl_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    lsl z0.s, z0.s, #31
; CHECK-NEXT:    lsl z1.s, z1.s, #31
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: shl_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #31
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #31
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #31
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #31
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #12]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #31
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #31
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #4]
; NONEON-NOSVE-NEXT:    lsl w9, w8, #31
; NONEON-NOSVE-NEXT:    ldr w8, [sp]
; NONEON-NOSVE-NEXT:    lsl w8, w8, #31
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = shl <8 x i32> %op1, splat(i32 31)
  store <8 x i32> %res, ptr %a
  ret void
}

define void @shl_v4i64(ptr %a) {
; CHECK-LABEL: shl_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    lsl z0.d, z0.d, #63
; CHECK-NEXT:    lsl z1.d, z1.d, #63
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: shl_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    lsl x9, x8, #63
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    lsl x8, x8, #63
; NONEON-NOSVE-NEXT:    stp x8, x9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #8]
; NONEON-NOSVE-NEXT:    lsl x9, x8, #63
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    lsl x8, x8, #63
; NONEON-NOSVE-NEXT:    stp x8, x9, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = shl <4 x i64> %op1, splat(i64 63)
  store <4 x i64> %res, ptr %a
  ret void
}

;
; SMAX
;

define void @smax_v32i8(ptr %a) {
; CHECK-LABEL: smax_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    smax z0.b, z0.b, #7
; CHECK-NEXT:    smax z1.b, z1.b, #7
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smax_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    mov w8, #7 // =0x7
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #31]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #30]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #29]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #61]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #27]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #59]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #26]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #25]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #57]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #23]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #55]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #21]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #53]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #19]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #51]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #17]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #49]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #47]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #45]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #7]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #37]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #3]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #2]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #33]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %res = call <32 x i8> @llvm.smax.v32i8(<32 x i8> %op1, <32 x i8> splat(i8 7))
  store <32 x i8> %res, ptr %a
  ret void
}

define void @smax_v16i16(ptr %a) {
; CHECK-LABEL: smax_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    smax z0.h, z0.h, #15
; CHECK-NEXT:    smax z1.h, z1.h, #15
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smax_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    mov w8, #15 // =0xf
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #30]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #26]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = call <16 x i16> @llvm.smax.v16i16(<16 x i16> %op1, <16 x i16> splat(i16 15))
  store <16 x i16> %res, ptr %a
  ret void
}

define void @smax_v8i32(ptr %a) {
; CHECK-LABEL: smax_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    smax z0.s, z0.s, #31
; CHECK-NEXT:    smax z1.s, z1.s, #31
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smax_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    mov w8, #31 // =0x1f
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w10, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    stp w9, w10, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w10, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    stp w9, w10, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w10, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, gt
; NONEON-NOSVE-NEXT:    stp w9, w10, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w10, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldr w9, [sp]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    stp w8, w10, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = call <8 x i32> @llvm.smax.v8i32(<8 x i32> %op1, <8 x i32> splat(i32 31))
  store <8 x i32> %res, ptr %a
  ret void
}

define void @smax_v4i64(ptr %a) {
; CHECK-LABEL: smax_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    smax z0.d, z0.d, #63
; CHECK-NEXT:    smax z1.d, z1.d, #63
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smax_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    mov w8, #63 // =0x3f
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp x9, #63
; NONEON-NOSVE-NEXT:    csel x10, x9, x8, gt
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp x9, #63
; NONEON-NOSVE-NEXT:    csel x9, x9, x8, gt
; NONEON-NOSVE-NEXT:    stp x9, x10, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp x9, #63
; NONEON-NOSVE-NEXT:    csel x10, x9, x8, gt
; NONEON-NOSVE-NEXT:    ldr x9, [sp]
; NONEON-NOSVE-NEXT:    cmp x9, #63
; NONEON-NOSVE-NEXT:    csel x8, x9, x8, gt
; NONEON-NOSVE-NEXT:    stp x8, x10, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = call <4 x i64> @llvm.smax.v4i64(<4 x i64> %op1, <4 x i64> splat(i64 63))
  store <4 x i64> %res, ptr %a
  ret void
}

;
; SMIN
;

define void @smin_v32i8(ptr %a) {
; CHECK-LABEL: smin_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    smin z0.b, z0.b, #7
; CHECK-NEXT:    smin z1.b, z1.b, #7
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smin_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    mov w8, #7 // =0x7
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #31]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #30]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #29]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #61]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #27]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #59]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #26]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #25]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #57]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #23]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #55]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #21]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #53]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #19]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #51]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #17]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #49]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #47]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #45]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #7]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #37]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #3]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #2]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w9, [sp, #33]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %res = call <32 x i8> @llvm.smin.v32i8(<32 x i8> %op1, <32 x i8> splat(i8 7))
  store <32 x i8> %res, ptr %a
  ret void
}

define void @smin_v16i16(ptr %a) {
; CHECK-LABEL: smin_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    smin z0.h, z0.h, #15
; CHECK-NEXT:    smin z1.h, z1.h, #15
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smin_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    mov w8, #15 // =0xf
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #30]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #26]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    strh w9, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = call <16 x i16> @llvm.smin.v16i16(<16 x i16> %op1, <16 x i16> splat(i16 15))
  store <16 x i16> %res, ptr %a
  ret void
}

define void @smin_v8i32(ptr %a) {
; CHECK-LABEL: smin_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    smin z0.s, z0.s, #31
; CHECK-NEXT:    smin z1.s, z1.s, #31
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smin_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    mov w8, #31 // =0x1f
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w10, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    stp w9, w10, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w10, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    stp w9, w10, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w10, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lt
; NONEON-NOSVE-NEXT:    stp w9, w10, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w10, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldr w9, [sp]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    stp w8, w10, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = call <8 x i32> @llvm.smin.v8i32(<8 x i32> %op1, <8 x i32> splat(i32 31))
  store <8 x i32> %res, ptr %a
  ret void
}

define void @smin_v4i64(ptr %a) {
; CHECK-LABEL: smin_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    smin z0.d, z0.d, #63
; CHECK-NEXT:    smin z1.d, z1.d, #63
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smin_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    mov w8, #63 // =0x3f
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp x9, #63
; NONEON-NOSVE-NEXT:    csel x10, x9, x8, lt
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp x9, #63
; NONEON-NOSVE-NEXT:    csel x9, x9, x8, lt
; NONEON-NOSVE-NEXT:    stp x9, x10, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp x9, #63
; NONEON-NOSVE-NEXT:    csel x10, x9, x8, lt
; NONEON-NOSVE-NEXT:    ldr x9, [sp]
; NONEON-NOSVE-NEXT:    cmp x9, #63
; NONEON-NOSVE-NEXT:    csel x8, x9, x8, lt
; NONEON-NOSVE-NEXT:    stp x8, x10, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = call <4 x i64> @llvm.smin.v4i64(<4 x i64> %op1, <4 x i64> splat(i64 63))
  store <4 x i64> %res, ptr %a
  ret void
}

;
; SUB
;

define void @sub_v32i8(ptr %a) {
; CHECK-LABEL: sub_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    sub z0.b, z0.b, #7 // =0x7
; CHECK-NEXT:    sub z1.b, z1.b, #7 // =0x7
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sub_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp]
; NONEON-NOSVE-NEXT:    sub w8, w8, #7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %res = sub <32 x i8> %op1, splat(i8 7)
  store <32 x i8> %res, ptr %a
  ret void
}

define void @sub_v16i16(ptr %a) {
; CHECK-LABEL: sub_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    sub z0.h, z0.h, #15 // =0xf
; CHECK-NEXT:    sub z1.h, z1.h, #15 // =0xf
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sub_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    sub w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    sub w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    sub w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    sub w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    sub w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    sub w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    sub w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    sub w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    sub w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    sub w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    sub w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    sub w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    sub w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    sub w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    sub w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp]
; NONEON-NOSVE-NEXT:    sub w8, w8, #15
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = sub <16 x i16> %op1, splat(i16 15)
  store <16 x i16> %res, ptr %a
  ret void
}

define void @sub_v8i32(ptr %a) {
; CHECK-LABEL: sub_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    sub z0.s, z0.s, #31 // =0x1f
; CHECK-NEXT:    sub z1.s, z1.s, #31 // =0x1f
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sub_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    sub w9, w8, #31
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    sub w8, w8, #31
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    sub w9, w8, #31
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    sub w8, w8, #31
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #12]
; NONEON-NOSVE-NEXT:    sub w9, w8, #31
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    sub w8, w8, #31
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #4]
; NONEON-NOSVE-NEXT:    sub w9, w8, #31
; NONEON-NOSVE-NEXT:    ldr w8, [sp]
; NONEON-NOSVE-NEXT:    sub w8, w8, #31
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = sub <8 x i32> %op1, splat(i32 31)
  store <8 x i32> %res, ptr %a
  ret void
}

define void @sub_v4i64(ptr %a) {
; CHECK-LABEL: sub_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    sub z0.d, z0.d, #63 // =0x3f
; CHECK-NEXT:    sub z1.d, z1.d, #63 // =0x3f
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sub_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    sub x9, x8, #63
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    sub x8, x8, #63
; NONEON-NOSVE-NEXT:    stp x8, x9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #8]
; NONEON-NOSVE-NEXT:    sub x9, x8, #63
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    sub x8, x8, #63
; NONEON-NOSVE-NEXT:    stp x8, x9, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = sub <4 x i64> %op1, splat(i64 63)
  store <4 x i64> %res, ptr %a
  ret void
}

;
; UMAX
;

define void @umax_v32i8(ptr %a) {
; CHECK-LABEL: umax_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    umax z0.b, z0.b, #7
; CHECK-NEXT:    umax z1.b, z1.b, #7
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umax_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    mov w8, #7 // =0x7
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #31]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #30]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #29]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #61]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #28]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #27]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #59]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #26]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #25]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #57]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #24]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #23]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #55]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #22]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #21]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #53]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #20]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #19]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #51]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #18]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #17]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #49]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #16]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #47]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #45]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #7]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #6]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #37]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #4]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #3]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #2]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w9, [sp, #33]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp]
; NONEON-NOSVE-NEXT:    tst w9, #0xf8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, ne
; NONEON-NOSVE-NEXT:    strb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %res = call <32 x i8> @llvm.umax.v32i8(<32 x i8> %op1, <32 x i8> splat(i8 7))
  store <32 x i8> %res, ptr %a
  ret void
}

define void @umax_v16i16(ptr %a) {
; CHECK-LABEL: umax_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    umax z0.h, z0.h, #15
; CHECK-NEXT:    umax z1.h, z1.h, #15
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umax_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    mov w8, #15 // =0xf
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #30]
; NONEON-NOSVE-NEXT:    tst w9, #0xfff0
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strh w9, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #28]
; NONEON-NOSVE-NEXT:    tst w9, #0xfff0
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strh w9, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #26]
; NONEON-NOSVE-NEXT:    tst w9, #0xfff0
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strh w9, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #24]
; NONEON-NOSVE-NEXT:    tst w9, #0xfff0
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strh w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #22]
; NONEON-NOSVE-NEXT:    tst w9, #0xfff0
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strh w9, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #20]
; NONEON-NOSVE-NEXT:    tst w9, #0xfff0
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strh w9, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #18]
; NONEON-NOSVE-NEXT:    tst w9, #0xfff0
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strh w9, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #16]
; NONEON-NOSVE-NEXT:    tst w9, #0xfff0
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strh w9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    tst w9, #0xfff0
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strh w9, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    tst w9, #0xfff0
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strh w9, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    tst w9, #0xfff0
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strh w9, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    tst w9, #0xfff0
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strh w9, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #6]
; NONEON-NOSVE-NEXT:    tst w9, #0xfff0
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strh w9, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #4]
; NONEON-NOSVE-NEXT:    tst w9, #0xfff0
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strh w9, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    tst w9, #0xfff0
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, ne
; NONEON-NOSVE-NEXT:    strh w9, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp]
; NONEON-NOSVE-NEXT:    tst w9, #0xfff0
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, ne
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = call <16 x i16> @llvm.umax.v16i16(<16 x i16> %op1, <16 x i16> splat(i16 15))
  store <16 x i16> %res, ptr %a
  ret void
}

define void @umax_v8i32(ptr %a) {
; CHECK-LABEL: umax_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    umax z0.s, z0.s, #31
; CHECK-NEXT:    umax z1.s, z1.s, #31
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umax_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    mov w8, #31 // =0x1f
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w10, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, hi
; NONEON-NOSVE-NEXT:    stp w9, w10, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w10, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, hi
; NONEON-NOSVE-NEXT:    stp w9, w10, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w10, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, hi
; NONEON-NOSVE-NEXT:    stp w9, w10, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w10, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldr w9, [sp]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    stp w8, w10, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = call <8 x i32> @llvm.umax.v8i32(<8 x i32> %op1, <8 x i32> splat(i32 31))
  store <8 x i32> %res, ptr %a
  ret void
}

define void @umax_v4i64(ptr %a) {
; CHECK-LABEL: umax_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    umax z0.d, z0.d, #63
; CHECK-NEXT:    umax z1.d, z1.d, #63
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umax_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    mov w8, #63 // =0x3f
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp x9, #63
; NONEON-NOSVE-NEXT:    csel x10, x9, x8, hi
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp x9, #63
; NONEON-NOSVE-NEXT:    csel x9, x9, x8, hi
; NONEON-NOSVE-NEXT:    stp x9, x10, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp x9, #63
; NONEON-NOSVE-NEXT:    csel x10, x9, x8, hi
; NONEON-NOSVE-NEXT:    ldr x9, [sp]
; NONEON-NOSVE-NEXT:    cmp x9, #63
; NONEON-NOSVE-NEXT:    csel x8, x9, x8, hi
; NONEON-NOSVE-NEXT:    stp x8, x10, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = call <4 x i64> @llvm.umax.v4i64(<4 x i64> %op1, <4 x i64> splat(i64 63))
  store <4 x i64> %res, ptr %a
  ret void
}

;
; UMIN
;

define void @umin_v32i8(ptr %a) {
; CHECK-LABEL: umin_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    umin z0.b, z0.b, #7
; CHECK-NEXT:    umin z1.b, z1.b, #7
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umin_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    mov w8, #7 // =0x7
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #31]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #30]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #29]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #61]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #27]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #59]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #26]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #25]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #57]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #23]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #55]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #21]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #53]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #19]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #51]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #17]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #49]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #47]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #45]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #7]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #37]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #3]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #2]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w9, [sp, #33]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp]
; NONEON-NOSVE-NEXT:    cmp w9, #7
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %res = call <32 x i8> @llvm.umin.v32i8(<32 x i8> %op1, <32 x i8> splat(i8 7))
  store <32 x i8> %res, ptr %a
  ret void
}

define void @umin_v16i16(ptr %a) {
; CHECK-LABEL: umin_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    umin z0.h, z0.h, #15
; CHECK-NEXT:    umin z1.h, z1.h, #15
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umin_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    mov w8, #15 // =0xf
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #30]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strh w9, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strh w9, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #26]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strh w9, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strh w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strh w9, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strh w9, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strh w9, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strh w9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strh w9, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strh w9, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strh w9, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strh w9, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #6]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strh w9, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strh w9, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    strh w9, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp]
; NONEON-NOSVE-NEXT:    cmp w9, #15
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = call <16 x i16> @llvm.umin.v16i16(<16 x i16> %op1, <16 x i16> splat(i16 15))
  store <16 x i16> %res, ptr %a
  ret void
}

define void @umin_v8i32(ptr %a) {
; CHECK-LABEL: umin_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    umin z0.s, z0.s, #31
; CHECK-NEXT:    umin z1.s, z1.s, #31
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umin_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    mov w8, #31 // =0x1f
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w10, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    stp w9, w10, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w10, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    stp w9, w10, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #12]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w10, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w9, w9, w8, lo
; NONEON-NOSVE-NEXT:    stp w9, w10, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #4]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w10, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldr w9, [sp]
; NONEON-NOSVE-NEXT:    cmp w9, #31
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    stp w8, w10, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = call <8 x i32> @llvm.umin.v8i32(<8 x i32> %op1, <8 x i32> splat(i32 31))
  store <8 x i32> %res, ptr %a
  ret void
}

define void @umin_v4i64(ptr %a) {
; CHECK-LABEL: umin_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    umin z0.d, z0.d, #63
; CHECK-NEXT:    umin z1.d, z1.d, #63
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umin_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    mov w8, #63 // =0x3f
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp x9, #63
; NONEON-NOSVE-NEXT:    csel x10, x9, x8, lo
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp x9, #63
; NONEON-NOSVE-NEXT:    csel x9, x9, x8, lo
; NONEON-NOSVE-NEXT:    stp x9, x10, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp x9, #63
; NONEON-NOSVE-NEXT:    csel x10, x9, x8, lo
; NONEON-NOSVE-NEXT:    ldr x9, [sp]
; NONEON-NOSVE-NEXT:    cmp x9, #63
; NONEON-NOSVE-NEXT:    csel x8, x9, x8, lo
; NONEON-NOSVE-NEXT:    stp x8, x10, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = call <4 x i64> @llvm.umin.v4i64(<4 x i64> %op1, <4 x i64> splat(i64 63))
  store <4 x i64> %res, ptr %a
  ret void
}

;
; XOR
;

define void @xor_v32i8(ptr %a) {
; CHECK-LABEL: xor_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    eor z0.b, z0.b, #0x7
; CHECK-NEXT:    eor z1.b, z1.b, #0x7
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: xor_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x7
; NONEON-NOSVE-NEXT:    strb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %res = xor <32 x i8> %op1, splat(i8 7)
  store <32 x i8> %res, ptr %a
  ret void
}

define void @xor_v16i16(ptr %a) {
; CHECK-LABEL: xor_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    eor z0.h, z0.h, #0xf
; CHECK-NEXT:    eor z1.h, z1.h, #0xf
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: xor_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0xf
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = xor <16 x i16> %op1, splat(i16 15)
  store <16 x i16> %res, ptr %a
  ret void
}

define void @xor_v8i32(ptr %a) {
; CHECK-LABEL: xor_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    eor z0.s, z0.s, #0x1f
; CHECK-NEXT:    eor z1.s, z1.s, #0x1f
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: xor_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    eor w9, w8, #0x1f
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x1f
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    eor w9, w8, #0x1f
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x1f
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #12]
; NONEON-NOSVE-NEXT:    eor w9, w8, #0x1f
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x1f
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #4]
; NONEON-NOSVE-NEXT:    eor w9, w8, #0x1f
; NONEON-NOSVE-NEXT:    ldr w8, [sp]
; NONEON-NOSVE-NEXT:    eor w8, w8, #0x1f
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = xor <8 x i32> %op1, splat(i32 31)
  store <8 x i32> %res, ptr %a
  ret void
}

define void @xor_v4i64(ptr %a) {
; CHECK-LABEL: xor_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    eor z0.d, z0.d, #0x3f
; CHECK-NEXT:    eor z1.d, z1.d, #0x3f
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: xor_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    eor x9, x8, #0x3f
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    eor x8, x8, #0x3f
; NONEON-NOSVE-NEXT:    stp x8, x9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #8]
; NONEON-NOSVE-NEXT:    eor x9, x8, #0x3f
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    eor x8, x8, #0x3f
; NONEON-NOSVE-NEXT:    stp x8, x9, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = xor <4 x i64> %op1, splat(i64 63)
  store <4 x i64> %res, ptr %a
  ret void
}

declare <32 x i8> @llvm.smax.v32i8(<32 x i8>, <32 x i8>)
declare <16 x i16> @llvm.smax.v16i16(<16 x i16>, <16 x i16>)
declare <8 x i32> @llvm.smax.v8i32(<8 x i32>, <8 x i32>)
declare <4 x i64> @llvm.smax.v4i64(<4 x i64>, <4 x i64>)

declare <32 x i8> @llvm.smin.v32i8(<32 x i8>, <32 x i8>)
declare <16 x i16> @llvm.smin.v16i16(<16 x i16>, <16 x i16>)
declare <8 x i32> @llvm.smin.v8i32(<8 x i32>, <8 x i32>)
declare <4 x i64> @llvm.smin.v4i64(<4 x i64>, <4 x i64>)

declare <32 x i8> @llvm.umax.v32i8(<32 x i8>, <32 x i8>)
declare <16 x i16> @llvm.umax.v16i16(<16 x i16>, <16 x i16>)
declare <8 x i32> @llvm.umax.v8i32(<8 x i32>, <8 x i32>)
declare <4 x i64> @llvm.umax.v4i64(<4 x i64>, <4 x i64>)

declare <32 x i8> @llvm.umin.v32i8(<32 x i8>, <32 x i8>)
declare <16 x i16> @llvm.umin.v16i16(<16 x i16>, <16 x i16>)
declare <8 x i32> @llvm.umin.v8i32(<8 x i32>, <8 x i32>)
declare <4 x i64> @llvm.umin.v4i64(<4 x i64>, <4 x i64>)
