; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=aarch64-unknown-linux-gnu -global-isel=0 %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc -mtriple=aarch64-unknown-linux-gnu -global-isel=1 %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-GI

define fp128 @fabs_f128(fp128 %a) {
; CHECK-SD-LABEL: fabs_f128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    str q0, [sp, #-16]!
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    ldrb w8, [sp, #15]
; CHECK-SD-NEXT:    and w8, w8, #0x7f
; CHECK-SD-NEXT:    strb w8, [sp, #15]
; CHECK-SD-NEXT:    ldr q0, [sp], #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fabs_f128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov x8, v0.d[1]
; CHECK-GI-NEXT:    mov v0.d[0], v0.d[0]
; CHECK-GI-NEXT:    and x8, x8, #0x7fffffffffffffff
; CHECK-GI-NEXT:    mov v0.d[1], x8
; CHECK-GI-NEXT:    ret
entry:
  %c = call fp128 @llvm.fabs.f128(fp128 %a)
  ret fp128 %c
}

define <1 x fp128> @fabs_v1f128(<1 x fp128> %a) {
; CHECK-SD-LABEL: fabs_v1f128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    str q0, [sp, #-16]!
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    ldrb w8, [sp, #15]
; CHECK-SD-NEXT:    and w8, w8, #0x7f
; CHECK-SD-NEXT:    strb w8, [sp, #15]
; CHECK-SD-NEXT:    ldr q0, [sp], #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fabs_v1f128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov x8, v0.d[1]
; CHECK-GI-NEXT:    mov v0.d[0], v0.d[0]
; CHECK-GI-NEXT:    and x8, x8, #0x7fffffffffffffff
; CHECK-GI-NEXT:    mov v0.d[1], x8
; CHECK-GI-NEXT:    ret
entry:
  %c = call <1 x fp128> @llvm.fabs.v1f128(<1 x fp128> %a)
  ret <1 x fp128> %c
}

define <2 x fp128> @fabs_v2f128(<2 x fp128> %a) {
; CHECK-SD-LABEL: fabs_v2f128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    stp q0, q1, [sp, #-32]!
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    ldrb w8, [sp, #15]
; CHECK-SD-NEXT:    and w8, w8, #0x7f
; CHECK-SD-NEXT:    strb w8, [sp, #15]
; CHECK-SD-NEXT:    ldrb w8, [sp, #31]
; CHECK-SD-NEXT:    and w8, w8, #0x7f
; CHECK-SD-NEXT:    strb w8, [sp, #31]
; CHECK-SD-NEXT:    ldp q0, q1, [sp], #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fabs_v2f128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov x8, v0.d[1]
; CHECK-GI-NEXT:    mov x9, v1.d[1]
; CHECK-GI-NEXT:    mov v0.d[0], v0.d[0]
; CHECK-GI-NEXT:    mov v1.d[0], v1.d[0]
; CHECK-GI-NEXT:    and x8, x8, #0x7fffffffffffffff
; CHECK-GI-NEXT:    and x9, x9, #0x7fffffffffffffff
; CHECK-GI-NEXT:    mov v0.d[1], x8
; CHECK-GI-NEXT:    mov v1.d[1], x9
; CHECK-GI-NEXT:    ret
entry:
  %c = call <2 x fp128> @llvm.fabs.v2f128(<2 x fp128> %a)
  ret <2 x fp128> %c
}

define <3 x fp128> @fabs_v3f128(<3 x fp128> %a) {
; CHECK-SD-LABEL: fabs_v3f128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    stp q0, q1, [sp, #-48]!
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    ldrb w8, [sp, #15]
; CHECK-SD-NEXT:    str q2, [sp, #32]
; CHECK-SD-NEXT:    and w8, w8, #0x7f
; CHECK-SD-NEXT:    strb w8, [sp, #15]
; CHECK-SD-NEXT:    ldrb w8, [sp, #31]
; CHECK-SD-NEXT:    and w8, w8, #0x7f
; CHECK-SD-NEXT:    strb w8, [sp, #31]
; CHECK-SD-NEXT:    ldrb w8, [sp, #47]
; CHECK-SD-NEXT:    ldp q0, q1, [sp]
; CHECK-SD-NEXT:    and w8, w8, #0x7f
; CHECK-SD-NEXT:    strb w8, [sp, #47]
; CHECK-SD-NEXT:    ldr q2, [sp, #32]
; CHECK-SD-NEXT:    add sp, sp, #48
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fabs_v3f128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov x8, v0.d[1]
; CHECK-GI-NEXT:    mov x9, v1.d[1]
; CHECK-GI-NEXT:    mov x10, v2.d[1]
; CHECK-GI-NEXT:    mov v0.d[0], v0.d[0]
; CHECK-GI-NEXT:    mov v1.d[0], v1.d[0]
; CHECK-GI-NEXT:    mov v2.d[0], v2.d[0]
; CHECK-GI-NEXT:    and x8, x8, #0x7fffffffffffffff
; CHECK-GI-NEXT:    and x9, x9, #0x7fffffffffffffff
; CHECK-GI-NEXT:    and x10, x10, #0x7fffffffffffffff
; CHECK-GI-NEXT:    mov v0.d[1], x8
; CHECK-GI-NEXT:    mov v1.d[1], x9
; CHECK-GI-NEXT:    mov v2.d[1], x10
; CHECK-GI-NEXT:    ret
entry:
  %c = call <3 x fp128> @llvm.fabs.v3f128(<3 x fp128> %a)
  ret <3 x fp128> %c
}

define <4 x fp128> @fabs_v4f128(<4 x fp128> %a) {
; CHECK-SD-LABEL: fabs_v4f128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    stp q0, q1, [sp, #-64]!
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 64
; CHECK-SD-NEXT:    ldrb w8, [sp, #15]
; CHECK-SD-NEXT:    stp q2, q3, [sp, #32]
; CHECK-SD-NEXT:    and w8, w8, #0x7f
; CHECK-SD-NEXT:    strb w8, [sp, #15]
; CHECK-SD-NEXT:    ldrb w8, [sp, #31]
; CHECK-SD-NEXT:    and w8, w8, #0x7f
; CHECK-SD-NEXT:    strb w8, [sp, #31]
; CHECK-SD-NEXT:    ldrb w8, [sp, #47]
; CHECK-SD-NEXT:    ldp q0, q1, [sp]
; CHECK-SD-NEXT:    and w8, w8, #0x7f
; CHECK-SD-NEXT:    strb w8, [sp, #47]
; CHECK-SD-NEXT:    ldrb w8, [sp, #63]
; CHECK-SD-NEXT:    and w8, w8, #0x7f
; CHECK-SD-NEXT:    strb w8, [sp, #63]
; CHECK-SD-NEXT:    ldp q2, q3, [sp, #32]
; CHECK-SD-NEXT:    add sp, sp, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fabs_v4f128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov x8, v0.d[1]
; CHECK-GI-NEXT:    mov v7.d[0], v0.d[0]
; CHECK-GI-NEXT:    mov x9, v1.d[1]
; CHECK-GI-NEXT:    mov x10, v2.d[1]
; CHECK-GI-NEXT:    mov x11, v3.d[1]
; CHECK-GI-NEXT:    mov v1.d[0], v1.d[0]
; CHECK-GI-NEXT:    mov v2.d[0], v2.d[0]
; CHECK-GI-NEXT:    mov v3.d[0], v3.d[0]
; CHECK-GI-NEXT:    and x8, x8, #0x7fffffffffffffff
; CHECK-GI-NEXT:    mov v7.d[1], x8
; CHECK-GI-NEXT:    and x8, x9, #0x7fffffffffffffff
; CHECK-GI-NEXT:    and x9, x10, #0x7fffffffffffffff
; CHECK-GI-NEXT:    and x10, x11, #0x7fffffffffffffff
; CHECK-GI-NEXT:    mov v1.d[1], x8
; CHECK-GI-NEXT:    mov v2.d[1], x9
; CHECK-GI-NEXT:    mov v3.d[1], x10
; CHECK-GI-NEXT:    mov v0.16b, v7.16b
; CHECK-GI-NEXT:    ret
entry:
  %c = call <4 x fp128> @llvm.fabs.v4f128(<4 x fp128> %a)
  ret <4 x fp128> %c
}

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
