; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --filter-out "(?!^\s*stl.*\bsp\b)^\s*.*\bsp\b" --filter "^\s*(ld[^r]|st|swp|cas|bl|add|and|eor|orn|orr|sub|mvn|sxt|cmp|ccmp|csel|dmb)"
; RUN: llc %s -o - -verify-machineinstrs -mtriple=aarch64 -mattr=+v8.4a -mattr=+rcpc-immo -global-isel=true -global-isel-abort=2 -O0 | FileCheck %s --check-prefixes=CHECK,GISEL
; RUN: llc %s -o - -verify-machineinstrs -mtriple=aarch64 -mattr=+v8.4a -mattr=+rcpc-immo -global-isel=false -O1 | FileCheck %s --check-prefixes=CHECK,SDAG

define void @store_atomic_i8_aligned_unordered(i8 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i8_aligned_unordered:
; CHECK:    strb w0, [x1, #4]
    %gep = getelementptr inbounds i8, ptr %ptr, i32 4
    store atomic i8 %value, ptr %gep unordered, align 1
    ret void
}

define void @store_atomic_i8_aligned_monotonic(i8 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i8_aligned_monotonic:
; CHECK:    strb w0, [x1, #4]
    %gep = getelementptr inbounds i8, ptr %ptr, i32 4
    store atomic i8 %value, ptr %gep monotonic, align 1
    ret void
}

define void @store_atomic_i8_aligned_release(i8 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i8_aligned_release:
; CHECK:    stlurb w0, [x1, #4]
    %gep = getelementptr inbounds i8, ptr %ptr, i32 4
    store atomic i8 %value, ptr %gep release, align 1
    ret void
}

define void @store_atomic_i8_aligned_seq_cst(i8 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i8_aligned_seq_cst:
; CHECK:    stlurb w0, [x1, #4]
    %gep = getelementptr inbounds i8, ptr %ptr, i32 4
    store atomic i8 %value, ptr %gep seq_cst, align 1
    ret void
}

define void @store_atomic_i16_aligned_unordered(i16 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i16_aligned_unordered:
; CHECK:    strh w0, [x1, #8]
    %gep = getelementptr inbounds i16, ptr %ptr, i32 4
    store atomic i16 %value, ptr %gep unordered, align 2
    ret void
}

define void @store_atomic_i16_aligned_monotonic(i16 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i16_aligned_monotonic:
; CHECK:    strh w0, [x1, #8]
    %gep = getelementptr inbounds i16, ptr %ptr, i32 4
    store atomic i16 %value, ptr %gep monotonic, align 2
    ret void
}

define void @store_atomic_i16_aligned_release(i16 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i16_aligned_release:
; CHECK:    stlurh w0, [x1, #8]
    %gep = getelementptr inbounds i16, ptr %ptr, i32 4
    store atomic i16 %value, ptr %gep release, align 2
    ret void
}

define void @store_atomic_i16_aligned_seq_cst(i16 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i16_aligned_seq_cst:
; CHECK:    stlurh w0, [x1, #8]
    %gep = getelementptr inbounds i16, ptr %ptr, i32 4
    store atomic i16 %value, ptr %gep seq_cst, align 2
    ret void
}

define void @store_atomic_i32_aligned_unordered(i32 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i32_aligned_unordered:
; CHECK:    str w0, [x1, #16]
    %gep = getelementptr inbounds i32, ptr %ptr, i32 4
    store atomic i32 %value, ptr %gep unordered, align 4
    ret void
}

define void @store_atomic_i32_aligned_monotonic(i32 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i32_aligned_monotonic:
; CHECK:    str w0, [x1, #16]
    %gep = getelementptr inbounds i32, ptr %ptr, i32 4
    store atomic i32 %value, ptr %gep monotonic, align 4
    ret void
}

define void @store_atomic_i32_aligned_release(i32 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i32_aligned_release:
; CHECK:    stlur w0, [x1, #16]
    %gep = getelementptr inbounds i32, ptr %ptr, i32 4
    store atomic i32 %value, ptr %gep release, align 4
    ret void
}

define void @store_atomic_i32_aligned_seq_cst(i32 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i32_aligned_seq_cst:
; CHECK:    stlur w0, [x1, #16]
    %gep = getelementptr inbounds i32, ptr %ptr, i32 4
    store atomic i32 %value, ptr %gep seq_cst, align 4
    ret void
}

define void @store_atomic_i64_aligned_unordered(i64 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i64_aligned_unordered:
; CHECK:    str x0, [x1, #32]
    %gep = getelementptr inbounds i64, ptr %ptr, i32 4
    store atomic i64 %value, ptr %gep unordered, align 8
    ret void
}

define void @store_atomic_i64_aligned_monotonic(i64 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i64_aligned_monotonic:
; CHECK:    str x0, [x1, #32]
    %gep = getelementptr inbounds i64, ptr %ptr, i32 4
    store atomic i64 %value, ptr %gep monotonic, align 8
    ret void
}

define void @store_atomic_i64_aligned_release(i64 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i64_aligned_release:
; CHECK:    stlur x0, [x1, #32]
    %gep = getelementptr inbounds i64, ptr %ptr, i32 4
    store atomic i64 %value, ptr %gep release, align 8
    ret void
}

define void @store_atomic_i64_aligned_seq_cst(i64 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i64_aligned_seq_cst:
; CHECK:    stlur x0, [x1, #32]
    %gep = getelementptr inbounds i64, ptr %ptr, i32 4
    store atomic i64 %value, ptr %gep seq_cst, align 8
    ret void
}

define void @store_atomic_i128_aligned_unordered(i128 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i128_aligned_unordered:
; CHECK:    stp x0, x1, [x2, #64]
    %gep = getelementptr inbounds i128, ptr %ptr, i32 4
    store atomic i128 %value, ptr %gep unordered, align 16
    ret void
}

define void @store_atomic_i128_aligned_monotonic(i128 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i128_aligned_monotonic:
; CHECK:    stp x0, x1, [x2, #64]
    %gep = getelementptr inbounds i128, ptr %ptr, i32 4
    store atomic i128 %value, ptr %gep monotonic, align 16
    ret void
}

define void @store_atomic_i128_aligned_release(i128 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i128_aligned_release:
; CHECK:    dmb ish
; CHECK:    stp x0, x1, [x2, #64]
    %gep = getelementptr inbounds i128, ptr %ptr, i32 4
    store atomic i128 %value, ptr %gep release, align 16
    ret void
}

define void @store_atomic_i128_aligned_seq_cst(i128 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i128_aligned_seq_cst:
; CHECK:    dmb ish
; CHECK:    stp x0, x1, [x2, #64]
; CHECK:    dmb ish
    %gep = getelementptr inbounds i128, ptr %ptr, i32 4
    store atomic i128 %value, ptr %gep seq_cst, align 16
    ret void
}

define void @store_atomic_i8_unaligned_unordered(i8 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i8_unaligned_unordered:
; CHECK:    strb w0, [x1, #4]
    %gep = getelementptr inbounds i8, ptr %ptr, i32 4
    store atomic i8 %value, ptr %gep unordered, align 1
    ret void
}

define void @store_atomic_i8_unaligned_monotonic(i8 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i8_unaligned_monotonic:
; CHECK:    strb w0, [x1, #4]
    %gep = getelementptr inbounds i8, ptr %ptr, i32 4
    store atomic i8 %value, ptr %gep monotonic, align 1
    ret void
}

define void @store_atomic_i8_unaligned_release(i8 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i8_unaligned_release:
; CHECK:    stlurb w0, [x1, #4]
    %gep = getelementptr inbounds i8, ptr %ptr, i32 4
    store atomic i8 %value, ptr %gep release, align 1
    ret void
}

define void @store_atomic_i8_unaligned_seq_cst(i8 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i8_unaligned_seq_cst:
; CHECK:    stlurb w0, [x1, #4]
    %gep = getelementptr inbounds i8, ptr %ptr, i32 4
    store atomic i8 %value, ptr %gep seq_cst, align 1
    ret void
}

define void @store_atomic_i16_unaligned_unordered(i16 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i16_unaligned_unordered:
; CHECK:    add x1, x1, #8
; CHECK:    bl __atomic_store
    %gep = getelementptr inbounds i16, ptr %ptr, i32 4
    store atomic i16 %value, ptr %gep unordered, align 1
    ret void
}

define void @store_atomic_i16_unaligned_monotonic(i16 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i16_unaligned_monotonic:
; CHECK:    add x1, x1, #8
; CHECK:    bl __atomic_store
    %gep = getelementptr inbounds i16, ptr %ptr, i32 4
    store atomic i16 %value, ptr %gep monotonic, align 1
    ret void
}

define void @store_atomic_i16_unaligned_release(i16 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i16_unaligned_release:
; CHECK:    add x1, x1, #8
; CHECK:    bl __atomic_store
    %gep = getelementptr inbounds i16, ptr %ptr, i32 4
    store atomic i16 %value, ptr %gep release, align 1
    ret void
}

define void @store_atomic_i16_unaligned_seq_cst(i16 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i16_unaligned_seq_cst:
; CHECK:    add x1, x1, #8
; CHECK:    bl __atomic_store
    %gep = getelementptr inbounds i16, ptr %ptr, i32 4
    store atomic i16 %value, ptr %gep seq_cst, align 1
    ret void
}

define void @store_atomic_i32_unaligned_unordered(i32 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i32_unaligned_unordered:
; CHECK:    add x1, x1, #16
; CHECK:    bl __atomic_store
    %gep = getelementptr inbounds i32, ptr %ptr, i32 4
    store atomic i32 %value, ptr %gep unordered, align 1
    ret void
}

define void @store_atomic_i32_unaligned_monotonic(i32 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i32_unaligned_monotonic:
; CHECK:    add x1, x1, #16
; CHECK:    bl __atomic_store
    %gep = getelementptr inbounds i32, ptr %ptr, i32 4
    store atomic i32 %value, ptr %gep monotonic, align 1
    ret void
}

define void @store_atomic_i32_unaligned_release(i32 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i32_unaligned_release:
; CHECK:    add x1, x1, #16
; CHECK:    bl __atomic_store
    %gep = getelementptr inbounds i32, ptr %ptr, i32 4
    store atomic i32 %value, ptr %gep release, align 1
    ret void
}

define void @store_atomic_i32_unaligned_seq_cst(i32 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i32_unaligned_seq_cst:
; CHECK:    add x1, x1, #16
; CHECK:    bl __atomic_store
    %gep = getelementptr inbounds i32, ptr %ptr, i32 4
    store atomic i32 %value, ptr %gep seq_cst, align 1
    ret void
}

define void @store_atomic_i64_unaligned_unordered(i64 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i64_unaligned_unordered:
; CHECK:    add x1, x1, #32
; CHECK:    bl __atomic_store
    %gep = getelementptr inbounds i64, ptr %ptr, i32 4
    store atomic i64 %value, ptr %gep unordered, align 1
    ret void
}

define void @store_atomic_i64_unaligned_monotonic(i64 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i64_unaligned_monotonic:
; CHECK:    add x1, x1, #32
; CHECK:    bl __atomic_store
    %gep = getelementptr inbounds i64, ptr %ptr, i32 4
    store atomic i64 %value, ptr %gep monotonic, align 1
    ret void
}

define void @store_atomic_i64_unaligned_release(i64 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i64_unaligned_release:
; CHECK:    add x1, x1, #32
; CHECK:    bl __atomic_store
    %gep = getelementptr inbounds i64, ptr %ptr, i32 4
    store atomic i64 %value, ptr %gep release, align 1
    ret void
}

define void @store_atomic_i64_unaligned_seq_cst(i64 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i64_unaligned_seq_cst:
; CHECK:    add x1, x1, #32
; CHECK:    bl __atomic_store
    %gep = getelementptr inbounds i64, ptr %ptr, i32 4
    store atomic i64 %value, ptr %gep seq_cst, align 1
    ret void
}

define void @store_atomic_i128_unaligned_unordered(i128 %value, ptr %ptr) {
; GISEL-LABEL: store_atomic_i128_unaligned_unordered:
; GISEL:    add x1, x8, #64
; GISEL:    bl __atomic_store
;
; SDAG-LABEL: store_atomic_i128_unaligned_unordered:
; SDAG:    add x1, x2, #64
; SDAG:    bl __atomic_store
    %gep = getelementptr inbounds i128, ptr %ptr, i32 4
    store atomic i128 %value, ptr %gep unordered, align 1
    ret void
}

define void @store_atomic_i128_unaligned_monotonic(i128 %value, ptr %ptr) {
; GISEL-LABEL: store_atomic_i128_unaligned_monotonic:
; GISEL:    add x1, x8, #64
; GISEL:    bl __atomic_store
;
; SDAG-LABEL: store_atomic_i128_unaligned_monotonic:
; SDAG:    add x1, x2, #64
; SDAG:    bl __atomic_store
    %gep = getelementptr inbounds i128, ptr %ptr, i32 4
    store atomic i128 %value, ptr %gep monotonic, align 1
    ret void
}

define void @store_atomic_i128_unaligned_release(i128 %value, ptr %ptr) {
; GISEL-LABEL: store_atomic_i128_unaligned_release:
; GISEL:    add x1, x8, #64
; GISEL:    bl __atomic_store
;
; SDAG-LABEL: store_atomic_i128_unaligned_release:
; SDAG:    add x1, x2, #64
; SDAG:    bl __atomic_store
    %gep = getelementptr inbounds i128, ptr %ptr, i32 4
    store atomic i128 %value, ptr %gep release, align 1
    ret void
}

define void @store_atomic_i128_unaligned_seq_cst(i128 %value, ptr %ptr) {
; GISEL-LABEL: store_atomic_i128_unaligned_seq_cst:
; GISEL:    add x1, x8, #64
; GISEL:    bl __atomic_store
;
; SDAG-LABEL: store_atomic_i128_unaligned_seq_cst:
; SDAG:    add x1, x2, #64
; SDAG:    bl __atomic_store
    %gep = getelementptr inbounds i128, ptr %ptr, i32 4
    store atomic i128 %value, ptr %gep seq_cst, align 1
    ret void
}

; TODO: missed opportunity to emit a stlurb w/ GISel
define void @store_atomic_i8_from_gep() {
; GISEL-LABEL: store_atomic_i8_from_gep:
; GISEL:    bl init
; GISEL:    add x9, x8, #1
; GISEL:    stlrb w8, [x9]
;
; SDAG-LABEL: store_atomic_i8_from_gep:
; SDAG:    bl init
; SDAG:    stlurb wzr, [sp, #13]
  %a = alloca [3 x i8]
  call void @init(ptr %a)
  %arrayidx  = getelementptr [3 x i8], ptr %a, i64 0, i64 1
  store atomic i8 0, ptr %arrayidx release, align 8
  ret void
}

; TODO: missed opportunity to emit a stlurh w/ GISel
define void @store_atomic_i16_from_gep() {
; GISEL-LABEL: store_atomic_i16_from_gep:
; GISEL:    bl init
; GISEL:    add x9, x8, #2
; GISEL:    stlrh w8, [x9]
;
; SDAG-LABEL: store_atomic_i16_from_gep:
; SDAG:    bl init
; SDAG:    stlurh wzr, [sp, #10]
  %a = alloca [3 x i16]
  call void @init(ptr %a)
  %arrayidx  = getelementptr [3 x i16], ptr %a, i64 0, i64 1
  store atomic i16 0, ptr %arrayidx release, align 8
  ret void
}

define void @store_atomic_i32_from_gep() {
; GISEL-LABEL: store_atomic_i32_from_gep:
; GISEL:    bl init
; GISEL:    stlur w8, [x9, #4]
;
; SDAG-LABEL: store_atomic_i32_from_gep:
; SDAG:    bl init
; SDAG:    stlur wzr, [sp, #8]
  %a = alloca [3 x i32]
  call void @init(ptr %a)
  %arrayidx  = getelementptr [3 x i32], ptr %a, i64 0, i64 1
  store atomic i32 0, ptr %arrayidx release, align 8
  ret void
}

define void @store_atomic_i64_from_gep() {
; GISEL-LABEL: store_atomic_i64_from_gep:
; GISEL:    bl init
; GISEL:    stlur x8, [x9, #8]
;
; SDAG-LABEL: store_atomic_i64_from_gep:
; SDAG:    bl init
; SDAG:    stlur xzr, [sp, #16]
  %a = alloca [3 x i64]
  call void @init(ptr %a)
  %arrayidx  = getelementptr [3 x i64], ptr %a, i64 0, i64 1
  store atomic i64 0, ptr %arrayidx release, align 8
  ret void
}

define void @store_atomic_i128_from_gep() {
; GISEL-LABEL: store_atomic_i128_from_gep:
; GISEL:    bl init
; GISEL:    dmb ish
; GISEL:    stp x8, x8, [x9, #16]
;
; SDAG-LABEL: store_atomic_i128_from_gep:
; SDAG:    bl init
; SDAG:    dmb ish
; SDAG:    stp xzr, xzr, [sp, #16]
  %a = alloca [3 x i128]
  call void @init(ptr %a)
  %arrayidx  = getelementptr [3 x i128], ptr %a, i64 0, i64 1
  store atomic i128 0, ptr %arrayidx release, align 16
  ret void
}

declare void @init(ptr)
