; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 2
; RUN: opt < %s -disable-output "-passes=print<scalar-evolution>" 2>&1 | FileCheck %s

define i64 @test00(i64 %a) {
; CHECK-LABEL: 'test00'
; CHECK-NEXT:  Classifying expressions for: @test00
; CHECK-NEXT:    %add = shl i64 %a, 10
; CHECK-NEXT:    --> (1024 * %a) U: [0,-1023) S: [-9223372036854775808,9223372036854774785)
; CHECK-NEXT:    %shl = add i64 %add, 256
; CHECK-NEXT:    --> (256 + (1024 * %a))<nuw><nsw> U: [256,-767) S: [-9223372036854775552,9223372036854775041)
; CHECK-NEXT:    %ashr = ashr exact i64 %shl, 8
; CHECK-NEXT:    --> (1 + (sext i56 (4 * (trunc i64 %a to i56)) to i64))<nuw><nsw> U: [1,-2) S: [-36028797018963967,36028797018963966)
; CHECK-NEXT:  Determining loop execution counts for: @test00
;
  %add = shl i64 %a, 10
  %shl = add i64 %add, 256
  %ashr = ashr exact i64 %shl, 8
  ret i64 %ashr
}

define i64 @test01(i64 %a) {
; CHECK-LABEL: 'test01'
; CHECK-NEXT:  Classifying expressions for: @test01
; CHECK-NEXT:    %add = shl i64 %a, 6
; CHECK-NEXT:    --> (64 * %a) U: [0,-63) S: [-9223372036854775808,9223372036854775745)
; CHECK-NEXT:    %shl = add i64 %add, 256
; CHECK-NEXT:    --> (256 + (64 * %a)) U: [0,-63) S: [-9223372036854775808,9223372036854775745)
; CHECK-NEXT:    %ashr = ashr exact i64 %shl, 8
; CHECK-NEXT:    --> %ashr U: [-36028797018963968,36028797018963968) S: [-36028797018963968,36028797018963968)
; CHECK-NEXT:  Determining loop execution counts for: @test01
;
  %add = shl i64 %a, 6
  %shl = add i64 %add, 256
  %ashr = ashr exact i64 %shl, 8
  ret i64 %ashr
}

define i64 @test02(i64 %a) {
; CHECK-LABEL: 'test02'
; CHECK-NEXT:  Classifying expressions for: @test02
; CHECK-NEXT:    %add = shl i64 %a, 12
; CHECK-NEXT:    --> (4096 * %a) U: [0,-4095) S: [-9223372036854775808,9223372036854771713)
; CHECK-NEXT:    %shl = add i64 %add, 4096
; CHECK-NEXT:    --> (4096 + (4096 * %a)) U: [0,-4095) S: [-9223372036854775808,9223372036854771713)
; CHECK-NEXT:    %ashr = ashr exact i64 %shl, 8
; CHECK-NEXT:    --> (sext i56 (16 + (16 * (trunc i64 %a to i56))) to i64) U: [0,-15) S: [-36028797018963968,36028797018963953)
; CHECK-NEXT:  Determining loop execution counts for: @test02
;
  %add = shl i64 %a, 12
  %shl = add i64 %add, 4096
  %ashr = ashr exact i64 %shl, 8
  ret i64 %ashr
}
