; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 5
; RUN: opt -disable-output -passes="print<scalar-evolution>" < %s 2>&1 | FileCheck %s

define void @infer.sext.0(ptr %c, i32 %start, ptr %buf) {
; CHECK-LABEL: 'infer.sext.0'
; CHECK-NEXT:  Classifying expressions for: @infer.sext.0
; CHECK-NEXT:    %counter = phi i32 [ 0, %entry ], [ %counter.inc, %loop ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%loop> U: [0,2) S: [0,2) Exits: 1 LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %idx = phi i32 [ %start, %entry ], [ %idx.inc, %loop ]
; CHECK-NEXT:    --> {%start,+,1}<nsw><%loop> U: full-set S: full-set Exits: (1 + %start) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %idx.inc = add nsw i32 %idx, 1
; CHECK-NEXT:    --> {(1 + %start)<nsw>,+,1}<nsw><%loop> U: full-set S: full-set Exits: (2 + %start) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %idx.inc.sext = sext i32 %idx.inc to i64
; CHECK-NEXT:    --> {(1 + (sext i32 %start to i64))<nsw>,+,1}<nsw><%loop> U: [-2147483647,2147483650) S: [-2147483647,2147483650) Exits: (2 + (sext i32 %start to i64))<nsw> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %buf.gep = getelementptr inbounds i32, ptr %buf, i32 %idx.inc
; CHECK-NEXT:    --> {(4 + (4 * (sext i32 %start to i64))<nsw> + %buf),+,4}<nw><%loop> U: full-set S: full-set Exits: (8 + (4 * (sext i32 %start to i64))<nsw> + %buf) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %val = load i32, ptr %buf.gep, align 4
; CHECK-NEXT:    --> %val U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %counter.inc = add i32 %counter, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%loop> U: [1,3) S: [1,3) Exits: 2 LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @infer.sext.0
; CHECK-NEXT:  Loop %loop: backedge-taken count is i32 1
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 1
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is i32 1
; CHECK-NEXT:  Loop %loop: Trip multiple is 2
;
 entry:
  br label %loop

 loop:
  %counter = phi i32 [ 0, %entry ], [ %counter.inc, %loop ]
  %idx = phi i32 [ %start, %entry ], [ %idx.inc, %loop ]
  %idx.inc = add nsw i32 %idx, 1
  %idx.inc.sext = sext i32 %idx.inc to i64

  %buf.gep = getelementptr inbounds i32, ptr %buf, i32 %idx.inc
  %val = load i32, ptr %buf.gep

  %condition = icmp eq i32 %counter, 1
  %counter.inc = add i32 %counter, 1
  br i1 %condition, label %exit, label %loop

 exit:
  ret void
}

define void @infer.zext.0(ptr %c, i32 %start, ptr %buf) {
; CHECK-LABEL: 'infer.zext.0'
; CHECK-NEXT:  Classifying expressions for: @infer.zext.0
; CHECK-NEXT:    %counter = phi i32 [ 0, %entry ], [ %counter.inc, %loop ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%loop> U: [0,2) S: [0,2) Exits: 1 LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %idx = phi i32 [ %start, %entry ], [ %idx.inc, %loop ]
; CHECK-NEXT:    --> {%start,+,1}<nuw><%loop> U: full-set S: full-set Exits: (1 + %start) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %idx.inc = add nuw i32 %idx, 1
; CHECK-NEXT:    --> {(1 + %start)<nuw>,+,1}<nuw><%loop> U: [1,0) S: [1,0) Exits: (2 + %start) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %idx.inc.sext = zext i32 %idx.inc to i64
; CHECK-NEXT:    --> {(1 + (zext i32 %start to i64))<nuw><nsw>,+,1}<nuw><%loop> U: [1,4294967298) S: [1,4294967298) Exits: (2 + (zext i32 %start to i64))<nuw><nsw> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %buf.gep = getelementptr inbounds i32, ptr %buf, i32 %idx.inc
; CHECK-NEXT:    --> ((4 * (sext i32 {(1 + %start)<nuw>,+,1}<nuw><%loop> to i64))<nsw> + %buf) U: full-set S: full-set Exits: ((4 * (sext i32 (2 + %start) to i64))<nsw> + %buf) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %val = load i32, ptr %buf.gep, align 4
; CHECK-NEXT:    --> %val U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %counter.inc = add i32 %counter, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%loop> U: [1,3) S: [1,3) Exits: 2 LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @infer.zext.0
; CHECK-NEXT:  Loop %loop: backedge-taken count is i32 1
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 1
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is i32 1
; CHECK-NEXT:  Loop %loop: Trip multiple is 2
;
 entry:
  br label %loop

 loop:
  %counter = phi i32 [ 0, %entry ], [ %counter.inc, %loop ]
  %idx = phi i32 [ %start, %entry ], [ %idx.inc, %loop ]
  %idx.inc = add nuw i32 %idx, 1
  %idx.inc.sext = zext i32 %idx.inc to i64

  %buf.gep = getelementptr inbounds i32, ptr %buf, i32 %idx.inc
  %val = load i32, ptr %buf.gep

  %condition = icmp eq i32 %counter, 1
  %counter.inc = add i32 %counter, 1
  br i1 %condition, label %exit, label %loop

 exit:
  ret void
}

define void @infer.sext.1(i32 %start, ptr %c) {
; CHECK-LABEL: 'infer.sext.1'
; CHECK-NEXT:  Classifying expressions for: @infer.sext.1
; CHECK-NEXT:    %start.mul = mul i32 %start, 4
; CHECK-NEXT:    --> (4 * %start) U: [0,-3) S: [-2147483648,2147483645)
; CHECK-NEXT:    %start.real = add i32 %start.mul, 2
; CHECK-NEXT:    --> (2 + (4 * %start))<nuw><nsw> U: [2,-1) S: [-2147483646,2147483647)
; CHECK-NEXT:    %idx = phi i32 [ %start.real, %entry ], [ %idx.inc, %loop ]
; CHECK-NEXT:    --> {(2 + (4 * %start))<nuw><nsw>,+,2}<nsw><%loop> U: [0,-1) S: [-2147483646,2147483647) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %idx.sext = sext i32 %idx to i64
; CHECK-NEXT:    --> {(2 + (sext i32 (4 * %start) to i64))<nuw><nsw>,+,2}<nsw><%loop> U: [0,-1) S: [-2147483646,9223372036854775807) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %idx.inc = add nsw i32 %idx, 2
; CHECK-NEXT:    --> {(4 + (4 * %start)),+,2}<nw><%loop> U: [0,-1) S: [-2147483648,2147483647) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %condition = load i1, ptr %c, align 1
; CHECK-NEXT:    --> %condition U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @infer.sext.1
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
 entry:
  %start.mul = mul i32 %start, 4
  %start.real = add i32 %start.mul, 2
  br label %loop

 loop:
  %idx = phi i32 [ %start.real, %entry ], [ %idx.inc, %loop ]
  %idx.sext = sext i32 %idx to i64
  %idx.inc = add nsw i32 %idx, 2
  %condition = load i1, ptr %c
  br i1 %condition, label %exit, label %loop

 exit:
  ret void
}

define void @infer.sext.2(ptr %c, i8 %start) {
; CHECK-LABEL: 'infer.sext.2'
; CHECK-NEXT:  Classifying expressions for: @infer.sext.2
; CHECK-NEXT:    %start.inc = add i8 %start, 1
; CHECK-NEXT:    --> (1 + %start) U: full-set S: full-set
; CHECK-NEXT:    %idx = phi i8 [ %start.inc, %entry ], [ %idx.inc, %loop ]
; CHECK-NEXT:    --> {(1 + %start),+,1}<nsw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %idx.sext = sext i8 %idx to i16
; CHECK-NEXT:    --> {(1 + (sext i8 %start to i16))<nsw>,+,1}<nsw><%loop> U: [-127,-32768) S: [-127,-32768) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %idx.inc = add nsw i8 %idx, 1
; CHECK-NEXT:    --> {(2 + %start),+,1}<nw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %condition = load volatile i1, ptr %c, align 1
; CHECK-NEXT:    --> %condition U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @infer.sext.2
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
 entry:
  %start.inc = add i8 %start, 1
  %entry.condition = icmp slt i8 %start, 127
  br i1 %entry.condition, label %loop, label %exit

 loop:
  %idx = phi i8 [ %start.inc, %entry ], [ %idx.inc, %loop ]
  %idx.sext = sext i8 %idx to i16
  %idx.inc = add nsw i8 %idx, 1
  %condition = load volatile i1, ptr %c
  br i1 %condition, label %exit, label %loop

 exit:
  ret void
}

define void @infer.zext.1(ptr %c, i8 %start) {
; CHECK-LABEL: 'infer.zext.1'
; CHECK-NEXT:  Classifying expressions for: @infer.zext.1
; CHECK-NEXT:    %start.inc = add i8 %start, 1
; CHECK-NEXT:    --> (1 + %start) U: full-set S: full-set
; CHECK-NEXT:    %idx = phi i8 [ %start.inc, %entry ], [ %idx.inc, %loop ]
; CHECK-NEXT:    --> {(1 + %start),+,1}<nuw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %idx.zext = zext i8 %idx to i16
; CHECK-NEXT:    --> {(1 + (zext i8 %start to i16))<nuw><nsw>,+,1}<nuw><%loop> U: [1,0) S: [1,0) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %idx.inc = add nuw i8 %idx, 1
; CHECK-NEXT:    --> {(2 + %start),+,1}<nw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %condition = load volatile i1, ptr %c, align 1
; CHECK-NEXT:    --> %condition U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @infer.zext.1
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
 entry:
  %start.inc = add i8 %start, 1
  %entry.condition = icmp ult i8 %start, 255
  br i1 %entry.condition, label %loop, label %exit

 loop:
  %idx = phi i8 [ %start.inc, %entry ], [ %idx.inc, %loop ]
  %idx.zext = zext i8 %idx to i16
  %idx.inc = add nuw i8 %idx, 1
  %condition = load volatile i1, ptr %c
  br i1 %condition, label %exit, label %loop

 exit:
  ret void
}
