; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+ssse3 | FileCheck %s --check-prefixes=SSE,SSSE3
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE,SSE42
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512,AVX512F
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512,AVX512BW
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+avx512f,+avx512dq | FileCheck %s --check-prefixes=AVX512,AVX512DQ
;
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mcpu=slm | FileCheck %s --check-prefixes=SSE,SLM
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mcpu=goldmont | FileCheck %s --check-prefixes=SSE,GLM
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mcpu=btver2 | FileCheck %s --check-prefixes=AVX,AVX1

define i32 @add(i32 %arg) {
; SSSE3-LABEL: 'add'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = add i64 undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = add <2 x i64> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:4 for: %V4I64 = add <4 x i64> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:8 for: %V8I64 = add <8 x i64> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = add i32 undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = add <4 x i32> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8I32 = add <8 x i32> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V16I32 = add <16 x i32> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = add i16 undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = add <8 x i16> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16I16 = add <16 x i16> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V32I16 = add <32 x i16> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = add i8 undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = add <16 x i8> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V32I8 = add <32 x i8> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V64I8 = add <64 x i8> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'add'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I64 = add i64 undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = add <2 x i64> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:4 for: %V4I64 = add <4 x i64> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:8 for: %V8I64 = add <8 x i64> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I32 = add i32 undef, undef
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = add <4 x i32> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8I32 = add <8 x i32> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V16I32 = add <16 x i32> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I16 = add i16 undef, undef
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = add <8 x i16> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16I16 = add <16 x i16> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V32I16 = add <32 x i16> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I8 = add i8 undef, undef
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = add <16 x i8> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V32I8 = add <32 x i8> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V64I8 = add <64 x i8> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'add'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = add i64 undef, undef
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = add <2 x i64> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = add <4 x i64> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = add <8 x i64> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = add i32 undef, undef
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = add <4 x i32> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = add <8 x i32> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = add <16 x i32> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = add i16 undef, undef
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = add <8 x i16> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = add <16 x i16> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = add <32 x i16> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = add i8 undef, undef
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = add <16 x i8> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = add <32 x i8> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = add <64 x i8> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'add'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = add i64 undef, undef
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = add <2 x i64> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = add <4 x i64> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I64 = add <8 x i64> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = add i32 undef, undef
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = add <4 x i32> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = add <8 x i32> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = add <16 x i32> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = add i16 undef, undef
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = add <8 x i16> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = add <16 x i16> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = add <32 x i16> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = add i8 undef, undef
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = add <16 x i8> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = add <32 x i8> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = add <64 x i8> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'add'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = add i64 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = add <2 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = add <4 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = add <8 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = add i32 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = add <4 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = add <8 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = add <16 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = add i16 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = add <8 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = add <16 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V32I16 = add <32 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = add i8 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = add <16 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = add <32 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V64I8 = add <64 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'add'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = add i64 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = add <2 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = add <4 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = add <8 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = add i32 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = add <4 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = add <8 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = add <16 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = add i16 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = add <8 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = add <16 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = add <32 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = add i8 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = add <16 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = add <32 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = add <64 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQ-LABEL: 'add'
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %I64 = add i64 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = add <2 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = add <4 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = add <8 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %I32 = add i32 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = add <4 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = add <8 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = add <16 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %I16 = add i16 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = add <8 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = add <16 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V32I16 = add <32 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %I8 = add i8 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = add <16 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = add <32 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V64I8 = add <64 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'add'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = add i64 undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = add <2 x i64> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:4 SizeLat:4 for: %V4I64 = add <4 x i64> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:8 SizeLat:8 for: %V8I64 = add <8 x i64> undef, undef
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = add i32 undef, undef
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = add <4 x i32> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8I32 = add <8 x i32> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V16I32 = add <16 x i32> undef, undef
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = add i16 undef, undef
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = add <8 x i16> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16I16 = add <16 x i16> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V32I16 = add <32 x i16> undef, undef
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = add i8 undef, undef
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = add <16 x i8> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V32I8 = add <32 x i8> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V64I8 = add <64 x i8> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; GLM-LABEL: 'add'
; GLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = add i64 undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = add <2 x i64> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:4 for: %V4I64 = add <4 x i64> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:8 for: %V8I64 = add <8 x i64> undef, undef
; GLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = add i32 undef, undef
; GLM-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = add <4 x i32> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8I32 = add <8 x i32> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V16I32 = add <16 x i32> undef, undef
; GLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = add i16 undef, undef
; GLM-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = add <8 x i16> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16I16 = add <16 x i16> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V32I16 = add <32 x i16> undef, undef
; GLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = add i8 undef, undef
; GLM-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = add <16 x i8> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V32I8 = add <32 x i8> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V64I8 = add <64 x i8> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I64 = add i64 undef, undef
  %V2I64 = add <2 x i64> undef, undef
  %V4I64 = add <4 x i64> undef, undef
  %V8I64 = add <8 x i64> undef, undef

  %I32 = add i32 undef, undef
  %V4I32 = add <4 x i32> undef, undef
  %V8I32 = add <8 x i32> undef, undef
  %V16I32 = add <16 x i32> undef, undef

  %I16 = add i16 undef, undef
  %V8I16 = add <8 x i16> undef, undef
  %V16I16 = add <16 x i16> undef, undef
  %V32I16 = add <32 x i16> undef, undef

  %I8 = add i8 undef, undef
  %V16I8 = add <16 x i8> undef, undef
  %V32I8 = add <32 x i8> undef, undef
  %V64I8 = add <64 x i8> undef, undef

  ret i32 undef
}

define i32 @sub(i32 %arg) {
; SSSE3-LABEL: 'sub'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = sub i64 undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = sub <2 x i64> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:4 for: %V4I64 = sub <4 x i64> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:8 for: %V8I64 = sub <8 x i64> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = sub i32 undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = sub <4 x i32> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8I32 = sub <8 x i32> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V16I32 = sub <16 x i32> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = sub i16 undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = sub <8 x i16> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16I16 = sub <16 x i16> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V32I16 = sub <32 x i16> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = sub i8 undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = sub <16 x i8> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V32I8 = sub <32 x i8> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V64I8 = sub <64 x i8> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'sub'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I64 = sub i64 undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = sub <2 x i64> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:4 for: %V4I64 = sub <4 x i64> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:8 for: %V8I64 = sub <8 x i64> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I32 = sub i32 undef, undef
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = sub <4 x i32> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8I32 = sub <8 x i32> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V16I32 = sub <16 x i32> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I16 = sub i16 undef, undef
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = sub <8 x i16> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16I16 = sub <16 x i16> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V32I16 = sub <32 x i16> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I8 = sub i8 undef, undef
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = sub <16 x i8> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V32I8 = sub <32 x i8> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V64I8 = sub <64 x i8> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'sub'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = sub i64 undef, undef
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = sub <2 x i64> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = sub <4 x i64> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = sub <8 x i64> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = sub i32 undef, undef
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = sub <4 x i32> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = sub <8 x i32> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = sub <16 x i32> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = sub i16 undef, undef
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = sub <8 x i16> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = sub <16 x i16> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = sub <32 x i16> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = sub i8 undef, undef
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = sub <16 x i8> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = sub <32 x i8> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = sub <64 x i8> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'sub'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = sub i64 undef, undef
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = sub <2 x i64> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = sub <4 x i64> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I64 = sub <8 x i64> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = sub i32 undef, undef
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = sub <4 x i32> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = sub <8 x i32> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = sub <16 x i32> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = sub i16 undef, undef
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = sub <8 x i16> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = sub <16 x i16> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = sub <32 x i16> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = sub i8 undef, undef
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = sub <16 x i8> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = sub <32 x i8> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = sub <64 x i8> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'sub'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = sub i64 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = sub <2 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = sub <4 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = sub <8 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = sub i32 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = sub <4 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = sub <8 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = sub <16 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = sub i16 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = sub <8 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = sub <16 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V32I16 = sub <32 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = sub i8 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = sub <16 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = sub <32 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V64I8 = sub <64 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'sub'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = sub i64 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = sub <2 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = sub <4 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = sub <8 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = sub i32 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = sub <4 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = sub <8 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = sub <16 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = sub i16 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = sub <8 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = sub <16 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = sub <32 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = sub i8 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = sub <16 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = sub <32 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = sub <64 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQ-LABEL: 'sub'
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %I64 = sub i64 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = sub <2 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = sub <4 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = sub <8 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %I32 = sub i32 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = sub <4 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = sub <8 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = sub <16 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %I16 = sub i16 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = sub <8 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = sub <16 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V32I16 = sub <32 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %I8 = sub i8 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = sub <16 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = sub <32 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V64I8 = sub <64 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'sub'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = sub i64 undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = sub <2 x i64> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:4 SizeLat:4 for: %V4I64 = sub <4 x i64> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:8 SizeLat:8 for: %V8I64 = sub <8 x i64> undef, undef
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = sub i32 undef, undef
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = sub <4 x i32> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8I32 = sub <8 x i32> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V16I32 = sub <16 x i32> undef, undef
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = sub i16 undef, undef
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = sub <8 x i16> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16I16 = sub <16 x i16> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V32I16 = sub <32 x i16> undef, undef
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = sub i8 undef, undef
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = sub <16 x i8> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V32I8 = sub <32 x i8> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V64I8 = sub <64 x i8> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; GLM-LABEL: 'sub'
; GLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = sub i64 undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = sub <2 x i64> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:4 for: %V4I64 = sub <4 x i64> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:8 for: %V8I64 = sub <8 x i64> undef, undef
; GLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = sub i32 undef, undef
; GLM-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = sub <4 x i32> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8I32 = sub <8 x i32> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V16I32 = sub <16 x i32> undef, undef
; GLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = sub i16 undef, undef
; GLM-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = sub <8 x i16> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16I16 = sub <16 x i16> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V32I16 = sub <32 x i16> undef, undef
; GLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = sub i8 undef, undef
; GLM-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = sub <16 x i8> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V32I8 = sub <32 x i8> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V64I8 = sub <64 x i8> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I64 = sub i64 undef, undef
  %V2I64 = sub <2 x i64> undef, undef
  %V4I64 = sub <4 x i64> undef, undef
  %V8I64 = sub <8 x i64> undef, undef

  %I32 = sub i32 undef, undef
  %V4I32 = sub <4 x i32> undef, undef
  %V8I32 = sub <8 x i32> undef, undef
  %V16I32 = sub <16 x i32> undef, undef

  %I16 = sub i16 undef, undef
  %V8I16 = sub <8 x i16> undef, undef
  %V16I16 = sub <16 x i16> undef, undef
  %V32I16 = sub <32 x i16> undef, undef

  %I8 = sub i8 undef, undef
  %V16I8 = sub <16 x i8> undef, undef
  %V32I8 = sub <32 x i8> undef, undef
  %V64I8 = sub <64 x i8> undef, undef

  ret i32 undef
}

define i32 @or(i32 %arg) {
; SSE-LABEL: 'or'
; SSE-NEXT:  Cost Model: Found costs of 1 for: %I64 = or i64 undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = or <2 x i64> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 2 for: %V4I64 = or <4 x i64> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 4 for: %V8I64 = or <8 x i64> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %I32 = or i32 undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = or <4 x i32> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = or <8 x i32> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = or <16 x i32> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %I16 = or i16 undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = or <8 x i16> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = or <16 x i16> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = or <32 x i16> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %I8 = or i8 undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = or <16 x i8> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = or <32 x i8> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = or <64 x i8> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %I1 = or i1 undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V2I1 = or <2 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V4I1 = or <4 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V8I1 = or <8 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V16I1 = or <16 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 2 for: %V32I1 = or <32 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 4 for: %V64I1 = or <64 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX-LABEL: 'or'
; AVX-NEXT:  Cost Model: Found costs of 1 for: %I64 = or i64 undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = or <2 x i64> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = or <4 x i64> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I64 = or <8 x i64> undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %I32 = or i32 undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = or <4 x i32> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = or <8 x i32> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = or <16 x i32> undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %I16 = or i16 undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = or <8 x i16> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = or <16 x i16> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = or <32 x i16> undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %I8 = or i8 undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = or <16 x i8> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = or <32 x i8> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = or <64 x i8> undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %I1 = or i1 undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V2I1 = or <2 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V4I1 = or <4 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V8I1 = or <8 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V16I1 = or <16 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I1 = or <32 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I1 = or <64 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'or'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = or i64 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = or <2 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = or <4 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = or <8 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = or i32 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = or <4 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = or <8 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = or <16 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = or i16 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = or <8 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = or <16 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = or <32 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = or i8 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = or <16 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = or <32 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = or <64 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I1 = or i1 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I1 = or <2 x i1> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I1 = or <4 x i1> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I1 = or <8 x i1> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I1 = or <16 x i1> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:1 SizeLat:1 for: %V32I1 = or <32 x i1> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:1 SizeLat:1 for: %V64I1 = or <64 x i1> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'or'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = or i64 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = or <2 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = or <4 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = or <8 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = or i32 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = or <4 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = or <8 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = or <16 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = or i16 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = or <8 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = or <16 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = or <32 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = or i8 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = or <16 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = or <32 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = or <64 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I1 = or i1 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I1 = or <2 x i1> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I1 = or <4 x i1> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I1 = or <8 x i1> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I1 = or <16 x i1> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I1 = or <32 x i1> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I1 = or <64 x i1> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQ-LABEL: 'or'
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %I64 = or i64 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = or <2 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = or <4 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = or <8 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %I32 = or i32 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = or <4 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = or <8 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = or <16 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %I16 = or i16 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = or <8 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = or <16 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = or <32 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %I8 = or i8 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = or <16 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = or <32 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = or <64 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %I1 = or i1 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V2I1 = or <2 x i1> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V4I1 = or <4 x i1> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V8I1 = or <8 x i1> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V16I1 = or <16 x i1> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:1 SizeLat:1 for: %V32I1 = or <32 x i1> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:1 SizeLat:1 for: %V64I1 = or <64 x i1> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I64 = or i64 undef, undef
  %V2I64 = or <2 x i64> undef, undef
  %V4I64 = or <4 x i64> undef, undef
  %V8I64 = or <8 x i64> undef, undef

  %I32 = or i32 undef, undef
  %V4I32 = or <4 x i32> undef, undef
  %V8I32 = or <8 x i32> undef, undef
  %V16I32 = or <16 x i32> undef, undef

  %I16 = or i16 undef, undef
  %V8I16 = or <8 x i16> undef, undef
  %V16I16 = or <16 x i16> undef, undef
  %V32I16 = or <32 x i16> undef, undef

  %I8 = or i8 undef, undef
  %V16I8 = or <16 x i8> undef, undef
  %V32I8 = or <32 x i8> undef, undef
  %V64I8 = or <64 x i8> undef, undef

  %I1 = or i1 undef, undef
  %V2I1 = or <2 x i1> undef, undef
  %V4I1 = or <4 x i1> undef, undef
  %V8I1 = or <8 x i1> undef, undef
  %V16I1 = or <16 x i1> undef, undef
  %V32I1 = or <32 x i1> undef, undef
  %V64I1 = or <64 x i1> undef, undef

  ret i32 undef
}

define i32 @xor(i32 %arg) {
; SSE-LABEL: 'xor'
; SSE-NEXT:  Cost Model: Found costs of 1 for: %I64 = xor i64 undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = xor <2 x i64> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 2 for: %V4I64 = xor <4 x i64> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 4 for: %V8I64 = xor <8 x i64> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %I32 = xor i32 undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = xor <4 x i32> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = xor <8 x i32> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = xor <16 x i32> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %I16 = xor i16 undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = xor <8 x i16> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = xor <16 x i16> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = xor <32 x i16> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %I8 = xor i8 undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = xor <16 x i8> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = xor <32 x i8> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = xor <64 x i8> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %I1 = xor i1 undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V2I1 = xor <2 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V4I1 = xor <4 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V8I1 = xor <8 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V16I1 = xor <16 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 2 for: %V32I1 = xor <32 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 4 for: %V64I1 = xor <64 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX-LABEL: 'xor'
; AVX-NEXT:  Cost Model: Found costs of 1 for: %I64 = xor i64 undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = xor <2 x i64> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = xor <4 x i64> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I64 = xor <8 x i64> undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %I32 = xor i32 undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = xor <4 x i32> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = xor <8 x i32> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = xor <16 x i32> undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %I16 = xor i16 undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = xor <8 x i16> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = xor <16 x i16> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = xor <32 x i16> undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %I8 = xor i8 undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = xor <16 x i8> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = xor <32 x i8> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = xor <64 x i8> undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %I1 = xor i1 undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V2I1 = xor <2 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V4I1 = xor <4 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V8I1 = xor <8 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V16I1 = xor <16 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I1 = xor <32 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I1 = xor <64 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'xor'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = xor i64 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = xor <2 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = xor <4 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = xor <8 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = xor i32 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = xor <4 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = xor <8 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = xor <16 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = xor i16 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = xor <8 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = xor <16 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = xor <32 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = xor i8 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = xor <16 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = xor <32 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = xor <64 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I1 = xor i1 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I1 = xor <2 x i1> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I1 = xor <4 x i1> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I1 = xor <8 x i1> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I1 = xor <16 x i1> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:1 SizeLat:1 for: %V32I1 = xor <32 x i1> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:1 SizeLat:1 for: %V64I1 = xor <64 x i1> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'xor'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = xor i64 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = xor <2 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = xor <4 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = xor <8 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = xor i32 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = xor <4 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = xor <8 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = xor <16 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = xor i16 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = xor <8 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = xor <16 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = xor <32 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = xor i8 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = xor <16 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = xor <32 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = xor <64 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I1 = xor i1 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I1 = xor <2 x i1> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I1 = xor <4 x i1> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I1 = xor <8 x i1> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I1 = xor <16 x i1> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I1 = xor <32 x i1> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I1 = xor <64 x i1> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQ-LABEL: 'xor'
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %I64 = xor i64 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = xor <2 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = xor <4 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = xor <8 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %I32 = xor i32 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = xor <4 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = xor <8 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = xor <16 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %I16 = xor i16 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = xor <8 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = xor <16 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = xor <32 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %I8 = xor i8 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = xor <16 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = xor <32 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = xor <64 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %I1 = xor i1 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V2I1 = xor <2 x i1> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V4I1 = xor <4 x i1> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V8I1 = xor <8 x i1> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V16I1 = xor <16 x i1> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:1 SizeLat:1 for: %V32I1 = xor <32 x i1> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:1 SizeLat:1 for: %V64I1 = xor <64 x i1> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I64 = xor i64 undef, undef
  %V2I64 = xor <2 x i64> undef, undef
  %V4I64 = xor <4 x i64> undef, undef
  %V8I64 = xor <8 x i64> undef, undef

  %I32 = xor i32 undef, undef
  %V4I32 = xor <4 x i32> undef, undef
  %V8I32 = xor <8 x i32> undef, undef
  %V16I32 = xor <16 x i32> undef, undef

  %I16 = xor i16 undef, undef
  %V8I16 = xor <8 x i16> undef, undef
  %V16I16 = xor <16 x i16> undef, undef
  %V32I16 = xor <32 x i16> undef, undef

  %I8 = xor i8 undef, undef
  %V16I8 = xor <16 x i8> undef, undef
  %V32I8 = xor <32 x i8> undef, undef
  %V64I8 = xor <64 x i8> undef, undef

  %I1 = xor i1 undef, undef
  %V2I1 = xor <2 x i1> undef, undef
  %V4I1 = xor <4 x i1> undef, undef
  %V8I1 = xor <8 x i1> undef, undef
  %V16I1 = xor <16 x i1> undef, undef
  %V32I1 = xor <32 x i1> undef, undef
  %V64I1 = xor <64 x i1> undef, undef

  ret i32 undef
}

define i32 @and(i32 %arg) {
; SSE-LABEL: 'and'
; SSE-NEXT:  Cost Model: Found costs of 1 for: %I64 = and i64 undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = and <2 x i64> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 2 for: %V4I64 = and <4 x i64> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 4 for: %V8I64 = and <8 x i64> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %I32 = and i32 undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = and <4 x i32> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = and <8 x i32> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = and <16 x i32> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %I16 = and i16 undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = and <8 x i16> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = and <16 x i16> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = and <32 x i16> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %I8 = and i8 undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = and <16 x i8> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = and <32 x i8> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = and <64 x i8> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %I1 = and i1 undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V2I1 = and <2 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V4I1 = and <4 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V8I1 = and <8 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V16I1 = and <16 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 2 for: %V32I1 = and <32 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found costs of 4 for: %V64I1 = and <64 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX-LABEL: 'and'
; AVX-NEXT:  Cost Model: Found costs of 1 for: %I64 = and i64 undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = and <2 x i64> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = and <4 x i64> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I64 = and <8 x i64> undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %I32 = and i32 undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = and <4 x i32> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = and <8 x i32> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = and <16 x i32> undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %I16 = and i16 undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = and <8 x i16> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = and <16 x i16> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = and <32 x i16> undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %I8 = and i8 undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = and <16 x i8> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = and <32 x i8> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = and <64 x i8> undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %I1 = and i1 undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V2I1 = and <2 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V4I1 = and <4 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V8I1 = and <8 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V16I1 = and <16 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I1 = and <32 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I1 = and <64 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'and'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = and i64 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = and <2 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = and <4 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = and <8 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = and i32 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = and <4 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = and <8 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = and <16 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = and i16 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = and <8 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = and <16 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = and <32 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = and i8 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = and <16 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = and <32 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = and <64 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I1 = and i1 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I1 = and <2 x i1> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I1 = and <4 x i1> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I1 = and <8 x i1> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I1 = and <16 x i1> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:1 SizeLat:1 for: %V32I1 = and <32 x i1> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:1 SizeLat:1 for: %V64I1 = and <64 x i1> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'and'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = and i64 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = and <2 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = and <4 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = and <8 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = and i32 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = and <4 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = and <8 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = and <16 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = and i16 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = and <8 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = and <16 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = and <32 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = and i8 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = and <16 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = and <32 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = and <64 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I1 = and i1 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I1 = and <2 x i1> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I1 = and <4 x i1> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I1 = and <8 x i1> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I1 = and <16 x i1> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I1 = and <32 x i1> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I1 = and <64 x i1> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQ-LABEL: 'and'
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %I64 = and i64 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = and <2 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = and <4 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = and <8 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %I32 = and i32 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = and <4 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = and <8 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = and <16 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %I16 = and i16 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = and <8 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = and <16 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = and <32 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %I8 = and i8 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = and <16 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = and <32 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = and <64 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %I1 = and i1 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V2I1 = and <2 x i1> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V4I1 = and <4 x i1> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V8I1 = and <8 x i1> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V16I1 = and <16 x i1> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:1 SizeLat:1 for: %V32I1 = and <32 x i1> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:1 SizeLat:1 for: %V64I1 = and <64 x i1> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I64 = and i64 undef, undef
  %V2I64 = and <2 x i64> undef, undef
  %V4I64 = and <4 x i64> undef, undef
  %V8I64 = and <8 x i64> undef, undef

  %I32 = and i32 undef, undef
  %V4I32 = and <4 x i32> undef, undef
  %V8I32 = and <8 x i32> undef, undef
  %V16I32 = and <16 x i32> undef, undef

  %I16 = and i16 undef, undef
  %V8I16 = and <8 x i16> undef, undef
  %V16I16 = and <16 x i16> undef, undef
  %V32I16 = and <32 x i16> undef, undef

  %I8 = and i8 undef, undef
  %V16I8 = and <16 x i8> undef, undef
  %V32I8 = and <32 x i8> undef, undef
  %V64I8 = and <64 x i8> undef, undef

  %I1 = and i1 undef, undef
  %V2I1 = and <2 x i1> undef, undef
  %V4I1 = and <4 x i1> undef, undef
  %V8I1 = and <8 x i1> undef, undef
  %V16I1 = and <16 x i1> undef, undef
  %V32I1 = and <32 x i1> undef, undef
  %V64I1 = and <64 x i1> undef, undef

  ret i32 undef
}

define i32 @mul(i32 %arg) {
; SSSE3-LABEL: 'mul'
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:6 SizeLat:2 for: %I64 = mul i64 undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:10 Lat:10 SizeLat:10 for: %V2I64 = mul <2 x i64> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:20 Lat:20 SizeLat:20 for: %V4I64 = mul <4 x i64> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:40 Lat:40 SizeLat:40 for: %V8I64 = mul <8 x i64> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %I32 = mul i32 undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:7 Lat:8 SizeLat:7 for: %V4I32 = mul <4 x i32> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:14 Lat:16 SizeLat:14 for: %V8I32 = mul <8 x i32> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:28 Lat:32 SizeLat:28 for: %V16I32 = mul <16 x i32> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:4 SizeLat:1 for: %I16 = mul i16 undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V8I16 = mul <8 x i16> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V16I16 = mul <16 x i16> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V32I16 = mul <32 x i16> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:4 SizeLat:1 for: %I8 = mul i8 undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:7 SizeLat:3 for: %V2I8 = mul <2 x i8> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:7 SizeLat:3 for: %V4I8 = mul <4 x i8> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:7 SizeLat:3 for: %V8I8 = mul <8 x i8> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:10 Lat:18 SizeLat:12 for: %V16I8 = mul <16 x i8> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:20 Lat:36 SizeLat:24 for: %V32I8 = mul <32 x i8> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:40 Lat:72 SizeLat:48 for: %V64I8 = mul <64 x i8> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'mul'
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:6 SizeLat:2 for: %I64 = mul i64 undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:10 SizeLat:10 for: %V2I64 = mul <2 x i64> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:20 Lat:20 SizeLat:20 for: %V4I64 = mul <4 x i64> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:40 Lat:40 SizeLat:40 for: %V8I64 = mul <8 x i64> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %I32 = mul i32 undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:11 SizeLat:1 for: %V4I32 = mul <4 x i32> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:22 SizeLat:2 for: %V8I32 = mul <8 x i32> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:44 SizeLat:4 for: %V16I32 = mul <16 x i32> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:4 SizeLat:1 for: %I16 = mul i16 undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V8I16 = mul <8 x i16> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V16I16 = mul <16 x i16> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V32I16 = mul <32 x i16> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:4 SizeLat:1 for: %I8 = mul i8 undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:7 SizeLat:3 for: %V2I8 = mul <2 x i8> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:7 SizeLat:3 for: %V4I8 = mul <4 x i8> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:7 SizeLat:3 for: %V8I8 = mul <8 x i8> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:10 Lat:18 SizeLat:12 for: %V16I8 = mul <16 x i8> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:20 Lat:36 SizeLat:24 for: %V32I8 = mul <32 x i8> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:40 Lat:72 SizeLat:48 for: %V64I8 = mul <64 x i8> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'mul'
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:6 SizeLat:2 for: %I64 = mul i64 undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:10 SizeLat:10 for: %V2I64 = mul <2 x i64> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:19 Lat:15 SizeLat:20 for: %V4I64 = mul <4 x i64> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:38 Lat:30 SizeLat:40 for: %V8I64 = mul <8 x i64> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %I32 = mul i32 undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:3 for: %V4I32 = mul <4 x i32> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:8 SizeLat:10 for: %V8I32 = mul <8 x i32> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:16 SizeLat:20 for: %V16I32 = mul <16 x i32> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:4 SizeLat:1 for: %I16 = mul i16 undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V8I16 = mul <8 x i16> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:8 SizeLat:6 for: %V16I16 = mul <16 x i16> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:16 SizeLat:12 for: %V32I16 = mul <32 x i16> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:4 SizeLat:1 for: %I8 = mul i8 undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:7 SizeLat:3 for: %V2I8 = mul <2 x i8> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:7 SizeLat:3 for: %V4I8 = mul <4 x i8> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:7 SizeLat:3 for: %V8I8 = mul <8 x i8> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:8 Lat:6 SizeLat:12 for: %V16I8 = mul <16 x i8> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:18 Lat:11 SizeLat:19 for: %V32I8 = mul <32 x i8> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:36 Lat:22 SizeLat:38 for: %V64I8 = mul <64 x i8> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'mul'
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:6 SizeLat:2 for: %I64 = mul i64 undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:8 Lat:10 SizeLat:8 for: %V2I64 = mul <2 x i64> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:8 Lat:10 SizeLat:13 for: %V4I64 = mul <4 x i64> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:16 Lat:20 SizeLat:26 for: %V8I64 = mul <8 x i64> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %I32 = mul i32 undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:10 SizeLat:2 for: %V4I32 = mul <4 x i32> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:10 SizeLat:2 for: %V8I32 = mul <8 x i32> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:20 SizeLat:4 for: %V16I32 = mul <16 x i32> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:4 SizeLat:1 for: %I16 = mul i16 undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V8I16 = mul <8 x i16> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %V16I16 = mul <16 x i16> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:4 for: %V32I16 = mul <32 x i16> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:4 SizeLat:1 for: %I8 = mul i8 undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:7 SizeLat:3 for: %V2I8 = mul <2 x i8> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:7 SizeLat:3 for: %V4I8 = mul <4 x i8> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:7 SizeLat:3 for: %V8I8 = mul <8 x i8> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:18 SizeLat:12 for: %V16I8 = mul <16 x i8> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:8 SizeLat:16 for: %V32I8 = mul <32 x i8> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:16 Lat:16 SizeLat:32 for: %V64I8 = mul <64 x i8> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'mul'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:6 SizeLat:2 for: %I64 = mul i64 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:8 Lat:10 SizeLat:8 for: %V2I64 = mul <2 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:8 Lat:10 SizeLat:13 for: %V4I64 = mul <4 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:8 Lat:9 SizeLat:8 for: %V8I64 = mul <8 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %I32 = mul i32 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:10 SizeLat:2 for: %V4I32 = mul <4 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:10 SizeLat:2 for: %V8I32 = mul <8 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:10 SizeLat:2 for: %V16I32 = mul <16 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:4 SizeLat:1 for: %I16 = mul i16 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V8I16 = mul <8 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %V16I16 = mul <16 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V32I16 = mul <32 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:4 SizeLat:1 for: %I8 = mul i8 undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:7 SizeLat:3 for: %V2I8 = mul <2 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:7 SizeLat:3 for: %V4I8 = mul <4 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:7 SizeLat:3 for: %V8I8 = mul <8 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:18 SizeLat:12 for: %V16I8 = mul <16 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:8 SizeLat:16 for: %V32I8 = mul <32 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V64I8 = mul <64 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'mul'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:6 SizeLat:2 for: %I64 = mul i64 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:8 Lat:10 SizeLat:8 for: %V2I64 = mul <2 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:8 Lat:10 SizeLat:13 for: %V4I64 = mul <4 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:8 Lat:9 SizeLat:8 for: %V8I64 = mul <8 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %I32 = mul i32 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:10 SizeLat:2 for: %V4I32 = mul <4 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:10 SizeLat:2 for: %V8I32 = mul <8 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:10 SizeLat:2 for: %V16I32 = mul <16 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:4 SizeLat:1 for: %I16 = mul i16 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V8I16 = mul <8 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %V16I16 = mul <16 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V32I16 = mul <32 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:4 SizeLat:1 for: %I8 = mul i8 undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:7 SizeLat:3 for: %V2I8 = mul <2 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:7 SizeLat:3 for: %V4I8 = mul <4 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:7 SizeLat:3 for: %V8I8 = mul <8 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:12 SizeLat:5 for: %V16I8 = mul <16 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:7 Lat:10 SizeLat:10 for: %V32I8 = mul <32 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:7 Lat:11 SizeLat:10 for: %V64I8 = mul <64 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQ-LABEL: 'mul'
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:6 SizeLat:2 for: %I64 = mul i64 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:15 SizeLat:3 for: %V2I64 = mul <2 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:15 SizeLat:3 for: %V4I64 = mul <4 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:15 SizeLat:3 for: %V8I64 = mul <8 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %I32 = mul i32 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:10 SizeLat:2 for: %V4I32 = mul <4 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:10 SizeLat:2 for: %V8I32 = mul <8 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:10 SizeLat:2 for: %V16I32 = mul <16 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:4 SizeLat:1 for: %I16 = mul i16 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V8I16 = mul <8 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %V16I16 = mul <16 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V32I16 = mul <32 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:4 SizeLat:1 for: %I8 = mul i8 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:7 SizeLat:3 for: %V2I8 = mul <2 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:7 SizeLat:3 for: %V4I8 = mul <4 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:7 SizeLat:3 for: %V8I8 = mul <8 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:18 SizeLat:12 for: %V16I8 = mul <16 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:8 SizeLat:16 for: %V32I8 = mul <32 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V64I8 = mul <64 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'mul'
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:6 SizeLat:2 for: %I64 = mul i64 undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:17 CodeSize:9 Lat:22 SizeLat:9 for: %V2I64 = mul <2 x i64> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:34 CodeSize:18 Lat:44 SizeLat:18 for: %V4I64 = mul <4 x i64> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:68 CodeSize:36 Lat:88 SizeLat:36 for: %V8I64 = mul <8 x i64> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %I32 = mul i32 undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:1 Lat:11 SizeLat:7 for: %V4I32 = mul <4 x i32> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:2 Lat:22 SizeLat:14 for: %V8I32 = mul <8 x i32> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:4 Lat:44 SizeLat:28 for: %V16I32 = mul <16 x i32> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:4 SizeLat:1 for: %I16 = mul i16 undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V8I16 = mul <8 x i16> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V16I16 = mul <16 x i16> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V32I16 = mul <32 x i16> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:4 SizeLat:1 for: %I8 = mul i8 undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:3 Lat:7 SizeLat:3 for: %V2I8 = mul <2 x i8> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:3 Lat:7 SizeLat:3 for: %V4I8 = mul <4 x i8> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:3 Lat:7 SizeLat:3 for: %V8I8 = mul <8 x i8> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:10 Lat:18 SizeLat:12 for: %V16I8 = mul <16 x i8> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:20 Lat:36 SizeLat:24 for: %V32I8 = mul <32 x i8> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:40 Lat:72 SizeLat:48 for: %V64I8 = mul <64 x i8> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; GLM-LABEL: 'mul'
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:6 SizeLat:2 for: %I64 = mul i64 undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:10 SizeLat:10 for: %V2I64 = mul <2 x i64> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:20 Lat:20 SizeLat:20 for: %V4I64 = mul <4 x i64> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:40 Lat:40 SizeLat:40 for: %V8I64 = mul <8 x i64> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %I32 = mul i32 undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:11 SizeLat:1 for: %V4I32 = mul <4 x i32> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:22 SizeLat:2 for: %V8I32 = mul <8 x i32> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:44 SizeLat:4 for: %V16I32 = mul <16 x i32> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:4 SizeLat:1 for: %I16 = mul i16 undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V8I16 = mul <8 x i16> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V16I16 = mul <16 x i16> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V32I16 = mul <32 x i16> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:4 SizeLat:1 for: %I8 = mul i8 undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:7 SizeLat:3 for: %V2I8 = mul <2 x i8> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:7 SizeLat:3 for: %V4I8 = mul <4 x i8> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:7 SizeLat:3 for: %V8I8 = mul <8 x i8> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:10 Lat:18 SizeLat:12 for: %V16I8 = mul <16 x i8> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:20 Lat:36 SizeLat:24 for: %V32I8 = mul <32 x i8> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:40 Lat:72 SizeLat:48 for: %V64I8 = mul <64 x i8> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I64 = mul i64 undef, undef
  %V2I64 = mul <2 x i64> undef, undef
  %V4I64 = mul <4 x i64> undef, undef
  %V8I64 = mul <8 x i64> undef, undef

  %I32 = mul i32 undef, undef
  %V4I32 = mul <4 x i32> undef, undef
  %V8I32 = mul <8 x i32> undef, undef
  %V16I32 = mul <16 x i32> undef, undef

  %I16 = mul i16 undef, undef
  %V8I16 = mul <8 x i16> undef, undef
  %V16I16 = mul <16 x i16> undef, undef
  %V32I16 = mul <32 x i16> undef, undef

  %I8 = mul i8 undef, undef
  %V2I8 = mul <2 x i8> undef, undef
  %V4I8 = mul <4 x i8> undef, undef
  %V8I8 = mul <8 x i8> undef, undef
  %V16I8 = mul <16 x i8> undef, undef
  %V32I8 = mul <32 x i8> undef, undef
  %V64I8 = mul <64 x i8> undef, undef

  ret i32 undef
}

; A <2 x i32> gets expanded to a <2 x i64> vector.
; A <2 x i64> vector multiply is implemented using
; 3 PMULUDQ and 2 PADDS and 4 shifts.
define void @mul_2i32() {
; SSSE3-LABEL: 'mul_2i32'
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:7 Lat:8 SizeLat:7 for: %A0 = mul <2 x i32> undef, undef
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSE42-LABEL: 'mul_2i32'
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:11 SizeLat:1 for: %A0 = mul <2 x i32> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX1-LABEL: 'mul_2i32'
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:3 for: %A0 = mul <2 x i32> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX2-LABEL: 'mul_2i32'
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:10 SizeLat:2 for: %A0 = mul <2 x i32> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512-LABEL: 'mul_2i32'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:10 SizeLat:2 for: %A0 = mul <2 x i32> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SLM-LABEL: 'mul_2i32'
; SLM-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:1 Lat:11 SizeLat:7 for: %A0 = mul <2 x i32> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; GLM-LABEL: 'mul_2i32'
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:11 SizeLat:1 for: %A0 = mul <2 x i32> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %A0 = mul <2 x i32> undef, undef

  ret void
}
