; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11-SDAG %s
; RUN: llc -global-isel -global-isel-abort=2 -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11-GISEL %s

declare i32 @llvm.amdgcn.permlane64(i32)
declare i32 @llvm.amdgcn.workitem.id.x()

define amdgpu_kernel void @test_s_i32(ptr addrspace(1) %out, i32 %src0) {
; GFX11-LABEL: test_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_permlane64_b32 v0, v0
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_endpgm
; GFX11-SDAG-LABEL: test_s_i32:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_clause 0x1
; GFX11-SDAG-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v0, v0
; GFX11-SDAG-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: test_s_i32:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_clause 0x1
; GFX11-GISEL-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_permlane64_b32 v0, v0
; GFX11-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-GISEL-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlane64.i32(i32 %src0)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_s_i64(ptr addrspace(1) %out, i64 %src0) {
; GFX11-SDAG-LABEL: test_s_i64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_mov_b32 v0, s3
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v1, v0
; GFX11-SDAG-NEXT:    v_permlane64_b32 v0, v2
; GFX11-SDAG-NEXT:    global_store_b64 v3, v[0:1], s[0:1]
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: test_s_i64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_permlane64_b32 v0, v0
; GFX11-GISEL-NEXT:    v_permlane64_b32 v1, v1
; GFX11-GISEL-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-GISEL-NEXT:    s_endpgm
  %v = call i64 @llvm.amdgcn.permlane64.i64(i64 %src0)
  store i64 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_s_f64(ptr addrspace(1) %out, double %src0) {
; GFX11-SDAG-LABEL: test_s_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_mov_b32 v0, s3
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v1, v0
; GFX11-SDAG-NEXT:    v_permlane64_b32 v0, v2
; GFX11-SDAG-NEXT:    global_store_b64 v3, v[0:1], s[0:1]
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: test_s_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_permlane64_b32 v0, v0
; GFX11-GISEL-NEXT:    v_permlane64_b32 v1, v1
; GFX11-GISEL-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-GISEL-NEXT:    s_endpgm
  %v = call double @llvm.amdgcn.permlane64.f64(double %src0)
  store double %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_i_i32(ptr addrspace(1) %out) {
; GFX11-LABEL: test_i:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_dual_mov_b32 v0, 0x63 :: v_dual_mov_b32 v1, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_permlane64_b32 v0, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_endpgm
; GFX11-SDAG-LABEL: test_i_i32:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v0, 0x63 :: v_dual_mov_b32 v1, 0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v0, v0
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: test_i_i32:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, 0x63 :: v_dual_mov_b32 v1, 0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_permlane64_b32 v0, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-GISEL-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlane64.i32(i32 99)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_i_f32(ptr addrspace(1) %out) {
; GFX11-SDAG-LABEL: test_i_f32:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v0, 0x449a5000 :: v_dual_mov_b32 v1, 0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v0, v0
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: test_i_f32:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, 0x449a5000 :: v_dual_mov_b32 v1, 0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_permlane64_b32 v0, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-GISEL-NEXT:    s_endpgm
  %v = call float @llvm.amdgcn.permlane64.f32(float 1234.5)
  store float %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_i_i64(ptr addrspace(1) %out) {
; GFX11-SDAG-LABEL: test_i_i64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v0, 0x63
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v1, v2
; GFX11-SDAG-NEXT:    v_permlane64_b32 v0, v0
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: test_i_i64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 0x63
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_permlane64_b32 v0, v0
; GFX11-GISEL-NEXT:    v_permlane64_b32 v1, v2
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-GISEL-NEXT:    s_endpgm
  %v = call i64 @llvm.amdgcn.permlane64.i64(i64 99)
  store i64 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_i_f64(ptr addrspace(1) %out) {
; GFX11-SDAG-LABEL: test_i_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v0, 0x40934a00
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v1, v0
; GFX11-SDAG-NEXT:    v_permlane64_b32 v0, v2
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: test_i_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, 0x40934a00
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_permlane64_b32 v0, v2
; GFX11-GISEL-NEXT:    v_permlane64_b32 v1, v1
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-GISEL-NEXT:    s_endpgm
  %v = call double @llvm.amdgcn.permlane64.f64(double 1234.5)
  store double %v, ptr addrspace(1) %out
  ret void
}



define amdgpu_kernel void @test_v_i32(ptr addrspace(1) %out, i32 %src0) #1 {
; GFX11-LABEL: test_v:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_permlane64_b32 v0, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_endpgm
; GFX11-SDAG-LABEL: test_v_i32:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v0, v0
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: test_v_i32:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_permlane64_b32 v0, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-GISEL-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %v = call i32 @llvm.amdgcn.permlane64.i32(i32 %tidx)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_v_f32(ptr addrspace(1) %out, float %src0) #1 {
; GFX11-SDAG-LABEL: test_v_f32:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v0, v0
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: test_v_f32:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_permlane64_b32 v0, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-GISEL-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %tidx_f32 = bitcast i32 %tidx to float
  %v = call float @llvm.amdgcn.permlane64.f32(float %tidx_f32)
  store float %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_v_i64(ptr addrspace(1) %out, i64 %src0) #1 {
; GFX11-SDAG-LABEL: test_v_i64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v1, v2
; GFX11-SDAG-NEXT:    v_permlane64_b32 v0, v0
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: test_v_i64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_permlane64_b32 v0, v0
; GFX11-GISEL-NEXT:    v_permlane64_b32 v1, v2
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-GISEL-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %tidx_i64 = zext i32 %tidx to i64
  %v = call i64 @llvm.amdgcn.permlane64.i64(i64 %tidx_i64)
  store i64 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_v_f64(ptr addrspace(1) %out, double %src0) #1 {
; GFX11-SDAG-LABEL: test_v_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_cvt_f64_f32_e32 v[0:1], v0
; GFX11-SDAG-NEXT:    v_permlane64_b32 v1, v1
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v0, v0
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: test_v_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_cvt_f64_f32_e32 v[0:1], v0
; GFX11-GISEL-NEXT:    v_permlane64_b32 v0, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_permlane64_b32 v1, v1
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-GISEL-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %tidx_f32 = bitcast i32 %tidx to float
  %tidx_f64 = fpext float %tidx_f32 to double
  %v = call double @llvm.amdgcn.permlane64.f64(double %tidx_f64)
  store double %v, ptr addrspace(1) %out
  ret void
}

define void @test_half(ptr addrspace(1) %out, half %src0) {
; GFX11-SDAG-LABEL: test_half:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v2, v2
; GFX11-SDAG-NEXT:    global_store_b16 v[0:1], v2, off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_half:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_permlane64_b32 v2, v2
; GFX11-GISEL-NEXT:    global_store_b16 v[0:1], v2, off
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %v = call half @llvm.amdgcn.permlane64.f16(half %src0)
  store half %v, ptr addrspace(1) %out
  ret void
}

define void @test_bfloat(ptr addrspace(1) %out, bfloat %src0) {
; GFX11-SDAG-LABEL: test_bfloat:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v2, v2
; GFX11-SDAG-NEXT:    global_store_b16 v[0:1], v2, off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_bfloat:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_permlane64_b32 v2, v2
; GFX11-GISEL-NEXT:    global_store_b16 v[0:1], v2, off
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %v = call bfloat @llvm.amdgcn.permlane64.bf16(bfloat %src0)
  store bfloat %v, ptr addrspace(1) %out
  ret void
}

define void @test_i16(ptr addrspace(1) %out, i16 %src0) {
; GFX11-SDAG-LABEL: test_i16:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v2, v2
; GFX11-SDAG-NEXT:    global_store_b16 v[0:1], v2, off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_i16:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_permlane64_b32 v2, v2
; GFX11-GISEL-NEXT:    global_store_b16 v[0:1], v2, off
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %v = call i16 @llvm.amdgcn.permlane64.i16(i16 %src0)
  store i16 %v, ptr addrspace(1) %out
  ret void
}

define void @test_v2f16(ptr addrspace(1) %out, <2 x half> %src0) {
; GFX11-SDAG-LABEL: test_v2f16:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v2, v2
; GFX11-SDAG-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_v2f16:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_permlane64_b32 v2, v2
; GFX11-GISEL-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %v = call <2 x half> @llvm.amdgcn.permlane64.v2f16(<2 x half> %src0)
  store <2 x half> %v, ptr addrspace(1) %out
  ret void
}

define void @test_v2f32(ptr addrspace(1) %out, <2 x float> %src0) {
; GFX11-SDAG-LABEL: test_v2f32:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v3, v3
; GFX11-SDAG-NEXT:    v_permlane64_b32 v2, v2
; GFX11-SDAG-NEXT:    global_store_b64 v[0:1], v[2:3], off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_v2f32:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_permlane64_b32 v2, v2
; GFX11-GISEL-NEXT:    v_permlane64_b32 v3, v3
; GFX11-GISEL-NEXT:    global_store_b64 v[0:1], v[2:3], off
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %v = call <2 x float> @llvm.amdgcn.permlane64.v2f32(<2 x float> %src0)
  store <2 x float> %v, ptr addrspace(1) %out
  ret void
}

define void @test_v7i32(ptr addrspace(1) %out, <7 x i32> %src0) {
; GFX11-SDAG-LABEL: test_v7i32:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v8, v8
; GFX11-SDAG-NEXT:    v_permlane64_b32 v7, v7
; GFX11-SDAG-NEXT:    v_permlane64_b32 v6, v6
; GFX11-SDAG-NEXT:    v_permlane64_b32 v5, v5
; GFX11-SDAG-NEXT:    v_permlane64_b32 v4, v4
; GFX11-SDAG-NEXT:    v_permlane64_b32 v3, v3
; GFX11-SDAG-NEXT:    v_permlane64_b32 v2, v2
; GFX11-SDAG-NEXT:    s_clause 0x1
; GFX11-SDAG-NEXT:    global_store_b96 v[0:1], v[6:8], off offset:16
; GFX11-SDAG-NEXT:    global_store_b128 v[0:1], v[2:5], off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_v7i32:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_permlane64_b32 v2, v2
; GFX11-GISEL-NEXT:    v_permlane64_b32 v3, v3
; GFX11-GISEL-NEXT:    v_permlane64_b32 v4, v4
; GFX11-GISEL-NEXT:    v_permlane64_b32 v5, v5
; GFX11-GISEL-NEXT:    v_permlane64_b32 v6, v6
; GFX11-GISEL-NEXT:    v_permlane64_b32 v7, v7
; GFX11-GISEL-NEXT:    v_permlane64_b32 v8, v8
; GFX11-GISEL-NEXT:    s_clause 0x1
; GFX11-GISEL-NEXT:    global_store_b128 v[0:1], v[2:5], off
; GFX11-GISEL-NEXT:    global_store_b96 v[0:1], v[6:8], off offset:16
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %v = call <7 x i32> @llvm.amdgcn.permlane64.v7i32(<7 x i32> %src0)
  store <7 x i32> %v, ptr addrspace(1) %out
  ret void
}

define void @test_v8i16(ptr addrspace(1) %out, <8 x i16> %src0) {
; GFX11-SDAG-LABEL: test_v8i16:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v5, v5
; GFX11-SDAG-NEXT:    v_permlane64_b32 v4, v4
; GFX11-SDAG-NEXT:    v_permlane64_b32 v3, v3
; GFX11-SDAG-NEXT:    v_permlane64_b32 v2, v2
; GFX11-SDAG-NEXT:    global_store_b128 v[0:1], v[2:5], off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_v8i16:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_permlane64_b32 v2, v2
; GFX11-GISEL-NEXT:    v_permlane64_b32 v3, v3
; GFX11-GISEL-NEXT:    v_permlane64_b32 v4, v4
; GFX11-GISEL-NEXT:    v_permlane64_b32 v5, v5
; GFX11-GISEL-NEXT:    global_store_b128 v[0:1], v[2:5], off
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %v = call <8 x i16> @llvm.amdgcn.permlane64.v8i16(<8 x i16> %src0)
  store <8 x i16> %v, ptr addrspace(1) %out
  ret void
}

define void @test_v2i64(ptr addrspace(1) %out, <2 x i64> %src0) {
; GFX11-SDAG-LABEL: test_v2i64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v5, v5
; GFX11-SDAG-NEXT:    v_permlane64_b32 v4, v4
; GFX11-SDAG-NEXT:    v_permlane64_b32 v3, v3
; GFX11-SDAG-NEXT:    v_permlane64_b32 v2, v2
; GFX11-SDAG-NEXT:    global_store_b128 v[0:1], v[2:5], off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_v2i64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_permlane64_b32 v2, v2
; GFX11-GISEL-NEXT:    v_permlane64_b32 v3, v3
; GFX11-GISEL-NEXT:    v_permlane64_b32 v4, v4
; GFX11-GISEL-NEXT:    v_permlane64_b32 v5, v5
; GFX11-GISEL-NEXT:    global_store_b128 v[0:1], v[2:5], off
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %v = call <2 x i64> @llvm.amdgcn.permlane64.v2i64(<2 x i64> %src0)
  store <2 x i64> %v, ptr addrspace(1) %out
  ret void
}

define void @test_v3i64(ptr addrspace(1) %out, <3 x i64> %src0) {
; GFX11-SDAG-LABEL: test_v3i64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v7, v7
; GFX11-SDAG-NEXT:    v_permlane64_b32 v6, v6
; GFX11-SDAG-NEXT:    v_permlane64_b32 v5, v5
; GFX11-SDAG-NEXT:    v_permlane64_b32 v4, v4
; GFX11-SDAG-NEXT:    v_permlane64_b32 v3, v3
; GFX11-SDAG-NEXT:    v_permlane64_b32 v2, v2
; GFX11-SDAG-NEXT:    s_clause 0x1
; GFX11-SDAG-NEXT:    global_store_b64 v[0:1], v[6:7], off offset:16
; GFX11-SDAG-NEXT:    global_store_b128 v[0:1], v[2:5], off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_v3i64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_permlane64_b32 v2, v2
; GFX11-GISEL-NEXT:    v_permlane64_b32 v3, v3
; GFX11-GISEL-NEXT:    v_permlane64_b32 v4, v4
; GFX11-GISEL-NEXT:    v_permlane64_b32 v5, v5
; GFX11-GISEL-NEXT:    v_permlane64_b32 v6, v6
; GFX11-GISEL-NEXT:    v_permlane64_b32 v7, v7
; GFX11-GISEL-NEXT:    s_clause 0x1
; GFX11-GISEL-NEXT:    global_store_b128 v[0:1], v[2:5], off
; GFX11-GISEL-NEXT:    global_store_b64 v[0:1], v[6:7], off offset:16
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %v = call <3 x i64> @llvm.amdgcn.permlane64.v3i64(<3 x i64> %src0)
  store <3 x i64> %v, ptr addrspace(1) %out
  ret void
}

define void @test_v4f64(ptr addrspace(1) %out, <4 x double> %src0) {
; GFX11-SDAG-LABEL: test_v4f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v9, v9
; GFX11-SDAG-NEXT:    v_permlane64_b32 v8, v8
; GFX11-SDAG-NEXT:    v_permlane64_b32 v7, v7
; GFX11-SDAG-NEXT:    v_permlane64_b32 v6, v6
; GFX11-SDAG-NEXT:    v_permlane64_b32 v5, v5
; GFX11-SDAG-NEXT:    v_permlane64_b32 v4, v4
; GFX11-SDAG-NEXT:    v_permlane64_b32 v3, v3
; GFX11-SDAG-NEXT:    v_permlane64_b32 v2, v2
; GFX11-SDAG-NEXT:    s_clause 0x1
; GFX11-SDAG-NEXT:    global_store_b128 v[0:1], v[6:9], off offset:16
; GFX11-SDAG-NEXT:    global_store_b128 v[0:1], v[2:5], off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_v4f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_permlane64_b32 v2, v2
; GFX11-GISEL-NEXT:    v_permlane64_b32 v3, v3
; GFX11-GISEL-NEXT:    v_permlane64_b32 v4, v4
; GFX11-GISEL-NEXT:    v_permlane64_b32 v5, v5
; GFX11-GISEL-NEXT:    v_permlane64_b32 v6, v6
; GFX11-GISEL-NEXT:    v_permlane64_b32 v7, v7
; GFX11-GISEL-NEXT:    v_permlane64_b32 v8, v8
; GFX11-GISEL-NEXT:    v_permlane64_b32 v9, v9
; GFX11-GISEL-NEXT:    s_clause 0x1
; GFX11-GISEL-NEXT:    global_store_b128 v[0:1], v[2:5], off
; GFX11-GISEL-NEXT:    global_store_b128 v[0:1], v[6:9], off offset:16
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %v = call <4 x double> @llvm.amdgcn.permlane64.v4f64(<4 x double> %src0)
  store <4 x double> %v, ptr addrspace(1) %out
  ret void
}

define void @test_v8f64(ptr addrspace(1) %out, <8 x double> %src0) {
; GFX11-SDAG-LABEL: test_v8f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v17, v17
; GFX11-SDAG-NEXT:    v_permlane64_b32 v16, v16
; GFX11-SDAG-NEXT:    v_permlane64_b32 v15, v15
; GFX11-SDAG-NEXT:    v_permlane64_b32 v14, v14
; GFX11-SDAG-NEXT:    v_permlane64_b32 v13, v13
; GFX11-SDAG-NEXT:    v_permlane64_b32 v12, v12
; GFX11-SDAG-NEXT:    v_permlane64_b32 v11, v11
; GFX11-SDAG-NEXT:    v_permlane64_b32 v10, v10
; GFX11-SDAG-NEXT:    v_permlane64_b32 v9, v9
; GFX11-SDAG-NEXT:    v_permlane64_b32 v8, v8
; GFX11-SDAG-NEXT:    v_permlane64_b32 v7, v7
; GFX11-SDAG-NEXT:    v_permlane64_b32 v6, v6
; GFX11-SDAG-NEXT:    v_permlane64_b32 v5, v5
; GFX11-SDAG-NEXT:    v_permlane64_b32 v4, v4
; GFX11-SDAG-NEXT:    v_permlane64_b32 v3, v3
; GFX11-SDAG-NEXT:    v_permlane64_b32 v2, v2
; GFX11-SDAG-NEXT:    s_clause 0x3
; GFX11-SDAG-NEXT:    global_store_b128 v[0:1], v[14:17], off offset:48
; GFX11-SDAG-NEXT:    global_store_b128 v[0:1], v[10:13], off offset:32
; GFX11-SDAG-NEXT:    global_store_b128 v[0:1], v[6:9], off offset:16
; GFX11-SDAG-NEXT:    global_store_b128 v[0:1], v[2:5], off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_v8f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_permlane64_b32 v2, v2
; GFX11-GISEL-NEXT:    v_permlane64_b32 v3, v3
; GFX11-GISEL-NEXT:    v_permlane64_b32 v4, v4
; GFX11-GISEL-NEXT:    v_permlane64_b32 v5, v5
; GFX11-GISEL-NEXT:    v_permlane64_b32 v6, v6
; GFX11-GISEL-NEXT:    v_permlane64_b32 v7, v7
; GFX11-GISEL-NEXT:    v_permlane64_b32 v8, v8
; GFX11-GISEL-NEXT:    v_permlane64_b32 v9, v9
; GFX11-GISEL-NEXT:    v_permlane64_b32 v10, v10
; GFX11-GISEL-NEXT:    v_permlane64_b32 v11, v11
; GFX11-GISEL-NEXT:    v_permlane64_b32 v12, v12
; GFX11-GISEL-NEXT:    v_permlane64_b32 v13, v13
; GFX11-GISEL-NEXT:    v_permlane64_b32 v14, v14
; GFX11-GISEL-NEXT:    v_permlane64_b32 v15, v15
; GFX11-GISEL-NEXT:    v_permlane64_b32 v16, v16
; GFX11-GISEL-NEXT:    v_permlane64_b32 v17, v17
; GFX11-GISEL-NEXT:    s_clause 0x3
; GFX11-GISEL-NEXT:    global_store_b128 v[0:1], v[2:5], off
; GFX11-GISEL-NEXT:    global_store_b128 v[0:1], v[6:9], off offset:16
; GFX11-GISEL-NEXT:    global_store_b128 v[0:1], v[10:13], off offset:32
; GFX11-GISEL-NEXT:    global_store_b128 v[0:1], v[14:17], off offset:48
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %v = call <8 x double> @llvm.amdgcn.permlane64.v8f64(<8 x double> %src0)
  store <8 x double> %v, ptr addrspace(1) %out
  ret void
}
