import { getElementFromPointWithoutHoneypot } from '@atlaskit/pragmatic-drag-and-drop/private/get-element-from-point-without-honey-pot';
import { getClosestScrollableElement } from './get-closest-scrollable-element';
import { getScrollable } from './get-scrollable';
import getScrollableScrollChange from './get-scrollable-scroll-change';
import getWindowScrollChange from './get-window-scroll-change';
import getViewport from './window/get-viewport';
export var scroll = function scroll(_ref) {
  var input = _ref.input,
    dragStartTime = _ref.dragStartTime,
    shouldUseTimeDampening = _ref.shouldUseTimeDampening,
    scrollElement = _ref.scrollElement,
    scrollWindow = _ref.scrollWindow,
    behavior = _ref.behavior;
  var tryScrollWindow = function tryScrollWindow() {
    var viewport = getViewport();
    var windowScrollChange = getWindowScrollChange({
      dragStartTime: dragStartTime,
      viewport: viewport,
      center: {
        x: input.clientX + viewport.scroll.current.x,
        y: input.clientY + viewport.scroll.current.y
      },
      shouldUseTimeDampening: shouldUseTimeDampening
    });
    if (windowScrollChange) {
      scrollWindow(windowScrollChange);
      return true;
    }
    return false;
  };
  var tryScrollContainer = function tryScrollContainer() {
    var over = getElementFromPointWithoutHoneypot({
      x: input.clientX,
      y: input.clientY
    });
    var closestScrollable = getClosestScrollableElement(over);
    if (!closestScrollable) {
      return false;
    }
    var scrollable = getScrollable({
      closestScrollable: closestScrollable
    });
    var scrollableScrollChange = getScrollableScrollChange({
      dragStartTime: dragStartTime,
      scrollable: scrollable,
      center: {
        x: input.clientX,
        y: input.clientY
      },
      shouldUseTimeDampening: shouldUseTimeDampening
    });
    if (scrollableScrollChange) {
      scrollElement(closestScrollable, scrollableScrollChange);
      return true;
    }
    return false;
  };
  if (behavior === 'container-only') {
    tryScrollContainer();
  }
  if (behavior === 'window-only') {
    tryScrollWindow();
  }
  if (behavior === 'container-then-window') {
    tryScrollContainer() || tryScrollWindow();
  }
  if (behavior === 'window-then-container') {
    tryScrollWindow() || tryScrollContainer();
  }
};